/* gnome-db-grid.h
 *
 * Copyright (C) 2002 - 2005 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef __GNOME_DB_GRID__
#define __GNOME_DB_GRID__

#include <gtk/gtk.h>
#include <libgda/gda-data-model.h>
#include "gnome-db-dict.h"
#include "gnome-db-enums.h"

G_BEGIN_DECLS

#define GNOME_DB_GRID_TYPE          (gnome_db_grid_get_type())
#define GNOME_DB_GRID(obj)          G_TYPE_CHECK_INSTANCE_CAST (obj, gnome_db_grid_get_type(), GnomeDbGrid)
#define GNOME_DB_GRID_CLASS(klass)  G_TYPE_CHECK_CLASS_CAST (klass, gnome_db_grid_get_type (), GnomeDbGridClass)
#define IS_GNOME_DB_GRID(obj)       G_TYPE_CHECK_INSTANCE_TYPE (obj, gnome_db_grid_get_type ())


typedef struct _GnomeDbGrid      GnomeDbGrid;
typedef struct _GnomeDbGridClass GnomeDbGridClass;
typedef struct _GnomeDbGridPriv  GnomeDbGridPriv;
typedef void (* GnomeDbGridForeachFunc) (GnomeDbGrid *grid, gint row, gpointer user_data);

/* struct for the object's data */
struct _GnomeDbGrid
{
	GtkVBox             object;

	GnomeDbGridPriv     *priv;
};

/* struct for the object's class */
struct _GnomeDbGridClass
{
	GtkVBoxClass       parent_class;

	void             (* selection_changed) (GnomeDbGrid *grid, gboolean row_selected);
	void             (* double_clicked)    (GnomeDbGrid *grid, gint row);
        void             (* create_popup_menu) (GnomeDbGrid *grid, GtkWidget *menu);
};

/* 
 * Generic widget's methods 
 */
guint             gnome_db_grid_get_type                  (void);

GtkWidget        *gnome_db_grid_new                       (void);
GtkWidget        *gnome_db_grid_new_with_gda_model        (GnomeDbDict *dict, GdaDataModel *model);
GtkWidget        *gnome_db_grid_new_with_select_query     (GnomeDbQuery *query, GnomeDbTarget *modified);

void              gnome_db_grid_set_sample_size           (GnomeDbGrid *grid, gint sample_size);
void              gnome_db_grid_set_sample_start          (GnomeDbGrid *grid, gint sample_start);

GList            *gnome_db_grid_get_selection             (GnomeDbGrid *grid);
void              gnome_db_grid_foreach_selected          (GnomeDbGrid *grid,
							   GnomeDbGridForeachFunc foreach_func, gpointer user_data);
void              gnome_db_grid_select_all                (GnomeDbGrid *grid);
void              gnome_db_grid_unselect_all              (GnomeDbGrid *grid);

void              gnome_db_grid_set_column_title          (GnomeDbGrid *grid, gint col, const gchar *title);
const gchar      *gnome_db_grid_get_column_title          (GnomeDbGrid *grid, gint col);
void              gnome_db_grid_set_title_icon_from_file  (GnomeDbGrid *grid, const gchar *file);
void              gnome_db_grid_set_title_icon_from_stock (GnomeDbGrid *grid, const gchar *stock_id, GtkIconSize size);
void              gnome_db_grid_set_show_title_icon       (GnomeDbGrid *grid, gboolean show);
gboolean          gnome_db_grid_get_show_title_icon       (GnomeDbGrid *grid);

/* FIXME: put into the GnomeDbDataWidget interface */
void              gnome_db_grid_set_gda_model             (GnomeDbGrid *grid, GnomeDbDict *dict, GdaDataModel *model);
GdaDataModel     *gnome_db_grid_get_gda_model             (GnomeDbGrid *grid);
void              gnome_db_grid_set_model                 (GnomeDbGrid *grid, GnomeDbDataModel *model);

void              gnome_db_grid_set_title                 (GnomeDbGrid *grid, const gchar *title);
void              gnome_db_grid_set_show_title            (GnomeDbGrid *grid, gboolean show);

G_END_DECLS

#endif



