/* structure_model.c generated by valac 0.12.1, the Vala compiler
 * generated from structure_model.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2011 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gee.h>


#define TYPE_STRUCT_DATA (struct_data_get_type ())

#define TYPE_STRUCT_TYPE (struct_type_get_type ())
typedef struct _StructData StructData;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_STRUCT_COLUMN (struct_column_get_type ())

#define TYPE_STRUCT_LIST_COLUMN (struct_list_column_get_type ())

#define TYPE_STRUCTURE_MODEL (structure_model_get_type ())
#define STRUCTURE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STRUCTURE_MODEL, StructureModel))
#define STRUCTURE_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STRUCTURE_MODEL, StructureModelClass))
#define IS_STRUCTURE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STRUCTURE_MODEL))
#define IS_STRUCTURE_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STRUCTURE_MODEL))
#define STRUCTURE_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STRUCTURE_MODEL, StructureModelClass))

typedef struct _StructureModel StructureModel;
typedef struct _StructureModelClass StructureModelClass;
typedef struct _StructureModelPrivate StructureModelPrivate;
#define __g_node_destroy__struct_data_free0_0(var) ((var == NULL) ? NULL : (var = (_g_node_destroy__struct_data_free0_ (var), NULL)))
#define _gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL)))

typedef enum  {
	STRUCT_TYPE_PART,
	STRUCT_TYPE_CHAPTER,
	STRUCT_TYPE_SECTION,
	STRUCT_TYPE_SUBSECTION,
	STRUCT_TYPE_SUBSUBSECTION,
	STRUCT_TYPE_PARAGRAPH,
	STRUCT_TYPE_SUBPARAGRAPH,
	STRUCT_TYPE_LABEL,
	STRUCT_TYPE_INCLUDE,
	STRUCT_TYPE_IMAGE,
	STRUCT_TYPE_TODO,
	STRUCT_TYPE_FIXME,
	STRUCT_TYPE_NB_COMMON_TYPES,
	STRUCT_TYPE_TABLE,
	STRUCT_TYPE_FIGURE,
	STRUCT_TYPE_NB_TYPES
} StructType;

struct _StructData {
	StructType type;
	gchar* text;
	GtkTextMark* start_mark;
	GtkTextMark* end_mark;
};

typedef enum  {
	STRUCT_COLUMN_PIXBUF,
	STRUCT_COLUMN_TEXT,
	STRUCT_COLUMN_TOOLTIP,
	STRUCT_COLUMN_START_MARK,
	STRUCT_COLUMN_END_MARK,
	STRUCT_COLUMN_TYPE,
	STRUCT_COLUMN_N_COLUMNS
} StructColumn;

typedef enum  {
	STRUCT_LIST_COLUMN_PIXBUF,
	STRUCT_LIST_COLUMN_TEXT,
	STRUCT_LIST_COLUMN_TOOLTIP,
	STRUCT_LIST_COLUMN_N_COLUMNS
} StructListColumn;

typedef enum  {
	STRUCT_ERROR_GENERAL,
	STRUCT_ERROR_DATA_OUTDATED
} StructError;
#define STRUCT_ERROR struct_error_quark ()
struct _StructureModel {
	GObject parent_instance;
	StructureModelPrivate * priv;
};

struct _StructureModelClass {
	GObjectClass parent_class;
};

struct _StructureModelPrivate {
	gboolean _emit_signals;
	GType* _column_types;
	gint _column_types_length1;
	gint __column_types_size_;
	GNode* _tree;
	gint _stamp;
	guint _nb_nodes;
	GNode* _end_node;
	GeeArrayList* _list_labels;
	GeeArrayList* _list_includes;
	GeeArrayList* _list_tables;
	GeeArrayList* _list_figures;
	GeeArrayList* _list_todos_and_fixmes;
};


static gpointer structure_model_parent_class = NULL;
static GtkTreeModelIface* structure_model_gtk_tree_model_parent_iface = NULL;

GType struct_data_get_type (void) G_GNUC_CONST;
GType struct_type_get_type (void) G_GNUC_CONST;
StructData* struct_data_dup (const StructData* self);
void struct_data_free (StructData* self);
void struct_data_copy (const StructData* self, StructData* dest);
void struct_data_destroy (StructData* self);
GType struct_column_get_type (void) G_GNUC_CONST;
GType struct_list_column_get_type (void) G_GNUC_CONST;
GQuark struct_error_quark (void);
GType structure_model_get_type (void) G_GNUC_CONST;
#define STRUCTURE_MODEL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_STRUCTURE_MODEL, StructureModelPrivate))
enum  {
	STRUCTURE_MODEL_DUMMY_PROPERTY,
	STRUCTURE_MODEL_EMIT_SIGNALS
};
static void _struct_data_free0_ (gpointer var);
static void _g_node_destroy__struct_data_free0_ (GNode* self);
static void _g_node_destroy__struct_data_free0_ (GNode* self);
StructureModel* structure_model_new (void);
StructureModel* structure_model_construct (GType object_type);
static void structure_model_new_stamp (StructureModel* self);
static void structure_model_reset_simple_lists (StructureModel* self);
static GtkTreeIter* structure_model_create_iter_at_node (StructureModel* self, GNode* node);
static GtkTreeIter* _gtk_tree_iter_dup (GtkTreeIter* self);
static gboolean structure_model_iter_is_valid (StructureModel* self, GtkTreeIter* iter);
static GNode* structure_model_get_node_from_iter (StructureModel* self, GtkTreeIter* iter);
static gboolean structure_model_column_is_valid (StructureModel* self, gint index);
static GType structure_model_real_get_column_type (GtkTreeModel* base, gint index);
static gint structure_model_real_get_n_columns (GtkTreeModel* base);
static GtkTreeModelFlags structure_model_real_get_flags (GtkTreeModel* base);
static gboolean structure_model_real_iter_has_child (GtkTreeModel* base, GtkTreeIter* iter);
static gint structure_model_real_iter_n_children (GtkTreeModel* base, GtkTreeIter* iter);
static void structure_model_real_get_value (GtkTreeModel* base, GtkTreeIter* iter, gint column, GValue* val);
gchar* structure_get_icon_from_type (StructType type);
gchar* structure_get_type_name (StructType type);
static gboolean structure_model_real_iter_children (GtkTreeModel* base, GtkTreeIter* iter, GtkTreeIter* parent);
static gboolean structure_model_real_iter_next (GtkTreeModel* base, GtkTreeIter* iter);
static gboolean structure_model_real_iter_nth_child (GtkTreeModel* base, GtkTreeIter* iter, GtkTreeIter* parent, gint n);
static gboolean structure_model_real_iter_parent (GtkTreeModel* base, GtkTreeIter* iter, GtkTreeIter* child);
static gboolean structure_model_real_get_iter (GtkTreeModel* base, GtkTreeIter* iter, GtkTreePath* path);
static GtkTreePath* structure_model_real_get_path (GtkTreeModel* base, GtkTreeIter* iter);
static void structure_model_real_ref_node (GtkTreeModel* base, GtkTreeIter* iter);
static void structure_model_real_unref_node (GtkTreeModel* base, GtkTreeIter* iter);
guint structure_model_get_nb_items (StructureModel* self);
GtkTreeIter* structure_model_add_item_at_end (StructureModel* self, StructData* item);
static void structure_model_search_end_node (StructureModel* self);
gboolean structure_is_section (StructType type);
static GtkTreeIter* structure_model_insert_item_after (StructureModel* self, GNode* parent, GNode* sibling, StructData* item);
GtkTreeIter* structure_model_get_next_sibling_or_parent (StructureModel* self, GtkTreeIter* section_iter, GError** error);
void structure_model_delete (StructureModel* self, GtkTreeIter* iter);
static GNode* structure_model_delete_node (StructureModel* self, GNode* node);
static void structure_model_regenerate_simple_lists (StructureModel* self);
void structure_model_modify_data (StructureModel* self, GtkTreePath* path, const gchar* text, GtkTextMark* end_mark);
gboolean structure_model_get_emit_signals (StructureModel* self);
static void structure_model_make_children_between_marks (StructureModel* self, GNode* node);
void structure_model_shift_right (StructureModel* self, GtkTreeIter* iter);
static void structure_model_shift_node (StructureModel* self, GNode* node, gboolean shift_right);
static void structure_model_reinsert_node (StructureModel* self, GNode* node, gboolean force_first_child);
void structure_model_shift_left (StructureModel* self, GtkTreeIter* iter);
gboolean structure_model_item_contains_subparagraph (StructureModel* self, GtkTreeIter* iter);
static gboolean structure_model_node_contains_subparagraph (StructureModel* self, GNode* node);
static void structure_model_insert_node (StructureModel* self, GNode* node, gboolean force_first_child);
static void structure_model_insert_node_in_list (StructureModel* self, GNode* node);
static gint structure_model_compare_nodes (GtkTextMark* mark1, GtkTextMark* mark2);
void structure_model_populate_list (StructureModel* self, GtkListStore* store, StructType type);
static GeeArrayList* structure_model_get_list (StructureModel* self, StructType type);
GtkTreePath* structure_model_get_tree_path_from_list_num (StructureModel* self, StructType list_type, gint num);
gint structure_model_get_list_num_from_tree_iter (StructureModel* self, GtkTreeIter* tree_iter);
static gboolean _lambda18_ (GNode* node_param, StructureModel* self);
static gboolean __lambda18__gnode_traverse_func (GNode* node, gpointer self);
void structure_model_set_emit_signals (StructureModel* self, gboolean value);
static void structure_model_finalize (GObject* obj);
static void _vala_structure_model_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_structure_model_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void struct_data_copy (const StructData* self, StructData* dest) {
	dest->type = self->type;
	dest->text = g_strdup (self->text);
	dest->start_mark = _g_object_ref0 (self->start_mark);
	dest->end_mark = _g_object_ref0 (self->end_mark);
}


void struct_data_destroy (StructData* self) {
	_g_free0 ((*self).text);
	_g_object_unref0 ((*self).start_mark);
	_g_object_unref0 ((*self).end_mark);
}


StructData* struct_data_dup (const StructData* self) {
	StructData* dup;
	dup = g_new0 (StructData, 1);
	struct_data_copy (self, dup);
	return dup;
}


void struct_data_free (StructData* self) {
	struct_data_destroy (self);
	g_free (self);
}


GType struct_data_get_type (void) {
	static volatile gsize struct_data_type_id__volatile = 0;
	if (g_once_init_enter (&struct_data_type_id__volatile)) {
		GType struct_data_type_id;
		struct_data_type_id = g_boxed_type_register_static ("StructData", (GBoxedCopyFunc) struct_data_dup, (GBoxedFreeFunc) struct_data_free);
		g_once_init_leave (&struct_data_type_id__volatile, struct_data_type_id);
	}
	return struct_data_type_id__volatile;
}


GType struct_column_get_type (void) {
	static volatile gsize struct_column_type_id__volatile = 0;
	if (g_once_init_enter (&struct_column_type_id__volatile)) {
		static const GEnumValue values[] = {{STRUCT_COLUMN_PIXBUF, "STRUCT_COLUMN_PIXBUF", "pixbuf"}, {STRUCT_COLUMN_TEXT, "STRUCT_COLUMN_TEXT", "text"}, {STRUCT_COLUMN_TOOLTIP, "STRUCT_COLUMN_TOOLTIP", "tooltip"}, {STRUCT_COLUMN_START_MARK, "STRUCT_COLUMN_START_MARK", "start-mark"}, {STRUCT_COLUMN_END_MARK, "STRUCT_COLUMN_END_MARK", "end-mark"}, {STRUCT_COLUMN_TYPE, "STRUCT_COLUMN_TYPE", "type"}, {STRUCT_COLUMN_N_COLUMNS, "STRUCT_COLUMN_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
		GType struct_column_type_id;
		struct_column_type_id = g_enum_register_static ("StructColumn", values);
		g_once_init_leave (&struct_column_type_id__volatile, struct_column_type_id);
	}
	return struct_column_type_id__volatile;
}


GType struct_list_column_get_type (void) {
	static volatile gsize struct_list_column_type_id__volatile = 0;
	if (g_once_init_enter (&struct_list_column_type_id__volatile)) {
		static const GEnumValue values[] = {{STRUCT_LIST_COLUMN_PIXBUF, "STRUCT_LIST_COLUMN_PIXBUF", "pixbuf"}, {STRUCT_LIST_COLUMN_TEXT, "STRUCT_LIST_COLUMN_TEXT", "text"}, {STRUCT_LIST_COLUMN_TOOLTIP, "STRUCT_LIST_COLUMN_TOOLTIP", "tooltip"}, {STRUCT_LIST_COLUMN_N_COLUMNS, "STRUCT_LIST_COLUMN_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
		GType struct_list_column_type_id;
		struct_list_column_type_id = g_enum_register_static ("StructListColumn", values);
		g_once_init_leave (&struct_list_column_type_id__volatile, struct_list_column_type_id);
	}
	return struct_list_column_type_id__volatile;
}


GQuark struct_error_quark (void) {
	return g_quark_from_static_string ("struct_error-quark");
}


static void _struct_data_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (struct_data_free (var), NULL));
}


static gboolean _g_node_destroy__struct_data_free0__node (GNode* node, gpointer unused) {
	_struct_data_free0_ (node->data);
	return FALSE;
}


static void _g_node_destroy__struct_data_free0_ (GNode* self) {
	g_node_traverse (self, G_POST_ORDER, G_TRAVERSE_ALL, -1, _g_node_destroy__struct_data_free0__node, NULL);
	g_node_destroy (self);
}


static gpointer _struct_data_dup0 (gpointer self) {
	return self ? struct_data_dup (self) : NULL;
}


StructureModel* structure_model_construct (GType object_type) {
	StructureModel * self = NULL;
	GType* _tmp0_ = NULL;
	StructData _tmp1_ = {0};
	StructData empty_data;
	StructData* _tmp2_;
	GNode* _tmp3_ = NULL;
	self = (StructureModel*) g_object_new (object_type, NULL);
	_tmp0_ = g_new0 (GType, STRUCT_COLUMN_N_COLUMNS);
	self->priv->_column_types = (g_free (self->priv->_column_types), NULL);
	self->priv->_column_types = _tmp0_;
	self->priv->_column_types_length1 = STRUCT_COLUMN_N_COLUMNS;
	self->priv->__column_types_size_ = STRUCT_COLUMN_N_COLUMNS;
	self->priv->_column_types[STRUCT_COLUMN_PIXBUF] = G_TYPE_STRING;
	self->priv->_column_types[STRUCT_COLUMN_TEXT] = G_TYPE_STRING;
	self->priv->_column_types[STRUCT_COLUMN_TOOLTIP] = G_TYPE_STRING;
	self->priv->_column_types[STRUCT_COLUMN_START_MARK] = GTK_TYPE_TEXT_MARK;
	self->priv->_column_types[STRUCT_COLUMN_END_MARK] = GTK_TYPE_TEXT_MARK;
	self->priv->_column_types[STRUCT_COLUMN_TYPE] = TYPE_STRUCT_TYPE;
	empty_data = _tmp1_;
	_tmp2_ = _struct_data_dup0 (&empty_data);
	_tmp3_ = g_node_new (_tmp2_);
	__g_node_destroy__struct_data_free0_0 (self->priv->_tree);
	self->priv->_tree = _tmp3_;
	structure_model_new_stamp (self);
	structure_model_reset_simple_lists (self);
	struct_data_destroy (&empty_data);
	return self;
}


StructureModel* structure_model_new (void) {
	return structure_model_construct (TYPE_STRUCTURE_MODEL);
}


static void structure_model_new_stamp (StructureModel* self) {
	guint32 _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_random_int ();
	self->priv->_stamp = (gint) _tmp0_;
}


static GtkTreeIter* _gtk_tree_iter_dup (GtkTreeIter* self) {
	GtkTreeIter* dup;
	dup = g_new0 (GtkTreeIter, 1);
	memcpy (dup, self, sizeof (GtkTreeIter));
	return dup;
}


static gpointer __gtk_tree_iter_dup0 (gpointer self) {
	return self ? _gtk_tree_iter_dup (self) : NULL;
}


static GtkTreeIter* structure_model_create_iter_at_node (StructureModel* self, GNode* node) {
	GtkTreeIter* result = NULL;
	GtkTreeIter new_iter = {0};
	GtkTreeIter* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (node != NULL, NULL);
	g_return_val_if_fail (node != self->priv->_tree, NULL);
	memset (&new_iter, 0, sizeof (GtkTreeIter));
	new_iter.stamp = self->priv->_stamp;
	new_iter.user_data = node;
	_tmp0_ = __gtk_tree_iter_dup0 (&new_iter);
	result = _tmp0_;
	return result;
}


static gboolean structure_model_iter_is_valid (StructureModel* self, GtkTreeIter* iter) {
	gboolean result = FALSE;
	GNode* _tmp0_ = NULL;
	GNode* node;
	StructData _tmp1_;
	StructData _tmp2_ = {0};
	StructData data;
	g_return_val_if_fail (self != NULL, FALSE);
	if ((*iter).stamp != self->priv->_stamp) {
		result = FALSE;
		return result;
	}
	if ((*iter).user_data == NULL) {
		result = FALSE;
		return result;
	}
	_tmp0_ = structure_model_get_node_from_iter (self, iter);
	node = _tmp0_;
	if (((StructData*) node->data) == NULL) {
		result = FALSE;
		return result;
	}
	struct_data_copy ((StructData*) node->data, &_tmp2_);
	_tmp1_ = _tmp2_;
	data = _tmp1_;
	if (data.text == NULL) {
		result = FALSE;
		struct_data_destroy (&data);
		return result;
	}
	result = TRUE;
	struct_data_destroy (&data);
	return result;
}


static gboolean structure_model_column_is_valid (StructureModel* self, gint index) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (0 <= index) {
		_tmp0_ = index < STRUCT_COLUMN_N_COLUMNS;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static GNode* structure_model_get_node_from_iter (StructureModel* self, GtkTreeIter* iter) {
	GNode* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = (GNode*) (*iter).user_data;
	return result;
}


/*************************************************************************/
static GType structure_model_real_get_column_type (GtkTreeModel* base, gint index) {
	StructureModel * self;
	GType result = 0UL;
	gboolean _tmp0_;
	self = (StructureModel*) base;
	_tmp0_ = structure_model_column_is_valid (self, index);
	g_return_val_if_fail (_tmp0_, G_TYPE_INVALID);
	result = self->priv->_column_types[index];
	return result;
}


static gint structure_model_real_get_n_columns (GtkTreeModel* base) {
	StructureModel * self;
	gint result = 0;
	self = (StructureModel*) base;
	result = (gint) STRUCT_COLUMN_N_COLUMNS;
	return result;
}


static GtkTreeModelFlags structure_model_real_get_flags (GtkTreeModel* base) {
	StructureModel * self;
	GtkTreeModelFlags result = 0;
	self = (StructureModel*) base;
	result = 0;
	return result;
}


static gboolean structure_model_real_iter_has_child (GtkTreeModel* base, GtkTreeIter* iter) {
	StructureModel * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	GNode* _tmp1_ = NULL;
	GNode* node;
	gboolean _tmp2_;
	self = (StructureModel*) base;
	_tmp0_ = structure_model_iter_is_valid (self, iter);
	g_return_val_if_fail (_tmp0_, FALSE);
	_tmp1_ = structure_model_get_node_from_iter (self, iter);
	node = _tmp1_;
	_tmp2_ = G_NODE_IS_LEAF (node);
	result = !_tmp2_;
	return result;
}


static gint structure_model_real_iter_n_children (GtkTreeModel* base, GtkTreeIter* iter) {
	StructureModel * self;
	gint result = 0;
	GNode* node = NULL;
	guint _tmp2_;
	self = (StructureModel*) base;
	if (iter == NULL) {
		node = self->priv->_tree;
	} else {
		gboolean _tmp0_;
		GNode* _tmp1_ = NULL;
		_tmp0_ = structure_model_iter_is_valid (self, iter);
		g_return_val_if_fail (_tmp0_, -1);
		_tmp1_ = structure_model_get_node_from_iter (self, iter);
		node = _tmp1_;
	}
	_tmp2_ = g_node_n_children (node);
	result = (gint) _tmp2_;
	return result;
}


static void structure_model_real_get_value (GtkTreeModel* base, GtkTreeIter* iter, gint column, GValue* val) {
	StructureModel * self;
	GValue _val = {0};
	gboolean _tmp0_;
	gboolean _tmp1_;
	GNode* _tmp2_ = NULL;
	GNode* node;
	StructData _tmp3_;
	StructData _tmp4_ = {0};
	StructData data;
	self = (StructureModel*) base;
	_tmp0_ = structure_model_iter_is_valid (self, iter);
	g_return_if_fail (_tmp0_);
	_tmp1_ = structure_model_column_is_valid (self, column);
	g_return_if_fail (_tmp1_);
	_tmp2_ = structure_model_get_node_from_iter (self, iter);
	node = _tmp2_;
	struct_data_copy ((StructData*) node->data, &_tmp4_);
	_tmp3_ = _tmp4_;
	data = _tmp3_;
	switch (column) {
		case STRUCT_COLUMN_TEXT:
		{
			GValue _tmp5_ = {0};
			g_value_init (&_tmp5_, G_TYPE_STRING);
			g_value_set_string (&_tmp5_, data.text);
			G_IS_VALUE (&_val) ? (g_value_unset (&_val), NULL) : NULL;
			_val = _tmp5_;
			break;
		}
		case STRUCT_COLUMN_START_MARK:
		{
			GValue _tmp6_ = {0};
			g_value_init (&_tmp6_, GTK_TYPE_TEXT_MARK);
			g_value_set_object (&_tmp6_, data.start_mark);
			G_IS_VALUE (&_val) ? (g_value_unset (&_val), NULL) : NULL;
			_val = _tmp6_;
			break;
		}
		case STRUCT_COLUMN_END_MARK:
		{
			GValue _tmp7_ = {0};
			g_value_init (&_tmp7_, GTK_TYPE_TEXT_MARK);
			g_value_set_object (&_tmp7_, data.end_mark);
			G_IS_VALUE (&_val) ? (g_value_unset (&_val), NULL) : NULL;
			_val = _tmp7_;
			break;
		}
		case STRUCT_COLUMN_TYPE:
		{
			GValue _tmp8_ = {0};
			g_value_init (&_tmp8_, TYPE_STRUCT_TYPE);
			g_value_set_enum (&_tmp8_, data.type);
			G_IS_VALUE (&_val) ? (g_value_unset (&_val), NULL) : NULL;
			_val = _tmp8_;
			break;
		}
		case STRUCT_COLUMN_PIXBUF:
		{
			gchar* _tmp9_ = NULL;
			GValue _tmp10_ = {0};
			_tmp9_ = structure_get_icon_from_type (data.type);
			g_value_init (&_tmp10_, G_TYPE_STRING);
			g_value_take_string (&_tmp10_, _tmp9_);
			G_IS_VALUE (&_val) ? (g_value_unset (&_val), NULL) : NULL;
			_val = _tmp10_;
			break;
		}
		case STRUCT_COLUMN_TOOLTIP:
		{
			gchar* _tmp11_ = NULL;
			GValue _tmp12_ = {0};
			_tmp11_ = structure_get_type_name (data.type);
			g_value_init (&_tmp12_, G_TYPE_STRING);
			g_value_take_string (&_tmp12_, _tmp11_);
			G_IS_VALUE (&_val) ? (g_value_unset (&_val), NULL) : NULL;
			_val = _tmp12_;
			break;
		}
		default:
		{
			g_return_if_reached ();
		}
	}
	struct_data_destroy (&data);
	if (val) {
		*val = _val;
	} else {
		G_IS_VALUE (&_val) ? (g_value_unset (&_val), NULL) : NULL;
	}
}


static gboolean structure_model_real_iter_children (GtkTreeModel* base, GtkTreeIter* iter, GtkTreeIter* parent) {
	StructureModel * self;
	GtkTreeIter _iter = {0};
	gboolean result = FALSE;
	GNode* node = NULL;
	gboolean _tmp2_;
	GNode* _tmp3_ = NULL;
	GtkTreeIter* _tmp4_ = NULL;
	GtkTreeIter* _tmp5_;
	self = (StructureModel*) base;
	if (parent == NULL) {
		node = self->priv->_tree;
	} else {
		gboolean _tmp0_;
		GNode* _tmp1_ = NULL;
		_tmp0_ = structure_model_iter_is_valid (self, parent);
		g_return_val_if_fail (_tmp0_, FALSE);
		_tmp1_ = structure_model_get_node_from_iter (self, parent);
		node = _tmp1_;
	}
	_tmp2_ = G_NODE_IS_LEAF (node);
	if (_tmp2_) {
		result = FALSE;
		if (iter) {
			*iter = _iter;
		}
		return result;
	}
	_tmp3_ = g_node_first_child (node);
	_tmp4_ = structure_model_create_iter_at_node (self, _tmp3_);
	_tmp5_ = _tmp4_;
	_iter = *_tmp5_;
	_g_free0 (_tmp5_);
	result = TRUE;
	if (iter) {
		*iter = _iter;
	}
	return result;
}


static gboolean structure_model_real_iter_next (GtkTreeModel* base, GtkTreeIter* iter) {
	StructureModel * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	GNode* _tmp1_ = NULL;
	GNode* node;
	GNode* _tmp2_ = NULL;
	GNode* next_node;
	GtkTreeIter* _tmp3_ = NULL;
	GtkTreeIter* _tmp4_;
	self = (StructureModel*) base;
	_tmp0_ = structure_model_iter_is_valid (self, iter);
	g_return_val_if_fail (_tmp0_, FALSE);
	_tmp1_ = structure_model_get_node_from_iter (self, iter);
	node = _tmp1_;
	_tmp2_ = g_node_next_sibling (node);
	next_node = _tmp2_;
	if (next_node == NULL) {
		result = FALSE;
		return result;
	}
	_tmp3_ = structure_model_create_iter_at_node (self, next_node);
	_tmp4_ = _tmp3_;
	*iter = *_tmp4_;
	_g_free0 (_tmp4_);
	result = TRUE;
	return result;
}


static gboolean structure_model_real_iter_nth_child (GtkTreeModel* base, GtkTreeIter* iter, GtkTreeIter* parent, gint n) {
	StructureModel * self;
	GtkTreeIter _iter = {0};
	gboolean result = FALSE;
	GNode* node = NULL;
	gboolean _tmp2_;
	gboolean _tmp3_ = FALSE;
	GNode* _tmp5_ = NULL;
	GtkTreeIter* _tmp6_ = NULL;
	GtkTreeIter* _tmp7_;
	self = (StructureModel*) base;
	if (parent == NULL) {
		node = self->priv->_tree;
	} else {
		gboolean _tmp0_;
		GNode* _tmp1_ = NULL;
		_tmp0_ = structure_model_iter_is_valid (self, parent);
		g_return_val_if_fail (_tmp0_, FALSE);
		_tmp1_ = structure_model_get_node_from_iter (self, parent);
		node = _tmp1_;
	}
	_tmp2_ = G_NODE_IS_LEAF (node);
	if (_tmp2_) {
		result = FALSE;
		if (iter) {
			*iter = _iter;
		}
		return result;
	}
	if (n < 0) {
		_tmp3_ = TRUE;
	} else {
		guint _tmp4_;
		_tmp4_ = g_node_n_children (node);
		_tmp3_ = _tmp4_ <= n;
	}
	if (_tmp3_) {
		result = FALSE;
		if (iter) {
			*iter = _iter;
		}
		return result;
	}
	_tmp5_ = g_node_nth_child (node, (guint) n);
	_tmp6_ = structure_model_create_iter_at_node (self, _tmp5_);
	_tmp7_ = _tmp6_;
	_iter = *_tmp7_;
	_g_free0 (_tmp7_);
	result = TRUE;
	if (iter) {
		*iter = _iter;
	}
	return result;
}


static gboolean structure_model_real_iter_parent (GtkTreeModel* base, GtkTreeIter* iter, GtkTreeIter* child) {
	StructureModel * self;
	GtkTreeIter _iter = {0};
	gboolean result = FALSE;
	gboolean _tmp0_;
	GNode* _tmp1_ = NULL;
	GNode* node;
	GNode* parent_node;
	GtkTreeIter* _tmp2_ = NULL;
	GtkTreeIter* _tmp3_;
	self = (StructureModel*) base;
	_tmp0_ = structure_model_iter_is_valid (self, child);
	g_return_val_if_fail (_tmp0_, FALSE);
	_tmp1_ = structure_model_get_node_from_iter (self, child);
	node = _tmp1_;
	parent_node = node->parent;
	g_return_val_if_fail (parent_node != NULL, FALSE);
	if (parent_node == self->priv->_tree) {
		result = FALSE;
		if (iter) {
			*iter = _iter;
		}
		return result;
	}
	_tmp2_ = structure_model_create_iter_at_node (self, parent_node);
	_tmp3_ = _tmp2_;
	_iter = *_tmp3_;
	_g_free0 (_tmp3_);
	result = TRUE;
	if (iter) {
		*iter = _iter;
	}
	return result;
}


static gboolean structure_model_real_get_iter (GtkTreeModel* base, GtkTreeIter* iter, GtkTreePath* path) {
	StructureModel * self;
	GtkTreeIter _iter = {0};
	gboolean result = FALSE;
	gint _tmp0_;
	gint depth;
	gint* _tmp1_ = NULL;
	gint* indices;
	gint indices_length1;
	gint _indices_size_;
	GNode* node;
	GtkTreeIter* _tmp6_ = NULL;
	GtkTreeIter* _tmp7_;
	self = (StructureModel*) base;
	g_return_val_if_fail (path != NULL, FALSE);
	_tmp0_ = gtk_tree_path_get_depth (path);
	depth = _tmp0_;
	g_return_val_if_fail (1 <= depth, FALSE);
	_tmp1_ = gtk_tree_path_get_indices (path);
	indices = _tmp1_;
	indices_length1 = -1;
	_indices_size_ = -1;
	node = self->priv->_tree;
	{
		gint cur_depth;
		cur_depth = 0;
		{
			gboolean _tmp2_;
			_tmp2_ = TRUE;
			while (TRUE) {
				gint indice;
				gboolean _tmp3_ = FALSE;
				GNode* _tmp5_ = NULL;
				if (!_tmp2_) {
					cur_depth++;
				}
				_tmp2_ = FALSE;
				if (!(cur_depth < depth)) {
					break;
				}
				indice = indices[cur_depth];
				if (indice < 0) {
					_tmp3_ = TRUE;
				} else {
					guint _tmp4_;
					_tmp4_ = g_node_n_children (node);
					_tmp3_ = _tmp4_ <= indice;
				}
				if (_tmp3_) {
					result = FALSE;
					if (iter) {
						*iter = _iter;
					}
					return result;
				}
				_tmp5_ = g_node_nth_child (node, (guint) indice);
				node = _tmp5_;
			}
		}
	}
	_tmp6_ = structure_model_create_iter_at_node (self, node);
	_tmp7_ = _tmp6_;
	_iter = *_tmp7_;
	_g_free0 (_tmp7_);
	result = TRUE;
	if (iter) {
		*iter = _iter;
	}
	return result;
}


static GtkTreePath* structure_model_real_get_path (GtkTreeModel* base, GtkTreeIter* iter) {
	StructureModel * self;
	GtkTreePath* result = NULL;
	gboolean _tmp0_;
	GtkTreePath* _tmp1_ = NULL;
	GtkTreePath* path;
	GNode* _tmp2_ = NULL;
	GNode* node;
	self = (StructureModel*) base;
	_tmp0_ = structure_model_iter_is_valid (self, iter);
	g_return_val_if_fail (_tmp0_, NULL);
	_tmp1_ = gtk_tree_path_new ();
	path = _tmp1_;
	_tmp2_ = structure_model_get_node_from_iter (self, iter);
	node = _tmp2_;
	while (TRUE) {
		gboolean _tmp3_;
		gint _tmp4_;
		gint pos;
		_tmp3_ = G_NODE_IS_ROOT (node);
		if (!(!_tmp3_)) {
			break;
		}
		_tmp4_ = g_node_child_position (node->parent, node);
		pos = _tmp4_;
		gtk_tree_path_prepend_index (path, pos);
		node = node->parent;
	}
	result = path;
	return result;
}


static void structure_model_real_ref_node (GtkTreeModel* base, GtkTreeIter* iter) {
	StructureModel * self;
	self = (StructureModel*) base;
}


static void structure_model_real_unref_node (GtkTreeModel* base, GtkTreeIter* iter) {
	StructureModel * self;
	self = (StructureModel*) base;
}


/*************************************************************************/
guint structure_model_get_nb_items (StructureModel* self) {
	guint result = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_nb_nodes;
	return result;
}


GtkTreeIter* structure_model_add_item_at_end (StructureModel* self, StructData* item) {
	GtkTreeIter* result = NULL;
	StructType item_depth;
	GNode* parent;
	GNode* prev_sibling;
	GtkTreeIter* _tmp2_ = NULL;
	GtkTreeIter* end_iter;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->_end_node == NULL) {
		structure_model_search_end_node (self);
	}
	item_depth = (*item).type;
	parent = self->priv->_end_node;
	prev_sibling = NULL;
	while (TRUE) {
		StructType cur_depth;
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_;
		if (parent == self->priv->_tree) {
			break;
		}
		cur_depth = (*((StructData*) parent->data)).type;
		_tmp1_ = structure_is_section (cur_depth);
		if (_tmp1_) {
			_tmp0_ = cur_depth < item_depth;
		} else {
			_tmp0_ = FALSE;
		}
		if (_tmp0_) {
			break;
		}
		prev_sibling = parent;
		parent = parent->parent;
	}
	_tmp2_ = structure_model_insert_item_after (self, parent, prev_sibling, item);
	end_iter = _tmp2_;
	if (end_iter != NULL) {
		GNode* _tmp3_ = NULL;
		_tmp3_ = structure_model_get_node_from_iter (self, end_iter);
		self->priv->_end_node = _tmp3_;
	}
	result = end_iter;
	return result;
}


GtkTreeIter* structure_model_get_next_sibling_or_parent (StructureModel* self, GtkTreeIter* section_iter, GError** error) {
	GtkTreeIter* result = NULL;
	gboolean _tmp0_;
	GNode* _tmp2_ = NULL;
	GNode* cur_node;
	gboolean _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = structure_model_iter_is_valid (self, section_iter);
	if (!_tmp0_) {
		GError* _tmp1_ = NULL;
		_tmp1_ = g_error_new_literal (STRUCT_ERROR, STRUCT_ERROR_GENERAL, "iter is not valid.");
		_inner_error_ = _tmp1_;
		if (_inner_error_->domain == STRUCT_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp2_ = structure_model_get_node_from_iter (self, section_iter);
	cur_node = _tmp2_;
	_tmp3_ = structure_is_section ((*((StructData*) cur_node->data)).type);
	if (!_tmp3_) {
		GError* _tmp4_ = NULL;
		_tmp4_ = g_error_new_literal (STRUCT_ERROR, STRUCT_ERROR_GENERAL, "iter is not a section.");
		_inner_error_ = _tmp4_;
		if (_inner_error_->domain == STRUCT_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	while (TRUE) {
		gboolean _tmp5_ = FALSE;
		GNode* _tmp6_ = NULL;
		GNode* next_sibling_node;
		if (cur_node != NULL) {
			_tmp5_ = cur_node != self->priv->_tree;
		} else {
			_tmp5_ = FALSE;
		}
		if (!_tmp5_) {
			break;
		}
		_tmp6_ = g_node_next_sibling (cur_node);
		next_sibling_node = _tmp6_;
		if (next_sibling_node != NULL) {
			GtkTreeIter* _tmp7_ = NULL;
			_tmp7_ = structure_model_create_iter_at_node (self, next_sibling_node);
			result = _tmp7_;
			return result;
		}
		cur_node = cur_node->parent;
	}
	result = NULL;
	return result;
}


void structure_model_delete (StructureModel* self, GtkTreeIter* iter) {
	gboolean _tmp0_;
	GNode* _tmp1_ = NULL;
	GNode* node;
	GNode* _tmp2_ = NULL;
	GNode* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = structure_model_iter_is_valid (self, iter);
	g_return_if_fail (_tmp0_);
	_tmp1_ = structure_model_get_node_from_iter (self, iter);
	node = _tmp1_;
	_tmp2_ = structure_model_delete_node (self, node);
	_tmp3_ = _tmp2_;
	__g_node_destroy__struct_data_free0_0 (_tmp3_);
	self->priv->_end_node = NULL;
	structure_model_regenerate_simple_lists (self);
}


void structure_model_modify_data (StructureModel* self, GtkTreePath* path, const gchar* text, GtkTextMark* end_mark) {
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp0_ = {0};
	gboolean _tmp1_;
	gboolean iter_is_valid;
	GNode* _tmp2_ = NULL;
	GNode* node;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp6_;
	GtkTextMark* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	g_return_if_fail (end_mark != NULL);
	_tmp1_ = gtk_tree_model_get_iter ((GtkTreeModel*) self, &_tmp0_, path);
	iter = _tmp0_;
	iter_is_valid = _tmp1_;
	g_return_if_fail (iter_is_valid);
	_tmp2_ = structure_model_get_node_from_iter (self, &iter);
	node = _tmp2_;
	structure_model_new_stamp (self);
	_tmp3_ = g_strdup (text);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == NULL) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup ("");
		_g_free0 (_tmp4_);
		_tmp4_ = _tmp5_;
	}
	_tmp6_ = g_strdup (_tmp4_);
	_g_free0 ((*((StructData*) node->data)).text);
	(*((StructData*) node->data)).text = _tmp6_;
	_tmp7_ = _g_object_ref0 (end_mark);
	_g_object_unref0 ((*((StructData*) node->data)).end_mark);
	(*((StructData*) node->data)).end_mark = _tmp7_;
	if (self->priv->_emit_signals) {
		gtk_tree_model_row_changed ((GtkTreeModel*) self, path, &iter);
	}
	structure_model_make_children_between_marks (self, node);
	_g_free0 (_tmp4_);
}


void structure_model_shift_right (StructureModel* self, GtkTreeIter* iter) {
	gboolean _tmp0_;
	GNode* _tmp1_ = NULL;
	GNode* node;
	StructType type;
	StructType new_type;
	GNode* _tmp2_ = NULL;
	GNode* new_parent;
	gint new_pos = 0;
	gboolean _tmp3_ = FALSE;
	GNode* _tmp5_ = NULL;
	GNode* node_unlinked;
	GNode* _tmp6_;
	GNode* _tmp7_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = structure_model_iter_is_valid (self, iter);
	g_return_if_fail (_tmp0_);
	_tmp1_ = structure_model_get_node_from_iter (self, iter);
	node = _tmp1_;
	type = (*((StructData*) node->data)).type;
	g_return_if_fail (type < STRUCT_TYPE_SUBPARAGRAPH);
	new_type = type + 1;
	_tmp2_ = g_node_prev_sibling (node);
	new_parent = _tmp2_;
	if (new_parent == NULL) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = new_type <= (*((StructData*) new_parent->data)).type;
	}
	if (_tmp3_) {
		gint _tmp4_;
		new_parent = node->parent;
		_tmp4_ = g_node_child_position (new_parent, node);
		new_pos = _tmp4_;
	} else {
		new_pos = -1;
	}
	_tmp5_ = structure_model_delete_node (self, node);
	node_unlinked = _tmp5_;
	structure_model_shift_node (self, node_unlinked, TRUE);
	_tmp6_ = node_unlinked;
	node_unlinked = NULL;
	_tmp7_ = g_node_insert (new_parent, new_pos, _tmp6_);
	node = _tmp7_;
	structure_model_reinsert_node (self, node, FALSE);
	__g_node_destroy__struct_data_free0_0 (node_unlinked);
}


void structure_model_shift_left (StructureModel* self, GtkTreeIter* iter) {
	gboolean _tmp0_;
	GNode* _tmp1_ = NULL;
	GNode* node;
	StructType type;
	gboolean _tmp2_ = FALSE;
	StructType new_type;
	GNode* new_parent = NULL;
	gint new_pos = 0;
	GNode* parent;
	gboolean _tmp3_ = FALSE;
	GNode* _tmp6_ = NULL;
	GNode* sibling;
	GNode* _tmp7_ = NULL;
	GNode* node_unlinked;
	GNode* _tmp11_;
	GNode* _tmp12_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = structure_model_iter_is_valid (self, iter);
	g_return_if_fail (_tmp0_);
	_tmp1_ = structure_model_get_node_from_iter (self, iter);
	node = _tmp1_;
	type = (*((StructData*) node->data)).type;
	if (STRUCT_TYPE_PART < type) {
		_tmp2_ = type <= STRUCT_TYPE_SUBPARAGRAPH;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_if_fail (_tmp2_);
	new_type = type - 1;
	parent = node->parent;
	if (parent == self->priv->_tree) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = (*((StructData*) parent->data)).type < new_type;
	}
	if (_tmp3_) {
		gint _tmp4_;
		new_parent = parent;
		_tmp4_ = g_node_child_position (parent, node);
		new_pos = _tmp4_;
	} else {
		gint _tmp5_;
		new_parent = parent->parent;
		_tmp5_ = g_node_child_position (new_parent, parent);
		new_pos = _tmp5_ + 1;
	}
	_tmp6_ = g_node_next_sibling (node);
	sibling = _tmp6_;
	_tmp7_ = structure_model_delete_node (self, node);
	node_unlinked = _tmp7_;
	structure_model_shift_node (self, node_unlinked, FALSE);
	while (TRUE) {
		GNode* _tmp8_ = NULL;
		GNode* next_sibling;
		GNode* _tmp9_ = NULL;
		GNode* new_child;
		GNode* _tmp10_;
		if (!(sibling != NULL)) {
			break;
		}
		if ((*((StructData*) sibling->data)).type <= new_type) {
			break;
		}
		_tmp8_ = g_node_next_sibling (sibling);
		next_sibling = _tmp8_;
		_tmp9_ = structure_model_delete_node (self, sibling);
		new_child = _tmp9_;
		_tmp10_ = new_child;
		new_child = NULL;
		g_node_append (node_unlinked, _tmp10_);
		sibling = next_sibling;
		__g_node_destroy__struct_data_free0_0 (new_child);
	}
	_tmp11_ = node_unlinked;
	node_unlinked = NULL;
	_tmp12_ = g_node_insert (new_parent, new_pos, _tmp11_);
	node = _tmp12_;
	structure_model_reinsert_node (self, node, FALSE);
	__g_node_destroy__struct_data_free0_0 (node_unlinked);
}


gboolean structure_model_item_contains_subparagraph (StructureModel* self, GtkTreeIter* iter) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	GNode* _tmp1_ = NULL;
	GNode* node;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = structure_model_iter_is_valid (self, iter);
	g_return_val_if_fail (_tmp0_, FALSE);
	_tmp1_ = structure_model_get_node_from_iter (self, iter);
	node = _tmp1_;
	_tmp2_ = structure_model_node_contains_subparagraph (self, node);
	result = _tmp2_;
	return result;
}


static gboolean structure_model_node_contains_subparagraph (StructureModel* self, GNode* node) {
	gboolean result = FALSE;
	StructType type;
	gboolean _tmp0_;
	GNode* _tmp1_ = NULL;
	GNode* child;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (node != NULL, FALSE);
	type = (*((StructData*) node->data)).type;
	if (type == STRUCT_TYPE_SUBPARAGRAPH) {
		result = TRUE;
		return result;
	}
	_tmp0_ = structure_is_section (type);
	if (!_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp1_ = g_node_first_child (node);
	child = _tmp1_;
	while (TRUE) {
		gboolean _tmp2_;
		GNode* _tmp3_ = NULL;
		if (!(child != NULL)) {
			break;
		}
		_tmp2_ = structure_model_node_contains_subparagraph (self, child);
		if (_tmp2_) {
			result = TRUE;
			return result;
		}
		_tmp3_ = g_node_next_sibling (child);
		child = _tmp3_;
	}
	result = FALSE;
	return result;
}


static void structure_model_insert_node (StructureModel* self, GNode* node, gboolean force_first_child) {
	GtkTreeIter* _tmp0_ = NULL;
	GtkTreeIter* _tmp1_;
	GtkTreeIter _tmp2_;
	GtkTreeIter item_iter;
	GtkTreePath* _tmp3_ = NULL;
	GtkTreePath* item_path;
	GNode* parent;
	gboolean _tmp4_ = FALSE;
	gboolean first_child;
	gboolean _tmp5_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	structure_model_new_stamp (self);
	self->priv->_nb_nodes++;
	if (!self->priv->_emit_signals) {
		return;
	}
	_tmp0_ = structure_model_create_iter_at_node (self, node);
	_tmp1_ = _tmp0_;
	_tmp2_ = *_tmp1_;
	_g_free0 (_tmp1_);
	item_iter = _tmp2_;
	_tmp3_ = gtk_tree_model_get_path ((GtkTreeModel*) self, &item_iter);
	item_path = _tmp3_;
	gtk_tree_model_row_inserted ((GtkTreeModel*) self, item_path, &item_iter);
	parent = node->parent;
	if (parent != self->priv->_tree) {
		_tmp4_ = parent->children == node;
	} else {
		_tmp4_ = FALSE;
	}
	first_child = _tmp4_;
	if (force_first_child) {
		_tmp5_ = TRUE;
	} else {
		_tmp5_ = first_child;
	}
	if (_tmp5_) {
		GtkTreeIter* _tmp6_ = NULL;
		GtkTreeIter* _tmp7_;
		GtkTreeIter _tmp8_;
		GtkTreeIter parent_iter;
		GtkTreePath* _tmp9_ = NULL;
		GtkTreePath* parent_path;
		_tmp6_ = structure_model_create_iter_at_node (self, parent);
		_tmp7_ = _tmp6_;
		_tmp8_ = *_tmp7_;
		_g_free0 (_tmp7_);
		parent_iter = _tmp8_;
		_tmp9_ = gtk_tree_model_get_path ((GtkTreeModel*) self, &parent_iter);
		parent_path = _tmp9_;
		gtk_tree_model_row_has_child_toggled ((GtkTreeModel*) self, parent_path, &parent_iter);
		_gtk_tree_path_free0 (parent_path);
	}
	_gtk_tree_path_free0 (item_path);
}


static GNode* g_node_unlink_vala (GNode* self) {
	GNode* result = NULL;
	void* ptr;
	void* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	ptr = self;
	g_node_unlink (self);
	_tmp0_ = ptr;
	ptr = NULL;
	result = (GNode*) _tmp0_;
	return result;
}


static GNode* structure_model_delete_node (StructureModel* self, GNode* node) {
	GNode* result = NULL;
	GtkTreePath* path;
	GNode* parent;
	GNode* _tmp2_ = NULL;
	GNode* node_unlinked;
	guint _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (node != NULL, NULL);
	structure_model_new_stamp (self);
	path = NULL;
	parent = NULL;
	if (self->priv->_emit_signals) {
		GtkTreeIter* _tmp0_ = NULL;
		GtkTreeIter* iter;
		GtkTreePath* _tmp1_ = NULL;
		_tmp0_ = structure_model_create_iter_at_node (self, node);
		iter = _tmp0_;
		g_return_val_if_fail (iter != NULL, NULL);
		_tmp1_ = gtk_tree_model_get_path ((GtkTreeModel*) self, iter);
		_gtk_tree_path_free0 (path);
		path = _tmp1_;
		parent = node->parent;
		_g_free0 (iter);
	}
	_tmp2_ = g_node_unlink_vala (node);
	node_unlinked = _tmp2_;
	_tmp3_ = g_node_n_nodes (node_unlinked, G_TRAVERSE_ALL);
	self->priv->_nb_nodes = self->priv->_nb_nodes - _tmp3_;
	if (self->priv->_emit_signals) {
		gboolean _tmp4_ = FALSE;
		gtk_tree_model_row_deleted ((GtkTreeModel*) self, path);
		if (parent != self->priv->_tree) {
			_tmp4_ = parent->children == NULL;
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			GtkTreeIter* _tmp5_ = NULL;
			GtkTreeIter* _tmp6_;
			GtkTreeIter _tmp7_;
			GtkTreeIter parent_iter;
			GtkTreePath* _tmp8_ = NULL;
			GtkTreePath* parent_path;
			_tmp5_ = structure_model_create_iter_at_node (self, parent);
			_tmp6_ = _tmp5_;
			_tmp7_ = *_tmp6_;
			_g_free0 (_tmp6_);
			parent_iter = _tmp7_;
			_tmp8_ = gtk_tree_model_get_path ((GtkTreeModel*) self, &parent_iter);
			parent_path = _tmp8_;
			gtk_tree_model_row_has_child_toggled ((GtkTreeModel*) self, parent_path, &parent_iter);
			_gtk_tree_path_free0 (parent_path);
		}
	}
	result = node_unlinked;
	_gtk_tree_path_free0 (path);
	return result;
}


static void structure_model_shift_node (StructureModel* self, GNode* node, gboolean shift_right) {
	gboolean _tmp0_;
	GNode* _tmp1_ = NULL;
	GNode* child;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = structure_is_section ((*((StructData*) node->data)).type);
	if (!_tmp0_) {
		return;
	}
	if (shift_right) {
		if ((*((StructData*) node->data)).type != STRUCT_TYPE_SUBPARAGRAPH) {
			(*((StructData*) node->data)).type = (*((StructData*) node->data)).type + 1;
		}
	} else {
		if ((*((StructData*) node->data)).type != STRUCT_TYPE_PART) {
			(*((StructData*) node->data)).type = (*((StructData*) node->data)).type - 1;
		}
	}
	_tmp1_ = g_node_first_child (node);
	child = _tmp1_;
	while (TRUE) {
		GNode* _tmp2_ = NULL;
		if (!(child != NULL)) {
			break;
		}
		structure_model_shift_node (self, child, shift_right);
		_tmp2_ = g_node_next_sibling (child);
		child = _tmp2_;
	}
}


static void structure_model_reinsert_node (StructureModel* self, GNode* node, gboolean force_first_child) {
	GNode* _tmp0_ = NULL;
	GNode* child;
	gboolean first_child;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	structure_model_insert_node (self, node, force_first_child);
	_tmp0_ = g_node_first_child (node);
	child = _tmp0_;
	first_child = TRUE;
	while (TRUE) {
		GNode* _tmp1_ = NULL;
		if (!(child != NULL)) {
			break;
		}
		structure_model_reinsert_node (self, child, first_child);
		_tmp1_ = g_node_next_sibling (child);
		child = _tmp1_;
		first_child = FALSE;
	}
}


static GtkTreeIter* structure_model_insert_item_after (StructureModel* self, GNode* parent, GNode* sibling, StructData* item) {
	GtkTreeIter* result = NULL;
	StructData* _tmp0_;
	GNode* _tmp1_ = NULL;
	GNode* _tmp2_ = NULL;
	GNode* new_node;
	GtkTreeIter* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail ((*item).text != NULL, NULL);
	_tmp0_ = _struct_data_dup0 (item);
	_tmp1_ = g_node_new (_tmp0_);
	_tmp2_ = g_node_insert_after (parent, sibling, _tmp1_);
	new_node = _tmp2_;
	structure_model_insert_node (self, new_node, FALSE);
	structure_model_insert_node_in_list (self, new_node);
	_tmp3_ = structure_model_create_iter_at_node (self, new_node);
	result = _tmp3_;
	return result;
}


static void structure_model_make_children_between_marks (StructureModel* self, GNode* node) {
	StructData _tmp0_;
	StructData _tmp1_ = {0};
	StructData data;
	GNode* _tmp2_ = NULL;
	GNode* sibling;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	struct_data_copy ((StructData*) node->data, &_tmp1_);
	_tmp0_ = _tmp1_;
	data = _tmp0_;
	if (data.end_mark == NULL) {
		struct_data_destroy (&data);
		return;
	}
	_tmp2_ = g_node_next_sibling (node);
	sibling = _tmp2_;
	while (TRUE) {
		StructData _tmp3_;
		StructData _tmp4_ = {0};
		StructData sibling_data;
		gboolean _tmp5_;
		gint _tmp6_;
		GNode* _tmp7_ = NULL;
		GNode* sibling_unlinked;
		GNode* _tmp8_;
		GNode* _tmp9_ = NULL;
		GNode* new_child;
		GNode* _tmp10_ = NULL;
		if (!(sibling != NULL)) {
			break;
		}
		struct_data_copy ((StructData*) sibling->data, &_tmp4_);
		_tmp3_ = _tmp4_;
		sibling_data = _tmp3_;
		_tmp5_ = structure_is_section (sibling_data.type);
		if (_tmp5_) {
			struct_data_destroy (&sibling_data);
			break;
		}
		_tmp6_ = structure_model_compare_nodes (data.end_mark, sibling_data.start_mark);
		if (_tmp6_ <= 0) {
			struct_data_destroy (&sibling_data);
			break;
		}
		_tmp7_ = structure_model_delete_node (self, sibling);
		sibling_unlinked = _tmp7_;
		_tmp8_ = sibling_unlinked;
		sibling_unlinked = NULL;
		_tmp9_ = g_node_append (node, _tmp8_);
		new_child = _tmp9_;
		structure_model_insert_node (self, new_child, FALSE);
		_tmp10_ = g_node_next_sibling (node);
		sibling = _tmp10_;
		__g_node_destroy__struct_data_free0_0 (sibling_unlinked);
		struct_data_destroy (&sibling_data);
	}
	struct_data_destroy (&data);
}


static void structure_model_search_end_node (StructureModel* self) {
	g_return_if_fail (self != NULL);
	self->priv->_end_node = self->priv->_tree;
	while (TRUE) {
		gboolean _tmp0_;
		GNode* _tmp1_ = NULL;
		_tmp0_ = G_NODE_IS_LEAF (self->priv->_end_node);
		if (!(!_tmp0_)) {
			break;
		}
		_tmp1_ = g_node_last_child (self->priv->_end_node);
		self->priv->_end_node = _tmp1_;
	}
}


static gint structure_model_compare_nodes (GtkTextMark* mark1, GtkTextMark* mark2) {
	gint result = 0;
	GtkTextBuffer* _tmp0_ = NULL;
	GtkTextBuffer* _tmp1_;
	GtkTextBuffer* doc;
	GtkTextBuffer* _tmp2_ = NULL;
	GtkTextIter iter1 = {0};
	GtkTextIter iter2 = {0};
	GtkTextIter _tmp3_ = {0};
	GtkTextIter _tmp4_ = {0};
	gint _tmp5_;
	g_return_val_if_fail (mark1 != NULL, 0);
	g_return_val_if_fail (mark2 != NULL, 0);
	_tmp0_ = gtk_text_mark_get_buffer (mark1);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	doc = _tmp1_;
	_tmp2_ = gtk_text_mark_get_buffer (mark2);
	g_return_val_if_fail (doc == _tmp2_, 0);
	gtk_text_buffer_get_iter_at_mark (doc, &_tmp3_, mark1);
	iter1 = _tmp3_;
	gtk_text_buffer_get_iter_at_mark (doc, &_tmp4_, mark2);
	iter2 = _tmp4_;
	_tmp5_ = gtk_text_iter_compare (&iter1, &iter2);
	result = _tmp5_;
	_g_object_unref0 (doc);
	return result;
}


/*************************************************************************/
void structure_model_populate_list (StructureModel* self, GtkListStore* store, StructType type) {
	GeeArrayList* _tmp0_ = NULL;
	GeeArrayList* list;
	g_return_if_fail (self != NULL);
	g_return_if_fail (store != NULL);
	_tmp0_ = structure_model_get_list (self, type);
	list = _tmp0_;
	g_return_if_fail (list != NULL);
	{
		GeeArrayList* _tmp1_;
		GeeArrayList* _node_list;
		gint _tmp2_;
		gint _node_size;
		gint _node_index;
		_tmp1_ = _g_object_ref0 (list);
		_node_list = _tmp1_;
		_tmp2_ = gee_collection_get_size ((GeeCollection*) _node_list);
		_node_size = _tmp2_;
		_node_index = -1;
		while (TRUE) {
			gpointer _tmp3_ = NULL;
			GNode* node;
			StructData _tmp4_;
			StructData _tmp5_ = {0};
			StructData data;
			GtkTreeIter iter = {0};
			GtkTreeIter _tmp6_ = {0};
			gchar* _tmp7_ = NULL;
			gchar* _tmp8_;
			gchar* _tmp9_ = NULL;
			gchar* _tmp10_;
			_node_index = _node_index + 1;
			if (!(_node_index < _node_size)) {
				break;
			}
			_tmp3_ = gee_abstract_list_get ((GeeAbstractList*) _node_list, _node_index);
			node = (GNode*) _tmp3_;
			struct_data_copy ((StructData*) node->data, &_tmp5_);
			_tmp4_ = _tmp5_;
			data = _tmp4_;
			gtk_list_store_append (store, &_tmp6_);
			iter = _tmp6_;
			_tmp7_ = structure_get_icon_from_type (data.type);
			_tmp8_ = _tmp7_;
			_tmp9_ = structure_get_type_name (data.type);
			_tmp10_ = _tmp9_;
			gtk_list_store_set (store, &iter, STRUCT_LIST_COLUMN_PIXBUF, _tmp8_, STRUCT_LIST_COLUMN_TEXT, data.text, STRUCT_LIST_COLUMN_TOOLTIP, _tmp10_, -1, -1);
			_g_free0 (_tmp10_);
			_g_free0 (_tmp8_);
			struct_data_destroy (&data);
		}
		_g_object_unref0 (_node_list);
	}
	_g_object_unref0 (list);
}


GtkTreePath* structure_model_get_tree_path_from_list_num (StructureModel* self, StructType list_type, gint num) {
	GtkTreePath* result = NULL;
	GeeArrayList* _tmp0_ = NULL;
	GeeArrayList* list;
	gboolean _tmp1_ = FALSE;
	gpointer _tmp3_ = NULL;
	GtkTreeIter* _tmp4_ = NULL;
	GtkTreeIter* _tmp5_;
	GtkTreePath* _tmp6_ = NULL;
	GtkTreePath* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = structure_model_get_list (self, list_type);
	list = _tmp0_;
	g_return_val_if_fail (list != NULL, NULL);
	if (0 <= num) {
		gint _tmp2_;
		_tmp2_ = gee_collection_get_size ((GeeCollection*) list);
		_tmp1_ = num < _tmp2_;
	} else {
		_tmp1_ = FALSE;
	}
	g_return_val_if_fail (_tmp1_, NULL);
	_tmp3_ = gee_abstract_list_get ((GeeAbstractList*) list, num);
	_tmp4_ = structure_model_create_iter_at_node (self, (GNode*) _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = gtk_tree_model_get_path ((GtkTreeModel*) self, _tmp5_);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	result = _tmp7_;
	_g_object_unref0 (list);
	return result;
}


gint structure_model_get_list_num_from_tree_iter (StructureModel* self, GtkTreeIter* tree_iter) {
	gint result = 0;
	gboolean _tmp0_;
	GNode* _tmp1_ = NULL;
	GNode* node;
	GeeArrayList* _tmp2_ = NULL;
	GeeArrayList* list;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = structure_model_iter_is_valid (self, tree_iter);
	g_return_val_if_fail (_tmp0_, -1);
	_tmp1_ = structure_model_get_node_from_iter (self, tree_iter);
	node = _tmp1_;
	_tmp2_ = structure_model_get_list (self, (*((StructData*) node->data)).type);
	list = _tmp2_;
	g_return_val_if_fail (list != NULL, -1);
	{
		gint num;
		num = 0;
		{
			gboolean _tmp3_;
			_tmp3_ = TRUE;
			while (TRUE) {
				gint _tmp4_;
				gpointer _tmp5_ = NULL;
				if (!_tmp3_) {
					num++;
				}
				_tmp3_ = FALSE;
				_tmp4_ = gee_collection_get_size ((GeeCollection*) list);
				if (!(num < _tmp4_)) {
					break;
				}
				_tmp5_ = gee_abstract_list_get ((GeeAbstractList*) list, num);
				if (((GNode*) _tmp5_) == node) {
					result = num;
					_g_object_unref0 (list);
					return result;
				}
			}
		}
	}
	g_return_val_if_reached (-1);
	_g_object_unref0 (list);
}


static void structure_model_insert_node_in_list (StructureModel* self, GNode* node) {
	StructData _tmp0_;
	StructData _tmp1_ = {0};
	StructData item;
	gboolean _tmp2_;
	GeeArrayList* _tmp3_ = NULL;
	GeeArrayList* list;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	struct_data_copy ((StructData*) node->data, &_tmp1_);
	_tmp0_ = _tmp1_;
	item = _tmp0_;
	_tmp2_ = structure_is_section (item.type);
	if (_tmp2_) {
		struct_data_destroy (&item);
		return;
	}
	_tmp3_ = structure_model_get_list (self, item.type);
	list = _tmp3_;
	g_return_if_fail (list != NULL);
	gee_abstract_collection_add ((GeeAbstractCollection*) list, node);
	_g_object_unref0 (list);
	struct_data_destroy (&item);
}


static gboolean _lambda18_ (GNode* node_param, StructureModel* self) {
	gboolean result = FALSE;
	GNode* node;
	StructType type;
	gboolean _tmp0_;
	g_return_val_if_fail (node_param != NULL, FALSE);
	node = (GNode*) node_param;
	type = (*((StructData*) node->data)).type;
	_tmp0_ = structure_is_section (type);
	if (!_tmp0_) {
		GeeArrayList* _tmp1_ = NULL;
		GeeArrayList* list;
		_tmp1_ = structure_model_get_list (self, type);
		list = _tmp1_;
		g_return_val_if_fail (list != NULL, TRUE);
		gee_abstract_collection_add ((GeeAbstractCollection*) list, node);
		_g_object_unref0 (list);
	}
	result = FALSE;
	return result;
}


static gboolean __lambda18__gnode_traverse_func (GNode* node, gpointer self) {
	gboolean result;
	result = _lambda18_ (node, self);
	return result;
}


static void structure_model_regenerate_simple_lists (StructureModel* self) {
	g_return_if_fail (self != NULL);
	structure_model_reset_simple_lists (self);
	g_node_traverse (self->priv->_tree, G_PRE_ORDER, G_TRAVERSE_ALL, -1, __lambda18__gnode_traverse_func, self);
}


static void structure_model_reset_simple_lists (StructureModel* self) {
	GeeArrayList* _tmp0_ = NULL;
	GeeArrayList* _tmp1_ = NULL;
	GeeArrayList* _tmp2_ = NULL;
	GeeArrayList* _tmp3_ = NULL;
	GeeArrayList* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_array_list_new (G_TYPE_POINTER, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_list_labels);
	self->priv->_list_labels = _tmp0_;
	_tmp1_ = gee_array_list_new (G_TYPE_POINTER, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_list_includes);
	self->priv->_list_includes = _tmp1_;
	_tmp2_ = gee_array_list_new (G_TYPE_POINTER, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_list_tables);
	self->priv->_list_tables = _tmp2_;
	_tmp3_ = gee_array_list_new (G_TYPE_POINTER, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_list_figures);
	self->priv->_list_figures = _tmp3_;
	_tmp4_ = gee_array_list_new (G_TYPE_POINTER, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_list_todos_and_fixmes);
	self->priv->_list_todos_and_fixmes = _tmp4_;
}


static GeeArrayList* structure_model_get_list (StructureModel* self, StructType type) {
	GeeArrayList* result = NULL;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = structure_is_section (type);
	if (_tmp0_) {
		result = NULL;
		return result;
	}
	switch (type) {
		case STRUCT_TYPE_LABEL:
		{
			GeeArrayList* _tmp1_;
			_tmp1_ = _g_object_ref0 (self->priv->_list_labels);
			result = _tmp1_;
			return result;
		}
		case STRUCT_TYPE_INCLUDE:
		{
			GeeArrayList* _tmp2_;
			_tmp2_ = _g_object_ref0 (self->priv->_list_includes);
			result = _tmp2_;
			return result;
		}
		case STRUCT_TYPE_TABLE:
		{
			GeeArrayList* _tmp3_;
			_tmp3_ = _g_object_ref0 (self->priv->_list_tables);
			result = _tmp3_;
			return result;
		}
		case STRUCT_TYPE_FIGURE:
		case STRUCT_TYPE_IMAGE:
		{
			GeeArrayList* _tmp4_;
			_tmp4_ = _g_object_ref0 (self->priv->_list_figures);
			result = _tmp4_;
			return result;
		}
		case STRUCT_TYPE_TODO:
		case STRUCT_TYPE_FIXME:
		{
			GeeArrayList* _tmp5_;
			_tmp5_ = _g_object_ref0 (self->priv->_list_todos_and_fixmes);
			result = _tmp5_;
			return result;
		}
		default:
		{
			result = NULL;
			return result;
		}
	}
}


gboolean structure_model_get_emit_signals (StructureModel* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_emit_signals;
	return result;
}


void structure_model_set_emit_signals (StructureModel* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_emit_signals = value;
	g_object_notify ((GObject *) self, "emit-signals");
}


static void structure_model_class_init (StructureModelClass * klass) {
	structure_model_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (StructureModelPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_structure_model_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_structure_model_set_property;
	G_OBJECT_CLASS (klass)->finalize = structure_model_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), STRUCTURE_MODEL_EMIT_SIGNALS, g_param_spec_boolean ("emit-signals", "emit-signals", "emit-signals", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void structure_model_gtk_tree_model_interface_init (GtkTreeModelIface * iface) {
	structure_model_gtk_tree_model_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_column_type = (GType (*)(GtkTreeModel* ,gint)) structure_model_real_get_column_type;
	iface->get_n_columns = (gint (*)(GtkTreeModel*)) structure_model_real_get_n_columns;
	iface->get_flags = (GtkTreeModelFlags (*)(GtkTreeModel*)) structure_model_real_get_flags;
	iface->iter_has_child = (gboolean (*)(GtkTreeModel* ,GtkTreeIter*)) structure_model_real_iter_has_child;
	iface->iter_n_children = (gint (*)(GtkTreeModel* ,GtkTreeIter*)) structure_model_real_iter_n_children;
	iface->get_value = (void (*)(GtkTreeModel* ,GtkTreeIter* ,gint ,GValue*)) structure_model_real_get_value;
	iface->iter_children = (gboolean (*)(GtkTreeModel* ,GtkTreeIter* ,GtkTreeIter*)) structure_model_real_iter_children;
	iface->iter_next = (gboolean (*)(GtkTreeModel* ,GtkTreeIter*)) structure_model_real_iter_next;
	iface->iter_nth_child = (gboolean (*)(GtkTreeModel* ,GtkTreeIter* ,GtkTreeIter* ,gint)) structure_model_real_iter_nth_child;
	iface->iter_parent = (gboolean (*)(GtkTreeModel* ,GtkTreeIter* ,GtkTreeIter*)) structure_model_real_iter_parent;
	iface->get_iter = (gboolean (*)(GtkTreeModel* ,GtkTreeIter* ,GtkTreePath*)) structure_model_real_get_iter;
	iface->get_path = (GtkTreePath* (*)(GtkTreeModel* ,GtkTreeIter*)) structure_model_real_get_path;
	iface->ref_node = (void (*)(GtkTreeModel* ,GtkTreeIter*)) structure_model_real_ref_node;
	iface->unref_node = (void (*)(GtkTreeModel* ,GtkTreeIter*)) structure_model_real_unref_node;
}


static void structure_model_instance_init (StructureModel * self) {
	self->priv = STRUCTURE_MODEL_GET_PRIVATE (self);
	self->priv->_emit_signals = FALSE;
	self->priv->_nb_nodes = (guint) 0;
	self->priv->_end_node = NULL;
}


static void structure_model_finalize (GObject* obj) {
	StructureModel * self;
	self = STRUCTURE_MODEL (obj);
	self->priv->_column_types = (g_free (self->priv->_column_types), NULL);
	__g_node_destroy__struct_data_free0_0 (self->priv->_tree);
	_g_object_unref0 (self->priv->_list_labels);
	_g_object_unref0 (self->priv->_list_includes);
	_g_object_unref0 (self->priv->_list_tables);
	_g_object_unref0 (self->priv->_list_figures);
	_g_object_unref0 (self->priv->_list_todos_and_fixmes);
	G_OBJECT_CLASS (structure_model_parent_class)->finalize (obj);
}


GType structure_model_get_type (void) {
	static volatile gsize structure_model_type_id__volatile = 0;
	if (g_once_init_enter (&structure_model_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (StructureModelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) structure_model_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (StructureModel), 0, (GInstanceInitFunc) structure_model_instance_init, NULL };
		static const GInterfaceInfo gtk_tree_model_info = { (GInterfaceInitFunc) structure_model_gtk_tree_model_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType structure_model_type_id;
		structure_model_type_id = g_type_register_static (G_TYPE_OBJECT, "StructureModel", &g_define_type_info, 0);
		g_type_add_interface_static (structure_model_type_id, GTK_TYPE_TREE_MODEL, &gtk_tree_model_info);
		g_once_init_leave (&structure_model_type_id__volatile, structure_model_type_id);
	}
	return structure_model_type_id__volatile;
}


static void _vala_structure_model_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	StructureModel * self;
	self = STRUCTURE_MODEL (object);
	switch (property_id) {
		case STRUCTURE_MODEL_EMIT_SIGNALS:
		g_value_set_boolean (value, structure_model_get_emit_signals (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_structure_model_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	StructureModel * self;
	self = STRUCTURE_MODEL (object);
	switch (property_id) {
		case STRUCTURE_MODEL_EMIT_SIGNALS:
		structure_model_set_emit_signals (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



