/* app_settings.c generated by valac 0.12.1, the Vala compiler
 * generated from app_settings.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2010-2011 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gee.h>
#include <config.h>
#include <gtksourceview/gtksourcestyleschememanager.h>
#include <gtksourceview/gtksourceview.h>
#include <gtk/gtk.h>
#include <stdio.h>
#include <glib/gi18n-lib.h>


#define TYPE_BUILD_JOB (build_job_get_type ())
typedef struct _BuildJob BuildJob;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_BUILD_TOOL (build_tool_get_type ())
typedef struct _BuildTool BuildTool;

#define TYPE_MOST_USED_SYMBOL (most_used_symbol_get_type ())
typedef struct _MostUsedSymbol MostUsedSymbol;

#define TYPE_APP_SETTINGS (app_settings_get_type ())
#define APP_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_SETTINGS, AppSettings))
#define APP_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_SETTINGS, AppSettingsClass))
#define IS_APP_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_SETTINGS))
#define IS_APP_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_SETTINGS))
#define APP_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_SETTINGS, AppSettingsClass))

typedef struct _AppSettings AppSettings;
typedef struct _AppSettingsClass AppSettingsClass;
typedef struct _AppSettingsPrivate AppSettingsPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_APPLICATION (application_get_type ())
#define APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APPLICATION, Application))
#define APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APPLICATION, ApplicationClass))
#define IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APPLICATION))
#define IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APPLICATION))
#define APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APPLICATION, ApplicationClass))

typedef struct _Application Application;
typedef struct _ApplicationClass ApplicationClass;

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))

#define TYPE_DOCUMENT_VIEW (document_view_get_type ())
#define DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_VIEW, DocumentView))
#define DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_VIEW, DocumentViewClass))
#define IS_DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_VIEW))
#define IS_DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_VIEW))
#define DOCUMENT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_VIEW, DocumentViewClass))

typedef struct _DocumentView DocumentView;
typedef struct _DocumentViewClass DocumentViewClass;
typedef struct _DocumentPrivate DocumentPrivate;

#define TYPE_DOCUMENT_TAB (document_tab_get_type ())
#define DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_TAB, DocumentTab))
#define DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_TAB, DocumentTabClass))
#define IS_DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_TAB))
#define IS_DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_TAB))
#define DOCUMENT_TAB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_TAB, DocumentTabClass))

typedef struct _DocumentTab DocumentTab;
typedef struct _DocumentTabClass DocumentTabClass;
#define _most_used_symbol_free0(var) ((var == NULL) ? NULL : (var = (most_used_symbol_free (var), NULL)))
#define _g_markup_parse_context_free0(var) ((var == NULL) ? NULL : (var = (g_markup_parse_context_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _build_tool_free0(var) ((var == NULL) ? NULL : (var = (build_tool_free (var), NULL)))

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

struct _BuildJob {
	gboolean must_succeed;
	gchar* post_processor;
	gchar* command;
	gchar** command_args;
	gint command_args_length1;
};

struct _BuildTool {
	gchar* description;
	gchar* extensions;
	gchar* label;
	gchar* icon;
	gboolean compilation;
	GList* jobs;
};

struct _MostUsedSymbol {
	gchar* id;
	gchar* latex_command;
	gchar* package_required;
	guint num;
};

struct _AppSettings {
	GSettings parent_instance;
	AppSettingsPrivate * priv;
};

struct _AppSettingsClass {
	GSettingsClass parent_class;
};

struct _AppSettingsPrivate {
	GSettings* editor;
	GSettings* desktop_interface;
	guint timeout_id;
	gchar* _system_font;
	GeeLinkedList* most_used_symbols;
	gboolean mus_modified;
	GeeLinkedList* build_tools;
	BuildTool current_build_tool;
	BuildJob current_build_job;
	BuildTool _build_tool_view_dvi;
	BuildTool _build_tool_view_pdf;
	BuildTool _build_tool_view_ps;
	gboolean current_tool_is_view_dvi;
	gboolean current_tool_is_view_pdf;
	gboolean current_tool_is_view_ps;
	gboolean build_tools_modified;
};

struct _Document {
	GtkSourceBuffer parent_instance;
	DocumentPrivate * priv;
	DocumentTab* tab;
	guint _unsaved_doc_num;
};

struct _DocumentClass {
	GtkSourceBufferClass parent_class;
};


static gpointer app_settings_parent_class = NULL;
static AppSettings* app_settings_instance;
static AppSettings* app_settings_instance = NULL;

GType build_job_get_type (void) G_GNUC_CONST;
BuildJob* build_job_dup (const BuildJob* self);
void build_job_free (BuildJob* self);
void build_job_copy (const BuildJob* self, BuildJob* dest);
void build_job_destroy (BuildJob* self);
static gchar** _vala_array_dup3 (gchar** self, int length);
GType build_tool_get_type (void) G_GNUC_CONST;
BuildTool* build_tool_dup (const BuildTool* self);
void build_tool_free (BuildTool* self);
void build_tool_copy (const BuildTool* self, BuildTool* dest);
void build_tool_destroy (BuildTool* self);
GType most_used_symbol_get_type (void) G_GNUC_CONST;
MostUsedSymbol* most_used_symbol_dup (const MostUsedSymbol* self);
void most_used_symbol_free (MostUsedSymbol* self);
void most_used_symbol_copy (const MostUsedSymbol* self, MostUsedSymbol* dest);
void most_used_symbol_destroy (MostUsedSymbol* self);
GType app_settings_get_type (void) G_GNUC_CONST;
#define APP_SETTINGS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_APP_SETTINGS, AppSettingsPrivate))
enum  {
	APP_SETTINGS_DUMMY_PROPERTY,
	APP_SETTINGS_SYSTEM_FONT,
	APP_SETTINGS_BUILD_TOOL_VIEW_DVI,
	APP_SETTINGS_BUILD_TOOL_VIEW_PDF,
	APP_SETTINGS_BUILD_TOOL_VIEW_PS
};
static AppSettings* app_settings_new (void);
static AppSettings* app_settings_construct (GType object_type);
static void app_settings_initialize (AppSettings* self);
static void app_settings_load_build_tools (AppSettings* self);
static void app_settings_load_most_used_symbols (AppSettings* self);
AppSettings* app_settings_get_default (void);
static void app_settings_set_system_font (AppSettings* self, const gchar* value);
static void _lambda6_ (GSettings* setting, const gchar* key, AppSettings* self);
static void app_settings_set_font (AppSettings* self, const gchar* font);
const gchar* app_settings_get_system_font (AppSettings* self);
static void __lambda6__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void _lambda84_ (GSettings* setting, const gchar* key, AppSettings* self);
static void __lambda84__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void _lambda85_ (GSettings* setting, const gchar* key, AppSettings* self);
static void __lambda85__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void _lambda86_ (GSettings* setting, const gchar* key, AppSettings* self);
GType application_get_type (void) G_GNUC_CONST;
Application* application_get_default (void);
GType document_get_type (void) G_GNUC_CONST;
GList* application_get_documents (Application* self);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static void __lambda86__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void _lambda87_ (GSettings* setting, const gchar* key, AppSettings* self);
GType document_view_get_type (void) G_GNUC_CONST;
GList* application_get_views (Application* self);
static void __lambda87__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void _lambda88_ (GSettings* setting, const gchar* key, AppSettings* self);
static void __lambda88__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void _lambda89_ (GSettings* setting, const gchar* key, AppSettings* self);
static void __lambda89__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void _lambda90_ (GSettings* setting, const gchar* key, AppSettings* self);
static void __lambda90__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void _lambda91_ (GSettings* setting, const gchar* key, AppSettings* self);
static void __lambda91__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void _lambda92_ (GSettings* setting, const gchar* key, AppSettings* self);
GType document_tab_get_type (void) G_GNUC_CONST;
void document_tab_set_auto_save (DocumentTab* self, gboolean value);
static void __lambda92__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void _lambda93_ (GSettings* setting, const gchar* key, AppSettings* self);
void document_tab_set_auto_save_interval (DocumentTab* self, guint value);
static void __lambda93__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void _lambda94_ (GSettings* setting, const gchar* key, AppSettings* self);
static gboolean _lambda95_ (AppSettings* self);
void symbols_reload_most_used_symbols (void);
static gboolean __lambda95__gsource_func (gpointer self);
static void __lambda94__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
void document_view_set_font_from_string (DocumentView* self, const gchar* font);
GeeList* app_settings_get_most_used_symbols (AppSettings* self);
void app_settings_clear_most_used_symbols (AppSettings* self);
void app_settings_add_symbol (AppSettings* self, const gchar* id, const gchar* command, const gchar* package);
static gint app_settings_sort_most_used_symbol (AppSettings* self, gint index, MostUsedSymbol* mus);
void symbols_remove_most_used_symbol (gint index);
void symbols_insert_most_used_symbol (gint index, MostUsedSymbol* symbol);
void symbols_swap_most_used_symbol (gint current_index, gint new_index);
static GFile* app_settings_get_file_most_used_symbols (AppSettings* self);
static void app_settings_mus_parser_start (AppSettings* self, GMarkupParseContext* context, const gchar* name, gchar** attr_names, int attr_names_length1, gchar** attr_values, int attr_values_length1, GError** error);
static void _app_settings_mus_parser_start_gmarkup_parser_start_element_func (GMarkupParseContext* context, const gchar* element_name, gchar** attribute_names, gchar** attribute_values, gpointer self, GError** error);
void app_settings_save_most_used_symbols (AppSettings* self);
void utils_delete_file (GFile* file);
GeeLinkedList* app_settings_get_build_tools (AppSettings* self);
void app_settings_move_build_tool_up (AppSettings* self, gint num);
static void app_settings_swap_build_tools (AppSettings* self, gint num1, gint num2);
void app_settings_move_build_tool_down (AppSettings* self, gint num);
static void app_settings_update_all_build_tools_menu (AppSettings* self);
void app_settings_delete_build_tool (AppSettings* self, gint num);
void app_settings_append_build_tool (AppSettings* self, BuildTool* tool);
static gboolean app_settings_is_compilation (AppSettings* self, const gchar* icon);
void app_settings_update_build_tool (AppSettings* self, gint num, BuildTool* tool);
static gboolean app_settings_is_build_tools_equal (AppSettings* self, BuildTool* tool1, BuildTool* tool2);
void app_settings_reset_all_build_tools (AppSettings* self);
static GFile* app_settings_get_user_config_build_tools_file (AppSettings* self);
GType main_window_get_type (void) G_GNUC_CONST;
GList* application_get_windows (Application* self);
void main_window_update_build_tools_menu (MainWindow* self);
static void _vala_array_add8 (GFile*** array, int* length, int* size, GFile* value);
static void _vala_array_add9 (GFile*** array, int* length, int* size, GFile* value);
static void _vala_array_add10 (GFile*** array, int* length, int* size, GFile* value);
static void app_settings_parser_start (AppSettings* self, GMarkupParseContext* context, const gchar* name, gchar** attr_names, int attr_names_length1, gchar** attr_values, int attr_values_length1, GError** error);
static void _app_settings_parser_start_gmarkup_parser_start_element_func (GMarkupParseContext* context, const gchar* element_name, gchar** attribute_names, gchar** attribute_values, gpointer self, GError** error);
static void app_settings_parser_end (AppSettings* self, GMarkupParseContext* context, const gchar* name, GError** error);
static void _app_settings_parser_end_gmarkup_parser_end_element_func (GMarkupParseContext* context, const gchar* element_name, gpointer self, GError** error);
static void app_settings_parser_text (AppSettings* self, GMarkupParseContext* context, const gchar* text, gsize text_len, GError** error);
static void _app_settings_parser_text_gmarkup_parser_text_func (GMarkupParseContext* context, const gchar* text, gsize text_len, gpointer self, GError** error);
static void app_settings_set_build_tool_view_dvi (AppSettings* self, BuildTool* value);
static void app_settings_set_build_tool_view_pdf (AppSettings* self, BuildTool* value);
static void app_settings_set_build_tool_view_ps (AppSettings* self, BuildTool* value);
void app_settings_save_build_tools (AppSettings* self);
void app_settings_get_build_tool_view_dvi (AppSettings* self, BuildTool* result);
void app_settings_get_build_tool_view_pdf (AppSettings* self, BuildTool* result);
void app_settings_get_build_tool_view_ps (AppSettings* self, BuildTool* result);
static void app_settings_finalize (GObject* obj);
static void _vala_app_settings_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_app_settings_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gchar** _vala_array_dup3 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


void build_job_copy (const BuildJob* self, BuildJob* dest) {
	gchar** _tmp0_;
	dest->must_succeed = self->must_succeed;
	dest->post_processor = g_strdup (self->post_processor);
	dest->command = g_strdup (self->command);
	dest->command_args = (_tmp0_ = self->command_args, (_tmp0_ == NULL) ? ((gpointer) _tmp0_) : _vala_array_dup3 (_tmp0_, (*self).command_args_length1));
	dest->command_args_length1 = self->command_args_length1;
}


void build_job_destroy (BuildJob* self) {
	_g_free0 ((*self).post_processor);
	_g_free0 ((*self).command);
	(*self).command_args = (_vala_array_free ((*self).command_args, (*self).command_args_length1, (GDestroyNotify) g_free), NULL);
}


BuildJob* build_job_dup (const BuildJob* self) {
	BuildJob* dup;
	dup = g_new0 (BuildJob, 1);
	build_job_copy (self, dup);
	return dup;
}


void build_job_free (BuildJob* self) {
	build_job_destroy (self);
	g_free (self);
}


GType build_job_get_type (void) {
	static volatile gsize build_job_type_id__volatile = 0;
	if (g_once_init_enter (&build_job_type_id__volatile)) {
		GType build_job_type_id;
		build_job_type_id = g_boxed_type_register_static ("BuildJob", (GBoxedCopyFunc) build_job_dup, (GBoxedFreeFunc) build_job_free);
		g_once_init_leave (&build_job_type_id__volatile, build_job_type_id);
	}
	return build_job_type_id__volatile;
}


void build_tool_copy (const BuildTool* self, BuildTool* dest) {
	dest->description = g_strdup (self->description);
	dest->extensions = g_strdup (self->extensions);
	dest->label = g_strdup (self->label);
	dest->icon = g_strdup (self->icon);
	dest->compilation = self->compilation;
	dest->jobs = self->jobs;
}


void build_tool_destroy (BuildTool* self) {
	_g_free0 ((*self).description);
	_g_free0 ((*self).extensions);
	_g_free0 ((*self).label);
	_g_free0 ((*self).icon);
}


BuildTool* build_tool_dup (const BuildTool* self) {
	BuildTool* dup;
	dup = g_new0 (BuildTool, 1);
	build_tool_copy (self, dup);
	return dup;
}


void build_tool_free (BuildTool* self) {
	build_tool_destroy (self);
	g_free (self);
}


GType build_tool_get_type (void) {
	static volatile gsize build_tool_type_id__volatile = 0;
	if (g_once_init_enter (&build_tool_type_id__volatile)) {
		GType build_tool_type_id;
		build_tool_type_id = g_boxed_type_register_static ("BuildTool", (GBoxedCopyFunc) build_tool_dup, (GBoxedFreeFunc) build_tool_free);
		g_once_init_leave (&build_tool_type_id__volatile, build_tool_type_id);
	}
	return build_tool_type_id__volatile;
}


void most_used_symbol_copy (const MostUsedSymbol* self, MostUsedSymbol* dest) {
	dest->id = g_strdup (self->id);
	dest->latex_command = g_strdup (self->latex_command);
	dest->package_required = g_strdup (self->package_required);
	dest->num = self->num;
}


void most_used_symbol_destroy (MostUsedSymbol* self) {
	_g_free0 ((*self).id);
	_g_free0 ((*self).latex_command);
	_g_free0 ((*self).package_required);
}


MostUsedSymbol* most_used_symbol_dup (const MostUsedSymbol* self) {
	MostUsedSymbol* dup;
	dup = g_new0 (MostUsedSymbol, 1);
	most_used_symbol_copy (self, dup);
	return dup;
}


void most_used_symbol_free (MostUsedSymbol* self) {
	most_used_symbol_destroy (self);
	g_free (self);
}


GType most_used_symbol_get_type (void) {
	static volatile gsize most_used_symbol_type_id__volatile = 0;
	if (g_once_init_enter (&most_used_symbol_type_id__volatile)) {
		GType most_used_symbol_type_id;
		most_used_symbol_type_id = g_boxed_type_register_static ("MostUsedSymbol", (GBoxedCopyFunc) most_used_symbol_dup, (GBoxedFreeFunc) most_used_symbol_free);
		g_once_init_leave (&most_used_symbol_type_id__volatile, most_used_symbol_type_id);
	}
	return most_used_symbol_type_id__volatile;
}


static AppSettings* app_settings_construct (GType object_type) {
	AppSettings * self = NULL;
	self = (AppSettings*) g_object_new (object_type, "schema", "org.gnome.latexila", NULL);
	app_settings_initialize (self);
	app_settings_load_build_tools (self);
	app_settings_load_most_used_symbols (self);
	return self;
}


static AppSettings* app_settings_new (void) {
	return app_settings_construct (TYPE_APP_SETTINGS);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


AppSettings* app_settings_get_default (void) {
	AppSettings* result = NULL;
	AppSettings* _tmp1_;
	if (app_settings_instance == NULL) {
		AppSettings* _tmp0_ = NULL;
		_tmp0_ = app_settings_new ();
		_g_object_unref0 (app_settings_instance);
		app_settings_instance = _tmp0_;
	}
	_tmp1_ = _g_object_ref0 (app_settings_instance);
	result = _tmp1_;
	return result;
}


static void _lambda6_ (GSettings* setting, const gchar* key, AppSettings* self) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (setting != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = g_settings_get_string (setting, key);
	_tmp1_ = _tmp0_;
	app_settings_set_system_font (self, _tmp1_);
	_g_free0 (_tmp1_);
	_tmp2_ = g_settings_get_boolean (self->priv->editor, "use-default-font");
	if (_tmp2_) {
		app_settings_set_font (self, self->priv->_system_font);
	}
}


static void __lambda6__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	_lambda6_ (_sender, key, self);
}


static void _lambda84_ (GSettings* setting, const gchar* key, AppSettings* self) {
	gboolean _tmp0_;
	gboolean val;
	gchar* _tmp1_ = NULL;
	gchar* _tmp4_;
	gchar* font;
	g_return_if_fail (setting != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = g_settings_get_boolean (setting, key);
	val = _tmp0_;
	if (val) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self->priv->_system_font);
		_g_free0 (_tmp1_);
		_tmp1_ = _tmp2_;
	} else {
		gchar* _tmp3_ = NULL;
		_tmp3_ = g_settings_get_string (self->priv->editor, "editor-font");
		_g_free0 (_tmp1_);
		_tmp1_ = _tmp3_;
	}
	_tmp4_ = g_strdup (_tmp1_);
	font = _tmp4_;
	app_settings_set_font (self, font);
	_g_free0 (font);
	_g_free0 (_tmp1_);
}


static void __lambda84__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	_lambda84_ (_sender, key, self);
}


static void _lambda85_ (GSettings* setting, const gchar* key, AppSettings* self) {
	gboolean _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	g_return_if_fail (setting != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = g_settings_get_boolean (self->priv->editor, "use-default-font");
	if (_tmp0_) {
		return;
	}
	_tmp1_ = g_settings_get_string (setting, key);
	_tmp2_ = _tmp1_;
	app_settings_set_font (self, _tmp2_);
	_g_free0 (_tmp2_);
}


static void __lambda85__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	_lambda85_ (_sender, key, self);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static void _lambda86_ (GSettings* setting, const gchar* key, AppSettings* self) {
	gchar* _tmp0_ = NULL;
	gchar* scheme_id;
	GtkSourceStyleSchemeManager* _tmp1_ = NULL;
	GtkSourceStyleSchemeManager* _tmp2_;
	GtkSourceStyleSchemeManager* manager;
	GtkSourceStyleScheme* _tmp3_ = NULL;
	GtkSourceStyleScheme* _tmp4_;
	GtkSourceStyleScheme* scheme;
	Application* _tmp5_ = NULL;
	Application* _tmp6_;
	GList* _tmp7_ = NULL;
	GList* _tmp8_;
	g_return_if_fail (setting != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = g_settings_get_string (setting, key);
	scheme_id = _tmp0_;
	_tmp1_ = gtk_source_style_scheme_manager_get_default ();
	_tmp2_ = _g_object_ref0 (_tmp1_);
	manager = _tmp2_;
	_tmp3_ = gtk_source_style_scheme_manager_get_scheme (manager, scheme_id);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	scheme = _tmp4_;
	_tmp5_ = application_get_default ();
	_tmp6_ = _tmp5_;
	_tmp7_ = application_get_documents (_tmp6_);
	_tmp8_ = _tmp7_;
	_g_object_unref0 (_tmp6_);
	{
		GList* doc_collection;
		GList* doc_it;
		doc_collection = _tmp8_;
		for (doc_it = doc_collection; doc_it != NULL; doc_it = doc_it->next) {
			Document* _tmp9_;
			Document* doc;
			_tmp9_ = _g_object_ref0 ((Document*) doc_it->data);
			doc = _tmp9_;
			{
				gtk_source_buffer_set_style_scheme ((GtkSourceBuffer*) doc, scheme);
				_g_object_unref0 (doc);
			}
		}
		__g_list_free__g_object_unref0_0 (doc_collection);
	}
	_g_object_unref0 (scheme);
	_g_object_unref0 (manager);
	_g_free0 (scheme_id);
}


static void __lambda86__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	_lambda86_ (_sender, key, self);
}


static void _lambda87_ (GSettings* setting, const gchar* key, AppSettings* self) {
	guint val = 0U;
	guint _tmp0_;
	Application* _tmp1_ = NULL;
	Application* _tmp2_;
	GList* _tmp3_ = NULL;
	GList* _tmp4_;
	g_return_if_fail (setting != NULL);
	g_return_if_fail (key != NULL);
	g_settings_get (setting, key, "u", &val);
	_tmp0_ = CLAMP (val, (guint) 1, (guint) 24);
	val = _tmp0_;
	_tmp1_ = application_get_default ();
	_tmp2_ = _tmp1_;
	_tmp3_ = application_get_views (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp2_);
	{
		GList* view_collection;
		GList* view_it;
		view_collection = _tmp4_;
		for (view_it = view_collection; view_it != NULL; view_it = view_it->next) {
			DocumentView* _tmp5_;
			DocumentView* view;
			_tmp5_ = _g_object_ref0 ((DocumentView*) view_it->data);
			view = _tmp5_;
			{
				gtk_source_view_set_tab_width ((GtkSourceView*) view, val);
				_g_object_unref0 (view);
			}
		}
		__g_list_free__g_object_unref0_0 (view_collection);
	}
}


static void __lambda87__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	_lambda87_ (_sender, key, self);
}


static void _lambda88_ (GSettings* setting, const gchar* key, AppSettings* self) {
	gboolean _tmp0_;
	gboolean val;
	Application* _tmp1_ = NULL;
	Application* _tmp2_;
	GList* _tmp3_ = NULL;
	GList* _tmp4_;
	g_return_if_fail (setting != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = g_settings_get_boolean (setting, key);
	val = _tmp0_;
	_tmp1_ = application_get_default ();
	_tmp2_ = _tmp1_;
	_tmp3_ = application_get_views (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp2_);
	{
		GList* view_collection;
		GList* view_it;
		view_collection = _tmp4_;
		for (view_it = view_collection; view_it != NULL; view_it = view_it->next) {
			DocumentView* _tmp5_;
			DocumentView* view;
			_tmp5_ = _g_object_ref0 ((DocumentView*) view_it->data);
			view = _tmp5_;
			{
				gtk_source_view_set_insert_spaces_instead_of_tabs ((GtkSourceView*) view, val);
				_g_object_unref0 (view);
			}
		}
		__g_list_free__g_object_unref0_0 (view_collection);
	}
}


static void __lambda88__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	_lambda88_ (_sender, key, self);
}


static void _lambda89_ (GSettings* setting, const gchar* key, AppSettings* self) {
	gboolean _tmp0_;
	gboolean val;
	Application* _tmp1_ = NULL;
	Application* _tmp2_;
	GList* _tmp3_ = NULL;
	GList* _tmp4_;
	g_return_if_fail (setting != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = g_settings_get_boolean (setting, key);
	val = _tmp0_;
	_tmp1_ = application_get_default ();
	_tmp2_ = _tmp1_;
	_tmp3_ = application_get_views (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp2_);
	{
		GList* view_collection;
		GList* view_it;
		view_collection = _tmp4_;
		for (view_it = view_collection; view_it != NULL; view_it = view_it->next) {
			DocumentView* _tmp5_;
			DocumentView* view;
			_tmp5_ = _g_object_ref0 ((DocumentView*) view_it->data);
			view = _tmp5_;
			{
				gtk_source_view_set_show_line_numbers ((GtkSourceView*) view, val);
				_g_object_unref0 (view);
			}
		}
		__g_list_free__g_object_unref0_0 (view_collection);
	}
}


static void __lambda89__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	_lambda89_ (_sender, key, self);
}


static void _lambda90_ (GSettings* setting, const gchar* key, AppSettings* self) {
	gboolean _tmp0_;
	gboolean val;
	Application* _tmp1_ = NULL;
	Application* _tmp2_;
	GList* _tmp3_ = NULL;
	GList* _tmp4_;
	g_return_if_fail (setting != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = g_settings_get_boolean (setting, key);
	val = _tmp0_;
	_tmp1_ = application_get_default ();
	_tmp2_ = _tmp1_;
	_tmp3_ = application_get_views (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp2_);
	{
		GList* view_collection;
		GList* view_it;
		view_collection = _tmp4_;
		for (view_it = view_collection; view_it != NULL; view_it = view_it->next) {
			DocumentView* _tmp5_;
			DocumentView* view;
			_tmp5_ = _g_object_ref0 ((DocumentView*) view_it->data);
			view = _tmp5_;
			{
				gtk_source_view_set_highlight_current_line ((GtkSourceView*) view, val);
				_g_object_unref0 (view);
			}
		}
		__g_list_free__g_object_unref0_0 (view_collection);
	}
}


static void __lambda90__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	_lambda90_ (_sender, key, self);
}


static void _lambda91_ (GSettings* setting, const gchar* key, AppSettings* self) {
	gboolean _tmp0_;
	gboolean val;
	Application* _tmp1_ = NULL;
	Application* _tmp2_;
	GList* _tmp3_ = NULL;
	GList* _tmp4_;
	g_return_if_fail (setting != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = g_settings_get_boolean (setting, key);
	val = _tmp0_;
	_tmp1_ = application_get_default ();
	_tmp2_ = _tmp1_;
	_tmp3_ = application_get_documents (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp2_);
	{
		GList* doc_collection;
		GList* doc_it;
		doc_collection = _tmp4_;
		for (doc_it = doc_collection; doc_it != NULL; doc_it = doc_it->next) {
			Document* _tmp5_;
			Document* doc;
			_tmp5_ = _g_object_ref0 ((Document*) doc_it->data);
			doc = _tmp5_;
			{
				gtk_source_buffer_set_highlight_matching_brackets ((GtkSourceBuffer*) doc, val);
				_g_object_unref0 (doc);
			}
		}
		__g_list_free__g_object_unref0_0 (doc_collection);
	}
}


static void __lambda91__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	_lambda91_ (_sender, key, self);
}


static void _lambda92_ (GSettings* setting, const gchar* key, AppSettings* self) {
	gboolean _tmp0_;
	gboolean val;
	Application* _tmp1_ = NULL;
	Application* _tmp2_;
	GList* _tmp3_ = NULL;
	GList* _tmp4_;
	g_return_if_fail (setting != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = g_settings_get_boolean (setting, key);
	val = _tmp0_;
	_tmp1_ = application_get_default ();
	_tmp2_ = _tmp1_;
	_tmp3_ = application_get_documents (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp2_);
	{
		GList* doc_collection;
		GList* doc_it;
		doc_collection = _tmp4_;
		for (doc_it = doc_collection; doc_it != NULL; doc_it = doc_it->next) {
			Document* _tmp5_;
			Document* doc;
			_tmp5_ = _g_object_ref0 ((Document*) doc_it->data);
			doc = _tmp5_;
			{
				document_tab_set_auto_save (doc->tab, val);
				_g_object_unref0 (doc);
			}
		}
		__g_list_free__g_object_unref0_0 (doc_collection);
	}
}


static void __lambda92__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	_lambda92_ (_sender, key, self);
}


static void _lambda93_ (GSettings* setting, const gchar* key, AppSettings* self) {
	guint val = 0U;
	Application* _tmp0_ = NULL;
	Application* _tmp1_;
	GList* _tmp2_ = NULL;
	GList* _tmp3_;
	g_return_if_fail (setting != NULL);
	g_return_if_fail (key != NULL);
	g_settings_get (setting, key, "u", &val);
	_tmp0_ = application_get_default ();
	_tmp1_ = _tmp0_;
	_tmp2_ = application_get_documents (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	{
		GList* doc_collection;
		GList* doc_it;
		doc_collection = _tmp3_;
		for (doc_it = doc_collection; doc_it != NULL; doc_it = doc_it->next) {
			Document* _tmp4_;
			Document* doc;
			_tmp4_ = _g_object_ref0 ((Document*) doc_it->data);
			doc = _tmp4_;
			{
				document_tab_set_auto_save_interval (doc->tab, val);
				_g_object_unref0 (doc);
			}
		}
		__g_list_free__g_object_unref0_0 (doc_collection);
	}
}


static void __lambda93__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	_lambda93_ (_sender, key, self);
}


static gboolean _lambda95_ (AppSettings* self) {
	gboolean result = FALSE;
	self->priv->timeout_id = (guint) 0;
	symbols_reload_most_used_symbols ();
	result = FALSE;
	return result;
}


static gboolean __lambda95__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda95_ (self);
	return result;
}


static void _lambda94_ (GSettings* setting, const gchar* key, AppSettings* self) {
	guint _tmp0_;
	g_return_if_fail (setting != NULL);
	g_return_if_fail (key != NULL);
	if (self->priv->timeout_id != 0) {
		g_source_remove (self->priv->timeout_id);
	}
	_tmp0_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, __lambda95__gsource_func, g_object_ref (self), g_object_unref);
	self->priv->timeout_id = _tmp0_;
}


static void __lambda94__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	_lambda94_ (_sender, key, self);
}


static void app_settings_initialize (AppSettings* self) {
	GSettings* _tmp0_ = NULL;
	GSettings* _tmp1_;
	GSettings* prefs;
	GSettings* _tmp2_ = NULL;
	GSettings* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_settings_get_child ((GSettings*) self, "preferences");
	_tmp1_ = _g_object_ref0 (_tmp0_);
	prefs = _tmp1_;
	_tmp2_ = g_settings_get_child (prefs, "editor");
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->priv->editor);
	self->priv->editor = _tmp3_;
	if (!DESKTOP_SCHEMAS) {
		app_settings_set_system_font (self, "Monospace 10");
	} else {
		GSettings* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		_tmp4_ = g_settings_new ("org.gnome.desktop.interface");
		_g_object_unref0 (self->priv->desktop_interface);
		self->priv->desktop_interface = _tmp4_;
		_tmp5_ = g_settings_get_string (self->priv->desktop_interface, "monospace-font-name");
		_tmp6_ = _tmp5_;
		app_settings_set_system_font (self, _tmp6_);
		_g_free0 (_tmp6_);
		g_signal_connect_object (self->priv->desktop_interface, "changed::monospace-font-name", (GCallback) __lambda6__g_settings_changed, self, 0);
	}
	g_signal_connect_object (self->priv->editor, "changed::use-default-font", (GCallback) __lambda84__g_settings_changed, self, 0);
	g_signal_connect_object (self->priv->editor, "changed::editor-font", (GCallback) __lambda85__g_settings_changed, self, 0);
	g_signal_connect_object (self->priv->editor, "changed::scheme", (GCallback) __lambda86__g_settings_changed, self, 0);
	g_signal_connect_object (self->priv->editor, "changed::tabs-size", (GCallback) __lambda87__g_settings_changed, self, 0);
	g_signal_connect_object (self->priv->editor, "changed::insert-spaces", (GCallback) __lambda88__g_settings_changed, self, 0);
	g_signal_connect_object (self->priv->editor, "changed::display-line-numbers", (GCallback) __lambda89__g_settings_changed, self, 0);
	g_signal_connect_object (self->priv->editor, "changed::highlight-current-line", (GCallback) __lambda90__g_settings_changed, self, 0);
	g_signal_connect_object (self->priv->editor, "changed::bracket-matching", (GCallback) __lambda91__g_settings_changed, self, 0);
	g_signal_connect_object (self->priv->editor, "changed::auto-save", (GCallback) __lambda92__g_settings_changed, self, 0);
	g_signal_connect_object (self->priv->editor, "changed::auto-save-interval", (GCallback) __lambda93__g_settings_changed, self, 0);
	g_signal_connect_object (self->priv->editor, "changed::nb-most-used-symbols", (GCallback) __lambda94__g_settings_changed, self, 0);
	_g_object_unref0 (prefs);
}


static void app_settings_set_font (AppSettings* self, const gchar* font) {
	Application* _tmp0_ = NULL;
	Application* _tmp1_;
	GList* _tmp2_ = NULL;
	GList* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (font != NULL);
	_tmp0_ = application_get_default ();
	_tmp1_ = _tmp0_;
	_tmp2_ = application_get_views (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	{
		GList* view_collection;
		GList* view_it;
		view_collection = _tmp3_;
		for (view_it = view_collection; view_it != NULL; view_it = view_it->next) {
			DocumentView* _tmp4_;
			DocumentView* view;
			_tmp4_ = _g_object_ref0 ((DocumentView*) view_it->data);
			view = _tmp4_;
			{
				document_view_set_font_from_string (view, font);
				_g_object_unref0 (view);
			}
		}
		__g_list_free__g_object_unref0_0 (view_collection);
	}
}


GeeList* app_settings_get_most_used_symbols (AppSettings* self) {
	GeeList* result = NULL;
	gint _tmp0_;
	gint max;
	gint _tmp1_;
	gint _tmp2_;
	GeeList* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_settings_get_int (self->priv->editor, "nb-most-used-symbols");
	max = _tmp0_;
	_tmp1_ = gee_collection_get_size ((GeeCollection*) self->priv->most_used_symbols);
	_tmp2_ = MIN (max, _tmp1_);
	_tmp3_ = gee_abstract_list_slice ((GeeAbstractList*) self->priv->most_used_symbols, 0, _tmp2_);
	result = _tmp3_;
	return result;
}


void app_settings_clear_most_used_symbols (AppSettings* self) {
	g_return_if_fail (self != NULL);
	self->priv->mus_modified = TRUE;
	gee_abstract_collection_clear ((GeeAbstractCollection*) self->priv->most_used_symbols);
}


void app_settings_add_symbol (AppSettings* self, const gchar* id, const gchar* command, const gchar* package) {
	gint _tmp0_;
	gint max;
	gint i;
	MostUsedSymbol new_symbol = {0};
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gint _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (id != NULL);
	g_return_if_fail (command != NULL);
	self->priv->mus_modified = TRUE;
	_tmp0_ = g_settings_get_int (self->priv->editor, "nb-most-used-symbols");
	max = _tmp0_;
	i = 0;
	{
		GeeLinkedList* _tmp1_;
		GeeLinkedList* _mus_list;
		gint _tmp2_;
		gint _mus_size;
		gint _mus_index;
		_tmp1_ = _g_object_ref0 (self->priv->most_used_symbols);
		_mus_list = _tmp1_;
		_tmp2_ = gee_collection_get_size ((GeeCollection*) _mus_list);
		_mus_size = _tmp2_;
		_mus_index = -1;
		while (TRUE) {
			gpointer _tmp3_ = NULL;
			MostUsedSymbol* _tmp4_;
			MostUsedSymbol _tmp5_;
			MostUsedSymbol _tmp6_ = {0};
			MostUsedSymbol _tmp7_;
			MostUsedSymbol mus;
			_mus_index = _mus_index + 1;
			if (!(_mus_index < _mus_size)) {
				break;
			}
			_tmp3_ = gee_abstract_list_get ((GeeAbstractList*) _mus_list, _mus_index);
			_tmp4_ = (MostUsedSymbol*) _tmp3_;
			most_used_symbol_copy (_tmp4_, &_tmp6_);
			_tmp5_ = _tmp6_;
			_tmp7_ = _tmp5_;
			_most_used_symbol_free0 (_tmp4_);
			mus = _tmp7_;
			if (g_strcmp0 (mus.id, id) == 0) {
				gint _tmp8_;
				gint new_i;
				gboolean _tmp9_ = FALSE;
				mus.num++;
				_tmp8_ = app_settings_sort_most_used_symbol (self, i, &mus);
				new_i = _tmp8_;
				if (new_i != i) {
					_tmp9_ = new_i < max;
				} else {
					_tmp9_ = FALSE;
				}
				if (_tmp9_) {
					if (i >= max) {
						symbols_remove_most_used_symbol (max - 1);
						symbols_insert_most_used_symbol (new_i, &mus);
					} else {
						symbols_swap_most_used_symbol (i, new_i);
					}
				}
				most_used_symbol_destroy (&mus);
				_g_object_unref0 (_mus_list);
				return;
			}
			i++;
			most_used_symbol_destroy (&mus);
		}
		_g_object_unref0 (_mus_list);
	}
	memset (&new_symbol, 0, sizeof (MostUsedSymbol));
	_tmp10_ = g_strdup (id);
	_g_free0 (new_symbol.id);
	new_symbol.id = _tmp10_;
	_tmp11_ = g_strdup (command);
	_g_free0 (new_symbol.latex_command);
	new_symbol.latex_command = _tmp11_;
	_tmp12_ = g_strdup (package);
	_g_free0 (new_symbol.package_required);
	new_symbol.package_required = _tmp12_;
	new_symbol.num = (guint) 1;
	gee_abstract_collection_add ((GeeAbstractCollection*) self->priv->most_used_symbols, &new_symbol);
	_tmp13_ = gee_collection_get_size ((GeeCollection*) self->priv->most_used_symbols);
	if (_tmp13_ <= max) {
		gint _tmp14_;
		_tmp14_ = gee_collection_get_size ((GeeCollection*) self->priv->most_used_symbols);
		symbols_insert_most_used_symbol (_tmp14_ - 1, &new_symbol);
	}
	most_used_symbol_destroy (&new_symbol);
}


static gint app_settings_sort_most_used_symbol (AppSettings* self, gint index, MostUsedSymbol* mus) {
	gint result = 0;
	gint new_index = 0;
	g_return_val_if_fail (self != NULL, 0);
	if (index == 0) {
		gee_abstract_list_set ((GeeAbstractList*) self->priv->most_used_symbols, index, mus);
		result = 0;
		return result;
	}
	{
		gboolean _tmp0_;
		new_index = index - 1;
		_tmp0_ = TRUE;
		while (TRUE) {
			gpointer _tmp1_ = NULL;
			MostUsedSymbol* _tmp2_;
			MostUsedSymbol _tmp3_;
			MostUsedSymbol _tmp4_ = {0};
			MostUsedSymbol _tmp5_;
			MostUsedSymbol symbol;
			if (!_tmp0_) {
				new_index--;
			}
			_tmp0_ = FALSE;
			if (!(new_index >= 0)) {
				break;
			}
			_tmp1_ = gee_abstract_list_get ((GeeAbstractList*) self->priv->most_used_symbols, new_index);
			_tmp2_ = (MostUsedSymbol*) _tmp1_;
			most_used_symbol_copy (_tmp2_, &_tmp4_);
			_tmp3_ = _tmp4_;
			_tmp5_ = _tmp3_;
			_most_used_symbol_free0 (_tmp2_);
			symbol = _tmp5_;
			if (symbol.num >= (*mus).num) {
				new_index++;
				most_used_symbol_destroy (&symbol);
				break;
			}
			most_used_symbol_destroy (&symbol);
		}
	}
	if (new_index < 0) {
		new_index = 0;
	}
	if (new_index < index) {
		gpointer _tmp6_ = NULL;
		MostUsedSymbol* _tmp7_;
		_tmp6_ = gee_abstract_list_remove_at ((GeeAbstractList*) self->priv->most_used_symbols, index);
		_tmp7_ = (MostUsedSymbol*) _tmp6_;
		_most_used_symbol_free0 (_tmp7_);
		gee_abstract_list_insert ((GeeAbstractList*) self->priv->most_used_symbols, new_index, mus);
	} else {
		gee_abstract_list_set ((GeeAbstractList*) self->priv->most_used_symbols, index, mus);
	}
	result = new_index;
	return result;
}


static void _app_settings_mus_parser_start_gmarkup_parser_start_element_func (GMarkupParseContext* context, const gchar* element_name, gchar** attribute_names, gchar** attribute_values, gpointer self, GError** error) {
	app_settings_mus_parser_start (self, context, element_name, attribute_names, _vala_array_length (attribute_names), attribute_values, _vala_array_length (attribute_values), error);
}


static void app_settings_load_most_used_symbols (AppSettings* self) {
	GeeLinkedList* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* file;
	gboolean _tmp2_;
	gchar* contents = NULL;
	gchar* _tmp3_ = NULL;
	GMarkupParser _tmp4_ = {0};
	GMarkupParser parser;
	GMarkupParseContext* _tmp5_ = NULL;
	GMarkupParseContext* context;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_linked_list_new (TYPE_MOST_USED_SYMBOL, (GBoxedCopyFunc) most_used_symbol_dup, most_used_symbol_free, NULL);
	_g_object_unref0 (self->priv->most_used_symbols);
	self->priv->most_used_symbols = _tmp0_;
	_tmp1_ = app_settings_get_file_most_used_symbols (self);
	file = _tmp1_;
	_tmp2_ = g_file_query_exists (file, NULL);
	if (!_tmp2_) {
		_g_object_unref0 (file);
		return;
	}
	g_file_load_contents (file, NULL, &_tmp3_, NULL, NULL, &_inner_error_);
	_g_free0 (contents);
	contents = _tmp3_;
	if (_inner_error_ != NULL) {
		_g_free0 (contents);
		goto __catch19_g_error;
	}
	_tmp4_.start_element = _app_settings_mus_parser_start_gmarkup_parser_start_element_func;
	_tmp4_.end_element = NULL;
	_tmp4_.text = NULL;
	_tmp4_.passthrough = NULL;
	_tmp4_.error = NULL;
	parser = _tmp4_;
	_tmp5_ = g_markup_parse_context_new (&parser, 0, self, NULL);
	context = _tmp5_;
	g_markup_parse_context_parse (context, contents, (gssize) (-1), &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_markup_parse_context_free0 (context);
		_g_free0 (contents);
		goto __catch19_g_error;
	}
	_g_markup_parse_context_free0 (context);
	_g_free0 (contents);
	goto __finally19;
	__catch19_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		fprintf (stderr, "Warning: impossible to load most used symbols: %s\n", e->message);
		_g_error_free0 (e);
	}
	__finally19:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (file);
}


static void app_settings_mus_parser_start (AppSettings* self, GMarkupParseContext* context, const gchar* name, gchar** attr_names, int attr_names_length1, gchar** attr_values, int attr_values_length1, GError** error) {
	const gchar* _tmp0_;
	GQuark _tmp1_;
	static GQuark _tmp1__label0 = 0;
	static GQuark _tmp1__label1 = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = name;
	_tmp1_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp1_ == ((0 != _tmp1__label0) ? _tmp1__label0 : (_tmp1__label0 = g_quark_from_static_string ("symbols")))) {
		switch (0) {
			default:
			{
				return;
			}
		}
	} else if (_tmp1_ == ((0 != _tmp1__label1) ? _tmp1__label1 : (_tmp1__label1 = g_quark_from_static_string ("symbol")))) {
		switch (0) {
			default:
			{
				MostUsedSymbol symbol = {0};
				memset (&symbol, 0, sizeof (MostUsedSymbol));
				{
					gint i;
					i = 0;
					{
						gboolean _tmp2_;
						_tmp2_ = TRUE;
						while (TRUE) {
							const gchar* _tmp3_;
							GQuark _tmp4_;
							static GQuark _tmp4__label0 = 0;
							static GQuark _tmp4__label1 = 0;
							static GQuark _tmp4__label2 = 0;
							static GQuark _tmp4__label3 = 0;
							if (!_tmp2_) {
								i++;
							}
							_tmp2_ = FALSE;
							if (!(i < attr_names_length1)) {
								break;
							}
							_tmp3_ = attr_names[i];
							_tmp4_ = (NULL == _tmp3_) ? 0 : g_quark_from_string (_tmp3_);
							if (_tmp4_ == ((0 != _tmp4__label0) ? _tmp4__label0 : (_tmp4__label0 = g_quark_from_static_string ("id")))) {
								switch (0) {
									default:
									{
										gchar* _tmp5_;
										_tmp5_ = g_strdup (attr_values[i]);
										_g_free0 (symbol.id);
										symbol.id = _tmp5_;
										break;
									}
								}
							} else if (_tmp4_ == ((0 != _tmp4__label1) ? _tmp4__label1 : (_tmp4__label1 = g_quark_from_static_string ("command")))) {
								switch (0) {
									default:
									{
										gchar* _tmp6_;
										_tmp6_ = g_strdup (attr_values[i]);
										_g_free0 (symbol.latex_command);
										symbol.latex_command = _tmp6_;
										break;
									}
								}
							} else if (_tmp4_ == ((0 != _tmp4__label2) ? _tmp4__label2 : (_tmp4__label2 = g_quark_from_static_string ("package")))) {
								switch (0) {
									default:
									{
										const gchar* _tmp7_ = NULL;
										gchar* _tmp8_;
										if (g_strcmp0 (attr_values[i], "") != 0) {
											_tmp7_ = attr_values[i];
										} else {
											_tmp7_ = NULL;
										}
										_tmp8_ = g_strdup (_tmp7_);
										_g_free0 (symbol.package_required);
										symbol.package_required = _tmp8_;
										break;
									}
								}
							} else if (_tmp4_ == ((0 != _tmp4__label3) ? _tmp4__label3 : (_tmp4__label3 = g_quark_from_static_string ("num")))) {
								switch (0) {
									default:
									{
										gint _tmp9_;
										_tmp9_ = atoi (attr_values[i]);
										symbol.num = (guint) _tmp9_;
										break;
									}
								}
							} else {
								switch (0) {
									default:
									{
										gchar* _tmp10_;
										gchar* _tmp11_;
										gchar* _tmp12_;
										gchar* _tmp13_;
										GError* _tmp14_ = NULL;
										GError* _tmp15_;
										_tmp10_ = g_strconcat ("unknown attribute \"", attr_names[i], NULL);
										_tmp11_ = _tmp10_;
										_tmp12_ = g_strconcat (_tmp11_, "\"", NULL);
										_tmp13_ = _tmp12_;
										_tmp14_ = g_error_new_literal (G_MARKUP_ERROR, G_MARKUP_ERROR_UNKNOWN_ATTRIBUTE, _tmp13_);
										_tmp15_ = _tmp14_;
										_g_free0 (_tmp13_);
										_g_free0 (_tmp11_);
										_inner_error_ = _tmp15_;
										if (_inner_error_->domain == G_MARKUP_ERROR) {
											g_propagate_error (error, _inner_error_);
											most_used_symbol_destroy (&symbol);
											return;
										} else {
											most_used_symbol_destroy (&symbol);
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
											g_clear_error (&_inner_error_);
											return;
										}
									}
								}
							}
						}
					}
				}
				gee_abstract_collection_add ((GeeAbstractCollection*) self->priv->most_used_symbols, &symbol);
				most_used_symbol_destroy (&symbol);
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				gchar* _tmp16_;
				gchar* _tmp17_;
				gchar* _tmp18_;
				gchar* _tmp19_;
				GError* _tmp20_ = NULL;
				GError* _tmp21_;
				_tmp16_ = g_strconcat ("unknown element \"", name, NULL);
				_tmp17_ = _tmp16_;
				_tmp18_ = g_strconcat (_tmp17_, "\"", NULL);
				_tmp19_ = _tmp18_;
				_tmp20_ = g_error_new_literal (G_MARKUP_ERROR, G_MARKUP_ERROR_UNKNOWN_ELEMENT, _tmp19_);
				_tmp21_ = _tmp20_;
				_g_free0 (_tmp19_);
				_g_free0 (_tmp17_);
				_inner_error_ = _tmp21_;
				if (_inner_error_->domain == G_MARKUP_ERROR) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
	}
}


static GFile* app_settings_get_file_most_used_symbols (AppSettings* self) {
	GFile* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* path;
	GFile* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_get_user_data_dir ();
	_tmp1_ = g_build_filename (_tmp0_, "latexila", "most_used_symbols.xml", NULL, NULL);
	path = _tmp1_;
	_tmp2_ = g_file_new_for_path (path);
	result = _tmp2_;
	_g_free0 (path);
	return result;
}


void app_settings_save_most_used_symbols (AppSettings* self) {
	GFile* _tmp0_ = NULL;
	GFile* file;
	gint _tmp1_;
	gchar* _tmp2_;
	gchar* content;
	gchar* _tmp16_;
	GFile* _tmp17_ = NULL;
	GFile* parent;
	gboolean _tmp18_ = FALSE;
	gsize _tmp20_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	if (!self->priv->mus_modified) {
		return;
	}
	_tmp0_ = app_settings_get_file_most_used_symbols (self);
	file = _tmp0_;
	_tmp1_ = gee_collection_get_size ((GeeCollection*) self->priv->most_used_symbols);
	if (_tmp1_ == 0) {
		utils_delete_file (file);
		_g_object_unref0 (file);
		return;
	}
	_tmp2_ = g_strdup ("<symbols>\n");
	content = _tmp2_;
	{
		GeeLinkedList* _tmp3_;
		GeeLinkedList* _symbol_list;
		gint _tmp4_;
		gint _symbol_size;
		gint _symbol_index;
		_tmp3_ = _g_object_ref0 (self->priv->most_used_symbols);
		_symbol_list = _tmp3_;
		_tmp4_ = gee_collection_get_size ((GeeCollection*) _symbol_list);
		_symbol_size = _tmp4_;
		_symbol_index = -1;
		while (TRUE) {
			gpointer _tmp5_ = NULL;
			MostUsedSymbol* _tmp6_;
			MostUsedSymbol _tmp7_;
			MostUsedSymbol _tmp8_ = {0};
			MostUsedSymbol _tmp9_;
			MostUsedSymbol symbol;
			gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp13_ = NULL;
			gchar* _tmp14_;
			gchar* _tmp15_;
			_symbol_index = _symbol_index + 1;
			if (!(_symbol_index < _symbol_size)) {
				break;
			}
			_tmp5_ = gee_abstract_list_get ((GeeAbstractList*) _symbol_list, _symbol_index);
			_tmp6_ = (MostUsedSymbol*) _tmp5_;
			most_used_symbol_copy (_tmp6_, &_tmp8_);
			_tmp7_ = _tmp8_;
			_tmp9_ = _tmp7_;
			_most_used_symbol_free0 (_tmp6_);
			symbol = _tmp9_;
			_tmp10_ = g_strdup (symbol.package_required);
			_tmp11_ = _tmp10_;
			if (_tmp11_ == NULL) {
				gchar* _tmp12_;
				_tmp12_ = g_strdup ("");
				_g_free0 (_tmp11_);
				_tmp11_ = _tmp12_;
			}
			_tmp13_ = g_strdup_printf ("  <symbol id=\"%s\" command=\"%s\" package=\"%s\" num=\"%u\" />\n", symbol.id, symbol.latex_command, _tmp11_, symbol.num);
			_tmp14_ = _tmp13_;
			_tmp15_ = g_strconcat (content, _tmp14_, NULL);
			_g_free0 (content);
			content = _tmp15_;
			_g_free0 (_tmp14_);
			_g_free0 (_tmp11_);
			most_used_symbol_destroy (&symbol);
		}
		_g_object_unref0 (_symbol_list);
	}
	_tmp16_ = g_strconcat (content, "</symbols>\n", NULL);
	_g_free0 (content);
	content = _tmp16_;
	_tmp17_ = g_file_get_parent (file);
	parent = _tmp17_;
	if (parent != NULL) {
		gboolean _tmp19_;
		_tmp19_ = g_file_query_exists (parent, NULL);
		_tmp18_ = !_tmp19_;
	} else {
		_tmp18_ = FALSE;
	}
	if (_tmp18_) {
		g_file_make_directory_with_parents (parent, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (parent);
			goto __catch20_g_error;
		}
	}
	_tmp20_ = strlen (content);
	g_file_replace_contents (file, content, _tmp20_, NULL, FALSE, G_FILE_CREATE_NONE, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_object_unref0 (parent);
		goto __catch20_g_error;
	}
	_g_object_unref0 (parent);
	goto __finally20;
	__catch20_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		fprintf (stderr, "Warning: impossible to save most used symbols: %s\n", e->message);
		_g_error_free0 (e);
	}
	__finally20:
	if (_inner_error_ != NULL) {
		_g_free0 (content);
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (content);
	_g_object_unref0 (file);
}


GeeLinkedList* app_settings_get_build_tools (AppSettings* self) {
	GeeLinkedList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->build_tools;
	return result;
}


void app_settings_move_build_tool_up (AppSettings* self, gint num) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (num > 0);
	app_settings_swap_build_tools (self, num, num - 1);
}


void app_settings_move_build_tool_down (AppSettings* self, gint num) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_collection_get_size ((GeeCollection*) self->priv->build_tools);
	g_return_if_fail (num < (_tmp0_ - 1));
	app_settings_swap_build_tools (self, num, num + 1);
}


static void app_settings_swap_build_tools (AppSettings* self, gint num1, gint num2) {
	gpointer _tmp0_ = NULL;
	BuildTool* _tmp1_;
	BuildTool _tmp2_;
	BuildTool _tmp3_ = {0};
	BuildTool _tmp4_;
	BuildTool tool;
	gpointer _tmp5_ = NULL;
	BuildTool* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (self->priv->build_tools != NULL);
	_tmp0_ = gee_abstract_list_get ((GeeAbstractList*) self->priv->build_tools, num1);
	_tmp1_ = (BuildTool*) _tmp0_;
	build_tool_copy (_tmp1_, &_tmp3_);
	_tmp2_ = _tmp3_;
	_tmp4_ = _tmp2_;
	_build_tool_free0 (_tmp1_);
	tool = _tmp4_;
	_tmp5_ = gee_abstract_list_remove_at ((GeeAbstractList*) self->priv->build_tools, num1);
	_tmp6_ = (BuildTool*) _tmp5_;
	_build_tool_free0 (_tmp6_);
	gee_abstract_list_insert ((GeeAbstractList*) self->priv->build_tools, num2, &tool);
	app_settings_update_all_build_tools_menu (self);
	build_tool_destroy (&tool);
}


void app_settings_delete_build_tool (AppSettings* self, gint num) {
	gboolean _tmp0_ = FALSE;
	gpointer _tmp2_ = NULL;
	BuildTool* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (self->priv->build_tools != NULL);
	if (num >= 0) {
		gint _tmp1_;
		_tmp1_ = gee_collection_get_size ((GeeCollection*) self->priv->build_tools);
		_tmp0_ = num < _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	g_return_if_fail (_tmp0_);
	_tmp2_ = gee_abstract_list_remove_at ((GeeAbstractList*) self->priv->build_tools, num);
	_tmp3_ = (BuildTool*) _tmp2_;
	_build_tool_free0 (_tmp3_);
	app_settings_update_all_build_tools_menu (self);
}


void app_settings_append_build_tool (AppSettings* self, BuildTool* tool) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (self->priv->build_tools != NULL);
	_tmp0_ = app_settings_is_compilation (self, (*tool).icon);
	(*tool).compilation = _tmp0_;
	gee_abstract_collection_add ((GeeAbstractCollection*) self->priv->build_tools, tool);
	app_settings_update_all_build_tools_menu (self);
}


void app_settings_update_build_tool (AppSettings* self, gint num, BuildTool* tool) {
	gboolean _tmp0_ = FALSE;
	gpointer _tmp2_ = NULL;
	BuildTool* _tmp3_;
	BuildTool _tmp4_;
	BuildTool _tmp5_ = {0};
	BuildTool _tmp6_;
	BuildTool current_tool;
	gboolean _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (self->priv->build_tools != NULL);
	if (num >= 0) {
		gint _tmp1_;
		_tmp1_ = gee_collection_get_size ((GeeCollection*) self->priv->build_tools);
		_tmp0_ = num < _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	g_return_if_fail (_tmp0_);
	_tmp2_ = gee_abstract_list_get ((GeeAbstractList*) self->priv->build_tools, num);
	_tmp3_ = (BuildTool*) _tmp2_;
	build_tool_copy (_tmp3_, &_tmp5_);
	_tmp4_ = _tmp5_;
	_tmp6_ = _tmp4_;
	_build_tool_free0 (_tmp3_);
	current_tool = _tmp6_;
	_tmp7_ = app_settings_is_build_tools_equal (self, &current_tool, tool);
	if (!_tmp7_) {
		gboolean _tmp8_;
		gpointer _tmp9_ = NULL;
		BuildTool* _tmp10_;
		_tmp8_ = app_settings_is_compilation (self, (*tool).icon);
		(*tool).compilation = _tmp8_;
		_tmp9_ = gee_abstract_list_remove_at ((GeeAbstractList*) self->priv->build_tools, num);
		_tmp10_ = (BuildTool*) _tmp9_;
		_build_tool_free0 (_tmp10_);
		gee_abstract_list_insert ((GeeAbstractList*) self->priv->build_tools, num, tool);
		app_settings_update_all_build_tools_menu (self);
	}
	build_tool_destroy (&current_tool);
}


void app_settings_reset_all_build_tools (AppSettings* self) {
	GFile* _tmp0_ = NULL;
	GFile* file;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = app_settings_get_user_config_build_tools_file (self);
	file = _tmp0_;
	_tmp1_ = g_file_query_exists (file, NULL);
	if (_tmp1_) {
		utils_delete_file (file);
	}
	app_settings_load_build_tools (self);
	app_settings_update_all_build_tools_menu (self);
	_g_object_unref0 (file);
}


static gboolean app_settings_is_build_tools_equal (AppSettings* self, BuildTool* tool1, BuildTool* tool2) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (g_strcmp0 ((*tool1).label, (*tool2).label) != 0) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = g_strcmp0 ((*tool1).description, (*tool2).description) != 0;
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = g_strcmp0 ((*tool1).extensions, (*tool2).extensions) != 0;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = g_strcmp0 ((*tool1).icon, (*tool2).icon) != 0;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		guint _tmp4_;
		guint _tmp5_;
		_tmp4_ = g_list_length ((*tool1).jobs);
		_tmp5_ = g_list_length ((*tool2).jobs);
		_tmp0_ = _tmp4_ != _tmp5_;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	{
		guint i;
		i = (guint) 0;
		{
			gboolean _tmp6_;
			_tmp6_ = TRUE;
			while (TRUE) {
				guint _tmp7_;
				gconstpointer _tmp8_ = NULL;
				BuildJob _tmp9_;
				BuildJob _tmp10_ = {0};
				BuildJob job1;
				gconstpointer _tmp11_ = NULL;
				BuildJob _tmp12_;
				BuildJob _tmp13_ = {0};
				BuildJob job2;
				gboolean _tmp14_ = FALSE;
				gboolean _tmp15_ = FALSE;
				if (!_tmp6_) {
					i++;
				}
				_tmp6_ = FALSE;
				_tmp7_ = g_list_length ((*tool1).jobs);
				if (!(i < _tmp7_)) {
					break;
				}
				_tmp8_ = g_list_nth_data ((*tool1).jobs, i);
				build_job_copy ((BuildJob*) _tmp8_, &_tmp10_);
				_tmp9_ = _tmp10_;
				job1 = _tmp9_;
				_tmp11_ = g_list_nth_data ((*tool2).jobs, i);
				build_job_copy ((BuildJob*) _tmp11_, &_tmp13_);
				_tmp12_ = _tmp13_;
				job2 = _tmp12_;
				if (g_strcmp0 (job1.command, job2.command) != 0) {
					_tmp15_ = TRUE;
				} else {
					_tmp15_ = job1.must_succeed != job2.must_succeed;
				}
				if (_tmp15_) {
					_tmp14_ = TRUE;
				} else {
					_tmp14_ = g_strcmp0 (job1.post_processor, job2.post_processor) != 0;
				}
				if (_tmp14_) {
					result = FALSE;
					build_job_destroy (&job2);
					build_job_destroy (&job1);
					return result;
				}
				build_job_destroy (&job2);
				build_job_destroy (&job1);
			}
		}
	}
	result = TRUE;
	return result;
}


static void app_settings_update_all_build_tools_menu (AppSettings* self) {
	Application* _tmp0_ = NULL;
	Application* _tmp1_;
	GList* _tmp2_ = NULL;
	GList* _tmp3_;
	g_return_if_fail (self != NULL);
	self->priv->build_tools_modified = TRUE;
	_tmp0_ = application_get_default ();
	_tmp1_ = _tmp0_;
	_tmp2_ = application_get_windows (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	{
		GList* window_collection;
		GList* window_it;
		window_collection = _tmp3_;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			MainWindow* _tmp4_;
			MainWindow* window;
			_tmp4_ = _g_object_ref0 ((MainWindow*) window_it->data);
			window = _tmp4_;
			{
				main_window_update_build_tools_menu (window);
				_g_object_unref0 (window);
			}
		}
	}
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}


static gboolean app_settings_is_compilation (AppSettings* self, const gchar* icon) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (icon != NULL, FALSE);
	_tmp2_ = string_contains (icon, "compile");
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = g_strcmp0 (icon, GTK_STOCK_EXECUTE) == 0;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (icon, GTK_STOCK_CONVERT) == 0;
	}
	result = _tmp0_;
	return result;
}


static void _vala_array_add8 (GFile*** array, int* length, int* size, GFile* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GFile*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add9 (GFile*** array, int* length, int* size, GFile* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GFile*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add10 (GFile*** array, int* length, int* size, GFile* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GFile*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _app_settings_parser_start_gmarkup_parser_start_element_func (GMarkupParseContext* context, const gchar* element_name, gchar** attribute_names, gchar** attribute_values, gpointer self, GError** error) {
	app_settings_parser_start (self, context, element_name, attribute_names, _vala_array_length (attribute_names), attribute_values, _vala_array_length (attribute_values), error);
}


static void _app_settings_parser_end_gmarkup_parser_end_element_func (GMarkupParseContext* context, const gchar* element_name, gpointer self, GError** error) {
	app_settings_parser_end (self, context, element_name, error);
}


static void _app_settings_parser_text_gmarkup_parser_text_func (GMarkupParseContext* context, const gchar* text, gsize text_len, gpointer self, GError** error) {
	app_settings_parser_text (self, context, text, text_len, error);
}


static void app_settings_load_build_tools (AppSettings* self) {
	GeeLinkedList* _tmp0_ = NULL;
	GFile** _tmp1_ = NULL;
	GFile** files;
	gint files_length1;
	gint _files_size_;
	GFile* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	GFile* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	GFile* _tmp9_ = NULL;
	GFile* _tmp10_;
	GFile* default_file;
	gboolean _tmp11_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_linked_list_new (TYPE_BUILD_TOOL, (GBoxedCopyFunc) build_tool_dup, build_tool_free, NULL);
	_g_object_unref0 (self->priv->build_tools);
	self->priv->build_tools = _tmp0_;
	_tmp1_ = g_new0 (GFile*, 0 + 1);
	files = _tmp1_;
	files_length1 = 0;
	_files_size_ = 0;
	_tmp2_ = app_settings_get_user_config_build_tools_file (self);
	_vala_array_add8 (&files, &files_length1, &_files_size_, _tmp2_);
	_tmp3_ = _ ("build_tools-en.xml");
	_tmp4_ = g_build_filename (DATA_DIR, "build_tools", _tmp3_, NULL, NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_file_new_for_path (_tmp5_);
	_vala_array_add9 (&files, &files_length1, &_files_size_, _tmp6_);
	_g_free0 (_tmp5_);
	_tmp7_ = g_build_filename (DATA_DIR, "build_tools", "build_tools-en.xml", NULL, NULL);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_file_new_for_path (_tmp8_);
	_tmp10_ = _tmp9_;
	_g_free0 (_tmp8_);
	default_file = _tmp10_;
	_tmp11_ = g_file_equal (default_file, files[1]);
	if (!_tmp11_) {
		GFile* _tmp12_;
		_tmp12_ = _g_object_ref0 (default_file);
		_vala_array_add10 (&files, &files_length1, &_files_size_, _tmp12_);
	}
	{
		GFile** file_collection;
		int file_collection_length1;
		int file_it;
		file_collection = files;
		file_collection_length1 = files_length1;
		for (file_it = 0; file_it < files_length1; file_it = file_it + 1) {
			GFile* _tmp13_;
			GFile* file;
			_tmp13_ = _g_object_ref0 (file_collection[file_it]);
			file = _tmp13_;
			{
				gboolean _tmp14_;
				gchar* contents = NULL;
				gchar* _tmp15_ = NULL;
				GMarkupParser _tmp16_ = {0};
				GMarkupParser parser;
				GMarkupParseContext* _tmp17_ = NULL;
				GMarkupParseContext* context;
				_tmp14_ = g_file_query_exists (file, NULL);
				if (!_tmp14_) {
					_g_object_unref0 (file);
					continue;
				}
				g_file_load_contents (file, NULL, &_tmp15_, NULL, NULL, &_inner_error_);
				_g_free0 (contents);
				contents = _tmp15_;
				if (_inner_error_ != NULL) {
					_g_free0 (contents);
					goto __catch21_g_error;
				}
				_tmp16_.start_element = _app_settings_parser_start_gmarkup_parser_start_element_func;
				_tmp16_.end_element = _app_settings_parser_end_gmarkup_parser_end_element_func;
				_tmp16_.text = _app_settings_parser_text_gmarkup_parser_text_func;
				_tmp16_.passthrough = NULL;
				_tmp16_.error = NULL;
				parser = _tmp16_;
				_tmp17_ = g_markup_parse_context_new (&parser, 0, self, NULL);
				context = _tmp17_;
				g_markup_parse_context_parse (context, contents, (gssize) (-1), &_inner_error_);
				if (_inner_error_ != NULL) {
					_g_markup_parse_context_free0 (context);
					_g_free0 (contents);
					goto __catch21_g_error;
				}
				_g_markup_parse_context_free0 (context);
				_g_free0 (contents);
				_g_object_unref0 (file);
				break;
				_g_markup_parse_context_free0 (context);
				_g_free0 (contents);
				goto __finally21;
				__catch21_g_error:
				{
					GError * e;
					e = _inner_error_;
					_inner_error_ = NULL;
					fprintf (stderr, "Warning: impossible to load build tools: %s\n", e->message);
					_g_error_free0 (e);
				}
				__finally21:
				if (_inner_error_ != NULL) {
					_g_object_unref0 (file);
					_g_object_unref0 (default_file);
					files = (_vala_array_free (files, files_length1, (GDestroyNotify) g_object_unref), NULL);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				_g_object_unref0 (file);
			}
		}
	}
	_g_object_unref0 (default_file);
	files = (_vala_array_free (files, files_length1, (GDestroyNotify) g_object_unref), NULL);
}


static gboolean string_to_bool (const gchar* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (g_strcmp0 (self, "true") == 0) {
		result = TRUE;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}


static void app_settings_parser_start (AppSettings* self, GMarkupParseContext* context, const gchar* name, gchar** attr_names, int attr_names_length1, gchar** attr_values, int attr_values_length1, GError** error) {
	const gchar* _tmp0_;
	GQuark _tmp1_;
	static GQuark _tmp1__label0 = 0;
	static GQuark _tmp1__label1 = 0;
	static GQuark _tmp1__label2 = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = name;
	_tmp1_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp1_ == ((0 != _tmp1__label0) ? _tmp1__label0 : (_tmp1__label0 = g_quark_from_static_string ("tools")))) {
		switch (0) {
			default:
			{
				return;
			}
		}
	} else if (_tmp1_ == ((0 != _tmp1__label1) ? _tmp1__label1 : (_tmp1__label1 = g_quark_from_static_string ("tool")))) {
		switch (0) {
			default:
			{
				BuildTool _tmp2_ = {0};
				BuildTool _tmp3_ = {0};
				memset (&_tmp2_, 0, sizeof (BuildTool));
				_tmp3_ = _tmp2_;
				build_tool_destroy (&self->priv->current_build_tool);
				self->priv->current_build_tool = _tmp3_;
				self->priv->current_build_tool.compilation = FALSE;
				{
					gint i;
					i = 0;
					{
						gboolean _tmp4_;
						_tmp4_ = TRUE;
						while (TRUE) {
							const gchar* _tmp5_;
							GQuark _tmp6_;
							static GQuark _tmp6__label0 = 0;
							static GQuark _tmp6__label1 = 0;
							static GQuark _tmp6__label2 = 0;
							static GQuark _tmp6__label3 = 0;
							if (!_tmp4_) {
								i++;
							}
							_tmp4_ = FALSE;
							if (!(i < attr_names_length1)) {
								break;
							}
							_tmp5_ = attr_names[i];
							_tmp6_ = (NULL == _tmp5_) ? 0 : g_quark_from_string (_tmp5_);
							if (_tmp6_ == ((0 != _tmp6__label0) ? _tmp6__label0 : (_tmp6__label0 = g_quark_from_static_string ("description")))) {
								switch (0) {
									default:
									{
										gchar* _tmp7_;
										_tmp7_ = g_strdup (attr_values[i]);
										_g_free0 (self->priv->current_build_tool.description);
										self->priv->current_build_tool.description = _tmp7_;
										break;
									}
								}
							} else if (_tmp6_ == ((0 != _tmp6__label1) ? _tmp6__label1 : (_tmp6__label1 = g_quark_from_static_string ("extensions")))) {
								switch (0) {
									default:
									{
										gchar* _tmp8_;
										_tmp8_ = g_strdup (attr_values[i]);
										_g_free0 (self->priv->current_build_tool.extensions);
										self->priv->current_build_tool.extensions = _tmp8_;
										break;
									}
								}
							} else if (_tmp6_ == ((0 != _tmp6__label2) ? _tmp6__label2 : (_tmp6__label2 = g_quark_from_static_string ("label")))) {
								switch (0) {
									default:
									{
										gchar* _tmp9_;
										_tmp9_ = g_strdup (attr_values[i]);
										_g_free0 (self->priv->current_build_tool.label);
										self->priv->current_build_tool.label = _tmp9_;
										break;
									}
								}
							} else if (_tmp6_ == ((0 != _tmp6__label3) ? _tmp6__label3 : (_tmp6__label3 = g_quark_from_static_string ("icon")))) {
								switch (0) {
									default:
									{
										gchar* _tmp10_;
										gchar* icon;
										gchar* _tmp11_;
										const gchar* _tmp12_;
										GQuark _tmp13_;
										static GQuark _tmp13__label0 = 0;
										static GQuark _tmp13__label1 = 0;
										static GQuark _tmp13__label2 = 0;
										gboolean _tmp14_;
										_tmp10_ = g_strdup (attr_values[i]);
										icon = _tmp10_;
										_tmp11_ = g_strdup (icon);
										_g_free0 (self->priv->current_build_tool.icon);
										self->priv->current_build_tool.icon = _tmp11_;
										_tmp12_ = icon;
										_tmp13_ = (NULL == _tmp12_) ? 0 : g_quark_from_string (_tmp12_);
										if (_tmp13_ == ((0 != _tmp13__label0) ? _tmp13__label0 : (_tmp13__label0 = g_quark_from_static_string ("view_dvi")))) {
											switch (0) {
												default:
												{
													self->priv->current_tool_is_view_dvi = TRUE;
													break;
												}
											}
										} else if (_tmp13_ == ((0 != _tmp13__label1) ? _tmp13__label1 : (_tmp13__label1 = g_quark_from_static_string ("view_pdf")))) {
											switch (0) {
												default:
												{
													self->priv->current_tool_is_view_pdf = TRUE;
													break;
												}
											}
										} else if (_tmp13_ == ((0 != _tmp13__label2) ? _tmp13__label2 : (_tmp13__label2 = g_quark_from_static_string ("view_ps")))) {
											switch (0) {
												default:
												{
													self->priv->current_tool_is_view_ps = TRUE;
													break;
												}
											}
										}
										_tmp14_ = app_settings_is_compilation (self, icon);
										self->priv->current_build_tool.compilation = _tmp14_;
										_g_free0 (icon);
										break;
									}
								}
							} else {
								switch (0) {
									default:
									{
										gchar* _tmp15_;
										gchar* _tmp16_;
										gchar* _tmp17_;
										gchar* _tmp18_;
										GError* _tmp19_ = NULL;
										GError* _tmp20_;
										_tmp15_ = g_strconcat ("unknown attribute \"", attr_names[i], NULL);
										_tmp16_ = _tmp15_;
										_tmp17_ = g_strconcat (_tmp16_, "\"", NULL);
										_tmp18_ = _tmp17_;
										_tmp19_ = g_error_new_literal (G_MARKUP_ERROR, G_MARKUP_ERROR_UNKNOWN_ATTRIBUTE, _tmp18_);
										_tmp20_ = _tmp19_;
										_g_free0 (_tmp18_);
										_g_free0 (_tmp16_);
										_inner_error_ = _tmp20_;
										if (_inner_error_->domain == G_MARKUP_ERROR) {
											g_propagate_error (error, _inner_error_);
											return;
										} else {
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
											g_clear_error (&_inner_error_);
											return;
										}
									}
								}
							}
						}
					}
				}
				break;
			}
		}
	} else if (_tmp1_ == ((0 != _tmp1__label2) ? _tmp1__label2 : (_tmp1__label2 = g_quark_from_static_string ("job")))) {
		switch (0) {
			default:
			{
				BuildJob _tmp21_ = {0};
				BuildJob _tmp22_ = {0};
				memset (&_tmp21_, 0, sizeof (BuildJob));
				_tmp22_ = _tmp21_;
				build_job_destroy (&self->priv->current_build_job);
				self->priv->current_build_job = _tmp22_;
				{
					gint i;
					i = 0;
					{
						gboolean _tmp23_;
						_tmp23_ = TRUE;
						while (TRUE) {
							const gchar* _tmp24_;
							GQuark _tmp25_;
							static GQuark _tmp25__label0 = 0;
							static GQuark _tmp25__label1 = 0;
							if (!_tmp23_) {
								i++;
							}
							_tmp23_ = FALSE;
							if (!(i < attr_names_length1)) {
								break;
							}
							_tmp24_ = attr_names[i];
							_tmp25_ = (NULL == _tmp24_) ? 0 : g_quark_from_string (_tmp24_);
							if (_tmp25_ == ((0 != _tmp25__label0) ? _tmp25__label0 : (_tmp25__label0 = g_quark_from_static_string ("mustSucceed")))) {
								switch (0) {
									default:
									{
										gboolean _tmp26_;
										_tmp26_ = string_to_bool (attr_values[i]);
										self->priv->current_build_job.must_succeed = _tmp26_;
										break;
									}
								}
							} else if (_tmp25_ == ((0 != _tmp25__label1) ? _tmp25__label1 : (_tmp25__label1 = g_quark_from_static_string ("postProcessor")))) {
								switch (0) {
									default:
									{
										gchar* _tmp27_;
										_tmp27_ = g_strdup (attr_values[i]);
										_g_free0 (self->priv->current_build_job.post_processor);
										self->priv->current_build_job.post_processor = _tmp27_;
										break;
									}
								}
							} else {
								switch (0) {
									default:
									{
										gchar* _tmp28_;
										gchar* _tmp29_;
										gchar* _tmp30_;
										gchar* _tmp31_;
										GError* _tmp32_ = NULL;
										GError* _tmp33_;
										_tmp28_ = g_strconcat ("unknown attribute \"", attr_names[i], NULL);
										_tmp29_ = _tmp28_;
										_tmp30_ = g_strconcat (_tmp29_, "\"", NULL);
										_tmp31_ = _tmp30_;
										_tmp32_ = g_error_new_literal (G_MARKUP_ERROR, G_MARKUP_ERROR_UNKNOWN_ATTRIBUTE, _tmp31_);
										_tmp33_ = _tmp32_;
										_g_free0 (_tmp31_);
										_g_free0 (_tmp29_);
										_inner_error_ = _tmp33_;
										if (_inner_error_->domain == G_MARKUP_ERROR) {
											g_propagate_error (error, _inner_error_);
											return;
										} else {
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
											g_clear_error (&_inner_error_);
											return;
										}
									}
								}
							}
						}
					}
				}
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				gchar* _tmp34_;
				gchar* _tmp35_;
				gchar* _tmp36_;
				gchar* _tmp37_;
				GError* _tmp38_ = NULL;
				GError* _tmp39_;
				_tmp34_ = g_strconcat ("unknown element \"", name, NULL);
				_tmp35_ = _tmp34_;
				_tmp36_ = g_strconcat (_tmp35_, "\"", NULL);
				_tmp37_ = _tmp36_;
				_tmp38_ = g_error_new_literal (G_MARKUP_ERROR, G_MARKUP_ERROR_UNKNOWN_ELEMENT, _tmp37_);
				_tmp39_ = _tmp38_;
				_g_free0 (_tmp37_);
				_g_free0 (_tmp35_);
				_inner_error_ = _tmp39_;
				if (_inner_error_->domain == G_MARKUP_ERROR) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
	}
}


static gpointer _build_job_dup0 (gpointer self) {
	return self ? build_job_dup (self) : NULL;
}


static void app_settings_parser_end (AppSettings* self, GMarkupParseContext* context, const gchar* name, GError** error) {
	const gchar* _tmp0_;
	GQuark _tmp1_;
	static GQuark _tmp1__label0 = 0;
	static GQuark _tmp1__label1 = 0;
	static GQuark _tmp1__label2 = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = name;
	_tmp1_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp1_ == ((0 != _tmp1__label0) ? _tmp1__label0 : (_tmp1__label0 = g_quark_from_static_string ("tools")))) {
		switch (0) {
			default:
			{
				return;
			}
		}
	} else if (_tmp1_ == ((0 != _tmp1__label1) ? _tmp1__label1 : (_tmp1__label1 = g_quark_from_static_string ("tool")))) {
		switch (0) {
			default:
			{
				gee_abstract_collection_add ((GeeAbstractCollection*) self->priv->build_tools, &self->priv->current_build_tool);
				if (self->priv->current_tool_is_view_dvi) {
					app_settings_set_build_tool_view_dvi (self, &self->priv->current_build_tool);
					self->priv->current_tool_is_view_dvi = FALSE;
				} else {
					if (self->priv->current_tool_is_view_pdf) {
						app_settings_set_build_tool_view_pdf (self, &self->priv->current_build_tool);
						self->priv->current_tool_is_view_pdf = FALSE;
					} else {
						if (self->priv->current_tool_is_view_ps) {
							app_settings_set_build_tool_view_ps (self, &self->priv->current_build_tool);
							self->priv->current_tool_is_view_ps = FALSE;
						}
					}
				}
				break;
			}
		}
	} else if (_tmp1_ == ((0 != _tmp1__label2) ? _tmp1__label2 : (_tmp1__label2 = g_quark_from_static_string ("job")))) {
		switch (0) {
			default:
			{
				BuildJob* _tmp2_;
				_tmp2_ = _build_job_dup0 (&self->priv->current_build_job);
				self->priv->current_build_tool.jobs = g_list_append (self->priv->current_build_tool.jobs, _tmp2_);
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				gchar* _tmp3_;
				gchar* _tmp4_;
				gchar* _tmp5_;
				gchar* _tmp6_;
				GError* _tmp7_ = NULL;
				GError* _tmp8_;
				_tmp3_ = g_strconcat ("unknown element \"", name, NULL);
				_tmp4_ = _tmp3_;
				_tmp5_ = g_strconcat (_tmp4_, "\"", NULL);
				_tmp6_ = _tmp5_;
				_tmp7_ = g_error_new_literal (G_MARKUP_ERROR, G_MARKUP_ERROR_UNKNOWN_ELEMENT, _tmp6_);
				_tmp8_ = _tmp7_;
				_g_free0 (_tmp6_);
				_g_free0 (_tmp4_);
				_inner_error_ = _tmp8_;
				if (_inner_error_->domain == G_MARKUP_ERROR) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
	}
}


static void app_settings_parser_text (AppSettings* self, GMarkupParseContext* context, const gchar* text, gsize text_len, GError** error) {
	const gchar* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = g_markup_parse_context_get_element (context);
	if (g_strcmp0 (_tmp0_, "job") == 0) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup (text);
		_g_free0 (self->priv->current_build_job.command);
		self->priv->current_build_job.command = _tmp1_;
	}
}


static gchar* bool_to_string (gboolean self) {
	gchar* result = NULL;
	if (self) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("true");
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("false");
		result = _tmp1_;
		return result;
	}
}


void app_settings_save_build_tools (AppSettings* self) {
	gchar* _tmp0_;
	gchar* content;
	gchar* _tmp26_;
	GFile* _tmp27_ = NULL;
	GFile* file;
	GFile* _tmp28_ = NULL;
	GFile* parent;
	gboolean _tmp29_ = FALSE;
	gsize _tmp31_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (self->priv->build_tools != NULL);
	if (!self->priv->build_tools_modified) {
		return;
	}
	_tmp0_ = g_strdup ("<tools>\n");
	content = _tmp0_;
	{
		GeeLinkedList* _tmp1_;
		GeeLinkedList* _tool_list;
		gint _tmp2_;
		gint _tool_size;
		gint _tool_index;
		_tmp1_ = _g_object_ref0 (self->priv->build_tools);
		_tool_list = _tmp1_;
		_tmp2_ = gee_collection_get_size ((GeeCollection*) _tool_list);
		_tool_size = _tmp2_;
		_tool_index = -1;
		while (TRUE) {
			gpointer _tmp3_ = NULL;
			BuildTool* _tmp4_;
			BuildTool _tmp5_;
			BuildTool _tmp6_ = {0};
			BuildTool _tmp7_;
			BuildTool tool;
			gchar* _tmp8_ = NULL;
			gchar* _tmp9_;
			gchar* _tmp10_ = NULL;
			gchar* _tmp11_;
			gchar* _tmp12_ = NULL;
			gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp25_;
			_tool_index = _tool_index + 1;
			if (!(_tool_index < _tool_size)) {
				break;
			}
			_tmp3_ = gee_abstract_list_get ((GeeAbstractList*) _tool_list, _tool_index);
			_tmp4_ = (BuildTool*) _tmp3_;
			build_tool_copy (_tmp4_, &_tmp6_);
			_tmp5_ = _tmp6_;
			_tmp7_ = _tmp5_;
			_build_tool_free0 (_tmp4_);
			tool = _tmp7_;
			_tmp8_ = g_markup_escape_text (tool.description, (gssize) (-1));
			_tmp9_ = _tmp8_;
			_tmp10_ = g_markup_escape_text (tool.label, (gssize) (-1));
			_tmp11_ = _tmp10_;
			_tmp12_ = g_strdup_printf ("  <tool description=\"%s\" extensions=\"%s\" label=\"%s\" icon=\"%s\">" \
"\n", _tmp9_, tool.extensions, _tmp11_, tool.icon);
			_tmp13_ = _tmp12_;
			_tmp14_ = g_strconcat (content, _tmp13_, NULL);
			_g_free0 (content);
			content = _tmp14_;
			_g_free0 (_tmp13_);
			_g_free0 (_tmp11_);
			_g_free0 (_tmp9_);
			{
				GList* job_collection;
				GList* job_it;
				job_collection = tool.jobs;
				for (job_it = job_collection; job_it != NULL; job_it = job_it->next) {
					BuildJob _tmp15_;
					BuildJob _tmp16_ = {0};
					BuildJob job;
					build_job_copy ((BuildJob*) job_it->data, &_tmp16_);
					_tmp15_ = _tmp16_;
					job = _tmp15_;
					{
						gchar* _tmp17_ = NULL;
						gchar* _tmp18_;
						gchar* _tmp19_ = NULL;
						gchar* _tmp20_;
						gchar* _tmp21_;
						gchar* _tmp22_ = NULL;
						gchar* _tmp23_;
						gchar* _tmp24_;
						_tmp17_ = bool_to_string (job.must_succeed);
						_tmp18_ = _tmp17_;
						_tmp19_ = g_strdup_printf ("    <job mustSucceed=\"%s\" postProcessor=\"%s\">", _tmp18_, job.post_processor);
						_tmp20_ = _tmp19_;
						_tmp21_ = g_strconcat (content, _tmp20_, NULL);
						_g_free0 (content);
						content = _tmp21_;
						_g_free0 (_tmp20_);
						_g_free0 (_tmp18_);
						_tmp22_ = g_markup_printf_escaped ("%s</job>\n", job.command);
						_tmp23_ = _tmp22_;
						_tmp24_ = g_strconcat (content, _tmp23_, NULL);
						_g_free0 (content);
						content = _tmp24_;
						_g_free0 (_tmp23_);
						build_job_destroy (&job);
					}
				}
			}
			_tmp25_ = g_strconcat (content, "  </tool>\n", NULL);
			_g_free0 (content);
			content = _tmp25_;
			build_tool_destroy (&tool);
		}
		_g_object_unref0 (_tool_list);
	}
	_tmp26_ = g_strconcat (content, "</tools>\n", NULL);
	_g_free0 (content);
	content = _tmp26_;
	_tmp27_ = app_settings_get_user_config_build_tools_file (self);
	file = _tmp27_;
	_tmp28_ = g_file_get_parent (file);
	parent = _tmp28_;
	if (parent != NULL) {
		gboolean _tmp30_;
		_tmp30_ = g_file_query_exists (parent, NULL);
		_tmp29_ = !_tmp30_;
	} else {
		_tmp29_ = FALSE;
	}
	if (_tmp29_) {
		g_file_make_directory_with_parents (parent, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (parent);
			_g_object_unref0 (file);
			goto __catch22_g_error;
		}
	}
	_tmp31_ = strlen (content);
	g_file_replace_contents (file, content, _tmp31_, NULL, TRUE, G_FILE_CREATE_NONE, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_object_unref0 (parent);
		_g_object_unref0 (file);
		goto __catch22_g_error;
	}
	_g_object_unref0 (parent);
	_g_object_unref0 (file);
	goto __finally22;
	__catch22_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		fprintf (stderr, "Warning: impossible to save build tools: %s\n", e->message);
		_g_error_free0 (e);
	}
	__finally22:
	if (_inner_error_ != NULL) {
		_g_free0 (content);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (content);
}


static GFile* app_settings_get_user_config_build_tools_file (AppSettings* self) {
	GFile* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* path;
	GFile* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_get_user_config_dir ();
	_tmp1_ = g_build_filename (_tmp0_, "latexila", "build_tools.xml", NULL, NULL);
	path = _tmp1_;
	_tmp2_ = g_file_new_for_path (path);
	result = _tmp2_;
	_g_free0 (path);
	return result;
}


const gchar* app_settings_get_system_font (AppSettings* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_system_font;
	return result;
}


static void app_settings_set_system_font (AppSettings* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_system_font);
	self->priv->_system_font = _tmp0_;
	g_object_notify ((GObject *) self, "system-font");
}


void app_settings_get_build_tool_view_dvi (AppSettings* self, BuildTool* result) {
	g_return_if_fail (self != NULL);
	*result = self->priv->_build_tool_view_dvi;
	return;
}


static void app_settings_set_build_tool_view_dvi (AppSettings* self, BuildTool* value) {
	BuildTool _tmp0_;
	BuildTool _tmp1_ = {0};
	g_return_if_fail (self != NULL);
	build_tool_copy (value, &_tmp1_);
	_tmp0_ = _tmp1_;
	build_tool_destroy (&self->priv->_build_tool_view_dvi);
	self->priv->_build_tool_view_dvi = _tmp0_;
	g_object_notify ((GObject *) self, "build-tool-view-dvi");
}


void app_settings_get_build_tool_view_pdf (AppSettings* self, BuildTool* result) {
	g_return_if_fail (self != NULL);
	*result = self->priv->_build_tool_view_pdf;
	return;
}


static void app_settings_set_build_tool_view_pdf (AppSettings* self, BuildTool* value) {
	BuildTool _tmp0_;
	BuildTool _tmp1_ = {0};
	g_return_if_fail (self != NULL);
	build_tool_copy (value, &_tmp1_);
	_tmp0_ = _tmp1_;
	build_tool_destroy (&self->priv->_build_tool_view_pdf);
	self->priv->_build_tool_view_pdf = _tmp0_;
	g_object_notify ((GObject *) self, "build-tool-view-pdf");
}


void app_settings_get_build_tool_view_ps (AppSettings* self, BuildTool* result) {
	g_return_if_fail (self != NULL);
	*result = self->priv->_build_tool_view_ps;
	return;
}


static void app_settings_set_build_tool_view_ps (AppSettings* self, BuildTool* value) {
	BuildTool _tmp0_;
	BuildTool _tmp1_ = {0};
	g_return_if_fail (self != NULL);
	build_tool_copy (value, &_tmp1_);
	_tmp0_ = _tmp1_;
	build_tool_destroy (&self->priv->_build_tool_view_ps);
	self->priv->_build_tool_view_ps = _tmp0_;
	g_object_notify ((GObject *) self, "build-tool-view-ps");
}


static void app_settings_class_init (AppSettingsClass * klass) {
	app_settings_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (AppSettingsPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_app_settings_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_app_settings_set_property;
	G_OBJECT_CLASS (klass)->finalize = app_settings_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), APP_SETTINGS_SYSTEM_FONT, g_param_spec_string ("system-font", "system-font", "system-font", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), APP_SETTINGS_BUILD_TOOL_VIEW_DVI, g_param_spec_boxed ("build-tool-view-dvi", "build-tool-view-dvi", "build-tool-view-dvi", TYPE_BUILD_TOOL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), APP_SETTINGS_BUILD_TOOL_VIEW_PDF, g_param_spec_boxed ("build-tool-view-pdf", "build-tool-view-pdf", "build-tool-view-pdf", TYPE_BUILD_TOOL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), APP_SETTINGS_BUILD_TOOL_VIEW_PS, g_param_spec_boxed ("build-tool-view-ps", "build-tool-view-ps", "build-tool-view-ps", TYPE_BUILD_TOOL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void app_settings_instance_init (AppSettings * self) {
	self->priv = APP_SETTINGS_GET_PRIVATE (self);
	self->priv->timeout_id = (guint) 0;
	self->priv->mus_modified = FALSE;
	self->priv->current_tool_is_view_dvi = FALSE;
	self->priv->current_tool_is_view_pdf = FALSE;
	self->priv->current_tool_is_view_ps = FALSE;
	self->priv->build_tools_modified = FALSE;
}


static void app_settings_finalize (GObject* obj) {
	AppSettings * self;
	self = APP_SETTINGS (obj);
	_g_object_unref0 (self->priv->editor);
	_g_object_unref0 (self->priv->desktop_interface);
	_g_free0 (self->priv->_system_font);
	_g_object_unref0 (self->priv->most_used_symbols);
	_g_object_unref0 (self->priv->build_tools);
	build_tool_destroy (&self->priv->current_build_tool);
	build_job_destroy (&self->priv->current_build_job);
	build_tool_destroy (&self->priv->_build_tool_view_dvi);
	build_tool_destroy (&self->priv->_build_tool_view_pdf);
	build_tool_destroy (&self->priv->_build_tool_view_ps);
	G_OBJECT_CLASS (app_settings_parent_class)->finalize (obj);
}


GType app_settings_get_type (void) {
	static volatile gsize app_settings_type_id__volatile = 0;
	if (g_once_init_enter (&app_settings_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (AppSettingsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) app_settings_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AppSettings), 0, (GInstanceInitFunc) app_settings_instance_init, NULL };
		GType app_settings_type_id;
		app_settings_type_id = g_type_register_static (G_TYPE_SETTINGS, "AppSettings", &g_define_type_info, 0);
		g_once_init_leave (&app_settings_type_id__volatile, app_settings_type_id);
	}
	return app_settings_type_id__volatile;
}


static void _vala_app_settings_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	AppSettings * self;
	BuildTool boxed0;
	BuildTool boxed1;
	BuildTool boxed2;
	self = APP_SETTINGS (object);
	switch (property_id) {
		case APP_SETTINGS_SYSTEM_FONT:
		g_value_set_string (value, app_settings_get_system_font (self));
		break;
		case APP_SETTINGS_BUILD_TOOL_VIEW_DVI:
		app_settings_get_build_tool_view_dvi (self, &boxed0);
		g_value_set_boxed (value, &boxed0);
		break;
		case APP_SETTINGS_BUILD_TOOL_VIEW_PDF:
		app_settings_get_build_tool_view_pdf (self, &boxed1);
		g_value_set_boxed (value, &boxed1);
		break;
		case APP_SETTINGS_BUILD_TOOL_VIEW_PS:
		app_settings_get_build_tool_view_ps (self, &boxed2);
		g_value_set_boxed (value, &boxed2);
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_app_settings_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	AppSettings * self;
	self = APP_SETTINGS (object);
	switch (property_id) {
		case APP_SETTINGS_SYSTEM_FONT:
		app_settings_set_system_font (self, g_value_get_string (value));
		break;
		case APP_SETTINGS_BUILD_TOOL_VIEW_DVI:
		app_settings_set_build_tool_view_dvi (self, g_value_get_boxed (value));
		break;
		case APP_SETTINGS_BUILD_TOOL_VIEW_PDF:
		app_settings_set_build_tool_view_pdf (self, g_value_get_boxed (value));
		break;
		case APP_SETTINGS_BUILD_TOOL_VIEW_PS:
		app_settings_set_build_tool_view_ps (self, g_value_get_boxed (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



