/* utils.c generated by valac 0.10.2, the Vala compiler
 * generated from utils.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2010 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gdk/gdk.h>
#include <gdk/gdkx.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>
#include <X11/Xregion.h>
#include <stdio.h>
#include <gdk-pixbuf/gdk-pixdata.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_BUILD_TOOL (build_tool_get_type ())

#define TYPE_BUILD_JOB (build_job_get_type ())
typedef struct _BuildJob BuildJob;
typedef struct _BuildTool BuildTool;
#define _gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL)))

struct _BuildJob {
	gboolean must_succeed;
	char* post_processor;
	char* command;
};

struct _BuildTool {
	char* description;
	char* extensions;
	char* label;
	char* icon;
	gboolean compilation;
	GList* jobs;
};



void utils_flush_queue (void);
char* utils_str_middle_truncate (const char* str, guint max_length);
char* utils_replace_home_dir_with_tilde (const char* uri);
char* utils_uri_get_dirname (const char* uri);
char* utils_get_dirname_for_display (GFile* location);
char* utils_get_shortname (const char* path);
glong utils_get_extension_pos (const char* path);
char* utils_get_extension (const char* path);
#define UTILS_ALL_WORKSPACES ((guint) 0xffffff)
guint utils_get_window_workspace (GtkWindow* gtkwindow);
GtkWidget* utils_add_scrollbar (GtkWidget* child);
GType build_tool_get_type (void) G_GNUC_CONST;
GType build_job_get_type (void) G_GNUC_CONST;
BuildJob* build_job_dup (const BuildJob* self);
void build_job_free (BuildJob* self);
void build_job_copy (const BuildJob* self, BuildJob* dest);
void build_job_destroy (BuildJob* self);
BuildTool* build_tool_dup (const BuildTool* self);
void build_tool_free (BuildTool* self);
void build_tool_copy (const BuildTool* self, BuildTool* dest);
void build_tool_destroy (BuildTool* self);
void utils_print_build_tool (BuildTool* build_tool);
void utils_delete_file (GFile* file);
gboolean utils_tree_model_iter_prev (GtkTreeModel* model, GtkTreeIter* iter);
void utils_set_entry_error (GtkWidget* entry, gboolean _error_);
gint utils_get_selected_row (GtkTreeView* view, GtkTreeIter* iter_to_set);
GdkPixbuf* utils_get_pixbuf_from_stock (const char* stock_id, GtkIconSize size);
static int _vala_strcmp0 (const char * str1, const char * str2);



void utils_flush_queue (void) {
	while (TRUE) {
		if (!gtk_events_pending ()) {
			break;
		}
		gtk_main_iteration ();
	}
}


static glong string_get_length (const char* self) {
	glong result;
	g_return_val_if_fail (self != NULL, 0L);
	result = g_utf8_strlen (self, (gssize) (-1));
	return result;
}


static char* string_slice (const char* self, glong start, glong end) {
	char* result = NULL;
	glong string_length;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	const char* start_string;
	g_return_val_if_fail (self != NULL, NULL);
	string_length = string_get_length (self);
	if (start < 0) {
		start = string_length + start;
	}
	if (end < 0) {
		end = string_length + end;
	}
	if (start >= 0) {
		_tmp0_ = start <= string_length;
	} else {
		_tmp0_ = FALSE;
	}
	g_return_val_if_fail (_tmp0_, NULL);
	if (end >= 0) {
		_tmp1_ = end <= string_length;
	} else {
		_tmp1_ = FALSE;
	}
	g_return_val_if_fail (_tmp1_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	start_string = g_utf8_offset_to_pointer (self, start);
	result = g_strndup (start_string, ((gchar*) g_utf8_offset_to_pointer (start_string, end - start)) - ((gchar*) start_string));
	return result;
}


char* utils_str_middle_truncate (const char* str, guint max_length) {
	char* result = NULL;
	guint half_length;
	glong l;
	char* _tmp0_;
	char* _tmp1_;
	char* _tmp2_;
	char* _tmp3_;
	g_return_val_if_fail (str != NULL, NULL);
	if (string_get_length (str) <= max_length) {
		result = g_strdup (str);
		return result;
	}
	half_length = (max_length - 4) / 2;
	l = string_get_length (str);
	result = (_tmp3_ = g_strconcat (_tmp1_ = g_strconcat (_tmp0_ = string_slice (str, (glong) 0, (glong) half_length), "...", NULL), _tmp2_ = string_slice (str, l - half_length, l), NULL), _g_free0 (_tmp2_), _g_free0 (_tmp1_), _g_free0 (_tmp0_), _tmp3_);
	return result;
}


char* utils_replace_home_dir_with_tilde (const char* uri) {
	char* result = NULL;
	char* home;
	g_return_val_if_fail (uri != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	home = g_strdup (g_get_home_dir ());
	if (_vala_strcmp0 (uri, home) == 0) {
		result = g_strdup ("~");
		_g_free0 (home);
		return result;
	}
	if (g_str_has_prefix (uri, home)) {
		char* _tmp0_;
		char* _tmp1_;
		result = (_tmp1_ = g_strconcat ("~", _tmp0_ = string_slice (uri, string_get_length (home), string_get_length (uri)), NULL), _g_free0 (_tmp0_), _tmp1_);
		_g_free0 (home);
		return result;
	}
	result = g_strdup (uri);
	_g_free0 (home);
	return result;
}


char* utils_uri_get_dirname (const char* uri) {
	char* result = NULL;
	char* dir;
	g_return_val_if_fail (uri != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	dir = g_path_get_dirname (uri);
	if (_vala_strcmp0 (dir, ".") == 0) {
		result = NULL;
		_g_free0 (dir);
		return result;
	}
	result = utils_replace_home_dir_with_tilde (dir);
	_g_free0 (dir);
	return result;
}


char* utils_get_dirname_for_display (GFile* location) {
	char* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (location != NULL, NULL);
	{
		GMount* mount;
		char* mount_name;
		char* _tmp0_;
		char* dirname;
		gboolean _tmp2_ = FALSE;
		char* _tmp3_;
		char* _tmp4_;
		mount = g_file_find_enclosing_mount (location, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch42_g_error;
		}
		mount_name = g_strdup (g_mount_get_name (mount));
		_tmp0_ = g_file_get_path (location);
		if (_tmp0_ == NULL) {
			char* _tmp1_;
			_tmp0_ = (_tmp1_ = g_file_get_uri (location), _g_free0 (_tmp0_), _tmp1_);
		}
		dirname = utils_uri_get_dirname (_tmp0_);
		if (dirname == NULL) {
			_tmp2_ = TRUE;
		} else {
			_tmp2_ = _vala_strcmp0 (dirname, ".") == 0;
		}
		if (_tmp2_) {
			result = mount_name;
			_g_free0 (dirname);
			_g_free0 (_tmp0_);
			_g_object_unref0 (mount);
			return result;
		}
		result = (_tmp4_ = g_strconcat (_tmp3_ = g_strconcat (mount_name, " ", NULL), dirname, NULL), _g_free0 (_tmp3_), _tmp4_);
		_g_free0 (dirname);
		_g_free0 (_tmp0_);
		_g_free0 (mount_name);
		_g_object_unref0 (mount);
		return result;
		_g_free0 (dirname);
		_g_free0 (_tmp0_);
		_g_free0 (mount_name);
		_g_object_unref0 (mount);
	}
	goto __finally42;
	__catch42_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			char* _tmp5_;
			_tmp5_ = g_file_get_path (location);
			if (_tmp5_ == NULL) {
				char* _tmp6_;
				_tmp5_ = (_tmp6_ = g_file_get_uri (location), _g_free0 (_tmp5_), _tmp6_);
			}
			result = utils_uri_get_dirname (_tmp5_);
			_g_free0 (_tmp5_);
			_g_error_free0 (e);
			return result;
		}
	}
	__finally42:
	{
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


char* utils_get_shortname (const char* path) {
	char* result = NULL;
	g_return_val_if_fail (path != NULL, NULL);
	result = string_slice (path, (glong) 0, utils_get_extension_pos (path));
	return result;
}


char* utils_get_extension (const char* path) {
	char* result = NULL;
	g_return_val_if_fail (path != NULL, NULL);
	result = string_slice (path, utils_get_extension_pos (path), string_get_length (path));
	return result;
}


glong utils_get_extension_pos (const char* path) {
	glong result = 0L;
	glong l;
	g_return_val_if_fail (path != NULL, 0L);
	l = string_get_length (path);
	{
		glong i;
		i = l - 1;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				if (!_tmp0_) {
					i--;
				}
				_tmp0_ = FALSE;
				if (!(i >= 0)) {
					break;
				}
				if (g_utf8_get_char (g_utf8_offset_to_pointer (path, i)) == '/') {
					result = l;
					return result;
				} else {
					if (g_utf8_get_char (g_utf8_offset_to_pointer (path, i)) == '.') {
						result = i;
						return result;
					}
				}
			}
		}
	}
	result = l;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


guint utils_get_window_workspace (GtkWindow* gtkwindow) {
	guint result = 0U;
	guint ret;
	GdkWindow* window;
	GdkDisplay* display;
	Display* x_display;
	Atom type;
	gint format = 0;
	gulong nitems = 0UL;
	gulong bytes_after = 0UL;
	guint* workspace = NULL;
	gint _result_;
	gint err;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (gtkwindow != NULL, 0U);
	g_return_val_if_fail (gtk_widget_get_realized ((GtkWidget*) gtkwindow), 0);
	ret = UTILS_ALL_WORKSPACES;
	window = _g_object_ref0 (gtk_widget_get_window ((GtkWidget*) gtkwindow));
	display = _g_object_ref0 (gdk_drawable_get_display ((GdkDrawable*) window));
	x_display = gdk_x11_display_get_xdisplay (display);
	gdk_error_trap_push ();
	_result_ = XGetWindowProperty (x_display, (Window) gdk_x11_drawable_get_xid ((GdkDrawable*) window), gdk_x11_get_xatom_by_name_for_display (display, "_NET_WM_DESKTOP"), (glong) 0, G_MAXLONG, FALSE, XA_CARDINAL, &type, &format, &nitems, &bytes_after, (unsigned char **) (&workspace));
	err = gdk_error_trap_pop ();
	if (err != Success) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = _result_ != Success;
	}
	if (_tmp0_) {
		result = ret;
		_g_object_unref0 (display);
		_g_object_unref0 (window);
		return result;
	}
	if (type == XA_CARDINAL) {
		_tmp2_ = format == 32;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = nitems > 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		ret = workspace[0];
	}
	XFree (workspace);
	result = ret;
	_g_object_unref0 (display);
	_g_object_unref0 (window);
	return result;
}


GtkWidget* utils_add_scrollbar (GtkWidget* child) {
	GtkWidget* result = NULL;
	GtkScrolledWindow* scrollbar;
	g_return_val_if_fail (child != NULL, NULL);
	scrollbar = g_object_ref_sink ((GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL));
	gtk_scrolled_window_set_policy (scrollbar, GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_container_add ((GtkContainer*) scrollbar, child);
	result = (GtkWidget*) scrollbar;
	return result;
}


static char* bool_to_string (gboolean self) {
	char* result = NULL;
	if (self) {
		result = g_strdup ("true");
		return result;
	} else {
		result = g_strdup ("false");
		return result;
	}
}


void utils_print_build_tool (BuildTool* build_tool) {
	fprintf (stdout, "\n=== Build Tool ===\n");
	fprintf (stdout, "desc: %s\n", (*build_tool).description);
	fprintf (stdout, "ext: %s\n", (*build_tool).extensions);
	fprintf (stdout, "label: %s\n", (*build_tool).label);
	fprintf (stdout, "icon: %s\n\n", (*build_tool).icon);
	{
		GList* build_job_collection;
		GList* build_job_it;
		build_job_collection = (*build_tool).jobs;
		for (build_job_it = build_job_collection; build_job_it != NULL; build_job_it = build_job_it->next) {
			BuildJob _tmp1_ = {0};
			BuildJob build_job;
			build_job = (build_job_copy ((BuildJob*) build_job_it->data, &_tmp1_), _tmp1_);
			{
				char* _tmp0_;
				fprintf (stdout, "== Build Job ==\n");
				fprintf (stdout, "must succeed: %s\n", _tmp0_ = bool_to_string (build_job.must_succeed));
				_g_free0 (_tmp0_);
				fprintf (stdout, "post processor: %s\n", build_job.post_processor);
				fprintf (stdout, "command: %s\n\n", build_job.command);
				build_job_destroy (&build_job);
			}
		}
	}
}


void utils_delete_file (GFile* file) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (file != NULL);
	{
		g_file_delete (file, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch43_g_error;
		}
	}
	goto __finally43;
	__catch43_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			char* _tmp0_;
			fprintf (stderr, "Warning: delete file \"%s\" failed: %s\n", _tmp0_ = g_file_get_parse_name (file), e->message);
			_g_free0 (_tmp0_);
			_g_error_free0 (e);
		}
	}
	__finally43:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


gboolean utils_tree_model_iter_prev (GtkTreeModel* model, GtkTreeIter* iter) {
	gboolean result = FALSE;
	GtkTreePath* path;
	g_return_val_if_fail (model != NULL, FALSE);
	path = gtk_tree_model_get_path (model, iter);
	if (gtk_tree_path_prev (path)) {
		gboolean ret;
		ret = gtk_tree_model_get_iter (model, iter, path);
		result = ret;
		_gtk_tree_path_free0 (path);
		return result;
	}
	result = FALSE;
	_gtk_tree_path_free0 (path);
	return result;
}


void utils_set_entry_error (GtkWidget* entry, gboolean _error_) {
	g_return_if_fail (entry != NULL);
	if (_error_) {
		GdkColor red = {0};
		GdkColor white = {0};
		gdk_color_parse ("#FF6666", &red);
		gdk_color_parse ("white", &white);
		gtk_widget_modify_base (entry, GTK_STATE_NORMAL, &red);
		gtk_widget_modify_text (entry, GTK_STATE_NORMAL, &white);
	} else {
		gtk_widget_modify_base (entry, GTK_STATE_NORMAL, NULL);
		gtk_widget_modify_text (entry, GTK_STATE_NORMAL, NULL);
	}
}


gint utils_get_selected_row (GtkTreeView* view, GtkTreeIter* iter_to_set) {
	gint result = 0;
	GtkTreeSelection* select;
	GtkTreeIter iter = {0};
	g_return_val_if_fail (view != NULL, 0);
	select = _g_object_ref0 (gtk_tree_view_get_selection (view));
	if (gtk_tree_selection_get_selected (select, NULL, &iter)) {
		GtkTreeModel* model;
		GtkTreePath* path;
		if ((iter_to_set) != NULL) {
			*iter_to_set = iter;
		}
		model = _g_object_ref0 (gtk_tree_view_get_model (view));
		path = gtk_tree_model_get_path (model, &iter);
		result = gtk_tree_path_get_indices (path)[0];
		_gtk_tree_path_free0 (path);
		_g_object_unref0 (model);
		_g_object_unref0 (select);
		return result;
	}
	result = -1;
	_g_object_unref0 (select);
	return result;
}


GdkPixbuf* utils_get_pixbuf_from_stock (const char* stock_id, GtkIconSize size) {
	GdkPixbuf* result = NULL;
	GtkInvisible* w;
	GdkPixbuf* pixbuf;
	g_return_val_if_fail (stock_id != NULL, NULL);
	w = g_object_ref_sink ((GtkInvisible*) gtk_invisible_new ());
	pixbuf = gtk_widget_render_icon ((GtkWidget*) w, stock_id, size, "vala");
	result = pixbuf;
	_g_object_unref0 (w);
	return result;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




