/* -*- tab-width: 4; c-basic-offset: 4 -*- */

using System;
using System.Collections.Generic;
using Gtk;
using GConf;

// Instantiate it's child on show ...
class DelayedWidget : Gtk.Alignment
{
    public delegate Gtk.Widget Create();
    Create     fnCreate;
    string     help;
    string     confKey;
    MainWindow window;
    Gtk.Widget container;

    public DelayedWidget (MainWindow window, Gtk.Widget container, Create fnCreate,
                          string label, string help)
        : base ((float)0.5, (float)0.5, (float)1, (float)1)
    {
        this.window = window;
        this.container = container;
        this.fnCreate = fnCreate;
        this.help = help;
        this.confKey = "/apps/iogrind/" + label.ToLower() + "_visible";
        this.confKey = this.confKey.Replace (' ', '_');
    }
    internal bool ShowHelp
    {
        get {
            GConf.Client client = new GConf.Client();
            try {
                return (bool) client.Get (this.confKey);
            } catch (GConf.NoSuchKeyException) {
                return true;
            }
        }
        set {
            GConf.Client client = new GConf.Client();
            client.Set (this.confKey, value);
        }
    }

    public void AddContent()
    {
        if (Child != null)
            return;

        Gtk.Widget newChild = fnCreate();
        newChild.Show();
        Add (newChild);
        this.container.QueueDraw();

        if (ShowHelp) {
            Gtk.MessageDialog dlg;
            dlg = new Gtk.MessageDialog (this.window, 0,
                                         Gtk.MessageType.Info,
                                         Gtk.ButtonsType.Ok, true,
                                         help);
            Gtk.CheckButton disableMe = new Gtk.CheckButton ("don't show this help again");
            disableMe.Show();
            dlg.VBox.Add (disableMe);
            dlg.DeleteEvent += delegate { dlg.Destroy(); };
            dlg.Response += delegate {
                ShowHelp = ! disableMe.Active;
                dlg.Destroy();
            };
            dlg.Show();
        }
    }
}

public class MainWindow : Gtk.Window
{
	SimulationData sd;
	Gtk.Notebook tabs;

	static List<MainWindow> windows;
    protected override bool OnDeleteEvent (Gdk.Event ev)
	{
		windows.Remove(this);
		if (windows.Count == 0)
			Application.Quit();
		return true;
	}

	static public List<MainWindow> AllWindows {
		get { return windows; }
	}

	void AppendPage(DelayedWidget.Create createFn, string label, string help)
	{
        Gtk.Widget widget = new DelayedWidget (this, this.tabs, createFn, label, help);
		widget.Show();
		Gtk.Label lWidget = new Gtk.Label (label);
		lWidget.Show();
		tabs.AppendPage (widget, lWidget);
	}

	void CreateBody()
	{
		this.tabs = new Gtk.Notebook();
		this.tabs.Show();
        this.tabs.SwitchPage += delegate {
            (this.tabs.GetNthPage (this.tabs.Page) as DelayedWidget).AddContent();
        };
		AppendPage (delegate { return new StackView (this.sd); }, "stack view",
                    "This view is a histogram: area is simulated time. " +
                    "On the left we have relevant stack frames during which the program consumed I/O time " +
                    "in the center we have the hierarchical histogram. Clicking on the histogram should take you to the " +
                    "relevant stack frame, and vv. Similarly double-clicking on the histogram should allow you to " +
                    "zoom in, to get further detail on a given frame");
		AppendPage (delegate { return new FileView (this.sd); }, "file view",
                    "This view is a histogram: area is simulated time. " +
                    "On the left we have a file-system view of the files that are touched " +
                    "in the center we have a hierarchical histogram - breaking down the total time " +
                    "by directory hierarchy. Clicking on the histogram should take you to the " +
                    "relevant file / directory, and vv. Similarly double-clicking on the histogram should allow you to " +
                    "zoom into a given directory, to make further detail visible");
		AppendPage (delegate { return new AddrView (this.sd); }, "address view",
                    "This view shows compressed virtual memory address vertically, by simulated I/O time horizontally." +
                    "Memory maps are rendered in various colors to highlight them, and initial page touches are rendered in " +
                    "black (and enlarged to at least a single output pixel).\n" +
                    "If the trace was generated with --trace-working-set=yes enabled, then some working set information can also " +
                    "be displayed.");
        string fsViewHelp = "This shows a view of the complete filesystem.\n" +
                    "On the right we have an overview - the blue bar shows the position of the main view (in the center).\n" +
                    "On the left we have a tree-view of the file-system (NB. the files are in directory read order)\n" +
                    "The center view shows the data - which is colorered: white for blank space, red for inodes. Selected files" +
                    "are green - and the intensity of color shows linearity: ideally non-fragmented files should be contiguous " +
            "and transition uniformly from a dark to a light color.";
		AppendPage (delegate { return new FSView (this.sd.FileSystem); }, "fs view", fsViewHelp);
		AppendPage (delegate { return new ScribbleView (this.sd); }, "scribble",
                    "The scribble view has a linear (time-wise) list of the I/O requests in the left pane " +
                    "(NB. &lt;seq&gt; items are there for clarity &amp; incurred no real I/O cost)\n" +
                    "If you select several of these items (shift-arrow, or shift-click) then the I/O pattern " +
                    "will be rendered in red on the main views. Otherwise this view is much like the file system view:\n\n"
                    + fsViewHelp);

        if (System.Environment.GetEnvironmentVariable("IOGRIND_HACKER") == null) {
            Gtk.MessageDialog warning =
                new Gtk.MessageDialog (this, Gtk.DialogFlags.Modal,
                                       Gtk.MessageType.Warning,
                                       Gtk.ButtonsType.Ok, true,
                                       "<b>Warning</b> - the results of the simulation you are " +
                                       "about to (foolishly) believe, are generated almost " +
                                       "entirely from thermal noise.\n" +
                                       "<b>Any</b> similarity between the " +
                                       "fictional version of the program portrayed here and the " +
                                       "actual program is purely coincidental. This is a work of fiction, " +
                                       "this is not an attempt to defame the character, or authors of said " +
                                       "software. Terms and conditions may apply, do not operate heavy " +
                                       "machinery while keeping up payments on your home...\n" +
                                       "<b>Please not use this to optimise your software (yet).</b>");
            warning.Run();
            warning.Destroy();
        }

		Add (this.tabs);
	}

	public MainWindow (SimulationData sd, string profile) :
		base ("I/O profile " + profile)
	{
		this.sd = sd;
		SetDefaultSize (1300, 950);
		CreateBody();

		if (windows == null)
			windows = new List<MainWindow>();

		windows.Add (this);
	}
}
