#ifndef INTERFACE_H
#define INTERFACE_H

/*
 * A cleaner, more extensible and user-friendly interface for DiskSim
 */

#if defined(__cplusplus)
extern "C" {
#endif

// time is the time since simulation start in seconds.
typedef double IDiskSimTime;

/* opaque handles */
typedef struct _IDiskSim IDiskSim;
typedef struct _IDiskSimRequest IDiskSimRequest;

/* necessary callbacks */
typedef void (*IDiskSimCallback)           (IDiskSim        *ids,
                                            void            *closure,
                                            IDiskSimTime     time);
typedef void (*IDiskSimScheduleCallback)   (IDiskSim        *ids,
                                            IDiskSimCallback callback,
                                            void            *callback_closure,
                                            IDiskSimTime     time_to_call,
                                            void            *closure);
typedef void (*IDiskSimDeScheduleCallback) (IDiskSim        *ids,
                                            IDiskSimCallback callback,
                                            void            *closure);
typedef void (*IDiskSimDoneIONotify)       (IDiskSim        *ids,
                                            IDiskSimRequest *req,
                                            IDiskSimTime     time_completed,
                                            void            *closure);

/* Disk Simulator */
IDiskSim *idisksim_init         (const char                *profile_name,
                                 IDiskSimScheduleCallback   schedule_fn,
                                 IDiskSimDeScheduleCallback de_schedule_fn,
                                 IDiskSimDoneIONotify       notify_fn,
                                 void                      *closure);
int      idisksim_get_blk_size  (IDiskSim                  *ids);
int      idisksim_get_blk_count (IDiskSim                  *ids);
void     idisksim_free          (IDiskSim                  *ids);

/* submit a request */
void     idisksim_submit  (IDiskSim                  *ids,
                           IDiskSimRequest           *req,
                           IDiskSimTime               time);
/* process I/O at scheduled time */
void     idisksim_iterate (IDiskSim                  *ids,
                           IDiskSimTime               time);

/* I/O Requests */

typedef enum {
    IDISKSIM_READ = 'r',
    IDISKSIM_WRITE = 'w'
} IDiskSimRequestType;

IDiskSimRequest *idisksim_request_new  (IDiskSimRequestType type,
                                        unsigned int        blkno,
                                        int                 blkcount);
void             idisksim_request_free (IDiskSimRequest    *req);

#if defined(__cplusplus)
}
#endif

#endif /* INTERFACE_H */
