using GLib;
using Gtk;
using GUPnP;

public class Test.DeviceViewTest : Window {

    construct {
        title = "GUPnP DeviceView Test";
        resize (400, 300);
        destroy += Gtk.main_quit;

        /* Init GUPnP stuff */
        Context ctxt;
        try {
            Thread.init (null);
            ctxt = new Context (null, null, 0);
        } catch (Error err) {
            critical (err.message);
            Gtk.main_quit ();
        }

        ControlPoint cp = new ControlPoint (ctxt, "upnp:rootdevice");
        cp.active = true;

        /* Create a ScrolledWindow for the UIDeviceView */
        var scroll_win = new ScrolledWindow (null, null);
        scroll_win.set_policy (PolicyType.AUTOMATIC,
                               PolicyType.ALWAYS);
        scroll_win.set_shadow_type (ShadowType.IN);
        add (scroll_win);

        /* Set up store and view */
        UIDeviceStore store = new UIDeviceStore (cp);
        UIDeviceView view = new UIDeviceView (store);
        scroll_win.add (view);
    }

    static int main (string[] args) {
        Gtk.init (ref args);

        var test = new DeviceViewTest ();
        test.show_all ();
        Gtk.main ();

        return 0;
    }
}
