// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_CELLAREABOX_H
#define _GTKMM_CELLAREABOX_H


#include <glibmm.h>

/* Copyright (C) 2010 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <gtkmm/cellarea.h>
#include <gtkmm/orientable.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkCellAreaBox GtkCellAreaBox;
typedef struct _GtkCellAreaBoxClass GtkCellAreaBoxClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class CellAreaBox_Class; } // namespace Gtk
namespace Gtk
{

/** A cell area that renders CellRenderers into a row or a colum, depending on its orientation.
 *
 * This class uses a notion of packing. Packing
 * refers to adding cell renderers with reference to a particular position
 * in a CellAreaBox. There are two reference positions: the
 * start and the end of the box.
 * When the CellAreaBox is oriented in the Gtk::ORIENTATION_VERTICAL
 * orientation, the start is defined as the top of the box and the end is
 * defined as the bottom. In the  Gtk::ORIENTATION_HORIZONTAL orientation
 * start is defined as the left side and the end is defined as the right
 * side.
 *
 * Alignments of CellRenderers rendered in adjacent rows can be
 * configured by configuring the align_child cell property
 * with CellArea::cell_set_property() or by specifying the "align"
 * argument to pack_start() or pack_end().
 *
 * @newin{3,0}
 */

class CellAreaBox
  : public Gtk::CellArea,
    public Orientable
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef CellAreaBox CppObjectType;
  typedef CellAreaBox_Class CppClassType;
  typedef GtkCellAreaBox BaseObjectType;
  typedef GtkCellAreaBoxClass BaseClassType;

private:  friend class CellAreaBox_Class;
  static CppClassType cellareabox_class_;

private:
  // noncopyable
  CellAreaBox(const CellAreaBox&);
  CellAreaBox& operator=(const CellAreaBox&);

protected:
  explicit CellAreaBox(const Glib::ConstructParams& construct_params);
  explicit CellAreaBox(GtkCellAreaBox* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~CellAreaBox();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GtkCellAreaBox*       gobj()       { return reinterpret_cast<GtkCellAreaBox*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GtkCellAreaBox* gobj() const { return reinterpret_cast<GtkCellAreaBox*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GtkCellAreaBox* gobj_copy();

private:

  
protected:
  CellAreaBox();
  
public:

  //TODO: Are these good default values:
  
  void pack_start(CellRenderer& renderer, bool expand =  false, bool align =  true, bool fixed =  false);
  
  void pack_end(CellRenderer& renderer, bool expand =  false, bool align =  true, bool fixed =  false);
  
  int get_spacing() const;
  
  void set_spacing(int spacing);


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Gtk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gtk::CellAreaBox
   */
  Glib::RefPtr<Gtk::CellAreaBox> wrap(GtkCellAreaBox* object, bool take_copy = false);
}


#endif /* _GTKMM_CELLAREABOX_H */

