// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_STYLECONTEXT_H
#define _GTKMM_STYLECONTEXT_H


#include <glibmm.h>

/* Copyright (C) 2010 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include <gtkmm/styleprovider.h>
#include <gtkmm/border.h>
#include <gtkmm/enums.h>
#include <gdkmm/window.h>
#include <gdkmm/screen.h>

#include <gtkmm/enums.h>
#include <gtkmm/iconsource.h>
#include <gtkmm/iconset.h>
#include <gtkmm/widgetpath.h>
#include <gtkmmconfig.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkStyleContext GtkStyleContext;
typedef struct _GtkStyleContextClass GtkStyleContextClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class StyleContext_Class; } // namespace Gtk
namespace Gtk
{

class IconSet;

//TODO: Add (and translate to C++) the code examples from the C documentation.
//TODO: Find a way to show the headings as headings in this doxygen comment.
/** This object stores styling information affecting a widget defined by WidgetPath.
 *
 * In order to construct the final style information, StyleContext
 * queries information from all attached StyleProviders. Style providers
 * can be either attached explicitly to the context through
 * add_provider(), or to the screen through
 * add_provider_for_screen(). The resulting style is a
 * combination of all providers' information in priority order.
 *
 * For GTK+ widgets, any StyleContext returned by
 * Widget::get_style_context() will already have a WidgetPath, a
 * Gdk::Screen and RTL/LTR information set, The style context will be also
 * updated automatically if any of these settings change on the widget.
 *
 * If you are using the theming layer standalone, you will need to set a
 * widget path and a screen yourself to the created style context through
 * set_path() and set_screen(), as well
 * as updating the context yourself using invalidate()
 * whenever any of the conditions change, such as a change in the
 * Settings::property_gtk_theme_name() setting or a hierarchy change in the rendered
 * widget.
 *
 * Transition animations
 * 
 * StyleContext has built-in support for state change transitions.
 * Note that these animations respect the Settings::property_gtk_enable_animations()
 * setting.
 *
 * For simple widgets where state changes affect the whole widget area,
 * calling notify_state_change() with a no region
 * is sufficient to trigger the transition animation. And GTK+ already
 * does that when Widget::set_state() or Widget::set_state_flags()
 * are called.
 * 
 * If a widget needs to declare several animatable regions (i.e. not
 * affecting the whole widget area), its Widget::signal_draw() signal handler
 * needs to wrap the render operations for the different regions with
 * calls to push_animatable_region() and
 * pop_animatable_region(). These methods take an
 * identifier for the region which must be unique within the style context.
 * For simple widgets with a fixed set of animatable regions, using an
 * enumeration works well.
 *
 * For complex widgets with an arbitrary number of animatable regions, it
 * is up to the implementation to come up with a way to uniquely identify
 * each animatable region. Using pointers to internal objects is one way
 * to achieve this.
 *
 * The widget also needs to notify the style context about a state change
 * for a given animatable region so the animation is triggered. 
 * notify_state_change() can take no region IDs, meaning that the whole widget 
 * area will be updated by the animation.
 *
 * @newin{3,0}
 */

class StyleContext : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef StyleContext CppObjectType;
  typedef StyleContext_Class CppClassType;
  typedef GtkStyleContext BaseObjectType;
  typedef GtkStyleContextClass BaseClassType;

private:  friend class StyleContext_Class;
  static CppClassType stylecontext_class_;

private:
  // noncopyable
  StyleContext(const StyleContext&);
  StyleContext& operator=(const StyleContext&);

protected:
  explicit StyleContext(const Glib::ConstructParams& construct_params);
  explicit StyleContext(GtkStyleContext* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~StyleContext();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GtkStyleContext*       gobj()       { return reinterpret_cast<GtkStyleContext*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GtkStyleContext* gobj() const { return reinterpret_cast<GtkStyleContext*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GtkStyleContext* gobj_copy();

private:

protected:
  StyleContext();

public:
  
  static Glib::RefPtr<StyleContext> create();

  
  static void add_provider_for_screen(const Glib::RefPtr<Gdk::Screen>& screen, const Glib::RefPtr<StyleProvider>& provider, guint priority);
  
  static void remove_provider_for_screen(const Glib::RefPtr<Gdk::Screen>& screen, const Glib::RefPtr<StyleProvider>& provider);

  
  void add_provider(const Glib::RefPtr<StyleProvider>& provider, guint priority);

  
  void remove_provider(const Glib::RefPtr<StyleProvider>& provider);

  
  void context_save();
  
  void context_restore();

/* TODO:
  _WRAP_METHOD(void get_property (
                                     const Glib::ustring& property,
                                     StateFlags    state,
                                     GValue          *value), tk_style_context_get_property)
  _WRAP_METHOD(void get_valist   (
                                     StateFlags    state,
                                     va_list          args), gtk_style_context_get_valist)
  _WRAP_METHOD(void get          (
                                     StateFlags    state,
                                     ...) G_GNUC_NULL_TERMINATED;
*/

  
  void set_state(StateFlags flags);
  
  StateFlags get_state() const;

  
  bool state_is_running(StateType state, gdouble* progress);

  
  void set_path(const WidgetPath& path);
  
 
  WidgetPath get_path() const;

  //TODO: _WRAP_METHOD(GList * list_classes (), gtk_style_context_list_classes)

  
  void add_class(const Glib::ustring& class_name);
  
  void remove_class(const Glib::ustring& class_name);
  
  bool has_class(const Glib::ustring& class_name);

  
  GList* list_regions ();

  
  void add_region(const Glib::ustring& region_name, RegionFlags flags);
  
  void remove_region(const Glib::ustring& region_name);
  
  bool has_region(const Glib::ustring& region_name, RegionFlags& flags_return);
/*
  _WRAP_METHOD(void get_style_property (
                                           const Glib::ustring& property_name,
                                           GValue          *value), gtk_style_context_get_style_property)
  _WRAP_METHOD(void get_style_valist   (
                                           va_list          args), gtk_style_context_get_style_valis)
  _WRAP_METHOD(void get_style          (
                                           ...), gtk_style_context_get_style)
*/

  
  Glib::RefPtr<IconSet> lookup_icon_set(const Glib::ustring& stock_id);

/* TODO: Move this to Iconset?
  _WRAP_METHOD(GdkPixbuf  * gtk_icon_set_render_icon_pixbuf   (const Glib::RefPtr<IconSet>& con_set,
                                                GtkStyleContext *context,
                                                GtkIconSize      size), gtk_icon_set_render_icon_pixbuf)
*/

  
  void set_screen(const Glib::RefPtr<Gdk::Screen>& screen);
                                          
  
  Glib::RefPtr<Gdk::Screen> get_screen();
  
  Glib::RefPtr<const Gdk::Screen> get_screen() const;

  
  void set_direction(TextDirection direction);
  
  TextDirection get_direction() const;

  
  void set_junction_sides(JunctionSides sides);
  
  JunctionSides get_junction_sides() const;

  
  bool lookup_color(const Glib::ustring& color_name, Gdk::RGBA& color);

  //TODO: region_id can be NULL.
  
  void notify_state_change(const Glib::RefPtr<Gdk::Window>& window, gpointer region_id, StateType state, bool state_value);
  
  
  void push_animatable_region(gpointer region_id);
  
  void pop_animatable_region();

  //TODO: Documentation
  Gdk::RGBA get_color(StateFlags state = (StateFlags)0) const;
  
  
  Gdk::RGBA get_background_color(StateFlags state = (StateFlags)0) const;
  
  
  Gdk::RGBA  get_border_color(StateFlags state = (StateFlags)0) const;
  

  Border get_border(StateFlags state = (StateFlags)0) const;
  
  
  Border get_padding(StateFlags state = (StateFlags)0) const;
  

  Border get_margin (StateFlags state = (StateFlags)0) const;
  

  void invalidate();
  //TODO: _WRAP_METHOD(void reset_widgets(const Glib::RefPtr<Gdk::Screen>& screen), gtk_style_context_reset_widgets)

  
  void set_background(const Glib::RefPtr<Gdk::Window>& window);
  
  
  void render_check(const Cairo::RefPtr<Cairo::Context>& cr, double x, double y, double width, double height);
  
  void render_option(const Cairo::RefPtr<Cairo::Context>& cr, double x, double y, double width, double height);
  
  void render_arrow(const Cairo::RefPtr<Cairo::Context>& cr, double angle, double x, double y, double size);
  
  void render_background(const Cairo::RefPtr<Cairo::Context>& cr, double x,  double y, double width, double height);
  
  void render_frame(const Cairo::RefPtr<Cairo::Context>& cr, double x,  double y, double width, double height);
  
  void render_expander(const Cairo::RefPtr<Cairo::Context>& cr, double x, double y, double width, double height);
  
  void render_focus(const Cairo::RefPtr<Cairo::Context>& cr, double x, double y, double width, double height);
  
  void render_layout(const Cairo::RefPtr<Cairo::Context>& cr, double x, double y,  PangoLayout     *layout);
  
  void render_line(const Cairo::RefPtr<Cairo::Context>& cr, double x0, double y0,  double x1, double y1);
  
  void render_slider(const Cairo::RefPtr<Cairo::Context>& cr, double x, double y, double width, double height,  Orientation orientation);
  
  void render_frame_gap(const Cairo::RefPtr<Cairo::Context>& cr, double x, double y, double width, double height,  PositionType  gap_side, double xy0_gap, double xy1_gap);
  
  void render_extension(const Cairo::RefPtr<Cairo::Context>& cr, double x, double y, double width, double height,  PositionType gap_side);
  
  void render_handle(const Cairo::RefPtr<Cairo::Context>& cr, double x, double y, double width, double height);
  
  void render_activity(const Cairo::RefPtr<Cairo::Context>& cr,  double x,  double y, double width, double height);
  
  Glib::RefPtr<Gdk::Pixbuf> render_icon_pixbuf(const IconSource& source, IconSize size);
                                    
  
  /**
   * @par Prototype:
   * <tt>void on_my_%changed()</tt>
   */

  Glib::SignalProxy0< void > signal_changed();


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The associated GdkScreen.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<Gdk::Screen> > property_screen() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The associated GdkScreen.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gdk::Screen> > property_screen() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Text direction.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<TextDirection> property_direction() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Text direction.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<TextDirection> property_direction() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  virtual void on_changed();


};

} // namespace Gtk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gtk::StyleContext
   */
  Glib::RefPtr<Gtk::StyleContext> wrap(GtkStyleContext* object, bool take_copy = false);
}


#endif /* _GTKMM_STYLECONTEXT_H */

