// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_PRINTOPERATION_H
#define _GTKMM_PRINTOPERATION_H


#include <glibmm.h>

/* Copyright (C) 2006 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/object.h>

#include <gtkmm/pagesetup.h>
#include <gtkmm/printcontext.h>
#include <gtkmm/printoperationpreview.h>
#include <gtkmm/printsettings.h>
#include <gtkmm/window.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkPrintOperation GtkPrintOperation;
typedef struct _GtkPrintOperationClass GtkPrintOperationClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class PrintOperation_Class; } // namespace Gtk
namespace Gtk
{

/** @addtogroup gtkmmEnums Enums and Flags */

/**
 * @ingroup gtkmmEnums
 */
enum PrintStatus
{
  PRINT_STATUS_INITIAL,
  PRINT_STATUS_PREPARING,
  PRINT_STATUS_GENERATING_DATA,
  PRINT_STATUS_SENDING_DATA,
  PRINT_STATUS_PENDING,
  PRINT_STATUS_PENDING_ISSUE,
  PRINT_STATUS_PRINTING,
  PRINT_STATUS_FINISHED,
  PRINT_STATUS_FINISHED_ABORTED
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::PrintStatus> : public Glib::Value_Enum<Gtk::PrintStatus>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{

/**
 * @ingroup gtkmmEnums
 */
enum PrintOperationResult
{
  PRINT_OPERATION_RESULT_ERROR,
  PRINT_OPERATION_RESULT_APPLY,
  PRINT_OPERATION_RESULT_CANCEL,
  PRINT_OPERATION_RESULT_IN_PROGRESS
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::PrintOperationResult> : public Glib::Value_Enum<Gtk::PrintOperationResult>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{

/**
 * @ingroup gtkmmEnums
 */
enum PrintOperationAction
{
  PRINT_OPERATION_ACTION_PRINT_DIALOG,
  PRINT_OPERATION_ACTION_PRINT,
  PRINT_OPERATION_ACTION_PREVIEW,
  PRINT_OPERATION_ACTION_EXPORT
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::PrintOperationAction> : public Glib::Value_Enum<Gtk::PrintOperationAction>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{

class PrintError : public Glib::Error
{
public:
  enum Code
  {
    GENERAL,
    INTERNAL_ERROR,
    NOMEM
  };

  PrintError(Code error_code, const Glib::ustring& error_message);
  explicit PrintError(GError* gobject);
  Code code() const;

#ifndef DOXYGEN_SHOULD_SKIP_THIS
private:

#ifdef GLIBMM_EXCEPTIONS_ENABLED
  static void throw_func(GError* gobject);
#else
  //When not using exceptions, we just pass the Exception object around without throwing it:
  static std::auto_ptr<Glib::Error> throw_func(GError* gobject);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  friend void wrap_init(); // uses throw_func()
#endif
};

} // namespace Gtk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::PrintError::Code> : public Glib::Value_Enum<Gtk::PrintError::Code>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{


/** @defgroup Printing Printing
 */

/** PrintOperation is the high-level, portable printing API. It looks a bit different than other 
 * GTK+ dialogs such as the FileChooser, since some platforms don't expose enough infrastructure 
 * to implement a good print dialog. On such platforms, GtkPrintOperation uses the native print 
 * dialog. On platforms which do not provide a native print dialog, GTK+ uses its own, see PrintUnixDialog.
 *
 * The typical way to use the high-level printing API is to create a PrintOperation object 
 * when the user chooses to print. Then you set some properties on it,such as the page size, any PrintSettings 
 * from previous print operations, the number of  pages, the current page, etc.
 *
 * Then you start the print operation by calling run(). It will then show a dialog to 
 * let the user select a printer and options. When the user finishes the dialog various signals will be 
 * emitted by the PrintOperation for you to handle, the main one being draw_page. You should then 
 * render the page on the provided PrintContext using Cairo.
 *
 * @since 2.10
 *
 * @ingroup Printing
 */

class PrintOperation :
  public Glib::Object,
  public PrintOperationPreview
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef PrintOperation CppObjectType;
  typedef PrintOperation_Class CppClassType;
  typedef GtkPrintOperation BaseObjectType;
  typedef GtkPrintOperationClass BaseClassType;

private:  friend class PrintOperation_Class;
  static CppClassType printoperation_class_;

private:
  // noncopyable
  PrintOperation(const PrintOperation&);
  PrintOperation& operator=(const PrintOperation&);

protected:
  explicit PrintOperation(const Glib::ConstructParams& construct_params);
  explicit PrintOperation(GtkPrintOperation* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~PrintOperation();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GtkPrintOperation*       gobj()       { return reinterpret_cast<GtkPrintOperation*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GtkPrintOperation* gobj() const { return reinterpret_cast<GtkPrintOperation*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GtkPrintOperation* gobj_copy();

private:

  
protected:
  PrintOperation();

public:
  
  static Glib::RefPtr<PrintOperation> create();


  void set_default_page_setup(const Glib::RefPtr<PageSetup>& default_page_setup);
  
  Glib::RefPtr<PageSetup> get_default_page_setup() const;

  
  void set_print_settings(const Glib::RefPtr<PrintSettings>& print_settings);
  
  Glib::RefPtr<PrintSettings> get_print_settings() const;

  
  void set_job_name(const Glib::ustring& job_name);
  
  void set_n_pages(int n_pages);
  
  void set_current_page(int current_page);
  
  void set_use_full_page(bool use_full_page = true);
  
  void set_unit(Unit unit);
  
  void set_export_filename(const std::string& filename);
  
  void set_track_print_status(bool track_status = true);
  
  void set_show_progress (bool show_progress = true);
  
  void set_allow_async(bool allow_async = true);
  
  void set_custom_tab_label(const Glib::ustring& label);

   
  #ifdef GLIBMM_EXCEPTIONS_ENABLED
  PrintOperationResult run(PrintOperationAction action = PRINT_OPERATION_ACTION_PRINT_DIALOG);
  #else
  PrintOperationResult run(PrintOperationAction action, std::auto_ptr<Glib::Error>& error);
  #endif //GLIBMM_EXCEPTIONS_ENABLED

  
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  PrintOperationResult run(PrintOperationAction action, Window& parent);
#else
  PrintOperationResult run(PrintOperationAction action, Window& parent, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
  PrintStatus get_status() const;
  
  Glib::ustring get_status_string() const;
  
  void cancel();
  
  bool is_finished() const;

  
  //TODO: point out in the docs that the PrintOperationResult enum may also indicate
  // that an error occurred, and in that case it is up to him to handle it.
  

  Glib::SignalProxy1< void,PrintOperationResult > signal_done();


  Glib::SignalProxy1< void,const Glib::RefPtr<PrintContext>& > signal_begin_print();

  
  Glib::SignalProxy1< bool,const Glib::RefPtr<PrintContext>& > signal_paginate();


  Glib::SignalProxy3< void,const Glib::RefPtr<PrintContext>&,int,const Glib::RefPtr<PageSetup>& > signal_request_page_setup();

  
  Glib::SignalProxy2< void,const Glib::RefPtr<PrintContext>&,int > signal_draw_page();

  
  Glib::SignalProxy1< void,const Glib::RefPtr<PrintContext>& > signal_end_print();

  
  Glib::SignalProxy0< void > signal_status_changed();


  Glib::SignalProxy0< Widget* > signal_create_custom_widget();


  Glib::SignalProxy1< void,Widget* > signal_custom_widget_apply();


  //TODO: This is causing crashes:
  

  Glib::SignalProxy3< bool,const Glib::RefPtr<PrintOperationPreview>&,const Glib::RefPtr<PrintContext>&,Window* > signal_preview();


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The GtkPageSetup used by default.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<PageSetup> > property_default_page_setup() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The GtkPageSetup used by default.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<PageSetup> > property_default_page_setup() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The GtkPrintSettings used for initializing the dialog.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<PrintSettings> > property_print_settings() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The GtkPrintSettings used for initializing the dialog.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<PrintSettings> > property_print_settings() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** A string used for identifying the print job.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Glib::ustring> property_job_name() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** A string used for identifying the print job.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_job_name() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The number of pages in the document.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<int> property_n_pages() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The number of pages in the document.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_n_pages() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The current page in the document.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<int> property_current_page() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The current page in the document.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_current_page() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** TRUE if the the origin of the context should be at the corner of the page and not the corner of the imageable area.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_use_full_page() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** TRUE if the the origin of the context should be at the corner of the page and not the corner of the imageable area.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_use_full_page() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The unit in which distances can be measured in the context.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Unit> property_unit() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The unit in which distances can be measured in the context.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Unit> property_unit() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** TRUE if a progress dialog is shown while printing.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_show_progress() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** TRUE if a progress dialog is shown while printing.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_show_progress() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** TRUE if print process may run asynchronous.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_allow_async() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** TRUE if print process may run asynchronous.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_allow_async() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Export filename.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<std::string> property_export_filename() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Export filename.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<std::string> property_export_filename() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The status of the print operation.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<PrintStatus> property_status() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** A human-readable description of the status.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_status_string() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Label for the tab containing custom widgets.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Glib::ustring> property_custom_tab_label() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Label for the tab containing custom widgets.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_custom_tab_label() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
  virtual void on_done(PrintOperationResult result);
  virtual void on_begin_print(const Glib::RefPtr<PrintContext>& context);
  virtual bool on_paginate(const Glib::RefPtr<PrintContext>& context);
  virtual void on_request_page_setup(const Glib::RefPtr<PrintContext>& context, int page_no, const Glib::RefPtr<PageSetup>& setup);
  virtual void on_draw_page(const Glib::RefPtr<PrintContext>& context, int page_nr);
  virtual void on_end_print(const Glib::RefPtr<PrintContext>& context);
  virtual void on_status_changed();
  virtual Widget* on_create_custom_widget();
  virtual void on_custom_widget_apply(Widget* widget);
  virtual bool on_preview(const Glib::RefPtr<PrintOperationPreview>& preview, const Glib::RefPtr<PrintContext>& context, Window* parent);


};

  //TODO: Make these static members of a class instead of non-class functions?

  //Note: gtk_run_page_setup_dialog() can take a null page_setup object, but the application should always 
  //store and reuse a page_setup object, so I see no need to provide an overload for that. murrayc.
  //TODO: The parent parameter may also be null, so maybe we should add an overload for that.

  /** Runs a page setup dialog, letting the user modify the values from page_setup. 
   * If the user cancels the dialog, the returned PageSetup is identical to that passed in @a page_setup, 
   * otherwise it contains the modifications done in the dialog.
   * 
   * Note that this function may use a recursive mainloop to show the page setup dialog. 
   * See run_page_setup_dialog_async() if this is a problem.
   *
   * @param parent Transient parent.
   * @param page_setup An existing GtkPageSetup.
   * @param settings Print settings.
   * @result A new PageSetup object.
   *
   * @since 2.10
   */
  Glib::RefPtr<PageSetup> run_page_setup_dialog(Window& parent,
                                                const Glib::RefPtr<const PageSetup>& page_setup,
                                                const Glib::RefPtr<const PrintSettings>& print_settings);

  /** For example, 
   * void on_setup_done(const Glib::RefPtr<PageSetup>& page_setup);
   */
  typedef sigc::slot< void, const Glib::RefPtr<PageSetup>& > SlotPrintSetupDone;

  /** Runs a page setup dialog, letting the user modify the values from page_setup.
   *
   * In contrast to run_page_setup_dialog(), this function returns after showing the 
   * page setup dialog on platforms that support this, and calls the @a slot from a 
   * signal handler for the ::response signal of the dialog.
   *
   * @param parent Transient parent.
   * @param page_setup An existing GtkPageSetup.
   * @param settings Print settings.
   * @result A new PageSetup object.
   * @param slot
   *
   * @since 2.10
   */
  void run_page_setup_dialog_async(Window& parent,
                                   const Glib::RefPtr<const PageSetup>& page_setup,
                                   const Glib::RefPtr<const PrintSettings>& print_settings,
                                   const SlotPrintSetupDone& slot);

} // namespace Gtk


namespace Glib
{
  /** @relates Gtk::PrintOperation
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
  Glib::RefPtr<Gtk::PrintOperation> wrap(GtkPrintOperation* object, bool take_copy = false);
}


#endif /* _GTKMM_PRINTOPERATION_H */

