// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _ATKMM_RELATIONSET_H
#define _ATKMM_RELATIONSET_H


#include <glibmm.h>

/* $Id: relationset.hg,v 1.3 2005/01/05 18:21:30 murrayc Exp $ */

/* Copyright (C) 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include <atkmm/relation.h>
#include <atkmm/object.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _AtkRelationSet AtkRelationSet;
typedef struct _AtkRelationSetClass AtkRelationSetClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Atk
{ class RelationSet_Class; } // namespace Atk
namespace Atk
{

/** A set of Atk::Relations, normally the set of AtkRelations which an Atk::Object has.
 */

class RelationSet : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef RelationSet CppObjectType;
  typedef RelationSet_Class CppClassType;
  typedef AtkRelationSet BaseObjectType;
  typedef AtkRelationSetClass BaseClassType;

private:  friend class RelationSet_Class;
  static CppClassType relationset_class_;

private:
  // noncopyable
  RelationSet(const RelationSet&);
  RelationSet& operator=(const RelationSet&);

protected:
  explicit RelationSet(const Glib::ConstructParams& construct_params);
  explicit RelationSet(AtkRelationSet* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~RelationSet();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  AtkRelationSet*       gobj()       { return reinterpret_cast<AtkRelationSet*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const AtkRelationSet* gobj() const { return reinterpret_cast<AtkRelationSet*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  AtkRelationSet* gobj_copy();

private:

protected:
  RelationSet();

public:
  
  static Glib::RefPtr<RelationSet> create();


  /** Determines whether the relation set contains a relation that matches the
   * specified type.
   * @param relationship An Atk::RelationType.
   * @return <tt>true</tt> if @a relationship  is the relationship type of a relation
   * in @a set , <tt>false</tt> otherwise.
   */
  bool set_contains(RelationType relationship);
  
  /** Removes a relation from the relation set.
   * This function unref's the Atk::Relation so it will be deleted unless there
   * is another reference to it.
   * @param relation An Atk::Relation.
   */
  void set_remove(const Glib::RefPtr<Relation>& relation);
  
  /** Add a new relation to the current relation set if it is not already
   * present.
   * This function ref's the AtkRelation so the caller of this function
   * should unref it to ensure that it will be destroyed when the AtkRelationSet
   * is destroyed.
   * @param relation An Atk::Relation.
   */
  void set_add(const Glib::RefPtr<Relation>& relation);
  
  /** Determines the number of relations in a relation set.
   * @return An integer representing the number of relations in the set.
   */
  int get_n_relations() const;
  
  /** Determines the relation at the specified position in the relation set.
   * @param i A <tt>int</tt> representing a position in the set, starting from 0.
   * @return A Atk::Relation, which is the relation at position i in the set.
   */
  Glib::RefPtr<Relation> get_relation(gint i);
  
  /** Finds a relation that matches the specified type.
   * @param relationship An Atk::RelationType.
   * @return An Atk::Relation, which is a relation matching the specified type.
   */
  Glib::RefPtr<Relation> get_relation(RelationType relationship);
  
  
  void add_relation_by_type(RelationType relationship, const Glib::RefPtr<Atk::Object>& target);


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Atk


namespace Glib
{
  /** @relates Atk::RelationSet
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
  Glib::RefPtr<Atk::RelationSet> wrap(AtkRelationSet* object, bool take_copy = false);
}


#endif /* _ATKMM_RELATIONSET_H */

