// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _PANGOMM_LANGUAGE_H
#define _PANGOMM_LANGUAGE_H

#include <glibmm.h>

/* Copyright (C) 2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <pango/pango-attributes.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
extern "C" { typedef struct _PangoLanguage PangoLanguage; }
#endif

namespace Pango
{

/** A Pango::Language is used to represent a language.
 */
class Language
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Language CppObjectType;
  typedef PangoLanguage BaseObjectType;

  static GType get_type() G_GNUC_CONST;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


  explicit Language(PangoLanguage* gobject, bool make_a_copy = true);

  Language(const Language& other);
  Language& operator=(const Language& other);

  ~Language();

  void swap(Language& other);

  ///Provides access to the underlying C instance.
  PangoLanguage*       gobj()       { return gobject_; }

  ///Provides access to the underlying C instance.
  const PangoLanguage* gobj() const { return gobject_; }

  // The caller is responsible for freeing it. Use when directly setting fields in structs.
  PangoLanguage* gobj_copy() const;

protected:
  PangoLanguage* gobject_;

private:

   //This function is a bad hack for internal use by renderers and Pango (from pango/pango-utils.c)
   //This is defined as a macro
  

public:
  /** Constructs an empty language tag.
   */
  Language();

  /** Constructs a Pango::Language object from a RFC-3066 format language tag.
   * This function first canonicalizes the string by converting it to lowercase,
   * mapping '_' to '-', and stripping all characters other than letters and '-'.
   */
  Language(const Glib::ustring& language);

  /** Gets a RFC-3066 format string representing the given language tag.
   * @return A string representing the language tag. An empty string is returned if the language tag is empty.
   */
  Glib::ustring get_string() const;

  
  bool matches(const Glib::ustring & range_list) const;


};

} /* namespace Pango */


namespace Pango
{

/** @relates Pango::Language */
inline void swap(Language& lhs, Language& rhs)
  { lhs.swap(rhs); }

} // namespace Pango

namespace Glib
{

/** @relates Pango::Language */
Pango::Language wrap(PangoLanguage* object, bool take_copy = false);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
template <>
class Value<Pango::Language> : public Glib::Value_Boxed<Pango::Language>
{};
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

} // namespace Glib

#endif /* _PANGOMM_LANGUAGE_H */

