// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_LAYOUT_H
#define _GTKMM_LAYOUT_H

#include <glibmm.h>

/* $Id: layout.hg,v 1.1.1.1 2003/01/21 13:40:28 murrayc Exp $ */

/* layout.h
 * 
 * Copyright (C) 2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/container.h>
#include <gtkmm/adjustment.h>
#include <gdkmm/window.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkLayout GtkLayout;
typedef struct _GtkLayoutClass GtkLayoutClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class Layout_Class; } // namespace Gtk
namespace Gtk
{

/** Infinite scrollable area containing child widgets and/or custom drawing.
 *
 * Gtk::Layout is similar to Gtk::DrawingArea in that it's a "blank slate"
 * and doesn't do anything but paint a blank background by default. It's
 * different in that it supports scrolling natively (You can add it directly
 * to a Gtk::ScrolledWindow), and it can contain child widgets, since it's a
 * Gtk::Container.  However if you're just going to draw, a Gtk::DrawingArea
 * is a better choice since it has lower overhead.
 *
 * When handling expose_event signals, you must draw to the bin_window
 * Gdk::Window - see get_bin_window() - rather than the normal Gdk::Window -
 * see get_window() - as you would for a drawing area.
 *
 * @ingroup Widgets
 * @ingroup Containers
 */

class Layout : public Container
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Layout CppObjectType;
  typedef Layout_Class CppClassType;
  typedef GtkLayout BaseObjectType;
  typedef GtkLayoutClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~Layout();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class Layout_Class;
  static CppClassType layout_class_;

  // noncopyable
  Layout(const Layout&);
  Layout& operator=(const Layout&);

protected:
  explicit Layout(const Glib::ConstructParams& construct_params);
  explicit Layout(GtkLayout* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  GtkLayout*       gobj()       { return reinterpret_cast<GtkLayout*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const GtkLayout* gobj() const { return reinterpret_cast<GtkLayout*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  virtual void on_set_scroll_adjustments(Adjustment* p1, Adjustment* p2);


private:

  
public:
  Layout();
  Layout (Adjustment& hadjustment, Adjustment& vadjustment);

  
  void put(Widget &widget, int x, int y);
  
  void move(Widget &widget, int x, int y);
  
  void set_size(guint width, guint height);
  
  void get_size(guint& width, guint& height) const;

  
  void set_hadjustment(Adjustment& hadj);

  /// Creates the Adjustment.
  void set_hadjustment();
  
  Adjustment* get_hadjustment();
  
  const Adjustment* get_hadjustment() const;
  
  void set_vadjustment(Adjustment& vadj);

  /// Creates the Adjustment.
  void set_vadjustment();
  
  Adjustment* get_vadjustment();
  
  const Adjustment* get_vadjustment() const;

  Glib::RefPtr<Gdk::Window> get_bin_window();
  Glib::RefPtr<const Gdk::Window> get_bin_window() const;

  // See Gtk::Widget::set_scroll_adjustments()
  
  /**
   * @par Prototype:
   * <tt>void %set_scroll_adjustments(Adjustment* p1, Adjustment* p2)</tt>
   */
  Glib::SignalProxy2<void,Adjustment*,Adjustment*> signal_set_scroll_adjustments();


  Glib::PropertyProxy<Adjustment*> property_hadjustment();

  Glib::PropertyProxy<Adjustment*> property_vadjustment();

  Glib::PropertyProxy<guint> property_width();

  Glib::PropertyProxy<guint> property_height();


};

} /* namespace Gtk */


namespace Glib
{
  /** @relates Gtk::Layout */
  Gtk::Layout* wrap(GtkLayout* object, bool take_copy = false);
}
#endif /* _GTKMM_LAYOUT_H */

