// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_TOOLBAR_H
#define _GTKMM_TOOLBAR_H

#include <glibmm.h>

/* $Id: toolbar.hg,v 1.40 2002/12/29 03:04:16 daniel Exp $ */

/* Copyright (C) 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/helperlist.h>
#include <gtkmm/container.h>
#include <gtkmm/stockid.h>
#include <gtk/gtktoolbar.h> /* Needed for GtkToolbarChild */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkToolbar GtkToolbar;
typedef struct _GtkToolbarClass GtkToolbarClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class Toolbar_Class; } // namespace Gtk
namespace Gtk
{


/** @addtogroup gtkmmEnums Enums and Flags */

/**
 * @ingroup gtkmmEnums
 */
enum ToolbarChildType
{
  TOOLBAR_CHILD_SPACE,
  TOOLBAR_CHILD_BUTTON,
  TOOLBAR_CHILD_TOGGLEBUTTON,
  TOOLBAR_CHILD_RADIOBUTTON,
  TOOLBAR_CHILD_WIDGET
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::ToolbarChildType> : public Glib::Value_Enum<Gtk::ToolbarChildType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{


/** @defgroup Toolbars Toolbar classes
 */

/* toolbar is a bit of a factory.  We will
represent this by making a virtual list called
tools.  Tools iterates through the children
of list.  It looks like list<Toolbar_Helpers::Tool*>
but inserts Toolbar::Element.  Elements 
are a factory for spaces, widget, buttons, toggle
buttons and radio buttons. 

The name "icon" in the gtk+ interface is very
misleading, it is really a button content
not a pixmap.  We will rename it to "content".

Confused?  Okay go read the interface.
*/
class Toolbar;

namespace RadioButton_Helpers { class Group; }

namespace Toolbar_Helpers
{
/*********************************************************************
***** Elem classes (This should be an easy and cool interface) 
*********************************************************************/

typedef SigC::Slot0<void> Callback0;

// Tool is the output class (very thin wrapper)
class Tool : private GtkToolbarChild
{
private:
  Tool(const Tool&);
  Tool& operator=(const Tool&);

public:
  ToolbarChildType get_type() const;
  Widget* get_widget()  const;
  Widget* get_content() const;
  Label*  get_label()   const;

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  friend class Dummy_; // silence the compiler (Child has only private ctors)
#endif
};

// Element is the input class
class ToolList;
class Element
{
friend class ToolList;
protected:
  ToolbarChildType    type_;
  Widget*             widget_;
  Glib::ustring       text_;
  bool                has_text_;
  StockID             stock_id_;
  Glib::ustring       tooltip_text_;
  Glib::ustring       tooltip_private_text_;
  Widget*             content_; // This does not need to be a pixmap.
  Callback0           callback_;
  RadioButton_Helpers::Group* group_;

private:
  Element& operator=(const Element&);

protected:
  // some fields are mutually exclusive
  Element(ToolbarChildType      type,
          Widget*               widget,
          const Glib::ustring&  text,
          bool                  has_text,
          const Gtk::StockID&   stock_id,
          const Glib::ustring&  tooltip_text,
          const Glib::ustring&  tooltip_private_text,
          Widget*               content,
          const Callback0&      callback);

public:
  Element(const Element& other);

  Element(Widget& widget,
          const Glib::ustring& tooltip_text         = Glib::ustring(),
          const Glib::ustring& tooltip_private_text = Glib::ustring());
};

/** @ingroup Toolbars
 */
struct Space : public Element
{
  Space();
};

/** @ingroup Toolbars
 */
struct StockElem : public Element
{
  StockElem(const Gtk::StockID&  stock_id,
            const Callback0&     callback,
            const Glib::ustring& tooltip_text         = Glib::ustring(),
            const Glib::ustring& tooltip_private_text = Glib::ustring());
};

typedef Element WidgetElem;

// Order here is different than gtk+, watch yourself
// Each button set has 3 forms i
//   with a Glib::ustring and content
//   with a Glib::ustring
//   with content (ie Pixmap, images, etc)
//
/** @ingroup Toolbars
 */
struct ButtonElem : public Element
{
  ButtonElem(const Glib::ustring& text,
             Widget&         content,
             const Callback0&     callback,
             const Glib::ustring& tooltip_text         = Glib::ustring(),
             const Glib::ustring& tooltip_private_text = Glib::ustring());

  ButtonElem(Widget&         content,
             const Callback0&     callback,
             const Glib::ustring& tooltip_text         = Glib::ustring(),
             const Glib::ustring& tooltip_private_text = Glib::ustring());

  ButtonElem(const Glib::ustring& text,
             const Callback0&     callback,
             const Glib::ustring& tooltip_text         = Glib::ustring(),
             const Glib::ustring& tooltip_private_text = Glib::ustring());
};

/** @ingroup Toolbars
 */
struct ToggleElem : public Element
{
  ToggleElem(const Glib::ustring& text,
             Widget&         content,
             const Callback0&     callback,
             const Glib::ustring& tooltip_text         = Glib::ustring(),
             const Glib::ustring& tooltip_private_text = Glib::ustring());

  ToggleElem(Widget&         content,
             const Callback0&     callback,
             const Glib::ustring& tooltip_text         = Glib::ustring(),
             const Glib::ustring& tooltip_private_text = Glib::ustring());

  ToggleElem(const Glib::ustring& text,
             const Callback0&     callback,
             const Glib::ustring& tooltip_text         = Glib::ustring(),
             const Glib::ustring& tooltip_private_text = Glib::ustring());
};

/** @ingroup Toolbars
 */
struct RadioElem : public Element
{
  RadioElem(RadioButton_Helpers::Group& group,
            const Glib::ustring& text,
            Widget&         content,
            const Callback0&     callback             = Callback0(),
            const Glib::ustring& tooltip_text         = Glib::ustring(),
            const Glib::ustring& tooltip_private_text = Glib::ustring());

  RadioElem(RadioButton_Helpers::Group& group,
            Widget&         content,
            const Callback0&     callback             = Callback0(),
            const Glib::ustring& tooltip_text         = Glib::ustring(),
            const Glib::ustring& tooltip_private_text = Glib::ustring());

  RadioElem(RadioButton_Helpers::Group& group,
            const Glib::ustring& text,
            const Callback0&     callback             = Callback0(),
            const Glib::ustring& tooltip_text         = Glib::ustring(),
            const Glib::ustring& tooltip_private_text = Glib::ustring());
};

/*********************************************************************
***** List properties
*********************************************************************/
 
  
class ToolList : public Glib::HelperList< Tool, const Element, Glib::List_Iterator< Tool > >
{
public:
  ToolList();
  explicit ToolList(GtkToolbar* gparent);
  ToolList(const ToolList& src);
  virtual ~ToolList() {}

  ToolList& operator=(const ToolList& src);

  typedef Glib::HelperList< Tool, const Element,  Glib::List_Iterator< Tool > > type_base;

  GtkToolbar* gparent();
  const GtkToolbar* gparent() const;

  virtual GList*& glist() const;      // front of list

  virtual void erase(iterator start, iterator stop);
  virtual iterator erase(iterator);  //Implented as custom or by LIST_CONTAINER_REMOVE
  virtual void remove(const_reference); //Implented as custom or by LIST_CONTAINER_REMOVE

  /// This is order n. (use at own risk)
  reference operator[](size_type l) const;

public:
  iterator insert(iterator position, element_type& e); //custom-implemented.

  template <class InputIterator>
  inline void insert(iterator position, InputIterator first, InputIterator last)
  {
    for(;first != last; ++first)
      position = insert(position, *first);
  }

 inline void push_front(element_type& e)
    { insert(begin(), e); }
  inline void push_back(element_type& e)
    { insert(end(), e); }


  virtual void remove(Widget& widget);
  
  iterator find(const_reference c);
  iterator find(Widget&);

  };


} /* namespace Toolbar_Helpers */


/** Bars of buttons and other widgets.
 * The STL-style container is available via the tools() method.
 * @ingroup Widgets
 * @ingroup Containers
 * @ingroup Toolbars
 */

class Toolbar : public Container
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Toolbar CppObjectType;
  typedef Toolbar_Class CppClassType;
  typedef GtkToolbar BaseObjectType;
  typedef GtkToolbarClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~Toolbar();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class Toolbar_Class;
  static CppClassType toolbar_class_;

  // noncopyable
  Toolbar(const Toolbar&);
  Toolbar& operator=(const Toolbar&);

protected:
  explicit Toolbar(const Glib::ConstructParams& construct_params);
  explicit Toolbar(GtkToolbar* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  GtkToolbar*       gobj()       { return reinterpret_cast<GtkToolbar*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const GtkToolbar* gobj() const { return reinterpret_cast<GtkToolbar*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  virtual void on_orientation_changed(Orientation orientation);
  virtual void on_toolbar_style_changed(ToolbarStyle style);


private:

public:
  typedef Toolbar_Helpers::ToolList ToolList;

  Toolbar();


/* Style methods */
  
  void set_orientation(Orientation orientation);
  
  /** Retrieves the current orientation of the toolbar. See
   * set_orientation().
   * @return The orientation.
   */
  Orientation get_orientation() const;

  
  void set_toolbar_style(ToolbarStyle style);
  
  /** Retrieves whether the toolbar has text, icons, or both . See
   * set_style().
   * @return The current style of @a toolbar .
   */
  ToolbarStyle get_toolbar_style() const;

  
  void set_tooltips(bool enable = true);
  
  /** Retrieves whether tooltips are enabled. See
   * set_tooltips().
   * @return <tt>true</tt> if tooltips are enabled.
   */
  bool get_tooltips() const;

  
  /** This function sets the size of stock icons in the toolbar. You
   * can call it both before you add the icons and after they've been
   * added. The size you set will override user preferences for the default
   * icon size.
   * @param icon_size The Gtk::IconSize that stock icons in the toolbar shall have.
   */
  void set_icon_size(IconSize icon_size);
  
  /** Retrieves the icon size fo the toolbar. See set_icon_size().
   * @return The current icon size for the icons on the toolbar.
   */
  IconSize get_icon_size() const;

  
  /** Unsets a toolbar style set with set_style(), so that
   * user preferences will be used to determine the toolbar style.
   */
  void unset_toolbar_style();
  
  /** Unsets toolbar icon size set with set_icon_size(), so that
   * user preferences will be used to determine the icon size.
   */
  void unset_icon_size();

  
  /**
   * @par Prototype:
   * <tt>void %orientation_changed(Orientation orientation)</tt>
   */
  Glib::SignalProxy1<void,Orientation> signal_orientation_changed();

  
  /**
   * @par Prototype:
   * <tt>void %toolbar_style_changed(ToolbarStyle style)</tt>
   */
  Glib::SignalProxy1<void,ToolbarStyle> signal_toolbar_style_changed();


  ///STL-style container.
  ToolList& tools();
  
  ///STL-style container.
  const ToolList& tools() const;


  typedef Toolbar_Helpers::Callback0 Callback0;
  Gtk::Widget* append_item(const Glib::ustring& text, const Glib::ustring& tooltip_text, const Glib::ustring& tooltip_private_text,
    Gtk::Widget& icon, Callback0 slot);
  Gtk::Widget* append_item(const Glib::ustring& text, const Glib::ustring& tooltip_text, const Glib::ustring& tooltip_private_text,
    Callback0 slot);
  
    
  Gtk::Widget* prepend_item(const Glib::ustring& text, const Glib::ustring& tooltip_text, const Glib::ustring& tooltip_private_text,
    Gtk::Widget& icon, Callback0 slot);
  Gtk::Widget* prepend_item(const Glib::ustring& text, const Glib::ustring& tooltip_text, const Glib::ustring& tooltip_private_text,
    Callback0 slot);
  
    
  Gtk::Widget* insert_item(const Glib::ustring& text, const Glib::ustring& tooltip_text, const Glib::ustring& tooltip_private_text,
    Gtk::Widget& icon, Callback0 slot,
    int position);
  Gtk::Widget* insert_item(const Glib::ustring& text, const Glib::ustring& tooltip_text, const Glib::ustring& tooltip_private_text,
    Callback0 slot,
    int position);
  

  Gtk::Widget* insert_stock(const Gtk::StockID& stock_id, const Glib::ustring& tooltip_text, const Glib::ustring& tooltip_private_text,
    Callback0 slot,
    int position);
  

  void append_space();
  
  void prepend_space();
  
  void insert_space(int position);
  
  /** Removes a space from the specified position.
   * @param position The index of the space to remove.
   */
  void remove_space(int position);

  
  /** Adds a widget to the end of the given toolbar.
   * @param widget A Gtk::Widget to add to the toolbar.
   * @param tooltip_text The element's tooltip.
   * @param tooltip_private_text Used for context-sensitive help about this toolbar element.
   */
  void append_widget(Gtk::Widget& widget, const Glib::ustring& tooltip_text = Glib::ustring(), const Glib::ustring& tooltip_private_text = Glib::ustring());
  
  /** Adds a widget to the beginning of the given toolbar.
   * @param widget A Gtk::Widget to add to the toolbar.
   * @param tooltip_text The element's tooltip.
   * @param tooltip_private_text Used for context-sensitive help about this toolbar element.
   */
  void prepend_widget(Gtk::Widget& widget, const Glib::ustring& tooltip_text = Glib::ustring(), const Glib::ustring& tooltip_private_text = Glib::ustring());
  
  /** Inserts a widget in the toolbar at the given position.
   * @param widget A Gtk::Widget to add to the toolbar.
   * @param tooltip_text The element's tooltip.
   * @param tooltip_private_text Used for context-sensitive help about this toolbar element.
   * @param position The number of widgets to insert this widget after.
   */
  void insert_widget(Gtk::Widget& widget, const Glib::ustring& tooltip_text, const Glib::ustring& tooltip_private_text, int position);

  //Let's not wrap gtk_toolbar_*_element(), because they don't do anything extra, and it's an unclear API.
  

  Glib::PropertyProxy<Orientation> property_orientation();

  Glib::PropertyProxy<ToolbarStyle> property_toolbar_style();


protected:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  mutable ToolList tools_proxy_;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


};

} // namespace Gtk


namespace Glib
{
  /** @relates Gtk::Toolbar */
  Gtk::Toolbar* wrap(GtkToolbar* object, bool take_copy = false);
}
#endif /* _GTKMM_TOOLBAR_H */

