// Generated by gtkmmproc -- DO NOT MODIFY!

#include <gtkmm/notebook.h>
#include <gtkmm/private/notebook_p.h>

#include <gtk/gtktypebuiltins.h>
// -*- c++ -*-
/* $Id: notebook.ccg,v 1.16 2002/10/31 12:19:11 daniel Exp $ */

/* Copyright 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtknotebook.h>
#include <gtkmm/label.h>


namespace Gtk
{

namespace Notebook_Helpers
{

/**** Gtk::Notebook_Helpers::PageIterator **********************************/

bool PageIterator::equal(const PageIterator& other) const
{
  return (node_ == other.node_);
}

PageIterator::operator bool() const
{
  return (node_ != 0);
}

PageIterator& PageIterator::operator++()
{
  g_return_val_if_fail(node_ != 0, *this);

  node_ = node_->next;
  return *this;
}

const PageIterator PageIterator::operator++(int)
{
  const PageIterator tmp (*this);
  this->operator++();
  return tmp;
}

PageIterator& PageIterator::operator--()
{
  if(node_)
    node_ = node_->prev;
  else
    node_ = g_list_last(parent_->gobj()->children);

  return *this;
}

const PageIterator PageIterator::operator--(int)
{
  const PageIterator tmp (*this);
  this->operator--();
  return tmp;
}


/*********************************************************************
***** Page Properties
*********************************************************************/

int Page::get_page_num() const
{
  return g_list_position(parent_->gobj()->children, node_);
}

Widget* Page::get_child() const
{
  return parent_->get_nth_page(get_page_num());
}

Widget* Page::get_tab_label() const
{
  return parent_->get_tab_label(*get_child());
}

void Page::set_tab_label(Widget& tab_label)
{
  parent_->set_tab_label(*get_child(), tab_label);
}

void Page::set_tab_label_text(const Glib::ustring& tab_text)
{
  parent_->set_tab_label_text(*get_child(), tab_text);
}

Glib::ustring Page::get_tab_label_text() const
{
  return parent_->get_tab_label_text(*get_child());
}

Widget* Page::get_menu_label() const
{
  return parent_->get_menu_label(*get_child());
}

void Page::set_menu_label(Widget& menu_label)
{
  parent_->set_menu_label(*get_child(), menu_label);
}

void Page::set_menu_label_text(const Glib::ustring& menu_text)
{
  parent_->set_menu_label_text(*get_child(), menu_text);
}

Glib::ustring Page::get_menu_label_text() const
{
  return parent_->get_menu_label_text(*get_child());
}

void Page::query_tab_label_packing(bool& expand, bool& fill, PackType& pack_type)
{
  parent_->query_tab_label_packing(*get_child(), expand, fill, pack_type);
}

void Page::set_tab_label_packing(bool expand, bool fill, PackType pack_type)
{
  parent_->set_tab_label_packing(*get_child(), expand, fill, pack_type);
}

/*********************************************************************
***** List properties
*********************************************************************/
PageList::PageList()
:
  gparent_ (0)
{}

PageList::PageList(GtkNotebook* gparent)
:
  gparent_ (gparent)
{}

PageList::PageList(const PageList& src)
{
  operator=(src);
}

PageList& PageList::operator=(const PageList& src)
{
  gparent_ = src.gparent_;
  return *this;
}

PageList::size_type PageList::max_size() const
{
  return G_MAXINT;
}

bool PageList::empty() const
{
  return (gparent_->children == 0);
}

PageList::size_type PageList::size() const
{
  return g_list_length(gparent_->children);
}

PageList::value_type PageList::front() const
{
  return *begin();
}

PageList::value_type PageList::back() const
{
  iterator pend (end());
  return *--pend;
}

PageList::value_type PageList::operator[](size_type index) const
{
  GList *const node = g_list_nth(gparent_->children, index);
  g_assert(node != 0);

  return *iterator(Glib::wrap(gparent_), node);
}

PageList::iterator PageList::insert(PageList::iterator position, const Element& elem)
{
  // Get the iterator index, or -1 for end().
  const int index = (position) ? position->get_page_num() : -1;

  // Give item to GTK+.
  gtk_notebook_insert_page_menu(gparent_,
                                Glib::unwrap(elem.child_),
                                Glib::unwrap(elem.tab_),
                                Glib::unwrap(elem.menu_),
                                index);

  // Return an iterator pointing to the inserted element.
  return --position;
}

void PageList::erase(PageList::iterator start, PageList::iterator stop)
{
  while(start != stop)
    start = erase(start);
}

PageList::iterator PageList::erase(PageList::iterator position)
{
  iterator next (position);

  if(position)
  {
    ++next;
    gtk_container_remove(GTK_CONTAINER(gparent_), position->get_child()->gobj());
  }

  return next;
}

void PageList::remove(const_reference child)
{
//  g_return_if_fail(child.parent_ != 0);
  gtk_container_remove(GTK_CONTAINER(gparent_), child.get_child()->gobj());
}

void PageList::remove(Widget& widget)
{
  gtk_container_remove(GTK_CONTAINER(gparent_), widget.gobj());
}

void PageList::reorder(PageList::iterator position, PageList::iterator page)
{
  gtk_notebook_reorder_child(gparent(), page->get_child()->gobj(), position->get_page_num());
}

PageList::iterator PageList::find(int num)
{
  if(num < 0) return end();
  int j = 0;
  iterator i;
  for(i = begin(), j = 0; i != end(), j < num; ++i, ++j);
  return i;
}

PageList::iterator PageList::find(const_reference c)
{
  iterator i = begin();
  for(i = begin(); i != end() && ((*i).get_child() != c.get_child()); i++);
  return i;
}

PageList::iterator PageList::find(Widget& widget)
{
  iterator i;
  for(i = begin(); i != end() && ((*i).get_child() != &widget); i++);
  return i;
}

PageList::iterator PageList::find(GtkNotebookPage* page)
{
  GList* node = gparent_->children;

  while(node && node->data != page)
    node = node->next;

  return (node) ? iterator(Glib::wrap(gparent_), node) : end();
}

void PageList::clear()
{
  erase(begin(), end());
}

PageList::iterator PageList::begin_() const
{
  return iterator(Glib::wrap(gparent_), gparent_->children);
}

PageList::iterator PageList::end_() const
{
  return iterator(Glib::wrap(gparent_), 0);
}

Element::Element(Widget* child, Widget* tab, Widget* menu)
:
  child_  (child),
  tab_    (tab),
  menu_   (menu)
{}

Element::Element(Widget& child, Widget& tab, Widget& menu)
:
  child_  (&child),
  tab_    (&tab),
  menu_   (&menu)
{}

Element::Element(Widget& child)
:
  child_  (&child),
  tab_    (0),
  menu_   (0)
{}

TabElem::TabElem(Widget& child, Widget& tab)
:
  Element(&child, &tab, 0)
{}

TabElem::TabElem(Widget& child, const Glib::ustring& label, bool mnemonic)
:
  Element(&child, manage(new Label(label, mnemonic)), 0)
{}

MenuElem::MenuElem(Widget& child, Widget& menu)
:
  Element(&child, 0, &menu)
{}

} /* namespace Notebook_Helpers */


Notebook::PageList::iterator Notebook::get_current()
{
  return pages().find(get_current_page());
}

Notebook::PageList& Notebook::pages()
{
  pages_proxy_ = PageList(gobj());
  return pages_proxy_;
}

const Notebook::PageList& Notebook::pages() const
{
  pages_proxy_ = PageList(const_cast<GtkNotebook*>(gobj()));
  return pages_proxy_;
}

/*Widget* Notebook::get_current_page()
{
  return get_nth_page(get_current_page_num());
}*/

void Notebook::prepend_page(Widget& child, const Glib::ustring& tab_label, bool use_mnemonic)
{
  Label* pLabel = Gtk::manage( new Label(tab_label, use_mnemonic) );
  prepend_page(child, *pLabel);
}

void Notebook::prepend_page(Widget& child, const Glib::ustring& tab_label, const Glib::ustring& menu_label, bool use_mnemonic)
{
  Label* pLabel = Gtk::manage( new Label(tab_label, use_mnemonic) );
  Label* pLabelMenu = Gtk::manage( new Label(menu_label, use_mnemonic) );
  prepend_page(child, *pLabel, *pLabelMenu);
}

void Notebook::append_page(Widget& child, const Glib::ustring& tab_label, bool use_mnemonic)
{
  Label* pLabel = Gtk::manage( new Label(tab_label, use_mnemonic) );
  append_page(child, *pLabel);
}

void Notebook::append_page(Widget& child, const Glib::ustring& tab_label, const Glib::ustring& menu_label, bool use_mnemonic)
{
  Label* pLabel = Gtk::manage( new Label(tab_label, use_mnemonic) );
  Label* pLabelMenu = Gtk::manage( new Label(menu_label, use_mnemonic) );
  append_page(child, *pLabel, *pLabelMenu);
}

void Notebook::insert_page(Widget& child, const Glib::ustring& tab_label, int position, bool use_mnemonic)
{
  Label* pLabel = Gtk::manage( new Label(tab_label, use_mnemonic) );
  insert_page(child, *pLabel, position);
}

void Notebook::insert_page(Widget& child, const Glib::ustring& tab_label, const Glib::ustring& menu_label, int position, bool use_mnemonic)
{
  Label* pLabel = Gtk::manage( new Label(tab_label, use_mnemonic) );
  Label* pLabelMenu = Gtk::manage( new Label(menu_label, use_mnemonic) );
  insert_page(child, *pLabel, *pLabelMenu, position);
}

void Notebook::remove_page(Widget& child)
{
  int pos = page_num(child);
  if(pos != -1)
    remove_page(pos);
}

void Notebook::query_tab_label_packing(Widget& child, bool& expand, bool& fill, PackType& pack_type)
{
  gboolean gexpand = false;
  gboolean gfill = false;
  GtkPackType gpack_type = GTK_PACK_START;
  gtk_notebook_query_tab_label_packing(gobj(), child.gobj(), &gexpand, &gfill, &gpack_type);
  expand = gexpand;
  fill = gfill;
  pack_type = (PackType)gpack_type;
}

} //namespace Gtk


namespace
{

void Notebook_signal_switch_page_callback(GtkNotebook* self, GtkNotebookPage* p0,guint p1,void* data)
{
  using namespace Gtk;
  typedef SigC::Slot2<void,GtkNotebookPage*,guint> SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    try
    {
      if(SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*(SlotType::Proxy)(slot->proxy_))
            (p0,p1, slot);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
}

const Glib::SignalProxyInfo Notebook_signal_switch_page_info =
{
  "switch_page",
  (GCallback) &Notebook_signal_switch_page_callback,
  (GCallback) &Notebook_signal_switch_page_callback
};


gboolean Notebook_signal_select_page_callback(GtkNotebook* self, gboolean p0,void* data)
{
  using namespace Gtk;
  typedef SigC::Slot1<bool,bool> SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    try
    {
      if(SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>(((*(SlotType::Proxy)(slot->proxy_))
            (p0
, slot)));
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }

  typedef gboolean RType;
  return RType();
}

gboolean Notebook_signal_select_page_notify_callback(GtkNotebook* self, gboolean p0, void* data)
{
  using namespace Gtk;
  typedef SigC::Slot1<void,bool> SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    try
    {
      if(SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*(SlotType::Proxy)(slot->proxy_))
            (p0
, slot);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }

  typedef gboolean RType;
  return RType();
}

const Glib::SignalProxyInfo Notebook_signal_select_page_info =
{
  "select_page",
  (GCallback) &Notebook_signal_select_page_callback,
  (GCallback) &Notebook_signal_select_page_notify_callback
};


gboolean Notebook_signal_focus_tab_callback(GtkNotebook* self, GtkNotebookTab p0,void* data)
{
  using namespace Gtk;
  typedef SigC::Slot1<bool,NotebookTab> SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    try
    {
      if(SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>(((*(SlotType::Proxy)(slot->proxy_))
            (((NotebookTab)(p0))
, slot)));
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }

  typedef gboolean RType;
  return RType();
}

gboolean Notebook_signal_focus_tab_notify_callback(GtkNotebook* self, GtkNotebookTab p0, void* data)
{
  using namespace Gtk;
  typedef SigC::Slot1<void,NotebookTab> SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    try
    {
      if(SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*(SlotType::Proxy)(slot->proxy_))
            (((NotebookTab)(p0))
, slot);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }

  typedef gboolean RType;
  return RType();
}

const Glib::SignalProxyInfo Notebook_signal_focus_tab_info =
{
  "focus_tab",
  (GCallback) &Notebook_signal_focus_tab_callback,
  (GCallback) &Notebook_signal_focus_tab_notify_callback
};


void Notebook_signal_change_current_page_callback(GtkNotebook* self, gint p0,void* data)
{
  using namespace Gtk;
  typedef SigC::Slot1<void,int> SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    try
    {
      if(SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*(SlotType::Proxy)(slot->proxy_))
            (p0
, slot);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
}

const Glib::SignalProxyInfo Notebook_signal_change_current_page_info =
{
  "change_current_page",
  (GCallback) &Notebook_signal_change_current_page_callback,
  (GCallback) &Notebook_signal_change_current_page_callback
};


void Notebook_signal_move_focus_out_callback(GtkNotebook* self, GtkDirectionType p0,void* data)
{
  using namespace Gtk;
  typedef SigC::Slot1<void,DirectionType> SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    try
    {
      if(SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*(SlotType::Proxy)(slot->proxy_))
            (((DirectionType)(p0))
, slot);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
}

const Glib::SignalProxyInfo Notebook_signal_move_focus_out_info =
{
  "move_focus_out",
  (GCallback) &Notebook_signal_move_focus_out_callback,
  (GCallback) &Notebook_signal_move_focus_out_callback
};

} // anonymous namespace

// static
GType Glib::Value<Gtk::NotebookTab>::value_type()
{
  return gtk_notebook_tab_get_type();
}


namespace Glib
{

Gtk::Notebook* wrap(GtkNotebook* object, bool take_copy)
{
  return dynamic_cast<Gtk::Notebook *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gtk
{


/* The *_Class implementation: */

const Glib::Class& Notebook_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &Notebook_Class::class_init_function;

    // TODO: This is currently just optimized away, apparently with no harm.
    // Is it actually necessary?
    // Make sure that the parent type has been created.
    CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gtk_notebook_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:
  }

  return *this;
}

void Notebook_Class::class_init_function(void* g_class, void* class_data)
{
  BaseClassType *const klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);

  klass->switch_page = &switch_page_callback;
  klass->select_page = &select_page_callback;
  klass->focus_tab = &focus_tab_callback;
  klass->change_current_page = &change_current_page_callback;
  klass->move_focus_out = &move_focus_out_callback;
}


void Notebook_Class::switch_page_callback(GtkNotebook* self, GtkNotebookPage* p0, guint p1)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj && obj->is_derived_())
  {
    try // Trap C++ exceptions which would normally be lost because this is a C callback.
    {
      // Call the virtual member method, which derived classes might override.
      obj->on_switch_page(p0, p1);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

    // Call the original underlying C function:
    if(base && base->switch_page)
      (*base->switch_page)(self, p0, p1);
  }
}

gboolean Notebook_Class::select_page_callback(GtkNotebook* self, gboolean p0)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj && obj->is_derived_())
  {
    try // Trap C++ exceptions which would normally be lost because this is a C callback.
    {
      // Call the virtual member method, which derived classes might override.
      return static_cast<int>(obj->on_select_page(p0
));
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

    // Call the original underlying C function:
    if(base && base->select_page)
      return (*base->select_page)(self, p0);
  }

  typedef gboolean RType;
  return RType();
}

gboolean Notebook_Class::focus_tab_callback(GtkNotebook* self, GtkNotebookTab p0)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj && obj->is_derived_())
  {
    try // Trap C++ exceptions which would normally be lost because this is a C callback.
    {
      // Call the virtual member method, which derived classes might override.
      return static_cast<int>(obj->on_focus_tab(((NotebookTab)(p0))
));
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

    // Call the original underlying C function:
    if(base && base->focus_tab)
      return (*base->focus_tab)(self, p0);
  }

  typedef gboolean RType;
  return RType();
}

void Notebook_Class::change_current_page_callback(GtkNotebook* self, gint p0)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj && obj->is_derived_())
  {
    try // Trap C++ exceptions which would normally be lost because this is a C callback.
    {
      // Call the virtual member method, which derived classes might override.
      obj->on_change_current_page(p0
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

    // Call the original underlying C function:
    if(base && base->change_current_page)
      (*base->change_current_page)(self, p0);
  }
}

void Notebook_Class::move_focus_out_callback(GtkNotebook* self, GtkDirectionType p0)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj && obj->is_derived_())
  {
    try // Trap C++ exceptions which would normally be lost because this is a C callback.
    {
      // Call the virtual member method, which derived classes might override.
      obj->on_move_focus_out(((DirectionType)(p0))
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

    // Call the original underlying C function:
    if(base && base->move_focus_out)
      (*base->move_focus_out)(self, p0);
  }
}


Glib::ObjectBase* Notebook_Class::wrap_new(GObject* o)
{
  return manage(new Notebook((GtkNotebook*)(o)));

}


/* The implementation: */

Notebook::Notebook(const Glib::ConstructParams& construct_params)
:
  Gtk::Container(construct_params)
{
  }

Notebook::Notebook(GtkNotebook* castitem)
:
  Gtk::Container((GtkContainer*)(castitem))
{
  }

Notebook::~Notebook()
{
  destroy_();
}

Notebook::CppClassType Notebook::notebook_class_; // initialize static member

GType Notebook::get_type()
{
  return notebook_class_.init().get_type();
}

GType Notebook::get_base_type()
{
  return gtk_notebook_get_type();
}

Notebook::Notebook()
:
  Glib::ObjectBase(0), //Mark this class as gtkmmproc-generated, rather than a custom class, to allow vfunc optimisations.
  Gtk::Container(Glib::ConstructParams(notebook_class_.init()))
{
  }

void Notebook::prepend_page(Widget& child, Widget& tab_label)
{
  gtk_notebook_prepend_page(gobj(), (child).gobj(), (tab_label).gobj());
}

void Notebook::prepend_page(Widget& child, Widget& tab_label, Widget& menu_label)
{
  gtk_notebook_prepend_page_menu(gobj(), (child).gobj(), (tab_label).gobj(), (menu_label).gobj());
}

void Notebook::append_page(Widget& child, Widget& tab_label)
{
  gtk_notebook_append_page(gobj(), (child).gobj(), (tab_label).gobj());
}

void Notebook::append_page(Widget& child, Widget& tab_label, Widget& menu_label)
{
  gtk_notebook_append_page_menu(gobj(), (child).gobj(), (tab_label).gobj(), (menu_label).gobj());
}

void Notebook::insert_page(Widget& child, Widget& tab_label, int position)
{
  gtk_notebook_insert_page(gobj(), (child).gobj(), (tab_label).gobj(), position);
}

void Notebook::insert_page(Widget& child, Widget& tab_label, Widget& menu_label, int position)
{
  gtk_notebook_insert_page_menu(gobj(), (child).gobj(), (tab_label).gobj(), (menu_label).gobj(), position);
}

void Notebook::remove_page(int page_num)
{
  gtk_notebook_remove_page(gobj(), page_num);
}

int Notebook::get_current_page() const
{
  return gtk_notebook_get_current_page(const_cast<GtkNotebook*>(gobj()));
}

Widget* Notebook::get_nth_page(int page_number)
{
  return Glib::wrap(gtk_notebook_get_nth_page(gobj(), page_number));
}

const Widget* Notebook::get_nth_page(int page_number) const
{
  return Glib::wrap(gtk_notebook_get_nth_page(const_cast<GtkNotebook*>(gobj()), page_number));
}

gint Notebook::get_n_pages()
{
  return gtk_notebook_get_n_pages(gobj());
}

int Notebook::page_num(const Widget& child)
{
  return gtk_notebook_page_num(gobj(), const_cast<GtkWidget*>((child).gobj()));
}

void Notebook::set_current_page(int page_number)
{
  gtk_notebook_set_current_page(gobj(), page_number);
}

void Notebook::next_page()
{
  gtk_notebook_next_page(gobj());
}

void Notebook::prev_page()
{
  gtk_notebook_prev_page(gobj());
}

void Notebook::set_show_border(bool show_border)
{
  gtk_notebook_set_show_border(gobj(), static_cast<int>(show_border));
}

bool Notebook::get_show_border() const
{
  return gtk_notebook_get_show_border(const_cast<GtkNotebook*>(gobj()));
}

void Notebook::set_show_tabs(bool show_tabs)
{
  gtk_notebook_set_show_tabs(gobj(), static_cast<int>(show_tabs));
}

bool Notebook::get_show_tabs() const
{
  return gtk_notebook_get_show_tabs(const_cast<GtkNotebook*>(gobj()));
}

void Notebook::set_tab_pos(PositionType pos)
{
  gtk_notebook_set_tab_pos(gobj(), ((GtkPositionType)(pos)));
}

PositionType Notebook::get_tab_pos() const
{
  return ((PositionType)(gtk_notebook_get_tab_pos(const_cast<GtkNotebook*>(gobj()))));
}

void Notebook::set_scrollable(bool scrollable)
{
  gtk_notebook_set_scrollable(gobj(), static_cast<int>(scrollable));
}

bool Notebook::get_scrollable() const
{
  return gtk_notebook_get_scrollable(const_cast<GtkNotebook*>(gobj()));
}

void Notebook::popup_enable()
{
  gtk_notebook_popup_enable(gobj());
}

void Notebook::popup_disable()
{
  gtk_notebook_popup_disable(gobj());
}

Widget* Notebook::get_tab_label(Widget& child)
{
  return Glib::wrap(gtk_notebook_get_tab_label(gobj(), (child).gobj()));
}

const Widget* Notebook::get_tab_label(Widget& child) const
{
  return Glib::wrap(gtk_notebook_get_tab_label(const_cast<GtkNotebook*>(gobj()), (child).gobj()));
}

void Notebook::set_tab_label(Widget& child, Widget& tab_label)
{
  gtk_notebook_set_tab_label(gobj(), (child).gobj(), (tab_label).gobj());
}

void Notebook::set_tab_label_text(Widget& child, const Glib::ustring& tab_text)
{
  gtk_notebook_set_tab_label_text(gobj(), (child).gobj(), tab_text.c_str());
}

Glib::ustring Notebook::get_tab_label_text(Widget& child) const
{
  return Glib::convert_const_gchar_ptr_to_ustring(gtk_notebook_get_tab_label_text(const_cast<GtkNotebook*>(gobj()), (child).gobj()));
}

Widget* Notebook::get_menu_label(Widget& child)
{
  return Glib::wrap(gtk_notebook_get_menu_label(gobj(), (child).gobj()));
}

const Widget* Notebook::get_menu_label(Widget& child) const
{
  return Glib::wrap(gtk_notebook_get_menu_label(const_cast<GtkNotebook*>(gobj()), (child).gobj()));
}

void Notebook::set_menu_label(Widget& child, Widget& menu_label)
{
  gtk_notebook_set_menu_label(gobj(), (child).gobj(), (menu_label).gobj());
}

void Notebook::set_menu_label_text(Widget& child, const Glib::ustring& menu_text)
{
  gtk_notebook_set_menu_label_text(gobj(), (child).gobj(), menu_text.c_str());
}

Glib::ustring Notebook::get_menu_label_text(Widget& child) const
{
  return Glib::convert_const_gchar_ptr_to_ustring(gtk_notebook_get_menu_label_text(const_cast<GtkNotebook*>(gobj()), (child).gobj()));
}

void Notebook::set_tab_label_packing(Widget& child, bool expand, bool fill, PackType pack_type)
{
  gtk_notebook_set_tab_label_packing(gobj(), (child).gobj(), static_cast<int>(expand), static_cast<int>(fill), ((GtkPackType)(pack_type)));
}

void Notebook::reorder_child(Widget& child, int position)
{
  gtk_notebook_reorder_child(gobj(), (child).gobj(), position);
}


Glib::SignalProxy2<void,GtkNotebookPage*,guint> Notebook::signal_switch_page()
{
  return Glib::SignalProxy2<void,GtkNotebookPage*,guint>(this, &Notebook_signal_switch_page_info);
}

Glib::SignalProxy1<bool,bool> Notebook::signal_select_page()
{
  return Glib::SignalProxy1<bool,bool>(this, &Notebook_signal_select_page_info);
}

Glib::SignalProxy1<bool,NotebookTab> Notebook::signal_focus_tab()
{
  return Glib::SignalProxy1<bool,NotebookTab>(this, &Notebook_signal_focus_tab_info);
}

Glib::SignalProxy1<void,int> Notebook::signal_change_current_page()
{
  return Glib::SignalProxy1<void,int>(this, &Notebook_signal_change_current_page_info);
}

Glib::SignalProxy1<void,DirectionType> Notebook::signal_move_focus_out()
{
  return Glib::SignalProxy1<void,DirectionType>(this, &Notebook_signal_move_focus_out_info);
}


Glib::PropertyProxy<PositionType> Notebook::property_tab_pos()
{
  return Glib::PropertyProxy<PositionType>(this, "tab_pos");
}

Glib::PropertyProxy<bool> Notebook::property_show_tabs()
{
  return Glib::PropertyProxy<bool>(this, "show_tabs");
}

Glib::PropertyProxy<bool> Notebook::property_show_border()
{
  return Glib::PropertyProxy<bool>(this, "show_border");
}

Glib::PropertyProxy<bool> Notebook::property_scrollable()
{
  return Glib::PropertyProxy<bool>(this, "scrollable");
}

Glib::PropertyProxy_WriteOnly<guint> Notebook::property_tab_border()
{
  return Glib::PropertyProxy_WriteOnly<guint>(this, "tab_border");
}

Glib::PropertyProxy<guint> Notebook::property_tab_hborder()
{
  return Glib::PropertyProxy<guint>(this, "tab_hborder");
}

Glib::PropertyProxy<guint> Notebook::property_tab_vborder()
{
  return Glib::PropertyProxy<guint>(this, "tab_vborder");
}

Glib::PropertyProxy<int> Notebook::property_page()
{
  return Glib::PropertyProxy<int>(this, "page");
}

Glib::PropertyProxy<bool> Notebook::property_enable_popup()
{
  return Glib::PropertyProxy<bool>(this, "enable_popup");
}

Glib::PropertyProxy<bool> Notebook::property_homogeneous()
{
  return Glib::PropertyProxy<bool>(this, "homogeneous");
}


void Gtk::Notebook::on_switch_page(GtkNotebookPage* page, guint page_num)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->switch_page)
    (*base->switch_page)(gobj(),page,page_num);
}

bool Gtk::Notebook::on_select_page(bool move_focus)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->select_page)
    return (*base->select_page)(gobj(),static_cast<int>(move_focus));

  typedef bool RType;
  return RType();
}

bool Gtk::Notebook::on_focus_tab(NotebookTab type)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->focus_tab)
    return (*base->focus_tab)(gobj(),((GtkNotebookTab)(type)));

  typedef bool RType;
  return RType();
}

void Gtk::Notebook::on_change_current_page(int offset)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->change_current_page)
    (*base->change_current_page)(gobj(),offset);
}

void Gtk::Notebook::on_move_focus_out(DirectionType direction)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->move_focus_out)
    (*base->move_focus_out)(gobj(),((GtkDirectionType)(direction)));
}


} // namespace Gtk


