
#include <gtkmm/treesortable.h>
#include <gtkmm/private/treesortable_p.h>

// -*- c++ -*-
/* $Id: treesortable.ccg,v 1.1 2002/03/22 14:15:38 murrayc Exp $ */

/* 
 *
 * Copyright 1998-1999 The Gtk-- Development Team
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

namespace Gtk
{


} /* namespace Gtk */


namespace
{

const Glib::SignalProxyInfo TreeSortable_signal_sort_column_changed_info =
{
  "sort_column_changed",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};

} // anonymous namespace


namespace Glib
{

Glib::RefPtr<Gtk::TreeSortable> wrap(GtkTreeSortable* object, bool take_copy /* = false */)
{
  return Glib::RefPtr<Gtk::TreeSortable>( dynamic_cast<Gtk::TreeSortable*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Gtk
{


/* The *_Class implementation: */

GType TreeSortable_Class::get_type()
{
  if (!gtype_) //Create the GType if necessary.
    {
      //Make sure that the parent type has been created:
      CppClassParent::CppObjectType::get_type();

      //Get the size of the base C class:
      GType gtype_base = gtk_tree_sortable_get_type();
      gtype_ = gtype_base; //We can not derive from another interface.
/*
      GTypeQuery typeQueryBase = {0 ,};
      g_type_query(gtype_base, &typeQueryBase);

      //Create a derived C type.
      //These init funcs will, in turn, call the init functions in the base C type.
      GTypeInfo info =
        {
          typeQueryBase.class_size, // class_size
          (GBaseInitFunc) 0, // base_init *
          (GBaseFinalizeFunc) 0, // base_finalize
          (GClassInitFunc) class_init_function, // class_init
          0, // class_finalize
          0, // class_data
          typeQueryBase.instance_size, // instance_size
          0, // n_preallocs
          (GInstanceInitFunc) object_init_function // instance_init
        };

      gtype_ = g_type_register_static(gtype_base, "gtkmm__TreeSortable", &info, GTypeFlags(0));
*/
    }
  return gtype_;
}

void TreeSortable_Class::iface_init_function(BaseClassType* iface)
{
  CppClassParent::iface_init_function((GTypeInterface*)iface);
  BaseClassType* klass = iface; //Allows us to reuse generated code from GObject wrappers.
   klass->get_sort_column_id = &get_sort_column_id_vfunc_callback;
  klass->set_sort_func = &set_sort_func_vfunc_callback;
  klass->set_default_sort_func = &set_default_sort_func_vfunc_callback;
  klass->has_default_sort_func = &has_default_sort_func_vfunc_callback;
  klass->set_sort_column_id = &set_sort_column_id_vfunc_callback;
   klass->sort_column_changed = &sort_column_changed_callback;
}

void TreeSortable_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((GTypeInterface*)klass);
}

void TreeSortable_Class::object_init_function(BaseObjectType* object)
{
}

gboolean TreeSortable_Class::get_sort_column_id_vfunc_callback(GtkTreeSortable* self, int* sort_column_id, GtkSortType* order)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      return obj->get_sort_column_id_vfunc(sort_column_id, order);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_interface_peek_parent( // Get the parent interface of the interface.
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
));
    g_assert(base != 0);

    if(base->get_sort_column_id)
      (*base->get_sort_column_id)(self, sort_column_id, order);
  }

  typedef gboolean RType;
  return RType();
}

void TreeSortable_Class::set_sort_func_vfunc_callback(GtkTreeSortable* self, int sort_column_id, GtkTreeIterCompareFunc func, gpointer data, GtkDestroyNotify destroy)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->set_sort_func_vfunc(sort_column_id, func, data, destroy);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_interface_peek_parent( // Get the parent interface of the interface.
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
));
    g_assert(base != 0);

    if(base->set_sort_func)
      (*base->set_sort_func)(self, sort_column_id, func, data, destroy);
  }
}

void TreeSortable_Class::set_default_sort_func_vfunc_callback(GtkTreeSortable* self, GtkTreeIterCompareFunc func, gpointer data, GtkDestroyNotify destroy)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->set_default_sort_func_vfunc(func, data, destroy);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_interface_peek_parent( // Get the parent interface of the interface.
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
));
    g_assert(base != 0);

    if(base->set_default_sort_func)
      (*base->set_default_sort_func)(self, func, data, destroy);
  }
}

gboolean TreeSortable_Class::has_default_sort_func_vfunc_callback(GtkTreeSortable* self)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      return obj->has_default_sort_func_vfunc();
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_interface_peek_parent( // Get the parent interface of the interface.
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
));
    g_assert(base != 0);

    if(base->has_default_sort_func)
      (*base->has_default_sort_func)(self);
  }

  typedef gboolean RType;
  return RType();
}

void TreeSortable_Class::set_sort_column_id_vfunc_callback(GtkTreeSortable* self, int sort_column_id, GtkSortType order)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->set_sort_column_id_vfunc_vfunc(sort_column_id, order);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_interface_peek_parent( // Get the parent interface of the interface.
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
));
    g_assert(base != 0);

    if(base->set_sort_column_id)
      (*base->set_sort_column_id)(self, sort_column_id, order);
  }
}


void TreeSortable_Class::sort_column_changed_callback(GtkTreeSortable* self)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_sort_column_changed();
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_interface_peek_parent( // Get the parent interface of the interface.
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
));
    g_assert(base != 0);

    if(base->sort_column_changed)
      (*base->sort_column_changed)(self);
  }
}


Glib::ObjectBase* TreeSortable_Class::wrap_new(GObject* o)
{
  return new TreeSortable((GtkTreeSortable*)(o));
}


/* The implementation: */

TreeSortable::TreeSortable(GtkTreeSortable* castitem)
: Glib::Interface((GObject*)(castitem))
{}

TreeSortable::~TreeSortable()
{
}

/*
GtkTreeSortable* TreeSortable::gobj_copy()
{
  reference();
  return gobj();
}
*/

Glib::RefPtr<TreeSortable> TreeSortable::wrap_specific_type(GtkTreeSortable* gobject, bool take_copy /* = false */) //static
{
  Glib::RefPtr<TreeSortable> refPtr;
  //Check for an existing wrapper:
  TreeSortable* pCppObject = dynamic_cast<TreeSortable*>(Glib::ObjectBase::_get_current_wrapper(G_OBJECT(gobject)));
  if(pCppObject)
  {
    //Return the existing wrapper:
    refPtr = Glib::RefPtr<TreeSortable>(pCppObject);
  }
  else
  {
    //Create a new wrapper:
    refPtr = Glib::RefPtr<TreeSortable>( new TreeSortable(gobject) );
  }

  if(take_copy)
    refPtr->reference();

  return refPtr;
}

TreeSortable::TreeSortable()
{
}


void TreeSortable::add_interface(GType gtype_implementer) //static
{
  static const GInterfaceInfo iface_info =
  {
	  (GInterfaceInitFunc)CppClassType::iface_init_function,
	  NULL,
	  NULL
  };

  g_type_add_interface_static(
    gtype_implementer,
    get_type(), //interface_type: whose direct parent type must be G_TYPE_INTERFACE
    &iface_info
  );
}

TreeSortable::CppClassType TreeSortable::treesortable_class_; //Initialize static member.

GType TreeSortable::get_type()
{
  return treesortable_class_.get_type();
}

GType TreeSortable::get_base_type()
{
  return gtk_tree_sortable_get_type();
}

void TreeSortable::set_sort_column_id(int sort_column_id, SortType order)
{
  gtk_tree_sortable_set_sort_column_id(gobj(), sort_column_id, ((GtkSortType)(order)));
}

void TreeSortable::set_sort_column_id(const TreeModelColumnBase& sort_column_id, SortType order)
{
  gtk_tree_sortable_set_sort_column_id(gobj(), (sort_column_id).index(), ((GtkSortType)(order)));
}


Glib::SignalProxy0<void> TreeSortable::signal_sort_column_changed()
{
  return Glib::SignalProxy0<void>(this, &TreeSortable_signal_sort_column_changed_info);
}


void Gtk::TreeSortable::on_sort_column_changed()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface.
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
));
  g_assert(base != 0);

  if(base->sort_column_changed)
    (*base->sort_column_changed)(gobj());
}


gboolean Gtk::TreeSortable::get_sort_column_id_vfunc(int* sort_column_id, GtkSortType* order)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface.
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
));
  g_assert(base != 0);

  if(base->get_sort_column_id)
    return (*base->get_sort_column_id)(gobj(),sort_column_id,order);

  typedef gboolean RType;
  return RType();
}

void Gtk::TreeSortable::set_sort_func_vfunc(int sort_column_id, GtkTreeIterCompareFunc func, gpointer data, GtkDestroyNotify destroy)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface.
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
));
  g_assert(base != 0);

  if(base->set_sort_func)
    (*base->set_sort_func)(gobj(),sort_column_id,func,data,destroy);
}

void Gtk::TreeSortable::set_default_sort_func_vfunc(GtkTreeIterCompareFunc func, gpointer data, GtkDestroyNotify destroy)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface.
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
));
  g_assert(base != 0);

  if(base->set_default_sort_func)
    (*base->set_default_sort_func)(gobj(),func,data,destroy);
}

gboolean Gtk::TreeSortable::has_default_sort_func_vfunc()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface.
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
));
  g_assert(base != 0);

  if(base->has_default_sort_func)
    return (*base->has_default_sort_func)(gobj());

  typedef gboolean RType;
  return RType();
}

void Gtk::TreeSortable::set_sort_column_id_vfunc_vfunc(int sort_column_id, GtkSortType order)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface.
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
));
  g_assert(base != 0);

  if(base->set_sort_column_id)
    (*base->set_sort_column_id)(gobj(),sort_column_id,order);
}

bool Gtk::TreeSortable::get_sort_column_id(int& sort_column_id, SortType& order) const
{
  return const_cast<TreeSortable*>(this)->get_sort_column_id_vfunc(&sort_column_id, ((GtkSortType*) &(order)));
 }

void Gtk::TreeSortable::set_sort_func(int sort_column_id, GtkTreeIterCompareFunc func, gpointer data, GtkDestroyNotify destroy)
{
  set_sort_func_vfunc(sort_column_id, func, data, destroy);
 }

void Gtk::TreeSortable::set_default_sort_func(GtkTreeIterCompareFunc func, gpointer data, GtkDestroyNotify destroy)
{
  set_default_sort_func_vfunc(func, data, destroy);
 }

bool Gtk::TreeSortable::has_default_sort_func()
{
  return has_default_sort_func_vfunc();
 }

void Gtk::TreeSortable::set_sort_column_id_vfunc(int sort_column_id, SortType order)
{
  set_sort_column_id_vfunc_vfunc(sort_column_id, ((GtkSortType)(order)));
 }

;

} // namespace Gtk

