// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_TEXTITER_H
#define _GTKMM_TEXTITER_H

#include <glibmm.h>

/* $Id: textiter.hg,v 1.24 2002/05/09 20:31:23 murrayc Exp $ */

/* textiter.h
 *
 * Copyright(C) 1998-1999 The gtkmm Development Team
 *
 * This library is free software, ) you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation, ) either
 * version 2 of the License, or(at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, ) without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library, ) if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/exceptionhandler.h>
#include <glibmm/slisthandle.h>
#include <gdkmm/pixbuf.h>
#include <gtkmm/texttag.h>
#include <gtkmm/textmark.h>
#include <gtkmm/textchildanchor.h>
#include <gtkmm/textattributes.h>


namespace Gtk
{


/** @addtogroup gtkmmEnums Enums and Flags */

/**
 * @ingroup gtkmmEnums
 */
enum TextSearchFlags
{
  TEXT_SEARCH_VISIBLE_ONLY,
  TEXT_SEARCH_TEXT_ONLY
};

} // namespace Gtk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::TextSearchFlags> : public Glib::Value_Enum<Gtk::TextSearchFlags>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{


class TextBuffer;
//class TextTag;
//class TextChildAnchor;

class TextIter
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef TextIter CppObjectType;
  typedef GtkTextIter BaseObjectType;

  static GType get_type() G_GNUC_CONST;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  TextIter();
  explicit TextIter(const GtkTextIter* gobject); // always takes a copy

  GtkTextIter*       gobj()       { return &gobject_; }
  const GtkTextIter* gobj() const { return &gobject_; }

protected:
  GtkTextIter gobject_;

private:
  
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

protected:
  template <class Predicate>
  struct PredicateAdapter
  {
    Predicate predicate_;
    inline PredicateAdapter(const Predicate& predicate);
    static gboolean gtk_callback(gunichar uc, void* user_data);
  };

  
  bool forward_find_char_impl(GtkTextCharPredicate predicate,
                                           void* user_data,
                                           const GtkTextIter* limit);

  
  bool backward_find_char_impl(GtkTextCharPredicate predicate,
                                            void* user_data,
                                            const GtkTextIter* limit);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  
  Glib::RefPtr<TextBuffer> get_buffer() const;

  
  int get_offset() const;
  
  int get_line() const;
  
  int get_line_offset() const;
  
  int get_line_index() const;

  
  int get_visible_line_offset() const;
  
  int get_visible_line_index() const;

  
  gunichar get_char() const;
  
  Glib::ustring get_slice(const TextIter& end) const;
  
  Glib::ustring get_text(const TextIter& end) const;
  
  Glib::ustring get_visible_slice(const TextIter& end) const;
  
  Glib::ustring get_visible_text(const TextIter& end) const;

  
  Glib::RefPtr<Gdk::Pixbuf> get_pixbuf() const;
  
  Glib::SListHandle< Glib::RefPtr<TextMark> > get_marks();

  
  Glib::RefPtr<TextChildAnchor> get_child_anchor();

  
  Glib::SListHandle< Glib::RefPtr<TextTag> > get_toggled_tags(bool toggled_on);

  
  bool begins_tag(const Glib::RefPtr<TextTag>& tag) const;
  
  bool ends_tag(const Glib::RefPtr<TextTag>& tag) const;
  
  bool toggles_tag(const Glib::RefPtr<TextTag>& tag) const;

  
  bool has_tag(const Glib::RefPtr<TextTag>& tag) const;
  
  Glib::SListHandle< Glib::RefPtr<TextTag> > get_tags();

  
  bool editable(bool default_setting) const;
  
  bool can_insert( bool default_editability) const;

  
  bool starts_word() const;
  
  bool ends_word() const;
  
  bool inside_word() const;
  
  bool starts_sentence() const;
  
  bool ends_sentence() const;
  
  bool inside_sentence() const;
  
  bool starts_line() const;
  
  bool ends_line() const;
  
  bool is_cursor_position() const;

  
  int get_chars_in_line() const;
  
  int get_bytes_in_line() const;

  bool get_attributes(TextAttributes& values) const;
  
  PangoLanguage* get_language() const;
  
  bool is_end() const;
  
  bool is_start() const;

  
  bool forward_char();
  
  bool backward_char();
  
  bool forward_chars(int count);
  
  bool backward_chars(int count);
  
  bool forward_line();
  
  bool backward_line();
  
  bool forward_lines(int count);
  
  bool backward_lines(int count);
  
  bool forward_word_end();
  
  bool backward_word_start();
  
  bool forward_word_ends(int count);
  
  bool backward_word_starts(int count);

  
  bool forward_sentence_end();
  
  bool backward_sentence_start();
  
  bool forward_sentence_ends(int count);
  
  bool backward_sentence_starts(int count);

  
  bool forward_cursor_position();
  
  bool backward_cursor_position();
  
  bool forward_cursor_positions(int count);
  
  bool backward_cursor_positions(int count);

  
  void set_offset(int char_offset);
  
  void set_line(int line_number);
  
  void set_line_offset(int char_on_line);
  
  void set_line_index(int byte_on_line);
  
  void forward_to_end();
  
  bool forward_to_line_end();

  
  void set_visible_line_offset(int char_on_line);
  
  void set_visible_line_index(int byte_on_line);

  
  bool forward_to_tag_toggle(const Glib::RefPtr<TextTag>& tag);
  
  bool backward_to_tag_toggle(const Glib::RefPtr<TextTag>& tag);

  template <class Predicate> inline bool forward_find_char(Predicate predicate, const TextIter& limit);
  template <class Predicate> inline bool forward_find_char(Predicate predicate);
  template <class Predicate> inline bool backward_find_char(Predicate predicate, const TextIter& limit);
  template <class Predicate> inline bool backward_find_char(Predicate predicate);

  
  bool forward_search(const Glib::ustring& str,
                                        TextSearchFlags flags,
                                        TextIter& match_start,
                                        TextIter& match_end,
                                        const TextIter& limit);

  
  bool backward_search(const Glib::ustring& str,
                                        TextSearchFlags flags,
                                        TextIter& match_start,
                                        TextIter& match_end,
                                        const TextIter& limit);
  
  int compare(const TextIter& rhs) const;
  
  bool in_range(const TextIter& start, const TextIter& end) const;
  
  void order(TextIter& second);


};


#ifndef DOXYGEN_SHOULD_SKIP_THIS

template <class Predicate> inline
TextIter::PredicateAdapter<Predicate>::PredicateAdapter(const Predicate& predicate)
:
  predicate_(predicate)
{}

// static
template <class Predicate>
gboolean TextIter::PredicateAdapter<Predicate>::gtk_callback(gunichar uc, void* user_data)
{
  try
  {
    // This will either use Predicate::operator(), or call a function pointer.
    // The explicit conditional expression avoids relying on an implicit
    // conversion of the return type to int, which might be not available.
    return (static_cast<TextIter::PredicateAdapter<Predicate>*>(user_data)->predicate_(uc)) ? 1 : 0;
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
    return 0;
  }
}

template <class Predicate> inline
bool TextIter::forward_find_char(Predicate predicate, const TextIter& limit)
{
  typedef TextIter::PredicateAdapter<Predicate> PredAdapter;
  PredAdapter adapter(predicate);
  return forward_find_char_impl(&PredAdapter::gtk_callback, &adapter, limit.gobj());
}

template <class Predicate> inline
bool TextIter::forward_find_char(Predicate predicate)
{
  typedef TextIter::PredicateAdapter<Predicate> PredAdapter;
  PredAdapter adapter(predicate);
  return forward_find_char_impl(&PredAdapter::gtk_callback, &adapter, 0);
}

template <class Predicate> inline
bool TextIter::backward_find_char(Predicate predicate, const TextIter& limit)
{
  typedef TextIter::PredicateAdapter<Predicate> PredAdapter;
  PredAdapter adapter(predicate);
  return backward_find_char_impl(&PredAdapter::gtk_callback, &adapter, limit.gobj());
}

template <class Predicate> inline
bool TextIter::backward_find_char(Predicate predicate)
{
  typedef TextIter::PredicateAdapter<Predicate> PredAdapter;
  PredAdapter adapter(predicate);
  return backward_find_char_impl(&PredAdapter::gtk_callback, &adapter, 0);
}

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

} // namespace Gtk


namespace Gtk
{

/** @relates Gtk::TextIter */
bool operator==(const TextIter& lhs, const TextIter& rhs);

/** @relates Gtk::TextIter */
bool operator!=(const TextIter& lhs, const TextIter& rhs);

/** @relates Gtk::TextIter */
bool operator<(const TextIter& lhs, const TextIter& rhs);

/** @relates Gtk::TextIter */
bool operator>(const TextIter& lhs, const TextIter& rhs);

/** @relates Gtk::TextIter */
bool operator<=(const TextIter& lhs, const TextIter& rhs);

/** @relates Gtk::TextIter */
bool operator>=(const TextIter& lhs, const TextIter& rhs);


} // namespace Gtk


namespace Glib
{

/** @relates Gtk::TextIter */
Gtk::TextIter& wrap(GtkTextIter* object);

/** @relates Gtk::TextIter */
const Gtk::TextIter& wrap(const GtkTextIter* object);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
template <>
class Value<Gtk::TextIter> : public Glib::Value_Boxed<Gtk::TextIter>
{};
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

} // namespace Glib

#endif /* _GTKMM_TEXTITER_H */

