
extern "C"
{
#include <glib-object.h>
#include <gdk/gdkenumtypes.h>
}

#include <gdkmm/pixbufanimation.h>
#include <gdkmm/private/pixbufanimation_p.h>

// -*- c++ -*-
/* $Id: pixbufanimation.ccg,v 1.1 2001/10/21 16:48:47 murrayc Exp $ */

/*
 *
 * Copyright 1998-1999 The Gtk-- Development Team
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gdk/gdkcolor.h>

namespace Gdk
{

Glib::RefPtr<PixbufAnimation> PixbufAnimation::create_from_file(const Glib::ustring& filename)
{
  GError* pError = 0;
  return Glib::wrap(gdk_pixbuf_animation_new_from_file(filename.c_str(), &pError));
}

}


namespace
{
} // anonymous namespace


namespace Glib
{

Glib::RefPtr<Gdk::PixbufAnimation> wrap(GdkPixbufAnimation* object, bool take_copy /* = false */)
{
  return Glib::RefPtr<Gdk::PixbufAnimation>( dynamic_cast<Gdk::PixbufAnimation*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Gdk
{


/* The *_Class implementation: */

GType PixbufAnimation_Class::get_type()
{
  if(!gtype_) // create the GType if necessary
  {
    // The actual struct definition is hidden, so we can not derive one.
    gtype_ = gdk_pixbuf_animation_get_type();

    // Add derived versions of interfaces, if the C type implements any interfaces:
  }

  return gtype_;
}


Glib::ObjectBase* PixbufAnimation_Class::wrap_new(GObject* o)
{
  return new PixbufAnimation((GdkPixbufAnimation*)(o));
}


/* The implementation: */

GdkPixbufAnimation* PixbufAnimation::gobj_copy()
{
  reference();
  return gobj();
}

Glib::RefPtr<PixbufAnimation> PixbufAnimation::wrap_specific_type(GdkPixbufAnimation* gobject, bool take_copy /* = false */) //static
{
  Glib::RefPtr<PixbufAnimation> refPtr;

  if(gobject)
  {
    //Check for an existing wrapper:
    PixbufAnimation* pCppObject = dynamic_cast<PixbufAnimation*>(Glib::ObjectBase::_get_current_wrapper(G_OBJECT(gobject)));
    if(pCppObject)
    {
      //Return the existing wrapper:
      refPtr = Glib::RefPtr<PixbufAnimation>(pCppObject);
    }
    else
    {
      //Create a new wrapper:
      refPtr = Glib::RefPtr<PixbufAnimation>( new PixbufAnimation(gobject) );
    }

    if(take_copy && refPtr)
      refPtr->reference();
  }

  return refPtr;
}

PixbufAnimation::PixbufAnimation(GdkPixbufAnimation* castitem)
: Glib::Object((GObject*)(castitem))
{}

PixbufAnimation::~PixbufAnimation()
{
}

PixbufAnimation::CppClassType PixbufAnimation::pixbufanimation_class_; //Initialize static member.

GType PixbufAnimation::get_type()
{
  return pixbufanimation_class_.get_type();
}

GType PixbufAnimation::get_base_type()
{
  return gdk_pixbuf_animation_get_type();
}

int PixbufAnimation::get_width()
{
  return gdk_pixbuf_animation_get_width(gobj());
}

int PixbufAnimation::get_height()
{
  return gdk_pixbuf_animation_get_height(gobj());
}

bool PixbufAnimation::is_static_image()
{
  return gdk_pixbuf_animation_is_static_image(gobj());
}

Glib::RefPtr<Pixbuf> PixbufAnimation::get_static_image()
{
  Glib::RefPtr<Pixbuf> retvalue = Glib::wrap(gdk_pixbuf_animation_get_static_image(gobj()));
  if(!(retvalue.is_null()))
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<PixbufAnimationIter> PixbufAnimation::get_iter(const GTimeVal* start_time)
{
  Glib::RefPtr<PixbufAnimationIter> retvalue = PixbufAnimationIter::wrap_specific_type(gdk_pixbuf_animation_get_iter(gobj(), start_time));
  if(!(retvalue.is_null()))
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}


} // namespace Gdk

