
extern "C"
{
#include <glib-object.h>
#include <gdk/gdkenumtypes.h>
}

#include <gdkmm/event.h>
#include <gdkmm/private/event_p.h>

#include <gdk/gdkenumtypes.h>
// -*- c++ -*-
/* $Id: event.ccg,v 1.1 2001/10/21 12:44:25 murrayc Exp $ */

/*
 *
 * Copyright 1998-1999 The Gtk-- Development Team
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


namespace Gdk
{


} //namespace Gdk


namespace
{
} // anonymous namespace

// static
GType Glib::Value<Gdk::EventType>::value_type()
{
  return gdk_event_type_get_type();
}

// static
GType Glib::Value<Gdk::ExtensionMode>::value_type()
{
  return gdk_extension_mode_get_type();
}

// static
GType Glib::Value<Gdk::AxisUse>::value_type()
{
  return gdk_axis_use_get_type();
}


namespace Glib
{

Gdk::Event wrap(GdkEvent* object, bool take_copy)
{
  return Gdk::Event(object, take_copy);
}

} // namespace Glib


namespace Gdk
{


// static
GType Event::get_type()
{
  return gdk_event_get_type();
}

Event::Event()
:
  gobject_ (0) // Allows creation of invalid wrapper, e.g. for output arguments to methods.
{}

Event::Event(const Event& src)
:
  gobject_ ((src.gobject_) ? gdk_event_copy(src.gobject_) : 0)
{}

Event::Event(GdkEvent* castitem, bool make_a_copy)
{
  // For BoxedType wrappers, make_a_copy is true by default.  The static
  // BoxedType wrappers must always take a copy, thus make_a_copy = true
  // ensures identical behaviour if the default argument is used.

  if(make_a_copy)
  {
    if(castitem)
      gobject_ = gdk_event_copy(castitem);
    else
      gobject_ = 0;
  }
  else
  {
    // It was given to us by a function which has already made a copy for us to keep.
    gobject_ = castitem;
  }
}

Event& Event::operator=(const Event& src)
{
  GdkEvent *const new_gobject = (src.gobject_) ? gdk_event_copy(src.gobject_) : 0;

  if(gobject_)
    gdk_event_free(gobject_);
  gobject_ = new_gobject;

  return *this;
}

Event::~Event()
{
  if(gobject_)
    gdk_event_free(gobject_);}


GdkEvent* Event::gobj_copy() const
{
  return gdk_event_copy(gobject_);
}

Event Event::get()
{
  return Event(gdk_event_get());
}

Event Event::peek()
{
  return Event(gdk_event_peek());
}

Event Event::get_graphics_expose(const Glib::RefPtr<Window>& window)
{
  return Event(gdk_event_get_graphics_expose(Glib::unwrap(window)));
}

void Event::put()
{
  gdk_event_put(gobj());
}

bool Event::events_pending()
{
  return gdk_events_pending();
}

guint32 Event::get_time()
{
  return gdk_event_get_time(gobj());
}

bool Event::get_state(ModifierType& state)
{
  return gdk_event_get_state(gobj(), ((GdkModifierType*) &(state)));
}

bool Event::get_coords(double& x_win, double& y_win)
{
  return gdk_event_get_coords(gobj(), &(x_win), &(y_win));
}

bool Event::get_root_coords(double& x_root, double& y_root)
{
  return gdk_event_get_root_coords(gobj(), &(x_root), &(y_root));
}

bool Event::get_axis(AxisUse axis_use, double& value)
{
  return gdk_event_get_axis(gobj(), ((GdkAxisUse)(axis_use)), &(value));
}

void Event::set_show_events(bool show_events)
{
  gdk_set_show_events(static_cast<int>(show_events));
}

bool Event::get_show_events()
{
  return gdk_get_show_events();
}


} // namespace Gdk


