
#include <gtkmm/treeviewcolumn.h>
#include <gtkmm/private/treeviewcolumn_p.h>

#include <gtk/gtktypebuiltins.h>
// -*- c++ -*-
/* $Id: treeviewcolumn.ccg,v 1.10 2002/04/02 13:25:20 daniel Exp $ */

/* 
 *
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtktreeviewcolumn.h>
#include <gtkmm/treeview_private.h>

namespace Gtk
{

TreeViewColumn::TreeViewColumn(const Glib::ustring& title, Gtk::CellRenderer& cell)
: Gtk::Object((GtkObject*)(g_object_new(get_type(), "title", title.c_str(), (char*)0)))
{
  //This is equivalent to _gtk_tree_view_column_new_with_attributes().
  //You will also need to all gtk_tree_view_column_add_atrribtue() a few times.

  pack_start(cell, true);
}

void TreeViewColumn::add_attribute(const Glib::PropertyProxy_Base& property,
                                   const TreeModelColumnBase& column)
{
  gtk_tree_view_column_add_attribute(gobj(),
      (GtkCellRenderer*) property.get_object()->gobj(), property.get_name(), column.index());
}

void TreeViewColumn::set_cell_data_func(CellRenderer& cell_renderer, const SlotCellData& slot)
{
  //Create a signal proxy. A pointer to this will be passed through the callback's data parameter.
  //It will be deleted when TreeView_Private::SignalProxy_CellData::gtk_callback_destroy() is called.
  TreeView_Private::SignalProxy_CellData* pSignalProxy = new TreeView_Private::SignalProxy_CellData(slot);

  gtk_tree_view_column_set_cell_data_func(gobj(), cell_renderer.gobj(),
    &TreeView_Private::SignalProxy_CellData::gtk_callback, (gpointer)pSignalProxy,
    &TreeView_Private::SignalProxy_CellData::gtk_callback_destroy);
}


} /* namespace Gtk */


namespace
{

const Glib::SignalProxyInfo TreeViewColumn_signal_clicked_info =
{
  "clicked",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};

} // anonymous namespace

// static
GType Glib::Value<Gtk::TreeViewColumnSizing>::value_type()
{
  return gtk_tree_view_column_sizing_get_type();
}


namespace Glib
{

Gtk::TreeViewColumn* wrap(GtkTreeViewColumn* object, bool take_copy /* = false */)
{
  return dynamic_cast<Gtk::TreeViewColumn *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gtk
{


/* The *_Class implementation: */

GType TreeViewColumn_Class::get_type()
{
  if(!gtype_) // create the GType if necessary
  {
    // TODO: This is currently just optimized away, apparently with no harm.
    // Is it actually needed?
    // Make sure that the parent type has been created.
    CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gtk_tree_view_column_get_type(), (GClassInitFunc) &class_init_function);

    // Add derived versions of interfaces, if the C type implements any interfaces:
  }

  return gtype_;
}

void TreeViewColumn_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
  klass->clicked = &clicked_callback;
}


void TreeViewColumn_Class::clicked_callback(GtkTreeViewColumn* self)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_clicked();
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->clicked)
      (*base->clicked)(self);
  }
}


Glib::ObjectBase* TreeViewColumn_Class::wrap_new(GObject* o)
{
  return manage(new TreeViewColumn((GtkTreeViewColumn*)(o)));
}


/* The implementation: */

TreeViewColumn::TreeViewColumn(GtkTreeViewColumn* castitem)
: Gtk::Object((GtkObject*)(castitem))
{}

TreeViewColumn::~TreeViewColumn()
{
  destroy_();
}

TreeViewColumn::CppClassType TreeViewColumn::treeviewcolumn_class_; //Initialize static member.

GType TreeViewColumn::get_type()
{
  return treeviewcolumn_class_.get_type();
}

GType TreeViewColumn::get_base_type()
{
  return gtk_tree_view_column_get_type();
}

TreeViewColumn::TreeViewColumn()
: Gtk::Object((GtkObject*)(g_object_new(get_type(), (char*)0)))
{}

void TreeViewColumn::pack_start(CellRenderer& cell, bool expand)
{
  gtk_tree_view_column_pack_start(gobj(), (cell).gobj(), static_cast<int>(expand));
}

void TreeViewColumn::pack_end(CellRenderer& cell, bool expand)
{
  gtk_tree_view_column_pack_end(gobj(), (cell).gobj(), static_cast<int>(expand));
}

void TreeViewColumn::clear()
{
  gtk_tree_view_column_clear(gobj());
}

Glib::ListHandle<CellRenderer*> TreeViewColumn::get_cell_renderers()
{
  return Glib::ListHandle<CellRenderer*>(gtk_tree_view_column_get_cell_renderers(gobj()), Glib::OWNERSHIP_SHALLOW);
}

void TreeViewColumn::add_attribute(CellRenderer& cell_renderer, const Glib::ustring& attribute, int column)
{
  gtk_tree_view_column_add_attribute(gobj(), (cell_renderer).gobj(), attribute.c_str(), column);
}

void TreeViewColumn::clear_attributes(CellRenderer& cell_renderer)
{
  gtk_tree_view_column_clear_attributes(gobj(), (cell_renderer).gobj());
}

void TreeViewColumn::set_spacing(int spacing)
{
  gtk_tree_view_column_set_spacing(gobj(), spacing);
}

int TreeViewColumn::get_spacing()
{
  return gtk_tree_view_column_get_spacing(gobj());
}

void TreeViewColumn::set_visible(bool visible)
{
  gtk_tree_view_column_set_visible(gobj(), static_cast<int>(visible));
}

bool TreeViewColumn::get_visible()
{
  return gtk_tree_view_column_get_visible(gobj());
}

void TreeViewColumn::set_resizable(bool resizable)
{
  gtk_tree_view_column_set_resizable(gobj(), static_cast<int>(resizable));
}

bool TreeViewColumn::get_resizable() const
{
  return gtk_tree_view_column_get_resizable(const_cast<GtkTreeViewColumn*>(gobj()));
}

void TreeViewColumn::set_sizing(TreeViewColumnSizing type)
{
  gtk_tree_view_column_set_sizing(gobj(), ((GtkTreeViewColumnSizing)(type)));
}

TreeViewColumnSizing TreeViewColumn::get_sizing()
{
  return ((TreeViewColumnSizing)(gtk_tree_view_column_get_sizing(gobj())));
}

int TreeViewColumn::get_width()
{
  return gtk_tree_view_column_get_width(gobj());
}

int TreeViewColumn::get_fixed_width()
{
  return gtk_tree_view_column_get_fixed_width(gobj());
}

void TreeViewColumn::set_fixed_width(int fixed_width)
{
  gtk_tree_view_column_set_fixed_width(gobj(), fixed_width);
}

void TreeViewColumn::set_min_width(int min_width)
{
  gtk_tree_view_column_set_min_width(gobj(), min_width);
}

int TreeViewColumn::get_min_width()
{
  return gtk_tree_view_column_get_min_width(gobj());
}

void TreeViewColumn::set_max_width(int max_width)
{
  gtk_tree_view_column_set_max_width(gobj(), max_width);
}

int TreeViewColumn::get_max_width()
{
  return gtk_tree_view_column_get_max_width(gobj());
}

void TreeViewColumn::clicked()
{
  gtk_tree_view_column_clicked(gobj());
}

void TreeViewColumn::set_title(const Glib::ustring& title)
{
  gtk_tree_view_column_set_title(gobj(), title.c_str());
}

Glib::ustring TreeViewColumn::get_title()
{
  return Glib::convert_const_gchar_ptr_to_ustring(gtk_tree_view_column_get_title(gobj()));
}

void TreeViewColumn::set_clickable(bool clickable)
{
  gtk_tree_view_column_set_clickable(gobj(), static_cast<int>(clickable));
}

bool TreeViewColumn::get_clickable()
{
  return gtk_tree_view_column_get_clickable(gobj());
}

void TreeViewColumn::set_widget(GtkWidget* widget)
{
  gtk_tree_view_column_set_widget(gobj(), widget);
}

Widget* TreeViewColumn::get_widget()
{
  return Glib::wrap(gtk_tree_view_column_get_widget(gobj()));
}

void TreeViewColumn::set_alignment(float xalign)
{
  gtk_tree_view_column_set_alignment(gobj(), xalign);
}

float TreeViewColumn::get_alignment()
{
  return gtk_tree_view_column_get_alignment(gobj());
}

void TreeViewColumn::set_reorderable(bool reorderable)
{
  gtk_tree_view_column_set_reorderable(gobj(), static_cast<int>(reorderable));
}

bool TreeViewColumn::get_reorderable()
{
  return gtk_tree_view_column_get_reorderable(gobj());
}

void TreeViewColumn::set_sort_column_id(int sort_column_id)
{
  gtk_tree_view_column_set_sort_column_id(gobj(), sort_column_id);
}

int TreeViewColumn::get_sort_column_id()
{
  return gtk_tree_view_column_get_sort_column_id(gobj());
}

void TreeViewColumn::set_sort_indicator(bool setting)
{
  gtk_tree_view_column_set_sort_indicator(gobj(), static_cast<int>(setting));
}

bool TreeViewColumn::get_sort_indicator()
{
  return gtk_tree_view_column_get_sort_indicator(gobj());
}

void TreeViewColumn::set_sort_order(SortType order)
{
  gtk_tree_view_column_set_sort_order(gobj(), ((GtkSortType)(order)));
}

SortType TreeViewColumn::get_sort_order()
{
  return ((SortType)(gtk_tree_view_column_get_sort_order(gobj())));
}

void TreeViewColumn::cell_set_cell_data(const Glib::RefPtr<TreeModel>& tree_model, const TreeIter& iter, bool is_expander, bool is_expanded)
{
  gtk_tree_view_column_cell_set_cell_data(gobj(), Glib::unwrap(tree_model), const_cast<GtkTreeIter*>((iter).gobj()), static_cast<int>(is_expander), static_cast<int>(is_expanded));
}

void TreeViewColumn::cell_get_size(Gdk::Rectangle& cell_area, int& x_offset, int& y_offset, int& width, int& height)
{
  gtk_tree_view_column_cell_get_size(gobj(), (cell_area).gobj(), &x_offset, &y_offset, &width, &height);
}

bool TreeViewColumn::cell_is_visible()
{
  return gtk_tree_view_column_cell_is_visible(gobj());
}


Glib::SignalProxy0<void> TreeViewColumn::signal_clicked()
{
  return Glib::SignalProxy0<void>(this, &TreeViewColumn_signal_clicked_info);
}


Glib::PropertyProxy<bool> TreeViewColumn::property_visible()
{
  return Glib::PropertyProxy<bool>(this, "visible");
}

Glib::PropertyProxy_ReadOnly<int> TreeViewColumn::property_width()
{
  return Glib::PropertyProxy_ReadOnly<int>(this, "width");
}

Glib::PropertyProxy<TreeViewColumnSizing> TreeViewColumn::property_sizing()
{
  return Glib::PropertyProxy<TreeViewColumnSizing>(this, "sizing");
}

Glib::PropertyProxy<int> TreeViewColumn::property_fixed_width()
{
  return Glib::PropertyProxy<int>(this, "fixed_width");
}

Glib::PropertyProxy<int> TreeViewColumn::property_min_width()
{
  return Glib::PropertyProxy<int>(this, "min_width");
}

Glib::PropertyProxy<int> TreeViewColumn::property_max_width()
{
  return Glib::PropertyProxy<int>(this, "max_width");
}

Glib::PropertyProxy<Glib::ustring> TreeViewColumn::property_title()
{
  return Glib::PropertyProxy<Glib::ustring>(this, "title");
}

Glib::PropertyProxy<bool> TreeViewColumn::property_clickable()
{
  return Glib::PropertyProxy<bool>(this, "clickable");
}

Glib::PropertyProxy<Widget*> TreeViewColumn::property_widget()
{
  return Glib::PropertyProxy<Widget*>(this, "widget");
}

Glib::PropertyProxy<float> TreeViewColumn::property_alignment()
{
  return Glib::PropertyProxy<float>(this, "alignment");
}

Glib::PropertyProxy<bool> TreeViewColumn::property_reorderable()
{
  return Glib::PropertyProxy<bool>(this, "reorderable");
}

Glib::PropertyProxy<bool> TreeViewColumn::property_sort_indicator()
{
  return Glib::PropertyProxy<bool>(this, "sort_indicator");
}

Glib::PropertyProxy<SortType> TreeViewColumn::property_sort_order()
{
  return Glib::PropertyProxy<SortType>(this, "sort_order");
}


void Gtk::TreeViewColumn::on_clicked()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->clicked)
    (*base->clicked)(gobj());
}


} // namespace Gtk

