// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_TREEMODEL_H
#define _GTKMM_TREEMODEL_H

#include <glibmm.h>

/* $Id: treemodel.hg,v 1.19 2002/04/02 13:25:19 daniel Exp $ */


/* treemodel.h
 *
 * Copyright (C) 1998-1999 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtktreemodel.h>
#include <glibmm/interface.h>
#include <gtkmm/treeiter.h>
#include <gtkmm/treemodelcolumn.h>
#include <gtkmm/treepath.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkTreeModel GtkTreeModel;
typedef struct _GtkTreeModelClass GtkTreeModelClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class TreeModel_Class; } // namespace Gtk
namespace Gtk
{


/** @addtogroup gtkmmEnums Enums and Flags */

/**
 * @ingroup gtkmmEnums
 * @par Bitwise operators:
 * <tt>%TreeModelFlags operator|(TreeModelFlags, TreeModelFlags)</tt><br>
 * <tt>%TreeModelFlags operator&(TreeModelFlags, TreeModelFlags)</tt><br>
 * <tt>%TreeModelFlags operator~(TreeModelFlags)</tt><br>
 */
enum TreeModelFlags
{
  TREE_MODEL_ITERS_PERSIST = 1 << 0,
  TREE_MODEL_LIST_ONLY = 1 << 1
};

/** @ingroup gtkmmEnums */
inline TreeModelFlags operator|(TreeModelFlags lhs, TreeModelFlags rhs)
  { return static_cast<TreeModelFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gtkmmEnums */
inline TreeModelFlags operator&(TreeModelFlags lhs, TreeModelFlags rhs)
  { return static_cast<TreeModelFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gtkmmEnums */
inline TreeModelFlags operator~(TreeModelFlags flags)
  { return static_cast<TreeModelFlags>(~static_cast<unsigned>(flags)); }

} // namespace Gtk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::TreeModelFlags> : public Glib::Value_Flags<Gtk::TreeModelFlags>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{


/** This interface defines a generic tree interface for use by the Gtk::TreeView widget.
 * It is is designed to be usable with any appropriate data structure. The programmer just has to implement this interface on their own data type for it to be viewable by a Gtk::TreeView widget.
 *
 * The model is represented as a hierarchical tree of strongly-typed, columned data. In other words, the model can be seen as a tree where every node has different values depending on which column is being queried.
 * The type of data found in a column is determined by using the GType system (ie. G_TYPE_INT, GTK_TYPE_BUTTON, G_TYPE_POINTER, etc.). The types are homogeneous per column across all nodes. It is important to note that this interface only provides a way of examining a model and observing changes. The implementation of each individual model decides how and if changes are made.
 *
 * In order to make life simpler for programmers who do not need to write their own specialized model, two generic models are provided -
 * the Gtk::TreeStore and the Gtk::ListStore. To use these, the developer simply pushes data into these models as necessary. These models provide the data structure as well as all appropriate tree interfaces. As a result, implementing drag and drop, sorting, and storing data is trivial. For the vast majority of trees and lists, these two models are sufficient.
 *
 * Models are accessed on a node/column level of granularity. One can query for the value of a model at a certain node and a certain column on that node. There are two structures used to reference a particular node in a model. They are the Gtk::TreePath and the Gtk::TreeIter. Most of the interface consists of operations on a Gtk::TreeIter.
 *
 * A path is essentially a potential node. It is a location on a model that may or may not actually correspond to a node on a specific model. A Gtk::TreePath can be converted into either an array of unsigned integers or a string. The string form is a list of numbers separated by a colon. Each number refers to the offset at that level. Thus, the path "0" refers to the root node and the path "2:4" refers to the fifth child of the third node.
 *
 * By contrast, a Gtk::TreeIter is a reference to a specific node on a specific model. It is a generic structure with an integer and three generic pointers. These are filled in by the model in a model-specific way. One can convert a path to an iterator by calling Gtk::TreeModel::get_iter(). These iterators are the primary way of accessing a model and are similar to the iterators used by Gtk::TextBuffer.. The model interface defines a set of operations using them for navigating the model.
 *
 * The lifecycle of an iterator can be a little confusing at first. Iterators are expected to always be valid for as long as the model is unchanged (and doesn't emit a signal). The model is considered to own all outstanding iterators and nothing needs to be done to free them from the user's point of view. Additionally, some models guarantee that an iterator is valid for as long as the node it refers to is valid (most notably the Gtk::TreeStore and Gtk::ListStore). Although generally uninteresting, as one always has to allow for the case where iterators do not persist beyond a signal, some very important performance enhancements were made in the sort model. As a result, the GTK_TREE_MODEL_ITERS_PERSIST flag was added to indicate this behavior.
 *
 * @ingroup TreeView
*/

class TreeModel : public Glib::Interface
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef TreeModel CppObjectType;
  typedef TreeModel_Class CppClassType;
  typedef GtkTreeModel BaseObjectType;
  typedef GtkTreeModelIface BaseClassType;

private:
  friend class TreeModel_Class;
  static CppClassType treemodel_class_;

  TreeModel(const TreeModel&);
  TreeModel& operator=(const TreeModel&); // not implemented
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

protected:
  TreeModel(); //You must derive from this class.
  explicit TreeModel(GtkTreeModel* castitem);
public:
  virtual ~TreeModel();

  static void add_interface(GType gtype_implementer);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type() G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */
  GtkTreeModel* gobj()             { return (GtkTreeModel*)(gobject_); }
  const GtkTreeModel* gobj() const { return (GtkTreeModel*)(gobject_); }

  //GtkTreeModel* gobj_copy();

  static Glib::RefPtr<TreeModel> wrap_specific_type(GtkTreeModel* gobject, bool take_copy = false); //Re-uses the existing wrapper, if it exists.


public:
  //C++ methods used to invoke GTK+ virtual functions:
  TreeModelFlags get_flags();
  int get_n_columns();
  GType get_column_type(int index);
  GtkTreePath* get_path(const TreeIter& iter);

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
  virtual GtkTreeModelFlags get_flags_vfunc();
  virtual gint get_n_columns_vfunc();
  virtual GType get_column_type_vfunc(gint index);
  virtual gboolean get_iter_vfunc(GtkTreeIter* iter, GtkTreePath* path);
  virtual GtkTreePath* get_path_vfunc(GtkTreeIter* iter);
  virtual void get_value_vfunc(GtkTreeIter* iter, int column, GValue* value);

  //Default Signal Handlers::
  virtual void on_row_changed(const TreePath& path, const TreeIter& iter);
  virtual void on_row_inserted(const TreePath& path, const TreeIter& iter);
  virtual void on_row_has_child_toggled(const TreePath& path, const TreeIter& iter);
  virtual void on_row_deleted(const TreePath& path);
  virtual void on_rows_reordered(const TreePath& path, const TreeIter& iter, int* new_order);


private:

  
protected:
  

public:
  TreeIter get_iter(TreePath& path);
  TreeIter get_iter(const Glib::ustring& path_string);

  TreeIterChildren children();

  //_WRAP_METHOD(gtk_tree_model_foreach)

 
  /**
   * @par Prototype:
   * <tt>void %row_changed(const TreePath& path, const TreeIter& iter)</tt>
   */
  Glib::SignalProxy2<void,const TreePath&,const TreeIter&> signal_row_changed();

  
  /**
   * @par Prototype:
   * <tt>void %row_inserted(const TreePath& path, const TreeIter& iter)</tt>
   */
  Glib::SignalProxy2<void,const TreePath&,const TreeIter&> signal_row_inserted();

  
  /**
   * @par Prototype:
   * <tt>void %row_has_child_toggled(const TreePath& path, const TreeIter& iter)</tt>
   */
  Glib::SignalProxy2<void,const TreePath&,const TreeIter&> signal_row_has_child_toggled();

  
  /**
   * @par Prototype:
   * <tt>void %row_deleted(const TreePath& path)</tt>
   */
  Glib::SignalProxy1<void,const TreePath&> signal_row_deleted();

  
  /**
   * @par Prototype:
   * <tt>void %rows_reordered(const TreePath& path, const TreeIter& iter, int* new_order)</tt>
   */
  Glib::SignalProxy3<void,const TreePath&,const TreeIter&,int*> signal_rows_reordered();


  template <class ColumnType>
  typename ColumnType::ElementType get_value(const TreeIter& row, const ColumnType& column);

/*
  _WRAP_VFUNC(bool iter_next(TreeIter& iter), iter_next)
  _WRAP_VFUNC(bool iter_children(TreeIter& iter, const TreeIter& parent = TreeIter()), iter_children)
  _WRAP_VFUNC(bool iter_has_child(const TreeIter& iter) const, iter_has_child)
  _WRAP_VFUNC(int iter_n_children(const TreeIter& iter) const, iter_n_children)
  int get_n_children() const;

  _WRAP_VFUNC(bool iter_nth_child(TreeIter& iter, const TreeIter& parent, int n), iter_nth_child)
  bool iter_nth_child(TreeIter& iter, int n);
  _WRAP_VFUNC(bool iter_parent(TreeIter& iter, const TreeIter& child), iter_parent)
  _WRAP_VFUNC(void ref_node(TreeIter& iter), ref_node)
  _WRAP_VFUNC(void unref_node(TreeIter& iter), unref_node)
*/

protected:
  
  void get_value_impl(const TreeIter& row, int column, Glib::ValueBase& value);


};


template <class ColumnType>
typename ColumnType::ElementType TreeModel::get_value(const TreeIter& row, const ColumnType& column)
{
  typename ColumnType::ValueType value;

  get_value_impl(row, column.index(), value);
  return value.get();
}

} // namespace Gtk


namespace Glib
{
  /** @relates Gtk::TreeModel */
  Glib::RefPtr<Gtk::TreeModel> wrap(GtkTreeModel* object, bool take_copy = false);
}

#endif /* _GTKMM_TREEMODEL_H */

