
#include <gtkmm/treemodel.h>
#include <gtkmm/private/treemodel_p.h>

#include <gtk/gtktypebuiltins.h>
// -*- c++ -*-
/* $Id: treemodel.ccg,v 1.10 2002/04/16 13:01:53 murrayc Exp $ */

/* 
 *
 * Copyright 1998-1999 The Gtk-- Development Team
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtktreestore.h>
#include <gtk/gtktreemodel.h>

namespace Gtk
{

TreeIter TreeModel::get_iter(Gtk::TreePath& path)
{
  TreeIter iter(gobj());
  gtk_tree_model_get_iter(gobj(), iter.gobj(), path.gobj());
  return iter;
}

TreeIter TreeModel::get_iter(const Glib::ustring& path_string)
{
  TreeIter iter (gobj());
  gtk_tree_model_get_iter_from_string(gobj(), iter.gobj(), path_string.c_str());
  return iter;
}

TreeIterChildren TreeModel::children()
{
  return TreeIterChildren(gobj());
}

/*
bool TreeModel::iter_nth_child(Gtk::TreeIter& iter, int n)
{
  // parent = 0: See C documentation for gtk_tree_model_iter_nth_child().
  const bool result = iter_nth_child_vfunc(iter.gobj(), 0, n);

  if(!result)
    iter.clear();

  return result;
}

int TreeModel::get_n_children() const
{
  // TODO: Currently broken, because TreeIter().gobj() isn't 0.
  return iter_n_children(TreeIter());
}
*/

} // namespace Gtk


namespace
{


void TreeModel_signal_row_changed_callback(GtkTreeModel* self, GtkTreePath* path,GtkTreeIter* iter,void* data)
{
  using namespace Gtk;
  typedef SigC::Slot2<void,const TreePath&,const TreeIter&> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    (*(SlotType::Proxy)(slot->proxy_))
        (Glib::wrap(path, true)
,Gtk::TreeIter(self, iter)
, slot);
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }
}

const Glib::SignalProxyInfo TreeModel_signal_row_changed_info =
{
  "row_changed",
  (GCallback) &TreeModel_signal_row_changed_callback,
  (GCallback) &TreeModel_signal_row_changed_callback
};


void TreeModel_signal_row_inserted_callback(GtkTreeModel* self, GtkTreePath* path,GtkTreeIter* iter,void* data)
{
  using namespace Gtk;
  typedef SigC::Slot2<void,const TreePath&,const TreeIter&> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    (*(SlotType::Proxy)(slot->proxy_))
        (Glib::wrap(path, true)
,Gtk::TreeIter(self, iter)
, slot);
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }
}

const Glib::SignalProxyInfo TreeModel_signal_row_inserted_info =
{
  "row_inserted",
  (GCallback) &TreeModel_signal_row_inserted_callback,
  (GCallback) &TreeModel_signal_row_inserted_callback
};


void TreeModel_signal_row_has_child_toggled_callback(GtkTreeModel* self, GtkTreePath* path,GtkTreeIter* iter,void* data)
{
  using namespace Gtk;
  typedef SigC::Slot2<void,const TreePath&,const TreeIter&> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    (*(SlotType::Proxy)(slot->proxy_))
        (Glib::wrap(path, true)
,Gtk::TreeIter(self, iter)
, slot);
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }
}

const Glib::SignalProxyInfo TreeModel_signal_row_has_child_toggled_info =
{
  "row_has_child_toggled",
  (GCallback) &TreeModel_signal_row_has_child_toggled_callback,
  (GCallback) &TreeModel_signal_row_has_child_toggled_callback
};


void TreeModel_signal_row_deleted_callback(GtkTreeModel*, GtkTreePath* path,void* data)
{
  using namespace Gtk;
  typedef SigC::Slot1<void,const TreePath&> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    (*(SlotType::Proxy)(slot->proxy_))
        (Glib::wrap(path, true)
, slot);
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }
}

const Glib::SignalProxyInfo TreeModel_signal_row_deleted_info =
{
  "row_deleted",
  (GCallback) &TreeModel_signal_row_deleted_callback,
  (GCallback) &TreeModel_signal_row_deleted_callback
};


void TreeModel_signal_rows_reordered_callback(GtkTreeModel* self, GtkTreePath* path,GtkTreeIter* iter,gint* new_order,void* data)
{
  using namespace Gtk;
  typedef SigC::Slot3<void,const TreePath&,const TreeIter&,int*> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    (*(SlotType::Proxy)(slot->proxy_))
        (Glib::wrap(path, true)
,Gtk::TreeIter(self, iter)
,new_order
, slot);
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }
}

const Glib::SignalProxyInfo TreeModel_signal_rows_reordered_info =
{
  "rows_reordered",
  (GCallback) &TreeModel_signal_rows_reordered_callback,
  (GCallback) &TreeModel_signal_rows_reordered_callback
};

} // anonymous namespace

// static
GType Glib::Value<Gtk::TreeModelFlags>::value_type()
{
  return gtk_tree_model_flags_get_type();
}


namespace Glib
{

Glib::RefPtr<Gtk::TreeModel> wrap(GtkTreeModel* object, bool take_copy /* = false */)
{
  return Glib::RefPtr<Gtk::TreeModel>( dynamic_cast<Gtk::TreeModel*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Gtk
{


/* The *_Class implementation: */

GType TreeModel_Class::get_type()
{
  if (!gtype_) //Create the GType if necessary.
    {
      //Make sure that the parent type has been created:
      CppClassParent::CppObjectType::get_type();

      //Get the size of the base C class:
      GType gtype_base = gtk_tree_model_get_type();
      gtype_ = gtype_base; //We can not derive from another interface.
/*
      GTypeQuery typeQueryBase = {0 ,};
      g_type_query(gtype_base, &typeQueryBase);

      //Create a derived C type.
      //These init funcs will, in turn, call the init functions in the base C type.
      GTypeInfo info =
        {
          typeQueryBase.class_size, // class_size
          (GBaseInitFunc) 0, // base_init *
          (GBaseFinalizeFunc) 0, // base_finalize
          (GClassInitFunc) class_init_function, // class_init
          0, // class_finalize
          0, // class_data
          typeQueryBase.instance_size, // instance_size
          0, // n_preallocs
          (GInstanceInitFunc) object_init_function // instance_init
        };

      gtype_ = g_type_register_static(gtype_base, "gtkmm__TreeModel", &info, GTypeFlags(0));
*/
    }
  return gtype_;
}

void TreeModel_Class::iface_init_function(BaseClassType* iface)
{
  CppClassParent::iface_init_function((GTypeInterface*)iface);
  BaseClassType* klass = iface; //Allows us to reuse generated code from GObject wrappers.
   klass->get_flags = &get_flags_vfunc_callback;
  klass->get_n_columns = &get_n_columns_vfunc_callback;
  klass->get_column_type = &get_column_type_vfunc_callback;
  klass->get_iter = &get_iter_vfunc_callback;
  klass->get_path = &get_path_vfunc_callback;
  klass->get_value = &get_value_vfunc_callback;
   klass->row_changed = &row_changed_callback;
  klass->row_inserted = &row_inserted_callback;
  klass->row_has_child_toggled = &row_has_child_toggled_callback;
  klass->row_deleted = &row_deleted_callback;
  klass->rows_reordered = &rows_reordered_callback;
}

void TreeModel_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((GTypeInterface*)klass);
}

void TreeModel_Class::object_init_function(BaseObjectType* object)
{
}

GtkTreeModelFlags TreeModel_Class::get_flags_vfunc_callback(GtkTreeModel* self)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      return obj->get_flags_vfunc();
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_interface_peek_parent( // Get the parent interface of the interface.
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
));
    g_assert(base != 0);

    if(base->get_flags)
      (*base->get_flags)(self);
  }

  typedef GtkTreeModelFlags RType;
  return RType();
}

gint TreeModel_Class::get_n_columns_vfunc_callback(GtkTreeModel* self)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      return obj->get_n_columns_vfunc();
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_interface_peek_parent( // Get the parent interface of the interface.
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
));
    g_assert(base != 0);

    if(base->get_n_columns)
      (*base->get_n_columns)(self);
  }

  typedef gint RType;
  return RType();
}

GType TreeModel_Class::get_column_type_vfunc_callback(GtkTreeModel* self, gint index)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      return obj->get_column_type_vfunc(index);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_interface_peek_parent( // Get the parent interface of the interface.
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
));
    g_assert(base != 0);

    if(base->get_column_type)
      (*base->get_column_type)(self, index);
  }

  typedef GType RType;
  return RType();
}

gboolean TreeModel_Class::get_iter_vfunc_callback(GtkTreeModel* self, GtkTreeIter* iter, GtkTreePath* path)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      return obj->get_iter_vfunc(iter, path);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_interface_peek_parent( // Get the parent interface of the interface.
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
));
    g_assert(base != 0);

    if(base->get_iter)
      (*base->get_iter)(self, iter, path);
  }

  typedef gboolean RType;
  return RType();
}

GtkTreePath* TreeModel_Class::get_path_vfunc_callback(GtkTreeModel* self, GtkTreeIter* iter)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      return obj->get_path_vfunc(iter);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_interface_peek_parent( // Get the parent interface of the interface.
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
));
    g_assert(base != 0);

    if(base->get_path)
      (*base->get_path)(self, iter);
  }

  typedef GtkTreePath* RType;
  return RType();
}

void TreeModel_Class::get_value_vfunc_callback(GtkTreeModel* self, GtkTreeIter* iter, gint column, GValue* value)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->get_value_vfunc(iter, column
, value);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_interface_peek_parent( // Get the parent interface of the interface.
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
));
    g_assert(base != 0);

    if(base->get_value)
      (*base->get_value)(self, iter, column, value);
  }
}


void TreeModel_Class::row_changed_callback(GtkTreeModel* self, GtkTreePath* path, GtkTreeIter* iter)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_row_changed(Glib::wrap(path, true)
, Gtk::TreeIter(self, iter)
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_interface_peek_parent( // Get the parent interface of the interface.
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
));
    g_assert(base != 0);

    if(base->row_changed)
      (*base->row_changed)(self, path, iter);
  }
}

void TreeModel_Class::row_inserted_callback(GtkTreeModel* self, GtkTreePath* path, GtkTreeIter* iter)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_row_inserted(Glib::wrap(path, true)
, Gtk::TreeIter(self, iter)
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_interface_peek_parent( // Get the parent interface of the interface.
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
));
    g_assert(base != 0);

    if(base->row_inserted)
      (*base->row_inserted)(self, path, iter);
  }
}

void TreeModel_Class::row_has_child_toggled_callback(GtkTreeModel* self, GtkTreePath* path, GtkTreeIter* iter)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_row_has_child_toggled(Glib::wrap(path, true)
, Gtk::TreeIter(self, iter)
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_interface_peek_parent( // Get the parent interface of the interface.
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
));
    g_assert(base != 0);

    if(base->row_has_child_toggled)
      (*base->row_has_child_toggled)(self, path, iter);
  }
}

void TreeModel_Class::row_deleted_callback(GtkTreeModel* self, GtkTreePath* path)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_row_deleted(Glib::wrap(path, true)
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_interface_peek_parent( // Get the parent interface of the interface.
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
));
    g_assert(base != 0);

    if(base->row_deleted)
      (*base->row_deleted)(self, path);
  }
}

void TreeModel_Class::rows_reordered_callback(GtkTreeModel* self, GtkTreePath* path, GtkTreeIter* iter, gint* new_order)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_rows_reordered(Glib::wrap(path, true)
, Gtk::TreeIter(self, iter)
, new_order
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_interface_peek_parent( // Get the parent interface of the interface.
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
));
    g_assert(base != 0);

    if(base->rows_reordered)
      (*base->rows_reordered)(self, path, iter, new_order);
  }
}


Glib::ObjectBase* TreeModel_Class::wrap_new(GObject* o)
{
  return new TreeModel((GtkTreeModel*)(o));
}


/* The implementation: */

TreeModel::TreeModel(GtkTreeModel* castitem)
: Glib::Interface((GObject*)(castitem))
{}

TreeModel::~TreeModel()
{
}

/*
GtkTreeModel* TreeModel::gobj_copy()
{
  reference();
  return gobj();
}
*/

Glib::RefPtr<TreeModel> TreeModel::wrap_specific_type(GtkTreeModel* gobject, bool take_copy /* = false */) //static
{
  Glib::RefPtr<TreeModel> refPtr;
  //Check for an existing wrapper:
  TreeModel* pCppObject = dynamic_cast<TreeModel*>(Glib::ObjectBase::_get_current_wrapper(G_OBJECT(gobject)));
  if(pCppObject)
  {
    //Return the existing wrapper:
    refPtr = Glib::RefPtr<TreeModel>(pCppObject);
  }
  else
  {
    //Create a new wrapper:
    refPtr = Glib::RefPtr<TreeModel>( new TreeModel(gobject) );
  }

  if(take_copy)
    refPtr->reference();

  return refPtr;
}

TreeModel::TreeModel()
{
}


void TreeModel::add_interface(GType gtype_implementer) //static
{
  static const GInterfaceInfo iface_info =
  {
	  (GInterfaceInitFunc)CppClassType::iface_init_function,
	  NULL,
	  NULL
  };

  g_type_add_interface_static(
    gtype_implementer,
    get_type(), //interface_type: whose direct parent type must be G_TYPE_INTERFACE
    &iface_info
  );
}

TreeModel::CppClassType TreeModel::treemodel_class_; //Initialize static member.

GType TreeModel::get_type()
{
  return treemodel_class_.get_type();
}

GType TreeModel::get_base_type()
{
  return gtk_tree_model_get_type();
}

void TreeModel::get_value_impl(const TreeIter& row, int column, Glib::ValueBase& value)
{
  gtk_tree_model_get_value(gobj(), const_cast<GtkTreeIter*>((row).gobj()), column, value.gobj());
}


Glib::SignalProxy2<void,const TreePath&,const TreeIter&> TreeModel::signal_row_changed()
{
  return Glib::SignalProxy2<void,const TreePath&,const TreeIter&>(this, &TreeModel_signal_row_changed_info);
}

Glib::SignalProxy2<void,const TreePath&,const TreeIter&> TreeModel::signal_row_inserted()
{
  return Glib::SignalProxy2<void,const TreePath&,const TreeIter&>(this, &TreeModel_signal_row_inserted_info);
}

Glib::SignalProxy2<void,const TreePath&,const TreeIter&> TreeModel::signal_row_has_child_toggled()
{
  return Glib::SignalProxy2<void,const TreePath&,const TreeIter&>(this, &TreeModel_signal_row_has_child_toggled_info);
}

Glib::SignalProxy1<void,const TreePath&> TreeModel::signal_row_deleted()
{
  return Glib::SignalProxy1<void,const TreePath&>(this, &TreeModel_signal_row_deleted_info);
}

Glib::SignalProxy3<void,const TreePath&,const TreeIter&,int*> TreeModel::signal_rows_reordered()
{
  return Glib::SignalProxy3<void,const TreePath&,const TreeIter&,int*>(this, &TreeModel_signal_rows_reordered_info);
}


void Gtk::TreeModel::on_row_changed(const TreePath& path, const TreeIter& iter)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface.
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
));
  g_assert(base != 0);

  if(base->row_changed)
    (*base->row_changed)(gobj(),const_cast<GtkTreePath*>((path).gobj()),const_cast<GtkTreeIter*>((iter).gobj()));
}

void Gtk::TreeModel::on_row_inserted(const TreePath& path, const TreeIter& iter)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface.
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
));
  g_assert(base != 0);

  if(base->row_inserted)
    (*base->row_inserted)(gobj(),const_cast<GtkTreePath*>((path).gobj()),const_cast<GtkTreeIter*>((iter).gobj()));
}

void Gtk::TreeModel::on_row_has_child_toggled(const TreePath& path, const TreeIter& iter)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface.
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
));
  g_assert(base != 0);

  if(base->row_has_child_toggled)
    (*base->row_has_child_toggled)(gobj(),const_cast<GtkTreePath*>((path).gobj()),const_cast<GtkTreeIter*>((iter).gobj()));
}

void Gtk::TreeModel::on_row_deleted(const TreePath& path)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface.
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
));
  g_assert(base != 0);

  if(base->row_deleted)
    (*base->row_deleted)(gobj(),const_cast<GtkTreePath*>((path).gobj()));
}

void Gtk::TreeModel::on_rows_reordered(const TreePath& path, const TreeIter& iter, int* new_order)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface.
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
));
  g_assert(base != 0);

  if(base->rows_reordered)
    (*base->rows_reordered)(gobj(),const_cast<GtkTreePath*>((path).gobj()),const_cast<GtkTreeIter*>((iter).gobj()),new_order);
}


GtkTreeModelFlags Gtk::TreeModel::get_flags_vfunc()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface.
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
));
  g_assert(base != 0);

  if(base->get_flags)
    return (*base->get_flags)(gobj());

  typedef GtkTreeModelFlags RType;
  return RType();
}

gint Gtk::TreeModel::get_n_columns_vfunc()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface.
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
));
  g_assert(base != 0);

  if(base->get_n_columns)
    return (*base->get_n_columns)(gobj());

  typedef gint RType;
  return RType();
}

GType Gtk::TreeModel::get_column_type_vfunc(gint index)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface.
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
));
  g_assert(base != 0);

  if(base->get_column_type)
    return (*base->get_column_type)(gobj(),index);

  typedef GType RType;
  return RType();
}

gboolean Gtk::TreeModel::get_iter_vfunc(GtkTreeIter* iter, GtkTreePath* path)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface.
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
));
  g_assert(base != 0);

  if(base->get_iter)
    return (*base->get_iter)(gobj(),iter,path);

  typedef gboolean RType;
  return RType();
}

GtkTreePath* Gtk::TreeModel::get_path_vfunc(GtkTreeIter* iter)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface.
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
));
  g_assert(base != 0);

  if(base->get_path)
    return (*base->get_path)(gobj(),iter);

  typedef GtkTreePath* RType;
  return RType();
}

void Gtk::TreeModel::get_value_vfunc(GtkTreeIter* iter, int column, GValue* value)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface.
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
));
  g_assert(base != 0);

  if(base->get_value)
    (*base->get_value)(gobj(),iter,column,value);
}

TreeModelFlags Gtk::TreeModel::get_flags()
{
  return ((TreeModelFlags)(get_flags_vfunc()));
 }

int Gtk::TreeModel::get_n_columns()
{
  return get_n_columns_vfunc();
 }

GType Gtk::TreeModel::get_column_type(int index)
{
  return get_column_type_vfunc(index);
 }

GtkTreePath* Gtk::TreeModel::get_path(const TreeIter& iter)
{
  return get_path_vfunc(const_cast<GtkTreeIter*>((iter).gobj()));
 }

;

} // namespace Gtk

