
#include <gtkmm/cellrenderertoggle.h>
#include <gtkmm/private/cellrenderertoggle_p.h>

// -*- c++ -*-
/* $Id: cellrenderertoggle.ccg,v 1.2 2002/04/16 13:01:52 murrayc Exp $ */

/* 
 *
 * Copyright 1998-1999 The Gtk-- Development Team
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtkcellrenderertoggle.h>


namespace
{


void CellRendererToggle_signal_toggled_callback(GtkCellRendererToggle*, const gchar* p0,void* data)
{
  using namespace Gtk;
  typedef SigC::Slot1<void,const Glib::ustring&> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    (*(SlotType::Proxy)(slot->proxy_))
        (Glib::convert_const_gchar_ptr_to_ustring(p0)
, slot);
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }
}

const Glib::SignalProxyInfo CellRendererToggle_signal_toggled_info =
{
  "toggled",
  (GCallback) &CellRendererToggle_signal_toggled_callback,
  (GCallback) &CellRendererToggle_signal_toggled_callback
};

} // anonymous namespace


namespace Glib
{

Gtk::CellRendererToggle* wrap(GtkCellRendererToggle* object, bool take_copy /* = false */)
{
  return dynamic_cast<Gtk::CellRendererToggle *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gtk
{


/* The *_Class implementation: */

GType CellRendererToggle_Class::get_type()
{
  if(!gtype_) // create the GType if necessary
  {
    // TODO: This is currently just optimized away, apparently with no harm.
    // Is it actually needed?
    // Make sure that the parent type has been created.
    CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gtk_cell_renderer_toggle_get_type(), (GClassInitFunc) &class_init_function);

    // Add derived versions of interfaces, if the C type implements any interfaces:
  }

  return gtype_;
}

void CellRendererToggle_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
  klass->toggled = &toggled_callback;
}


void CellRendererToggle_Class::toggled_callback(GtkCellRendererToggle* self, const gchar* p0)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_toggled(Glib::convert_const_gchar_ptr_to_ustring(p0)
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->toggled)
      (*base->toggled)(self, p0);
  }
}


Glib::ObjectBase* CellRendererToggle_Class::wrap_new(GObject* o)
{
  return manage(new CellRendererToggle((GtkCellRendererToggle*)(o)));
}


/* The implementation: */

CellRendererToggle::CellRendererToggle(GtkCellRendererToggle* castitem)
: Gtk::CellRenderer((GtkCellRenderer*)(castitem))
{}

CellRendererToggle::~CellRendererToggle()
{
  destroy_();
}

CellRendererToggle::CppClassType CellRendererToggle::cellrenderertoggle_class_; //Initialize static member.

GType CellRendererToggle::get_type()
{
  return cellrenderertoggle_class_.get_type();
}

GType CellRendererToggle::get_base_type()
{
  return gtk_cell_renderer_toggle_get_type();
}

CellRendererToggle::CellRendererToggle()
: Gtk::CellRenderer((GtkCellRenderer*)(g_object_new(get_type(), (char*)0)))
{}

bool CellRendererToggle::get_radio()
{
  return gtk_cell_renderer_toggle_get_radio(gobj());
}

void CellRendererToggle::set_radio(bool radio)
{
  gtk_cell_renderer_toggle_set_radio(gobj(), static_cast<int>(radio));
}

bool CellRendererToggle::get_active()
{
  return gtk_cell_renderer_toggle_get_active(gobj());
}

void CellRendererToggle::set_active(bool setting)
{
  gtk_cell_renderer_toggle_set_active(gobj(), static_cast<int>(setting));
}


Glib::SignalProxy1<void,const Glib::ustring&> CellRendererToggle::signal_toggled()
{
  return Glib::SignalProxy1<void,const Glib::ustring&>(this, &CellRendererToggle_signal_toggled_info);
}


Glib::PropertyProxy<bool> CellRendererToggle::property_activatable()
{
  return Glib::PropertyProxy<bool>(this, "activatable");
}

Glib::PropertyProxy<bool> CellRendererToggle::property_active()
{
  return Glib::PropertyProxy<bool>(this, "active");
}

Glib::PropertyProxy<bool> CellRendererToggle::property_radio()
{
  return Glib::PropertyProxy<bool>(this, "radio");
}


void Gtk::CellRendererToggle::on_toggled(const Glib::ustring& path)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->toggled)
    (*base->toggled)(gobj(),path.c_str());
}


} // namespace Gtk

