
#include <gtkmm/alignment.h>
#include <gtkmm/private/alignment_p.h>

// -*- c++ -*-
/* $Id: alignment.ccg,v 1.7 2001/10/25 11:17:19 murrayc Exp $ */

/* 
 *
 * Copyright 1998-1999 The Gtk-- Development Team
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtkalignment.h>


namespace
{
} // anonymous namespace


namespace Glib
{

Gtk::Alignment* wrap(GtkAlignment* object, bool take_copy /* = false */)
{
  return dynamic_cast<Gtk::Alignment *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gtk
{


/* The *_Class implementation: */

GType Alignment_Class::get_type()
{
  if(!gtype_) // create the GType if necessary
  {
    // TODO: This is currently just optimized away, apparently with no harm.
    // Is it actually needed?
    // Make sure that the parent type has been created.
    CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gtk_alignment_get_type(), (GClassInitFunc) &class_init_function);

    // Add derived versions of interfaces, if the C type implements any interfaces:
  }

  return gtype_;
}

void Alignment_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
}


Glib::ObjectBase* Alignment_Class::wrap_new(GObject* o)
{
  return manage(new Alignment((GtkAlignment*)(o)));
}


/* The implementation: */

Alignment::Alignment(GtkAlignment* castitem)
: Gtk::Bin((GtkBin*)(castitem))
{}

Alignment::~Alignment()
{
  destroy_();
}

Alignment::CppClassType Alignment::alignment_class_; //Initialize static member.

GType Alignment::get_type()
{
  return alignment_class_.get_type();
}

GType Alignment::get_base_type()
{
  return gtk_alignment_get_type();
}

Alignment::Alignment(float xalign, float yalign, float xscale, float yscale)
: Gtk::Bin((GtkBin*)( g_object_new(get_type(), "xalign", xalign, "yalign", yalign, "xscale", xscale, "yscale", yscale, (char*)0) ))
{}

void Alignment::set(float xalign, float yalign, float xscale, float yscale)
{
  gtk_alignment_set(gobj(), xalign, yalign, xscale, yscale);
}


Glib::PropertyProxy<float> Alignment::property_xalign()
{
  return Glib::PropertyProxy<float>(this, "xalign");
}

Glib::PropertyProxy<float> Alignment::property_yalign()
{
  return Glib::PropertyProxy<float>(this, "yalign");
}

Glib::PropertyProxy<float> Alignment::property_xscale()
{
  return Glib::PropertyProxy<float>(this, "xscale");
}

Glib::PropertyProxy<float> Alignment::property_yscale()
{
  return Glib::PropertyProxy<float>(this, "yscale");
}


} // namespace Gtk

