// -*- c++ -*-
#ifndef _GLIBMM_OBJECT_H
#define _GLIBMM_OBJECT_H
/* $Id: object.h,v 1.47 2002/04/22 00:09:26 murrayc Exp $ */

/* object.h
 * 
 * Copyright 2001 Free Software Foundation
 * Copyright 1998-1999 The gtkmm Development Team 
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* this file is critical for our compile times, no #includes to this
   header, please */

#include <glibmm/objectbase.h>
#include <glibmm/wrap.h>
#include <glibmm/containers.h>
#include <glibmm/quark.h>
#include <glibmm/signalproxy.h>
#include <glibmm/propertyproxy.h>
#include <glibmm/refptr.h>
#include <glibmm/utility.h> //Could be private, but that would be tedious.

typedef struct _GObject GObject;
typedef struct _GObjectClass GObjectClass;


namespace Glib
{

#ifndef DOXYGEN_SHOULD_SKIP_THIS
class Object_Class;
class GSigConnectionNode;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

//: The base class of the whole hierarchy
class Object : virtual public ObjectBase
{
public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Object       CppObjectType;
  typedef Object_Class CppClassType;
  typedef GObject      BaseObjectType;
  typedef GObjectClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

protected:
  Object(); //For use by C++-only sub-types.
  explicit Object(GObject* castitem);
  virtual ~Object(); //It should only be deleted by the callback.

public:
  static RefPtr<Object> create(); //You must reimplement this in each derived class.

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type() G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  //GObject* gobj_copy(); //Give a ref-ed copy to someone. Use for direct struct access.

  static Glib::RefPtr<Object> wrap_specific_type(GObject* gobject, bool take_copy = false); //Re-uses the existing wrapper, if it exists.

  // Glib::Objects contain a list<Quark, pair<void*, DestroyNotify> >
  // to store run time data added to the object at run time.
  //TODO: Use slots instead:
  void* get_data(const QueryQuark &key);
  void set_data(const Quark &key, void* data);
  typedef void (*DestroyNotify) (gpointer data);
  void set_data(const Quark &key, void* data, DestroyNotify notify);
  void remove_data(const QueryQuark& quark);
  // same as remove without notifying
  void* steal_data(const QueryQuark& quark);

  // convenience functions
  //template <class T>
  //void set_data_typed(const Quark& quark, const T& data)
  //  { set_data(quark, new T(data), delete_typed<T>); }

  //template <class T>
  //T& get_data_typed(const QueryQuark& quark)
  //  { return *static_cast<T*>(get_data(quark)); }

private:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  friend class Object_Class;
  static CppClassType object_class;

  Object(const Object&);
  Object& operator=(const Object&); // not implemented
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  // Glib::Object can not be dynamic because it lacks a float state.
  //virtual void set_manage();
};

} /* namespace Glib */

#endif /* _GLIBMM_OBJECT_H */

