
#include <pangomm/fontset.h>
#include <pangomm/private/fontset_p.h>

// -*- c++ -*-
/* $Id: fontset.ccg,v 1.2 2001/12/13 21:40:02 murrayc Exp $ */

/* 
 *
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


namespace
{
} // anonymous namespace


namespace Glib
{

Glib::RefPtr<Pango::Fontset> wrap(PangoFontset* object, bool take_copy /* = false */)
{
  return Glib::RefPtr<Pango::Fontset>( dynamic_cast<Pango::Fontset*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Pango
{


/* The *_Class implementation: */

GType Fontset_Class::get_type()
  {
    gtype_ = pango_fontset_get_type(); //The actual struct definition is hidden, so we can not derive one.
    return gtype_;
  }


Glib::ObjectBase* Fontset_Class::wrap_new(GObject* o)
{
  return new Fontset((PangoFontset*)(o));
}


/* The implementation: */

PangoFontset* Fontset::gobj_copy()
{
  reference();
  return gobj();
}

Glib::RefPtr<Fontset> Fontset::wrap_specific_type(PangoFontset* gobject, bool take_copy /* = false */) //static
{
  Glib::RefPtr<Fontset> refPtr;

  if(gobject)
  {
    //Check for an existing wrapper:
    Fontset* pCppObject = dynamic_cast<Fontset*>(Glib::ObjectBase::_get_current_wrapper(G_OBJECT(gobject)));
    if(pCppObject)
    {
      //Return the existing wrapper:
      refPtr = Glib::RefPtr<Fontset>(pCppObject);
    }
    else
    {
      //Create a new wrapper:
      refPtr = Glib::RefPtr<Fontset>( new Fontset(gobject) );
    }

    if(take_copy && refPtr)
      refPtr->reference();
  }

  return refPtr;
}

Fontset::Fontset(PangoFontset* castitem)
: Glib::Object((GObject*)(castitem))
{}

Fontset::~Fontset()
{
}

Fontset::CppClassType Fontset::fontset_class_; //Initialize static member.

GType Fontset::get_type()
{
  return fontset_class_.get_type();
}

GType Fontset::get_base_type()
{
  return pango_fontset_get_type();
}


} // namespace Pango

