
#include <gtkmm/progressbar.h>
#include <gtkmm/private/progressbar_p.h>

#include <gtk/gtktypebuiltins.h>
// -*- c++ -*-
/* $Id: progressbar.ccg,v 1.6 2001/11/12 14:35:39 murrayc Exp $ */

/* 
 *
 * Copyright 1998-1999 The Gtk-- Development Team
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/adjustment.h>
#include <gtk/gtkprogressbar.h>


namespace
{
} // anonymous namespace

// static
GType Glib::Value<Gtk::ProgressBarStyle>::value_type()
{
  return gtk_progress_bar_style_get_type();
}

// static
GType Glib::Value<Gtk::ProgressBarOrientation>::value_type()
{
  return gtk_progress_bar_orientation_get_type();
}


namespace Glib
{

Gtk::ProgressBar* wrap(GtkProgressBar* object, bool take_copy /* = false */)
{
  return dynamic_cast<Gtk::ProgressBar *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gtk
{


/* The *_Class implementation: */

GType ProgressBar_Class::get_type()
  {
    if (!gtype_) //Create the GType if necessary.
      {
        //Make sure that the parent type has been created:
        CppClassParent::CppObjectType::get_type();

        //Create a derived C type.
        //These init funcs will, in turn, call the init functions in the base C type.
        GTypeInfo info =
          {
            sizeof(BaseClassType), /* class_size */
            0, /* base_init */
            0, /* base_finalize */
            (GClassInitFunc) &class_init_function, /* class_init */
            0, /* class_finalize */
            0, /* class_data */
            sizeof(BaseObjectType), /* instance_size */
            0, /* n_preallocs */
            0, /* instance_init */
	    0 /* value_table */
          };

        gtype_ = g_type_register_static(gtk_progress_bar_get_type(), "gtkmm__ProgressBar", &info, GTypeFlags(0));

  //Add derived versions of interfaces, if the C type implements any interfaces:
      }
    return gtype_;
  }
void ProgressBar_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
}


Glib::ObjectBase* ProgressBar_Class::wrap_new(GObject* o)
{
  return manage(new ProgressBar((GtkProgressBar*)(o)));
}


/* The implementation: */

ProgressBar::ProgressBar(GtkProgressBar* castitem)
: Gtk::Widget((GtkWidget*)(castitem))
{}

ProgressBar::~ProgressBar()
{
  destroy_();
}

ProgressBar::CppClassType ProgressBar::progressbar_class_; //Initialize static member.

GType ProgressBar::get_type()
{
  return progressbar_class_.get_type();
}

GType ProgressBar::get_base_type()
{
  return gtk_progress_bar_get_type();
}

ProgressBar::ProgressBar()
: Gtk::Widget((GtkWidget*)(g_object_new(get_type(), (char*)0)))
{}

void ProgressBar::pulse()
{
  gtk_progress_bar_pulse(gobj());
}

Glib::ustring ProgressBar::get_text() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(gtk_progress_bar_get_text(const_cast<GtkProgressBar*>(gobj())));
}

void ProgressBar::set_text(const Glib::ustring& text)
{
  gtk_progress_bar_set_text(gobj(), text.c_str());
}

double ProgressBar::get_fraction() const
{
  return gtk_progress_bar_get_fraction(const_cast<GtkProgressBar*>(gobj()));
}

void ProgressBar::set_fraction(double fraction)
{
  gtk_progress_bar_set_fraction(gobj(), fraction);
}

double ProgressBar::get_pulse_step() const
{
  return gtk_progress_bar_get_pulse_step(const_cast<GtkProgressBar*>(gobj()));
}

void ProgressBar::set_pulse_step(double fraction)
{
  gtk_progress_bar_set_pulse_step(gobj(), fraction);
}

void ProgressBar::set_orientation(ProgressBarOrientation orientation)
{
  gtk_progress_bar_set_orientation(gobj(), ((GtkProgressBarOrientation)(orientation)));
}

ProgressBarOrientation ProgressBar::get_orientation() const
{
  return ((ProgressBarOrientation)(gtk_progress_bar_get_orientation(const_cast<GtkProgressBar*>(gobj()))));
}


Glib::PropertyProxy<double> ProgressBar::property_fraction()
{
  return Glib::PropertyProxy<double>(this, "fraction");
}

Glib::PropertyProxy<double> ProgressBar::property_pulse_step()
{
  return Glib::PropertyProxy<double>(this, "pulse_step");
}

Glib::PropertyProxy<ProgressBarOrientation> ProgressBar::property_orientation()
{
  return Glib::PropertyProxy<ProgressBarOrientation>(this, "orientation");
}

Glib::PropertyProxy<Glib::ustring> ProgressBar::property_text()
{
  return Glib::PropertyProxy<Glib::ustring>(this, "text");
}


} // namespace Gtk

