// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_LABEL_H
#define _GTKMM_LABEL_H

#include <glibmm.h>

/* $Id: label.hg,v 1.22 2002/04/02 13:25:17 daniel Exp $ */


/* label.h
 * 
 * Copyright(C) 1998-1999 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or(at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/misc.h>
//#include <gtkmm/menu.h>
#include <pangomm/attrlist.h>
#include <gtk/gtkmenu.h>

#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkLabel GtkLabel;
typedef struct _GtkLabelClass GtkLabelClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gtk
{ class Label_Class; } // namespace Gtk
namespace Gtk{ class Menu; }


namespace Gtk
{

/** Text Glib::ustring widget.
 * A simple setable widget for holding a Glib::ustring.
 * @ingroup Widgets
 */

class Label : public Misc
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Label CppObjectType;
  typedef Label_Class CppClassType;
  typedef GtkLabel BaseObjectType;
  typedef GtkLabelClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~Label();

private:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  friend class CppClassType;
  static CppClassType label_class_;

  Label(const Label&);
  Label& operator=(const Label&); // not implemented

protected:
  explicit Label(GtkLabel* castitem);
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type() G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */
  GtkLabel* gobj()             { return (GtkLabel*)(gobject_); }
  const GtkLabel* gobj() const { return (GtkLabel*)(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  virtual void on_move_cursor(MovementStep step, int count, bool extend_selection);
  virtual void on_copy_clipboard();
  virtual void on_populate_popup(Menu* menu);


private:

  
public:

  Label();
  explicit Label(const Glib::ustring& label, bool mnemonic = false);
  

  /// Doesn't use markup.
  
  /** Sets the text within the Gtk::Label widget.  It overwrites any text that
   * was there before.  
   * 
   * This will also clear any previously set mnemonic accelerators.
   * @param str The text you want to set.
   */
  void set_text(const Glib::ustring &str);
  
  /** Fetches the text from a label widget, as displayed on the
   * screen. This does not include any embedded underlines
   * indicating mnemonics or Pango markup. (See get_label())
   * @return The text in the label widget. This is the internal
   * string used by the label, and must not be modified.
   */
  Glib::ustring get_text() const;

  
  /** Sets a Pango::AttrList; the attributes in the list are applied to the
   * label text. The attributes set with this function will be ignored
   * if label->use_underline or label->use_markup is <tt>true</tt>.
   * @param attrs A Pango::AttrList.
   */
  void set_attributes(Pango::AttrList& attrs);
  
  /** Gets the attribute list that was set on the label using
   * set_attributes(), if any. This function does
   * not reflect attributes that come from the labels markup
   * (see set_markup()). If you want to get the
   * effective attributes for the label, use
   * pango_layout_get_attribute (gtk_label_get_layout (label)).
   * @return The attribute list, or <tt>0</tt> if none was set.
   */
  Pango::AttrList get_attributes();

  /// Uses markup.
  
  /** Sets the text of the label. The label is interpreted as
   * including embedded underlines and/or Pango markup depending
   * on the values of label->use_underline and label->use_markup.
   * @param str The new text to set for the label.
   */
  void set_label(const Glib::ustring& str);
  
  /** Fetches the text from a label widget including any embedded
   * underlines indicating mnemonics and Pango markup. (See
   * get_text()).
   * @return The text of the label widget. This string is
   * owned by the widget and must not be modified or freed.
   */
  Glib::ustring get_label() const;
  
  /** Parses @a str which is marked up with the Pango text markup language,
   * setting the label's text and attribute list based on the parse results.
   * @param str A markup string (see Pango markup format).
   */
  void set_markup(const Glib::ustring& str);
  
  /** Sets whether the text of the label contains markup in Pango's text markup
   * language. See set_markup().
   * @param setting <tt>true</tt> if the label's text should be parsed for markup.
   */
  void set_use_markup(bool setting = true);
  
  /** Returns whether the label's text is interpreted as marked up with
   * the Pango text markup
   * language. See set_use_markup().
   * @return <tt>true</tt> if the label's text will be parsed for markup.
   */
  bool get_use_markup() const;
  
  /** If true, an underline in the text indicates the next character should be
   * used for the mnemonic accelerator key.
   * @param setting <tt>true</tt> if underlines in the text indicate mnemonics.
   */
  void set_use_underline(bool setting = true);
  
  /** Returns whether an embedded underline in the label indicates a
   * mnemonic. See set_use_underline().
   * @return <tt>true</tt> whether an embedded underline in the label indicates
   * the mnemonic accelerator keys.
   */
  bool get_use_underline() const;

  
  /** Parses @a str which is marked up with the Pango text markup language,
   * setting the label's text and attribute list based on the parse results.
   * If characters in @a str are preceded by an underscore, they are underlined
   * indicating that they represent a keyboard accelerator called a mnemonic.
   * 
   * The mnemonic key can be used to activate another widget, chosen automatically,
   * or explicitly using set_mnemonic_widget().
   * @param str A markup string (see Pango markup format).
   */
  void set_markup_with_mnemonic(const Glib::ustring& str);
  
  /** If the label has been set so that it has an mnemonic key this function
   * returns the keyval used for the mnemonic accelerator. If there is no
   * mnemonic set up it returns #GDK_VoidSymbol.
   * @return GDK keyval usable for accelerators, or #GDK_VoidSymbol.
   */
  guint get_mnemonic_keyval() const;
  
  /** If the label has been set so that it has an mnemonic key (using
   * i.e.\  set_markup_with_mnemonic(),
   * set_text_with_mnemonic(), new_with_mnemonic()
   * or the "use_underline" property) the label can be associated with a
   * widget that is the target of the mnemonic. When the label is inside
   * a widget (like a Gtk::Button or a Gtk::Notebook tab) it is
   * automatically associated with the correct widget, but sometimes
   * (i.e. when the target is a Gtk::Entry next to the label) you need to
   * set it explicitly using this function.
   * 
   * The target widget will be accelerated by emitting "mnemonic_activate" on it.
   * The default handler for this signal will activate the widget if there are no
   * mnemonic collisions and toggle focus between the colliding widgets otherwise.
   * @param widget The target Gtk::Widget.
   */
  void set_mnemonic_widget(Widget& widget);
  
  /** Retrieves the target of the mnemonic (keyboard shortcut) of this
   * label. See set_mnemonic_widget().
   * @return The target of the label's mnemonic, or <tt>0</tt> if none
   * has been set and the default algorithm will be used.
   */
  Widget* get_mnemonic_widget();
  
  /** Retrieves the target of the mnemonic (keyboard shortcut) of this
   * label. See set_mnemonic_widget().
   * @return The target of the label's mnemonic, or <tt>0</tt> if none
   * has been set and the default algorithm will be used.
   */
  const Widget* get_mnemonic_widget() const;
  
  /** Sets the label's text from the string @a str.
   * If characters in @a str are preceded by an underscore, they are underlined
   * indicating that they represent a keyboard accelerator called a mnemonic.
   * The mnemonic key can be used to activate another widget, chosen automatically,
   * or explicitly using set_mnemonic_widget().
   * @param str A string.
   */
  void set_text_with_mnemonic(const Glib::ustring& str);
  
  /** Sets the alignment of the lines in the text of the label relative to
   * each other.  Gtk::JUSTIFY_LEFT is the default value when the
   * widget is first created with new(). If you instead want
   * to set the alignment of the label as a whole, use
   * Gtk::Misc::set_alignment() instead. set_justify() has no
   * effect on labels containing only a single line.
   * @param jtype A Gtk::Justification.
   */
  void set_justify(Justification jtype);
  
  /** Returns the justification of the label. See set_justify().
   * @return Gtk::Justification.
   */
  Justification get_justify() const;
  
  void set_pattern(const Glib::ustring& pattern);
  
  /** Toggles line wrapping within the Gtk::Label widget.  <tt>true</tt> makes it break
   * lines if text exceeds the widget's size.  <tt>false</tt> lets the text get cut off
   * by the edge of the widget if it exceeds the widget size.
   * @param wrap The setting.
   */
  void set_line_wrap(bool wrap = true);
  
  /** Returns whether lines in the label are automatically wrapped. See set_line_wrap().
   * @return <tt>true</tt> if the lines of the label are automatically wrapped.
   */
  bool get_line_wrap() const;
  
  /** Selectable labels allow the user to select text from the label, for
   * copy-and-paste.
   * @param setting <tt>true</tt> to allow selecting text in the label.
   */
  void set_selectable(bool setting = true);
  
  /** Gets the value set by set_selectable().
   * @return <tt>true</tt> if the user can copy text from the label.
   */
  bool get_selectable() const;
  
  /** Selects a range of characters in the label, if the label is selectable.
   * See set_selectable(). If the label is not selectable,
   * this function has no effect. If @a start_offset or
   * @a end_offset are -1, then the end of the label will be substituted.
   * @param start_offset Start offset (in characters not bytes).
   * @param end_offset End offset (in characters not bytes).
   */
  void select_region(int start_offset, int end_offset);
  
  /** Gets the selected range of characters in the label, returning <tt>true</tt>
   * if there's a selection.
   * @param start Return location for start of selection, as a character offset.
   * @param end Return location for end of selection, as a character offset.
   * @return <tt>true</tt> if selection is non-empty.
   */
  bool get_selection_bounds(int& start, int& end);

  
  /** Gets the Pango::Layout used to display the label.
   * The layout is useful to e.g. convert text positions to
   * pixel positions, in combination with get_layout_offsets().
   * The returned layout is owned by the label so need not be
   * freed by the caller.
   * @return The Pango::Layout for this label.
   */
  Glib::RefPtr<Pango::Layout> get_layout();
  
  /** Obtains the coordinates where the label will draw the Pango::Layout
   * representing the text in the label; useful to convert mouse events
   * into coordinates inside the Pango::Layout, e.g.\ to take some action
   * if some part of the label is clicked. Of course you will need to
   * create a Gtk::EventBox to receive the events, and pack the label
   * inside it, since labels are a Gtk::NO_WINDOW widget. Remember
   * when using the Pango::Layout functions you need to convert to
   * and from pixels using PANGO_PIXELS() or Pango::SCALE.
   * @param x Location to store X offset of layout, or <tt>0</tt>.
   * @param y Location to store Y offset of layout, or <tt>0</tt>.
   */
  void get_layout_offsets(int& x, int& y);

  
  /**
   * @par Prototype:
   * <tt>void %move_cursor(MovementStep step, int count, bool extend_selection)</tt>
   */
  Glib::SignalProxy3<void,MovementStep,int,bool> signal_move_cursor();

  
  /**
   * @par Prototype:
   * <tt>void %copy_clipboard()</tt>
   */
  Glib::SignalProxy0<void> signal_copy_clipboard();

  
  /**
   * @par Prototype:
   * <tt>void %populate_popup(Menu* menu)</tt>
   */
  Glib::SignalProxy1<void,Menu*> signal_populate_popup();


  Glib::PropertyProxy<Glib::ustring> property_label();

  Glib::PropertyProxy<Pango::AttrList> property_attributes();

  Glib::PropertyProxy<bool> property_use_markup();

  Glib::PropertyProxy<bool> property_use_underline();

  Glib::PropertyProxy<Justification> property_justify();

  Glib::PropertyProxy_WriteOnly<Glib::ustring> property_pattern();

  Glib::PropertyProxy<bool> property_wrap();

  Glib::PropertyProxy<bool> property_selectable();

  Glib::PropertyProxy_ReadOnly<guint> property_mnemonic_keyval();

  Glib::PropertyProxy<Widget*> property_mnemonic_widget();

  Glib::PropertyProxy_ReadOnly<int> property_cursor_position();

  Glib::PropertyProxy_ReadOnly<int> property_selection_bound();


};

}  /* namespace Gtk */


namespace Glib
{
  /** @relates Gtk::Label */
  Gtk::Label* wrap(GtkLabel* object, bool take_copy = false);
}
#endif /* _GTKMM_LABEL_H */

