
#include <gtkmm/item.h>
#include <gtkmm/private/item_p.h>

// -*- c++ -*-
/* $Id: item.ccg,v 1.3 2001/11/30 14:53:00 murrayc Exp $ */

/* 
 *
 * Copyright 1998-1999 The Gtk-- Development Team
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtkitem.h>


namespace
{

const Glib::SignalProxyInfo Item_signal_select_info =
{
  "select",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


const Glib::SignalProxyInfo Item_signal_deselect_info =
{
  "deselect",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


const Glib::SignalProxyInfo Item_signal_toggle_info =
{
  "toggle",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};

} // anonymous namespace


namespace Glib
{

Gtk::Item* wrap(GtkItem* object, bool take_copy /* = false */)
{
  return dynamic_cast<Gtk::Item *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gtk
{


/* The *_Class implementation: */

GType Item_Class::get_type()
  {
    if (!gtype_) //Create the GType if necessary.
      {
        //Make sure that the parent type has been created:
        CppClassParent::CppObjectType::get_type();

        //Create a derived C type.
        //These init funcs will, in turn, call the init functions in the base C type.
        GTypeInfo info =
          {
            sizeof(BaseClassType), /* class_size */
            0, /* base_init */
            0, /* base_finalize */
            (GClassInitFunc) &class_init_function, /* class_init */
            0, /* class_finalize */
            0, /* class_data */
            sizeof(BaseObjectType), /* instance_size */
            0, /* n_preallocs */
            0, /* instance_init */
	    0 /* value_table */
          };

        gtype_ = g_type_register_static(gtk_item_get_type(), "gtkmm__Item", &info, GTypeFlags(0));

  //Add derived versions of interfaces, if the C type implements any interfaces:
      }
    return gtype_;
  }
void Item_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
  klass->select = &select_callback;
  klass->deselect = &deselect_callback;
  klass->toggle = &toggle_callback;
}


void Item_Class::select_callback(GtkItem* self)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_select();
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->select)
      (*base->select)(self);
  }
}

void Item_Class::deselect_callback(GtkItem* self)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_deselect();
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->deselect)
      (*base->deselect)(self);
  }
}

void Item_Class::toggle_callback(GtkItem* self)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_toggle();
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->toggle)
      (*base->toggle)(self);
  }
}


Glib::ObjectBase* Item_Class::wrap_new(GObject* o)
{
  return manage(new Item((GtkItem*)(o)));
}


/* The implementation: */

Item::Item(GtkItem* castitem)
: Gtk::Bin((GtkBin*)(castitem))
{}

Item::~Item()
{
  destroy_();
}

Item::CppClassType Item::item_class_; //Initialize static member.

GType Item::get_type()
{
  return item_class_.get_type();
}

GType Item::get_base_type()
{
  return gtk_item_get_type();
}

void Item::select()
{
  gtk_item_select(gobj());
}

void Item::deselect()
{
  gtk_item_deselect(gobj());
}

void Item::toggle()
{
  gtk_item_toggle(gobj());
}

Item::Item()
: Gtk::Bin((GtkBin*)(g_object_new(get_type(), (char*)0)))
{}


Glib::SignalProxy0<void> Item::signal_select()
{
  return Glib::SignalProxy0<void>(this, &Item_signal_select_info);
}

Glib::SignalProxy0<void> Item::signal_deselect()
{
  return Glib::SignalProxy0<void>(this, &Item_signal_deselect_info);
}

Glib::SignalProxy0<void> Item::signal_toggle()
{
  return Glib::SignalProxy0<void>(this, &Item_signal_toggle_info);
}


void Gtk::Item::on_select()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->select)
    (*base->select)(gobj());
}

void Gtk::Item::on_deselect()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->deselect)
    (*base->deselect)(gobj());
}

void Gtk::Item::on_toggle()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->toggle)
    (*base->toggle)(gobj());
}


} // namespace Gtk

