
#include <gtkmm/inputdialog.h>
#include <gtkmm/private/inputdialog_p.h>

// -*- c++ -*-
/* $Id: inputdialog.ccg,v 1.3 2001/05/29 05:31:27 kenelson Exp $ */

/* 
 *
 * Copyright 1998-1999 The Gtk-- Development Team
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtkinputdialog.h>
#include <gtkmm/button.h>
#include <gtkmm/optionmenu.h>
#include <gtkmm/scrolledwindow.h>
#include <gtkmm/table.h>


namespace
{


void InputDialog_signal_enable_device_callback(GtkInputDialog*, GdkDevice* p0,void* data)
{
  using namespace Gtk;
  typedef SigC::Slot1<void,GdkDevice*> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    (*(SlotType::Proxy)(slot->proxy_))
        (p0, slot);
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }
}

const Glib::SignalProxyInfo InputDialog_signal_enable_device_info =
{
  "enable_device",
  (GCallback) &InputDialog_signal_enable_device_callback,
  (GCallback) &InputDialog_signal_enable_device_callback
};


void InputDialog_signal_disable_device_callback(GtkInputDialog*, GdkDevice* p0,void* data)
{
  using namespace Gtk;
  typedef SigC::Slot1<void,GdkDevice*> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    (*(SlotType::Proxy)(slot->proxy_))
        (p0, slot);
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }
}

const Glib::SignalProxyInfo InputDialog_signal_disable_device_info =
{
  "disable_device",
  (GCallback) &InputDialog_signal_disable_device_callback,
  (GCallback) &InputDialog_signal_disable_device_callback
};

} // anonymous namespace


namespace Glib
{

Gtk::InputDialog* wrap(GtkInputDialog* object, bool take_copy /* = false */)
{
  return dynamic_cast<Gtk::InputDialog *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gtk
{


/* The *_Class implementation: */

GType InputDialog_Class::get_type()
  {
    if (!gtype_) //Create the GType if necessary.
      {
        //Make sure that the parent type has been created:
        CppClassParent::CppObjectType::get_type();

        //Create a derived C type.
        //These init funcs will, in turn, call the init functions in the base C type.
        GTypeInfo info =
          {
            sizeof(BaseClassType), /* class_size */
            0, /* base_init */
            0, /* base_finalize */
            (GClassInitFunc) &class_init_function, /* class_init */
            0, /* class_finalize */
            0, /* class_data */
            sizeof(BaseObjectType), /* instance_size */
            0, /* n_preallocs */
            0, /* instance_init */
	    0 /* value_table */
          };

        gtype_ = g_type_register_static(gtk_input_dialog_get_type(), "gtkmm__InputDialog", &info, GTypeFlags(0));

  //Add derived versions of interfaces, if the C type implements any interfaces:
      }
    return gtype_;
  }
void InputDialog_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
  klass->enable_device = &enable_device_callback;
  klass->disable_device = &disable_device_callback;
}


void InputDialog_Class::enable_device_callback(GtkInputDialog* self, GdkDevice* p0)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_enable_device(p0);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->enable_device)
      (*base->enable_device)(self, p0);
  }
}

void InputDialog_Class::disable_device_callback(GtkInputDialog* self, GdkDevice* p0)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_disable_device(p0);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->disable_device)
      (*base->disable_device)(self, p0);
  }
}


Glib::ObjectBase* InputDialog_Class::wrap_new(GObject* o)
{
  return manage(new InputDialog((GtkInputDialog*)(o)));
}


/* The implementation: */

InputDialog::InputDialog(GtkInputDialog* castitem)
: Gtk::Dialog((GtkDialog*)(castitem))
{}

InputDialog::~InputDialog()
{
  destroy_();
}

InputDialog::CppClassType InputDialog::inputdialog_class_; //Initialize static member.

GType InputDialog::get_type()
{
  return inputdialog_class_.get_type();
}

GType InputDialog::get_base_type()
{
  return gtk_input_dialog_get_type();
}

InputDialog::InputDialog()
: Gtk::Dialog((GtkDialog*)(g_object_new(get_type(), (char*)0)))
{}

Table* InputDialog::get_axis_list()
{
  return Glib::wrap((GtkTable*)(gobj()->axis_list));
}

const Table* InputDialog::get_axis_list() const
{
  return Glib::wrap((GtkTable*)(gobj()->axis_list));
}

ScrolledWindow* InputDialog::get_axis_box()
{
  return Glib::wrap((GtkScrolledWindow*)(gobj()->axis_listbox));
}

const ScrolledWindow* InputDialog::get_axis_box() const
{
  return Glib::wrap((GtkScrolledWindow*)(gobj()->axis_listbox));
}

OptionMenu* InputDialog::get_mode_optionmenu()
{
  return Glib::wrap((GtkOptionMenu*)(gobj()->mode_optionmenu));
}

const OptionMenu* InputDialog::get_mode_optionmenu() const
{
  return Glib::wrap((GtkOptionMenu*)(gobj()->mode_optionmenu));
}

Button* InputDialog::get_close_button()
{
  return Glib::wrap((GtkButton*)(gobj()->close_button));
}

const Button* InputDialog::get_close_button() const
{
  return Glib::wrap((GtkButton*)(gobj()->close_button));
}

Button* InputDialog::get_save_button()
{
  return Glib::wrap((GtkButton*)(gobj()->save_button));
}

const Button* InputDialog::get_save_button() const
{
  return Glib::wrap((GtkButton*)(gobj()->save_button));
}

GdkDevice* InputDialog::get_current_device()
{
  return gobj()->current_device;
}

const GdkDevice* InputDialog::get_current_device() const
{
  return gobj()->current_device;
}

Table* InputDialog::get_keys_list()
{
  return Glib::wrap((GtkTable*)(gobj()->keys_list));
}

const Table* InputDialog::get_keys_list() const
{
  return Glib::wrap((GtkTable*)(gobj()->keys_list));
}

ScrolledWindow* InputDialog::get_keys_box()
{
  return Glib::wrap((GtkScrolledWindow*)(gobj()->keys_listbox));
}

const ScrolledWindow* InputDialog::get_keys_box() const
{
  return Glib::wrap((GtkScrolledWindow*)(gobj()->keys_listbox));
}


Glib::SignalProxy1<void,GdkDevice*> InputDialog::signal_enable_device()
{
  return Glib::SignalProxy1<void,GdkDevice*>(this, &InputDialog_signal_enable_device_info);
}

Glib::SignalProxy1<void,GdkDevice*> InputDialog::signal_disable_device()
{
  return Glib::SignalProxy1<void,GdkDevice*>(this, &InputDialog_signal_disable_device_info);
}


void Gtk::InputDialog::on_enable_device(GdkDevice* device)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->enable_device)
    (*base->enable_device)(gobj(),device);
}

void Gtk::InputDialog::on_disable_device(GdkDevice* device)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->disable_device)
    (*base->disable_device)(gobj(),device);
}


} // namespace Gtk

