
#include <gtkmm/iconsource.h>
#include <gtkmm/private/iconsource_p.h>

// -*- c++ -*-
/* $Id: iconsource.ccg,v 1.1 2001/11/09 16:58:15 murrayc Exp $ */

/*
 *
 * Copyright 1998-1999 The Gtk-- Development Team
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


namespace
{
} // anonymous namespace


namespace Glib
{

Gtk::IconSource wrap(GtkIconSource* object, bool take_copy /* = false */)
{
  return Gtk::IconSource(object, take_copy);
}

} // namespace Glib


namespace Gtk
{


// static
GType IconSource::get_type()
{
  return gtk_icon_source_get_type();
}

IconSource::IconSource()
:
  gobject_ (gtk_icon_source_new())
{}

IconSource::IconSource(const IconSource& src)
:
  gobject_ ((src.gobject_) ? gtk_icon_source_copy(src.gobject_) : 0)
{}

IconSource::IconSource(GtkIconSource* castitem, bool make_a_copy /* = true */)
{
  // For BoxedType wrappers, make_a_copy is true by default.  The static
  // BoxedType wrappers must always take a copy, thus make_a_copy = true
  // ensures identical behaviour if the default argument is used.

  if(make_a_copy)
  {
    if(castitem)
      gobject_ = gtk_icon_source_copy(castitem);
    else
      gobject_ = 0;
  }
  else
  {
    // It was given to us by a function which has already made a copy for us to keep.
    gobject_ = castitem;
  }
}

IconSource& IconSource::operator=(const IconSource& src)
{
  GtkIconSource *const new_gobject = (src.gobject_) ? gtk_icon_source_copy(src.gobject_) : 0;

  if(gobject_)
    gtk_icon_source_free(gobject_);
  gobject_ = new_gobject;

  return *this;
}

IconSource::~IconSource()
{
  if(gobject_)
    gtk_icon_source_free(gobject_);}


GtkIconSource* IconSource::gobj_copy() const
{
  return gtk_icon_source_copy(gobject_);
}

void IconSource::set_filename(const Glib::ustring& filename)
{
  gtk_icon_source_set_filename(gobj(), filename.c_str());
}

void IconSource::set_pixbuf(const Glib::RefPtr<Gdk::Pixbuf>& pixbuf)
{
  gtk_icon_source_set_pixbuf(gobj(), Glib::unwrap(pixbuf));
}

Glib::ustring IconSource::get_filename()
{
  return Glib::convert_const_gchar_ptr_to_ustring(gtk_icon_source_get_filename(gobj()));
}

Glib::RefPtr<Gdk::Pixbuf> IconSource::get_pixbuf()
{
  return Glib::wrap(gtk_icon_source_get_pixbuf(gobj()));
}

void IconSource::set_direction_wildcarded(bool setting)
{
  gtk_icon_source_set_direction_wildcarded(gobj(), static_cast<int>(setting));
}

void IconSource::set_state_wildcarded(bool setting)
{
  gtk_icon_source_set_state_wildcarded(gobj(), static_cast<int>(setting));
}

void IconSource::set_size_wildcarded(bool setting)
{
  gtk_icon_source_set_size_wildcarded(gobj(), static_cast<int>(setting));
}

bool IconSource::get_size_wildcarded() const
{
  return gtk_icon_source_get_size_wildcarded(const_cast<GtkIconSource*>(gobj()));
}

bool IconSource::get_state_wildcarded() const
{
  return gtk_icon_source_get_state_wildcarded(const_cast<GtkIconSource*>(gobj()));
}

bool IconSource::get_direction_wildcarded() const
{
  return gtk_icon_source_get_direction_wildcarded(const_cast<GtkIconSource*>(gobj()));
}

void IconSource::set_direction(TextDirection direction)
{
  gtk_icon_source_set_direction(gobj(), ((GtkTextDirection)(direction)));
}

void IconSource::set_state(StateType state)
{
  gtk_icon_source_set_state(gobj(), ((GtkStateType)(state)));
}

void IconSource::set_size(IconSize size)
{
  gtk_icon_source_set_size(gobj(), static_cast<GtkIconSize>(int(size)));
}

TextDirection IconSource::get_direction() const
{
  return ((TextDirection)(gtk_icon_source_get_direction(const_cast<GtkIconSource*>(gobj()))));
}

StateType IconSource::get_state() const
{
  return ((StateType)(gtk_icon_source_get_state(const_cast<GtkIconSource*>(gobj()))));
}

IconSize IconSource::get_size() const
{
  return IconSize(static_cast<int>(gtk_icon_source_get_size(const_cast<GtkIconSource*>(gobj()))));
}


} // namespace Gtk


