
#include <gtkmm/checkmenuitem.h>
#include <gtkmm/private/checkmenuitem_p.h>

// -*- c++ -*-
/* $Id: checkmenuitem.ccg,v 1.11 2002/03/09 18:10:46 murrayc Exp $ */

/* 
 *
 * Copyright 1998-1999 The Gtk-- Development Team
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtkcheckmenuitem.h>
#include <gtkmm/misc.h>
#include <gtkmm/label.h>

namespace Gtk
{

CheckMenuItem::CheckMenuItem(const Glib::ustring& label, bool mnemonic /* = false */)
: Gtk::MenuItem( (GtkMenuItem*)(g_object_new(get_type(), 0)) )
{
  add_accel_label(label, mnemonic); /* Left-aligned label */
}

} /* namespace Gtk */

namespace
{

const Glib::SignalProxyInfo CheckMenuItem_signal_toggled_info =
{
  "toggled",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};

} // anonymous namespace


namespace Glib
{

Gtk::CheckMenuItem* wrap(GtkCheckMenuItem* object, bool take_copy /* = false */)
{
  return dynamic_cast<Gtk::CheckMenuItem *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gtk
{


/* The *_Class implementation: */

GType CheckMenuItem_Class::get_type()
  {
    if (!gtype_) //Create the GType if necessary.
      {
        //Make sure that the parent type has been created:
        CppClassParent::CppObjectType::get_type();

        //Create a derived C type.
        //These init funcs will, in turn, call the init functions in the base C type.
        GTypeInfo info =
          {
            sizeof(BaseClassType), /* class_size */
            0, /* base_init */
            0, /* base_finalize */
            (GClassInitFunc) &class_init_function, /* class_init */
            0, /* class_finalize */
            0, /* class_data */
            sizeof(BaseObjectType), /* instance_size */
            0, /* n_preallocs */
            0, /* instance_init */
	    0 /* value_table */
          };

        gtype_ = g_type_register_static(gtk_check_menu_item_get_type(), "gtkmm__CheckMenuItem", &info, GTypeFlags(0));

  //Add derived versions of interfaces, if the C type implements any interfaces:
      }
    return gtype_;
  }
void CheckMenuItem_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
  klass->draw_indicator = &draw_indicator_vfunc_callback;
  klass->toggled = &toggled_callback;
}


void CheckMenuItem_Class::draw_indicator_vfunc_callback(GtkCheckMenuItem* self, GdkRectangle* area)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->draw_indicator(area);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->draw_indicator)
      (*base->draw_indicator)(self, area);
  }
}


void CheckMenuItem_Class::toggled_callback(GtkCheckMenuItem* self)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_toggled();
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->toggled)
      (*base->toggled)(self);
  }
}


Glib::ObjectBase* CheckMenuItem_Class::wrap_new(GObject* o)
{
  return manage(new CheckMenuItem((GtkCheckMenuItem*)(o)));
}


/* The implementation: */

CheckMenuItem::CheckMenuItem(GtkCheckMenuItem* castitem)
: Gtk::MenuItem((GtkMenuItem*)(castitem))
{}

CheckMenuItem::~CheckMenuItem()
{
  destroy_();
}

CheckMenuItem::CppClassType CheckMenuItem::checkmenuitem_class_; //Initialize static member.

GType CheckMenuItem::get_type()
{
  return checkmenuitem_class_.get_type();
}

GType CheckMenuItem::get_base_type()
{
  return gtk_check_menu_item_get_type();
}

CheckMenuItem::CheckMenuItem()
: Gtk::MenuItem((GtkMenuItem*)(g_object_new(get_type(), (char*)0)))
{}

void CheckMenuItem::set_active(bool state)
{
  gtk_check_menu_item_set_active(gobj(), static_cast<int>(state));
}

bool CheckMenuItem::get_active() const
{
  return gtk_check_menu_item_get_active(const_cast<GtkCheckMenuItem*>(gobj()));
}

void CheckMenuItem::toggled()
{
  gtk_check_menu_item_toggled(gobj());
}

void CheckMenuItem::set_inconsistent(bool setting)
{
  gtk_check_menu_item_set_inconsistent(gobj(), static_cast<int>(setting));
}

bool CheckMenuItem::get_inconsistent() const
{
  return gtk_check_menu_item_get_inconsistent(const_cast<GtkCheckMenuItem*>(gobj()));
}


Glib::SignalProxy0<void> CheckMenuItem::signal_toggled()
{
  return Glib::SignalProxy0<void>(this, &CheckMenuItem_signal_toggled_info);
}


Glib::PropertyProxy<bool> CheckMenuItem::property_active()
{
  return Glib::PropertyProxy<bool>(this, "active");
}

Glib::PropertyProxy<bool> CheckMenuItem::property_inconsistent()
{
  return Glib::PropertyProxy<bool>(this, "inconsistent");
}


void Gtk::CheckMenuItem::on_toggled()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->toggled)
    (*base->toggled)(gobj());
}


void Gtk::CheckMenuItem::draw_indicator(GdkRectangle* area)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->draw_indicator)
    (*base->draw_indicator)(gobj(),area);
}


} // namespace Gtk

