#include "common.h"
#include <gw-obex.h>
#include <signal.h>
#include <assert.h>

GMainLoop *loop;
typedef void (*sighandler_t)(int);

static void signal_handler(int sig) {
	printf("oi\n");
	g_main_loop_quit(loop);
}

static void callback(GwObexXfer *xfer, gpointer data) {
}

static void dc_callback(GwObex *ctx, gpointer data) {
}

int main(int argc, char **argv) {
	GwObex *gwo = setup();
	gw_obex_set_disconnect_callback(gwo, dc_callback, NULL);

	gint error;
	GwObexXfer *xfer = gw_obex_get_async(gwo, "abc", "text/html", &error);
	gw_obex_xfer_set_callback(xfer, callback, NULL);

	loop = g_main_loop_new(NULL, FALSE);

	sighandler_t r = signal(SIGINT, signal_handler);
	assert(r != SIG_ERR);

	g_main_loop_run(loop);

	gw_obex_xfer_free(xfer);
	gw_obex_close(gwo);
	return 0;
}
