<?xml version="1.0" encoding="UTF-8"?>
<xslt:stylesheet xmlns:xslt="http://www.w3.org/1999/XSL/Transform" xmlns:msg="http://www.gnome.org/~shaunm/gnome-doc-utils/xsl-format" version="1.0">
  <title xmlns="http://www.gnome.org/~shaunm/xsldoc">Format Templates</title>
  <template xmlns="http://www.gnome.org/~shaunm/xsldoc">
    <name>format.citetitle</name>
    <purpose>
    Format a <xmltag>citetitle</xmltag> element
  </purpose>
    <parameter>
      <name>lang</name>
      <purpose>
              The language to use for formatting
            </purpose>
    </parameter>
    <parameter>
      <name>node</name>
      <purpose>
      The <sgmltag>citetitle</sgmltag> element to format
    </purpose>
    </parameter>
    <parameter>
      <name>role</name>
      <purpose>
      The role of the label, extracted from the
      <sgmltag class="attribute">pubwork</sgmltag> attribute
    </purpose>
    </parameter>
    <description>
      <para>This template used for formatting the <sgmltag>citetitle</sgmltag>
    element in DocBook.  The <sgmltag>citetitle</sgmltag> element has a
    <sgmltag class="attribute">pubwork</sgmltag> attribute that can be set
    to one of the following values:
    <literal>article</literal>,      <literal>bbs</literal>,
    <literal>book</literal>,         <literal>cdrom</literal>,
    <literal>chapter</literal>,      <literal>dvd</literal>,
    <literal>emailmessage</literal>, <literal>gopher</literal>,
    <literal>journal</literal>,      <literal>manuscript</literal>,
    <literal>newsposting</literal>,  <literal>part</literal>,
    <literal>refentry</literal>,     <literal>section</literal>,
    <literal>series</literal>,       <literal>set</literal>,
    <literal>webpage</literal>,      <literal>wiki</literal>.
    This template allows multiple role format strings, using the value of
    <sgmltag class="attribute">pubwork</sgmltag> as the role.  Translators
    can use this to customize the appearance of a cited title based on the
    type of document being cited.  The default formatting is as follows:</para>
      <programlisting>
&lt;msg:msgstr role="article"&gt;“%t{node}”&lt;/msg:msgstr&gt;
&lt;msg:msgstr&gt;&lt;i&gt;%t{node}&lt;/i&gt;&lt;/msg:msgstr&gt;</programlisting>
      <para>This puts the title of an article citation in quotes.  For all other
    types of works, the title is simply italicized.</para>
    </description>
    <section>
      <title>Arguments</title>
      <para>This is a format template constructed by
    <function role="xsl-template" moreinfo="refentry">format2xsl</function>.
    The following arguments are available for translators:</para>
      <variablelist>
        <varlistentry>
          <term>
            <parameter>node</parameter>
          </term>
          <listitem>
            <para>A template argument which processes the contents of
        the <sgmltag>citetitle</sgmltag> element.</para>
          </listitem>
        </varlistentry>
      </variablelist>
    </section>
  </template>
  <xslt:template name="format.citetitle">
    <xslt:param select="." name="node"/>
    <xslt:param name="role"/>
    <xslt:param name="lang" select="$node/ancestor-or-self::*[@lang][1]/@lang"/>
    <xslt:variable name="lang_language">
      <xslt:call-template name="gettext.get.language">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_region">
      <xslt:call-template name="gettext.get.region">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_variant">
      <xslt:call-template name="gettext.get.variant">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_charset">
      <xslt:call-template name="gettext.get.charset">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:choose>
      <xslt:when test="$lang_language = 'sr' and $lang_variant = 'Latn'">
        <xslt:choose>
          <xslt:when test="$role = 'article'">
            <xslt:text>„</xslt:text>
            <xslt:apply-templates select="$node/node()"/>
            <xslt:text>“</xslt:text>
          </xslt:when>
          <xslt:otherwise>
            <xslt:variable name="name">
              <xslt:call-template name="format2xsl.element.name">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:variable name="namespace">
              <xslt:call-template name="format2xsl.element.namespace">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:element name="{$name}" namespace="{$namespace}">
              <xslt:text/>
              <xslt:apply-templates select="$node/node()"/>
              <xslt:text/>
            </xslt:element>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'pt' and $lang_region = 'BR'">
        <xslt:choose>
          <xslt:when test="$role = 'article'">
            <xslt:text>“</xslt:text>
            <xslt:apply-templates select="$node/node()"/>
            <xslt:text>”</xslt:text>
          </xslt:when>
          <xslt:otherwise>
            <xslt:variable name="name">
              <xslt:call-template name="format2xsl.element.name">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:variable name="namespace">
              <xslt:call-template name="format2xsl.element.namespace">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:element name="{$name}" namespace="{$namespace}">
              <xslt:text/>
              <xslt:apply-templates select="$node/node()"/>
              <xslt:text/>
            </xslt:element>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'bg'">
        <xslt:text>
  </xslt:text>
        <xslt:text>„</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>“</xslt:text>
        <xslt:text>
  </xslt:text>
        <xslt:variable name="name">
          <xslt:call-template name="format2xsl.element.name">
            <xslt:with-param name="name" select="'i'"/>
            <xslt:with-param name="namespace" select="''"/>
          </xslt:call-template>
        </xslt:variable>
        <xslt:variable name="namespace">
          <xslt:call-template name="format2xsl.element.namespace">
            <xslt:with-param name="name" select="'i'"/>
            <xslt:with-param name="namespace" select="''"/>
          </xslt:call-template>
        </xslt:variable>
        <xslt:element name="{$name}" namespace="{$namespace}">
          <xslt:text/>
          <xslt:apply-templates select="$node/node()"/>
          <xslt:text/>
        </xslt:element>
        <xslt:text>
</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'cs'">
        <xslt:choose>
          <xslt:when test="$role = 'article'">
            <xslt:text>„</xslt:text>
            <xslt:apply-templates select="$node/node()"/>
            <xslt:text>”</xslt:text>
          </xslt:when>
          <xslt:otherwise>
            <xslt:variable name="name">
              <xslt:call-template name="format2xsl.element.name">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:variable name="namespace">
              <xslt:call-template name="format2xsl.element.namespace">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:element name="{$name}" namespace="{$namespace}">
              <xslt:text/>
              <xslt:apply-templates select="$node/node()"/>
              <xslt:text/>
            </xslt:element>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'de'">
        <xslt:choose>
          <xslt:when test="$role = 'article'">
            <xslt:text>“</xslt:text>
            <xslt:apply-templates select="$node/node()"/>
            <xslt:text>”</xslt:text>
          </xslt:when>
          <xslt:otherwise>
            <xslt:variable name="name">
              <xslt:call-template name="format2xsl.element.name">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:variable name="namespace">
              <xslt:call-template name="format2xsl.element.namespace">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:element name="{$name}" namespace="{$namespace}">
              <xslt:text/>
              <xslt:apply-templates select="$node/node()"/>
              <xslt:text/>
            </xslt:element>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'es'">
        <xslt:variable name="name">
          <xslt:call-template name="format2xsl.element.name">
            <xslt:with-param name="name" select="'i'"/>
            <xslt:with-param name="namespace" select="''"/>
          </xslt:call-template>
        </xslt:variable>
        <xslt:variable name="namespace">
          <xslt:call-template name="format2xsl.element.namespace">
            <xslt:with-param name="name" select="'i'"/>
            <xslt:with-param name="namespace" select="''"/>
          </xslt:call-template>
        </xslt:variable>
        <xslt:element name="{$name}" namespace="{$namespace}">
          <xslt:text/>
          <xslt:apply-templates select="$node/node()"/>
          <xslt:text/>
        </xslt:element>
      </xslt:when>
      <xslt:when test="$lang_language = 'et'">
        <xslt:variable name="name">
          <xslt:call-template name="format2xsl.element.name">
            <xslt:with-param name="name" select="'i'"/>
            <xslt:with-param name="namespace" select="''"/>
          </xslt:call-template>
        </xslt:variable>
        <xslt:variable name="namespace">
          <xslt:call-template name="format2xsl.element.namespace">
            <xslt:with-param name="name" select="'i'"/>
            <xslt:with-param name="namespace" select="''"/>
          </xslt:call-template>
        </xslt:variable>
        <xslt:element name="{$name}" namespace="{$namespace}">
          <xslt:text/>
          <xslt:apply-templates select="$node/node()"/>
          <xslt:text/>
        </xslt:element>
      </xslt:when>
      <xslt:when test="$lang_language = 'fi'">
        <xslt:variable name="name">
          <xslt:call-template name="format2xsl.element.name">
            <xslt:with-param name="name" select="'i'"/>
            <xslt:with-param name="namespace" select="''"/>
          </xslt:call-template>
        </xslt:variable>
        <xslt:variable name="namespace">
          <xslt:call-template name="format2xsl.element.namespace">
            <xslt:with-param name="name" select="'i'"/>
            <xslt:with-param name="namespace" select="''"/>
          </xslt:call-template>
        </xslt:variable>
        <xslt:element name="{$name}" namespace="{$namespace}">
          <xslt:text/>
          <xslt:apply-templates select="$node/node()"/>
          <xslt:text/>
        </xslt:element>
      </xslt:when>
      <xslt:when test="$lang_language = 'hu'">
        <xslt:choose>
          <xslt:when test="$role = 'article'">
            <xslt:text>“</xslt:text>
            <xslt:apply-templates select="$node/node()"/>
            <xslt:text>”</xslt:text>
          </xslt:when>
          <xslt:otherwise>
            <xslt:variable name="name">
              <xslt:call-template name="format2xsl.element.name">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:variable name="namespace">
              <xslt:call-template name="format2xsl.element.namespace">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:element name="{$name}" namespace="{$namespace}">
              <xslt:text/>
              <xslt:apply-templates select="$node/node()"/>
              <xslt:text/>
            </xslt:element>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'id'">
        <xslt:text>bentuk.citetitle</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'lt'">
        <xslt:text>„</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>“</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'nb'">
        <xslt:text>format.sitattittel</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'ne'">
        <xslt:text>ढाँचा.साइटशीर्षक</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'no'">
        <xslt:text>format.sitattittel</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'pt'">
        <xslt:choose>
          <xslt:when test="$role = 'article'">
            <xslt:text>“</xslt:text>
            <xslt:apply-templates select="$node/node()"/>
            <xslt:text>”</xslt:text>
          </xslt:when>
          <xslt:otherwise>
            <xslt:variable name="name">
              <xslt:call-template name="format2xsl.element.name">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:variable name="namespace">
              <xslt:call-template name="format2xsl.element.namespace">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:element name="{$name}" namespace="{$namespace}">
              <xslt:text/>
              <xslt:apply-templates select="$node/node()"/>
              <xslt:text/>
            </xslt:element>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'ro'">
        <xslt:choose>
          <xslt:when test="$role = 'article'">
            <xslt:text>„</xslt:text>
            <xslt:apply-templates select="$node/node()"/>
            <xslt:text>”</xslt:text>
          </xslt:when>
          <xslt:otherwise>
            <xslt:variable name="name">
              <xslt:call-template name="format2xsl.element.name">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:variable name="namespace">
              <xslt:call-template name="format2xsl.element.namespace">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:element name="{$name}" namespace="{$namespace}">
              <xslt:text/>
              <xslt:apply-templates select="$node/node()"/>
              <xslt:text/>
            </xslt:element>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'sr'">
        <xslt:choose>
          <xslt:when test="$role = 'article'">
            <xslt:text>„</xslt:text>
            <xslt:apply-templates select="$node/node()"/>
            <xslt:text>“</xslt:text>
          </xslt:when>
          <xslt:otherwise>
            <xslt:variable name="name">
              <xslt:call-template name="format2xsl.element.name">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:variable name="namespace">
              <xslt:call-template name="format2xsl.element.namespace">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:element name="{$name}" namespace="{$namespace}">
              <xslt:text/>
              <xslt:apply-templates select="$node/node()"/>
              <xslt:text/>
            </xslt:element>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'sv'">
        <xslt:text>format.citattitel</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'tr'">
        <xslt:text>format.çağrıbaşlığı</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'vi'">
        <xslt:text>Trích dẫn tên</xslt:text>
      </xslt:when>
      <xslt:otherwise>
        <xslt:choose>
          <xslt:when test="$role = 'article'">
            <xslt:text>“</xslt:text>
            <xslt:apply-templates select="$node/node()"/>
            <xslt:text>”</xslt:text>
          </xslt:when>
          <xslt:otherwise>
            <xslt:variable name="name">
              <xslt:call-template name="format2xsl.element.name">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:variable name="namespace">
              <xslt:call-template name="format2xsl.element.namespace">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:element name="{$name}" namespace="{$namespace}">
              <xslt:text/>
              <xslt:apply-templates select="$node/node()"/>
              <xslt:text/>
            </xslt:element>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:otherwise>
    </xslt:choose>
  </xslt:template>
  <template xmlns="http://www.gnome.org/~shaunm/xsldoc">
    <name>format.quote.outer</name>
    <purpose>
    Format a <xmltag>quote</xmltag> element
  </purpose>
    <parameter>
      <name>lang</name>
      <purpose>
              The language to use for formatting
            </purpose>
    </parameter>
    <parameter>
      <name>node</name>
      <purpose>
      The <xmltag>quote</xmltag> element to format
    </purpose>
    </parameter>
    <section>
      <title>Arguments</title>
      <para>This is a format template constructed by
    <function role="xsl-template" moreinfo="refentry">format2xsl</function>.
    The following arguments are available for translators:</para>
      <variablelist>
        <varlistentry>
          <term>
            <parameter>node</parameter>
          </term>
          <listitem>
            <para>A template argument which processes the contents of
        the <sgmltag>quote</sgmltag> element.</para>
          </listitem>
        </varlistentry>
      </variablelist>
    </section>
  </template>
  <xslt:template name="format.quote.outer">
    <xslt:param select="." name="node"/>
    <xslt:param name="lang" select="$node/ancestor-or-self::*[@lang][1]/@lang"/>
    <xslt:variable name="lang_language">
      <xslt:call-template name="gettext.get.language">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_region">
      <xslt:call-template name="gettext.get.region">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_variant">
      <xslt:call-template name="gettext.get.variant">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_charset">
      <xslt:call-template name="gettext.get.charset">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:choose>
      <xslt:when test="$lang_language = 'sr' and $lang_variant = 'Latn'">
        <xslt:text>„</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>“</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'pt' and $lang_region = 'BR'">
        <xslt:text>“</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>”</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'bg'">
        <xslt:text>„</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>“</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'cs'">
        <xslt:text>„</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>”</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'de'">
        <xslt:text>„</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>”</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'es'">
        <xslt:text>«</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>»</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'et'">
        <xslt:text>“</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>”</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'fi'">
        <xslt:text>"</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>"</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'hu'">
        <xslt:text>„</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>”</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'id'">
        <xslt:text>bentuk.kutip.luar</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'lt'">
        <xslt:text>„</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>“</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'nb'">
        <xslt:text>format.sitat.ytre</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'ne'">
        <xslt:text>ढाँचा.उदधृत वाक्य.बाहिरी</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'no'">
        <xslt:text>format.sitat.ytre</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'pt'">
        <xslt:text>“</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>”</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'ro'">
        <xslt:text>„</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>”</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'sk'">
        <xslt:text>„</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>“</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'sr'">
        <xslt:text>„</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>“</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'sv'">
        <xslt:text>format.citat.yttre</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'tr'">
        <xslt:text>format.aktarım.dışa</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'vi'">
        <xslt:text>«</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>»</xslt:text>
      </xslt:when>
      <xslt:otherwise>
        <xslt:text>“</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>”</xslt:text>
      </xslt:otherwise>
    </xslt:choose>
  </xslt:template>
  <template xmlns="http://www.gnome.org/~shaunm/xsldoc">
    <name>format.quote.inner</name>
    <purpose>
    Format a nested <xmltag>quote</xmltag> element
  </purpose>
    <parameter>
      <name>lang</name>
      <purpose>
              The language to use for formatting
            </purpose>
    </parameter>
    <parameter>
      <name>node</name>
      <purpose>
      The <xmltag>quote</xmltag> element to format
    </purpose>
    </parameter>
    <section>
      <title>Arguments</title>
      <para>This is a format template constructed by
    <function role="xsl-template" moreinfo="refentry">format2xsl</function>.
    The following arguments are available for translators:</para>
      <variablelist>
        <varlistentry>
          <term>
            <parameter>node</parameter>
          </term>
          <listitem>
            <para>A template argument which processes the contents of
        the <sgmltag>quote</sgmltag> element.</para>
          </listitem>
        </varlistentry>
      </variablelist>
    </section>
  </template>
  <xslt:template name="format.quote.inner">
    <xslt:param select="." name="node"/>
    <xslt:param name="lang" select="$node/ancestor-or-self::*[@lang][1]/@lang"/>
    <xslt:variable name="lang_language">
      <xslt:call-template name="gettext.get.language">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_region">
      <xslt:call-template name="gettext.get.region">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_variant">
      <xslt:call-template name="gettext.get.variant">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_charset">
      <xslt:call-template name="gettext.get.charset">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:choose>
      <xslt:when test="$lang_language = 'sr' and $lang_variant = 'Latn'">
        <xslt:text>‘</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>’</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'pt' and $lang_region = 'BR'">
        <xslt:text>‘</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>’</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'bg'">
        <xslt:text>«</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>»</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'cs'">
        <xslt:text>‚</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>’</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'de'">
        <xslt:text>‚</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>’</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'es'">
        <xslt:text>‘</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>’</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'et'">
        <xslt:text>‘</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>’</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'fi'">
        <xslt:text>'</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>'</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'hu'">
        <xslt:text>,,</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>''</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'id'">
        <xslt:text>bentuk.kutip.dalam</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'lt'">
        <xslt:text>„</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>“</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'nb'">
        <xslt:text>format.sitat.indre</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'ne'">
        <xslt:text>ढाँचा.उदधृत वाक्य.भित्री</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'no'">
        <xslt:text>format.sitat.indre</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'pt'">
        <xslt:text>‘</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>’</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'ro'">
        <xslt:text>‚</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>’</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'sk'">
        <xslt:text>'</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>'</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'sr'">
        <xslt:text>‘</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>’</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'sv'">
        <xslt:text>format.citat.inre</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'tr'">
        <xslt:text>format.aktarım.içe</xslt:text>
      </xslt:when>
      <xslt:when test="$lang_language = 'vi'">
        <xslt:text>‹</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>›</xslt:text>
      </xslt:when>
      <xslt:otherwise>
        <xslt:text>‘</xslt:text>
        <xslt:apply-templates select="$node/node()"/>
        <xslt:text>’</xslt:text>
      </xslt:otherwise>
    </xslt:choose>
  </xslt:template>
  <template xmlns="http://www.gnome.org/~shaunm/xsldoc">
    <name>format.appendix.label</name>
    <purpose>
    Format the label for a <xmltag>appendix</xmltag> element
  </purpose>
    <parameter>
      <name>lang</name>
      <purpose>
              The language to use for formatting
            </purpose>
    </parameter>
    <parameter>
      <name>node</name>
      <purpose>
      The <xmltag>appendix</xmltag> element to format
    </purpose>
    </parameter>
    <parameter>
      <name>role</name>
      <purpose>
      The role of the label
    </purpose>
    </parameter>
    <section>
      <title>Arguments</title>
      <para>This is a format template constructed by
    <function role="xsl-template" moreinfo="refentry">format2xsl</function>.
    The following arguments are available for translators:</para>
      <variablelist>
        <varlistentry>
          <term>
            <parameter>number</parameter>
          </term>
          <listitem>
            <para>A template argument which extracts the number
        portion of the label.</para>
          </listitem>
        </varlistentry>
        <varlistentry>
          <term>
            <parameter>title</parameter>
          </term>
          <listitem>
            <para>A template argument which extracts the title
        of the element.</para>
          </listitem>
        </varlistentry>
      </variablelist>
    </section>
  </template>
  <xslt:template name="format.appendix.label">
    <xslt:param select="." name="node"/>
    <xslt:param name="role"/>
    <xslt:param name="lang" select="$node/ancestor-or-self::*[@lang][1]/@lang"/>
    <xslt:variable name="lang_language">
      <xslt:call-template name="gettext.get.language">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_region">
      <xslt:call-template name="gettext.get.region">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_variant">
      <xslt:call-template name="gettext.get.variant">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_charset">
      <xslt:call-template name="gettext.get.charset">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:choose>
      <xslt:when test="$lang_language = 'sr' and $lang_variant = 'Latn'">
        <xslt:choose>
          <xslt:when test="$role = 'header'">
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text>. </xslt:text>
          </xslt:when>
          <xslt:when test="$role = 'li'">
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text>. </xslt:text>
          </xslt:when>
          <xslt:when test="$role = 'xref'">
            <xslt:text>Dodatak </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text> ― </xslt:text>
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:when>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Dodatak </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'pt' and $lang_region = 'BR'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Apêndice </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'zh' and $lang_region = 'CN'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>format.appendix label</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'bg'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Приложение </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'cs'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Příloha </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'de'">
        <xslt:choose>
          <xslt:when test="$role = 'header'">
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text>. </xslt:text>
          </xslt:when>
          <xslt:when test="$role = 'li'">
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text>. </xslt:text>
          </xslt:when>
          <xslt:when test="$role = 'xref'">
            <xslt:text>Anhang </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text> ― </xslt:text>
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:when>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Anhang </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'es'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Apéndice </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'et'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Lisa </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'fi'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Liite </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'hu'">
        <xslt:choose>
          <xslt:when test="$role = 'header'">
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text>. Függelék</xslt:text>
          </xslt:when>
          <xslt:when test="$role = 'li'">
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text>. Függelék</xslt:text>
          </xslt:when>
          <xslt:when test="$role = 'xref'">
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text>. Függelék: </xslt:text>
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:when>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text>. Függelék</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'id'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>bentuk.tambahan.nama</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'lt'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text>-as priedas</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'nb'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>format.tillegg.etikett</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'ne'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>ढाँचा.एपेन्डिक्स.लेबुल</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'no'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>format.tillegg.etikett</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'pt'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Apêndice </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'ro'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Anexa </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'sk'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Príloha </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'sr'">
        <xslt:choose>
          <xslt:when test="$role = 'header'">
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text>. </xslt:text>
          </xslt:when>
          <xslt:when test="$role = 'li'">
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text>. </xslt:text>
          </xslt:when>
          <xslt:when test="$role = 'xref'">
            <xslt:text>Додатак </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text> ― </xslt:text>
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:when>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Додатак </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'sv'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>format.appendix.etikett</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'tr'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>format.ek.etiket</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'vi'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Phụ lục </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:otherwise>
        <xslt:choose>
          <xslt:when test="$role = 'header'">
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text>. </xslt:text>
          </xslt:when>
          <xslt:when test="$role = 'li'">
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text>. </xslt:text>
          </xslt:when>
          <xslt:when test="$role = 'xref'">
            <xslt:text>Appendix </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text> ― </xslt:text>
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:when>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Appendix </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:otherwise>
    </xslt:choose>
  </xslt:template>
  <template xmlns="http://www.gnome.org/~shaunm/xsldoc">
    <name>format.chapter.label</name>
    <purpose>
    Format the label for a <xmltag>chapter</xmltag> element
  </purpose>
    <parameter>
      <name>lang</name>
      <purpose>
              The language to use for formatting
            </purpose>
    </parameter>
    <parameter>
      <name>node</name>
      <purpose>
      The <xmltag>chapter</xmltag> element to format
    </purpose>
    </parameter>
    <parameter>
      <name>role</name>
      <purpose>
      The role of the label
    </purpose>
    </parameter>
    <section>
      <title>Arguments</title>
      <para>This is a format template constructed by
    <function role="xsl-template" moreinfo="refentry">format2xsl</function>.
    The following arguments are available for translators:</para>
      <variablelist>
        <varlistentry>
          <term>
            <parameter>number</parameter>
          </term>
          <listitem>
            <para>A template argument which extracts the number
        portion of the label.</para>
          </listitem>
        </varlistentry>
        <varlistentry>
          <term>
            <parameter>title</parameter>
          </term>
          <listitem>
            <para>A template argument which extracts the title
        of the element.</para>
          </listitem>
        </varlistentry>
      </variablelist>
    </section>
  </template>
  <xslt:template name="format.chapter.label">
    <xslt:param select="." name="node"/>
    <xslt:param name="role"/>
    <xslt:param name="lang" select="$node/ancestor-or-self::*[@lang][1]/@lang"/>
    <xslt:variable name="lang_language">
      <xslt:call-template name="gettext.get.language">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_region">
      <xslt:call-template name="gettext.get.region">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_variant">
      <xslt:call-template name="gettext.get.variant">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_charset">
      <xslt:call-template name="gettext.get.charset">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:choose>
      <xslt:when test="$lang_language = 'sr' and $lang_variant = 'Latn'">
        <xslt:choose>
          <xslt:when test="$role = 'header'">
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text>. </xslt:text>
          </xslt:when>
          <xslt:when test="$role = 'li'">
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text>. </xslt:text>
          </xslt:when>
          <xslt:when test="$role = 'xref'">
            <xslt:text>Glava </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text> ― </xslt:text>
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:when>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Glava </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'pt' and $lang_region = 'BR'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Capítulo </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'zh' and $lang_region = 'CN'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>format.chapter label</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'bg'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Глава </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'cs'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Kapitola </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'de'">
        <xslt:choose>
          <xslt:when test="$role = 'header'">
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text>. </xslt:text>
          </xslt:when>
          <xslt:when test="$role = 'li'">
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text>. </xslt:text>
          </xslt:when>
          <xslt:when test="$role = 'xref'">
            <xslt:text>Kapitel </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text> ― </xslt:text>
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:when>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Kapitel </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'es'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Capítulo </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'et'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text>. peatükk</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'fi'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Kappale </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'hu'">
        <xslt:choose>
          <xslt:when test="$role = 'header'">
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text>. Fejezet</xslt:text>
          </xslt:when>
          <xslt:when test="$role = 'li'">
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text>. Fejezet</xslt:text>
          </xslt:when>
          <xslt:when test="$role = 'xref'">
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text>. Fejezet: </xslt:text>
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:when>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text>. Fejezet</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'id'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>bentuk.bab.nama</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'lt'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text>-as skyrius</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'nb'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>format.kapittel.etikett</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'ne'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>ढाँचा.अध्याय.लेबुल</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'no'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>format.kapittel.etikett</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'pt'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Capítulo </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'ro'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Capitolul </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'sk'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Kapitola </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'sr'">
        <xslt:choose>
          <xslt:when test="$role = 'header'">
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text>. </xslt:text>
          </xslt:when>
          <xslt:when test="$role = 'li'">
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text>. </xslt:text>
          </xslt:when>
          <xslt:when test="$role = 'xref'">
            <xslt:text>Глава </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text> ― </xslt:text>
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:when>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Глава </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'sv'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>format.kapitel.etikett</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'tr'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>format.bölüm.etiket</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'vi'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Chương </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:otherwise>
        <xslt:choose>
          <xslt:when test="$role = 'header'">
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text>. </xslt:text>
          </xslt:when>
          <xslt:when test="$role = 'li'">
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text>. </xslt:text>
          </xslt:when>
          <xslt:when test="$role = 'xref'">
            <xslt:text>Chapter </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text> ― </xslt:text>
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:when>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Chapter </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:otherwise>
    </xslt:choose>
  </xslt:template>
  <template xmlns="http://www.gnome.org/~shaunm/xsldoc">
    <name>format.example.label</name>
    <purpose>
    Format the label for a <xmltag>example</xmltag> element
  </purpose>
    <parameter>
      <name>lang</name>
      <purpose>
              The language to use for formatting
            </purpose>
    </parameter>
    <parameter>
      <name>node</name>
      <purpose>
      The <xmltag>example</xmltag> element to format
    </purpose>
    </parameter>
    <parameter>
      <name>role</name>
      <purpose>
      The role of the label
    </purpose>
    </parameter>
    <section>
      <title>Arguments</title>
      <para>This is a format template constructed by
    <function role="xsl-template" moreinfo="refentry">format2xsl</function>.
    The following arguments are available for translators:</para>
      <variablelist>
        <varlistentry>
          <term>
            <parameter>number</parameter>
          </term>
          <listitem>
            <para>A template argument which extracts the number
        portion of the label.</para>
          </listitem>
        </varlistentry>
        <varlistentry>
          <term>
            <parameter>title</parameter>
          </term>
          <listitem>
            <para>A template argument which extracts the title
        of the element.</para>
          </listitem>
        </varlistentry>
      </variablelist>
    </section>
  </template>
  <xslt:template name="format.example.label">
    <xslt:param select="." name="node"/>
    <xslt:param name="role"/>
    <xslt:param name="lang" select="$node/ancestor-or-self::*[@lang][1]/@lang"/>
    <xslt:variable name="lang_language">
      <xslt:call-template name="gettext.get.language">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_region">
      <xslt:call-template name="gettext.get.region">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_variant">
      <xslt:call-template name="gettext.get.variant">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_charset">
      <xslt:call-template name="gettext.get.charset">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:choose>
      <xslt:when test="$lang_language = 'sr' and $lang_variant = 'Latn'">
        <xslt:choose>
          <xslt:when test="$role = 'header'">
            <xslt:variable name="name">
              <xslt:call-template name="format2xsl.element.name">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:variable name="namespace">
              <xslt:call-template name="format2xsl.element.namespace">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:element name="{$name}" namespace="{$namespace}">
              <xslt:text>Primer </xslt:text>
              <xslt:call-template name="db.label.number">
                <xslt:with-param select="$node" name="node"/>
              </xslt:call-template>
              <xslt:text/>
            </xslt:element>
            <xslt:text> </xslt:text>
          </xslt:when>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Primer </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'pt' and $lang_region = 'BR'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Exemplo </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'zh' and $lang_region = 'CN'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>format.example label</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'bg'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Пример </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'cs'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Příklad </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'de'">
        <xslt:choose>
          <xslt:when test="$role = 'header'">
            <xslt:variable name="name">
              <xslt:call-template name="format2xsl.element.name">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:variable name="namespace">
              <xslt:call-template name="format2xsl.element.namespace">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:element name="{$name}" namespace="{$namespace}">
              <xslt:text>Beispiel </xslt:text>
              <xslt:call-template name="db.label.number">
                <xslt:with-param select="$node" name="node"/>
              </xslt:call-template>
              <xslt:text/>
            </xslt:element>
            <xslt:text> </xslt:text>
          </xslt:when>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Beispiel </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'es'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Ejemplo </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'et'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Näide </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'fi'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Esimerkki </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'hu'">
        <xslt:choose>
          <xslt:when test="$role = 'header'">
            <xslt:variable name="name">
              <xslt:call-template name="format2xsl.element.name">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:variable name="namespace">
              <xslt:call-template name="format2xsl.element.namespace">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:element name="{$name}" namespace="{$namespace}">
              <xslt:text/>
              <xslt:call-template name="db.label.number">
                <xslt:with-param select="$node" name="node"/>
              </xslt:call-template>
              <xslt:text>. Példa</xslt:text>
            </xslt:element>
          </xslt:when>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text>. Példa</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'id'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>bentuk.contoh.nama</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'lt'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text>-as pavyzdys</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'nb'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>format.eksempel.etikett</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'ne'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>ढाँचा.उदारण.लेबुल</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'no'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>format.eksempel.etikett</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'pt'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Exemplo </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'ro'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Exemplul </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'sk'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Príklad </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'sr'">
        <xslt:choose>
          <xslt:when test="$role = 'header'">
            <xslt:variable name="name">
              <xslt:call-template name="format2xsl.element.name">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:variable name="namespace">
              <xslt:call-template name="format2xsl.element.namespace">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:element name="{$name}" namespace="{$namespace}">
              <xslt:text>Пример </xslt:text>
              <xslt:call-template name="db.label.number">
                <xslt:with-param select="$node" name="node"/>
              </xslt:call-template>
              <xslt:text/>
            </xslt:element>
            <xslt:text> </xslt:text>
          </xslt:when>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Пример </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'sv'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>format.exempel.etikett</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'tr'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>format.örnek.etiket</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'vi'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Lời thí dụ </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:otherwise>
        <xslt:choose>
          <xslt:when test="$role = 'header'">
            <xslt:variable name="name">
              <xslt:call-template name="format2xsl.element.name">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:variable name="namespace">
              <xslt:call-template name="format2xsl.element.namespace">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:element name="{$name}" namespace="{$namespace}">
              <xslt:text>Example </xslt:text>
              <xslt:call-template name="db.label.number">
                <xslt:with-param select="$node" name="node"/>
              </xslt:call-template>
              <xslt:text/>
            </xslt:element>
            <xslt:text> </xslt:text>
          </xslt:when>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Example </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:otherwise>
    </xslt:choose>
  </xslt:template>
  <template xmlns="http://www.gnome.org/~shaunm/xsldoc">
    <name>format.figure.label</name>
    <purpose>
    Format the label for a <xmltag>figure</xmltag> element
  </purpose>
    <parameter>
      <name>lang</name>
      <purpose>
              The language to use for formatting
            </purpose>
    </parameter>
    <parameter>
      <name>node</name>
      <purpose>
      The <xmltag>figure</xmltag> element to format
    </purpose>
    </parameter>
    <parameter>
      <name>role</name>
      <purpose>
      The role of the label
    </purpose>
    </parameter>
    <section>
      <title>Arguments</title>
      <para>This is a format template constructed by
    <function role="xsl-template" moreinfo="refentry">format2xsl</function>.
    The following arguments are available for translators:</para>
      <variablelist>
        <varlistentry>
          <term>
            <parameter>number</parameter>
          </term>
          <listitem>
            <para>A template argument which extracts the number
        portion of the label.</para>
          </listitem>
        </varlistentry>
        <varlistentry>
          <term>
            <parameter>title</parameter>
          </term>
          <listitem>
            <para>A template argument which extracts the title
        of the element.</para>
          </listitem>
        </varlistentry>
      </variablelist>
    </section>
  </template>
  <xslt:template name="format.figure.label">
    <xslt:param select="." name="node"/>
    <xslt:param name="role"/>
    <xslt:param name="lang" select="$node/ancestor-or-self::*[@lang][1]/@lang"/>
    <xslt:variable name="lang_language">
      <xslt:call-template name="gettext.get.language">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_region">
      <xslt:call-template name="gettext.get.region">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_variant">
      <xslt:call-template name="gettext.get.variant">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:variable name="lang_charset">
      <xslt:call-template name="gettext.get.charset">
        <xslt:with-param name="lang" select="$lang"/>
      </xslt:call-template>
    </xslt:variable>
    <xslt:choose>
      <xslt:when test="$lang_language = 'sr' and $lang_variant = 'Latn'">
        <xslt:choose>
          <xslt:when test="$role = 'header'">
            <xslt:variable name="name">
              <xslt:call-template name="format2xsl.element.name">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:variable name="namespace">
              <xslt:call-template name="format2xsl.element.namespace">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:element name="{$name}" namespace="{$namespace}">
              <xslt:text>Slika </xslt:text>
              <xslt:call-template name="db.label.number">
                <xslt:with-param select="$node" name="node"/>
              </xslt:call-template>
              <xslt:text/>
            </xslt:element>
            <xslt:text> </xslt:text>
          </xslt:when>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Slika </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'pt' and $lang_region = 'BR'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Figura </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'zh' and $lang_region = 'CN'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>format.figure label</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'bg'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Фигура </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'cs'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Obrázek </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'de'">
        <xslt:choose>
          <xslt:when test="$role = 'header'">
            <xslt:variable name="name">
              <xslt:call-template name="format2xsl.element.name">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:variable name="namespace">
              <xslt:call-template name="format2xsl.element.namespace">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:element name="{$name}" namespace="{$namespace}">
              <xslt:text>Abbildung </xslt:text>
              <xslt:call-template name="db.label.number">
                <xslt:with-param select="$node" name="node"/>
              </xslt:call-template>
              <xslt:text/>
            </xslt:element>
            <xslt:text> </xslt:text>
          </xslt:when>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Abbildung </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'es'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Figura </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'et'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Joonis </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'fi'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Kuva </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'hu'">
        <xslt:choose>
          <xslt:when test="$role = 'header'">
            <xslt:variable name="name">
              <xslt:call-template name="format2xsl.element.name">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:variable name="namespace">
              <xslt:call-template name="format2xsl.element.namespace">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:element name="{$name}" namespace="{$namespace}">
              <xslt:text/>
              <xslt:call-template name="db.label.number">
                <xslt:with-param select="$node" name="node"/>
              </xslt:call-template>
              <xslt:text>. Kép</xslt:text>
            </xslt:element>
          </xslt:when>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text>. Kép</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'id'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>bentuk.gambar.nama</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'lt'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text/>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text>-as paveikslėlis</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'nb'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>format.figur.etikett</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'ne'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>ढाँचा.रेखाचित्र.लेबुल</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'no'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>format.figur.etikett</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'pt'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Imagem </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'ro'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Figura </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'sk'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Obrázok </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'sr'">
        <xslt:choose>
          <xslt:when test="$role = 'header'">
            <xslt:variable name="name">
              <xslt:call-template name="format2xsl.element.name">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:variable name="namespace">
              <xslt:call-template name="format2xsl.element.namespace">
                <xslt:with-param name="name" select="'i'"/>
                <xslt:with-param name="namespace" select="''"/>
              </xslt:call-template>
            </xslt:variable>
            <xslt:element name="{$name}" namespace="{$namespace}">
              <xslt:text>Слика </xslt:text>
              <xslt:call-template name="db.label.number">
                <xslt:with-param select="$node" name="node"/>
              </xslt:call-template>
              <xslt:text/>
            </xslt:element>
            <xslt:text> </xslt:text>
          </xslt:when>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Слика </xslt:text>
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
            <xslt:text/>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'sv'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>format.figur.etikett</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'tr'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>format.şekil.etiket</xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
      <xslt:when test="$lang_language = 'vi'">
        <xslt:choose>
          <xslt:when test="$role = 'title'">
            <xslt:call-template name="db.title">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:when test="$role = 'number'">
            <xslt:call-template name="db.label.number">
              <xslt:with-param select="$node" name="node"/>
            </xslt:call-template>
          </xslt:when>
          <xslt:otherwise>
            <xslt:text>Hình </xslt:text>
          </xslt:otherwise>
        </xslt:choose>
      </xslt:when>
    </xslt:choose>
  </xslt:template>
</xslt:stylesheet>
