/* GNOME-DB Components
 * Copyrigth (C) 2000-2001 The Free Software Foundation
 *
 * AUTHORS:
 *	Rodrigo Moya <rodrigo@gnome-db.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <libgda/gda-config.h>
#include <libgnomedb/gnome-db-grid.h>
#include <bonobo/bonobo-i18n.h>
#include <gtk/gtknotebook.h>
#include "components-manager-view.h"

#define PARENT_TYPE GTK_TYPE_VBOX

struct _ComponentsManagerViewPrivate {
	GtkWidget *notebook;

	/* 'Data Sources' tab */
	GtkWidget *dsn_tab;
	GtkWidget *dsn_list;
};

static void components_manager_view_class_init (ComponentsManagerViewClass *klass);
static void components_manager_view_init       (ComponentsManagerView *manager,
						ComponentsManagerViewClass *klass);
static void components_manager_view_finalize   (GObject *object);

static GObjectClass *parent_class = NULL;

/*
 * Private functions
 */

static void
show_data_sources (ComponentsManagerView *view)
{
	GdaDataModel *model;

	g_return_if_fail (COMPONENTS_IS_MANAGER_VIEW (view));

	model = gda_config_get_data_source_model ();
	gnome_db_grid_set_model (GNOME_DB_GRID (view->priv->dsn_list), model);

	g_object_unref (G_OBJECT (model));
}

/*
 * ComponentsManagerView class implementation
 */

static void
components_manager_view_class_init (ComponentsManagerViewClass *klass)
{
	GObjectClass *object_class = G_OBJECT_CLASS (klass);

	parent_class = g_type_class_peek_parent (klass);

	object_class->finalize = components_manager_view_finalize;
}

static void
components_manager_view_init (ComponentsManagerView *view, ComponentsManagerViewClass *klass)
{
	g_return_if_fail (COMPONENTS_IS_MANAGER_VIEW (view));

	/* allocate private structure */
	view->priv = g_new0 (ComponentsManagerViewPrivate, 1);

	/* setup widgets */
	view->priv->notebook = gnome_db_new_notebook_widget ();
	gtk_box_pack_start (GTK_BOX (view), view->priv->notebook, TRUE, TRUE, 0);

	/* dsn tab */
	view->priv->dsn_tab = gnome_db_new_hbox_widget ();
	gtk_notebook_append_page (GTK_NOTEBOOK (view->priv->notebook),
				  view->priv->dsn_tab, gtk_label_new (_("Data Sources")));

	view->priv->dsn_list = gnome_db_grid_new ();
	gtk_widget_show (view->priv->dsn_list);
	show_data_sources (view);
	gtk_box_pack_start (GTK_BOX (view->priv->dsn_tab), view->priv->dsn_list, TRUE, TRUE, 0);
}

static void
components_manager_view_finalize (GObject *object)
{
	ComponentsManagerView *view = (ComponentsManagerView *) object;

	g_return_if_fail (COMPONENTS_IS_MANAGER_VIEW (view));

	/* free memory */
	g_free (view->priv);
	view->priv = NULL;

	parent_class->finalize (object);
}

GType
components_manager_view_get_type (void)
{
	static GType type = 0;

	if (!type) {
		static const GTypeInfo info = {
			sizeof (ComponentsManagerViewClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) components_manager_view_class_init,
			NULL,
			NULL,
			sizeof (ComponentsManagerView),
			0,
			(GInstanceInitFunc) components_manager_view_init
		};
		type = g_type_register_static (GTK_TYPE_VBOX, "ComponentsManagerView", &info, 0);
	}

	return type;
}

GtkWidget *
components_manager_view_new (void)
{
	ComponentsManagerView *view;

	view = g_object_new (COMPONENTS_TYPE_MANAGER_VIEW, NULL);
	return GTK_WIDGET (view);
}
