/* GNOME DB library
 * Copyright (C) 1999-2000 Rodrigo Moya
 *
 * This Library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This Library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this Library; see the file COPYING.LIB.  If not,
 * write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "gnome-db.h"
#include <libgnome/gnome-i18n.h>

/**
 * gnome_db_init
 * @app_id: application name
 * @version: application version
 * @nargs: number of arguments
 * @args: arguments
 *
 * Initialize the GNOME-DB environment for client UI applications. This includes
 * everything your application needs about GTK/GNOME/Bonobo, so you must avoid calling
 * any of gtk_init, gnome_init*, or bonobo_init when using this function.
 */
void
gnome_db_init (const gchar *app_id, const gchar *version, int nargs, char *args[])
{
	CORBA_Environment ev;
	
	gnome_init_with_popt_table(app_id, version, nargs, args, oaf_popt_options, 0, NULL);
	oaf_init(nargs, args);
	
	/* initialize Bonobo */
	if (bonobo_init(gda_corba_get_orb(), NULL, NULL) == FALSE)
		g_error(_("Could not initialize Bonobo\n"));
		
	bonobo_activate();
}

/**
 * gnome_db_main
 * @ui_create_func: function to be called for creating the initial GUI
 *
 * This function runs the GNOME-DB application making the call, thus entering
 * in the event loop needed for GNOME-DB applications to interact with users.
 * You can pass a pointer to a function to be called for creating the initial
 * UI of your application. That function should have the form:
 *
 *	guint ui_create_func (void)
 *
 * it should return 0 if all went ok, and any other value if there was any error.
 * This is very important: if you return a non-zero value, the function will be
 * called repeatedly until you do so.
 */
void
gnome_db_main (GtkFunction ui_create_func)
{
	if (ui_create_func) {
		/*
		 * We can't make any CORBA calls unless we're in the main
		 * loop. So we delay creating the container here.
		 */
		gtk_idle_add((GtkFunction) ui_create_func, NULL);
	}
	bonobo_main();
}
 
