/*  GNOME-DB Components
 *  Copyrigth (C) 2000 Rodrigo Moya
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gnomedb-com.h>

static void new_table_cb        (BonoboUIComponent *uic, GnomeDbControl *control, const gchar *path);
static void open_database_cb    (BonoboUIComponent *uic, GnomeDbControl *control, const gchar *path);
static void refresh_database_cb (BonoboUIComponent *uic, GnomeDbControl *control, const gchar *path);
static void save_database_cb    (BonoboUIComponent *uic, GnomeDbControl *control, const gchar *path);
	
/* UI verbs */
BonoboUIVerb designer_verbs [] = {
	BONOBO_UI_VERB ("DesignerNew", NULL),
	BONOBO_UI_VERB ("DesignerNewTable", new_table_cb),
	BONOBO_UI_VERB ("DesignerOpen", open_database_cb),
	BONOBO_UI_VERB ("DesignerSave", save_database_cb),
	BONOBO_UI_VERB ("DesignerRefresh", refresh_database_cb),
	BONOBO_UI_VERB_END
};

/*
 * Callbacks
 */

static void
new_table_cb (BonoboUIComponent *uic, GnomeDbControl *control, const gchar *path)
{
	GtkWidget *designer;
	GtkWidget *dialog;
	GtkWidget *label;
	GtkWidget *entry;

	g_return_if_fail(GNOME_DB_IS_CONTROL(control));

	designer = gnome_db_control_get_widget (control);
	if (!GNOME_DB_IS_DESIGNER (designer))
		return;

	/* create the dialog */
	dialog = gnome_dialog_new (_("Add new table"),
				   GNOME_STOCK_BUTTON_OK,
				   GNOME_STOCK_BUTTON_CANCEL,
				   NULL);
	gnome_dialog_set_default (GNOME_DIALOG (dialog), 0);
	label = gnome_db_new_label_widget (_("Enter the name of the table to add"));
	gtk_box_pack_start (GTK_BOX (GNOME_DIALOG (dialog)->vbox), label, 0, 0, 0);
	entry = gnome_db_new_entry_widget (0, TRUE);
	gtk_box_pack_start (GTK_BOX (GNOME_DIALOG (dialog)->vbox), entry, 0, 0, 0);

	if (!gnome_dialog_run (GNOME_DIALOG (dialog))) {
		GdaXmlDatabase *xmldb;
		gchar *tname;

		tname = gtk_entry_get_text (GTK_ENTRY (entry));
		xmldb = gnome_db_designer_get_database (designer);
		if (GDA_IS_XML_DATABASE (xmldb))
			gda_xml_database_table_new (xmldb, tname);
	}
	gnome_dialog_close (GNOME_DIALOG (dialog));
}

static void
open_database_cb (BonoboUIComponent *uic, GnomeDbControl *control, const gchar *path)
{
	gchar* filename;
	
	g_return_if_fail(GNOME_DB_IS_CONTROL(control));

	filename = gnome_db_select_file(_("Select database design"));
	if (filename) {
		GtkWidget* designer;
		
		designer = gnome_db_control_get_widget(control);
		if (GNOME_DB_IS_DESIGNER(designer))
			gnome_db_designer_load_file(GNOME_DB_DESIGNER(designer), filename);
		g_free((gpointer) filename);
	}
}

static void
refresh_database_cb (BonoboUIComponent *uic, GnomeDbControl *control, const gchar *path)
{
	GtkWidget* designer;
	
	g_return_if_fail(GNOME_DB_IS_CONTROL(control));
	
	designer = gnome_db_control_get_widget(control);
	if (GNOME_DB_IS_DESIGNER(designer))
		gnome_db_designer_refresh(GNOME_DB_DESIGNER(designer));
}

static void
save_database_cb (BonoboUIComponent *uic, GnomeDbControl *control, const gchar *path)
{
	GtkWidget *designer;

	g_return_if_fail(GNOME_DB_IS_CONTROL(control));

	designer = gnome_db_control_get_widget(control);
	if (GNOME_DB_IS_DESIGNER(designer))
		gnome_db_designer_save(GNOME_DB_DESIGNER(designer));
}

/*
 * Public functions
 */
BonoboObject *
components_designer_new (void)
{
	GtkWidget*      designer;
	GnomeDbControl* control;

	designer = gnome_db_designer_new();
	gtk_widget_show_all(designer);
	
	/* create the control instance */
	control = gnome_db_control_new(designer);
	if (GNOME_DB_IS_CONTROL(control)) {
		gnome_db_control_set_ui (control,
					 GNOMEDB_DATADIR,
					 "gnomedb-com-designer.xml",
					 designer_verbs,
					 control);
	}
	return BONOBO_OBJECT(control);
}

