/* Glom
 *
 * Copyright (C) 2001-2004 Murray Cumming
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef GLOM_DIALOG_NEWDATABASE_H
#define GLOM_DIALOG_NEWDATABASE_H

#include <libglademm.h>
#include <gtkmm/dialog.h>
#include <gtkmm/entry.h>

namespace Glom
{

/** Show the dialog, with the specified title.
 * @param title The initial title. This will also be filled with the actual entered title.
 * @param self_hosted This will be true if the user chose to self-host the database.
 * @result This will be false if the user cancelled the dialog.
 */
bool show_dialog_new_database(Gtk::Window* parent_window, Glib::ustring& title, bool& self_hosted);

class Dialog_NewDatabase : public Gtk::Dialog
{
public:
  Dialog_NewDatabase(BaseObjectType* cobject, const Glib::RefPtr<Gnome::Glade::Xml>& refGlade);
  virtual ~Dialog_NewDatabase();

  ///Set sensible defaults:
  virtual void set_input(const Glib::ustring& title);

  ///Get the user input:
  virtual void get_input(Glib::ustring& title, bool& self_hosted);

protected:
  virtual void on_entry_title_changed();

  Gtk::Entry* m_entry_title;
  Gtk::RadioButton* m_radiobutton_server_selfhosted;
  Gtk::Button* m_button_ok;
};

} //namespace Glom

#endif //GLOM_DIALOG_NEWDATABASE_H

