/* Glom
 *
 * Copyright (C) 2001-2004 Murray Cumming
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "alignment_justified.h"

Alignment_Justified::Alignment_Justified()
{
  set_border_width(2); //Useful default.
}

Alignment_Justified::~Alignment_Justified()
{
}

void Alignment_Justified::set_justification(Gtk::Justification justification)
{
  switch(justification)
  {
    case(Gtk::JUSTIFY_LEFT):
    {
      set(Gtk::JUSTIFY_LEFT, Gtk::JUSTIFY_CENTER, 0.0);
      break;
    }
    case(Gtk::JUSTIFY_RIGHT):
    {
      set(Gtk::JUSTIFY_RIGHT, Gtk::JUSTIFY_CENTER, 0.0);
      break;
    }
    case(Gtk::JUSTIFY_CENTER):
    {
      set();
      break;
    }
    default:
    {
      break;
    }
  }
}
