<?xml version='1.0' encoding='ISO-8859-1' standalone='yes' ?>
<tagfile>
  <compound kind="group">
    <name>CharsetConv</name>
    <title>Character Set Conversion</title>
    <filename>group__CharsetConv.html</filename>
    <class kind="class">Glib::ConvertError</class>
    <class kind="class">Glib::IConv</class>
    <member kind="function">
      <type>bool</type>
      <name>get_charset</name>
      <anchorfile>group__CharsetConv.html</anchorfile>
      <anchor>gabf5fac564c47a7a9ad6037044c3909f4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_charset</name>
      <anchorfile>group__CharsetConv.html</anchorfile>
      <anchor>ga88965337df48a173a6b013e8243e4631</anchor>
      <arglist>(std::string &amp;charset)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>convert</name>
      <anchorfile>group__CharsetConv.html</anchorfile>
      <anchor>ga58f7e4556c436a96c64b186bbc8f7f4c</anchor>
      <arglist>(const std::string &amp;str, const std::string &amp;to_codeset, const std::string &amp;from_codeset)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>convert_with_fallback</name>
      <anchorfile>group__CharsetConv.html</anchorfile>
      <anchor>ga40b5aa172fabd1f3dbf50a962d0d351f</anchor>
      <arglist>(const std::string &amp;str, const std::string &amp;to_codeset, const std::string &amp;from_codeset)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>convert_with_fallback</name>
      <anchorfile>group__CharsetConv.html</anchorfile>
      <anchor>gaf1b091e4397a7637e884148484b1f71e</anchor>
      <arglist>(const std::string &amp;str, const std::string &amp;to_codeset, const std::string &amp;from_codeset, const Glib::ustring &amp;fallback)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>locale_to_utf8</name>
      <anchorfile>group__CharsetConv.html</anchorfile>
      <anchor>ga4517b17f2aad4cd5c0e0640de212d928</anchor>
      <arglist>(const std::string &amp;opsys_string)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>locale_from_utf8</name>
      <anchorfile>group__CharsetConv.html</anchorfile>
      <anchor>gacc062729285890a7e9b22bece6fb987c</anchor>
      <arglist>(const Glib::ustring &amp;utf8_string)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>filename_to_utf8</name>
      <anchorfile>group__CharsetConv.html</anchorfile>
      <anchor>ga6cf95dc00505401594260a360d70c17b</anchor>
      <arglist>(const std::string &amp;opsys_string)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>filename_from_utf8</name>
      <anchorfile>group__CharsetConv.html</anchorfile>
      <anchor>ga2bd94064ad97b43324a7854b62f0835b</anchor>
      <arglist>(const Glib::ustring &amp;utf8_string)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>filename_from_uri</name>
      <anchorfile>group__CharsetConv.html</anchorfile>
      <anchor>gada23cd7f7dc8eb25e99b867a55551763</anchor>
      <arglist>(const Glib::ustring &amp;uri, Glib::ustring &amp;hostname)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>filename_from_uri</name>
      <anchorfile>group__CharsetConv.html</anchorfile>
      <anchor>gab1cb94f4a4a70bad06b715fb14a252d9</anchor>
      <arglist>(const Glib::ustring &amp;uri)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>filename_to_uri</name>
      <anchorfile>group__CharsetConv.html</anchorfile>
      <anchor>gae1b2f056bde3fbab578c602fe42e3de9</anchor>
      <arglist>(const std::string &amp;filename, const Glib::ustring &amp;hostname)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>filename_to_uri</name>
      <anchorfile>group__CharsetConv.html</anchorfile>
      <anchor>gaaf69aec83665229cc06596cf627d9d5a</anchor>
      <arglist>(const std::string &amp;filename)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>filename_display_basename</name>
      <anchorfile>group__CharsetConv.html</anchorfile>
      <anchor>ga05dd67157ad35da4401263247b6f4d81</anchor>
      <arglist>(const std::string &amp;filename)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>filename_display_name</name>
      <anchorfile>group__CharsetConv.html</anchorfile>
      <anchor>gabc1b404cc965f3da6beecddfe2623afc</anchor>
      <arglist>(const std::string &amp;filename)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>FileUtils</name>
    <title>File Utilities</title>
    <filename>group__FileUtils.html</filename>
    <class kind="class">Glib::FileError</class>
    <class kind="class">Glib::DirIterator</class>
    <class kind="class">Glib::Dir</class>
    <member kind="function">
      <type>bool</type>
      <name>file_test</name>
      <anchorfile>group__FileUtils.html</anchorfile>
      <anchor>ga0b2fce78896a9a84f7ea3a5646cc7d36</anchor>
      <arglist>(const std::string &amp;filename, FileTest test)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>mkstemp</name>
      <anchorfile>group__FileUtils.html</anchorfile>
      <anchor>gae4c8d716bd109b6b8e1420a8c20b3507</anchor>
      <arglist>(std::string &amp;filename_template)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>file_open_tmp</name>
      <anchorfile>group__FileUtils.html</anchorfile>
      <anchor>gae91f239f1cf0123399374deed54fbf3a</anchor>
      <arglist>(std::string &amp;name_used, const std::string &amp;prefix)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>file_open_tmp</name>
      <anchorfile>group__FileUtils.html</anchorfile>
      <anchor>ga682379de4ea119540b4bdc1759e93e1d</anchor>
      <arglist>(std::string &amp;name_used)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>file_get_contents</name>
      <anchorfile>group__FileUtils.html</anchorfile>
      <anchor>ga835da54212fe78e833ac55b49150b989</anchor>
      <arglist>(const std::string &amp;filename)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>Markup</name>
    <title>Simple XML Subset Parser</title>
    <filename>group__Markup.html</filename>
    <class kind="class">Glib::MarkupError</class>
    <class kind="class">Glib::Markup::AttributeKeyLess</class>
    <class kind="class">Glib::Markup::Parser</class>
    <class kind="class">Glib::Markup::ParseContext</class>
    <member kind="typedef">
      <type>Glib::MarkupError</type>
      <name>Error</name>
      <anchorfile>group__Markup.html</anchorfile>
      <anchor>ga7d0403c76601e7d3ba4641737e094e77</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>escape_text</name>
      <anchorfile>group__Markup.html</anchorfile>
      <anchor>gac95c5843d8dada8449f90f2fd635feb1</anchor>
      <arglist>(const Glib::ustring &amp;text)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>ShellUtils</name>
    <title>Shell-related Utilities</title>
    <filename>group__ShellUtils.html</filename>
    <class kind="class">Glib::ShellError</class>
    <member kind="function">
      <type>Glib::ArrayHandle&lt; std::string &gt;</type>
      <name>shell_parse_argv</name>
      <anchorfile>group__ShellUtils.html</anchorfile>
      <anchor>gabc52fcb14cfc7a5ba37ca821cc837818</anchor>
      <arglist>(const std::string &amp;command_line)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>shell_quote</name>
      <anchorfile>group__ShellUtils.html</anchorfile>
      <anchor>ga55ebfb935f2131b2ae40d339568f568c</anchor>
      <arglist>(const std::string &amp;unquoted_string)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>shell_unquote</name>
      <anchorfile>group__ShellUtils.html</anchorfile>
      <anchor>ga449dc37c6ea7e7563740df86e31c263c</anchor>
      <arglist>(const std::string &amp;quoted_string)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>Spawn</name>
    <title>Spawning Processes</title>
    <filename>group__Spawn.html</filename>
    <class kind="class">Glib::SpawnError</class>
    <member kind="function">
      <type>void</type>
      <name>spawn_async_with_pipes</name>
      <anchorfile>group__Spawn.html</anchorfile>
      <anchor>ga0a530eed9f6343ea1d51cb8ec8051ce7</anchor>
      <arglist>(const std::string &amp;working_directory, const Glib::ArrayHandle&lt; std::string &gt; &amp;argv, const Glib::ArrayHandle&lt; std::string &gt; &amp;envp, SpawnFlags flags=SpawnFlags(0), const sigc::slot&lt; void &gt; &amp;child_setup=sigc::slot&lt; void &gt;(), Pid *child_pid=0, int *standard_input=0, int *standard_output=0, int *standard_error=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>spawn_async_with_pipes</name>
      <anchorfile>group__Spawn.html</anchorfile>
      <anchor>ga36b7c1d110d10f86f3ef5d6e10db206f</anchor>
      <arglist>(const std::string &amp;working_directory, const Glib::ArrayHandle&lt; std::string &gt; &amp;argv, SpawnFlags flags=SpawnFlags(0), const sigc::slot&lt; void &gt; &amp;child_setup=sigc::slot&lt; void &gt;(), Pid *child_pid=0, int *standard_input=0, int *standard_output=0, int *standard_error=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>spawn_async</name>
      <anchorfile>group__Spawn.html</anchorfile>
      <anchor>ga5d42ba801678215f3820382388df32b0</anchor>
      <arglist>(const std::string &amp;working_directory, const Glib::ArrayHandle&lt; std::string &gt; &amp;argv, const Glib::ArrayHandle&lt; std::string &gt; &amp;envp, SpawnFlags flags=SpawnFlags(0), const sigc::slot&lt; void &gt; &amp;child_setup=sigc::slot&lt; void &gt;(), Pid *child_pid=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>spawn_async</name>
      <anchorfile>group__Spawn.html</anchorfile>
      <anchor>ga0c4e1708989b50fb34266504cc038ee6</anchor>
      <arglist>(const std::string &amp;working_directory, const Glib::ArrayHandle&lt; std::string &gt; &amp;argv, SpawnFlags flags=SpawnFlags(0), const sigc::slot&lt; void &gt; &amp;child_setup=sigc::slot&lt; void &gt;(), Pid *child_pid=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>spawn_sync</name>
      <anchorfile>group__Spawn.html</anchorfile>
      <anchor>gad4fbf31fdb5536b104f4f75bf58c60e1</anchor>
      <arglist>(const std::string &amp;working_directory, const Glib::ArrayHandle&lt; std::string &gt; &amp;argv, const Glib::ArrayHandle&lt; std::string &gt; &amp;envp, SpawnFlags flags=SpawnFlags(0), const sigc::slot&lt; void &gt; &amp;child_setup=sigc::slot&lt; void &gt;(), std::string *standard_output=0, std::string *standard_error=0, int *exit_status=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>spawn_sync</name>
      <anchorfile>group__Spawn.html</anchorfile>
      <anchor>gacc157258907be90b58184baeebc9c740</anchor>
      <arglist>(const std::string &amp;working_directory, const Glib::ArrayHandle&lt; std::string &gt; &amp;argv, SpawnFlags flags=SpawnFlags(0), const sigc::slot&lt; void &gt; &amp;child_setup=sigc::slot&lt; void &gt;(), std::string *standard_output=0, std::string *standard_error=0, int *exit_status=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>spawn_command_line_async</name>
      <anchorfile>group__Spawn.html</anchorfile>
      <anchor>ga648167a4af607f87763f1334fe5a472f</anchor>
      <arglist>(const std::string &amp;command_line)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>spawn_command_line_sync</name>
      <anchorfile>group__Spawn.html</anchorfile>
      <anchor>ga713bdb79396eda85ad186cb2db89564f</anchor>
      <arglist>(const std::string &amp;command_line, std::string *standard_output=0, std::string *standard_error=0, int *exit_status=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>spawn_close_pid</name>
      <anchorfile>group__Spawn.html</anchorfile>
      <anchor>gaaea8f41c7a08af3b2919ce64fd0c27e5</anchor>
      <arglist>(Pid pid)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>Threads</name>
    <title>Threads</title>
    <filename>group__Threads.html</filename>
    <class kind="class">Glib::ThreadError</class>
    <class kind="class">Glib::Thread</class>
    <class kind="class">Glib::Thread::Exit</class>
    <class kind="struct">Glib::StaticMutex</class>
    <class kind="class">Glib::Mutex</class>
    <class kind="class">Glib::Mutex::Lock</class>
    <class kind="struct">Glib::StaticRecMutex</class>
    <class kind="class">Glib::RecMutex</class>
    <class kind="class">Glib::RecMutex::Lock</class>
    <class kind="struct">Glib::StaticRWLock</class>
    <class kind="class">Glib::RWLock</class>
    <class kind="class">Glib::RWLock::ReaderLock</class>
    <class kind="class">Glib::RWLock::WriterLock</class>
    <class kind="class">Glib::Cond</class>
    <class kind="struct">Glib::StaticPrivate</class>
    <class kind="class">Glib::Private</class>
    <class kind="class">Glib::Dispatcher</class>
    <member kind="enumeration">
      <name>NotLock</name>
      <anchorfile>group__Threads.html</anchorfile>
      <anchor>ga2dd111336e3b057b51ca5871795fffa4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NOT_LOCK</name>
      <anchorfile>group__Threads.html</anchorfile>
      <anchor>gga2dd111336e3b057b51ca5871795fffa4a9681fb4e85e62ba64e39a12526eaa840</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>TryLock</name>
      <anchorfile>group__Threads.html</anchorfile>
      <anchor>ga7441a36336ea4cdb35c0fddbf3f97b19</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TRY_LOCK</name>
      <anchorfile>group__Threads.html</anchorfile>
      <anchor>gga7441a36336ea4cdb35c0fddbf3f97b19adf6b2565785992ff637cbc453988841d</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>thread_init</name>
      <anchorfile>group__Threads.html</anchorfile>
      <anchor>gab26d01c776801f1fff00753e97af4fc7</anchor>
      <arglist>(GThreadFunctions *vtable=0)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>thread_supported</name>
      <anchorfile>group__Threads.html</anchorfile>
      <anchor>gad59d126f6197035e6f6a31e7f4d87818</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Thread *</type>
      <name>wrap</name>
      <anchorfile>group__Threads.html</anchorfile>
      <anchor>ga6bfbb3119eaac9fa8cb725aa1e82f61e</anchor>
      <arglist>(GThread *gobject)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>Unicode</name>
    <title>Unicode Manipulation</title>
    <filename>group__Unicode.html</filename>
    <namespace>Glib::Unicode</namespace>
    <namespace>Glib::Ascii</namespace>
  </compound>
  <compound kind="group">
    <name>UriUtils</name>
    <title>URI Utilities</title>
    <filename>group__UriUtils.html</filename>
    <member kind="function">
      <type>std::string</type>
      <name>uri_unescape_string</name>
      <anchorfile>group__UriUtils.html</anchorfile>
      <anchor>ga0c070cac984dc463fd60ccbdb4237e25</anchor>
      <arglist>(const std::string &amp;escaped_string, const std::string &amp;illegal_characters=std::string())</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>uri_parse_scheme</name>
      <anchorfile>group__UriUtils.html</anchorfile>
      <anchor>ga0cc4270d6796b2166964f08a5cb746b3</anchor>
      <arglist>(const std::string &amp;uri)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>uri_escape_string</name>
      <anchorfile>group__UriUtils.html</anchorfile>
      <anchor>gad902095ab5049111caa9207770b0a437</anchor>
      <arglist>(const std::string &amp;unescaped, const std::string &amp;reserved_chars_allowed=std::string(), bool allow_utf8=true)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>ContHandles</name>
    <title>Generic container converters</title>
    <filename>group__ContHandles.html</filename>
    <class kind="class">Glib::ArrayHandle</class>
    <class kind="class">Glib::Sequence</class>
    <class kind="class">Glib::ListHandle</class>
    <class kind="class">Glib::SListHandle</class>
    <subgroup>ContHelpers</subgroup>
    <member kind="typedef">
      <type>ArrayHandle&lt; Glib::ustring &gt;</type>
      <name>StringArrayHandle</name>
      <anchorfile>group__ContHandles.html</anchorfile>
      <anchor>ga8e243b697be740f5f7d4b578ae50db41</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>OwnershipType</name>
      <anchorfile>group__ContHandles.html</anchorfile>
      <anchor>ga64c27560b41710ccf64a3679a3ba3f20</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>OWNERSHIP_NONE</name>
      <anchorfile>group__ContHandles.html</anchorfile>
      <anchor>gga64c27560b41710ccf64a3679a3ba3f20a7d594cffcc2d2d6c4313ddb4d6613c79</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>OWNERSHIP_SHALLOW</name>
      <anchorfile>group__ContHandles.html</anchorfile>
      <anchor>gga64c27560b41710ccf64a3679a3ba3f20a448c598cdc37e2de8a162e1020001715</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>OWNERSHIP_DEEP</name>
      <anchorfile>group__ContHandles.html</anchorfile>
      <anchor>gga64c27560b41710ccf64a3679a3ba3f20a2a6d6bfadc36f9eda31af79d32928c6a</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>Sequence&lt; Iterator &gt;</type>
      <name>sequence</name>
      <anchorfile>group__ContHandles.html</anchorfile>
      <anchor>ga33e5a3a70ef5f7bed112046726ff8b04</anchor>
      <arglist>(Iterator pbegin, Iterator pend)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>ContHelpers</name>
    <title>Helper classes</title>
    <filename>group__ContHelpers.html</filename>
    <class kind="class">Glib::Container_Helpers::ArrayHandleIterator</class>
    <class kind="struct">Glib::Container_Helpers::TypeTraits</class>
    <class kind="class">Glib::Container_Helpers::ListHandleIterator</class>
    <class kind="class">Glib::Container_Helpers::SListHandleIterator</class>
  </compound>
  <compound kind="group">
    <name>MainLoop</name>
    <title>The Main Event Loop</title>
    <filename>group__MainLoop.html</filename>
    <class kind="class">Glib::PollFD</class>
    <class kind="class">Glib::SignalTimeout</class>
    <class kind="class">Glib::SignalIdle</class>
    <class kind="class">Glib::SignalIO</class>
    <class kind="class">Glib::SignalChildWatch</class>
    <class kind="class">Glib::MainContext</class>
    <class kind="class">Glib::MainLoop</class>
    <class kind="class">Glib::Source</class>
    <class kind="class">Glib::TimeoutSource</class>
    <class kind="class">Glib::IdleSource</class>
    <class kind="class">Glib::IOSource</class>
    <member kind="enumeration">
      <name>IOCondition</name>
      <anchorfile>group__MainLoop.html</anchorfile>
      <anchor>gabd96381793b70d4ae32c725926990918</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_IN</name>
      <anchorfile>group__MainLoop.html</anchorfile>
      <anchor>ggabd96381793b70d4ae32c725926990918af244f3e8c1c9525762f3630befd76336</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_OUT</name>
      <anchorfile>group__MainLoop.html</anchorfile>
      <anchor>ggabd96381793b70d4ae32c725926990918a60f61c8f26f2bb61afd3ad8afd673099</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_PRI</name>
      <anchorfile>group__MainLoop.html</anchorfile>
      <anchor>ggabd96381793b70d4ae32c725926990918a36bb5411dda1131e5c23e17a8619c820</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERR</name>
      <anchorfile>group__MainLoop.html</anchorfile>
      <anchor>ggabd96381793b70d4ae32c725926990918a2e402c9fd5879c49ef5359fa4189acd3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_HUP</name>
      <anchorfile>group__MainLoop.html</anchorfile>
      <anchor>ggabd96381793b70d4ae32c725926990918ab5dcc0e24c236c027b041d362dcff35b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_NVAL</name>
      <anchorfile>group__MainLoop.html</anchorfile>
      <anchor>ggabd96381793b70d4ae32c725926990918ad37b5d6ba6a0c1ad98510f352ac2f885</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>IOCondition</type>
      <name>operator|</name>
      <anchorfile>group__MainLoop.html</anchorfile>
      <anchor>gab5937e9164f36f75ba87fd67903348d5</anchor>
      <arglist>(IOCondition lhs, IOCondition rhs)</arglist>
    </member>
    <member kind="function">
      <type>IOCondition</type>
      <name>operator&amp;</name>
      <anchorfile>group__MainLoop.html</anchorfile>
      <anchor>ga12928ddba0f38406f19d55547bac552b</anchor>
      <arglist>(IOCondition lhs, IOCondition rhs)</arglist>
    </member>
    <member kind="function">
      <type>IOCondition</type>
      <name>operator^</name>
      <anchorfile>group__MainLoop.html</anchorfile>
      <anchor>ga6416bbf923045261beb85241fff8ef0d</anchor>
      <arglist>(IOCondition lhs, IOCondition rhs)</arglist>
    </member>
    <member kind="function">
      <type>IOCondition</type>
      <name>operator~</name>
      <anchorfile>group__MainLoop.html</anchorfile>
      <anchor>ga85461947d24f306cefd2fe17999deb97</anchor>
      <arglist>(IOCondition flags)</arglist>
    </member>
    <member kind="function">
      <type>IOCondition &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__MainLoop.html</anchorfile>
      <anchor>ga8269a01826f8737d98ab0d345a0004f4</anchor>
      <arglist>(IOCondition &amp;lhs, IOCondition rhs)</arglist>
    </member>
    <member kind="function">
      <type>IOCondition &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__MainLoop.html</anchorfile>
      <anchor>ga11f46ad6051058eeeb34d5963a4f7c44</anchor>
      <arglist>(IOCondition &amp;lhs, IOCondition rhs)</arglist>
    </member>
    <member kind="function">
      <type>IOCondition &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__MainLoop.html</anchorfile>
      <anchor>ga995d6d5d01db67af62661bcd5dfd1ad6</anchor>
      <arglist>(IOCondition &amp;lhs, IOCondition rhs)</arglist>
    </member>
    <member kind="function">
      <type>SignalTimeout</type>
      <name>signal_timeout</name>
      <anchorfile>group__MainLoop.html</anchorfile>
      <anchor>gaadb206fcc112f086f9d47c016b1f2175</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>SignalIdle</type>
      <name>signal_idle</name>
      <anchorfile>group__MainLoop.html</anchorfile>
      <anchor>ga76792522d9680a05e232d3519a25f98d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>SignalIO</type>
      <name>signal_io</name>
      <anchorfile>group__MainLoop.html</anchorfile>
      <anchor>gaf391654b755a32169d18be4835677376</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>SignalChildWatch</type>
      <name>signal_child_watch</name>
      <anchorfile>group__MainLoop.html</anchorfile>
      <anchor>ga11ee7db80cc44ece02056a38bb049e3b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; MainContext &gt;</type>
      <name>wrap</name>
      <anchorfile>group__MainLoop.html</anchorfile>
      <anchor>ga043c5714afbad2745b27301dd58470a4</anchor>
      <arglist>(GMainContext *gobject, bool take_copy=false)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; MainLoop &gt;</type>
      <name>wrap</name>
      <anchorfile>group__MainLoop.html</anchorfile>
      <anchor>ga22ea72cda4ef327ca03fb72d6a3bea89</anchor>
      <arglist>(GMainLoop *gobject, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>MiscUtils</name>
    <title>Miscellaneous Utility Functions</title>
    <filename>group__MiscUtils.html</filename>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_application_name</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga9c2f67828083d74925b23c59ab868698</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_application_name</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga40e45835b7b461cba0f7a10fbb63c0d3</anchor>
      <arglist>(const Glib::ustring &amp;application_name)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_prgname</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga391655dededb496010eee2e92d0f1fdf</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_prgname</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga7d5c429822c09048892c4dee9c8e08c1</anchor>
      <arglist>(const std::string &amp;prgname)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>getenv</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga5e186fdb08835342a5866b11fe787ebb</anchor>
      <arglist>(const std::string &amp;variable, bool &amp;found)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>getenv</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga8e2c8f250aa7f059956737851ace08f6</anchor>
      <arglist>(const std::string &amp;variable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>setenv</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga862657f21e5a930541d048a920204f59</anchor>
      <arglist>(const std::string &amp;variable, const std::string &amp;value, bool overwrite=true)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unsetenv</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga6fb89001630714ec9ee5244cab56343e</anchor>
      <arglist>(const std::string &amp;variable)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_user_name</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga52964bfd712e8c9e688f668da51f3ed9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_real_name</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga30692e3263e66868878f535e0b7c9722</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_home_dir</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga9412ea70c7fea058c03211dac318f8e6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_tmp_dir</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>gac42272146fd9320958132f1591d28991</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_current_dir</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga06d93c95572d6a382b8cc4e09dd5a339</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_user_special_dir</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>gabc928a4e477df53f90e221a854cc73cb</anchor>
      <arglist>(GUserDirectory directory)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_user_data_dir</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga821b704b5ede1583e4057990976d394b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_user_config_dir</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>gae517b931f4753abcd48adb2769a8fc48</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_user_cache_dir</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>gaa68121f26e82df1c293c82b89c8998e5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>path_is_absolute</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>gad82525f39f7408f97f2c096c4f721b3b</anchor>
      <arglist>(const std::string &amp;filename)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>path_skip_root</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga306eee64abc3d28993895b826f4dd533</anchor>
      <arglist>(const std::string &amp;filename)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>path_get_basename</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga20ebf2917a7fce5d1901568017b95a35</anchor>
      <arglist>(const std::string &amp;filename)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>path_get_dirname</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>gae03457226c4239a74b83486739521434</anchor>
      <arglist>(const std::string &amp;filename)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>build_filename</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>gaa4a70bf050b3f318f87049ed30206a9a</anchor>
      <arglist>(const Glib::ArrayHandle&lt; std::string &gt; &amp;elements)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>build_filename</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>gada06023cc39be3a44eb68e38d6cbea6c</anchor>
      <arglist>(const std::string &amp;elem1, const std::string &amp;elem2)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>build_path</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga6afc89d45cc34f3cfce4a55f3f5e7afa</anchor>
      <arglist>(const std::string &amp;separator, const Glib::ArrayHandle&lt; std::string &gt; &amp;elements)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>find_program_in_path</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>gaa4c4ecb9a3eb803ae6d9dee51e1e5b14</anchor>
      <arglist>(const std::string &amp;program)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>PatternMatching</name>
    <title>Glob-style Pattern Matching</title>
    <filename>group__PatternMatching.html</filename>
    <class kind="class">Glib::PatternSpec</class>
  </compound>
  <compound kind="group">
    <name>Random</name>
    <title>Random Numbers</title>
    <filename>group__Random.html</filename>
    <class kind="class">Glib::Rand</class>
  </compound>
  <compound kind="group">
    <name>StringUtils</name>
    <title>String Utility Functions</title>
    <filename>group__StringUtils.html</filename>
    <member kind="function">
      <type>bool</type>
      <name>str_has_prefix</name>
      <anchorfile>group__StringUtils.html</anchorfile>
      <anchor>ga6b7e8354049756e92a97554a107618ac</anchor>
      <arglist>(const std::string &amp;str, const std::string &amp;prefix)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>str_has_suffix</name>
      <anchorfile>group__StringUtils.html</anchorfile>
      <anchor>ga5c4e380ffc6617ac61ca92e203e45630</anchor>
      <arglist>(const std::string &amp;str, const std::string &amp;suffix)</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>strtod</name>
      <anchorfile>group__StringUtils.html</anchorfile>
      <anchor>gaa44aba9faa6575d4881b1fe779464f6b</anchor>
      <arglist>(const std::string &amp;str)</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>strtod</name>
      <anchorfile>group__StringUtils.html</anchorfile>
      <anchor>ga6465a8320d790115c41a2c76d1d3233c</anchor>
      <arglist>(const std::string &amp;str, std::string::size_type &amp;end_index, std::string::size_type start_index=0)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>dtostr</name>
      <anchorfile>group__StringUtils.html</anchorfile>
      <anchor>gac740e6c99bca5896ccbfc12b621491ac</anchor>
      <arglist>(double d)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>strescape</name>
      <anchorfile>group__StringUtils.html</anchorfile>
      <anchor>ga35e288b5ce34cb15eeec907421d2b77c</anchor>
      <arglist>(const std::string &amp;source)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>strescape</name>
      <anchorfile>group__StringUtils.html</anchorfile>
      <anchor>gad24f3547c8d6b3ec56d7f5805a11d6ab</anchor>
      <arglist>(const std::string &amp;source, const std::string &amp;exceptions)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>strcompress</name>
      <anchorfile>group__StringUtils.html</anchorfile>
      <anchor>ga85cd83bd40baf0119aac3ff0a9a5e7b2</anchor>
      <arglist>(const std::string &amp;source)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>strerror</name>
      <anchorfile>group__StringUtils.html</anchorfile>
      <anchor>ga1eb869894996c91c0f69dbff96714c71</anchor>
      <arglist>(int errnum)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>strsignal</name>
      <anchorfile>group__StringUtils.html</anchorfile>
      <anchor>ga44ce9f689aff8abe1e3073b209f360d3</anchor>
      <arglist>(int signum)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>ThreadPools</name>
    <title>Thread Pools</title>
    <filename>group__ThreadPools.html</filename>
    <class kind="class">Glib::ThreadPool</class>
  </compound>
  <compound kind="group">
    <name>glibmmValue</name>
    <title>Generic Values</title>
    <filename>group__glibmmValue.html</filename>
    <class kind="class">Glib::Value&lt; bool &gt;</class>
    <class kind="class">Glib::Value&lt; char &gt;</class>
    <class kind="class">Glib::Value&lt; unsigned char &gt;</class>
    <class kind="class">Glib::Value&lt; int &gt;</class>
    <class kind="class">Glib::Value&lt; unsigned int &gt;</class>
    <class kind="class">Glib::Value&lt; long &gt;</class>
    <class kind="class">Glib::Value&lt; unsigned long &gt;</class>
    <class kind="class">Glib::Value&lt; long long &gt;</class>
    <class kind="class">Glib::Value&lt; unsigned long long &gt;</class>
    <class kind="class">Glib::Value&lt; float &gt;</class>
    <class kind="class">Glib::Value&lt; double &gt;</class>
    <class kind="class">Glib::Value&lt; void * &gt;</class>
    <class kind="class">Glib::ValueBase</class>
    <class kind="class">Glib::ValueBase_Boxed</class>
    <class kind="class">Glib::ValueBase_Object</class>
    <class kind="class">Glib::ValueBase_Enum</class>
    <class kind="class">Glib::ValueBase_Flags</class>
    <class kind="class">Glib::ValueBase_String</class>
    <class kind="class">Glib::Value_Boxed</class>
    <class kind="class">Glib::Value&lt; std::string &gt;</class>
    <class kind="class">Glib::Value&lt; Glib::ustring &gt;</class>
    <class kind="class">Glib::Value_Enum</class>
    <class kind="class">Glib::Value_Flags</class>
    <class kind="class">Glib::Value_Pointer</class>
    <class kind="class">Glib::Value</class>
    <class kind="class">Glib::Value&lt; T * &gt;</class>
    <class kind="class">Glib::Value&lt; const T * &gt;</class>
  </compound>
  <compound kind="group">
    <name>Streams</name>
    <title>Stream Classes</title>
    <filename>group__Streams.html</filename>
    <class kind="class">Gio::BufferedInputStream</class>
    <class kind="class">Gio::BufferedOutputStream</class>
    <class kind="class">Gio::DataInputStream</class>
    <class kind="class">Gio::DataOutputStream</class>
    <class kind="class">Gio::FileInputStream</class>
    <class kind="class">Gio::FileIOStream</class>
    <class kind="class">Gio::FileOutputStream</class>
    <class kind="class">Gio::FilterInputStream</class>
    <class kind="class">Gio::FilterOutputStream</class>
    <class kind="class">Gio::InputStream</class>
    <class kind="class">Gio::IOStream</class>
    <class kind="class">Gio::MemoryInputStream</class>
    <class kind="class">Gio::MemoryOutputStream</class>
    <class kind="class">Gio::Mount</class>
    <class kind="class">Gio::OutputStream</class>
    <class kind="class">Gio::Seekable</class>
    <class kind="class">Gio::UnixInputStream</class>
    <class kind="class">Gio::UnixOutputStream</class>
  </compound>
  <compound kind="group">
    <name>glibmmEnums</name>
    <title>Enums and Flags</title>
    <filename>group__glibmmEnums.html</filename>
    <member kind="enumeration">
      <name>ChecksumType</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga5d1c13a9d5c34bff7dd1e74654f282eb</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>CHECKSUM_MD5</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga5d1c13a9d5c34bff7dd1e74654f282eba3129e0040dd5c2541baadb2d3dd87ec3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>CHECKSUM_SHA1</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga5d1c13a9d5c34bff7dd1e74654f282eba7e5a02d18bd90f5988de70a06d22c7ad</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>CHECKSUM_SHA256</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga5d1c13a9d5c34bff7dd1e74654f282ebaf56ee9e607e115c54aaa7541ad9cb1b2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>Month</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga9781abc52ad49766808898743e44031f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>BAD_MONTH</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga9781abc52ad49766808898743e44031fa3c180cbd1a72ac6c1193374f07478043</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>JANUARY</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga9781abc52ad49766808898743e44031fadcae78391f0081dd887dbd5c62ce9e18</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FEBRUARY</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga9781abc52ad49766808898743e44031fafbb90abf68464b8e14a764cef1ced1e1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MARCH</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga9781abc52ad49766808898743e44031faaf1909bbb4cbf9a02db828ab35e52ce3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>APRIL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga9781abc52ad49766808898743e44031fa879774f2eee3f8807bbd8e3c25e3c5b2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MAY</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga9781abc52ad49766808898743e44031fa9da639bcfe895324daded17f4600116b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>JUNE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga9781abc52ad49766808898743e44031faaab22ac997e15a34995118694f8cbd2d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>JULY</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga9781abc52ad49766808898743e44031fae6d2bfb5bd12aace37808b1f5fe53afb</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>AUGUST</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga9781abc52ad49766808898743e44031fa846063b97ea9c5dd82cae8718bb75df1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SEPTEMBER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga9781abc52ad49766808898743e44031faa7e563e8689c07fac8f60f9f68f6cebb</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>OCTOBER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga9781abc52ad49766808898743e44031fa3c5a2a9a7bfcc9b7cbd57b89856c4989</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NOVEMBER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga9781abc52ad49766808898743e44031fac21038623ac787c4c94010d2334f6c8a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DECEMBER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga9781abc52ad49766808898743e44031fa2aed3776c7cb74418206e52677f394c7</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>Weekday</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga073c9f49a289b2036eb226bcdf16a2f1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>BAD_WEEKDAY</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga073c9f49a289b2036eb226bcdf16a2f1a0b852cafa7e3b36f3b87c8acd796be89</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MONDAY</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga073c9f49a289b2036eb226bcdf16a2f1ac75c38cdbe0d1a25346de7d5a1919f12</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TUESDAY</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga073c9f49a289b2036eb226bcdf16a2f1a3f573dae7a781f9f380b0adecdc068fc</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>WEDNESDAY</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga073c9f49a289b2036eb226bcdf16a2f1ab91831a000325a1ad3dd881f0db708e0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>THURSDAY</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga073c9f49a289b2036eb226bcdf16a2f1ac2be9a407f81cac5ef82ec308aa23cc9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FRIDAY</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga073c9f49a289b2036eb226bcdf16a2f1ad86f5fb6fa5f0f99e8f6980d5d78ceae</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SATURDAY</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga073c9f49a289b2036eb226bcdf16a2f1aa8703e1dd1d78272012d603e8ded6807</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SUNDAY</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga073c9f49a289b2036eb226bcdf16a2f1ac0ae61753cd0be03a4cee4ff0b209fb4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>DMY</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gac803072d86bbc2ce1f7d558c94f41ae1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DAY</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggac803072d86bbc2ce1f7d558c94f41ae1a340ad04532a2d66518f8eefdf1ac1b27</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MONTH</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggac803072d86bbc2ce1f7d558c94f41ae1a9da8611c47d68fe95d9026cf162bb350</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>YEAR</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggac803072d86bbc2ce1f7d558c94f41ae1a8eec7a614a99a9640e578862c13b5682</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>FileTest</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga33c24ccefbd130021f06708763e16ef2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_TEST_IS_REGULAR</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga33c24ccefbd130021f06708763e16ef2a3181e2e655e765b00dfdb1e1ea443f62</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_TEST_IS_SYMLINK</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga33c24ccefbd130021f06708763e16ef2a86cda9ff0bf25358070a9bc8b4a186d6</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_TEST_IS_DIR</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga33c24ccefbd130021f06708763e16ef2ad3679641c18e5e4d4578c2122492cea4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_TEST_IS_EXECUTABLE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga33c24ccefbd130021f06708763e16ef2ad9ab64f07fd4fc2105b53b7379265535</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_TEST_EXISTS</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga33c24ccefbd130021f06708763e16ef2a37c8f223bda6b6ce2875490351989ddd</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>SeekType</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gaa3767731311bdba4ef42dc99215e5cda</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SEEK_TYPE_CUR</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaa3767731311bdba4ef42dc99215e5cdaa48f0a394042c3a8e117b2ae64af33960</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SEEK_TYPE_SET</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaa3767731311bdba4ef42dc99215e5cdaa1e0d3b4a03e5dd32f135acc89982889f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SEEK_TYPE_END</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaa3767731311bdba4ef42dc99215e5cdaafa5ff5cdf7e6623866c717fe49cfbaec</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>IOStatus</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga23fb251e48485b62a9c2677bb1f87d5e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_STATUS_ERROR</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga23fb251e48485b62a9c2677bb1f87d5ea121996c81c45593110cd714bb81bc349</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_STATUS_NORMAL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga23fb251e48485b62a9c2677bb1f87d5eaf249c5b8e984c37db0847258aeeae86a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_STATUS_EOF</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga23fb251e48485b62a9c2677bb1f87d5ead42ae91b402716ab4faaec9b0f3823fe</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_STATUS_AGAIN</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga23fb251e48485b62a9c2677bb1f87d5ea5a33609d7ff07e1d711185c0765cf5de</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>IOFlags</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gaee093e5db5bc1ea5738771ba0d1af3b7</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_FLAG_APPEND</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaee093e5db5bc1ea5738771ba0d1af3b7a121e65986f06397730c4c36d09fb4dc7</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_FLAG_NONBLOCK</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaee093e5db5bc1ea5738771ba0d1af3b7a3724a778574d25ba0bd83139a80b2c0b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_FLAG_IS_READABLE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaee093e5db5bc1ea5738771ba0d1af3b7a162bfe5ccb18465d0f11e954cc4a89d9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_FLAG_IS_WRITEABLE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaee093e5db5bc1ea5738771ba0d1af3b7af9738e0234ae1d1f15c4512d6edb16db</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_FLAG_IS_SEEKABLE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaee093e5db5bc1ea5738771ba0d1af3b7ac1373a306084710994199b3de0137cfd</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_FLAG_GET_MASK</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaee093e5db5bc1ea5738771ba0d1af3b7a9431cd6fcef2a716b7d313bd9cde85b6</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_FLAG_SET_MASK</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaee093e5db5bc1ea5738771ba0d1af3b7a1d4db9b335a96f503cd491973b162105</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>KeyFileFlags</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga5866be36312563d91e5a7be27348459b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>KEY_FILE_NONE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga5866be36312563d91e5a7be27348459ba06a606cb7b5f244a0f3ad4f5e67b30bb</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>KEY_FILE_KEEP_COMMENTS</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga5866be36312563d91e5a7be27348459ba00058fa3d8e271d9ff5e1469dc39dc69</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>KEY_FILE_KEEP_TRANSLATIONS</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga5866be36312563d91e5a7be27348459ba7ff723c84c930b978dccd6732eebe985</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>ParseFlags</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gaa4fcaf917b6eb2aa085817e83b0a4108</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DO_NOT_USE_THIS_UNSUPPORTED_FLAG</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaa4fcaf917b6eb2aa085817e83b0a4108a3f48cb56dd56d529c9379ae244441e90</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TREAT_CDATA_AS_TEXT</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaa4fcaf917b6eb2aa085817e83b0a4108a7da76e9b36f7599e3791e9cc87a2ff72</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PREFIX_ERROR_POSITION</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaa4fcaf917b6eb2aa085817e83b0a4108a4bd16878d9226c7ce4c5fbf023a67e94</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>ModuleFlags</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga502283ffbe523adf38c69905ec8640f3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MODULE_BIND_LAZY</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga502283ffbe523adf38c69905ec8640f3acd94d05ef9ba97ceb6f3904b87f5bbfc</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MODULE_BIND_LOCAL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga502283ffbe523adf38c69905ec8640f3a8e5768a91ee8dbf459785dee8b664b72</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MODULE_BIND_MASK</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga502283ffbe523adf38c69905ec8640f3a9cbf95b359863e9296457cbb0f193169</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>TraverseType</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gae3a70fa1e451da068323419e8c98e9a9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TRAVERSE_IN_ORDER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggae3a70fa1e451da068323419e8c98e9a9aa7f260b474a886df2bf1aefcfc0f14b2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TRAVERSE_PRE_ORDER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggae3a70fa1e451da068323419e8c98e9a9abed8efe71581ccb087323f38b6807661</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TRAVERSE_POST_ORDER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggae3a70fa1e451da068323419e8c98e9a9a0af70e322b94dfbbfc98b100d21cef4e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TRAVERSE_LEVEL_ORDER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggae3a70fa1e451da068323419e8c98e9a9a16cd819f4ab8175453f6287aeefad870</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>TraverseFlags</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gad11179d39a4991e5b09f145d594a450e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TRAVERSE_LEAVES</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggad11179d39a4991e5b09f145d594a450ea7da8793fdd0c433870a5e6c2e3152898</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TRAVERSE_NON_LEAVES</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggad11179d39a4991e5b09f145d594a450ea6473ae1f054172ae349d01003fabf37f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TRAVERSE_ALL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggad11179d39a4991e5b09f145d594a450ea1be75d605b0c93ca7932110467536670</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TRAVERSE_MASK</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggad11179d39a4991e5b09f145d594a450ea6832c7b45443db4eed6f4cfbd3c04b69</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>RegexCompileFlags</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gaaaedee3e1374af9f1d66ccd34252a68d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_CASELESS</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaaaedee3e1374af9f1d66ccd34252a68da0f604aee4eae77ce7bca901c8b3de37d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_MULTILINE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaaaedee3e1374af9f1d66ccd34252a68daee58700869ae67ad0823d10a7c51cb9d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_DOTALL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaaaedee3e1374af9f1d66ccd34252a68da7ec3013d10b6360c921d67f23ff585fa</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_EXTENDED</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaaaedee3e1374af9f1d66ccd34252a68da4ef80551354a8a16bcefaf9b35f55a17</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_ANCHORED</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaaaedee3e1374af9f1d66ccd34252a68da67404d06bba595dec28fb4e6e05da427</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_DOLLAR_ENDONLY</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaaaedee3e1374af9f1d66ccd34252a68da0d7cf52858b215b55ff10ccae9732dd4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_UNGREEDY</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaaaedee3e1374af9f1d66ccd34252a68daf9c564d8191b7220f0f072b3b694f8ac</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_RAW</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaaaedee3e1374af9f1d66ccd34252a68da3acb6bdd173741b57cf267be3a3c7f75</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_NO_AUTO_CAPTURE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaaaedee3e1374af9f1d66ccd34252a68dac6ccf906840973453a55625b2edf2f25</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_OPTIMIZE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaaaedee3e1374af9f1d66ccd34252a68da581257f414998f8ea0e0f55adf0844f0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_DUPNAMES</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaaaedee3e1374af9f1d66ccd34252a68da895a8a3fb7141b91a1890ee0bdb1a6b1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_NEWLINE_CR</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaaaedee3e1374af9f1d66ccd34252a68da3cab374f897aaac10d71c5437f9d77f3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_NEWLINE_LF</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaaaedee3e1374af9f1d66ccd34252a68dabbbc306156a05aa67fde8d86d6d3b3c9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_NEWLINE_CRLF</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaaaedee3e1374af9f1d66ccd34252a68da8a419c54023c5dbedbd8960c9367d68a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>RegexMatchFlags</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga8375c7f6797efc96929e8be89435c746</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_MATCH_ANCHORED</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga8375c7f6797efc96929e8be89435c746ac387b5b0e77b1726553e5d77e77191d9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_MATCH_NOTBOL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga8375c7f6797efc96929e8be89435c746afcdffce16a01e99f25f52bfe3deafd80</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_MATCH_NOTEOL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga8375c7f6797efc96929e8be89435c746a70b70be752f4874a262c15b99b3ee75f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_MATCH_NOTEMPTY</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga8375c7f6797efc96929e8be89435c746a58bc907f6f6e19c30456c895d18ea655</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_MATCH_PARTIAL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga8375c7f6797efc96929e8be89435c746aaa4d21e1c7f7ab1df117d433cafc5ad6</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_MATCH_NEWLINE_CR</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga8375c7f6797efc96929e8be89435c746aed663630c5623dc65f0ea23a04cf2979</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_MATCH_NEWLINE_LF</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga8375c7f6797efc96929e8be89435c746af5656ccd40cd632e00bc71b08834386e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_MATCH_NEWLINE_CRLF</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga8375c7f6797efc96929e8be89435c746a4b76b13cfd30f891108f491a58dbb2a9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_MATCH_NEWLINE_ANY</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga8375c7f6797efc96929e8be89435c746ac76fe84aa6df3f8e6af74504ff5e7ca8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>SpawnFlags</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga075918988c271e7fb63f1a1d083e26dd</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SPAWN_LEAVE_DESCRIPTORS_OPEN</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga075918988c271e7fb63f1a1d083e26ddaa2a457be3bdc07bbd0d32e1a63264d90</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SPAWN_DO_NOT_REAP_CHILD</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga075918988c271e7fb63f1a1d083e26dda0ad30b49d46750083ddd1e0643635e85</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SPAWN_SEARCH_PATH</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga075918988c271e7fb63f1a1d083e26dda341e5cb2803eb06a0f2f0431d6305e04</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SPAWN_STDOUT_TO_DEV_NULL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga075918988c271e7fb63f1a1d083e26dda450919630c2ce753374d1d05760bb205</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SPAWN_STDERR_TO_DEV_NULL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga075918988c271e7fb63f1a1d083e26dda5ae7fa0d4f6a0bdfc37adeb578634491</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SPAWN_CHILD_INHERITS_STDIN</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga075918988c271e7fb63f1a1d083e26dda9fb3c6cfddb2ef201f7b11829da8b5d0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SPAWN_FILE_AND_ARGV_ZERO</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga075918988c271e7fb63f1a1d083e26dda55dc12133953441059847e8633227a84</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>ThreadPriority</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga9b87dca6496b6ad53baec9ca01318448</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>THREAD_PRIORITY_LOW</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga9b87dca6496b6ad53baec9ca01318448a035a7bdc6a5b5eae6f644ed2605e8a37</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>THREAD_PRIORITY_NORMAL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga9b87dca6496b6ad53baec9ca01318448a6216bb25baaaca32642841ade911a92e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>THREAD_PRIORITY_HIGH</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga9b87dca6496b6ad53baec9ca01318448aef77081535e90116b203ce3b3b0fe523</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>THREAD_PRIORITY_URGENT</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga9b87dca6496b6ad53baec9ca01318448a5b79355bbd59c508995af57e0ed39a94</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>UnicodeType</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gadfbb414be3a4d127146fdca66dc7a46e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_CONTROL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46eac280382585f1014b43ed228760e7c558</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_FORMAT</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46eaaedc3e279c1c7e01f1bec907bbe313ab</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_UNASSIGNED</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46eafc32abac3afbe8380d54790f178fd3de</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_PRIVATE_USE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46ea5ca14907043380b1e9d725671bc71a56</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_SURROGATE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46ea0b99b4f93ef273ea4c49fb82970f5e54</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_LOWERCASE_LETTER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46eadb83c3e23724b6ef15888c6527a063bc</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_MODIFIER_LETTER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46eae6e48ddd5b4eacb4cbf67fa902743458</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_OTHER_LETTER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46ea57ced328464824fe23113e7b98a4ae61</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_TITLECASE_LETTER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46eab72e09c06a5aeffccdd94d5695dfcbc8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_UPPERCASE_LETTER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46ea8f344db3f8e39ed99bc2c9665ab96c89</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_COMBINING_MARK</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46ea5d22c0c4d39d68b815dccd52bb5ff01c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_ENCLOSING_MARK</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46ea4508b84626068a2dbf23a69b96475e6e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_NON_SPACING_MARK</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46ea857864a5d1c145cc3ff8ccba54834f19</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_DECIMAL_NUMBER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46eae75e5f353bc068ec3d8bf2555c540995</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_LETTER_NUMBER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46ea19811baedb3dbc8afddde43d00eb3cd9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_OTHER_NUMBER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46ea45a259cec90b0ada120fe7116be422b5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_CONNECT_PUNCTUATION</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46ea649c83b23fb3d9bd7bf1803858cc5afe</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_DASH_PUNCTUATION</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46eaa1169c4e20b3a47f597005f84f9fa7fc</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_CLOSE_PUNCTUATION</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46ea1ffaf2aac92ca1e818cf3e26b8301b90</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_FINAL_PUNCTUATION</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46eab549f212a3f340bd660a962b298409ff</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_INITIAL_PUNCTUATION</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46eab247e5e7480ecbf382b2128c600b8720</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_OTHER_PUNCTUATION</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46ea5c9416f9219bf9282c49b7ca831f0c9e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_OPEN_PUNCTUATION</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46ea806e11a7f8d1a0b0688a0237ad1fa190</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_CURRENCY_SYMBOL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46ea40b40c2bb5d39acee2b81327e2efb905</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_MODIFIER_SYMBOL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46ea5b693a82d2e497a2b13cae8d5668097c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_MATH_SYMBOL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46ea28100e9fa5a262bbd32b973303746490</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_OTHER_SYMBOL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46ea298582645a73c91d191b7e1dc61d214f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_LINE_SEPARATOR</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46ead7650a40ddf3741e87a1039eba56b1a5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_PARAGRAPH_SEPARATOR</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46ea5b3c71c265af11b331d0ec4240af1c8f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_SPACE_SEPARATOR</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46eac2eafb967dc62399aeb5ff27c8896b0d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>UnicodeBreakType</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga1af1a717c84d71aa4aabc9fc77b4d0ea</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_MANDATORY</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa37c762c3c7b080f5795ed6f828231923</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_CARRIAGE_RETURN</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa6b7c9d7a0ac78d14cf06b18bfeb2ccf9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_LINE_FEED</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa7839936b879938c5056bdb55eb0b6b7a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_COMBINING_MARK</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa014f326eb07effe48f1b771459caa7c4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_SURROGATE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa032b712c48700209c7cc414ca88cda34</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_ZERO_WIDTH_SPACE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaadb5ff8a11c4e596677d161903c732c56</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_INSEPARABLE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa38f51c8283586493a3ebd45fa3b0113e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_NON_BREAKING_GLUE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa47784c7e2cd80f6ac179de7f7a3f54e6</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_CONTINGENT</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaae80d6fef8acf765da47c8235e39f4896</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_SPACE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaab37a6597dbf2e248b610769be7e5cb3d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_AFTER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaada4027a9bfc5ffdf90e3be612adad7aa</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_BEFORE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaab1efcdcd3d6ecb55dff58a2e2ee1b9e4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_BEFORE_AND_AFTER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaaafce05d8590e1b40ec427f8f78cf15ee</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_HYPHEN</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa7e6dd69fc00fdc42ab091a2916426dbc</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_NON_STARTER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaabe412d94a1f7d9e92cc5a20f0b549626</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_OPEN_PUNCTUATION</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa52ebd39d1b02dfd368992a2ef8e7fa7d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_CLOSE_PUNCTUATION</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaad1284afc0511ab69aa18554b8306fbca</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_QUOTATION</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa8fe57a799eacc3299fd256285dd1246d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_EXCLAMATION</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaaf628849c1e5b531c022e12695c1f6f5d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_IDEOGRAPHIC</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa22047a88734e9fe1e9e0fef994cfb20b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_NUMERIC</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa50a61c3c53da7558d08c1fcbcfc3b138</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_INFIX_SEPARATOR</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa07f3d0d76db141033eff38ee7577ffd2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_SYMBOL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaafc02ec4862f016b6c2da35592f6cd62b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_ALPHABETIC</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaaea27a8970e74f93f485d45f6a1684586</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_PREFIX</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa580794ffc9992e65666adce0611eecb4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_POSTFIX</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa7ca3941d5dea03a5c824ae55212db01a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_COMPLEX_CONTEXT</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa3a96b8e59ba5815700d33c1f6006a339</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_AMBIGUOUS</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaae79244811e61b30eb68ee02dc45f1c09</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_UNKNOWN</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaaeb94f98b2233fae0afb38bf115b4b42d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_NEXT_LINE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa7ffad3080f483a6b97680db786836ced</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_WORD_JOINER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa9a74e7d947f75ef93d4e3aacebdb898b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_HANGUL_L_JAMO</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaab3449fb99a5694c3f6debd9d1a887a1b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_HANGUL_V_JAMO</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa156946aa6aec4f4e0f8e69d352f31f90</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_HANGUL_T_JAMO</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa37082de3ccd45cca392c6dee935d7cc0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_HANGUL_LV_SYLLABLE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa7a11c61184436fe2fb6e74d0ea916f86</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_HANGUL_LVT_SYLLABLE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa44dec475bcc1d26dc3ad905c302efc87</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>AsciiType</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga2e5a690ed07dfaa6f9ad9f1c57acd787</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ASCII_ALNUM</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga2e5a690ed07dfaa6f9ad9f1c57acd787af7d63a99479102b5391b44f631b5f009</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ASCII_ALPHA</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga2e5a690ed07dfaa6f9ad9f1c57acd787ac87947c729ac3c3f9f58b0ca28460152</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ASCII_CNTRL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga2e5a690ed07dfaa6f9ad9f1c57acd787a2e19c57ce5a6eac38d911a86cc44a2fb</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ASCII_DIGIT</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga2e5a690ed07dfaa6f9ad9f1c57acd787a9acd9a82d0670a3eb0377db782f48853</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ASCII_GRAPH</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga2e5a690ed07dfaa6f9ad9f1c57acd787a2ecdbe5137af423fce73ff2bbb34d625</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ASCII_LOWER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga2e5a690ed07dfaa6f9ad9f1c57acd787a875d3cb7494e1548db0d37ab44d4057e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ASCII_PRINT</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga2e5a690ed07dfaa6f9ad9f1c57acd787a9b1775043a8043d994c0c0ab890e86c4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ASCII_PUNCT</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga2e5a690ed07dfaa6f9ad9f1c57acd787ad3416d8662560db626259013ff72c58f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ASCII_SPACE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga2e5a690ed07dfaa6f9ad9f1c57acd787a7d7a68814efba3cf3d294475123413ce</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ASCII_UPPER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga2e5a690ed07dfaa6f9ad9f1c57acd787a5ae30681069b2ab88eed13e358c08090</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ASCII_XDIGIT</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga2e5a690ed07dfaa6f9ad9f1c57acd787ad78490a35d65839f2f06449e7e472337</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>NormalizeMode</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga18199b64f406e397627a4e7fc799f848</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NORMALIZE_DEFAULT</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga18199b64f406e397627a4e7fc799f848acbaee513b23e0066962df2e540cd4c99</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NORMALIZE_NFD</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga18199b64f406e397627a4e7fc799f848a169a0ae0910535038d8d403f874f0b5f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NORMALIZE_DEFAULT_COMPOSE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga18199b64f406e397627a4e7fc799f848ad9fb4be6b95958030771b4e8cba4144c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NORMALIZE_NFC</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga18199b64f406e397627a4e7fc799f848a20e4b8b42b12a7972ca4f6c84030978d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NORMALIZE_ALL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga18199b64f406e397627a4e7fc799f848aa1cf5911572000f5273dc46fe2c5b270</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NORMALIZE_NFKD</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga18199b64f406e397627a4e7fc799f848a995775ef324bbd76a91a74c7f2686867</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NORMALIZE_ALL_COMPOSE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga18199b64f406e397627a4e7fc799f848a7c98a2300648a33ca0ebc87fed999ca5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NORMALIZE_NFKC</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga18199b64f406e397627a4e7fc799f848aa7f62ac84c5ed8a8868cbb49a889dd98</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>FileTest</type>
      <name>operator|</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga8e018d8609ba17b0f6955505a8363bf7</anchor>
      <arglist>(FileTest lhs, FileTest rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileTest</type>
      <name>operator&amp;</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gae652f47e7b61603b9a6b86b7251d5526</anchor>
      <arglist>(FileTest lhs, FileTest rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileTest</type>
      <name>operator^</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga6c089f23d6bfd92e083edc75519db75e</anchor>
      <arglist>(FileTest lhs, FileTest rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileTest</type>
      <name>operator~</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga948edadd8ee7442b83d37dc3c325f890</anchor>
      <arglist>(FileTest flags)</arglist>
    </member>
    <member kind="function">
      <type>FileTest &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga9a6f5470f667596e897f5bfbd1068283</anchor>
      <arglist>(FileTest &amp;lhs, FileTest rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileTest &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga112ada474a7aad83af2bd49403abf41e</anchor>
      <arglist>(FileTest &amp;lhs, FileTest rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileTest &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga2219c78993a5196ca2a435a18e0fc3a7</anchor>
      <arglist>(FileTest &amp;lhs, FileTest rhs)</arglist>
    </member>
    <member kind="function">
      <type>IOFlags</type>
      <name>operator|</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga0dd0a8800b6311ee8f3867eb27a72ae5</anchor>
      <arglist>(IOFlags lhs, IOFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>IOFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga7662618e73d046d4df5eb7cce3e487f8</anchor>
      <arglist>(IOFlags lhs, IOFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>IOFlags</type>
      <name>operator^</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gad61c57b0678c703e8a14230d18bacff7</anchor>
      <arglist>(IOFlags lhs, IOFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>IOFlags</type>
      <name>operator~</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga548c1cb09208fef57e5d0b3c992d71b9</anchor>
      <arglist>(IOFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>IOFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gac3539f6df5e0c0658726f4f0573146f9</anchor>
      <arglist>(IOFlags &amp;lhs, IOFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>IOFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gae84d9361a6154e6b0e8d099705ad6cad</anchor>
      <arglist>(IOFlags &amp;lhs, IOFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>IOFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga2180a5c566ced37bbeb37050d9632da9</anchor>
      <arglist>(IOFlags &amp;lhs, IOFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>KeyFileFlags</type>
      <name>operator|</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gabac5e1493392116b118e4d1048e3fef0</anchor>
      <arglist>(KeyFileFlags lhs, KeyFileFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>KeyFileFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga1827ef58fe5e85d65ff8166e51b33556</anchor>
      <arglist>(KeyFileFlags lhs, KeyFileFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>KeyFileFlags</type>
      <name>operator^</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gacc28b21831114895abfdbae6c1908114</anchor>
      <arglist>(KeyFileFlags lhs, KeyFileFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>KeyFileFlags</type>
      <name>operator~</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gab99ff1d7c6d96da2ddfcfd1c4954e9b6</anchor>
      <arglist>(KeyFileFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>KeyFileFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga7096a34594825c90d7b6257935a62eb1</anchor>
      <arglist>(KeyFileFlags &amp;lhs, KeyFileFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>KeyFileFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga80dd56fcaea8bc3f0a5f21b9d3049877</anchor>
      <arglist>(KeyFileFlags &amp;lhs, KeyFileFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>KeyFileFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gac90869f74a743e2f99f55708c28a585d</anchor>
      <arglist>(KeyFileFlags &amp;lhs, KeyFileFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ParseFlags</type>
      <name>operator|</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga330303c9d78eb78547012d549d4bb018</anchor>
      <arglist>(ParseFlags lhs, ParseFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ParseFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga421021254296cdba48ec178a54fe93d9</anchor>
      <arglist>(ParseFlags lhs, ParseFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ParseFlags</type>
      <name>operator^</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gab059cb7acda2b29eb2066958fc71951a</anchor>
      <arglist>(ParseFlags lhs, ParseFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ParseFlags</type>
      <name>operator~</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga1fb97b62ae844c056b400e2813a21ee2</anchor>
      <arglist>(ParseFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>ParseFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga6b24d718f166cb352be94ee6e4090296</anchor>
      <arglist>(ParseFlags &amp;lhs, ParseFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ParseFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga2a7b1137fa0d9495cdb5f46ec564a2ba</anchor>
      <arglist>(ParseFlags &amp;lhs, ParseFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ParseFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gaf59b9479390c508dff23dba221177bcc</anchor>
      <arglist>(ParseFlags &amp;lhs, ParseFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ModuleFlags</type>
      <name>operator|</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gade862759d091b90329ba8f85aa2fd010</anchor>
      <arglist>(ModuleFlags lhs, ModuleFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ModuleFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gaacd06c8457fa8f31c1483f96c4933ddf</anchor>
      <arglist>(ModuleFlags lhs, ModuleFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ModuleFlags</type>
      <name>operator^</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga333d93ef372c08c322d27ac05bda0e18</anchor>
      <arglist>(ModuleFlags lhs, ModuleFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ModuleFlags</type>
      <name>operator~</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gaaa723a5b4d33e54167f7adbb18746004</anchor>
      <arglist>(ModuleFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>ModuleFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gae9df767ea1ec74b0d9d9acce426a07a8</anchor>
      <arglist>(ModuleFlags &amp;lhs, ModuleFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ModuleFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gab903aa5397125ce37c66a259c4b1a5f5</anchor>
      <arglist>(ModuleFlags &amp;lhs, ModuleFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ModuleFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga8e73a634c6441630eddf8805b22dd163</anchor>
      <arglist>(ModuleFlags &amp;lhs, ModuleFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>RegexCompileFlags</type>
      <name>operator|</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga5c44b3a4eee7eefbb1f2d1d8f22642ca</anchor>
      <arglist>(RegexCompileFlags lhs, RegexCompileFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>RegexCompileFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga4ae748a01d312275d2ca4e15c5df5826</anchor>
      <arglist>(RegexCompileFlags lhs, RegexCompileFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>RegexCompileFlags</type>
      <name>operator^</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga69068f48bbea92cdd3cc7d69fdc017e1</anchor>
      <arglist>(RegexCompileFlags lhs, RegexCompileFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>RegexCompileFlags</type>
      <name>operator~</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gacb650222b1a3f6a44e72df95d815a7f8</anchor>
      <arglist>(RegexCompileFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>RegexCompileFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gae6fd65d5a674d2e2e453793d86fa64cd</anchor>
      <arglist>(RegexCompileFlags &amp;lhs, RegexCompileFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>RegexCompileFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gaeefcf05c20e07dde23268b83a1ff1c45</anchor>
      <arglist>(RegexCompileFlags &amp;lhs, RegexCompileFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>RegexCompileFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga1425051a4ffed939a1bff1e0543c9498</anchor>
      <arglist>(RegexCompileFlags &amp;lhs, RegexCompileFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>RegexMatchFlags</type>
      <name>operator|</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gab63da3a959cbd5f00f4fa535e35eda08</anchor>
      <arglist>(RegexMatchFlags lhs, RegexMatchFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>RegexMatchFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga29b80a6c4482fae8e19f9328ec0c3147</anchor>
      <arglist>(RegexMatchFlags lhs, RegexMatchFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>RegexMatchFlags</type>
      <name>operator^</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga06c395f619dffca3f0fc483fab302122</anchor>
      <arglist>(RegexMatchFlags lhs, RegexMatchFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>RegexMatchFlags</type>
      <name>operator~</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gaf192ce556cbd7ddb416e8078bdb09523</anchor>
      <arglist>(RegexMatchFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>RegexMatchFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga8f30deab298559a873d7beca40279ead</anchor>
      <arglist>(RegexMatchFlags &amp;lhs, RegexMatchFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>RegexMatchFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga283a3e82cd9d3da8746edbe13a6f616a</anchor>
      <arglist>(RegexMatchFlags &amp;lhs, RegexMatchFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>RegexMatchFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga402d81f594d95305aa6e275aa74126ae</anchor>
      <arglist>(RegexMatchFlags &amp;lhs, RegexMatchFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SpawnFlags</type>
      <name>operator|</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gaba6cac919da111ebf69667bf9f8006ff</anchor>
      <arglist>(SpawnFlags lhs, SpawnFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SpawnFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga2d10b36fdc1ceb9fea2ffcd58406f3e2</anchor>
      <arglist>(SpawnFlags lhs, SpawnFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SpawnFlags</type>
      <name>operator^</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga84449a9a461b381f88f65435ef8389ec</anchor>
      <arglist>(SpawnFlags lhs, SpawnFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SpawnFlags</type>
      <name>operator~</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga065f45ca68d1397febf331293e4cc4de</anchor>
      <arglist>(SpawnFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>SpawnFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gabbe289c910b34a158f8dc22bb0b0095f</anchor>
      <arglist>(SpawnFlags &amp;lhs, SpawnFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SpawnFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga93f15ab009ea244c1d8b069e27ec193f</anchor>
      <arglist>(SpawnFlags &amp;lhs, SpawnFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SpawnFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga40166fcca8eb8ec5b148c82444553927</anchor>
      <arglist>(SpawnFlags &amp;lhs, SpawnFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AsciiType</type>
      <name>operator|</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga5bc1518eb5547dbb8af77b944ccaa048</anchor>
      <arglist>(AsciiType lhs, AsciiType rhs)</arglist>
    </member>
    <member kind="function">
      <type>AsciiType</type>
      <name>operator&amp;</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga4c340e00aeb13a9124081f383283eed0</anchor>
      <arglist>(AsciiType lhs, AsciiType rhs)</arglist>
    </member>
    <member kind="function">
      <type>AsciiType</type>
      <name>operator^</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga682a545ca2e86b3e162305e4f14fa8d5</anchor>
      <arglist>(AsciiType lhs, AsciiType rhs)</arglist>
    </member>
    <member kind="function">
      <type>AsciiType</type>
      <name>operator~</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gad7ea47582094c6d092a8f485e1e709c6</anchor>
      <arglist>(AsciiType flags)</arglist>
    </member>
    <member kind="function">
      <type>AsciiType &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga69bba23f4c9a83c268d0599f241b8ebe</anchor>
      <arglist>(AsciiType &amp;lhs, AsciiType rhs)</arglist>
    </member>
    <member kind="function">
      <type>AsciiType &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga8f4b46bf548b21ef21a568ecc18a5871</anchor>
      <arglist>(AsciiType &amp;lhs, AsciiType rhs)</arglist>
    </member>
    <member kind="function">
      <type>AsciiType &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gac1b0239e539cf250333fe0adc04dbb41</anchor>
      <arglist>(AsciiType &amp;lhs, AsciiType rhs)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>giommEnums</name>
    <title>Enums and Flags</title>
    <filename>group__giommEnums.html</filename>
    <member kind="enumeration">
      <name>AppInfoCreateFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gae39c1e25f40a070e1720470758a55344</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>APP_INFO_CREATE_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggae39c1e25f40a070e1720470758a55344af71f654bb54f7e68263da28fc5eccacd</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>APP_INFO_CREATE_NEEDS_TERMINAL</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggae39c1e25f40a070e1720470758a55344a01421973a2522b9e2ac7672c03468e8f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>APP_INFO_CREATE_SUPPORTS_URIS</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggae39c1e25f40a070e1720470758a55344aef4faf5deef3c2e3eec96cefd9feeafc</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>DriveStartFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gab628e70b1d028b3bc9b02b0d3b8acf2d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DRIVE_START_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggab628e70b1d028b3bc9b02b0d3b8acf2da6a46299fc0a721de0bed46063ba484de</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>DriveStartStopType</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga148d2356238c5c8f809dcbd58341cc2d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DRIVE_START_STOP_TYPE_UNKNOWN</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga148d2356238c5c8f809dcbd58341cc2da01961d00b61f87fb25ba3001a042db5b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DRIVE_START_STOP_TYPE_SHUTDOWN</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga148d2356238c5c8f809dcbd58341cc2da59acd7106146af052b9bc164ac85d1d4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DRIVE_START_STOP_TYPE_NETWORK</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga148d2356238c5c8f809dcbd58341cc2da24f499a4eee0fb59870d42089fc8cc38</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DRIVE_START_STOP_TYPE_MULTIDISK</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga148d2356238c5c8f809dcbd58341cc2da7f6a48659447fa2b3b0c1c9d0520e2ae</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DRIVE_START_STOP_TYPE_PASSWORD</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga148d2356238c5c8f809dcbd58341cc2daf1a4c886e6d77d3a1f3d8b864a536da5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>EmblemOrigin</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga7f2c8f757fdeb91ca48c0bc8184f9270</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EMBLEM_ORIGIN_UNKNOWN</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga7f2c8f757fdeb91ca48c0bc8184f9270a8f8b573b5755138f1da852121c33027d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EMBLEM_ORIGIN_DEVICE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga7f2c8f757fdeb91ca48c0bc8184f9270a6bcc4f7fda6aee37062db66a6abe66c2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EMBLEM_ORIGIN_LIVEMETADATA</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga7f2c8f757fdeb91ca48c0bc8184f9270a746b49f22653188190760d6724f00c03</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EMBLEM_ORIGIN_TAG</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga7f2c8f757fdeb91ca48c0bc8184f9270a8ca854f52478785f462472c706aefa2b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>DataStreamByteOrder</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga87dea9b56fed9c0bca0f8426fb57781e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DATA_STREAM_BYTE_ORDER_BIG_ENDIAN</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga87dea9b56fed9c0bca0f8426fb57781ea18117d3d82013605e0200837278b61ce</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DATA_STREAM_BYTE_ORDER_LITTLE_ENDIAN</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga87dea9b56fed9c0bca0f8426fb57781ead7d652c4c3be181175e6b3ce0b8a6b6d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DATA_STREAM_BYTE_ORDER_HOST_ENDIAN</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga87dea9b56fed9c0bca0f8426fb57781ea4ee0fe7768cdcaa1bfe30a866e597fe5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>DataStreamNewlineType</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga2de111fe308aff763fb98a39bc507267</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DATA_STREAM_NEWLINE_TYPE_LF</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga2de111fe308aff763fb98a39bc507267a2984664a935bd2803f9f8efb525ab1ab</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DATA_STREAM_NEWLINE_TYPE_CR</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga2de111fe308aff763fb98a39bc507267a684a76a8c6470952cf17935c0e6d4c85</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DATA_STREAM_NEWLINE_TYPE_CR_LF</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga2de111fe308aff763fb98a39bc507267a668ad4c9993ae7201cad988ccb9f9265</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DATA_STREAM_NEWLINE_TYPE_ANY</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga2de111fe308aff763fb98a39bc507267a07aa934ff2e202ae347600466895d634</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>SocketFamily</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga0ba69e14ad979bf9b2073ad122e38d48</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_FAMILY_INVALID</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0ba69e14ad979bf9b2073ad122e38d48a287dfaac297cc0158f78d7d62949ccaa</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_FAMILY_IPV6</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0ba69e14ad979bf9b2073ad122e38d48a8077081b5558ee5a35497749c4f4901c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>FileQueryInfoFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga2cb7bdea61353f0999607785abd032c0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_QUERY_INFO_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga2cb7bdea61353f0999607785abd032c0a25937649b891bc6e25fd3b102e961fa0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_QUERY_INFO_NOFOLLOW_SYMLINKS</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga2cb7bdea61353f0999607785abd032c0a111136a309875440d7b9a065e9d413fc</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>FileCreateFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga500a44e123fd4c578f8af9ddef2f7601</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_CREATE_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga500a44e123fd4c578f8af9ddef2f7601aa91626c845b45a4432c5c5be9f62db63</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_CREATE_PRIVATE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga500a44e123fd4c578f8af9ddef2f7601a561d151d8be5524e68d0316baa6b3346</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_CREATE_REPLACE_DESTINATION</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga500a44e123fd4c578f8af9ddef2f7601aa1edf0c05c6e4c84340200dcb4b981bf</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>FileCopyFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga08edc09a45449b136b27493647d4ecbe</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_COPY_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga08edc09a45449b136b27493647d4ecbea2de95276b80f5261e9de761e98987273</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_COPY_OVERWRITE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga08edc09a45449b136b27493647d4ecbeaa739f5a86205d73bc68ef06e59943b0a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_COPY_BACKUP</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga08edc09a45449b136b27493647d4ecbeae4bdca31f92ed16bc4fbdcfed03f51d3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_COPY_NOFOLLOW_SYMLINKS</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga08edc09a45449b136b27493647d4ecbea28d4e03c13c33cc8ee846dd74720b8c2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_COPY_ALL_METADATA</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga08edc09a45449b136b27493647d4ecbea1a0416eaa1df264399127dcfc8787cb3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_COPY_NO_FALLBACK_FOR_MOVE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga08edc09a45449b136b27493647d4ecbea8ba81fce89dc9733ef050a366cbc36ce</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_COPY_TARGET_DEFAULT_PERMS</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga08edc09a45449b136b27493647d4ecbea7c03196a0667919cbbbb692058351d80</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>FileMonitorFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga469f795e9a4dddb2421c0e5568be6649</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_MONITOR_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga469f795e9a4dddb2421c0e5568be6649ab14b94920f9dd257f04b8d2089ee7f41</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_MONITOR_WATCH_MOUNTS</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga469f795e9a4dddb2421c0e5568be6649a125f456ecc2055488ae714ae03cafb9e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>MountUnmountFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga9fa1b6a8eabf8f88e4cf6d611a4cff44</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MOUNT_UNMOUNT_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga9fa1b6a8eabf8f88e4cf6d611a4cff44a30cece3099822da07d5d74cc97fa4ad4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MOUNT_UNMOUNT_FORCE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga9fa1b6a8eabf8f88e4cf6d611a4cff44af26cca6f4bb36f76811bfe7d057459b8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>MountMountFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga5484bace25c932fd4c7354259e138814</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MOUNT_MOUNT_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga5484bace25c932fd4c7354259e138814a4fa5bb6630552f216d543dc14bdce93f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>FileAttributeType</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga5e79fa284e14b18d180741cd1c03d0e2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_ATTRIBUTE_TYPE_INVALID</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga5e79fa284e14b18d180741cd1c03d0e2a8e0404fb81075c7cb1947d391710df6b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_ATTRIBUTE_TYPE_STRING</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga5e79fa284e14b18d180741cd1c03d0e2a42aaefaf1350bc75f0c59232f5427a00</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_ATTRIBUTE_TYPE_BYTE_STRING</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga5e79fa284e14b18d180741cd1c03d0e2a1b5ce4388a50031998a766297c6809b3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_ATTRIBUTE_TYPE_BOOLEAN</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga5e79fa284e14b18d180741cd1c03d0e2a4ee1a4a4232372cc3ee901c60b04252b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_ATTRIBUTE_TYPE_UINT32</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga5e79fa284e14b18d180741cd1c03d0e2a1e05d09eec38684188623c5d66c80adc</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_ATTRIBUTE_TYPE_INT32</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga5e79fa284e14b18d180741cd1c03d0e2a8610920b627048811f8c83ff68815726</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_ATTRIBUTE_TYPE_UINT64</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga5e79fa284e14b18d180741cd1c03d0e2a6146f4603d261931c170501119ecdf10</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_ATTRIBUTE_TYPE_INT64</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga5e79fa284e14b18d180741cd1c03d0e2a4420e14e2d76c78878480484b4824178</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_ATTRIBUTE_TYPE_OBJECT</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga5e79fa284e14b18d180741cd1c03d0e2abf2a03fdfe8fab868b52e7e2e31681cd</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_ATTRIBUTE_TYPE_STRINGV</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga5e79fa284e14b18d180741cd1c03d0e2a137ca5ab57718ba53c1425d8adb529ab</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>FileAttributeInfoFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga8687b5c14230bb3e46a1df7341941f16</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_ATTRIBUTE_INFO_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga8687b5c14230bb3e46a1df7341941f16a4cfd632fc68ef8907454ebf50e25ddea</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_ATTRIBUTE_INFO_COPY_WITH_FILE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga8687b5c14230bb3e46a1df7341941f16a1f079dce29168aefc78ffb19913a2f56</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_ATTRIBUTE_INFO_COPY_WHEN_MOVED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga8687b5c14230bb3e46a1df7341941f16a31dfc4cee76aa4982b2f0b59df32d8ec</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>FileAttributeStatus</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gae926022c51a79fd117e4bfd100c25b29</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_ATTRIBUTE_STATUS_UNSET</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggae926022c51a79fd117e4bfd100c25b29a7d19f425a83dab27da6d3ad11622a0d5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_ATTRIBUTE_STATUS_SET</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggae926022c51a79fd117e4bfd100c25b29a163950d9d163bc80175e3fa34e917c71</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_ATTRIBUTE_STATUS_ERROR_SETTING</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggae926022c51a79fd117e4bfd100c25b29a146c1891a87c49ee9be95e76a92c3e2e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>FileType</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga7dcba95023d74c47bba3fd0a07f8824c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_TYPE_NOT_KNOWN</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga7dcba95023d74c47bba3fd0a07f8824cac879cd353f56a22f65c3267801953e30</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_TYPE_REGULAR</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga7dcba95023d74c47bba3fd0a07f8824cac07760305b8906edfcf52dbd6f7910d5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_TYPE_DIRECTORY</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga7dcba95023d74c47bba3fd0a07f8824ca681e4e1f442347d50c9b0cd8ca03bb2b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_TYPE_SYMBOLIC_LINK</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga7dcba95023d74c47bba3fd0a07f8824ca08dca91a6a47ea3a139b0c6afb0954c8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_TYPE_SPECIAL</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga7dcba95023d74c47bba3fd0a07f8824ca5fad9f1f4585f8114f830eedea41e7ef</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_TYPE_SHORTCUT</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga7dcba95023d74c47bba3fd0a07f8824cab853c5774004a86eab09106b60046106</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_TYPE_MOUNTABLE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga7dcba95023d74c47bba3fd0a07f8824caa7c0c584a463721afb2f2bb57b27c2ea</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>FileMonitorEvent</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gabd42cf9877b5b6556bb18b7fd6b6dd81</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_MONITOR_EVENT_CHANGED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggabd42cf9877b5b6556bb18b7fd6b6dd81a2fa81d8cdfbb69372e2167267cc6bde8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_MONITOR_EVENT_CHANGES_DONE_HINT</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggabd42cf9877b5b6556bb18b7fd6b6dd81af04e689b125341be3cc8425bed360fb2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_MONITOR_EVENT_DELETED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggabd42cf9877b5b6556bb18b7fd6b6dd81aa99e4d03a648a9b43d43885b76b4db82</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_MONITOR_EVENT_CREATED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggabd42cf9877b5b6556bb18b7fd6b6dd81a946dcf9aeeb8d22fb9631a912aeac751</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_MONITOR_EVENT_ATTRIBUTE_CHANGED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggabd42cf9877b5b6556bb18b7fd6b6dd81a0b265fec915bf4d5ce4547c8645d4b8e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_MONITOR_EVENT_PRE_UNMOUNT</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggabd42cf9877b5b6556bb18b7fd6b6dd81a9a904f978d9e725f84e12cc276faddae</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_MONITOR_EVENT_UNMOUNTED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggabd42cf9877b5b6556bb18b7fd6b6dd81a4e75e84f300f88c83e4a1b301e146a86</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>AskPasswordFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gac807da73d3b89a6dc16dad028244e6ec</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ASK_PASSWORD_NEED_PASSWORD</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggac807da73d3b89a6dc16dad028244e6ecad72247e662c964b1f34673a2a9dac864</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ASK_PASSWORD_NEED_USERNAME</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggac807da73d3b89a6dc16dad028244e6eca9176d669bd3832b47af7938ef2ab97da</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ASK_PASSWORD_NEED_DOMAIN</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggac807da73d3b89a6dc16dad028244e6ecaae4ff232f33015b669577b05c275ac64</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ASK_PASSWORD_SAVING_SUPPORTED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggac807da73d3b89a6dc16dad028244e6ecad9bf425560cd436e897cbdd1a7326673</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ASK_PASSWORD_ANONYMOUS_SUPPORTED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggac807da73d3b89a6dc16dad028244e6ecab54fea4ff83c960b28733ed9576b9ae7</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>PasswordSave</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gafec517575c8f8d6f48433c86da52448f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PASSWORD_SAVE_NEVER</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggafec517575c8f8d6f48433c86da52448fae6580664da5e48500434f40e24bcd77d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PASSWORD_SAVE_FOR_SESSION</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggafec517575c8f8d6f48433c86da52448fa9d5e5d263f2bfcdce02dfb8f25efb411</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PASSWORD_SAVE_PERMANENTLY</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggafec517575c8f8d6f48433c86da52448fa9f15426c23241e58661b559b12276323</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>MountOperationResult</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gac479310f8df4ad5909d717caec261076</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MOUNT_OPERATION_HANDLED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggac479310f8df4ad5909d717caec261076ad8feb3f3ff8deb01bb211593ea0c4f92</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MOUNT_OPERATION_ABORTED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggac479310f8df4ad5909d717caec261076ab5edd0f1001b94ee66b725fb6425e7c3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MOUNT_OPERATION_UNHANDLED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggac479310f8df4ad5909d717caec261076a2c4507658069f86a1ef208a0967c9aa9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>OutputStreamSpliceFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga7c30d67e5f60d33fdcd3053123feea74</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>OUTPUT_STREAM_SPLICE_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga7c30d67e5f60d33fdcd3053123feea74a876a19654c7cb1019edd78cffe3afe7d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>OUTPUT_STREAM_SPLICE_CLOSE_SOURCE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga7c30d67e5f60d33fdcd3053123feea74abd49ddb3a5960d177ae417c5d12271e6</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>OUTPUT_STREAM_SPLICE_CLOSE_TARGET</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga7c30d67e5f60d33fdcd3053123feea74a9db82f2020730fac9daa9acb5e7b57ef</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>SocketType</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga2302a45e052658e343729e0be2fd3310</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_TYPE_INVALID</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga2302a45e052658e343729e0be2fd3310af00948af66fed3af5d79f488132ec25f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_TYPE_STREAM</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga2302a45e052658e343729e0be2fd3310a449568cb50c6f759abbbccb633bbb266</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_TYPE_DATAGRAM</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga2302a45e052658e343729e0be2fd3310a7993070a3b3641e7da05c984ee08c8c0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_TYPE_SEQPACKET</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga2302a45e052658e343729e0be2fd3310a0395a0a66018835d7b4e07d68c731002</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>SocketProtocol</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga4e8932017a600fffa5e8e6b5f6ea5b16</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_PROTOCOL_UNKNOWN</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga4e8932017a600fffa5e8e6b5f6ea5b16a91f25c6679ad3343806e22be00be76d3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_PROTOCOL_DEFAULT</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga4e8932017a600fffa5e8e6b5f6ea5b16a1d6e5ce50037a49690304ba884287172</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_PROTOCOL_TCP</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga4e8932017a600fffa5e8e6b5f6ea5b16a369c33c8920f267e70d3e3a52022267e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_PROTOCOL_UDP</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga4e8932017a600fffa5e8e6b5f6ea5b16a5b2d9d1efcdedddf53020cc15646b82f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_PROTOCOL_SCTP</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga4e8932017a600fffa5e8e6b5f6ea5b16ae91b17d6dc2e813157474586fd2cc697</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>SocketMsgFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga11f5e6b2ba2903428e93d947c82fa04e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_MSG_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga11f5e6b2ba2903428e93d947c82fa04ea42d10ab5264669fd457d89aec658534b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_MSG_OOB</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga11f5e6b2ba2903428e93d947c82fa04eadabfe2785d08635e7a452b5ed9a0ad90</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_MSG_PEEK</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga11f5e6b2ba2903428e93d947c82fa04eafc3b9cd1274817ab778671fef134998e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_MSG_DONTROUTE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga11f5e6b2ba2903428e93d947c82fa04ea19c8b9aa25981e200a297b25bf7d8e05</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>AppInfoCreateFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gac2ae439cef63de06f97ed8454b67ec32</anchor>
      <arglist>(AppInfoCreateFlags lhs, AppInfoCreateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AppInfoCreateFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga1f0f1235c25f5552c8a1467697bd66d3</anchor>
      <arglist>(AppInfoCreateFlags lhs, AppInfoCreateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AppInfoCreateFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga9f582e5773b615c406ceb28b695b7015</anchor>
      <arglist>(AppInfoCreateFlags lhs, AppInfoCreateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AppInfoCreateFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga302df8457f421e75eaea25a67cb63c19</anchor>
      <arglist>(AppInfoCreateFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>AppInfoCreateFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaccda1b3df9583689a62a3add6715f640</anchor>
      <arglist>(AppInfoCreateFlags &amp;lhs, AppInfoCreateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AppInfoCreateFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga179d7c2a3d709c7a8e4a0796a8b5e833</anchor>
      <arglist>(AppInfoCreateFlags &amp;lhs, AppInfoCreateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AppInfoCreateFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga5dac484830e37250c0942325fb4b85a3</anchor>
      <arglist>(AppInfoCreateFlags &amp;lhs, AppInfoCreateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileQueryInfoFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaba7574ea0b336541af125d4eb9423088</anchor>
      <arglist>(FileQueryInfoFlags lhs, FileQueryInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileQueryInfoFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gafd57fe410ba970bb3cb78eb1c9942aeb</anchor>
      <arglist>(FileQueryInfoFlags lhs, FileQueryInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileQueryInfoFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gacae77e10133f304081534efa76be4a52</anchor>
      <arglist>(FileQueryInfoFlags lhs, FileQueryInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileQueryInfoFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga42422c40ea08ec4f0ad74c8e2a657eb5</anchor>
      <arglist>(FileQueryInfoFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>FileQueryInfoFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gac59d6f3b6a2adca24d2763ba2af99a02</anchor>
      <arglist>(FileQueryInfoFlags &amp;lhs, FileQueryInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileQueryInfoFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga203c5d02679e3aa4c78080fb9269b1f9</anchor>
      <arglist>(FileQueryInfoFlags &amp;lhs, FileQueryInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileQueryInfoFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga55adc6ecb3a15cb850b30bafb7eb9248</anchor>
      <arglist>(FileQueryInfoFlags &amp;lhs, FileQueryInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileCreateFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga431f17ab67ccea562ea556c10df6bd27</anchor>
      <arglist>(FileCreateFlags lhs, FileCreateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileCreateFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga4a52dbf7b71137a0d00ef49c0eb163a6</anchor>
      <arglist>(FileCreateFlags lhs, FileCreateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileCreateFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gab4d3e010c78b9f5ca2673210269b999d</anchor>
      <arglist>(FileCreateFlags lhs, FileCreateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileCreateFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga703109997bbde3b6a686dd36ec9d35ad</anchor>
      <arglist>(FileCreateFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>FileCreateFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga4f6ed1c3e6f2a3a7d394b62f3166df7a</anchor>
      <arglist>(FileCreateFlags &amp;lhs, FileCreateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileCreateFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga43d71b19c0e673331de89e1b1d84679b</anchor>
      <arglist>(FileCreateFlags &amp;lhs, FileCreateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileCreateFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga045123aaa65f69e2a76a488d1024e34d</anchor>
      <arglist>(FileCreateFlags &amp;lhs, FileCreateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileCopyFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga0b841b27ceceb381f08e1bc5cf929eb1</anchor>
      <arglist>(FileCopyFlags lhs, FileCopyFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileCopyFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gabb1d7757198076b221ba038b1d3ae841</anchor>
      <arglist>(FileCopyFlags lhs, FileCopyFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileCopyFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga29b016e93e7a6dfdebc4f9f6e4fbf1c1</anchor>
      <arglist>(FileCopyFlags lhs, FileCopyFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileCopyFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga70312f36423a73fbf663c64824631dc8</anchor>
      <arglist>(FileCopyFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>FileCopyFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gabb9c03e9bbf1ef698696dc08b0d36371</anchor>
      <arglist>(FileCopyFlags &amp;lhs, FileCopyFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileCopyFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gad2f22009032ff6f0975c5a5701ca061d</anchor>
      <arglist>(FileCopyFlags &amp;lhs, FileCopyFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileCopyFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga514b3929469585c9cfc222ef2daf4fea</anchor>
      <arglist>(FileCopyFlags &amp;lhs, FileCopyFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileMonitorFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gab3fab04e51aeff08aaf235f038e50d72</anchor>
      <arglist>(FileMonitorFlags lhs, FileMonitorFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileMonitorFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaf801bc2b57ef5136eba961cdcd68e2e6</anchor>
      <arglist>(FileMonitorFlags lhs, FileMonitorFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileMonitorFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga81b5df359bd6a61df867af8274d182ae</anchor>
      <arglist>(FileMonitorFlags lhs, FileMonitorFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileMonitorFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga501c69e3e5101b66d2e5fb8181229b2c</anchor>
      <arglist>(FileMonitorFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>FileMonitorFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga8af51d7b4e7b78d3f0153090674470aa</anchor>
      <arglist>(FileMonitorFlags &amp;lhs, FileMonitorFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileMonitorFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gae45bc889f678f9f87ff04596b0de7d1a</anchor>
      <arglist>(FileMonitorFlags &amp;lhs, FileMonitorFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileMonitorFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaffa032f65b2c0270e12fe6bafa5c36bf</anchor>
      <arglist>(FileMonitorFlags &amp;lhs, FileMonitorFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MountUnmountFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga42e2925c2e192eb3e9b71b727e676644</anchor>
      <arglist>(MountUnmountFlags lhs, MountUnmountFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MountUnmountFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga9ab823e8ba96b485774da1e93c7e576f</anchor>
      <arglist>(MountUnmountFlags lhs, MountUnmountFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MountUnmountFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga76909c76363248e860a94b20dad18ad9</anchor>
      <arglist>(MountUnmountFlags lhs, MountUnmountFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MountUnmountFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gace7018ee540582a709530dce1dd9191a</anchor>
      <arglist>(MountUnmountFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>MountUnmountFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga2d1ab6ef14833802a3615e54b8115aa8</anchor>
      <arglist>(MountUnmountFlags &amp;lhs, MountUnmountFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MountUnmountFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gae1e6af7ffa613a35d110daedd6671389</anchor>
      <arglist>(MountUnmountFlags &amp;lhs, MountUnmountFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MountUnmountFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga6a939c0dc5f5b25dbad5cdb7a1848184</anchor>
      <arglist>(MountUnmountFlags &amp;lhs, MountUnmountFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileAttributeInfoFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga3779f0623bf9380fb656028b9bc88323</anchor>
      <arglist>(FileAttributeInfoFlags lhs, FileAttributeInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileAttributeInfoFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga31f3ea9c0f0f3b94b829cff51a483da3</anchor>
      <arglist>(FileAttributeInfoFlags lhs, FileAttributeInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileAttributeInfoFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gade49ce26dfa73eb2eb9fc56534ac1319</anchor>
      <arglist>(FileAttributeInfoFlags lhs, FileAttributeInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileAttributeInfoFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga9150f4358ab779fd1267151c4ee84a46</anchor>
      <arglist>(FileAttributeInfoFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>FileAttributeInfoFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gadebdfefd85c32a1b626bce9ae251138b</anchor>
      <arglist>(FileAttributeInfoFlags &amp;lhs, FileAttributeInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileAttributeInfoFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga4d263feb91a513421902169e234bb8c3</anchor>
      <arglist>(FileAttributeInfoFlags &amp;lhs, FileAttributeInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileAttributeInfoFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaf8c86d142fcb81426bc429d51da4f7d9</anchor>
      <arglist>(FileAttributeInfoFlags &amp;lhs, FileAttributeInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AskPasswordFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gab444ed2fbe1877464f469a64d9107e36</anchor>
      <arglist>(AskPasswordFlags lhs, AskPasswordFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AskPasswordFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga8a45caccd402223c595e5a160f15f030</anchor>
      <arglist>(AskPasswordFlags lhs, AskPasswordFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AskPasswordFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaf0b37f457e38844832549486982ed1d8</anchor>
      <arglist>(AskPasswordFlags lhs, AskPasswordFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AskPasswordFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga993dba04647b8f34ad72e86cbc88ba34</anchor>
      <arglist>(AskPasswordFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>AskPasswordFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga01e87fab2e1906ac5eafa153747ceae9</anchor>
      <arglist>(AskPasswordFlags &amp;lhs, AskPasswordFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AskPasswordFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga90dc37e16010e611eed712a21ee0a787</anchor>
      <arglist>(AskPasswordFlags &amp;lhs, AskPasswordFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AskPasswordFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga8e3411a2fa7d7f016953b5f84dbad4c1</anchor>
      <arglist>(AskPasswordFlags &amp;lhs, AskPasswordFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>OutputStreamSpliceFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaef500d088ea9d123dc514f71c4c67b1d</anchor>
      <arglist>(OutputStreamSpliceFlags lhs, OutputStreamSpliceFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>OutputStreamSpliceFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga39f9583f05c94f16ce6228b52663e4e4</anchor>
      <arglist>(OutputStreamSpliceFlags lhs, OutputStreamSpliceFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>OutputStreamSpliceFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga14a79b6dee4f711a22b52bf259539e34</anchor>
      <arglist>(OutputStreamSpliceFlags lhs, OutputStreamSpliceFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>OutputStreamSpliceFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gafcded381df7535fe7c41bb8f8c21c169</anchor>
      <arglist>(OutputStreamSpliceFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>OutputStreamSpliceFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga5602d53794a62a9e823005e6f9aed428</anchor>
      <arglist>(OutputStreamSpliceFlags &amp;lhs, OutputStreamSpliceFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>OutputStreamSpliceFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gab363845e9d7769f38c78dc7cc55d9db6</anchor>
      <arglist>(OutputStreamSpliceFlags &amp;lhs, OutputStreamSpliceFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>OutputStreamSpliceFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga01f192f0f1b9f66047d603780c458e6e</anchor>
      <arglist>(OutputStreamSpliceFlags &amp;lhs, OutputStreamSpliceFlags rhs)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ChecksumType</name>
    <filename>classChecksumType.html</filename>
  </compound>
  <compound kind="namespace">
    <name>Gio</name>
    <filename>namespaceGio.html</filename>
    <class kind="class">Gio::AppLaunchContext</class>
    <class kind="class">Gio::AppInfo</class>
    <class kind="class">Gio::AsyncResult</class>
    <class kind="class">Gio::BufferedInputStream</class>
    <class kind="class">Gio::BufferedOutputStream</class>
    <class kind="class">Gio::Cancellable</class>
    <class kind="class">Gio::DataInputStream</class>
    <class kind="class">Gio::DataOutputStream</class>
    <class kind="class">Gio::Drive</class>
    <class kind="class">Gio::Emblem</class>
    <class kind="class">Gio::EmblemedIcon</class>
    <class kind="class">Gio::Error</class>
    <class kind="class">Gio::File</class>
    <class kind="class">Gio::FileAttributeInfo</class>
    <class kind="class">Gio::FileAttributeInfoList</class>
    <class kind="class">Gio::FileEnumerator</class>
    <class kind="class">Gio::FileIcon</class>
    <class kind="class">Gio::FileAttributeMatcher</class>
    <class kind="class">Gio::FileInfo</class>
    <class kind="class">Gio::FileInputStream</class>
    <class kind="class">Gio::FileIOStream</class>
    <class kind="class">Gio::FileMonitor</class>
    <class kind="class">Gio::FilenameCompleter</class>
    <class kind="class">Gio::FileOutputStream</class>
    <class kind="class">Gio::FilterInputStream</class>
    <class kind="class">Gio::FilterOutputStream</class>
    <class kind="class">Gio::Icon</class>
    <class kind="class">Gio::InetAddress</class>
    <class kind="class">Gio::InetSocketAddress</class>
    <class kind="class">Gio::Initable</class>
    <class kind="class">Gio::InputStream</class>
    <class kind="class">Gio::IOStream</class>
    <class kind="class">Gio::LoadableIcon</class>
    <class kind="class">Gio::MemoryInputStream</class>
    <class kind="class">Gio::MemoryOutputStream</class>
    <class kind="class">Gio::Mount</class>
    <class kind="class">Gio::MountOperation</class>
    <class kind="class">Gio::NetworkAddress</class>
    <class kind="class">Gio::NetworkService</class>
    <class kind="class">Gio::OutputStream</class>
    <class kind="class">Gio::Resolver</class>
    <class kind="class">Gio::Seekable</class>
    <class kind="class">Gio::Socket</class>
    <class kind="class">Gio::SocketAddress</class>
    <class kind="class">Gio::SocketAddressEnumerator</class>
    <class kind="class">Gio::SocketConnectable</class>
    <class kind="class">Gio::SrvTarget</class>
    <class kind="class">Gio::ThemedIcon</class>
    <class kind="class">Gio::Volume</class>
    <class kind="class">Gio::VolumeMonitor</class>
    <class kind="class">Gio::DesktopAppInfo</class>
    <class kind="class">Gio::UnixInputStream</class>
    <class kind="class">Gio::UnixOutputStream</class>
    <member kind="typedef">
      <type>sigc::slot&lt; void, Glib::RefPtr&lt; AsyncResult &gt; &amp; &gt;</type>
      <name>SlotAsyncReady</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>aecaa02709f9ab83fa2b36d2571665cbe</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Glib::ListHandle&lt; Gio::SrvTarget, SrvTargetListTraits &gt;</type>
      <name>ListHandle_SrvTarget</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>a1b4ed5afd24e359d3ba6bde02c9e90be</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>AppInfoCreateFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gae39c1e25f40a070e1720470758a55344</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>APP_INFO_CREATE_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggae39c1e25f40a070e1720470758a55344af71f654bb54f7e68263da28fc5eccacd</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>APP_INFO_CREATE_NEEDS_TERMINAL</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggae39c1e25f40a070e1720470758a55344a01421973a2522b9e2ac7672c03468e8f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>APP_INFO_CREATE_SUPPORTS_URIS</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggae39c1e25f40a070e1720470758a55344aef4faf5deef3c2e3eec96cefd9feeafc</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>DriveStartFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gab628e70b1d028b3bc9b02b0d3b8acf2d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DRIVE_START_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggab628e70b1d028b3bc9b02b0d3b8acf2da6a46299fc0a721de0bed46063ba484de</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>DriveStartStopType</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga148d2356238c5c8f809dcbd58341cc2d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DRIVE_START_STOP_TYPE_UNKNOWN</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga148d2356238c5c8f809dcbd58341cc2da01961d00b61f87fb25ba3001a042db5b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DRIVE_START_STOP_TYPE_SHUTDOWN</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga148d2356238c5c8f809dcbd58341cc2da59acd7106146af052b9bc164ac85d1d4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DRIVE_START_STOP_TYPE_NETWORK</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga148d2356238c5c8f809dcbd58341cc2da24f499a4eee0fb59870d42089fc8cc38</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DRIVE_START_STOP_TYPE_MULTIDISK</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga148d2356238c5c8f809dcbd58341cc2da7f6a48659447fa2b3b0c1c9d0520e2ae</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DRIVE_START_STOP_TYPE_PASSWORD</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga148d2356238c5c8f809dcbd58341cc2daf1a4c886e6d77d3a1f3d8b864a536da5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>EmblemOrigin</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga7f2c8f757fdeb91ca48c0bc8184f9270</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EMBLEM_ORIGIN_UNKNOWN</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga7f2c8f757fdeb91ca48c0bc8184f9270a8f8b573b5755138f1da852121c33027d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EMBLEM_ORIGIN_DEVICE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga7f2c8f757fdeb91ca48c0bc8184f9270a6bcc4f7fda6aee37062db66a6abe66c2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EMBLEM_ORIGIN_LIVEMETADATA</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga7f2c8f757fdeb91ca48c0bc8184f9270a746b49f22653188190760d6724f00c03</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EMBLEM_ORIGIN_TAG</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga7f2c8f757fdeb91ca48c0bc8184f9270a8ca854f52478785f462472c706aefa2b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>DataStreamByteOrder</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga87dea9b56fed9c0bca0f8426fb57781e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DATA_STREAM_BYTE_ORDER_BIG_ENDIAN</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga87dea9b56fed9c0bca0f8426fb57781ea18117d3d82013605e0200837278b61ce</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DATA_STREAM_BYTE_ORDER_LITTLE_ENDIAN</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga87dea9b56fed9c0bca0f8426fb57781ead7d652c4c3be181175e6b3ce0b8a6b6d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DATA_STREAM_BYTE_ORDER_HOST_ENDIAN</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga87dea9b56fed9c0bca0f8426fb57781ea4ee0fe7768cdcaa1bfe30a866e597fe5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>DataStreamNewlineType</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga2de111fe308aff763fb98a39bc507267</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DATA_STREAM_NEWLINE_TYPE_LF</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga2de111fe308aff763fb98a39bc507267a2984664a935bd2803f9f8efb525ab1ab</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DATA_STREAM_NEWLINE_TYPE_CR</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga2de111fe308aff763fb98a39bc507267a684a76a8c6470952cf17935c0e6d4c85</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DATA_STREAM_NEWLINE_TYPE_CR_LF</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga2de111fe308aff763fb98a39bc507267a668ad4c9993ae7201cad988ccb9f9265</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DATA_STREAM_NEWLINE_TYPE_ANY</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga2de111fe308aff763fb98a39bc507267a07aa934ff2e202ae347600466895d634</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>SocketFamily</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga0ba69e14ad979bf9b2073ad122e38d48</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_FAMILY_INVALID</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0ba69e14ad979bf9b2073ad122e38d48a287dfaac297cc0158f78d7d62949ccaa</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_FAMILY_IPV6</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0ba69e14ad979bf9b2073ad122e38d48a8077081b5558ee5a35497749c4f4901c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>FileQueryInfoFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga2cb7bdea61353f0999607785abd032c0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_QUERY_INFO_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga2cb7bdea61353f0999607785abd032c0a25937649b891bc6e25fd3b102e961fa0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_QUERY_INFO_NOFOLLOW_SYMLINKS</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga2cb7bdea61353f0999607785abd032c0a111136a309875440d7b9a065e9d413fc</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>FileCreateFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga500a44e123fd4c578f8af9ddef2f7601</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_CREATE_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga500a44e123fd4c578f8af9ddef2f7601aa91626c845b45a4432c5c5be9f62db63</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_CREATE_PRIVATE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga500a44e123fd4c578f8af9ddef2f7601a561d151d8be5524e68d0316baa6b3346</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_CREATE_REPLACE_DESTINATION</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga500a44e123fd4c578f8af9ddef2f7601aa1edf0c05c6e4c84340200dcb4b981bf</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>FileCopyFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga08edc09a45449b136b27493647d4ecbe</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_COPY_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga08edc09a45449b136b27493647d4ecbea2de95276b80f5261e9de761e98987273</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_COPY_OVERWRITE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga08edc09a45449b136b27493647d4ecbeaa739f5a86205d73bc68ef06e59943b0a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_COPY_BACKUP</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga08edc09a45449b136b27493647d4ecbeae4bdca31f92ed16bc4fbdcfed03f51d3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_COPY_NOFOLLOW_SYMLINKS</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga08edc09a45449b136b27493647d4ecbea28d4e03c13c33cc8ee846dd74720b8c2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_COPY_ALL_METADATA</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga08edc09a45449b136b27493647d4ecbea1a0416eaa1df264399127dcfc8787cb3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_COPY_NO_FALLBACK_FOR_MOVE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga08edc09a45449b136b27493647d4ecbea8ba81fce89dc9733ef050a366cbc36ce</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_COPY_TARGET_DEFAULT_PERMS</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga08edc09a45449b136b27493647d4ecbea7c03196a0667919cbbbb692058351d80</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>FileMonitorFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga469f795e9a4dddb2421c0e5568be6649</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_MONITOR_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga469f795e9a4dddb2421c0e5568be6649ab14b94920f9dd257f04b8d2089ee7f41</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_MONITOR_WATCH_MOUNTS</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga469f795e9a4dddb2421c0e5568be6649a125f456ecc2055488ae714ae03cafb9e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>MountUnmountFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga9fa1b6a8eabf8f88e4cf6d611a4cff44</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MOUNT_UNMOUNT_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga9fa1b6a8eabf8f88e4cf6d611a4cff44a30cece3099822da07d5d74cc97fa4ad4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MOUNT_UNMOUNT_FORCE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga9fa1b6a8eabf8f88e4cf6d611a4cff44af26cca6f4bb36f76811bfe7d057459b8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>MountMountFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga5484bace25c932fd4c7354259e138814</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MOUNT_MOUNT_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga5484bace25c932fd4c7354259e138814a4fa5bb6630552f216d543dc14bdce93f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>FileAttributeType</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga5e79fa284e14b18d180741cd1c03d0e2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_ATTRIBUTE_TYPE_INVALID</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga5e79fa284e14b18d180741cd1c03d0e2a8e0404fb81075c7cb1947d391710df6b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_ATTRIBUTE_TYPE_STRING</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga5e79fa284e14b18d180741cd1c03d0e2a42aaefaf1350bc75f0c59232f5427a00</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_ATTRIBUTE_TYPE_BYTE_STRING</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga5e79fa284e14b18d180741cd1c03d0e2a1b5ce4388a50031998a766297c6809b3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_ATTRIBUTE_TYPE_BOOLEAN</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga5e79fa284e14b18d180741cd1c03d0e2a4ee1a4a4232372cc3ee901c60b04252b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_ATTRIBUTE_TYPE_UINT32</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga5e79fa284e14b18d180741cd1c03d0e2a1e05d09eec38684188623c5d66c80adc</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_ATTRIBUTE_TYPE_INT32</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga5e79fa284e14b18d180741cd1c03d0e2a8610920b627048811f8c83ff68815726</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_ATTRIBUTE_TYPE_UINT64</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga5e79fa284e14b18d180741cd1c03d0e2a6146f4603d261931c170501119ecdf10</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_ATTRIBUTE_TYPE_INT64</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga5e79fa284e14b18d180741cd1c03d0e2a4420e14e2d76c78878480484b4824178</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_ATTRIBUTE_TYPE_OBJECT</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga5e79fa284e14b18d180741cd1c03d0e2abf2a03fdfe8fab868b52e7e2e31681cd</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_ATTRIBUTE_TYPE_STRINGV</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga5e79fa284e14b18d180741cd1c03d0e2a137ca5ab57718ba53c1425d8adb529ab</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>FileAttributeInfoFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga8687b5c14230bb3e46a1df7341941f16</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_ATTRIBUTE_INFO_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga8687b5c14230bb3e46a1df7341941f16a4cfd632fc68ef8907454ebf50e25ddea</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_ATTRIBUTE_INFO_COPY_WITH_FILE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga8687b5c14230bb3e46a1df7341941f16a1f079dce29168aefc78ffb19913a2f56</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_ATTRIBUTE_INFO_COPY_WHEN_MOVED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga8687b5c14230bb3e46a1df7341941f16a31dfc4cee76aa4982b2f0b59df32d8ec</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>FileAttributeStatus</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gae926022c51a79fd117e4bfd100c25b29</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_ATTRIBUTE_STATUS_UNSET</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggae926022c51a79fd117e4bfd100c25b29a7d19f425a83dab27da6d3ad11622a0d5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_ATTRIBUTE_STATUS_SET</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggae926022c51a79fd117e4bfd100c25b29a163950d9d163bc80175e3fa34e917c71</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_ATTRIBUTE_STATUS_ERROR_SETTING</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggae926022c51a79fd117e4bfd100c25b29a146c1891a87c49ee9be95e76a92c3e2e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>FileType</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga7dcba95023d74c47bba3fd0a07f8824c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_TYPE_NOT_KNOWN</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga7dcba95023d74c47bba3fd0a07f8824cac879cd353f56a22f65c3267801953e30</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_TYPE_REGULAR</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga7dcba95023d74c47bba3fd0a07f8824cac07760305b8906edfcf52dbd6f7910d5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_TYPE_DIRECTORY</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga7dcba95023d74c47bba3fd0a07f8824ca681e4e1f442347d50c9b0cd8ca03bb2b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_TYPE_SYMBOLIC_LINK</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga7dcba95023d74c47bba3fd0a07f8824ca08dca91a6a47ea3a139b0c6afb0954c8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_TYPE_SPECIAL</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga7dcba95023d74c47bba3fd0a07f8824ca5fad9f1f4585f8114f830eedea41e7ef</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_TYPE_SHORTCUT</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga7dcba95023d74c47bba3fd0a07f8824cab853c5774004a86eab09106b60046106</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_TYPE_MOUNTABLE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga7dcba95023d74c47bba3fd0a07f8824caa7c0c584a463721afb2f2bb57b27c2ea</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>FileMonitorEvent</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gabd42cf9877b5b6556bb18b7fd6b6dd81</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_MONITOR_EVENT_CHANGED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggabd42cf9877b5b6556bb18b7fd6b6dd81a2fa81d8cdfbb69372e2167267cc6bde8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_MONITOR_EVENT_CHANGES_DONE_HINT</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggabd42cf9877b5b6556bb18b7fd6b6dd81af04e689b125341be3cc8425bed360fb2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_MONITOR_EVENT_DELETED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggabd42cf9877b5b6556bb18b7fd6b6dd81aa99e4d03a648a9b43d43885b76b4db82</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_MONITOR_EVENT_CREATED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggabd42cf9877b5b6556bb18b7fd6b6dd81a946dcf9aeeb8d22fb9631a912aeac751</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_MONITOR_EVENT_ATTRIBUTE_CHANGED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggabd42cf9877b5b6556bb18b7fd6b6dd81a0b265fec915bf4d5ce4547c8645d4b8e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_MONITOR_EVENT_PRE_UNMOUNT</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggabd42cf9877b5b6556bb18b7fd6b6dd81a9a904f978d9e725f84e12cc276faddae</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_MONITOR_EVENT_UNMOUNTED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggabd42cf9877b5b6556bb18b7fd6b6dd81a4e75e84f300f88c83e4a1b301e146a86</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>AskPasswordFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gac807da73d3b89a6dc16dad028244e6ec</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ASK_PASSWORD_NEED_PASSWORD</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggac807da73d3b89a6dc16dad028244e6ecad72247e662c964b1f34673a2a9dac864</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ASK_PASSWORD_NEED_USERNAME</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggac807da73d3b89a6dc16dad028244e6eca9176d669bd3832b47af7938ef2ab97da</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ASK_PASSWORD_NEED_DOMAIN</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggac807da73d3b89a6dc16dad028244e6ecaae4ff232f33015b669577b05c275ac64</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ASK_PASSWORD_SAVING_SUPPORTED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggac807da73d3b89a6dc16dad028244e6ecad9bf425560cd436e897cbdd1a7326673</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ASK_PASSWORD_ANONYMOUS_SUPPORTED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggac807da73d3b89a6dc16dad028244e6ecab54fea4ff83c960b28733ed9576b9ae7</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>PasswordSave</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gafec517575c8f8d6f48433c86da52448f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PASSWORD_SAVE_NEVER</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggafec517575c8f8d6f48433c86da52448fae6580664da5e48500434f40e24bcd77d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PASSWORD_SAVE_FOR_SESSION</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggafec517575c8f8d6f48433c86da52448fa9d5e5d263f2bfcdce02dfb8f25efb411</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PASSWORD_SAVE_PERMANENTLY</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggafec517575c8f8d6f48433c86da52448fa9f15426c23241e58661b559b12276323</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>MountOperationResult</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gac479310f8df4ad5909d717caec261076</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MOUNT_OPERATION_HANDLED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggac479310f8df4ad5909d717caec261076ad8feb3f3ff8deb01bb211593ea0c4f92</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MOUNT_OPERATION_ABORTED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggac479310f8df4ad5909d717caec261076ab5edd0f1001b94ee66b725fb6425e7c3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MOUNT_OPERATION_UNHANDLED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggac479310f8df4ad5909d717caec261076a2c4507658069f86a1ef208a0967c9aa9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>OutputStreamSpliceFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga7c30d67e5f60d33fdcd3053123feea74</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>OUTPUT_STREAM_SPLICE_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga7c30d67e5f60d33fdcd3053123feea74a876a19654c7cb1019edd78cffe3afe7d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>OUTPUT_STREAM_SPLICE_CLOSE_SOURCE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga7c30d67e5f60d33fdcd3053123feea74abd49ddb3a5960d177ae417c5d12271e6</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>OUTPUT_STREAM_SPLICE_CLOSE_TARGET</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga7c30d67e5f60d33fdcd3053123feea74a9db82f2020730fac9daa9acb5e7b57ef</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>SocketType</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga2302a45e052658e343729e0be2fd3310</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_TYPE_INVALID</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga2302a45e052658e343729e0be2fd3310af00948af66fed3af5d79f488132ec25f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_TYPE_STREAM</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga2302a45e052658e343729e0be2fd3310a449568cb50c6f759abbbccb633bbb266</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_TYPE_DATAGRAM</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga2302a45e052658e343729e0be2fd3310a7993070a3b3641e7da05c984ee08c8c0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_TYPE_SEQPACKET</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga2302a45e052658e343729e0be2fd3310a0395a0a66018835d7b4e07d68c731002</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>SocketProtocol</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga4e8932017a600fffa5e8e6b5f6ea5b16</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_PROTOCOL_UNKNOWN</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga4e8932017a600fffa5e8e6b5f6ea5b16a91f25c6679ad3343806e22be00be76d3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_PROTOCOL_DEFAULT</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga4e8932017a600fffa5e8e6b5f6ea5b16a1d6e5ce50037a49690304ba884287172</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_PROTOCOL_TCP</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga4e8932017a600fffa5e8e6b5f6ea5b16a369c33c8920f267e70d3e3a52022267e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_PROTOCOL_UDP</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga4e8932017a600fffa5e8e6b5f6ea5b16a5b2d9d1efcdedddf53020cc15646b82f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_PROTOCOL_SCTP</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga4e8932017a600fffa5e8e6b5f6ea5b16ae91b17d6dc2e813157474586fd2cc697</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>SocketMsgFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga11f5e6b2ba2903428e93d947c82fa04e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_MSG_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga11f5e6b2ba2903428e93d947c82fa04ea42d10ab5264669fd457d89aec658534b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_MSG_OOB</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga11f5e6b2ba2903428e93d947c82fa04eadabfe2785d08635e7a452b5ed9a0ad90</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_MSG_PEEK</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga11f5e6b2ba2903428e93d947c82fa04eafc3b9cd1274817ab778671fef134998e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_MSG_DONTROUTE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga11f5e6b2ba2903428e93d947c82fa04ea19c8b9aa25981e200a297b25bf7d8e05</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>AppInfoCreateFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gac2ae439cef63de06f97ed8454b67ec32</anchor>
      <arglist>(AppInfoCreateFlags lhs, AppInfoCreateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AppInfoCreateFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga1f0f1235c25f5552c8a1467697bd66d3</anchor>
      <arglist>(AppInfoCreateFlags lhs, AppInfoCreateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AppInfoCreateFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga9f582e5773b615c406ceb28b695b7015</anchor>
      <arglist>(AppInfoCreateFlags lhs, AppInfoCreateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AppInfoCreateFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga302df8457f421e75eaea25a67cb63c19</anchor>
      <arglist>(AppInfoCreateFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>AppInfoCreateFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaccda1b3df9583689a62a3add6715f640</anchor>
      <arglist>(AppInfoCreateFlags &amp;lhs, AppInfoCreateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AppInfoCreateFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga179d7c2a3d709c7a8e4a0796a8b5e833</anchor>
      <arglist>(AppInfoCreateFlags &amp;lhs, AppInfoCreateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AppInfoCreateFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga5dac484830e37250c0942325fb4b85a3</anchor>
      <arglist>(AppInfoCreateFlags &amp;lhs, AppInfoCreateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileQueryInfoFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaba7574ea0b336541af125d4eb9423088</anchor>
      <arglist>(FileQueryInfoFlags lhs, FileQueryInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileQueryInfoFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gafd57fe410ba970bb3cb78eb1c9942aeb</anchor>
      <arglist>(FileQueryInfoFlags lhs, FileQueryInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileQueryInfoFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gacae77e10133f304081534efa76be4a52</anchor>
      <arglist>(FileQueryInfoFlags lhs, FileQueryInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileQueryInfoFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga42422c40ea08ec4f0ad74c8e2a657eb5</anchor>
      <arglist>(FileQueryInfoFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>FileQueryInfoFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gac59d6f3b6a2adca24d2763ba2af99a02</anchor>
      <arglist>(FileQueryInfoFlags &amp;lhs, FileQueryInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileQueryInfoFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga203c5d02679e3aa4c78080fb9269b1f9</anchor>
      <arglist>(FileQueryInfoFlags &amp;lhs, FileQueryInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileQueryInfoFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga55adc6ecb3a15cb850b30bafb7eb9248</anchor>
      <arglist>(FileQueryInfoFlags &amp;lhs, FileQueryInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileCreateFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga431f17ab67ccea562ea556c10df6bd27</anchor>
      <arglist>(FileCreateFlags lhs, FileCreateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileCreateFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga4a52dbf7b71137a0d00ef49c0eb163a6</anchor>
      <arglist>(FileCreateFlags lhs, FileCreateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileCreateFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gab4d3e010c78b9f5ca2673210269b999d</anchor>
      <arglist>(FileCreateFlags lhs, FileCreateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileCreateFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga703109997bbde3b6a686dd36ec9d35ad</anchor>
      <arglist>(FileCreateFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>FileCreateFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga4f6ed1c3e6f2a3a7d394b62f3166df7a</anchor>
      <arglist>(FileCreateFlags &amp;lhs, FileCreateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileCreateFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga43d71b19c0e673331de89e1b1d84679b</anchor>
      <arglist>(FileCreateFlags &amp;lhs, FileCreateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileCreateFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga045123aaa65f69e2a76a488d1024e34d</anchor>
      <arglist>(FileCreateFlags &amp;lhs, FileCreateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileCopyFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga0b841b27ceceb381f08e1bc5cf929eb1</anchor>
      <arglist>(FileCopyFlags lhs, FileCopyFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileCopyFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gabb1d7757198076b221ba038b1d3ae841</anchor>
      <arglist>(FileCopyFlags lhs, FileCopyFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileCopyFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga29b016e93e7a6dfdebc4f9f6e4fbf1c1</anchor>
      <arglist>(FileCopyFlags lhs, FileCopyFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileCopyFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga70312f36423a73fbf663c64824631dc8</anchor>
      <arglist>(FileCopyFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>FileCopyFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gabb9c03e9bbf1ef698696dc08b0d36371</anchor>
      <arglist>(FileCopyFlags &amp;lhs, FileCopyFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileCopyFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gad2f22009032ff6f0975c5a5701ca061d</anchor>
      <arglist>(FileCopyFlags &amp;lhs, FileCopyFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileCopyFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga514b3929469585c9cfc222ef2daf4fea</anchor>
      <arglist>(FileCopyFlags &amp;lhs, FileCopyFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileMonitorFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gab3fab04e51aeff08aaf235f038e50d72</anchor>
      <arglist>(FileMonitorFlags lhs, FileMonitorFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileMonitorFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaf801bc2b57ef5136eba961cdcd68e2e6</anchor>
      <arglist>(FileMonitorFlags lhs, FileMonitorFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileMonitorFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga81b5df359bd6a61df867af8274d182ae</anchor>
      <arglist>(FileMonitorFlags lhs, FileMonitorFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileMonitorFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga501c69e3e5101b66d2e5fb8181229b2c</anchor>
      <arglist>(FileMonitorFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>FileMonitorFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga8af51d7b4e7b78d3f0153090674470aa</anchor>
      <arglist>(FileMonitorFlags &amp;lhs, FileMonitorFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileMonitorFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gae45bc889f678f9f87ff04596b0de7d1a</anchor>
      <arglist>(FileMonitorFlags &amp;lhs, FileMonitorFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileMonitorFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaffa032f65b2c0270e12fe6bafa5c36bf</anchor>
      <arglist>(FileMonitorFlags &amp;lhs, FileMonitorFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MountUnmountFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga42e2925c2e192eb3e9b71b727e676644</anchor>
      <arglist>(MountUnmountFlags lhs, MountUnmountFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MountUnmountFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga9ab823e8ba96b485774da1e93c7e576f</anchor>
      <arglist>(MountUnmountFlags lhs, MountUnmountFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MountUnmountFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga76909c76363248e860a94b20dad18ad9</anchor>
      <arglist>(MountUnmountFlags lhs, MountUnmountFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MountUnmountFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gace7018ee540582a709530dce1dd9191a</anchor>
      <arglist>(MountUnmountFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>MountUnmountFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga2d1ab6ef14833802a3615e54b8115aa8</anchor>
      <arglist>(MountUnmountFlags &amp;lhs, MountUnmountFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MountUnmountFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gae1e6af7ffa613a35d110daedd6671389</anchor>
      <arglist>(MountUnmountFlags &amp;lhs, MountUnmountFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MountUnmountFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga6a939c0dc5f5b25dbad5cdb7a1848184</anchor>
      <arglist>(MountUnmountFlags &amp;lhs, MountUnmountFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileAttributeInfoFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga3779f0623bf9380fb656028b9bc88323</anchor>
      <arglist>(FileAttributeInfoFlags lhs, FileAttributeInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileAttributeInfoFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga31f3ea9c0f0f3b94b829cff51a483da3</anchor>
      <arglist>(FileAttributeInfoFlags lhs, FileAttributeInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileAttributeInfoFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gade49ce26dfa73eb2eb9fc56534ac1319</anchor>
      <arglist>(FileAttributeInfoFlags lhs, FileAttributeInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileAttributeInfoFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga9150f4358ab779fd1267151c4ee84a46</anchor>
      <arglist>(FileAttributeInfoFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>FileAttributeInfoFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gadebdfefd85c32a1b626bce9ae251138b</anchor>
      <arglist>(FileAttributeInfoFlags &amp;lhs, FileAttributeInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileAttributeInfoFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga4d263feb91a513421902169e234bb8c3</anchor>
      <arglist>(FileAttributeInfoFlags &amp;lhs, FileAttributeInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileAttributeInfoFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaf8c86d142fcb81426bc429d51da4f7d9</anchor>
      <arglist>(FileAttributeInfoFlags &amp;lhs, FileAttributeInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AskPasswordFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gab444ed2fbe1877464f469a64d9107e36</anchor>
      <arglist>(AskPasswordFlags lhs, AskPasswordFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AskPasswordFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga8a45caccd402223c595e5a160f15f030</anchor>
      <arglist>(AskPasswordFlags lhs, AskPasswordFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AskPasswordFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaf0b37f457e38844832549486982ed1d8</anchor>
      <arglist>(AskPasswordFlags lhs, AskPasswordFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AskPasswordFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga993dba04647b8f34ad72e86cbc88ba34</anchor>
      <arglist>(AskPasswordFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>AskPasswordFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga01e87fab2e1906ac5eafa153747ceae9</anchor>
      <arglist>(AskPasswordFlags &amp;lhs, AskPasswordFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AskPasswordFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga90dc37e16010e611eed712a21ee0a787</anchor>
      <arglist>(AskPasswordFlags &amp;lhs, AskPasswordFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AskPasswordFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga8e3411a2fa7d7f016953b5f84dbad4c1</anchor>
      <arglist>(AskPasswordFlags &amp;lhs, AskPasswordFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>OutputStreamSpliceFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaef500d088ea9d123dc514f71c4c67b1d</anchor>
      <arglist>(OutputStreamSpliceFlags lhs, OutputStreamSpliceFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>OutputStreamSpliceFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga39f9583f05c94f16ce6228b52663e4e4</anchor>
      <arglist>(OutputStreamSpliceFlags lhs, OutputStreamSpliceFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>OutputStreamSpliceFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga14a79b6dee4f711a22b52bf259539e34</anchor>
      <arglist>(OutputStreamSpliceFlags lhs, OutputStreamSpliceFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>OutputStreamSpliceFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gafcded381df7535fe7c41bb8f8c21c169</anchor>
      <arglist>(OutputStreamSpliceFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>OutputStreamSpliceFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga5602d53794a62a9e823005e6f9aed428</anchor>
      <arglist>(OutputStreamSpliceFlags &amp;lhs, OutputStreamSpliceFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>OutputStreamSpliceFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gab363845e9d7769f38c78dc7cc55d9db6</anchor>
      <arglist>(OutputStreamSpliceFlags &amp;lhs, OutputStreamSpliceFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>OutputStreamSpliceFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga01f192f0f1b9f66047d603780c458e6e</anchor>
      <arglist>(OutputStreamSpliceFlags &amp;lhs, OutputStreamSpliceFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>content_type_equals</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>a496c304f10ea79f1a20137bf614466e8</anchor>
      <arglist>(const Glib::ustring &amp;type1, const Glib::ustring &amp;type2)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>content_type_is_a</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>a278fca288c7c2e9995ebb64ce43a6ffd</anchor>
      <arglist>(const Glib::ustring &amp;type, const Glib::ustring &amp;supertype)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>content_type_is_unknown</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>aee153086e7cd9f1ab0509cbf81ec06e9</anchor>
      <arglist>(const Glib::ustring &amp;type)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>content_type_get_description</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ac065cb89d7abb5935cfa225e3d41a732</anchor>
      <arglist>(const Glib::ustring &amp;type)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>content_type_get_mime_type</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>a92f379d45658e14f3ec1bec3da71d908</anchor>
      <arglist>(const Glib::ustring &amp;type)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Icon &gt;</type>
      <name>content_type_get_icon</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>a7972eb82466bf972bbbf5b58f6344e84</anchor>
      <arglist>(const Glib::ustring &amp;type)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>content_type_can_be_executable</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ae5107c4e00134d7d9df3b755a74f9494</anchor>
      <arglist>(const Glib::ustring &amp;type)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>content_type_from_mime_type</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ad5432d8f8c8ba74f8157af9d49930b4c</anchor>
      <arglist>(const Glib::ustring &amp;mime_type)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>content_type_guess</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>a48e8afbb7f1724efcdebd7c028da5560</anchor>
      <arglist>(const std::string &amp;filename, const guchar *data, gsize data_size, bool &amp;result_uncertain)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>content_type_guess</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ae46acc46aa5c33a8d1feda6a675fefa9</anchor>
      <arglist>(const std::string &amp;filename, const std::string &amp;data, bool &amp;result_uncertain)</arglist>
    </member>
    <member kind="function">
      <type>Glib::StringArrayHandle</type>
      <name>content_type_guess_for_tree</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>a7e82e215c402edca50219020e43d08ec</anchor>
      <arglist>(const Glib::RefPtr&lt; const File &gt; &amp;root)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ListHandle&lt; Glib::ustring &gt;</type>
      <name>content_types_get_registered</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>aeae6cd7ee77a7b1c52443116f346b476</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>init</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>a28171d5c1584ce2516ba05b13cee04ec</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::AppLaunchContext</name>
    <filename>classGio_1_1AppLaunchContext.html</filename>
    <base>Glib::Object</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~AppLaunchContext</name>
      <anchorfile>classGio_1_1AppLaunchContext.html</anchorfile>
      <anchor>a11fe8b5d8eb6de7c6d1a19d77d366c98</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GAppLaunchContext *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1AppLaunchContext.html</anchorfile>
      <anchor>a41ed3abab4ad83b765974dfa6cb66067</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GAppLaunchContext *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1AppLaunchContext.html</anchorfile>
      <anchor>aa05603f4fe010e75df7ca950183b9224</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GAppLaunchContext *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1AppLaunchContext.html</anchorfile>
      <anchor>ac14e1569a0a5a81f846c0e11e7109011</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_display</name>
      <anchorfile>classGio_1_1AppLaunchContext.html</anchorfile>
      <anchor>acb9df3c4d0856cf54725a0ec1baf29cb</anchor>
      <arglist>(const Glib::RefPtr&lt; AppInfo &gt; &amp;info, const Glib::ListHandle&lt; Glib::RefPtr&lt; Gio::File &gt; &gt; &amp;files)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_startup_notify_id</name>
      <anchorfile>classGio_1_1AppLaunchContext.html</anchorfile>
      <anchor>ac76a58054fccd2cfc6f3554e1d4b012a</anchor>
      <arglist>(const Glib::RefPtr&lt; AppInfo &gt; &amp;info, const Glib::ListHandle&lt; Glib::RefPtr&lt; Gio::File &gt; &gt; &amp;files)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>launch_failed</name>
      <anchorfile>classGio_1_1AppLaunchContext.html</anchorfile>
      <anchor>aeb5fe002776ad4f040b6be49fa25b46a</anchor>
      <arglist>(const std::string &amp;startup_notify_id)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; AppLaunchContext &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1AppLaunchContext.html</anchorfile>
      <anchor>a9e0b952987932c15f4f8ac7ae6d2e046</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>AppLaunchContext</name>
      <anchorfile>classGio_1_1AppLaunchContext.html</anchorfile>
      <anchor>a04c6b83e39f16c6ae04ad10c387e2cec</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::AppLaunchContext &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1AppLaunchContext.html</anchorfile>
      <anchor>a3cda3d0a285e3ad87f1c94142b04a688</anchor>
      <arglist>(GAppLaunchContext *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::AppInfo</name>
    <filename>classGio_1_1AppInfo.html</filename>
    <base>Glib::Interface</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~AppInfo</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>acf86d510216c430be4735d1f7b13113e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GAppInfo *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>ab31e9bca0208159f0be42227397b8a94</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GAppInfo *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a5e52c62432a61c5380bd5dc553898251</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>equal</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a1803e87dccb051f4fe69cb10277c6c2e</anchor>
      <arglist>(const Glib::RefPtr&lt; AppInfo &gt; &amp;other) const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_id</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a3d929d82e4d7ae91f4d8904f91e7a1c4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_name</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a450c7e5a59919a66f73133749c318987</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_description</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>af7d89372dcf32cc6c25a9545a4ccffa0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_executable</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a06a665d4d812adb2eeb5c05d4c91c266</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_commandline</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>ad389c830c25f58b5ec99d247a3517939</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Icon &gt;</type>
      <name>get_icon</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a35a0c2c10ee787cc5d1d4ac7773bab0d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const Glib::RefPtr&lt; const Icon &gt;</type>
      <name>get_icon</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a16fe789da6c7f5c8c023255b2faff226</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>launch</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a4d5096988eea54e06832325276a78f2a</anchor>
      <arglist>(const Glib::ListHandle&lt; std::string &gt; &amp;files, const Glib::RefPtr&lt; AppLaunchContext &gt; &amp;launch_context)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>supports_uris</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a8bb534c3834b17ff80edb046ba78250e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>supports_files</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a6ba8d06c3f3d99f907ae1aadbd8b24da</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>launch_uris</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a23a6ee89635a2b24468c73f137ad8de4</anchor>
      <arglist>(const Glib::ListHandle&lt; std::string &gt; &amp;uris, GAppLaunchContext *launch_context)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>should_show</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a7b374a9120926615fc7454afab6452e4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>can_delete</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>ae9c4b3e178815a1fbbd60abe69d9e0f9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>do_delete</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a634d024dee3e412df7dc794a280a438e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>set_as_default_for_type</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a59cefa47ef35940d5c0b74a396728808</anchor>
      <arglist>(const std::string &amp;content_type)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>set_as_default_for_extension</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a33b6e19f73a30f1dde7913282aa20aeb</anchor>
      <arglist>(const std::string &amp;extension)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>add_supports_type</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a0dedbcba19457176114948c80efdfbe4</anchor>
      <arglist>(const std::string &amp;content_type)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>can_remove_supports_type</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a150146aaba23bfa208d5c7100d986ee9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>remove_supports_type</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>aa1e9856c39e12c5ad1770299e391b6c0</anchor>
      <arglist>(const std::string &amp;content_type)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>add_interface</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a12bbf2ad90f8915f46c3a49b6354e8ec</anchor>
      <arglist>(GType gtype_implementer)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; AppInfo &gt;</type>
      <name>create_from_commandline</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>ac77db461b3142c9459c8c1a211672bf9</anchor>
      <arglist>(const std::string &amp;commandline, const std::string &amp;application_name, AppInfoCreateFlags flags)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::ListHandle&lt; Glib::RefPtr&lt; AppInfo &gt; &gt;</type>
      <name>get_all</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a21c3fa9bf0f708f3cf52ec38eb837c2e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::ListHandle&lt; Glib::RefPtr&lt; AppInfo &gt; &gt;</type>
      <name>get_all_for_type</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a05bb9f05067d8469f2de981794a31302</anchor>
      <arglist>(const std::string &amp;content_type)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; AppInfo &gt;</type>
      <name>get_default_for_type</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a42907d07abfa7e35e2f220436d3fcb72</anchor>
      <arglist>(const std::string &amp;content_type, bool must_support_uris=true)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; AppInfo &gt;</type>
      <name>get_default_for_uri_scheme</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>ac278c0e445faed4288c6a719e059e0da</anchor>
      <arglist>(const std::string &amp;uri_scheme)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>reset_type_associations</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a01913be6448947643c9de26bddd0659c</anchor>
      <arglist>(const std::string &amp;content_type)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static bool</type>
      <name>launch_default_for_uri</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>acf9d831fcddbf5626b1e1b9ff70c8598</anchor>
      <arglist>(const std::string &amp;uri, const Glib::RefPtr&lt; AppLaunchContext &gt; &amp;context)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static bool</type>
      <name>launch_default_for_uri</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a164a90bd2c00e9c4acb1194c475dd5d5</anchor>
      <arglist>(const std::string &amp;uri)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::AppInfo &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a074ab0526fd01e5ee2daf2c81c17f552</anchor>
      <arglist>(GAppInfo *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::AsyncResult</name>
    <filename>classGio_1_1AsyncResult.html</filename>
    <base>Glib::Interface</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~AsyncResult</name>
      <anchorfile>classGio_1_1AsyncResult.html</anchorfile>
      <anchor>a9dae859748e44341d2c14a2777ca4fee</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GAsyncResult *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1AsyncResult.html</anchorfile>
      <anchor>ad7ebc2ac808bd8eff4f4cd4f94c1c70a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GAsyncResult *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1AsyncResult.html</anchorfile>
      <anchor>a134862761e05a548d2817505480140be</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Glib::Object &gt;</type>
      <name>get_source_object</name>
      <anchorfile>classGio_1_1AsyncResult.html</anchorfile>
      <anchor>a3b89bee3ed3ff402ff58f836e1d2398e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const Glib::Object &gt;</type>
      <name>get_source_object</name>
      <anchorfile>classGio_1_1AsyncResult.html</anchorfile>
      <anchor>adcb9d80c42cf04098629a8153d51b32c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::RefPtr&lt; Glib::Object &gt;</type>
      <name>get_source_object_vfunc</name>
      <anchorfile>classGio_1_1AsyncResult.html</anchorfile>
      <anchor>a97f3fe7208156d2c981f42e97ec4ce20</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>add_interface</name>
      <anchorfile>classGio_1_1AsyncResult.html</anchorfile>
      <anchor>a27a2e7a0488f8a3db08fa9547c791c6a</anchor>
      <arglist>(GType gtype_implementer)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::AsyncResult &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1AsyncResult.html</anchorfile>
      <anchor>a08e7667c305f6c361345c9a8e261d73a</anchor>
      <arglist>(GAsyncResult *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::BufferedInputStream</name>
    <filename>classGio_1_1BufferedInputStream.html</filename>
    <base>Gio::FilterInputStream</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~BufferedInputStream</name>
      <anchorfile>classGio_1_1BufferedInputStream.html</anchorfile>
      <anchor>a6d961bb2ebe9c213c1e4c49572bae6ed</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GBufferedInputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1BufferedInputStream.html</anchorfile>
      <anchor>aa9d0c1e643650b9a45831865f06e21be</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GBufferedInputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1BufferedInputStream.html</anchorfile>
      <anchor>ad6b09565f69b4c1cf1f0ca05ee53709e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GBufferedInputStream *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1BufferedInputStream.html</anchorfile>
      <anchor>a47dc5f78b1faed25cdaaafe42b526d6d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>gsize</type>
      <name>get_buffer_size</name>
      <anchorfile>classGio_1_1BufferedInputStream.html</anchorfile>
      <anchor>a46384a96dc052e9d25e1a88281d69e40</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_buffer_size</name>
      <anchorfile>classGio_1_1BufferedInputStream.html</anchorfile>
      <anchor>af5f861a5b30aadc48e21fb10a46afaa7</anchor>
      <arglist>(gsize size)</arglist>
    </member>
    <member kind="function">
      <type>gsize</type>
      <name>get_available</name>
      <anchorfile>classGio_1_1BufferedInputStream.html</anchorfile>
      <anchor>a436e3c852afdc67e8ba70d32e39ce6b9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>gsize</type>
      <name>peek</name>
      <anchorfile>classGio_1_1BufferedInputStream.html</anchorfile>
      <anchor>a17a6489d7ab0b72268264c9f0a30e879</anchor>
      <arglist>(void *buffer, gsize offset, gsize count) const </arglist>
    </member>
    <member kind="function">
      <type>const void *</type>
      <name>peek_buffer</name>
      <anchorfile>classGio_1_1BufferedInputStream.html</anchorfile>
      <anchor>a27838d9374fa86ae513bc27d939ede24</anchor>
      <arglist>(gsize &amp;count) const </arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>fill</name>
      <anchorfile>classGio_1_1BufferedInputStream.html</anchorfile>
      <anchor>a197687762599fb7c5b60141b55120cde</anchor>
      <arglist>(gssize count, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>fill</name>
      <anchorfile>classGio_1_1BufferedInputStream.html</anchorfile>
      <anchor>a271eab4876136b4960d37350738bfdfe</anchor>
      <arglist>(gssize count)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fill_async</name>
      <anchorfile>classGio_1_1BufferedInputStream.html</anchorfile>
      <anchor>a0a41790e04e9ba500eb18d1ce8371d34</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, gssize count, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fill_async</name>
      <anchorfile>classGio_1_1BufferedInputStream.html</anchorfile>
      <anchor>aadb9c1b367e36c20c91e16ea840b6ef0</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, gssize count, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>fill_finish</name>
      <anchorfile>classGio_1_1BufferedInputStream.html</anchorfile>
      <anchor>a13c665ccc722a2544539086846137277</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>read_byte</name>
      <anchorfile>classGio_1_1BufferedInputStream.html</anchorfile>
      <anchor>a85477f09b58dfb83e5a1ef62f119457a</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>read_byte</name>
      <anchorfile>classGio_1_1BufferedInputStream.html</anchorfile>
      <anchor>a8741ffb62c82425f54bc5e005c2a238f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; guint &gt;</type>
      <name>property_buffer_size</name>
      <anchorfile>classGio_1_1BufferedInputStream.html</anchorfile>
      <anchor>add79ff7674ee8f29ed4c778d29e4ce91</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; guint &gt;</type>
      <name>property_buffer_size</name>
      <anchorfile>classGio_1_1BufferedInputStream.html</anchorfile>
      <anchor>a4c14baabc1f6e3baffd38bdfb2797d55</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; BufferedInputStream &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1BufferedInputStream.html</anchorfile>
      <anchor>afc33c31f5c437df14d385d3aa9d1a37b</anchor>
      <arglist>(const Glib::RefPtr&lt; InputStream &gt; &amp;base_stream)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; BufferedInputStream &gt;</type>
      <name>create_sized</name>
      <anchorfile>classGio_1_1BufferedInputStream.html</anchorfile>
      <anchor>a47b3b1d2c774e7c322e29beb45653bf9</anchor>
      <arglist>(const Glib::RefPtr&lt; InputStream &gt; &amp;base_stream, gsize size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>BufferedInputStream</name>
      <anchorfile>classGio_1_1BufferedInputStream.html</anchorfile>
      <anchor>a0a81d8bea742203e775f796f73f46ea4</anchor>
      <arglist>(const Glib::RefPtr&lt; InputStream &gt; &amp;base_stream)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>BufferedInputStream</name>
      <anchorfile>classGio_1_1BufferedInputStream.html</anchorfile>
      <anchor>a615364466836d73513cc9c052e1d0f72</anchor>
      <arglist>(const Glib::RefPtr&lt; InputStream &gt; &amp;base_stream, gsize size)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::BufferedInputStream &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1BufferedInputStream.html</anchorfile>
      <anchor>adfe9bf4339f83095d6e96dda7b747575</anchor>
      <arglist>(GBufferedInputStream *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::BufferedOutputStream</name>
    <filename>classGio_1_1BufferedOutputStream.html</filename>
    <base>Gio::FilterOutputStream</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~BufferedOutputStream</name>
      <anchorfile>classGio_1_1BufferedOutputStream.html</anchorfile>
      <anchor>ab2cf992f28ebf871b0025e5060356f40</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GBufferedOutputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1BufferedOutputStream.html</anchorfile>
      <anchor>a6dfd09a0501267ef81030e3cf8e9ae47</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GBufferedOutputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1BufferedOutputStream.html</anchorfile>
      <anchor>a4a906daf7be02fd1c1548253f5f0e95c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GBufferedOutputStream *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1BufferedOutputStream.html</anchorfile>
      <anchor>a890c12d13d9f87332b00b785e32e4424</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>gsize</type>
      <name>get_buffer_size</name>
      <anchorfile>classGio_1_1BufferedOutputStream.html</anchorfile>
      <anchor>a18ba1d42def3606fe3da3912046b1c11</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_buffer_size</name>
      <anchorfile>classGio_1_1BufferedOutputStream.html</anchorfile>
      <anchor>a8044f48728b7020ba86e7364421b21fb</anchor>
      <arglist>(gsize size)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_auto_grow</name>
      <anchorfile>classGio_1_1BufferedOutputStream.html</anchorfile>
      <anchor>a5c308a93b5538db6c614b67e015474c5</anchor>
      <arglist>(bool auto_grow=true)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_auto_grow</name>
      <anchorfile>classGio_1_1BufferedOutputStream.html</anchorfile>
      <anchor>a53501edadccf17be8908fae896d34dcc</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; guint &gt;</type>
      <name>property_buffer_size</name>
      <anchorfile>classGio_1_1BufferedOutputStream.html</anchorfile>
      <anchor>aa00fd9e312bc942df1c01047c1a71bd5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; guint &gt;</type>
      <name>property_buffer_size</name>
      <anchorfile>classGio_1_1BufferedOutputStream.html</anchorfile>
      <anchor>a9c832174c00f75f618d1d14b9056f445</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; bool &gt;</type>
      <name>property_auto_grow</name>
      <anchorfile>classGio_1_1BufferedOutputStream.html</anchorfile>
      <anchor>aa898e7b7b62ff05c785cac3c3a6abf46</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_auto_grow</name>
      <anchorfile>classGio_1_1BufferedOutputStream.html</anchorfile>
      <anchor>a263f69601504ae97cc4b83afe19f116d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; BufferedOutputStream &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1BufferedOutputStream.html</anchorfile>
      <anchor>ad5cfe5126450ce9236a8c1f768aed4c5</anchor>
      <arglist>(const Glib::RefPtr&lt; OutputStream &gt; &amp;base_stream)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; BufferedOutputStream &gt;</type>
      <name>create_sized</name>
      <anchorfile>classGio_1_1BufferedOutputStream.html</anchorfile>
      <anchor>a32717dd0802cf24c7a7442181974a8b4</anchor>
      <arglist>(const Glib::RefPtr&lt; OutputStream &gt; &amp;base_stream, gsize size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>BufferedOutputStream</name>
      <anchorfile>classGio_1_1BufferedOutputStream.html</anchorfile>
      <anchor>abd7e5b3a7dc3a71b5cae2214cce5e5d6</anchor>
      <arglist>(const Glib::RefPtr&lt; OutputStream &gt; &amp;base_stream)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>BufferedOutputStream</name>
      <anchorfile>classGio_1_1BufferedOutputStream.html</anchorfile>
      <anchor>a0a67daf674844c17385b63722e18a1ad</anchor>
      <arglist>(const Glib::RefPtr&lt; OutputStream &gt; &amp;base_stream, gsize size)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::BufferedOutputStream &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1BufferedOutputStream.html</anchorfile>
      <anchor>ab4fbaeef8ea590b6c674973d25678902</anchor>
      <arglist>(GBufferedOutputStream *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::Cancellable</name>
    <filename>classGio_1_1Cancellable.html</filename>
    <base>Glib::Object</base>
    <member kind="typedef">
      <type>sigc::slot&lt; void &gt;</type>
      <name>SlotCancelledCallback</name>
      <anchorfile>classGio_1_1Cancellable.html</anchorfile>
      <anchor>a18d005aeefd0da4daab594f4c44ce9cd</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Cancellable</name>
      <anchorfile>classGio_1_1Cancellable.html</anchorfile>
      <anchor>a97c7c4d728865129bc6f0cd3f4ecfce7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GCancellable *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Cancellable.html</anchorfile>
      <anchor>ae19ec1e85fd9cd7893914d4d7c20120d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GCancellable *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Cancellable.html</anchorfile>
      <anchor>a668176a01f7ad3cc13c7448378f37b41</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GCancellable *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1Cancellable.html</anchorfile>
      <anchor>a379e6394bad0fff1eb11e1a160f30235</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_cancelled</name>
      <anchorfile>classGio_1_1Cancellable.html</anchorfile>
      <anchor>a47ce5f2f16541b7ae18bc5114b366d8c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>get_fd</name>
      <anchorfile>classGio_1_1Cancellable.html</anchorfile>
      <anchor>a80df23049daf594fda884f2932ce3b95</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cancel</name>
      <anchorfile>classGio_1_1Cancellable.html</anchorfile>
      <anchor>a86adae0645cec20d09d1a2903fe46cc0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push_current</name>
      <anchorfile>classGio_1_1Cancellable.html</anchorfile>
      <anchor>ad893da5aebfb4baf34ecdbdad7a3608b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>pop_current</name>
      <anchorfile>classGio_1_1Cancellable.html</anchorfile>
      <anchor>a93b5a39447d2b4eb9fb56748cb687fc8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>reset</name>
      <anchorfile>classGio_1_1Cancellable.html</anchorfile>
      <anchor>a2285370aea5d98141e742e73743b9c3e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>gulong</type>
      <name>connect</name>
      <anchorfile>classGio_1_1Cancellable.html</anchorfile>
      <anchor>ad43ddee749e87373a2dd035f8eb989e6</anchor>
      <arglist>(const SlotCancelledCallback &amp;callback)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>disconnect</name>
      <anchorfile>classGio_1_1Cancellable.html</anchorfile>
      <anchor>aa9277479b4bf0b80090e780e26215713</anchor>
      <arglist>(gulong handler_id)</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy0&lt; void &gt;</type>
      <name>signal_cancelled</name>
      <anchorfile>classGio_1_1Cancellable.html</anchorfile>
      <anchor>a5a34d4782ccec014684c4eb6c20cf0a6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Cancellable &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1Cancellable.html</anchorfile>
      <anchor>a8d59324b4c253f8c890901cd934203a7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Cancellable &gt;</type>
      <name>get_current</name>
      <anchorfile>classGio_1_1Cancellable.html</anchorfile>
      <anchor>aaf923ce91ddf21fc03bf2902e12cd4e1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Cancellable</name>
      <anchorfile>classGio_1_1Cancellable.html</anchorfile>
      <anchor>aab7733b6e915e4ebe280fbb669b6af2a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_cancelled</name>
      <anchorfile>classGio_1_1Cancellable.html</anchorfile>
      <anchor>aff017e200824997b9c26d82f147e078f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::Cancellable &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1Cancellable.html</anchorfile>
      <anchor>ac45875da91c9c870a0f154a8249047c0</anchor>
      <arglist>(GCancellable *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::DataInputStream</name>
    <filename>classGio_1_1DataInputStream.html</filename>
    <base>Gio::BufferedInputStream</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~DataInputStream</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>ae97b466761df6cccb9b4232e8dece6d5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GDataInputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>ad788764326462190e900785f50a50740</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GDataInputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a5d8f01998854eac791a3089acef051c0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GDataInputStream *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a8252806b8ac5548c51a0418162ddb6ab</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_byte_order</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a032c20df06b83828d3cb5e81f6b8f561</anchor>
      <arglist>(DataStreamByteOrder order)</arglist>
    </member>
    <member kind="function">
      <type>DataStreamByteOrder</type>
      <name>get_byte_order</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a3be4cc7ce927af027630cdeea0914004</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_newline_type</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>afbc8ad1476fd82e808234a661bfe4cd3</anchor>
      <arglist>(DataStreamNewlineType type)</arglist>
    </member>
    <member kind="function">
      <type>DataStreamNewlineType</type>
      <name>get_newline_type</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>afe528b7ecf9401b7bf91f0c67e34de9f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>guchar</type>
      <name>read_byte</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>aca226b5c2d1248dd079d835dd089570d</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>guchar</type>
      <name>read_byte</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>af4d01aa4e791d403b79db406befcc28e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>gint16</type>
      <name>read_int16</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a9fd357f931715d83c69b7010ff86af80</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>gint16</type>
      <name>read_int16</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a2407fa551610510cfdcda3b2d8adabdc</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>guint16</type>
      <name>read_uint16</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a9ac667e423ec3c3d997fc2a4683956d3</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>guint16</type>
      <name>read_uint16</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a4e99722aa033a78ac2f4dc593b36d197</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>gint32</type>
      <name>read_int32</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a6280a6c0c6cc1803dc3df8dc29910bcd</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>gint32</type>
      <name>read_int32</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>adbbe894fae2ba5d071c3f50895af9067</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>guint32</type>
      <name>read_uint32</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>ae7d36dbd67425b923fe335ec5a3f4124</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>guint32</type>
      <name>read_uint32</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a587856139c73d6c2df1ad2c5560cffec</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>gint64</type>
      <name>read_int64</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a5d9599527bcd651841fd4f73082d26e0</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>gint64</type>
      <name>read_int64</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a6ccd4123a211d1d89c17bb6e4a4aae35</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>guint64</type>
      <name>read_uint64</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a2e486863876f833e910286300c7e17a4</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>guint64</type>
      <name>read_uint64</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a9c7ed7807b2a8370f879a820dd0c7989</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>read_line</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a4e1ac2a250c7acd60417454379d580a7</anchor>
      <arglist>(std::string &amp;line, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>read_line</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a5186689410fe626e35688190b65ec0c5</anchor>
      <arglist>(std::string &amp;line)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>read_line_async</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>aad31c733d13f737f893326b3b7f1ff0d</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>read_line_finish</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a538562b9bf3a80138ba9918b2249f834</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result, std::string &amp;data)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>read_until</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a058c5367f9be4e4e36d5fb9de2201815</anchor>
      <arglist>(std::string &amp;data, const std::string &amp;stop_chars, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>read_until</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>aa7d2a04bf5a4628df0530ec40d4c33cf</anchor>
      <arglist>(std::string &amp;data, const std::string &amp;stop_chars)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>read_until_async</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a708cba487c68c8c927fe8ae6277b6123</anchor>
      <arglist>(const std::string &amp;stop_chars, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>read_until_finish</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>aa851cb398896f39bea56868b46bd480d</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result, std::string &amp;data)</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; DataStreamByteOrder &gt;</type>
      <name>property_byte_order</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>acbc9d655a3a0475f6b921be899bc6cdc</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; DataStreamByteOrder &gt;</type>
      <name>property_byte_order</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>abb65c759a942acd59a82c1d124dda033</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; DataStreamNewlineType &gt;</type>
      <name>property_newline_type</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a9b0be8e7ee14c413ba0e8c9b8e1acc1e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; DataStreamNewlineType &gt;</type>
      <name>property_newline_type</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a0aa39af96006289ad64d04d5a6c3c293</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; DataInputStream &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a5ecca0b3f4fdc5962c3c63e4e6706e4e</anchor>
      <arglist>(const Glib::RefPtr&lt; InputStream &gt; &amp;base_stream)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>DataInputStream</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a65e68eef09e6aa1d9e52d446a171fba3</anchor>
      <arglist>(const Glib::RefPtr&lt; InputStream &gt; &amp;base_stream)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::DataInputStream &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a88853a1864df25dc8dda900a6ad52266</anchor>
      <arglist>(GDataInputStream *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::DataOutputStream</name>
    <filename>classGio_1_1DataOutputStream.html</filename>
    <base>Gio::BufferedOutputStream</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~DataOutputStream</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>ad59e02b7e431eed80a7e8280576e4145</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GDataOutputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>acf92da9c162b7a0805aabe334912d5cb</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GDataOutputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>a42d4127b7b7b16ae6ec3feb5f66b68d2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GDataOutputStream *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>ac1e10167167a2f5c894e567003483419</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_byte_order</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>ad35d1b14012a1f4ce7aeca8e73a0560a</anchor>
      <arglist>(DataStreamByteOrder order)</arglist>
    </member>
    <member kind="function">
      <type>DataStreamByteOrder</type>
      <name>get_byte_order</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>ad9d00dd1dbb4e42186049130601e3117</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>put_byte</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>a193a3d737db19250895ad4329b82a602</anchor>
      <arglist>(guchar data, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>put_byte</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>a82d0f12bac635dc5889847c4911c3407</anchor>
      <arglist>(guchar data)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>put_int16</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>a967df26dca9c0948d78bd495800eeda3</anchor>
      <arglist>(gint16 data, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>put_int16</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>a29c0d46538383ed82d622068d826d06e</anchor>
      <arglist>(gint16 data)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>put_uint16</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>aa0f8a4fda83e453a49d5cf614868b392</anchor>
      <arglist>(guint16 data, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>put_uint16</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>aa222bd351437698643820251e28a406d</anchor>
      <arglist>(guint16 data)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>put_int32</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>ac405b5c957d34ff068fb07a30dbb5f09</anchor>
      <arglist>(gint32 data, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>put_int32</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>ac02e3766459a8bb970022ff3991d841e</anchor>
      <arglist>(gint32 data)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>put_uint32</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>a4851b514c9f3ca166b581b35f530ea71</anchor>
      <arglist>(guint32 data, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>put_uint32</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>a16cdae2dd633a4afaea583baa7d10d44</anchor>
      <arglist>(guint32 data)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>put_int64</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>ac7efa2d21047145f79fd651129b372f2</anchor>
      <arglist>(gint64 data, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>put_int64</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>abbe60cbe43ae446cef3a7c9764a6fe08</anchor>
      <arglist>(gint64 data)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>put_uint64</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>a4a16076bd66c8f2e249ecde22f9762c1</anchor>
      <arglist>(guint64 data, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>put_uint64</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>a5dfd43d27380c031314adf0dc67b4cb4</anchor>
      <arglist>(guint64 data)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>put_string</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>a11a8e87ba2da06727d2c8751214b7055</anchor>
      <arglist>(std::string str, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>put_string</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>ababf1898b1e49d7d16fdacdfe38db3f3</anchor>
      <arglist>(std::string str)</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; DataStreamByteOrder &gt;</type>
      <name>property_byte_order</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>aba9c94369d178cf798bd77b8be4a6731</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; DataStreamByteOrder &gt;</type>
      <name>property_byte_order</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>af1b6575e76c4c07d8b563079d80a1bcd</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; DataOutputStream &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>aa9c23f0bf4d13c5a4ca5b7bb03991928</anchor>
      <arglist>(const Glib::RefPtr&lt; OutputStream &gt; &amp;base_stream)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>DataOutputStream</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>ab01b287da67c8d2312a82f03de59916f</anchor>
      <arglist>(const Glib::RefPtr&lt; OutputStream &gt; &amp;base_stream)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::DataOutputStream &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>a53e38b7e7370532ed71a1f434050043a</anchor>
      <arglist>(GDataOutputStream *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::Drive</name>
    <filename>classGio_1_1Drive.html</filename>
    <base>Glib::Interface</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Drive</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a92df3dab950a06a57ea2f5080b917a14</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GDrive *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>aaa1d4330f6e1d0faee6262f632c63227</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GDrive *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>ada0bdfcbce80c94f4b080f6de73706df</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_name</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a29125b6262e95613e92266221584ab2d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Icon &gt;</type>
      <name>get_icon</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>aa7bbfe3d9eb4c716e4e964388b504458</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const Icon &gt;</type>
      <name>get_icon</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>ad0407bd1e193689a5b088abac49f581c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>has_volumes</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a42a2753bc97ae014a1649dc53b4acfae</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ListHandle&lt; Glib::RefPtr&lt; Volume &gt; &gt;</type>
      <name>get_volumes</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>afe6e5759dcf759a1c862e172543d6bd3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_media_removable</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>aa9c9b3db01d76f26527702860498b531</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>has_media</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>ad5397764c7a76adf9a0d8bc4f419fbe3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_media_check_automatic</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a0cbbb630e6f944f2cd078219d7e35cc7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>can_poll_for_media</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a538ad0e01c3359d7d75e8389eb54dec0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>can_eject</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a63d1960ea469bdb1a61ddf1752a6e9b9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>eject</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a4163a79cc5ff639693159110592e6be0</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>eject</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a7677be984564a7cf3c5ab7dd3ebb6c96</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>eject</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a306949d0008fd30a59136e0759dd60ed</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>eject</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a21a808bb07f7cb580899006fd42c76ea</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, const SlotAsyncReady &amp;slot, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>eject</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>af66cf6ad9b9027630f1c9303bbb6a8fe</anchor>
      <arglist>(MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>eject</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>acb804853bd5e4ecf4abc6503e6ffa82d</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>eject_finish</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>abdc299d32ba4dd96784db3a9a4523ea4</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>poll_for_media</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a1733be3e6aa7c23caa3c12a45d75878d</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>poll_for_media</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a1c565d20c1f17a233db75dec9ce30415</anchor>
      <arglist>(const SlotAsyncReady &amp;slot)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>poll_for_media</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a85bd972cad1ef7e1c2627767a825eed0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>poll_for_media_finish</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>afa415ce0439367e5d8685a2bb1bd9b8d</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_identifier</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a6a94c55bba839fa834ba18bc4ef41c39</anchor>
      <arglist>(const std::string &amp;kind) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::StringArrayHandle</type>
      <name>enumerate_identifiers</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a8c6c6c5597208c8cc9610b5f2d9f8107</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>start</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a48cae86204823873e110ecdf7948a5c3</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const SlotAsyncReady &amp;slot, DriveStartFlags flags=DRIVE_START_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>start</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a99ca25e21f33f54e79b9d62e47ddda71</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, const SlotAsyncReady &amp;slot, DriveStartFlags flags=DRIVE_START_NONE)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>start_finish</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a7d81d812989e5dc79414c63149dda9d7</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>can_start</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a2594f0176716f8aec2464a3b4dc856a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>can_start_degraded</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>ac047620f769a455b2ca3869bf725e9eb</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stop</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a037cd31001af5d6d0540f4ccbe7b12bf</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const SlotAsyncReady &amp;slot, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stop</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a1adf5f0d63a2d3a38acc4328f726f7ed</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, const SlotAsyncReady &amp;slot, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>stop_finish</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a308102dbcef3dac0a3ad0006a0c1440e</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>can_stop</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a79c25c1986a1e46ca8dcdf8e331b4dba</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>DriveStartStopType</type>
      <name>get_start_stop_type</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a5c9954887834a697b9417188c4e0ccb0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy0&lt; void &gt;</type>
      <name>signal_changed</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>abda915e1b5fff2be69fc28bbbba05736</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy0&lt; void &gt;</type>
      <name>signal_disconnected</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>aa65a212796147d65d4fa953755c33b6e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy0&lt; void &gt;</type>
      <name>signal_eject_button</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>aae48457a354c2bbde87b27c991bf867d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy0&lt; void &gt;</type>
      <name>signal_stop_button</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a37a763ad90197500323edacc4e6a8f63</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>add_interface</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a4a00b2efd7a10fae3ffc6e67f30b0908</anchor>
      <arglist>(GType gtype_implementer)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::Drive &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a1a0d5aec4d31827ebfcbdea0c2ebee87</anchor>
      <arglist>(GDrive *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::Emblem</name>
    <filename>classGio_1_1Emblem.html</filename>
    <base>Glib::Object</base>
    <base>Gio::Icon</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Emblem</name>
      <anchorfile>classGio_1_1Emblem.html</anchorfile>
      <anchor>a3b0b61279f632bcac5894004b99c5f4b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GEmblem *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Emblem.html</anchorfile>
      <anchor>a18a84361942885e0b75a82ffbc342947</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GEmblem *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Emblem.html</anchorfile>
      <anchor>aedc2ab1a8682aff33ba0dbdaf5d05afb</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GEmblem *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1Emblem.html</anchorfile>
      <anchor>a37489c6af0fd3ebcc26f2ad70499ab69</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Icon &gt;</type>
      <name>get_icon</name>
      <anchorfile>classGio_1_1Emblem.html</anchorfile>
      <anchor>a2272bb4eb06787a561eae7593912aa04</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const Icon &gt;</type>
      <name>get_icon</name>
      <anchorfile>classGio_1_1Emblem.html</anchorfile>
      <anchor>aaea925c28921a3d9a5e772aace7a2ff4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>EmblemOrigin</type>
      <name>get_origin</name>
      <anchorfile>classGio_1_1Emblem.html</anchorfile>
      <anchor>ae2e37f3de1e0d50b50a3ba4e9ff3d30f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Emblem &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1Emblem.html</anchorfile>
      <anchor>a73b765b853f364b1681352efc8a73a69</anchor>
      <arglist>(const Glib::RefPtr&lt; Icon &gt; &amp;icon)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Emblem &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1Emblem.html</anchorfile>
      <anchor>a49167949418fba4e254c3044b5b2808d</anchor>
      <arglist>(const Glib::RefPtr&lt; Icon &gt; &amp;icon, EmblemOrigin origin)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Emblem</name>
      <anchorfile>classGio_1_1Emblem.html</anchorfile>
      <anchor>a145a95e9ca6ee5d31be2c94be935c060</anchor>
      <arglist>(const Glib::RefPtr&lt; Icon &gt; &amp;icon)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Emblem</name>
      <anchorfile>classGio_1_1Emblem.html</anchorfile>
      <anchor>a2ff0e5c38e6fc97b2c57188099304fef</anchor>
      <arglist>(const Glib::RefPtr&lt; Icon &gt; &amp;icon, EmblemOrigin origin)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::Emblem &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1Emblem.html</anchorfile>
      <anchor>a53ecca7bfb4c8b1e3ac4305a8087bf3e</anchor>
      <arglist>(GEmblem *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::EmblemedIcon</name>
    <filename>classGio_1_1EmblemedIcon.html</filename>
    <base>Glib::Object</base>
    <base>Gio::Icon</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~EmblemedIcon</name>
      <anchorfile>classGio_1_1EmblemedIcon.html</anchorfile>
      <anchor>a52372e1aef73698e9ed8dfe9623ef8e7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GEmblemedIcon *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1EmblemedIcon.html</anchorfile>
      <anchor>ad19779f46ff62261df8b924f2e218f00</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GEmblemedIcon *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1EmblemedIcon.html</anchorfile>
      <anchor>a2b4a572414232927365ade6bf7bd1d5d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GEmblemedIcon *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1EmblemedIcon.html</anchorfile>
      <anchor>afa5683d27b359053a929ca46d61ff512</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Icon &gt;</type>
      <name>get_icon</name>
      <anchorfile>classGio_1_1EmblemedIcon.html</anchorfile>
      <anchor>aaa34ad2bbd13edbed76aaf908a04c630</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const Icon &gt;</type>
      <name>get_icon</name>
      <anchorfile>classGio_1_1EmblemedIcon.html</anchorfile>
      <anchor>afd4b52af91512a77936c0c1e13222436</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ListHandle&lt; Glib::RefPtr&lt; Emblem &gt; &gt;</type>
      <name>get_emblems</name>
      <anchorfile>classGio_1_1EmblemedIcon.html</anchorfile>
      <anchor>ad1795232c2d5abd7edec6a56072d94e9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>add_emblem</name>
      <anchorfile>classGio_1_1EmblemedIcon.html</anchorfile>
      <anchor>acf332055cf535914f444bc037ba7d324</anchor>
      <arglist>(const Glib::RefPtr&lt; Emblem &gt; &amp;emblem)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; EmblemedIcon &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1EmblemedIcon.html</anchorfile>
      <anchor>ac4e4b5c233a669ac82db3852b5d9a1a6</anchor>
      <arglist>(const Glib::RefPtr&lt; Icon &gt; &amp;icon, const Glib::RefPtr&lt; Emblem &gt; &amp;emblem)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>EmblemedIcon</name>
      <anchorfile>classGio_1_1EmblemedIcon.html</anchorfile>
      <anchor>a2d790c876f3033983c5989a64f5ed83a</anchor>
      <arglist>(const Glib::RefPtr&lt; Icon &gt; &amp;icon, const Glib::RefPtr&lt; Emblem &gt; &amp;emblem)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::EmblemedIcon &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1EmblemedIcon.html</anchorfile>
      <anchor>a1f2d2a7c6ad0125c6a9b4b41c2b7766a</anchor>
      <arglist>(GEmblemedIcon *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::Error</name>
    <filename>classGio_1_1Error.html</filename>
    <base>Glib::Error</base>
    <member kind="enumeration">
      <name>Code</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FAILED</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a4b7bf87fd22aea037daa6cadd0f6c6db</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NOT_FOUND</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a71ba0a8ad3a2cee6b86aae19fa38f8d0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EXISTS</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a46c2fb3115cde148a9044a996a5f5947</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IS_DIRECTORY</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134aa3b4c2b6e1109309dfb04e111ae0eeae</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NOT_DIRECTORY</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134ac89747d1a8296a2d7abc61e33e9a6849</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NOT_EMPTY</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a4d1db4eab217424adeb9acbb8bdcbed1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NOT_REGULAR_FILE</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a5f4f1cdbfc26e0b284ddc971e69b1153</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NOT_SYMBOLIC_LINK</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a308933795ee7ee7613e555eb6dfa89ce</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NOT_MOUNTABLE_FILE</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134aad4e3bf56a2de0f7642eb5713a4e2da0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILENAME_TOO_LONG</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134af64160bec6d689e9143b2b065114a8b8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>INVALID_FILENAME</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a4705fc1de258afdbf3d80d1e6a9c1a93</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TOO_MANY_LINKS</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a6bc650c3933a11fd0eec1a03c96bacfd</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NO_SPACE</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134adb48a8d32cc13f996feccfd7e7f4bfa9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>INVALID_ARGUMENT</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a2cc33d826acd1d12989ae83f4685db1e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PERMISSION_DENIED</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a6f7122349d0108e792444d115cfe067e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NOT_SUPPORTED</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134aa46bb4ae8662767fb5bf2406c384ca58</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NOT_MOUNTED</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a37bbb3053c929cc59ba594a0e68c4e2e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ALREADY_MOUNTED</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a2c70c6db9fe114fd367bb673a8f0d84e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>CLOSED</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a252082a76c9bf70f5df5e736b7334951</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>CANCELLED</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a9da2cb56b3e1b8db9adf481360e2ad0c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PENDING</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a6420882bc2f68e77254adb9767bac2b2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>READ_ONLY</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a15305a05f8c09ef80549261f01d42ae7</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>CANT_CREATE_BACKUP</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134ace8da5552c3ab58264e8c53011c68e18</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>WRONG_ETAG</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134ab84b31830cf8bda8886977905d8c0843</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TIMED_OUT</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a44decc3b328a874eadd76414c7ebe4db</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>WOULD_RECURSE</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a3af6165f166bf4e8aef85437d4497929</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>BUSY</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a066d8df507fe9a2de219f618d6242cce</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>WOULD_BLOCK</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a4041bd40a7ec2e6dc8dae84c30065fec</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>HOST_NOT_FOUND</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a267c1b76c0f55be7e49beb9aeb387e7e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>HOST_WAS_NOT_FOUND</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a207ecccfb593af57a3db3c9311e623a6</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>WOULD_MERGE</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134ac7a10c56c904ac8d1d977945c88d6b33</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FAILED_HANDLED</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a8001f1c0293ab55c88643e3eef3458aa</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TOO_MANY_OPEN_FILES</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134ab091e49c560d423fc47f1a9d5187540e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NOT_INITIALIZED</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a9664753e60bdd49ecee28c513c33b53e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ADDRESS_IN_USE</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134ad49388bed14b5c28982d23fdc3bd21e3</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Error</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a6dbe1ed978ad03ee64dbec0a055c3914</anchor>
      <arglist>(Code error_code, const Glib::ustring &amp;error_message)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Error</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a0e59e13293663b6c1690f9277c5b48b6</anchor>
      <arglist>(GError *gobject)</arglist>
    </member>
    <member kind="function">
      <type>Code</type>
      <name>code</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>ac353667814678e7406d8b1ab72cb430a</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::File</name>
    <filename>classGio_1_1File.html</filename>
    <base>Glib::Interface</base>
    <member kind="typedef">
      <type>sigc::slot&lt; void, goffset, goffset &gt;</type>
      <name>SlotFileProgress</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ac5ff32ee99845479d138eee49d92e59c</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>sigc::slot&lt; bool, const char *, goffset &gt;</type>
      <name>SlotReadMore</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>add182d22071784fc345adc757b3d687b</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~File</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>af17e8c7b30baa13aaa5d58ef4d56e383</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GFile *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a96552cfbaf2e5fa3659a1568db8cca91</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GFile *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a5437bc648d8b73451e8bee0bc902cfc0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; File &gt;</type>
      <name>dup</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a9ea238062cdc317ae982ffae5c226c9b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>guint</type>
      <name>hash</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a0320bac72ecc9ced1f894f1af696856f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>equal</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a8877115c870ea8f58b03d1d3c01a83e4</anchor>
      <arglist>(const Glib::RefPtr&lt; const File &gt; &amp;other) const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_basename</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ac731bed45bb7fcfd411eb69c49d3b883</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_path</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a7b3edc7946b681b6db2cdcdad08d2b00</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_uri</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a2d1313e4a4eb5de034b693ec1cc9fba0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_parse_name</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>aea4a78163e3085a35cbaacde9a3a7628</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; File &gt;</type>
      <name>get_parent</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>af39bbd5013b2dd675911df322e12ff94</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; File &gt;</type>
      <name>get_child</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a53c533d6bbeaaadd1b5592cf1e5ef93c</anchor>
      <arglist>(const std::string &amp;name) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; File &gt;</type>
      <name>get_child_for_display_name</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a479cfd632af30b29e125f904f809ed71</anchor>
      <arglist>(const Glib::ustring &amp;display_name) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>has_prefix</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a4c40ec88dfc4333f19e939d26a1e0332</anchor>
      <arglist>(const Glib::RefPtr&lt; const File &gt; &amp;prefix) const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_relative_path</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a464248111fa2bc5df89c620354eb99bb</anchor>
      <arglist>(const Glib::RefPtr&lt; const File &gt; &amp;descendant) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; File &gt;</type>
      <name>resolve_relative_path</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ac5e286d421c7236df39881f8ce0a4e03</anchor>
      <arglist>(const std::string &amp;relative_path) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_native</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>aaa3b910bc9f240d4ebd0efc70979f163</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>has_uri_scheme</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a90d71529e5b51b9ff73914eaf90be0f1</anchor>
      <arglist>(const std::string &amp;uri_scheme) const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_uri_scheme</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>aeecec6962f955bd72ac5595be37db7a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileInputStream &gt;</type>
      <name>read</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a3ef959c7ad7096846f26eb8b282e3c68</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileInputStream &gt;</type>
      <name>read</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a0395b3b0b8cec5dc1fd9953e52e5fbc1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>read_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a2826eed0b1e76c3771f6ad5f5b993991</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>read_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ab451a182a647408e697c9115e66f6194</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileInputStream &gt;</type>
      <name>read_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a64b10854ad1add1f888ecb19403eb921</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileOutputStream &gt;</type>
      <name>append_to</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a91c93ee71eee738690cb551d11df9528</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, FileCreateFlags flags=FILE_CREATE_NONE)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileOutputStream &gt;</type>
      <name>append_to</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a8db337b93f3b9b9a6e163477391e6c89</anchor>
      <arglist>(FileCreateFlags flags=FILE_CREATE_NONE)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileOutputStream &gt;</type>
      <name>create_file</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a86258e11b2884422819d051c3cfd07a2</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, FileCreateFlags flags=FILE_CREATE_NONE)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileOutputStream &gt;</type>
      <name>create_file</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a5cf2b17b953ccfefb1d13c39bd1be72c</anchor>
      <arglist>(FileCreateFlags flags=FILE_CREATE_NONE)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileOutputStream &gt;</type>
      <name>replace</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ad7cf0360096504e40f799fde5cc8e9de</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const std::string &amp;etag=std::string(), bool make_backup=false, FileCreateFlags flags=FILE_CREATE_NONE)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileOutputStream &gt;</type>
      <name>replace</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>acf55f9291659566f6fd36271801b013b</anchor>
      <arglist>(const std::string &amp;etag=std::string(), bool make_backup=false, FileCreateFlags flags=FILE_CREATE_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append_to_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a1e3dfb193e8f2ab69e24c4370de5335a</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, FileCreateFlags flags=FILE_CREATE_NONE, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append_to_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>abff3163e9bf8d8208cd0c0e568b777de</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, FileCreateFlags flags=FILE_CREATE_NONE, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileOutputStream &gt;</type>
      <name>append_to_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>acb1f2d32055b8da274ea241c69487dc6</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>create_file_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ae0c42446d37aa466173965b7db1a2053</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, FileCreateFlags flags=FILE_CREATE_NONE, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>create_file_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a3fe6ed015f3d2bb72aa7aceed8dc7ca1</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, FileCreateFlags flags=FILE_CREATE_NONE, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileOutputStream &gt;</type>
      <name>create_file_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a622b9f7aeaebe2ac53df0574c9c4211a</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>replace_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ad777cdaa404a6a668ee8d520299687ce</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const std::string &amp;etag=std::string(), bool make_backup=false, FileCreateFlags flags=FILE_CREATE_NONE, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>replace_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ae51e51a2e3a45da4324230b4d5401a58</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const std::string &amp;etag=std::string(), bool make_backup=false, FileCreateFlags flags=FILE_CREATE_NONE, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileOutputStream &gt;</type>
      <name>replace_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ab28557d592f2c53df618728cf865e65e</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileInfo &gt;</type>
      <name>query_info</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>adb25ffdbe571d33e89c9503fe9a20dcd</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const std::string &amp;attributes=&quot;*&quot;, FileQueryInfoFlags flags=FILE_QUERY_INFO_NONE) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileInfo &gt;</type>
      <name>query_info</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a4e4b9c07ade255b12e2b43c38c3aba90</anchor>
      <arglist>(const std::string &amp;attributes=&quot;*&quot;, FileQueryInfoFlags flags=FILE_QUERY_INFO_NONE) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>query_exists</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ad8b0a75e0afdb5f6874ea5e304d55ea8</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>query_exists</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ab4cfdbf4fedacd364e40a72c71ab341a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>FileType</type>
      <name>query_file_type</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>aa27c5b271c8f7667ce117cfc6118262e</anchor>
      <arglist>(FileQueryInfoFlags flags, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable) const </arglist>
    </member>
    <member kind="function">
      <type>FileType</type>
      <name>query_file_type</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a691a9de5512b870bf358a9b0d292e146</anchor>
      <arglist>(FileQueryInfoFlags flags=FILE_QUERY_INFO_NONE) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>query_info_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a7bd60e7864f8954c35e3b0891058e61c</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const std::string &amp;attributes=&quot;*&quot;, FileQueryInfoFlags flags=FILE_QUERY_INFO_NONE, int io_priority=Glib::PRIORITY_DEFAULT) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>query_info_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>afcad69d782a971802a8aa85125ac2c8c</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const std::string &amp;attributes=&quot;*&quot;, FileQueryInfoFlags flags=FILE_QUERY_INFO_NONE, int io_priority=Glib::PRIORITY_DEFAULT) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileInfo &gt;</type>
      <name>query_info_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>afd4ffc3630b41754c177658f2e745357</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileInfo &gt;</type>
      <name>query_filesystem_info</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a40486bc2f0c8758ef8a705b6b8b57e57</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const std::string &amp;attributes=&quot;*&quot;)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileInfo &gt;</type>
      <name>query_filesystem_info</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ac737012f8df97d90e2447d94d30b817d</anchor>
      <arglist>(const std::string &amp;attributes=&quot;*&quot;)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Mount &gt;</type>
      <name>find_enclosing_mount</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a45b881926b8d58c49d3baa1f51f2ee5d</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>query_filesystem_info_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a39184ff9c9437259df4b9a9e2f283a0b</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const std::string &amp;attributes=&quot;*&quot;, int io_priority=Glib::PRIORITY_DEFAULT) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>query_filesystem_info_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a4557ab16a50337f73d8a4649cf60fe70</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const std::string &amp;attributes=&quot;*&quot;, int io_priority=Glib::PRIORITY_DEFAULT) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileInfo &gt;</type>
      <name>query_filesystem_info_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>afd1159de8f782d918d8d460cddffee5b</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Mount &gt;</type>
      <name>find_enclosing_mount</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a6eb675267c7ea1c2a0d40e2e754d8333</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>find_enclosing_mount_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a78c95d4fa47157f7757b686677dec018</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>find_enclosing_mount_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a67458be57c5687e7469bc26e2594f4be</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Mount &gt;</type>
      <name>find_enclosing_mount_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>aa12e6222d81179937cdc366f4d315433</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileEnumerator &gt;</type>
      <name>enumerate_children</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a68c3afcddc0d4860aa2afb4bf715bb20</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const std::string &amp;attributes=&quot;*&quot;, FileQueryInfoFlags flags=FILE_QUERY_INFO_NONE)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileEnumerator &gt;</type>
      <name>enumerate_children</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ac0e293d607499b223f4892fb290ab2d6</anchor>
      <arglist>(const std::string &amp;attributes=&quot;*&quot;, FileQueryInfoFlags flags=FILE_QUERY_INFO_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>enumerate_children_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a1ead7237b7057d9b15cf5f3065988131</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const std::string &amp;attributes=&quot;*&quot;, FileQueryInfoFlags flags=FILE_QUERY_INFO_NONE, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>enumerate_children_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a5b5470cf1c97754a12169201665f1202</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const std::string &amp;attributes=&quot;*&quot;, FileQueryInfoFlags flags=FILE_QUERY_INFO_NONE, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileEnumerator &gt;</type>
      <name>enumerate_children_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a617a2950448788e68df128c58e068a14</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; File &gt;</type>
      <name>set_display_name</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a3dd75810d7c9ebafac398288f5afc018</anchor>
      <arglist>(const Glib::ustring &amp;display_name, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; File &gt;</type>
      <name>set_display_name</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a8c2aa80b2d0ecdd22f0222c8ce42d177</anchor>
      <arglist>(const Glib::ustring &amp;display_name)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_display_name_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a0ac539d7758b9c0de809f8c83e0bba79</anchor>
      <arglist>(const Glib::ustring &amp;display_name, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_display_name_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a74d219d321dca3d438f876256dee82d2</anchor>
      <arglist>(const Glib::ustring &amp;display_name, const SlotAsyncReady &amp;slot, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; File &gt;</type>
      <name>set_display_name_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a101b555723233014c0185dd505303f0a</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>remove</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>aded971b0cf84801f6684ad4bd5dc66c5</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>remove</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a14f34508dea523cbf889b7193e513ca4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>trash</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>acae5ecd962e832cf8d538877f4118da8</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>trash</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a1925736f9af338eaf9942468b4d6d65e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>copy</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>af9e906ed93069e6adb6d87dae158cad9</anchor>
      <arglist>(const Glib::RefPtr&lt; File &gt; &amp;destination, const SlotFileProgress &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, FileCopyFlags flags=FILE_COPY_NONE)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>copy</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a1d8159b5b377db174b376b3c09deb7c1</anchor>
      <arglist>(const Glib::RefPtr&lt; File &gt; &amp;destination, const SlotFileProgress &amp;slot, FileCopyFlags flags=FILE_COPY_NONE)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>copy</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a7a6b45bed32567031bc7b48273ad4079</anchor>
      <arglist>(const Glib::RefPtr&lt; File &gt; &amp;destination, FileCopyFlags flags=FILE_COPY_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a1785b7a4780d5d4ba5ae651350e34398</anchor>
      <arglist>(const Glib::RefPtr&lt; File &gt; &amp;destination, const SlotFileProgress &amp;slot_progress, const SlotAsyncReady &amp;slot_ready, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, FileCopyFlags flags=FILE_COPY_NONE, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a5b8ae7393c73a9a1d383a82d61f4ac30</anchor>
      <arglist>(const Glib::RefPtr&lt; File &gt; &amp;destination, const SlotAsyncReady &amp;slot_ready, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, FileCopyFlags flags=FILE_COPY_NONE, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ac2b1a85f29bbbe15998c090b3794cbf5</anchor>
      <arglist>(const Glib::RefPtr&lt; File &gt; &amp;destination, const SlotFileProgress &amp;slot_progress, const SlotAsyncReady &amp;slot_ready, FileCopyFlags flags=FILE_COPY_NONE, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ad538a383b8761d04bd36ed1aa1071e50</anchor>
      <arglist>(const Glib::RefPtr&lt; File &gt; &amp;destination, const SlotAsyncReady &amp;slot_ready, FileCopyFlags flags=FILE_COPY_NONE, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>copy_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a68294636a2d649c9de53332faee02cf6</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>move</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a51c0d55880178c37dee578fdc723b0f2</anchor>
      <arglist>(const Glib::RefPtr&lt; File &gt; &amp;destination, const SlotFileProgress &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, FileCopyFlags flags=FILE_COPY_NONE)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>move</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>adfb2d8bfed1cb7af50e5e5795ebea732</anchor>
      <arglist>(const Glib::RefPtr&lt; File &gt; &amp;destination, const SlotFileProgress &amp;slot, FileCopyFlags flags=FILE_COPY_NONE)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>move</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>aba1fab56c3a8bea0b7e4d7f7324c5320</anchor>
      <arglist>(const Glib::RefPtr&lt; File &gt; &amp;destination, FileCopyFlags flags=FILE_COPY_NONE)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>make_directory</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>abfa05e23e95e77cabac289ab4e294a58</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>make_directory</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>aa1e9aa5f58a76a8562fd00a13434f554</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>make_directory_with_parents</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>afb0b5b094339057b4b15952eb73e08d6</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>make_directory_with_parents</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a874a487551d49ca62b31a3e5cf32fee6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>make_symbolic_link</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a2709318e1f24dfd0cd498d28f5e1b8fe</anchor>
      <arglist>(const std::string &amp;symlink_value, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>make_symbolic_link</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a8a9a3d060c2675ff9ac1c758f0b2c024</anchor>
      <arglist>(const std::string &amp;symlink_value)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileAttributeInfoList &gt;</type>
      <name>query_settable_attributes</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a4a543339b58cff6a7e5ddd840df0e69e</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileAttributeInfoList &gt;</type>
      <name>query_settable_attributes</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a1ae03d0652bcfbad2f47409b8f815bc4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileAttributeInfoList &gt;</type>
      <name>query_writable_namespaces</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>af5c7463b92e2887597486e7b195ca12f</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileAttributeInfoList &gt;</type>
      <name>query_writable_namespaces</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>aa0278acd7d09ed292359004defb742b0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>set_attributes_from_info</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a69d9e40a85b96809abc5189b34e8d9b7</anchor>
      <arglist>(const Glib::RefPtr&lt; FileInfo &gt; &amp;info, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, FileQueryInfoFlags flags=FILE_QUERY_INFO_NONE)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>set_attributes_from_info</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ae9f6975ffef28f0d7145601a99de0903</anchor>
      <arglist>(const Glib::RefPtr&lt; FileInfo &gt; &amp;info, FileQueryInfoFlags flags=FILE_QUERY_INFO_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_attributes_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a14165fba9bf7d91448c3207407ae50c2</anchor>
      <arglist>(const Glib::RefPtr&lt; FileInfo &gt; &amp;info, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, FileQueryInfoFlags flags=FILE_QUERY_INFO_NONE, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_attributes_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a61317a1980318537aa8ada7bb8cc2390</anchor>
      <arglist>(const Glib::RefPtr&lt; FileInfo &gt; &amp;info, const SlotAsyncReady &amp;slot, FileQueryInfoFlags flags=FILE_QUERY_INFO_NONE, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>set_attributes_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>aefd45aed7b975b6e204e67927de2817a</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result, const Glib::RefPtr&lt; FileInfo &gt; &amp;info)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>set_attribute_string</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a5ce5f43fd5e2836ac1989a54d3233ff6</anchor>
      <arglist>(const std::string &amp;attribute, const std::string &amp;value, FileQueryInfoFlags flags, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>set_attribute_string</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a75fa7e1a44e97a910d232f2b4ab4bfdd</anchor>
      <arglist>(const std::string &amp;attribute, const std::string &amp;value, FileQueryInfoFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>set_attribute_byte_string</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a4f4373b8694c346a6908195f1f2644f3</anchor>
      <arglist>(const std::string &amp;attribute, const std::string &amp;value, FileQueryInfoFlags flags, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>set_attribute_byte_string</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a09f574259052186e1b516bdcbe696710</anchor>
      <arglist>(const std::string &amp;attribute, const std::string &amp;value, FileQueryInfoFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>set_attribute_uint32</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ae53b0f4d2214e050a290c8e35cac0f27</anchor>
      <arglist>(const std::string &amp;attribute, guint32 value, FileQueryInfoFlags flags, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>set_attribute_uint32</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a7f769f140143f2e96a7587a10b6792a9</anchor>
      <arglist>(const std::string &amp;attribute, guint32 value, FileQueryInfoFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>set_attribute_int32</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ab0290ecba7b06ccf7736e2292708667e</anchor>
      <arglist>(const std::string &amp;attribute, gint32 value, FileQueryInfoFlags flags, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>set_attribute_int32</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a4a707084a3c0a963548a21d17d0ec0b5</anchor>
      <arglist>(const std::string &amp;attribute, gint32 value, FileQueryInfoFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>set_attribute_uint64</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a48638081fd7af772a39af59a558b17f7</anchor>
      <arglist>(const std::string &amp;attribute, guint64 value, FileQueryInfoFlags flags, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>set_attribute_uint64</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a4aa77b3580df88cfd3d7231af78155c7</anchor>
      <arglist>(const std::string &amp;attribute, guint64 value, FileQueryInfoFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>set_attribute_int64</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a111d73a2d003e5a5a4c5f86c7c3d2fb7</anchor>
      <arglist>(const std::string &amp;attribute, gint64 value, FileQueryInfoFlags flags, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>set_attribute_int64</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a4477b0063110951b26c855696ec34802</anchor>
      <arglist>(const std::string &amp;attribute, gint64 value, FileQueryInfoFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>mount_enclosing_volume</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a144aa2de6b696da90a6baffbe959d732</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, MountMountFlags flags=MOUNT_MOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>mount_enclosing_volume</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a70fd22116d9c8682433c4bb8cbd764c1</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, const SlotAsyncReady &amp;slot, MountMountFlags flags=MOUNT_MOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>mount_enclosing_volume</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a2172cdcdb683630b719c521bf00b1eb4</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, MountMountFlags flags=MOUNT_MOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>mount_enclosing_volume</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a20f8f18876102a5efaa0536bfa71d71c</anchor>
      <arglist>(MountMountFlags flags=MOUNT_MOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>mount_enclosing_volume_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>aefd44b1b3467bcc474b345ff98b4aa6d</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>mount_mountable</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a40c88a403f5d01d722b5900545b6a4fe</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, MountMountFlags flags=MOUNT_MOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>mount_mountable</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ac3c29682ef5a50de73dc2c3c3333301c</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, const SlotAsyncReady &amp;slot, MountMountFlags flags=MOUNT_MOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>mount_mountable</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a049e06c3d95b49ad4bff1837ef6d8677</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, MountMountFlags flags=MOUNT_MOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>mount_mountable</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a8501fa88f4aaa8d52c001596960a4572</anchor>
      <arglist>(MountMountFlags flags=MOUNT_MOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; File &gt;</type>
      <name>mount_mountable_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ae15d36a7969c55122b9f85a1690a46e8</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unmount_mountable</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a5b687c8f19411e955bb069c469be92b4</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unmount_mountable</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ab6c8e9ef0e5d83a271c8307b18e779d8</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unmount_mountable</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a95f3e87e198493f4332a08aa79f6ebd3</anchor>
      <arglist>(MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>unmount_mountable_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a51458cf04ad25e4a784a3ebcb906155d</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>eject_mountable</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a8a8223e3b661f03c7a60ac0f003b916e</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>eject_mountable</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ad8422a939a634d2248ef6d8658f0fdad</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>eject_mountable</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>aeb28fd505cab23a82c68ff00445b12e7</anchor>
      <arglist>(MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>eject_mountable_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a6a5124de7c55e9dc5e85ffcb9d3dd14f</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>copy_attributes</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a90726dcf94248d2fddf2e4c8584b7bf0</anchor>
      <arglist>(const Glib::RefPtr&lt; File &gt; &amp;destination, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, FileCopyFlags flags=FILE_COPY_NONE)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>copy_attributes</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a05c1101ede98028c9234486eb0434250</anchor>
      <arglist>(const Glib::RefPtr&lt; File &gt; &amp;destination, FileCopyFlags flags=FILE_COPY_NONE)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileMonitor &gt;</type>
      <name>monitor_directory</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>aa0fa22ffba0ff50779e49ff9d12344e6</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, FileMonitorFlags flags=FILE_MONITOR_NONE)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileMonitor &gt;</type>
      <name>monitor_directory</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a12d36689c1024ff9fc8819f619910a92</anchor>
      <arglist>(FileMonitorFlags flags=FILE_MONITOR_NONE)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileMonitor &gt;</type>
      <name>monitor_file</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ab8e14809f330ddd58e628c96921cd987</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, FileMonitorFlags flags=FILE_MONITOR_NONE)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileMonitor &gt;</type>
      <name>monitor_file</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>aa410183ed3b4a745093383d038d271b9</anchor>
      <arglist>(FileMonitorFlags flags=FILE_MONITOR_NONE)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileMonitor &gt;</type>
      <name>monitor</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a88aacee7bb6f6d968b4383311a9dd002</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, FileMonitorFlags flags=FILE_MONITOR_NONE)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileMonitor &gt;</type>
      <name>monitor</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a50896969a9de87f810f0bf5e2d3335bd</anchor>
      <arglist>(FileMonitorFlags flags=FILE_MONITOR_NONE)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; AppInfo &gt;</type>
      <name>query_default_handler</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a753546465735b25633b003333b66d05c</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; AppInfo &gt;</type>
      <name>query_default_handler</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a0c0fd0ece2570b6704889df5ee43c283</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>load_contents</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ac53be228d732b34e062a2a57814cdf15</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, char *&amp;contents, gsize &amp;length, std::string &amp;etag_out)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>load_contents</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ada7c826a417f88b405244c8dc39ae1ef</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, char *&amp;contents, gsize &amp;length)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>load_contents</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a77f7781b0ba65bc4e7e613b80b353fd7</anchor>
      <arglist>(char *&amp;contents, gsize &amp;length, std::string &amp;etag_out)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>load_contents</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a40f3ce7cf905144bac7218f9988d2d35</anchor>
      <arglist>(char *&amp;contents, gsize &amp;length)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>load_contents_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ad0e02ebffbaa13036e4636d2118f71a0</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>load_contents_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a6af7ec98d5543bce07b917b65d7276ce</anchor>
      <arglist>(const SlotAsyncReady &amp;slot)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>load_contents_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a5fd15277ab90bcc57db088be04cac457</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result, char *&amp;contents, gsize &amp;length, std::string &amp;etag_out)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>load_contents_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>aee93c7e24e8391615f9f263584fb02bd</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result, char *&amp;contents, gsize &amp;length)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>load_partial_contents_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a0e8d95fcdf7c2aa38f54e90a22d3ab6f</anchor>
      <arglist>(const SlotReadMore &amp;slot_read_more, const SlotAsyncReady &amp;slot_async_ready, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>load_partial_contents_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a362d71932c0ba8797a8c47b77df1b6d7</anchor>
      <arglist>(const SlotReadMore &amp;slot_read_more, const SlotAsyncReady &amp;slot_async_ready)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>load_partial_contents_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a4b323508401d2e6fd2b3ad659f9bb5eb</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result, char *&amp;contents, gsize &amp;length, std::string &amp;etag_out)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>load_partial_contents_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ae3a59c3831feeadea9bd0709617d2db9</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result, char *&amp;contents, gsize &amp;length)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>replace_contents</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>af10deca1d5c5d1f650d3b182624330dc</anchor>
      <arglist>(const char *contents, gsize length, const std::string &amp;etag, std::string &amp;new_etag, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, bool make_backup=false, FileCreateFlags flags=FILE_CREATE_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>replace_contents</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ae7febf1f0f3b4b9efca9fae469082846</anchor>
      <arglist>(const char *contents, gsize length, const std::string &amp;etag, std::string &amp;new_etag, bool make_backup=false, FileCreateFlags flags=FILE_CREATE_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>replace_contents</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a23126b43cd262b63c0e458c3a4d0b65c</anchor>
      <arglist>(const std::string &amp;contents, const std::string &amp;etag, std::string &amp;new_etag, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, bool make_backup=false, FileCreateFlags flags=FILE_CREATE_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>replace_contents</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>aaf33a17461ff4f70fed06818e364f617</anchor>
      <arglist>(const std::string &amp;contents, const std::string &amp;etag, std::string &amp;new_etag, bool make_backup=false, FileCreateFlags flags=FILE_CREATE_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>replace_contents_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ad33b24a7942429157f47379f4353378c</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const char *contents, gsize length, const std::string &amp;etag, bool make_backup=false, FileCreateFlags flags=FILE_CREATE_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>replace_contents_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a9a1c445e84124e16294974a73f2f1bbb</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const char *contents, gsize length, const std::string &amp;etag, bool make_backup=false, FileCreateFlags flags=FILE_CREATE_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>replace_contents_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a380d6ce6362fc05e0e18ff1b881ceac7</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const std::string &amp;contents, const std::string &amp;etag, bool make_backup=false, FileCreateFlags flags=FILE_CREATE_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>replace_contents_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a6fc86aab90620881899a701c2b2775cb</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const std::string &amp;contents, const std::string &amp;etag, bool make_backup=false, FileCreateFlags flags=FILE_CREATE_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>replace_contents_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>af019065c5503c7f47d778c20f8e5de32</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result, std::string &amp;etag)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>replace_contents_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>af0372ffd3f535f39b7e48c0483e4c1f4</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>add_interface</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>aa9352e68c93431dd16b8ac587703772f</anchor>
      <arglist>(GType gtype_implementer)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; File &gt;</type>
      <name>create_for_path</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a1b1a4553b226689d50b9525488223e25</anchor>
      <arglist>(const std::string &amp;path)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; File &gt;</type>
      <name>create_for_uri</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a412b6b55f37f69bd4fb8fbd24d4967be</anchor>
      <arglist>(const std::string &amp;uri)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; File &gt;</type>
      <name>create_for_commandline_arg</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ab311a1c606b3907865fc8aecd4691de8</anchor>
      <arglist>(const std::string &amp;arg)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; File &gt;</type>
      <name>create_for_parse_name</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a7532baa6ce71fe27cfd1e9bba91a3536</anchor>
      <arglist>(const Glib::ustring &amp;parse_name)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::File &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a69670cdc7cf63783d6f9370dcbd7cc3d</anchor>
      <arglist>(GFile *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::FileAttributeInfo</name>
    <filename>classGio_1_1FileAttributeInfo.html</filename>
    <member kind="function">
      <type></type>
      <name>FileAttributeInfo</name>
      <anchorfile>classGio_1_1FileAttributeInfo.html</anchorfile>
      <anchor>a5e4777c01a420d7265f4ccd8ed230189</anchor>
      <arglist>(const GFileAttributeInfo *ginfo)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>FileAttributeInfo</name>
      <anchorfile>classGio_1_1FileAttributeInfo.html</anchorfile>
      <anchor>aa290f394f7f34b5b7ba9dbb7453ae792</anchor>
      <arglist>(const FileAttributeInfo &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>FileAttributeInfo &amp;</type>
      <name>operator=</name>
      <anchorfile>classGio_1_1FileAttributeInfo.html</anchorfile>
      <anchor>a19efa84d8e3f28299a2b89f86c9c7730</anchor>
      <arglist>(const FileAttributeInfo &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~FileAttributeInfo</name>
      <anchorfile>classGio_1_1FileAttributeInfo.html</anchorfile>
      <anchor>af7057435f526fc718c2be147d0df5b79</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_name</name>
      <anchorfile>classGio_1_1FileAttributeInfo.html</anchorfile>
      <anchor>ae2775dbf3905b88f52aee3828819792d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>FileAttributeType</type>
      <name>get_type</name>
      <anchorfile>classGio_1_1FileAttributeInfo.html</anchorfile>
      <anchor>a113f8e990486cf35c33d4963342483f0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>FileAttributeInfoFlags</type>
      <name>get_flags</name>
      <anchorfile>classGio_1_1FileAttributeInfo.html</anchorfile>
      <anchor>af3e06df4bf2d01ed2f1ff763c7ae01f9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>std::string</type>
      <name>m_name</name>
      <anchorfile>classGio_1_1FileAttributeInfo.html</anchorfile>
      <anchor>ab3ac15f750d21ddb4f6c7cd3240f8e03</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>FileAttributeType</type>
      <name>m_type</name>
      <anchorfile>classGio_1_1FileAttributeInfo.html</anchorfile>
      <anchor>abd2c79feb25a7adc6b9806d6b75d8c9e</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>FileAttributeInfoFlags</type>
      <name>m_flags</name>
      <anchorfile>classGio_1_1FileAttributeInfo.html</anchorfile>
      <anchor>a0b17e6847bad0bab1d90b7a3025e7dbf</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::FileAttributeInfoList</name>
    <filename>classGio_1_1FileAttributeInfoList.html</filename>
    <member kind="function">
      <type>void</type>
      <name>reference</name>
      <anchorfile>classGio_1_1FileAttributeInfoList.html</anchorfile>
      <anchor>a1dd9c6baf89e1254fbed44338eb0a4a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unreference</name>
      <anchorfile>classGio_1_1FileAttributeInfoList.html</anchorfile>
      <anchor>a889a9813bba642c384b9b2d05bae0823</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GFileAttributeInfoList *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1FileAttributeInfoList.html</anchorfile>
      <anchor>a8aba8445408cbf56722946723e6919a7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GFileAttributeInfoList *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1FileAttributeInfoList.html</anchorfile>
      <anchor>a030d5b7ddafbfa9e1b15d92254530203</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GFileAttributeInfoList *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1FileAttributeInfoList.html</anchorfile>
      <anchor>a2339b9d0f1a13935e58bfd1a2210cdb8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>operator bool</name>
      <anchorfile>classGio_1_1FileAttributeInfoList.html</anchorfile>
      <anchor>ae30d388537b163f12846afa47638e7be</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>empty</name>
      <anchorfile>classGio_1_1FileAttributeInfoList.html</anchorfile>
      <anchor>a7584d4757d8ff2cab6dbc3bb1d28da94</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>FileAttributeInfo</type>
      <name>lookup</name>
      <anchorfile>classGio_1_1FileAttributeInfoList.html</anchorfile>
      <anchor>a821a7de06545be2c6e18d7a53c5770eb</anchor>
      <arglist>(const std::string &amp;name) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileAttributeInfoList &gt;</type>
      <name>dup</name>
      <anchorfile>classGio_1_1FileAttributeInfoList.html</anchorfile>
      <anchor>a4253d86702cb4b18859e7ba06cb7e1fc</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>add</name>
      <anchorfile>classGio_1_1FileAttributeInfoList.html</anchorfile>
      <anchor>aed2f07a9ff6a250c3b8fa06324765c2f</anchor>
      <arglist>(const std::string &amp;name, FileAttributeType type, FileAttributeInfoFlags flags=FILE_ATTRIBUTE_INFO_NONE)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; FileAttributeInfoList &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1FileAttributeInfoList.html</anchorfile>
      <anchor>a0a0d066b1b2e3a0a533895922ff4c14a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>FileAttributeInfoList</name>
      <anchorfile>classGio_1_1FileAttributeInfoList.html</anchorfile>
      <anchor>af647ecbd4ab360b48deae74066993251</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>operator delete</name>
      <anchorfile>classGio_1_1FileAttributeInfoList.html</anchorfile>
      <anchor>af33439073a6052f731c8712aaa08ef5b</anchor>
      <arglist>(void *, size_t)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::FileAttributeInfoList &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1FileAttributeInfoList.html</anchorfile>
      <anchor>a7f7b3ffb2c6258de375ee4cc566c0089</anchor>
      <arglist>(GFileAttributeInfoList *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::FileEnumerator</name>
    <filename>classGio_1_1FileEnumerator.html</filename>
    <base>Glib::Object</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~FileEnumerator</name>
      <anchorfile>classGio_1_1FileEnumerator.html</anchorfile>
      <anchor>aa67510ecc9ddfbb3ef6f1d7ad560ca3f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GFileEnumerator *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1FileEnumerator.html</anchorfile>
      <anchor>a7c4e1d7258796a85d5b473e08168bd8c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GFileEnumerator *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1FileEnumerator.html</anchorfile>
      <anchor>aa54f2d24a93f78b20fa9c33913c862fd</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GFileEnumerator *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1FileEnumerator.html</anchorfile>
      <anchor>ac744c1c54800fb3764ea6ce5546f7937</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileInfo &gt;</type>
      <name>next_file</name>
      <anchorfile>classGio_1_1FileEnumerator.html</anchorfile>
      <anchor>a73b5814cb108be591316cedabe362800</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileInfo &gt;</type>
      <name>next_file</name>
      <anchorfile>classGio_1_1FileEnumerator.html</anchorfile>
      <anchor>a881873317d4a608d06405b3da3940e5a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>close</name>
      <anchorfile>classGio_1_1FileEnumerator.html</anchorfile>
      <anchor>a731c5e104949ecd082bcd6a2ada25641</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>close</name>
      <anchorfile>classGio_1_1FileEnumerator.html</anchorfile>
      <anchor>ad3729d377a08f39e3f4fc44d5c37409f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>next_files_async</name>
      <anchorfile>classGio_1_1FileEnumerator.html</anchorfile>
      <anchor>a78de4d8a6a97cc68fc236a69a730f033</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, int num_files=1, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>next_files_async</name>
      <anchorfile>classGio_1_1FileEnumerator.html</anchorfile>
      <anchor>ad51d86fbf6ebef0aed7f4321e1df6e79</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, int num_files=1, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ListHandle&lt; Glib::RefPtr&lt; FileInfo &gt; &gt;</type>
      <name>next_files_finish</name>
      <anchorfile>classGio_1_1FileEnumerator.html</anchorfile>
      <anchor>ab012d7f4428713efadbd10571f314973</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>close_async</name>
      <anchorfile>classGio_1_1FileEnumerator.html</anchorfile>
      <anchor>a0c878331956c2b28d749f561dbf84287</anchor>
      <arglist>(int io_priority, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const SlotAsyncReady &amp;slot)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>close_async</name>
      <anchorfile>classGio_1_1FileEnumerator.html</anchorfile>
      <anchor>aab848a136da3b0880f23e9084544e4ae</anchor>
      <arglist>(int io_priority, const SlotAsyncReady &amp;slot)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>close_finish</name>
      <anchorfile>classGio_1_1FileEnumerator.html</anchorfile>
      <anchor>a8f87519e9368a1db2399c24649976057</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_closed</name>
      <anchorfile>classGio_1_1FileEnumerator.html</anchorfile>
      <anchor>a3908b180f25ff93b1cb6cb86945981a1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>has_pending</name>
      <anchorfile>classGio_1_1FileEnumerator.html</anchorfile>
      <anchor>a3e1fb2fb2a8f8916929506828ded33b8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_pending</name>
      <anchorfile>classGio_1_1FileEnumerator.html</anchorfile>
      <anchor>a666470d02974350df0ed75f94321eaae</anchor>
      <arglist>(bool pending=true)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; File &gt;</type>
      <name>get_container</name>
      <anchorfile>classGio_1_1FileEnumerator.html</anchorfile>
      <anchor>a3ad9348edd27ff536e61ee6b87b0fd23</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const File &gt;</type>
      <name>get_container</name>
      <anchorfile>classGio_1_1FileEnumerator.html</anchorfile>
      <anchor>a639025c665bfef49b88902d16b889ec9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::FileEnumerator &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1FileEnumerator.html</anchorfile>
      <anchor>aba2d802d7865e00771c69e44da54318a</anchor>
      <arglist>(GFileEnumerator *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::FileIcon</name>
    <filename>classGio_1_1FileIcon.html</filename>
    <base>Glib::Object</base>
    <base>Gio::LoadableIcon</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~FileIcon</name>
      <anchorfile>classGio_1_1FileIcon.html</anchorfile>
      <anchor>a9e9ac46fa3312d274c8de2155a5343fe</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GFileIcon *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1FileIcon.html</anchorfile>
      <anchor>a0461feec986f30a389d7db0bfbc55673</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GFileIcon *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1FileIcon.html</anchorfile>
      <anchor>a018eb170dea43e7bf697baa73070e195</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GFileIcon *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1FileIcon.html</anchorfile>
      <anchor>ac56c21ee2b4cc36ba9b6d177fdc184a0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; File &gt;</type>
      <name>get_file</name>
      <anchorfile>classGio_1_1FileIcon.html</anchorfile>
      <anchor>a91c091a48d9acadf0fa4ba5817459b8d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const File &gt;</type>
      <name>get_file</name>
      <anchorfile>classGio_1_1FileIcon.html</anchorfile>
      <anchor>ad5414529acfb5cd8e118d8ce6cab676d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; FileIcon &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1FileIcon.html</anchorfile>
      <anchor>a09c67bb60019f8a14015d55ebfb89e25</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>FileIcon</name>
      <anchorfile>classGio_1_1FileIcon.html</anchorfile>
      <anchor>a2637e26120b3abc4711be125e212a72b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::FileIcon &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1FileIcon.html</anchorfile>
      <anchor>a211fbcdf28b3b87440c75b2c1a0212dd</anchor>
      <arglist>(GFileIcon *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::FileAttributeMatcher</name>
    <filename>classGio_1_1FileAttributeMatcher.html</filename>
    <member kind="function">
      <type>void</type>
      <name>reference</name>
      <anchorfile>classGio_1_1FileAttributeMatcher.html</anchorfile>
      <anchor>af9f21d4f8a594676e747583cbc3ad61b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unreference</name>
      <anchorfile>classGio_1_1FileAttributeMatcher.html</anchorfile>
      <anchor>a9e66e5a86c52725b6bd4f16781229775</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GFileAttributeMatcher *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1FileAttributeMatcher.html</anchorfile>
      <anchor>a34cf74569abe9a13c4412bf8f2347747</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GFileAttributeMatcher *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1FileAttributeMatcher.html</anchorfile>
      <anchor>a5e217b69f70586991b2ef272746aa7a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GFileAttributeMatcher *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1FileAttributeMatcher.html</anchorfile>
      <anchor>a35f18b4eb01427687fb0fe4f74dc0316</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>matches</name>
      <anchorfile>classGio_1_1FileAttributeMatcher.html</anchorfile>
      <anchor>a8e9f6798e6d368e0134ba00ca82106aa</anchor>
      <arglist>(const std::string &amp;full_name) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>matches_only</name>
      <anchorfile>classGio_1_1FileAttributeMatcher.html</anchorfile>
      <anchor>a664ac79f08935d6c13396a6d607aea84</anchor>
      <arglist>(const std::string &amp;full_name) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>enumerate_namespace</name>
      <anchorfile>classGio_1_1FileAttributeMatcher.html</anchorfile>
      <anchor>ac0edeabc8f07048f8bb2ba96d84983b8</anchor>
      <arglist>(const std::string &amp;ns)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>enumerate_next</name>
      <anchorfile>classGio_1_1FileAttributeMatcher.html</anchorfile>
      <anchor>a18103e91422814f576ff4b339bb085da</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; FileAttributeMatcher &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1FileAttributeMatcher.html</anchorfile>
      <anchor>a47b85316b6b6ce30841895ae6ef4f498</anchor>
      <arglist>(const std::string &amp;attributes=&quot;*&quot;)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>FileAttributeMatcher</name>
      <anchorfile>classGio_1_1FileAttributeMatcher.html</anchorfile>
      <anchor>ae91e6b65ca5bb2c635f5bdf9cba56ed7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>operator delete</name>
      <anchorfile>classGio_1_1FileAttributeMatcher.html</anchorfile>
      <anchor>a51a9c2dc02b96c5d902988c4a2a1bdae</anchor>
      <arglist>(void *, size_t)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::FileAttributeMatcher &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1FileAttributeMatcher.html</anchorfile>
      <anchor>a55c8ef1a5445afd09cc530d7c4945b7b</anchor>
      <arglist>(GFileAttributeMatcher *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::FileInfo</name>
    <filename>classGio_1_1FileInfo.html</filename>
    <base>Glib::Object</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~FileInfo</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>aaa6efce7f09cab1619475b27860a72cd</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GFileInfo *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>ae03eb9c62254cc8581e3ec757f8d98a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GFileInfo *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a631bcd07a3ae085260e7b3358444dd4a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GFileInfo *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a4c85d7a363f3925102ae03442472ac7d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>FileInfo</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a740057465d0744299ef0f118b7efe083</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileInfo &gt;</type>
      <name>dup</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a15f9fc3eeafd0fa4e90d51d22781be99</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy_into</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a43dff76c39bb388b7d67d77fa0024d25</anchor>
      <arglist>(Glib::RefPtr&lt; FileInfo &gt; &amp;dest) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>has_attribute</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>aa18458a7c75729d9521b3b0988bb9322</anchor>
      <arglist>(const std::string &amp;attribute) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::StringArrayHandle</type>
      <name>list_attributes</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a784a82a76bd8a10d16e6e78d311a8cae</anchor>
      <arglist>(const std::string &amp;name_space) const </arglist>
    </member>
    <member kind="function">
      <type>FileAttributeType</type>
      <name>get_attribute_type</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>ad9dfbef62139e9ea6d259d4bbe6b8b92</anchor>
      <arglist>(const std::string &amp;attribute) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove_attribute</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>ab36ffcf14c535c7fbbbb94907a3516c9</anchor>
      <arglist>(const std::string &amp;attribute)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_attribute_string</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>aad2362ace81fdccc95eed6cf4e84af41</anchor>
      <arglist>(const std::string &amp;attribute) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_attribute_as_string</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a75ee20462c4f2dc2c696611427a98d8c</anchor>
      <arglist>(const std::string &amp;attribute) const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_attribute_byte_string</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a4803fb91a2fd7a754f030b63962b2bef</anchor>
      <arglist>(const std::string &amp;attribute) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_attribute_boolean</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a167589bb3e2fa091d7717abe6405fd9a</anchor>
      <arglist>(const std::string &amp;attribute) const </arglist>
    </member>
    <member kind="function">
      <type>guint32</type>
      <name>get_attribute_uint32</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a4f84f3668092ae12b0f89f3ff985e9b4</anchor>
      <arglist>(const std::string &amp;attribute) const </arglist>
    </member>
    <member kind="function">
      <type>gint32</type>
      <name>get_attribute_int32</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>ad450ccf254244a053c11b14e88695c2f</anchor>
      <arglist>(const std::string &amp;attribute) const </arglist>
    </member>
    <member kind="function">
      <type>guint64</type>
      <name>get_attribute_uint64</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a382b0afbec9d9ba59e7fbb7cbe5fc5a5</anchor>
      <arglist>(const std::string &amp;attribute) const </arglist>
    </member>
    <member kind="function">
      <type>gint64</type>
      <name>get_attribute_int64</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>aeb52d13f7ad792ca3cfa527a85b89809</anchor>
      <arglist>(const std::string &amp;attribute) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Glib::Object &gt;</type>
      <name>get_attribute_object</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a6211b572545a437f9691297cf439d394</anchor>
      <arglist>(const std::string &amp;attribute) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_attribute_string</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a6273bbf43d262c18a67d5b407af8237c</anchor>
      <arglist>(const std::string &amp;attribute, const std::string &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_attribute_byte_string</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a65571d11697c7668be664b05145be73e</anchor>
      <arglist>(const std::string &amp;attribute, const std::string &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_attribute_boolean</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a417d65b3879da104191b15aa31094e27</anchor>
      <arglist>(const std::string &amp;attribute, bool value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_attribute_uint32</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>adeb6d97a7234f8cb9f597530b16bd1e6</anchor>
      <arglist>(const std::string &amp;attribute, guint32 value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_attribute_int32</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>adc1806943e1726b44e1b41eddf79f8cf</anchor>
      <arglist>(const std::string &amp;attribute, gint32 value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_attribute_uint64</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>acea5263ac50a21b59bd24075d2066ead</anchor>
      <arglist>(const std::string &amp;attribute, guint64 value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_attribute_int64</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a1fe7d70aa6504797ba032e50c767e23a</anchor>
      <arglist>(const std::string &amp;attribute, gint64 value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_attribute_object</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>ae2a4f18e80b03de854a29fc4fbfbcae7</anchor>
      <arglist>(const std::string &amp;attribute, const Glib::RefPtr&lt; Glib::Object &gt; &amp;object)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>clear_status</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>ac00eda5b1db8e5c7d3a756a43efe47fb</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>FileType</type>
      <name>get_file_type</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>abf62545b515bef26ead386be87750edb</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_hidden</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a58ec7193682510c1455a6547fcabddb4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_backup</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a0e782dc65b4a048628c35af89bc2b894</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_symlink</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a7a7ef1e79deefd16be5fcea5ed00e6d5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_name</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a2a237a251dce16850d2365f246e48e4e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_display_name</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>aab26e342861a38ea9cfcd8b52813d655</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_edit_name</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a92f5240ac06f5848072e2f43aeb71516</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Icon &gt;</type>
      <name>get_icon</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>ad835c26e3252232a437d1013a5ed9aa3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const Icon &gt;</type>
      <name>get_icon</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>afa956e081955525b68c5af3f291b7b8c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_content_type</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>aa67a68ee61c7b43f2051cf8639966e75</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>goffset</type>
      <name>get_size</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a298f0414de960d56bb5a2bcd951f4900</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::TimeVal</type>
      <name>modification_time</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a0bb8836539f5a2f4fe61c07e335110c9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_symlink_target</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a848a2f85fa4f84c6477e076987d28770</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_etag</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>aaa44913ffe15c029ce09dfe828cf0a0b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>gint32</type>
      <name>get_sort_order</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a6527af61c645715e24863592246545b3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_attribute_mask</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>add9025ae3f25e5213ab8fba055a4e09d</anchor>
      <arglist>(const Glib::RefPtr&lt; FileAttributeMatcher &gt; &amp;mask)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unset_attribute_mask</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>afb9178c888fbf6fd2ef1344bc8523ba3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_file_type</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>ab3ceaaaf6112575fd1b9cd6c75112606</anchor>
      <arglist>(FileType type)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_is_hidden</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>af817a5e2d32a2a7d0130c53e4bb3ca72</anchor>
      <arglist>(bool is_hidden=true)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_is_symlink</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a79304bdfa1e1e5e73f895c896ddf730e</anchor>
      <arglist>(bool is_symlink=true)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_name</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>af2430c30058f424bbc71c342fd2e9cda</anchor>
      <arglist>(const std::string &amp;name)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_display_name</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a6c0171f42d0877023cfe574b77359b59</anchor>
      <arglist>(const std::string &amp;display_name)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_edit_name</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a0aec971ea570c1946b8e57462e1bc9ce</anchor>
      <arglist>(const std::string &amp;edit_name)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_icon</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a3bd4ac6face055102cd02c679056a16a</anchor>
      <arglist>(const Glib::RefPtr&lt; Icon &gt; &amp;icon)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_content_type</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a1a07b5776ff1a1a8ed8d942710df5688</anchor>
      <arglist>(const std::string &amp;content_type)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_size</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>ac50fe95ac1dd596d44cd40225af223f5</anchor>
      <arglist>(goffset size)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_modification_time</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a999893faef31be8d0989415852ec527e</anchor>
      <arglist>(const Glib::TimeVal &amp;mtime)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_symlink_target</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>af0ca88a17c88c40b58890a68278528c4</anchor>
      <arglist>(const std::string &amp;symlink_target)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_sort_order</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>afec884c7bd2f655c7a3fe0122dfb4390</anchor>
      <arglist>(gint32 sort_order)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::FileInfo &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>aa08fd4d65078c227da321348eed9519d</anchor>
      <arglist>(GFileInfo *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::FileInputStream</name>
    <filename>classGio_1_1FileInputStream.html</filename>
    <base>Gio::InputStream</base>
    <base>Gio::Seekable</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~FileInputStream</name>
      <anchorfile>classGio_1_1FileInputStream.html</anchorfile>
      <anchor>a8039942e23f7821a67f7d1003b486b73</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GFileInputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1FileInputStream.html</anchorfile>
      <anchor>a5411e06810e06ad339d7a21257772219</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GFileInputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1FileInputStream.html</anchorfile>
      <anchor>ab1afea7b758100ca02a6aa5b89d57662</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GFileInputStream *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1FileInputStream.html</anchorfile>
      <anchor>aa35ad981b6f18b1e5ece395970c5991b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileInfo &gt;</type>
      <name>query_info</name>
      <anchorfile>classGio_1_1FileInputStream.html</anchorfile>
      <anchor>ae9cf87761484839f4ea53bc33064f189</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const std::string &amp;attributes=&quot;*&quot;)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileInfo &gt;</type>
      <name>query_info</name>
      <anchorfile>classGio_1_1FileInputStream.html</anchorfile>
      <anchor>a6ff4fe91f63b1eb38cca93591ba1f263</anchor>
      <arglist>(const std::string &amp;attributes=&quot;*&quot;)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>query_info_async</name>
      <anchorfile>classGio_1_1FileInputStream.html</anchorfile>
      <anchor>a50c9554cfa15b88a1d30c7719569cc5f</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const std::string &amp;attributes=&quot;*&quot;, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>query_info_async</name>
      <anchorfile>classGio_1_1FileInputStream.html</anchorfile>
      <anchor>a21f82f427ab1e958308889b78308dcdf</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const std::string &amp;attributes=&quot;*&quot;, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileInfo &gt;</type>
      <name>query_info_finish</name>
      <anchorfile>classGio_1_1FileInputStream.html</anchorfile>
      <anchor>a1c8e42e09d92c59b05d122eead3e3161</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::FileInputStream &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1FileInputStream.html</anchorfile>
      <anchor>aa3ca60bf8d52cd8c7d2688e58d634a36</anchor>
      <arglist>(GFileInputStream *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::FileIOStream</name>
    <filename>classGio_1_1FileIOStream.html</filename>
    <base>Gio::IOStream</base>
    <base>Gio::Seekable</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~FileIOStream</name>
      <anchorfile>classGio_1_1FileIOStream.html</anchorfile>
      <anchor>a7b412e59741edea22ef424786aa2665a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GFileIOStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1FileIOStream.html</anchorfile>
      <anchor>a382fe1830e5e347db4ae0d941398c0df</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GFileIOStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1FileIOStream.html</anchorfile>
      <anchor>acd384df600b1aea26bd10ca2e74f1b21</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GFileIOStream *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1FileIOStream.html</anchorfile>
      <anchor>a2661e78434e66d48a54aa67ddd4d4e53</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileInfo &gt;</type>
      <name>query_info</name>
      <anchorfile>classGio_1_1FileIOStream.html</anchorfile>
      <anchor>a11c3696bd12879c7554a8be1246ca069</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const std::string &amp;attributes=&quot;*&quot;)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileInfo &gt;</type>
      <name>query_info</name>
      <anchorfile>classGio_1_1FileIOStream.html</anchorfile>
      <anchor>a1c4cefdd3b2ff134f01ecbc7a4439921</anchor>
      <arglist>(const std::string &amp;attributes=&quot;*&quot;)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>query_info_async</name>
      <anchorfile>classGio_1_1FileIOStream.html</anchorfile>
      <anchor>ae83afafd7a40cc116026af5452c26151</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const std::string &amp;attributes=&quot;*&quot;, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>query_info_async</name>
      <anchorfile>classGio_1_1FileIOStream.html</anchorfile>
      <anchor>aeafe3bd19e6cf993dd7a2bb4e27ebd4d</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const std::string &amp;attributes=&quot;*&quot;, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileInfo &gt;</type>
      <name>query_info_finish</name>
      <anchorfile>classGio_1_1FileIOStream.html</anchorfile>
      <anchor>a9838bea653f37c9ff298e16a96ce11dd</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_etag</name>
      <anchorfile>classGio_1_1FileIOStream.html</anchorfile>
      <anchor>a98607843697e850776bd6736a93df4d5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::FileIOStream &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1FileIOStream.html</anchorfile>
      <anchor>a44679bcc0dadcf0eb3bf2691e51e7e98</anchor>
      <arglist>(GFileIOStream *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::FileMonitor</name>
    <filename>classGio_1_1FileMonitor.html</filename>
    <base>Glib::Object</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~FileMonitor</name>
      <anchorfile>classGio_1_1FileMonitor.html</anchorfile>
      <anchor>a6ffb078bc2ce7e7c4dde4c5731fa1f08</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GFileMonitor *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1FileMonitor.html</anchorfile>
      <anchor>a047a5032cf7905ecc37c6379e8c82f35</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GFileMonitor *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1FileMonitor.html</anchorfile>
      <anchor>a3930ab1dd57d0ec9341edf13bd62712f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GFileMonitor *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1FileMonitor.html</anchorfile>
      <anchor>a989efd770a3a68bc77f1917751feec9e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>cancel</name>
      <anchorfile>classGio_1_1FileMonitor.html</anchorfile>
      <anchor>ab6bdfc13b4a27521304c9be8aedec677</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_cancelled</name>
      <anchorfile>classGio_1_1FileMonitor.html</anchorfile>
      <anchor>ae5ebb0182704c6ea8314c6f0a6106fad</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_rate_limit</name>
      <anchorfile>classGio_1_1FileMonitor.html</anchorfile>
      <anchor>a47b6ca4693b67efead6c8dde6d526b31</anchor>
      <arglist>(int limit_msecs)</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy3&lt; void, const Glib::RefPtr&lt; File &gt; &amp;, const Glib::RefPtr&lt; File &gt; &amp;, FileMonitorEvent &gt;</type>
      <name>signal_changed</name>
      <anchorfile>classGio_1_1FileMonitor.html</anchorfile>
      <anchor>a36215dcf2bf7a9476284f419f163aad9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; int &gt;</type>
      <name>property_rate_limit</name>
      <anchorfile>classGio_1_1FileMonitor.html</anchorfile>
      <anchor>a3e6afeaa6d7985f5e6ee16b140277eff</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; int &gt;</type>
      <name>property_rate_limit</name>
      <anchorfile>classGio_1_1FileMonitor.html</anchorfile>
      <anchor>ab592fb7ad93948d35e8a19c8aebf2912</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_cancelled</name>
      <anchorfile>classGio_1_1FileMonitor.html</anchorfile>
      <anchor>a7c38219889f137400c15510ca309682c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_changed</name>
      <anchorfile>classGio_1_1FileMonitor.html</anchorfile>
      <anchor>a42c6d3679e90ad17504d3c0a5937da7c</anchor>
      <arglist>(const Glib::RefPtr&lt; File &gt; &amp;file, const Glib::RefPtr&lt; File &gt; &amp;other_file, FileMonitorEvent event_type)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::FileMonitor &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1FileMonitor.html</anchorfile>
      <anchor>a5ad2474eedfd1ae12f2c75003e6f26fe</anchor>
      <arglist>(GFileMonitor *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::FilenameCompleter</name>
    <filename>classGio_1_1FilenameCompleter.html</filename>
    <base>Glib::Object</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~FilenameCompleter</name>
      <anchorfile>classGio_1_1FilenameCompleter.html</anchorfile>
      <anchor>ad72f983849b2ba03e2ef98868b56b27f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GFilenameCompleter *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1FilenameCompleter.html</anchorfile>
      <anchor>a6fa2ba7f28935b557fac0dfe965fe916</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GFilenameCompleter *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1FilenameCompleter.html</anchorfile>
      <anchor>a0a627a9eac4a916e93f94bc4e7bc0d25</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GFilenameCompleter *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1FilenameCompleter.html</anchorfile>
      <anchor>ae069b04fba4a9fff00023476772a7b5b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_completion_suffix</name>
      <anchorfile>classGio_1_1FilenameCompleter.html</anchorfile>
      <anchor>ac881f6320fb90d70afa0a5a86a38db11</anchor>
      <arglist>(const std::string &amp;initial_text) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::StringArrayHandle</type>
      <name>get_completions</name>
      <anchorfile>classGio_1_1FilenameCompleter.html</anchorfile>
      <anchor>aa56775c73bc3d1bd5a9749926d8a7134</anchor>
      <arglist>(const std::string &amp;initial_text) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_dirs_only</name>
      <anchorfile>classGio_1_1FilenameCompleter.html</anchorfile>
      <anchor>abe7160d315c69ed35cdd5e1a25cf06bc</anchor>
      <arglist>(bool dirs_only=true)</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy0&lt; void &gt;</type>
      <name>signal_got_completion_data</name>
      <anchorfile>classGio_1_1FilenameCompleter.html</anchorfile>
      <anchor>a3acc6e4468f03d924b9efae217b49e70</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; FilenameCompleter &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1FilenameCompleter.html</anchorfile>
      <anchor>aeb7c3042c2f76a62f6806921bef56e89</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>FilenameCompleter</name>
      <anchorfile>classGio_1_1FilenameCompleter.html</anchorfile>
      <anchor>a1db98397daf75605c3a827f646ea98ff</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_got_completion_data</name>
      <anchorfile>classGio_1_1FilenameCompleter.html</anchorfile>
      <anchor>a092cefc4a3cbeff19f60ef75ebfc8b87</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::FilenameCompleter &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1FilenameCompleter.html</anchorfile>
      <anchor>ad03881744458e4aa6308376f5aebd2b3</anchor>
      <arglist>(GFilenameCompleter *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::FileOutputStream</name>
    <filename>classGio_1_1FileOutputStream.html</filename>
    <base>Gio::OutputStream</base>
    <base>Gio::Seekable</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~FileOutputStream</name>
      <anchorfile>classGio_1_1FileOutputStream.html</anchorfile>
      <anchor>ad441ab4039675535b59c65b4c5d14804</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GFileOutputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1FileOutputStream.html</anchorfile>
      <anchor>aa69b1c94c5a3a2e0002fc6cf5127fc70</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GFileOutputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1FileOutputStream.html</anchorfile>
      <anchor>a2bf847a5064b01e671731ecd56f88968</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GFileOutputStream *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1FileOutputStream.html</anchorfile>
      <anchor>af536865a9ed17c3093ab67465fba908b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileInfo &gt;</type>
      <name>query_info</name>
      <anchorfile>classGio_1_1FileOutputStream.html</anchorfile>
      <anchor>a660a0130611aad21965a3f74c2fe90cd</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const std::string &amp;attributes=&quot;*&quot;)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileInfo &gt;</type>
      <name>query_info</name>
      <anchorfile>classGio_1_1FileOutputStream.html</anchorfile>
      <anchor>a9b67d7fa0b9309ca42dea8607d2ef3d5</anchor>
      <arglist>(const std::string &amp;attributes=&quot;*&quot;)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>query_info_async</name>
      <anchorfile>classGio_1_1FileOutputStream.html</anchorfile>
      <anchor>a926ddca8782aeb271560a058ee6554aa</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const std::string &amp;attributes=&quot;*&quot;, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>query_info_async</name>
      <anchorfile>classGio_1_1FileOutputStream.html</anchorfile>
      <anchor>aa9297d379f28510afd0d5dabba65a447</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const std::string &amp;attributes=&quot;*&quot;, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileInfo &gt;</type>
      <name>query_info_finish</name>
      <anchorfile>classGio_1_1FileOutputStream.html</anchorfile>
      <anchor>aff73b62f94cc0be14f8271480aab6299</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_etag</name>
      <anchorfile>classGio_1_1FileOutputStream.html</anchorfile>
      <anchor>a8e29de4e67428a79b41180ca27af0a3d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::FileOutputStream &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1FileOutputStream.html</anchorfile>
      <anchor>a5fe0a7a8069a65b4a83b36f3a54b3142</anchor>
      <arglist>(GFileOutputStream *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::FilterInputStream</name>
    <filename>classGio_1_1FilterInputStream.html</filename>
    <base>Gio::InputStream</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~FilterInputStream</name>
      <anchorfile>classGio_1_1FilterInputStream.html</anchorfile>
      <anchor>a5d3ea75436d7681061f6c320225d7848</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GFilterInputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1FilterInputStream.html</anchorfile>
      <anchor>a6db43589745dcd172f4ca4082bc5d914</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GFilterInputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1FilterInputStream.html</anchorfile>
      <anchor>ac8fbd2cc879bfab4854d952b27ce271c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GFilterInputStream *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1FilterInputStream.html</anchorfile>
      <anchor>a55ef3320e423245cc69066c90785328e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; InputStream &gt;</type>
      <name>get_base_stream</name>
      <anchorfile>classGio_1_1FilterInputStream.html</anchorfile>
      <anchor>aa0e6304d8ea21a17b3e6a0127e3e7530</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const InputStream &gt;</type>
      <name>get_base_stream</name>
      <anchorfile>classGio_1_1FilterInputStream.html</anchorfile>
      <anchor>a41af6a4af682c043ac9c91ed13608705</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_close_base_stream</name>
      <anchorfile>classGio_1_1FilterInputStream.html</anchorfile>
      <anchor>a1a78226f76528f61c87ebe5a31b0f133</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_close_base_stream</name>
      <anchorfile>classGio_1_1FilterInputStream.html</anchorfile>
      <anchor>a82e03517a6841b170c7e13fcf2f66920</anchor>
      <arglist>(bool close_base=true)</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::RefPtr&lt; InputStream &gt; &gt;</type>
      <name>property_base_stream</name>
      <anchorfile>classGio_1_1FilterInputStream.html</anchorfile>
      <anchor>aee46182be8452b2b308e62b1fe932233</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_close_base_stream</name>
      <anchorfile>classGio_1_1FilterInputStream.html</anchorfile>
      <anchor>a9b5145644bfe5e2472cb219517ad54d0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::FilterInputStream &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1FilterInputStream.html</anchorfile>
      <anchor>a5f5a6b8c088b86f8671d9dfaed24ac70</anchor>
      <arglist>(GFilterInputStream *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::FilterOutputStream</name>
    <filename>classGio_1_1FilterOutputStream.html</filename>
    <base>Gio::OutputStream</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~FilterOutputStream</name>
      <anchorfile>classGio_1_1FilterOutputStream.html</anchorfile>
      <anchor>a65d7d0e8645a11065c74706d65e18fcd</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GFilterOutputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1FilterOutputStream.html</anchorfile>
      <anchor>a7cf09c946f16c1597e7ce038fd64f9ef</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GFilterOutputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1FilterOutputStream.html</anchorfile>
      <anchor>a4497fb9f0cb87f953bbc8fa5bb218a0c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GFilterOutputStream *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1FilterOutputStream.html</anchorfile>
      <anchor>ae0701328a1b8b2e71ba15dcdb83422b6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; OutputStream &gt;</type>
      <name>get_base_stream</name>
      <anchorfile>classGio_1_1FilterOutputStream.html</anchorfile>
      <anchor>a135f41e0b5e9ad029d17efdce11e3fd8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const OutputStream &gt;</type>
      <name>get_base_stream</name>
      <anchorfile>classGio_1_1FilterOutputStream.html</anchorfile>
      <anchor>a983b98a5bca8404c6ac515ff8048b61e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_close_base_stream</name>
      <anchorfile>classGio_1_1FilterOutputStream.html</anchorfile>
      <anchor>a5b9f78803d5860833114852fdbbf2d7b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_close_base_stream</name>
      <anchorfile>classGio_1_1FilterOutputStream.html</anchorfile>
      <anchor>ad02373553035aa1b1c3bb2bd578a24f6</anchor>
      <arglist>(bool close_base=true)</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::RefPtr&lt; InputStream &gt; &gt;</type>
      <name>property_base_stream</name>
      <anchorfile>classGio_1_1FilterOutputStream.html</anchorfile>
      <anchor>a080f2c7b32bcd1c05c04a437c5586afa</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_close_base_stream</name>
      <anchorfile>classGio_1_1FilterOutputStream.html</anchorfile>
      <anchor>a4f7d6b22bbc388ce128f71a9b7590b08</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::FilterOutputStream &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1FilterOutputStream.html</anchorfile>
      <anchor>ae070f4f975af2ac6beb39a5bef8d5f95</anchor>
      <arglist>(GFilterOutputStream *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::Icon</name>
    <filename>classGio_1_1Icon.html</filename>
    <base>Glib::Interface</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Icon</name>
      <anchorfile>classGio_1_1Icon.html</anchorfile>
      <anchor>a860156dd8f8c9143cce6fba134e5d7cb</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GIcon *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Icon.html</anchorfile>
      <anchor>a02ef784d9a07a205ce1d7daac39d2054</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GIcon *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Icon.html</anchorfile>
      <anchor>a94b7e4b63ce6c1c0f05673dd8b4adf94</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>guint</type>
      <name>hash</name>
      <anchorfile>classGio_1_1Icon.html</anchorfile>
      <anchor>acbcfcaa91ff4d50f700267e2928a61ae</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>to_string</name>
      <anchorfile>classGio_1_1Icon.html</anchorfile>
      <anchor>a7b0d721c852d1e5b0f9cd875769fabd7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>equal</name>
      <anchorfile>classGio_1_1Icon.html</anchorfile>
      <anchor>a90820057c0e8974d43d2597df18efb20</anchor>
      <arglist>(const Glib::RefPtr&lt; Icon &gt; &amp;other) const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>add_interface</name>
      <anchorfile>classGio_1_1Icon.html</anchorfile>
      <anchor>abd37e490fdf4da67eb3bbe2561c16ee3</anchor>
      <arglist>(GType gtype_implementer)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Icon &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1Icon.html</anchorfile>
      <anchor>a8ae9b8e7b8159620eea7f9215cac83ab</anchor>
      <arglist>(const std::string &amp;str)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::Icon &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1Icon.html</anchorfile>
      <anchor>a9f6d4523888318e40c362de6eea23004</anchor>
      <arglist>(GIcon *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::InetAddress</name>
    <filename>classGio_1_1InetAddress.html</filename>
    <base>Glib::Object</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~InetAddress</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>a681469990ccd8829c9c56f2c21b987ff</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GInetAddress *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>a814cf259fbe2075145372ff8f041e2fd</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GInetAddress *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>a02955cf2f6af819e6a33fae34f02a35d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GInetAddress *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>ac5740ac33a8c1507165bfb24ad05867b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const guint8 *</type>
      <name>to_bytes</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>a55511045dd96127a9e0c71277f6f09e9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>to_string</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>aad0c75db355f9202eb2d9abdfd62664f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>SocketFamily</type>
      <name>get_family</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>aad520fbba41d5d4ff350c0e0b8aa8bd2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_is_any</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>a195f40df5aa0a539d4199dd8c89b67ce</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_is_link_local</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>ae27877a353888bda5cc7d6ef439b6f43</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_is_loopback</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>a123434ddbf161d5bd24bdd6e1a242042</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_is_mc_global</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>a4bc588e6ceab049f81458d17a282a696</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_is_mc_link_local</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>a0759e79028e0f3a967f21e9aa785708c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_is_mc_node_local</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>a30fedd1ab379f61ad0d43822a7fbd414</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_is_mc_org_local</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>a1933a994b55b0d3198187813aadabb8a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_is_mc_site_local</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>af50cbe1bd1fc064e37759026f60a2e78</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_is_multicast</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>a1751ce4f0815d2bef25c789f6a7c2c51</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_is_site_local</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>a6f18baee3fd0e8d4411ed6300e3f4ac9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>gsize</type>
      <name>get_native_size</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>aadfe97104f2bc53014fd70a2f1d8541e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; InetAddress &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>ad9a5b29ab4211c5e6d03d7630d1f352e</anchor>
      <arglist>(const Glib::ustring &amp;string)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; InetAddress &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>ab34823f20a1719d0d4dd0b8908791196</anchor>
      <arglist>(const guint8 *bytes, SocketFamily family)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; InetAddress &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>a1bbce665174aea6b6fd13414e69ab2d9</anchor>
      <arglist>(SocketFamily family)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>InetAddress</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>a6da6b8c7cb8f15170ab889f912bc8486</anchor>
      <arglist>(const Glib::ustring &amp;string)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>InetAddress</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>aeca7299962f7b75793c493ff32d91abe</anchor>
      <arglist>(const guint8 *bytes, SocketFamily family)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>InetAddress</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>abd9c6a6a7a2aabedd88eafb4bfd69458</anchor>
      <arglist>(SocketFamily family)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::InetAddress &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>ab8ed0814ec989e9c9b07332b19958a01</anchor>
      <arglist>(GInetAddress *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::InetSocketAddress</name>
    <filename>classGio_1_1InetSocketAddress.html</filename>
    <base>Gio::SocketAddress</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~InetSocketAddress</name>
      <anchorfile>classGio_1_1InetSocketAddress.html</anchorfile>
      <anchor>a86c013c0d7971681b61da945543f1071</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GInetSocketAddress *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1InetSocketAddress.html</anchorfile>
      <anchor>a2185ff490fa658c11854df16c41910dc</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GInetSocketAddress *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1InetSocketAddress.html</anchorfile>
      <anchor>ad0a057e46b10504010e3e014d3207f4d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GInetSocketAddress *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1InetSocketAddress.html</anchorfile>
      <anchor>a0d165726f19e26d3c03a184510b6df2b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; InetAddress &gt;</type>
      <name>get_address</name>
      <anchorfile>classGio_1_1InetSocketAddress.html</anchorfile>
      <anchor>a28a044f52e94263559a50197d4ddfd6b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const InetAddress &gt;</type>
      <name>get_address</name>
      <anchorfile>classGio_1_1InetSocketAddress.html</anchorfile>
      <anchor>a0ff00835b7a56e1df1c18aaa3d842bea</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>guint16</type>
      <name>get_port</name>
      <anchorfile>classGio_1_1InetSocketAddress.html</anchorfile>
      <anchor>ae9fc68c477f6ed7915befb4131f42f42</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::RefPtr&lt; InetAddress &gt; &gt;</type>
      <name>property_address</name>
      <anchorfile>classGio_1_1InetSocketAddress.html</anchorfile>
      <anchor>a11ed0ddfae5e91401ff0e2a64c0e4486</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; guint16 &gt;</type>
      <name>property_port</name>
      <anchorfile>classGio_1_1InetSocketAddress.html</anchorfile>
      <anchor>a846bfac32dc21d47e98fe2576fa5c484</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; InetSocketAddress &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1InetSocketAddress.html</anchorfile>
      <anchor>a863fb8d260958e69d603e2903595a973</anchor>
      <arglist>(const Glib::RefPtr&lt; InetAddress &gt; &amp;address, guint16 port)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>InetSocketAddress</name>
      <anchorfile>classGio_1_1InetSocketAddress.html</anchorfile>
      <anchor>a54cf3e5885e7c14a26017ccdc5f552e8</anchor>
      <arglist>(const Glib::RefPtr&lt; InetAddress &gt; &amp;address, guint16 port)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::InetSocketAddress &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1InetSocketAddress.html</anchorfile>
      <anchor>a4498f65e8445567d4cacdc0a68437c33</anchor>
      <arglist>(GInetSocketAddress *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::Initable</name>
    <filename>classGio_1_1Initable.html</filename>
    <base>Glib::Interface</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Initable</name>
      <anchorfile>classGio_1_1Initable.html</anchorfile>
      <anchor>aa4da38b665a33995bf28ad1838253b7e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GInitable *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Initable.html</anchorfile>
      <anchor>a90206d58591c674e03c5de57623bac18</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GInitable *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Initable.html</anchorfile>
      <anchor>a30665fda96b812e27231ec5abc47b789</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>init</name>
      <anchorfile>classGio_1_1Initable.html</anchorfile>
      <anchor>a7dbee3b8e980bf52ae2a66e1523127a3</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>init</name>
      <anchorfile>classGio_1_1Initable.html</anchorfile>
      <anchor>a5881cf9c259d5af218585b7ecde38464</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>add_interface</name>
      <anchorfile>classGio_1_1Initable.html</anchorfile>
      <anchor>a6b68b1a2c2ab02ed1f25887c7acd121c</anchor>
      <arglist>(GType gtype_implementer)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::Initable &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1Initable.html</anchorfile>
      <anchor>a9a2f7929de61e6b32a2317fe0ebde865</anchor>
      <arglist>(GInitable *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::InputStream</name>
    <filename>classGio_1_1InputStream.html</filename>
    <base>Glib::Object</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~InputStream</name>
      <anchorfile>classGio_1_1InputStream.html</anchorfile>
      <anchor>afff624e3125add13c88e8a99907ba903</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GInputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1InputStream.html</anchorfile>
      <anchor>a2ed1120b3d03a12086e7f0ed3946aba1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GInputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1InputStream.html</anchorfile>
      <anchor>a1b0ef82ab81b3ded607584c7029fe1e9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GInputStream *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1InputStream.html</anchorfile>
      <anchor>a28a9394b07e9183c0c79798ea344c65c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>read</name>
      <anchorfile>classGio_1_1InputStream.html</anchorfile>
      <anchor>a49a1f4219f96c7fafdcf1ed12eb443e2</anchor>
      <arglist>(void *buffer, gsize count, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>read</name>
      <anchorfile>classGio_1_1InputStream.html</anchorfile>
      <anchor>a42ab2486116d40f6ef828277befb508a</anchor>
      <arglist>(void *buffer, gsize count)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>read_all</name>
      <anchorfile>classGio_1_1InputStream.html</anchorfile>
      <anchor>a1dc8a2babf32f93a0a5dccc0c39e0959</anchor>
      <arglist>(void *buffer, gsize count, gsize &amp;bytes_read, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>read_all</name>
      <anchorfile>classGio_1_1InputStream.html</anchorfile>
      <anchor>a6da0fc57d1a5df7107370c67e84aa496</anchor>
      <arglist>(void *buffer, gsize count, gsize &amp;bytes_read)</arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>skip</name>
      <anchorfile>classGio_1_1InputStream.html</anchorfile>
      <anchor>a17ea65f35c15043156db90af831a44a3</anchor>
      <arglist>(gsize count, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>skip</name>
      <anchorfile>classGio_1_1InputStream.html</anchorfile>
      <anchor>a1ea9146d612c666168886734b79a5d65</anchor>
      <arglist>(gsize count)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>close</name>
      <anchorfile>classGio_1_1InputStream.html</anchorfile>
      <anchor>a1b76b2503e607475f63731a886456e09</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>close</name>
      <anchorfile>classGio_1_1InputStream.html</anchorfile>
      <anchor>a7a3202cf7014bcfb2c0a7f301448ae50</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>read_async</name>
      <anchorfile>classGio_1_1InputStream.html</anchorfile>
      <anchor>a5b7762ee3f3c571fbc59a0c9af6e879e</anchor>
      <arglist>(void *buffer, gsize count, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>read_async</name>
      <anchorfile>classGio_1_1InputStream.html</anchorfile>
      <anchor>a05bea76fa9ac3c098a167d2b377e36a6</anchor>
      <arglist>(void *buffer, gsize count, const SlotAsyncReady &amp;slot, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>read_finish</name>
      <anchorfile>classGio_1_1InputStream.html</anchorfile>
      <anchor>ac089ab220e671ba0af2dd97f2405c0c5</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>skip_async</name>
      <anchorfile>classGio_1_1InputStream.html</anchorfile>
      <anchor>a1bf7a4a30005813b0a46e069215907a2</anchor>
      <arglist>(gsize count, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>skip_async</name>
      <anchorfile>classGio_1_1InputStream.html</anchorfile>
      <anchor>a111e86dad4548394edcff16d7735d2d5</anchor>
      <arglist>(gsize count, const SlotAsyncReady &amp;slot, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>skip_finish</name>
      <anchorfile>classGio_1_1InputStream.html</anchorfile>
      <anchor>a1522468bd203ab3082ab54e9eba68b03</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>close_async</name>
      <anchorfile>classGio_1_1InputStream.html</anchorfile>
      <anchor>af66159778ee2d577e9df52063ced53bf</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>close_async</name>
      <anchorfile>classGio_1_1InputStream.html</anchorfile>
      <anchor>ab5160982124f34ed6e475776acd126d2</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>gboolean</type>
      <name>close_finish</name>
      <anchorfile>classGio_1_1InputStream.html</anchorfile>
      <anchor>ae5a0d2c3ccf27661e374f151117a8fb7</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::InputStream &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1InputStream.html</anchorfile>
      <anchor>aec580b0fc1e0807d7ccba6cbb7e302db</anchor>
      <arglist>(GInputStream *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::IOStream</name>
    <filename>classGio_1_1IOStream.html</filename>
    <base>Glib::Object</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~IOStream</name>
      <anchorfile>classGio_1_1IOStream.html</anchorfile>
      <anchor>a1257d3a0df6edf25cf1088e4be7144e2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GIOStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1IOStream.html</anchorfile>
      <anchor>a6e8d13f8095555cecbe0d59f1542893f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GIOStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1IOStream.html</anchorfile>
      <anchor>a94eb81fa811399ece0ef743cd9d178ae</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GIOStream *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1IOStream.html</anchorfile>
      <anchor>a632594c5b02e0311448e79f6d495c65a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; InputStream &gt;</type>
      <name>get_input_stream</name>
      <anchorfile>classGio_1_1IOStream.html</anchorfile>
      <anchor>afab74f0f339afb505556f6cb8b8c2b45</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; OutputStream &gt;</type>
      <name>get_output_stream</name>
      <anchorfile>classGio_1_1IOStream.html</anchorfile>
      <anchor>acdea8fc29d817070fa9cca124f398930</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>close</name>
      <anchorfile>classGio_1_1IOStream.html</anchorfile>
      <anchor>ae22ea1e4e3cd6db48b5e012f35a2306d</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>close</name>
      <anchorfile>classGio_1_1IOStream.html</anchorfile>
      <anchor>a7d9c63eb525827d27f897d6823f719a8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>close_async</name>
      <anchorfile>classGio_1_1IOStream.html</anchorfile>
      <anchor>a289fe0ef58e44117952a2e01985afdd7</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>close_async</name>
      <anchorfile>classGio_1_1IOStream.html</anchorfile>
      <anchor>a41451e389068b3a61245b43695186ee6</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>close_finish</name>
      <anchorfile>classGio_1_1IOStream.html</anchorfile>
      <anchor>a205a044f155178460336bd6efd05554c</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_closed</name>
      <anchorfile>classGio_1_1IOStream.html</anchorfile>
      <anchor>a32d887d5d205566fe1cdfd0bf4176a8d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>has_pending</name>
      <anchorfile>classGio_1_1IOStream.html</anchorfile>
      <anchor>afecb3079c5a4adf9fe186b4a44923da3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>set_pending</name>
      <anchorfile>classGio_1_1IOStream.html</anchorfile>
      <anchor>a7217e0c7ef1659a8b293a81e5b2e95e2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>clear_pending</name>
      <anchorfile>classGio_1_1IOStream.html</anchorfile>
      <anchor>ac15dc0ec5596a9bb5ee174ea70a2b59d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::IOStream &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1IOStream.html</anchorfile>
      <anchor>a13101385680c3857e7027d78e1f6259a</anchor>
      <arglist>(GIOStream *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::LoadableIcon</name>
    <filename>classGio_1_1LoadableIcon.html</filename>
    <base>Gio::Icon</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~LoadableIcon</name>
      <anchorfile>classGio_1_1LoadableIcon.html</anchorfile>
      <anchor>ac1a01de0d91f26e45babaea521a982a9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GLoadableIcon *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1LoadableIcon.html</anchorfile>
      <anchor>aa590b3b76843c19f5dbf51448f30e9f7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GLoadableIcon *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1LoadableIcon.html</anchorfile>
      <anchor>a50a6f22519524e14d36d070cd2cb1c89</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; InputStream &gt;</type>
      <name>load</name>
      <anchorfile>classGio_1_1LoadableIcon.html</anchorfile>
      <anchor>af92f75fd1b6d4284e169c199a2c6b8c3</anchor>
      <arglist>(int size, Glib::ustring &amp;type, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; InputStream &gt;</type>
      <name>load</name>
      <anchorfile>classGio_1_1LoadableIcon.html</anchorfile>
      <anchor>acd3a877867f4ca2cbf5b1a5b059e2eb6</anchor>
      <arglist>(int size, Glib::ustring &amp;type)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>load_async</name>
      <anchorfile>classGio_1_1LoadableIcon.html</anchorfile>
      <anchor>a0218104cdd576b7dde4846de9b997e41</anchor>
      <arglist>(int size, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>load_async</name>
      <anchorfile>classGio_1_1LoadableIcon.html</anchorfile>
      <anchor>a3e2f5cf5ef217e53e6dfcbd83cc553e1</anchor>
      <arglist>(int size, const SlotAsyncReady &amp;slot)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>add_interface</name>
      <anchorfile>classGio_1_1LoadableIcon.html</anchorfile>
      <anchor>aac15ee4e49c92f2822760cc774f908d8</anchor>
      <arglist>(GType gtype_implementer)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::LoadableIcon &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1LoadableIcon.html</anchorfile>
      <anchor>afa55d29b9394247f8824820bb92e8e6b</anchor>
      <arglist>(GLoadableIcon *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::MemoryInputStream</name>
    <filename>classGio_1_1MemoryInputStream.html</filename>
    <base>Gio::InputStream</base>
    <base>Gio::Seekable</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~MemoryInputStream</name>
      <anchorfile>classGio_1_1MemoryInputStream.html</anchorfile>
      <anchor>a73bc118fab39a89f4d8e8434ff951ba8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GMemoryInputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1MemoryInputStream.html</anchorfile>
      <anchor>a076380153e01599446bd991e0985db69</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GMemoryInputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1MemoryInputStream.html</anchorfile>
      <anchor>af9ea44af840fc0d29d460498c8ce7d0e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GMemoryInputStream *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1MemoryInputStream.html</anchorfile>
      <anchor>af63cbdce2036e383cb7e77a7df83651c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>add_data</name>
      <anchorfile>classGio_1_1MemoryInputStream.html</anchorfile>
      <anchor>a483a0f4811f64a0a83204e22c227bf80</anchor>
      <arglist>(const std::string &amp;data)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>add_data</name>
      <anchorfile>classGio_1_1MemoryInputStream.html</anchorfile>
      <anchor>a9700ab039b7d4654330f2786bd8786eb</anchor>
      <arglist>(const void *data, gssize len)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>add_data</name>
      <anchorfile>classGio_1_1MemoryInputStream.html</anchorfile>
      <anchor>aa26832ff7a8bce5cc15518d5a2f0a14b</anchor>
      <arglist>(const void *data, gssize len, GDestroyNotify destroy)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; MemoryInputStream &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1MemoryInputStream.html</anchorfile>
      <anchor>adb6e55009e51b59fa19dcd69617cfda1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>MemoryInputStream</name>
      <anchorfile>classGio_1_1MemoryInputStream.html</anchorfile>
      <anchor>a3878e7ba1b947b72a8ab835e2ff24473</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::MemoryInputStream &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1MemoryInputStream.html</anchorfile>
      <anchor>a37bf0e5204e95253e4119ad954b3f7b9</anchor>
      <arglist>(GMemoryInputStream *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::MemoryOutputStream</name>
    <filename>classGio_1_1MemoryOutputStream.html</filename>
    <base>Gio::OutputStream</base>
    <base>Gio::Seekable</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~MemoryOutputStream</name>
      <anchorfile>classGio_1_1MemoryOutputStream.html</anchorfile>
      <anchor>ad46729116d268fe1f8f540c692a43bf4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GMemoryOutputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1MemoryOutputStream.html</anchorfile>
      <anchor>a3a52447ebfbc60722ced10d8aa625825</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GMemoryOutputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1MemoryOutputStream.html</anchorfile>
      <anchor>a026181901b030a2f1f6e3b66026de5d3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GMemoryOutputStream *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1MemoryOutputStream.html</anchorfile>
      <anchor>aa6b728d48c0817347df70d41bd57708f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>gpointer</type>
      <name>get_data</name>
      <anchorfile>classGio_1_1MemoryOutputStream.html</anchorfile>
      <anchor>a3b85fad262d105f85bff12b5a666ddfd</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>gsize</type>
      <name>get_size</name>
      <anchorfile>classGio_1_1MemoryOutputStream.html</anchorfile>
      <anchor>ae8e5b9a0551bba70974c99cbb24a91e3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>gsize</type>
      <name>get_data_size</name>
      <anchorfile>classGio_1_1MemoryOutputStream.html</anchorfile>
      <anchor>a7325ac59862190abfbbd8402ca7e7fe5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; MemoryOutputStream &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1MemoryOutputStream.html</anchorfile>
      <anchor>af906acc5229896d07482f73297a1ee6d</anchor>
      <arglist>(gpointer data, gsize len, GReallocFunc realloc_fn, GDestroyNotify destroy)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>MemoryOutputStream</name>
      <anchorfile>classGio_1_1MemoryOutputStream.html</anchorfile>
      <anchor>a813d6f10b2ef74d5b604834ff5d11e58</anchor>
      <arglist>(gpointer data, gsize len, GReallocFunc realloc_fn, GDestroyNotify destroy)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::MemoryOutputStream &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1MemoryOutputStream.html</anchorfile>
      <anchor>a294410b0d5c9b2d1a08dc9375338f187</anchor>
      <arglist>(GMemoryOutputStream *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::Mount</name>
    <filename>classGio_1_1Mount.html</filename>
    <base>Glib::Interface</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Mount</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a13e8fa0a412e509ed8a5cc10bf212ee2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GMount *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>afdab4fd2377e912d2baef0cc6a825eca</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GMount *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>ae15d61c7a8bb68f66fc46e3eaaaffbe6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; File &gt;</type>
      <name>get_root</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>accf83f7b2599411cb82f5f4c0172db81</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const File &gt;</type>
      <name>get_root</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>ac2bf8f7a467856c39cfc016d61fe8c5f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_name</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a951d543f8907069e20678dd503928cd0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Icon &gt;</type>
      <name>get_icon</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>ae368f1d91fc927b809f27acce5aff58e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const Icon &gt;</type>
      <name>get_icon</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a4c26c21db5fb5960b24d780018c6d04f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_uuid</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a8a58874fb45ac7960dec34f094f0306e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Volume &gt;</type>
      <name>get_volume</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a9497eb3a3a928144f522489b5b432cad</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const Volume &gt;</type>
      <name>get_volume</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>ac9f2177094e6203eaf6aa186b7ea3ee4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Drive &gt;</type>
      <name>get_drive</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>ab9b8889c7b8c8fdb885a46dad7419fed</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const Drive &gt;</type>
      <name>get_drive</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a9045c2d50f4433ebfa137c501b00fd96</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>can_unmount</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a52771234b6feb921931f28886bced5f7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>can_eject</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a279bb465c4781cf4a769db412db947f8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unmount</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a6eb057d27f3729dc451d32e8c6bc8fa0</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unmount</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a99bb5452908456ece101cee94d58efe9</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unmount</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>aedbcd024f16a92c704261c17eb7b1cf6</anchor>
      <arglist>(MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unmount</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a4673333db9d066f1f0fef5e4b2d5bd2b</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unmount</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a833c71dbd0d5cfa222cec64cafaaf328</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, const SlotAsyncReady &amp;slot, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unmount</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>af40b60bca3e9bc53496f0ac926a4db04</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>unmount_finish</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a319db22009f052fb5d0c45596f203d4d</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remount</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>aae983acbd58daf68125f5129466d4de1</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;operation, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, MountMountFlags flags=MOUNT_MOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remount</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a088ae08b4bc3a8dc44c0e18aa2b438e3</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;operation, const SlotAsyncReady &amp;slot, MountMountFlags flags=MOUNT_MOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remount</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a2059d92df5b2cc36268545b3dbd2c171</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;operation, MountMountFlags flags=MOUNT_MOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remount</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a4ef4769ca5b2e9a55f8a1981b2cc051e</anchor>
      <arglist>(MountMountFlags flags=MOUNT_MOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>remount_finish</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a5cb279b126e6086b5f0ae0957794f023</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>eject</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a6bbacd6b5ab2251d8df9db538d6f0d60</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>eject</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a3573df8a4d1d10dd321e2f46d9afc337</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>eject</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a0fe94aae6876d196348f786c5e830b49</anchor>
      <arglist>(MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>eject</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a8c2898b067f5651cb641c4375833f15b</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>eject</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a9a27b41f48e3a00783b0d8ac313d0014</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, const SlotAsyncReady &amp;slot, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>eject</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>ac7ff80c7b83d251de9a8c47ce79e9e5b</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>eject_finish</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>aee0c22ba1711f4d84d1eb0d2989c2d0d</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>guess_content_type</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a3ab56ac69c41c668990e91d7be2a2b73</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, bool force_rescan=true)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>guess_content_type</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a498994191262236c4bddf0b95df92642</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, bool force_rescan=true)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>guess_content_type</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>ada39b6385004f938c38ce14b0566756b</anchor>
      <arglist>(bool force_rescan=true)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>guess_content_type_sync</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a42de2d821060ef0f958ec176749ab595</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, bool force_rescan=true)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>guess_content_type_sync</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a7e6b4c96208fca788cedb49dbea89258</anchor>
      <arglist>(bool force_rescan=true)</arglist>
    </member>
    <member kind="function">
      <type>Glib::StringArrayHandle</type>
      <name>guess_content_type_finish</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a274064a160c15338580685a9e1603497</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_shadowed</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a7788da3491e20c6a5563adb7690001fb</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>shadow</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a1988ef61bd5316876ef434593a45f584</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unshadow</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>ab25d880d541247871be715e13fa2b39e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy0&lt; void &gt;</type>
      <name>signal_changed</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>ae9331b0fb0c2154885818ed72ddb21a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy0&lt; void &gt;</type>
      <name>signal_unmounted</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>adafc3d61a654cf2236f568e534aa6616</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy0&lt; void &gt;</type>
      <name>signal_pre_unmount</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>ae0c76ef0e895f2781add651624c590ed</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>add_interface</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>aad5f6e7a513330f247f71c9475a3eec8</anchor>
      <arglist>(GType gtype_implementer)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_changed</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>adf264056921a09b1426625973fb1d182</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_unmounted</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>adc6f47efdfd20501692f82a2c94b7efa</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::Mount &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a4723a81c56625aa5920589115060812c</anchor>
      <arglist>(GMount *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::MountOperation</name>
    <filename>classGio_1_1MountOperation.html</filename>
    <base>Glib::Object</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~MountOperation</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a6899f6121cf5a44a39ae3cc662d92fc6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GMountOperation *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a580640ff16e8cd1cbd9d0ce4659daa7e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GMountOperation *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a100962323f73438a4d35253b5763cc30</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GMountOperation *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a6e6feac74568a2eb7e6ca1a63122c31b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_username</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a13621e9b35aa25b8f62e5a6db14d3967</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_username</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>ae9e313d9dca3421676c590cf50134d62</anchor>
      <arglist>(const Glib::ustring &amp;username)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_password</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>ac874e50f4915199d6013932633841ac0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_password</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a9df86e31c73fea9e438586fde8a92b70</anchor>
      <arglist>(const Glib::ustring &amp;password)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_anonymous</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>aa30b6f82881ae1afea5a21836e5bd036</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_anonymous</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>ad5a97dd24b05012c93211932880edc02</anchor>
      <arglist>(bool anonymous=true)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_domain</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a3f0ed216f46c7a914c73d7d1e4a8c0c7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_domain</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a09fd2984393678b8592b7a3d565c0307</anchor>
      <arglist>(const Glib::ustring &amp;domain)</arglist>
    </member>
    <member kind="function">
      <type>PasswordSave</type>
      <name>get_password_save</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>abc1af61dac7d1427775b7505d27cd319</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_password_save</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a58bda8feb48b1e163931d96b5dfdc245</anchor>
      <arglist>(PasswordSave password_save)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>get_choice</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>ab7eaa8f1ea17c14c86c5f30cc0c5eda9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_choice</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a6fbd101a1db62e2f34b23b9fa5cca869</anchor>
      <arglist>(int choice)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>reply</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a1f444eede759bae682091b8fc5f108d3</anchor>
      <arglist>(MountOperationResult result)</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy4&lt; void, const Glib::ustring &amp;, const Glib::ustring &amp;, const Glib::ustring &amp;, AskPasswordFlags &gt;</type>
      <name>signal_ask_password</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a10cfcab05979a518d20f0c03cbf1a6cc</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy2&lt; void, const Glib::ustring &amp;, const Glib::StringArrayHandle &amp; &gt;</type>
      <name>signal_ask_question</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a38daf1bcead0ae90cc61db691616c342</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy1&lt; void, MountOperationResult &gt;</type>
      <name>signal_reply</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a55fa9cab0e2955fa6142f5dcc95198dc</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy0&lt; void &gt;</type>
      <name>signal_aborted</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a2aaec5c293ef88d3c331b67ee92f0493</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; Glib::ustring &gt;</type>
      <name>property_username</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a7a8ebc0a62b0e8e0b33bddde7db96706</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::ustring &gt;</type>
      <name>property_username</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a4508d7bc848d0a0a0c9445c5ca9abe9d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; Glib::ustring &gt;</type>
      <name>property_password</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a17670a49103488add212c9b29329e51e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::ustring &gt;</type>
      <name>property_password</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a874cf5588821b4c8b4ea5ccbb4a3ab0c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; bool &gt;</type>
      <name>property_anonymous</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>aa92ded64dceb5ea08d3eeb1cac25b3de</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_anonymous</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a22622be32255873c07bdf6ea42109d84</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; Glib::ustring &gt;</type>
      <name>property_domain</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>abddb368062abd7d6e225887ac57a026b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::ustring &gt;</type>
      <name>property_domain</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a223b2776dbcd745a319ffd03800764cd</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; PasswordSave &gt;</type>
      <name>property_password_save</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a0c44df49a85b8f281a306c38ebd0499c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; PasswordSave &gt;</type>
      <name>property_password_save</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>af6aaf7f15aa28944bfa89266fc2437ec</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; int &gt;</type>
      <name>property_choice</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a17e402048ff4be6503348eaffd54346d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; int &gt;</type>
      <name>property_choice</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a5f614f827c4496c3e7ba099eb702cc4f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; MountOperation &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a3e59fd19498a9be34bbb7462d87e2ca1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>MountOperation</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a415e62c32b8d497d859e50da0c8431cb</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_ask_password</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a2bfee2a7879e75708a22cfb59e99280b</anchor>
      <arglist>(const Glib::ustring &amp;message, const Glib::ustring &amp;default_user, const Glib::ustring &amp;default_domain, AskPasswordFlags flags)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_ask_question</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>af4d007e34e6f023de14a667aabfe3a39</anchor>
      <arglist>(const Glib::ustring &amp;message, const Glib::StringArrayHandle &amp;choices)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_reply</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a9480654f1624640c719ce260883c8f9e</anchor>
      <arglist>(MountOperationResult result)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::MountOperation &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a65da8ecee4b6b6cfd9e846ec6bc950fe</anchor>
      <arglist>(GMountOperation *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::NetworkAddress</name>
    <filename>classGio_1_1NetworkAddress.html</filename>
    <base>Glib::Object</base>
    <base>Gio::SocketConnectable</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~NetworkAddress</name>
      <anchorfile>classGio_1_1NetworkAddress.html</anchorfile>
      <anchor>a6907240bebaea930f6a4ea0cf48e9478</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GNetworkAddress *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1NetworkAddress.html</anchorfile>
      <anchor>ac3bece6c2edb44d1346abd2a07995df9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GNetworkAddress *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1NetworkAddress.html</anchorfile>
      <anchor>a34f56c110e7a2e843680d8ac8f9b7501</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GNetworkAddress *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1NetworkAddress.html</anchorfile>
      <anchor>aa38b8f4bb0392393ea1235f3adbe79e2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_hostname</name>
      <anchorfile>classGio_1_1NetworkAddress.html</anchorfile>
      <anchor>a859e032334faefe8c8c7d68f8ee2cdfe</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>guint16</type>
      <name>get_port</name>
      <anchorfile>classGio_1_1NetworkAddress.html</anchorfile>
      <anchor>a8a8893314bda54fc9b09a52f4bf9c33d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; std::string &gt;</type>
      <name>property_hostname</name>
      <anchorfile>classGio_1_1NetworkAddress.html</anchorfile>
      <anchor>aa981c8b93746cb0e71d1f0393d587fc7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; guint &gt;</type>
      <name>property_port</name>
      <anchorfile>classGio_1_1NetworkAddress.html</anchorfile>
      <anchor>a7063532bb773b162e803f40541ff7168</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; NetworkAddress &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1NetworkAddress.html</anchorfile>
      <anchor>a30cc7b78902bb94a53b7eca98fbee083</anchor>
      <arglist>(const std::string &amp;hostname, guint16 port)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; NetworkAddress &gt;</type>
      <name>parse</name>
      <anchorfile>classGio_1_1NetworkAddress.html</anchorfile>
      <anchor>a0090a07db819bd872a1379cb6d6c635a</anchor>
      <arglist>(const std::string &amp;host_and_port, guint16 default_port)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::NetworkAddress &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1NetworkAddress.html</anchorfile>
      <anchor>a8283831783706b23dea2801e56bf1b1d</anchor>
      <arglist>(GNetworkAddress *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::NetworkService</name>
    <filename>classGio_1_1NetworkService.html</filename>
    <base>Glib::Object</base>
    <base>Gio::SocketConnectable</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~NetworkService</name>
      <anchorfile>classGio_1_1NetworkService.html</anchorfile>
      <anchor>a991fb9d21ee21f41b0f6f78c57ba354b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GNetworkService *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1NetworkService.html</anchorfile>
      <anchor>a01c7acc26f88ba9b62cebecfadf0eb81</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GNetworkService *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1NetworkService.html</anchorfile>
      <anchor>a4163659ccfef2fe1459e54f542a04a83</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GNetworkService *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1NetworkService.html</anchorfile>
      <anchor>ac73f00e197b587678ea62ed430d7592c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_service</name>
      <anchorfile>classGio_1_1NetworkService.html</anchorfile>
      <anchor>ab6d8f3c7d9da2a302645eecce0707a7e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_protocol</name>
      <anchorfile>classGio_1_1NetworkService.html</anchorfile>
      <anchor>a2789410b339d1fd4770ca24243421520</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_domain</name>
      <anchorfile>classGio_1_1NetworkService.html</anchorfile>
      <anchor>a5ee1798c274fc4868fc108c6e3b0fbef</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::ustring &gt;</type>
      <name>property_protocol</name>
      <anchorfile>classGio_1_1NetworkService.html</anchorfile>
      <anchor>a70830dab9f87d2278cdbfcff65960726</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::ustring &gt;</type>
      <name>property_service</name>
      <anchorfile>classGio_1_1NetworkService.html</anchorfile>
      <anchor>a129ba5bc4179072852d5bfc39a40f129</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; NetworkService &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1NetworkService.html</anchorfile>
      <anchor>a1e6e8639ee28297dbce656fa93cafe65</anchor>
      <arglist>(const Glib::ustring &amp;service, const Glib::ustring &amp;protocol, const Glib::ustring &amp;domain)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::NetworkService &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1NetworkService.html</anchorfile>
      <anchor>ac0ea3336b85237336a8c8efeb4f864ec</anchor>
      <arglist>(GNetworkService *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::OutputStream</name>
    <filename>classGio_1_1OutputStream.html</filename>
    <base>Glib::Object</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~OutputStream</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>ae03f14924981183936d800fcde857fea</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GOutputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>ac5a71a1f432f8ac2a53de2c66eb81d9d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GOutputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>ac29e6ad7ccffde24201a1da608f25ac9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GOutputStream *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>ad9128985ea683716db40d7831cb7075c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>write</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>a0a714bc357db90c5e34f1d001446fe29</anchor>
      <arglist>(const void *buffer, gsize count, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>write</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>a5037c7a24ba87c7e8f1992f7586f032c</anchor>
      <arglist>(const void *buffer, gsize count)</arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>write</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>aee589585890960b4c26c86865fe3f0b4</anchor>
      <arglist>(const std::string &amp;buffer, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>write</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>afa3cf9f1b7006b1f79d8e452616f3324</anchor>
      <arglist>(const std::string &amp;buffer)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>write_all</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>ac9ff8d59409bfdfdfd95643f3ee4c98d</anchor>
      <arglist>(const void *buffer, gsize count, gsize &amp;bytes_written, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>write_all</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>aca15317cfd772d712b44147d378788b8</anchor>
      <arglist>(const void *buffer, gsize count, gsize &amp;bytes_written)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>write_all</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>ac10263d00bf17a158d4aad207fbb2d64</anchor>
      <arglist>(const std::string &amp;buffer, gsize &amp;bytes_written, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>write_all</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>a9171833c0c7c88103afd3fc12efbcf17</anchor>
      <arglist>(const std::string &amp;buffer, gsize &amp;bytes_written)</arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>splice</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>a080bff3f1f2017b4d4ff8343a5bfbf15</anchor>
      <arglist>(const Glib::RefPtr&lt; InputStream &gt; &amp;source, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, OutputStreamSpliceFlags flags=OUTPUT_STREAM_SPLICE_NONE)</arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>splice</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>aaca5a5891175c7c66cb77e476bae1843</anchor>
      <arglist>(const Glib::RefPtr&lt; InputStream &gt; &amp;source, OutputStreamSpliceFlags flags=OUTPUT_STREAM_SPLICE_NONE)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>flush</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>a413a349600ecd6013d15f563d6c6fd85</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>flush</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>a6bb81a11ef79dc8ffa9f5a275d2d6e0c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>close</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>a4fefad6d6b244924b4fe51c105d3805c</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>close</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>ac3e92678425dd530b22eaab97852ca23</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>write_async</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>a947eefdb85b9081348a1c0cc04be2eaa</anchor>
      <arglist>(const void *buffer, gsize count, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>write_async</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>aae0f58d27908beb35f24a88b6254107a</anchor>
      <arglist>(const void *buffer, gsize count, const SlotAsyncReady &amp;slot, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>write_finish</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>ac61dbaa1f910c14bf3beaadc0498065f</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>splice_async</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>a4bfe08685268b2236362bce84ba1cc77</anchor>
      <arglist>(const Glib::RefPtr&lt; InputStream &gt; &amp;source, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, OutputStreamSpliceFlags flags=OUTPUT_STREAM_SPLICE_NONE, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>splice_async</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>a85e95838d577180e11831b0f149e8f5c</anchor>
      <arglist>(const Glib::RefPtr&lt; InputStream &gt; &amp;source, const SlotAsyncReady &amp;slot, OutputStreamSpliceFlags flags=OUTPUT_STREAM_SPLICE_NONE, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>splice_finish</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>a29461238b7b3cf9c2d6dde85b4a6a6ea</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>flush_async</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>ac76478281be9559cb0a924bcc4ead263</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>flush_async</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>aa82f241b6c72fef632eaf51b279b25ce</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>flush_finish</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>af2e8a3c48152c2fdc744a50016911a3a</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>close_async</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>a47fb0dbd7f88c9167dacd577dcd8c6c7</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>close_async</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>a92f6a9cc67bfa6a2356a031fb3f691c0</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>close_finish</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>a8db5ee9e7a3a0c091eeebe960550e6f5</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::OutputStream &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>a96aad4c49fb938a88b75abe5339bef4f</anchor>
      <arglist>(GOutputStream *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::Resolver</name>
    <filename>classGio_1_1Resolver.html</filename>
    <base>Glib::Object</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Resolver</name>
      <anchorfile>classGio_1_1Resolver.html</anchorfile>
      <anchor>a91fb01b808b2e2d315d9ffc149f1f71e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GResolver *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Resolver.html</anchorfile>
      <anchor>a4d323772493d0cf739816c80f08398d2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GResolver *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Resolver.html</anchorfile>
      <anchor>a77d572cc0c4a48c47ec06e9a5f2d02a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GResolver *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1Resolver.html</anchorfile>
      <anchor>ae1cf170f1700985b286238d5f1dcbab2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::ListHandle&lt; Glib::RefPtr&lt; InetAddress &gt; &gt;</type>
      <name>lookup_by_name</name>
      <anchorfile>classGio_1_1Resolver.html</anchorfile>
      <anchor>aea1576fa2684d9bca58a589098a8371e</anchor>
      <arglist>(const Glib::ustring &amp;hostname, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ListHandle&lt; Glib::RefPtr&lt; InetAddress &gt; &gt;</type>
      <name>lookup_by_name</name>
      <anchorfile>classGio_1_1Resolver.html</anchorfile>
      <anchor>a4aaf18d0bcc67d6d139d993b140a8b14</anchor>
      <arglist>(const Glib::ustring &amp;hostname)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>lookup_by_name_async</name>
      <anchorfile>classGio_1_1Resolver.html</anchorfile>
      <anchor>a0130482bb442e3a006e06d57665c2318</anchor>
      <arglist>(const Glib::ustring &amp;hostname, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>lookup_by_name_async</name>
      <anchorfile>classGio_1_1Resolver.html</anchorfile>
      <anchor>ae38a0fc714443839c0bb3a0e40dcd082</anchor>
      <arglist>(const Glib::ustring &amp;hostname, const SlotAsyncReady &amp;slot)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ListHandle&lt; Glib::RefPtr&lt; InetAddress &gt; &gt;</type>
      <name>lookup_by_name_finish</name>
      <anchorfile>classGio_1_1Resolver.html</anchorfile>
      <anchor>afaf6f9f003fd213ebecb893d60f14380</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>lookup_by_address</name>
      <anchorfile>classGio_1_1Resolver.html</anchorfile>
      <anchor>abb5740225148191d2e93d7a6b12caf23</anchor>
      <arglist>(const Glib::RefPtr&lt; InetAddress &gt; &amp;address, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>lookup_by_address</name>
      <anchorfile>classGio_1_1Resolver.html</anchorfile>
      <anchor>a81f793a31c8ddaa2bf26361721c3fd1c</anchor>
      <arglist>(const Glib::RefPtr&lt; InetAddress &gt; &amp;address)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>lookup_by_address_async</name>
      <anchorfile>classGio_1_1Resolver.html</anchorfile>
      <anchor>a3bfd36d312e60b748df35089d5126b4f</anchor>
      <arglist>(const Glib::RefPtr&lt; InetAddress &gt; &amp;address, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>lookup_by_address_async</name>
      <anchorfile>classGio_1_1Resolver.html</anchorfile>
      <anchor>a91d05a43f8083af54826fcb3303e0eba</anchor>
      <arglist>(const Glib::RefPtr&lt; InetAddress &gt; &amp;address, const SlotAsyncReady &amp;slot)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>lookup_by_address_finish</name>
      <anchorfile>classGio_1_1Resolver.html</anchorfile>
      <anchor>ae127e4682bfb20ef0b292e7b98460762</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>ListHandle_SrvTarget</type>
      <name>lookup_service</name>
      <anchorfile>classGio_1_1Resolver.html</anchorfile>
      <anchor>aab5e246c4f14e55e079c8a280dd3de5b</anchor>
      <arglist>(const Glib::ustring &amp;service, const Glib::ustring &amp;protocol, const Glib::ustring &amp;domain, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>ListHandle_SrvTarget</type>
      <name>lookup_service</name>
      <anchorfile>classGio_1_1Resolver.html</anchorfile>
      <anchor>a3b131a66a7a7bd3e89713384ff2f6be3</anchor>
      <arglist>(const Glib::ustring &amp;service, const Glib::ustring &amp;protocol, const Glib::ustring &amp;domain)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>lookup_service_async</name>
      <anchorfile>classGio_1_1Resolver.html</anchorfile>
      <anchor>a49d103c02f6e0e8ad5d4e7abb1967ef0</anchor>
      <arglist>(const Glib::ustring &amp;service, const Glib::ustring &amp;protocol, const Glib::ustring &amp;domain, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>lookup_service_async</name>
      <anchorfile>classGio_1_1Resolver.html</anchorfile>
      <anchor>a58d46752ddd5305d811df4707c3ce4a7</anchor>
      <arglist>(const Glib::ustring &amp;service, const Glib::ustring &amp;protocol, const Glib::ustring &amp;domain, const SlotAsyncReady &amp;slot)</arglist>
    </member>
    <member kind="function">
      <type>ListHandle_SrvTarget</type>
      <name>lookup_service_finish</name>
      <anchorfile>classGio_1_1Resolver.html</anchorfile>
      <anchor>aae68cb39415c9286474d92c7aeba2e47</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Resolver &gt;</type>
      <name>get_default</name>
      <anchorfile>classGio_1_1Resolver.html</anchorfile>
      <anchor>ac822ffe60ab0ce2acfdc85ccb908f6fc</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>set_default</name>
      <anchorfile>classGio_1_1Resolver.html</anchorfile>
      <anchor>afbb1fb4f9edb0e553dbb61ca2437601c</anchor>
      <arglist>(const Glib::RefPtr&lt; Resolver &gt; &amp;resolver)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::Resolver &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1Resolver.html</anchorfile>
      <anchor>aa710fc39dacfe0e34730487741d84fb9</anchor>
      <arglist>(GResolver *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::Seekable</name>
    <filename>classGio_1_1Seekable.html</filename>
    <base>Glib::Interface</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Seekable</name>
      <anchorfile>classGio_1_1Seekable.html</anchorfile>
      <anchor>a9b3fcb7df7b3e63b737e5bc5c7e74271</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GSeekable *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Seekable.html</anchorfile>
      <anchor>a96176a5c51102b9a2d02f4555f2e048f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GSeekable *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Seekable.html</anchorfile>
      <anchor>ac60caf803ddd50d08115da50ccb149dd</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>goffset</type>
      <name>tell</name>
      <anchorfile>classGio_1_1Seekable.html</anchorfile>
      <anchor>a3f270a74f487712bb0a89d86a8313987</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>can_seek</name>
      <anchorfile>classGio_1_1Seekable.html</anchorfile>
      <anchor>a5dd0a134172ea72595a9c7b2072e0350</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>seek</name>
      <anchorfile>classGio_1_1Seekable.html</anchorfile>
      <anchor>aa717d10e2322df67b488657add79c70b</anchor>
      <arglist>(goffset offset, Glib::SeekType type, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>seek</name>
      <anchorfile>classGio_1_1Seekable.html</anchorfile>
      <anchor>a3404742af5d7855f6017578091f432cc</anchor>
      <arglist>(goffset offset, Glib::SeekType type)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>can_truncate</name>
      <anchorfile>classGio_1_1Seekable.html</anchorfile>
      <anchor>a961a029a8498e9223ed9c136cfe14597</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>truncate</name>
      <anchorfile>classGio_1_1Seekable.html</anchorfile>
      <anchor>aaf0792e6281670ea411cd7c3ef981998</anchor>
      <arglist>(goffset offset, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>truncate</name>
      <anchorfile>classGio_1_1Seekable.html</anchorfile>
      <anchor>a4458c08f1486ce89f8a7f9b49f10eb13</anchor>
      <arglist>(goffset offset)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>add_interface</name>
      <anchorfile>classGio_1_1Seekable.html</anchorfile>
      <anchor>ae8a94d31313527ff431cf49ba5af2bd8</anchor>
      <arglist>(GType gtype_implementer)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::Seekable &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1Seekable.html</anchorfile>
      <anchor>a0756ddeb91dc62f76d8a380716ecd228</anchor>
      <arglist>(GSeekable *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::Socket</name>
    <filename>classGio_1_1Socket.html</filename>
    <base>Glib::Object</base>
    <base>Gio::Initable</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Socket</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a8efac59d8562ceb635b76fe70087572d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GSocket *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a1d51f7bcd83450331d7261898e9007d6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GSocket *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a51c7fa832ce1c984a7bbceb4d7ba93a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GSocket *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>ae2fe06b1a579c40b596933da0ded4e37</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>bind</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a16044bba5924c183cff90f0a4cf47394</anchor>
      <arglist>(const Glib::RefPtr&lt; SocketAddress &gt; &amp;address, bool allow_reuse)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>listen</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>af16eed3fd42f3769b5e608f96db214fd</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Socket &gt;</type>
      <name>accept</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a137ae34a8f211eaed11f9a58ca6b3f5e</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Socket &gt;</type>
      <name>accept</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a4b6c036db4e484e6b7f0419962254888</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>connect</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a9ab220f5714a6116d35e846b00f4ad23</anchor>
      <arglist>(const Glib::RefPtr&lt; SocketAddress &gt; &amp;address, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>connect</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a0828763fe472d46aed833fad30af1c0b</anchor>
      <arglist>(const Glib::RefPtr&lt; SocketAddress &gt; &amp;address)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>check_connect_result</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a06b68dc0948e6dfa158487c314f9a521</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>receive</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a742403f4d076ba9050a435d95fea5d1c</anchor>
      <arglist>(char *buffer, gsize size, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>receive</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a73463b7677ffdfddaced49bdf170b4b6</anchor>
      <arglist>(char *buffer, gsize size)</arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>send</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>adc5c3145109841e0406150ad0b7f547c</anchor>
      <arglist>(const gchar *buffer, gsize size, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>send</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a986efa2a33528ce5aba0d7c6a7be1b65</anchor>
      <arglist>(const gchar *buffer, gsize size)</arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>send_to</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a8b2d4ff883535e696b6cdaacd730f729</anchor>
      <arglist>(const Glib::RefPtr&lt; SocketAddress &gt; &amp;address, const char *buffer, gsize size, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>send_to</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a929c8c4e0c10a39d65358853e94d9c4f</anchor>
      <arglist>(const Glib::RefPtr&lt; SocketAddress &gt; &amp;address, const char *buffer, gsize size)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>close</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>aab30d39b9e73fef6401c76d1d4edc118</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_closed</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a7ac925f7e6592ad4a96afe0f75411a96</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>shutdown</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a4f685bc040e9e10abe093deec0719fd7</anchor>
      <arglist>(bool shutdown_read, bool shutdown_write)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_connected</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>aea9561511b77e652271705fbfdb2f8f2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::IOCondition</type>
      <name>condition_check</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a86fdc5d814fd61abab15ec03c7da20ec</anchor>
      <arglist>(Glib::IOCondition condition)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>condition_wait</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>aaae28fa63035c05396064f5f4bb4fc36</anchor>
      <arglist>(Glib::IOCondition condition, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>condition_wait</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a9ae420715a2050cc09112f178bae88ba</anchor>
      <arglist>(Glib::IOCondition condition)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_listen_backlog</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>adc7b9d6cecc1c2234f9979b2ffb1b309</anchor>
      <arglist>(int backlog)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>get_listen_backlog</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a22a9e70db9abc7fc6383641afde8ee6f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_blocking</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a51d5a174441c255b69be9e809cdb96b3</anchor>
      <arglist>(bool blocking)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_blocking</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a1ffcbc226b08ae14856ea0dfe4d580e9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_keepalive</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a6cfac67927584ae7afe53006eebb06d7</anchor>
      <arglist>(bool keepalive)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_keepalive</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a530b4adc3d295f7c000981286dee8019</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>SocketFamily</type>
      <name>get_family</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>aac1e2a576e62d1e339eefae1fe12e24b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>get_fd</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>af3bb5076efcb022e31db9622a1c6e0ae</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; SocketAddress &gt;</type>
      <name>get_local_address</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a654e36f8577b61a4df93a0a70479a7f1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; SocketAddress &gt;</type>
      <name>get_remote_address</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>adce45788b8ac674bdf32a3ec8fb683c1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>SocketProtocol</type>
      <name>get_protocol</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a4ecd966ee71eb956258b289cf63eb43e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>SocketType</type>
      <name>get_socket_type</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a05cd563d5bc68362f3a574054ce63481</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>speaks_ipv4</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>ae33e646694bf6c5062683ba4b79d4fe1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; bool &gt;</type>
      <name>property_blocking</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>ae6c0fdc10c1dd971bd75241dc8e3edaf</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_blocking</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a004c9014634a2d15bf72bde26d0946d9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; SocketFamily &gt;</type>
      <name>property_family</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a9644d9441f3c4217c5f4f59b8821d966</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; int &gt;</type>
      <name>property_fd</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>aad681d273768f49f75fbee70abaa97f2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; bool &gt;</type>
      <name>property_keepalive</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a2dc3436d7a9a94b4355fef411659845e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_keepalive</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a86d147686d1bc91bc1350ed522ce04eb</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; int &gt;</type>
      <name>property_listen_backlog</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a013fbb1ab58b01f7f7457a1069ab5f4f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; int &gt;</type>
      <name>property_listen_backlog</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a24c7c56d57439271b9817ae13447550e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::RefPtr&lt; SocketAddress &gt; &gt;</type>
      <name>property_local_address</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>ac52bc9e13993758922ce0d3683f336af</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::RefPtr&lt; SocketAddress &gt; &gt;</type>
      <name>property_remote_address</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a0affc1f63146a265a1d1c2b884091708</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; SocketProtocol &gt;</type>
      <name>property_protocol</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a5b8ba56215c4f828d0db182c72ee5c1f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; SocketType &gt;</type>
      <name>property_type</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a43cc07ec00548b77642200014a160400</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::Socket &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a4b4f2145105f84580f0a2659a9e8e5db</anchor>
      <arglist>(GSocket *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::SocketAddress</name>
    <filename>classGio_1_1SocketAddress.html</filename>
    <base>Glib::Object</base>
    <base>Gio::SocketConnectable</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~SocketAddress</name>
      <anchorfile>classGio_1_1SocketAddress.html</anchorfile>
      <anchor>aeedceaf982ff7e7dc75d419022bafde1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GSocketAddress *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1SocketAddress.html</anchorfile>
      <anchor>a1f65b6f40eeb9a30eb613345be919eb6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GSocketAddress *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1SocketAddress.html</anchorfile>
      <anchor>aa2c5c7f04c127ad5037814f847ab2d6f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GSocketAddress *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1SocketAddress.html</anchorfile>
      <anchor>afe1a5b0091f024fa725ff31b88d01e7b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>SocketFamily</type>
      <name>get_family</name>
      <anchorfile>classGio_1_1SocketAddress.html</anchorfile>
      <anchor>ab4fb1e63e629e88e5263e8bf5d095809</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>to_native</name>
      <anchorfile>classGio_1_1SocketAddress.html</anchorfile>
      <anchor>adec995b9e46746a5d55b3c5af592ec44</anchor>
      <arglist>(gpointer dest, gsize destlen)</arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>get_native_size</name>
      <anchorfile>classGio_1_1SocketAddress.html</anchorfile>
      <anchor>a25fd6c43478da2eef785467f75ba02ec</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; SocketAddress &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1SocketAddress.html</anchorfile>
      <anchor>a3d2233d8fc6b47668d38d4b450b5bae2</anchor>
      <arglist>(gpointer native, gsize len)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::SocketAddress &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1SocketAddress.html</anchorfile>
      <anchor>adf0c2a59f4fc452b8b8e81f86ed1dc43</anchor>
      <arglist>(GSocketAddress *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::SocketAddressEnumerator</name>
    <filename>classGio_1_1SocketAddressEnumerator.html</filename>
    <base>Glib::Object</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~SocketAddressEnumerator</name>
      <anchorfile>classGio_1_1SocketAddressEnumerator.html</anchorfile>
      <anchor>a4d707b12b6751fb9b2331d66f84578cd</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GSocketAddressEnumerator *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1SocketAddressEnumerator.html</anchorfile>
      <anchor>a4e72db226aa1d74293b99dc1af495d29</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GSocketAddressEnumerator *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1SocketAddressEnumerator.html</anchorfile>
      <anchor>aba67cc02b09d4cea3a9a1df65dc9b726</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GSocketAddressEnumerator *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1SocketAddressEnumerator.html</anchorfile>
      <anchor>a38a1287d76bd77803c85439077dd019f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; SocketAddress &gt;</type>
      <name>next</name>
      <anchorfile>classGio_1_1SocketAddressEnumerator.html</anchorfile>
      <anchor>a2aac35c9406f82a2c627e70d815ad4f9</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; SocketAddress &gt;</type>
      <name>next</name>
      <anchorfile>classGio_1_1SocketAddressEnumerator.html</anchorfile>
      <anchor>a2a0ab29942c1516f22127aea2a184d09</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>next_async</name>
      <anchorfile>classGio_1_1SocketAddressEnumerator.html</anchorfile>
      <anchor>aa8c329070a4465ccfce945bb2cb24bd1</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const SlotAsyncReady &amp;slot)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>next_async</name>
      <anchorfile>classGio_1_1SocketAddressEnumerator.html</anchorfile>
      <anchor>a5fccf3d959f7ea6cfab87ef3c751513f</anchor>
      <arglist>(const SlotAsyncReady &amp;slot)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; SocketAddress &gt;</type>
      <name>next_finish</name>
      <anchorfile>classGio_1_1SocketAddressEnumerator.html</anchorfile>
      <anchor>ac125504ce63d7d6f562a197f85b4e174</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::SocketAddressEnumerator &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1SocketAddressEnumerator.html</anchorfile>
      <anchor>a333f94acb7c1811f6c649de72427f9d0</anchor>
      <arglist>(GSocketAddressEnumerator *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::SocketConnectable</name>
    <filename>classGio_1_1SocketConnectable.html</filename>
    <base>Glib::Interface</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~SocketConnectable</name>
      <anchorfile>classGio_1_1SocketConnectable.html</anchorfile>
      <anchor>a4cb889aad12cbcf04f6c64002f040226</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GSocketConnectable *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1SocketConnectable.html</anchorfile>
      <anchor>a25988d9aeb115345500d09b282cf7023</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GSocketConnectable *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1SocketConnectable.html</anchorfile>
      <anchor>a5ba8bd26578fa49ce4a6f8fbb544858c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; SocketAddressEnumerator &gt;</type>
      <name>enumerate</name>
      <anchorfile>classGio_1_1SocketConnectable.html</anchorfile>
      <anchor>a52dcce3726042d15225accd1413689aa</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>add_interface</name>
      <anchorfile>classGio_1_1SocketConnectable.html</anchorfile>
      <anchor>ac5522339bc623835f4a7245205d2ce5c</anchor>
      <arglist>(GType gtype_implementer)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::SocketConnectable &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1SocketConnectable.html</anchorfile>
      <anchor>ad7c218506ae7370a57399d87d1ec1459</anchor>
      <arglist>(GSocketConnectable *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::SrvTarget</name>
    <filename>classGio_1_1SrvTarget.html</filename>
    <member kind="function">
      <type></type>
      <name>SrvTarget</name>
      <anchorfile>classGio_1_1SrvTarget.html</anchorfile>
      <anchor>a8aedab3176f67cfd04621cf50225cbaa</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SrvTarget</name>
      <anchorfile>classGio_1_1SrvTarget.html</anchorfile>
      <anchor>a2897e03425b8a29f8199b82bc30c683d</anchor>
      <arglist>(GSrvTarget *gobject, bool make_a_copy=true)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SrvTarget</name>
      <anchorfile>classGio_1_1SrvTarget.html</anchorfile>
      <anchor>a39893a5f54f11a7b7aaa1d534ddab141</anchor>
      <arglist>(const SrvTarget &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>SrvTarget &amp;</type>
      <name>operator=</name>
      <anchorfile>classGio_1_1SrvTarget.html</anchorfile>
      <anchor>a64c9981401d91fcfdd64e4f3f90de7d4</anchor>
      <arglist>(const SrvTarget &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SrvTarget</name>
      <anchorfile>classGio_1_1SrvTarget.html</anchorfile>
      <anchor>afa511e356ee4caa752b9489ca3374542</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>swap</name>
      <anchorfile>classGio_1_1SrvTarget.html</anchorfile>
      <anchor>a2c0d698efc035391fb75d506d6dab1fe</anchor>
      <arglist>(SrvTarget &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>GSrvTarget *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1SrvTarget.html</anchorfile>
      <anchor>a6c3577ff466e24fde7da91dbb8267942</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GSrvTarget *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1SrvTarget.html</anchorfile>
      <anchor>aa1f565df7de8461f815e28175a2746ad</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GSrvTarget *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1SrvTarget.html</anchorfile>
      <anchor>a6b59da54bc6f97e17b1aa34e4b110608</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SrvTarget</name>
      <anchorfile>classGio_1_1SrvTarget.html</anchorfile>
      <anchor>a4c7ea721d35439712d77e031ef46c15e</anchor>
      <arglist>(const Glib::ustring &amp;hostname, guint16 port, guint16 priority, guint16 weight)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_hostname</name>
      <anchorfile>classGio_1_1SrvTarget.html</anchorfile>
      <anchor>a9fde92e3f76aff55f7b93066a0c20e18</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>guint16</type>
      <name>get_port</name>
      <anchorfile>classGio_1_1SrvTarget.html</anchorfile>
      <anchor>a128f762bd022cac6727ad488137d5830</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>guint16</type>
      <name>get_priority</name>
      <anchorfile>classGio_1_1SrvTarget.html</anchorfile>
      <anchor>a84eafd7887631f0d910a1d764de166f0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>guint16</type>
      <name>get_weight</name>
      <anchorfile>classGio_1_1SrvTarget.html</anchorfile>
      <anchor>ad86b3be1b52aeb216e915e2620854b16</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>GSrvTarget *</type>
      <name>gobject_</name>
      <anchorfile>classGio_1_1SrvTarget.html</anchorfile>
      <anchor>aca9c337827344ebc87400d400e1bd267</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>Gio::SrvTarget</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1SrvTarget.html</anchorfile>
      <anchor>ab09dd935751f2e15732c5f90d9c49cf8</anchor>
      <arglist>(GSrvTarget *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::ThemedIcon</name>
    <filename>classGio_1_1ThemedIcon.html</filename>
    <base>Glib::Object</base>
    <base>Gio::Icon</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~ThemedIcon</name>
      <anchorfile>classGio_1_1ThemedIcon.html</anchorfile>
      <anchor>ac5c41faafeffac479079e871edc4a66f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GThemedIcon *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1ThemedIcon.html</anchorfile>
      <anchor>aa179d9788f6a17df73a258c6f89049fd</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GThemedIcon *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1ThemedIcon.html</anchorfile>
      <anchor>ac962dc5a62c1d2b19611a497d92671ba</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GThemedIcon *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1ThemedIcon.html</anchorfile>
      <anchor>a077eea103e0f5713697f55cb66243997</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>prepend_name</name>
      <anchorfile>classGio_1_1ThemedIcon.html</anchorfile>
      <anchor>aa61fe78bdd8512c138a3ec23c6fa32f6</anchor>
      <arglist>(const std::string &amp;iconname)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append_name</name>
      <anchorfile>classGio_1_1ThemedIcon.html</anchorfile>
      <anchor>a15fb8158d3eede3d3aa4050fbdcbe124</anchor>
      <arglist>(const std::string &amp;iconname)</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_use_default_fallbacks</name>
      <anchorfile>classGio_1_1ThemedIcon.html</anchorfile>
      <anchor>add0cea54573bfff7a41d0f8d60445ced</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; ThemedIcon &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1ThemedIcon.html</anchorfile>
      <anchor>a843b98f320f1aa6316d55f266fbf8219</anchor>
      <arglist>(const std::string &amp;iconname, bool use_default_callbacks=false)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>ThemedIcon</name>
      <anchorfile>classGio_1_1ThemedIcon.html</anchorfile>
      <anchor>ac378bb89f60335fe0c24e10ce96cba12</anchor>
      <arglist>(const std::string &amp;iconname, bool use_default_callbacks=false)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::ThemedIcon &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1ThemedIcon.html</anchorfile>
      <anchor>a6e1861d53d63b929cd84e012e704c396</anchor>
      <arglist>(GThemedIcon *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::Volume</name>
    <filename>classGio_1_1Volume.html</filename>
    <base>Glib::Interface</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Volume</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>a3d35e595beb2a74009a06c42a5d26ccd</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GVolume *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>af75306117005b88b2c3f678d7a4e81fb</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GVolume *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>a93fc1178f76cfc3bd14210f6e042a526</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_name</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>ac66808206b78f8d721a08c8d3377b02a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_uuid</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>a099a949c09c9218e35d04a1fc6b1b526</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Icon &gt;</type>
      <name>get_icon</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>a1c127e8f75fc65bb5abedc810bae6448</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const Icon &gt;</type>
      <name>get_icon</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>a2a19117219838e05748eff7a432893b2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Drive &gt;</type>
      <name>get_drive</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>a666ee0dc70e5f4aefa194d64c489dc5d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const Drive &gt;</type>
      <name>get_drive</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>ac0e436e5d0503de051501b668d674a26</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Mount &gt;</type>
      <name>get_mount</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>a24b406858eff715570864fc787520a42</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const Mount &gt;</type>
      <name>get_mount</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>a5cbca187b9f04da9ad42d523a3766287</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>can_mount</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>adc2040fdc6985444b6f17ee5e1d65573</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>can_eject</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>ae09d0182b4deb272957016fc8b08ec46</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>should_automount</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>a1d2a3feca8a056d064be4db77809bc26</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>mount</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>a17599f8132a9c8a4ef9bfc0f5645033a</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, MountMountFlags flags=MOUNT_MOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>mount</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>ab506f07856b214bbf09d52f76ba94501</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, const SlotAsyncReady &amp;slot, MountMountFlags flags=MOUNT_MOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>mount</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>a4620147fca3f9de5bcba571415f47349</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, MountMountFlags flags=MOUNT_MOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>mount</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>aa34ce25eeb35a5c86dcedd1db5104579</anchor>
      <arglist>(MountMountFlags flags=MOUNT_MOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>mount_finish</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>a76b89705e10164880792f17d6670f655</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>eject</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>ac238638763e26aa3e838d9abc1dd63f7</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>eject</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>a7d9d20ce35aceb00c89d093e2e944c79</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>eject</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>a0eb78deac53941d4fe83e5b889cdf848</anchor>
      <arglist>(MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>eject</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>a9844d9de96e64d547b9f91c745abb8c6</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>eject</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>a7d520a329a66ee666955c0a85b5085ce</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, const SlotAsyncReady &amp;slot, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>eject</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>a75cf0202b35942ab2c36dc9086704064</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>eject_finish</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>a0f7234208d822c48a732ac0a84362473</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_identifier</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>a8f1582d0af0f02639db5a9a271c6fa11</anchor>
      <arglist>(const std::string &amp;kind) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::StringArrayHandle</type>
      <name>enumerate_identifiers</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>a67368fcdf28762a5a7eefbb4fbc82b40</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; File &gt;</type>
      <name>get_activation_root</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>adbf1a1ad7b49e483a0990a6d30765010</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const File &gt;</type>
      <name>get_activation_root</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>a2500d8babf1e205170f8f8a73f3ec884</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy0&lt; void &gt;</type>
      <name>signal_changed</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>a87fc3d3e43291cbaaadf0900e44cc3ab</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy0&lt; void &gt;</type>
      <name>signal_removed</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>adda17e98cd46e9a08a78064e4392fd9c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>add_interface</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>a284c9080be40b24012691302ec96568e</anchor>
      <arglist>(GType gtype_implementer)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_changed</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>a7a28465c703fbc59e85e62eb0ee53cc5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_removed</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>ace7a6a8760d17f19f0620c4aeb255455</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::Volume &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>ad88965901e2804959a1df827a721a547</anchor>
      <arglist>(GVolume *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::VolumeMonitor</name>
    <filename>classGio_1_1VolumeMonitor.html</filename>
    <base>Glib::Object</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~VolumeMonitor</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>ac726e6da4be5f55347f3ee81902dd5b4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GVolumeMonitor *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>a26f35f4479293662897520eb7b06542e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GVolumeMonitor *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>af0f6fda541a5b69b87971e2728f18ca5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GVolumeMonitor *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>a26c03982f6bebaaa15e5682e051e58c3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::ListHandle&lt; Glib::RefPtr&lt; Drive &gt; &gt;</type>
      <name>get_connected_drives</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>ac4a5e2749a0439bd75779b2a6b6783da</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::ListHandle&lt; Glib::RefPtr&lt; Volume &gt; &gt;</type>
      <name>get_volumes</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>a3781089d1267a1663bc9120ab21db25a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::ListHandle&lt; Glib::RefPtr&lt; Mount &gt; &gt;</type>
      <name>get_mounts</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>a93723d6d66d3349f0a958390cf9d02af</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Volume &gt;</type>
      <name>get_volume_for_uuid</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>a8ac52203cace8e352f1adce1fe7f385a</anchor>
      <arglist>(const std::string &amp;uuid)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Mount &gt;</type>
      <name>get_mount_for_uuid</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>a379fa574824d12a68309d015e367171d</anchor>
      <arglist>(const std::string &amp;uuid)</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy1&lt; void, const Glib::RefPtr&lt; Volume &gt; &amp; &gt;</type>
      <name>signal_volume_added</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>a8d55505f95820af5b7b12dacd3d3969a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy1&lt; void, const Glib::RefPtr&lt; Volume &gt; &amp; &gt;</type>
      <name>signal_volume_removed</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>ab185c68fcb6d60d7c1aa8bb8297a8401</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy1&lt; void, const Glib::RefPtr&lt; Volume &gt; &amp; &gt;</type>
      <name>signal_volume_changed</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>a79c7a849f12b7849c68d827fc43c47ac</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy1&lt; void, const Glib::RefPtr&lt; Mount &gt; &amp; &gt;</type>
      <name>signal_mount_added</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>aa2547e4e1ef9a3e172f1ddc3118e6b23</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy1&lt; void, const Glib::RefPtr&lt; Mount &gt; &amp; &gt;</type>
      <name>signal_mount_removed</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>a8b2bab7ce793a0d90dbb4ff681b6f559</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy1&lt; void, const Glib::RefPtr&lt; Mount &gt; &amp; &gt;</type>
      <name>signal_mount_pre_unmount</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>ab4e2b566fcee2dc841c123f30855fff9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy1&lt; void, const Glib::RefPtr&lt; Mount &gt; &amp; &gt;</type>
      <name>signal_mount_changed</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>ab7972f59213c7a01c1086fa668768617</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy1&lt; void, const Glib::RefPtr&lt; Drive &gt; &amp; &gt;</type>
      <name>signal_drive_connected</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>abe8053e0681fca3c8c8af58f8c6a99c7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy1&lt; void, const Glib::RefPtr&lt; Drive &gt; &amp; &gt;</type>
      <name>signal_drive_disconnected</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>a2894836b90cc97f18c13137f8ae9cd2e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy1&lt; void, const Glib::RefPtr&lt; Drive &gt; &amp; &gt;</type>
      <name>signal_drive_changed</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>a0f99a06c42eb70593432e305099266ba</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy1&lt; void, const Glib::RefPtr&lt; Drive &gt; &amp; &gt;</type>
      <name>signal_drive_eject_button</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>ac2fa5fa6ab82a9e29f5cce8975bce81a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy1&lt; void, const Glib::RefPtr&lt; Drive &gt; &amp; &gt;</type>
      <name>signal_drive_stop_button</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>a393811457e1b82a246459e978478d605</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; VolumeMonitor &gt;</type>
      <name>get</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>a25c516228d8ecedf40d45e82e4bbb3c8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Volume &gt;</type>
      <name>adopt_orphan_mount</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>ad02559ca69412cc5e202302de3f37a95</anchor>
      <arglist>(const Glib::RefPtr&lt; Mount &gt; &amp;mount)</arglist>
    </member>
    <member kind="variable">
      <type>gboolean(*</type>
      <name>is_supported</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>ac93d19d9f422c2f8d20a4fe17ed1e15f</anchor>
      <arglist>)(void)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_volume_added</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>acedc14897e721109142ae5d5fdf4daf0</anchor>
      <arglist>(const Glib::RefPtr&lt; Volume &gt; &amp;volume)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_volume_removed</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>ae57c09c2c8e5322ae8f241c92cae5e5c</anchor>
      <arglist>(const Glib::RefPtr&lt; Volume &gt; &amp;volume)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_volume_changed</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>a9838b33847a193882538a5ecfb5c8679</anchor>
      <arglist>(const Glib::RefPtr&lt; Volume &gt; &amp;volume)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_mount_added</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>a5323ab624d89a6488cfd08aaf6ff248e</anchor>
      <arglist>(const Glib::RefPtr&lt; Mount &gt; &amp;mount)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_mount_removed</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>ad912e1894509b15010e87f242982bcf5</anchor>
      <arglist>(const Glib::RefPtr&lt; Mount &gt; &amp;mount)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_mount_pre_unmount</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>ac51d8587804a6c09cf1a4476a21bf318</anchor>
      <arglist>(const Glib::RefPtr&lt; Mount &gt; &amp;mount)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_mount_changed</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>aa20faca7436ee75febf9112b163e4d77</anchor>
      <arglist>(const Glib::RefPtr&lt; Mount &gt; &amp;mount)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_drive_connected</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>a1c8095c8ab8bed1f8b09d97aedf2ef33</anchor>
      <arglist>(const Glib::RefPtr&lt; Drive &gt; &amp;drive)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_drive_disconnected</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>a70cb85fac2f07bdec4f896e5e3d7716d</anchor>
      <arglist>(const Glib::RefPtr&lt; Drive &gt; &amp;drive)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_drive_changed</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>a32f398cde4a82c609f5e60667f4a2afe</anchor>
      <arglist>(const Glib::RefPtr&lt; Drive &gt; &amp;drive)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::VolumeMonitor &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>a6e2656255f0de0710b8c35524b67ec89</anchor>
      <arglist>(GVolumeMonitor *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::DesktopAppInfo</name>
    <filename>classGio_1_1DesktopAppInfo.html</filename>
    <base>Glib::Object</base>
    <base>Gio::AppInfo</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~DesktopAppInfo</name>
      <anchorfile>classGio_1_1DesktopAppInfo.html</anchorfile>
      <anchor>a8dbb1f225b0f9512c0cef546b7d32012</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GDesktopAppInfo *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1DesktopAppInfo.html</anchorfile>
      <anchor>a3098e225a5b79ac496941ae2ab804c0c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GDesktopAppInfo *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1DesktopAppInfo.html</anchorfile>
      <anchor>af6f5698a7fd78187bac77556ac54622f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GDesktopAppInfo *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1DesktopAppInfo.html</anchorfile>
      <anchor>a60fe723570666ef15c3b024bdfaf6165</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_hidden</name>
      <anchorfile>classGio_1_1DesktopAppInfo.html</anchorfile>
      <anchor>a23113d028a906d5b3e2626dc558f36e6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; DesktopAppInfo &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1DesktopAppInfo.html</anchorfile>
      <anchor>ab6d9c00e00745f57d2e5b35f83060aad</anchor>
      <arglist>(const std::string &amp;desktop_id)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; DesktopAppInfo &gt;</type>
      <name>create_from_keyfile</name>
      <anchorfile>classGio_1_1DesktopAppInfo.html</anchorfile>
      <anchor>a4c474a10b54e12eac4cf71ee409c61c0</anchor>
      <arglist>(Glib::KeyFile &amp;key_file)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; DesktopAppInfo &gt;</type>
      <name>create_from_filename</name>
      <anchorfile>classGio_1_1DesktopAppInfo.html</anchorfile>
      <anchor>a42dca267f3ad09aaacd4937d20e4ed1d</anchor>
      <arglist>(const std::string &amp;filename)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>set_desktop_env</name>
      <anchorfile>classGio_1_1DesktopAppInfo.html</anchorfile>
      <anchor>ad3d07eea529c72d51aa868fe30d63392</anchor>
      <arglist>(const std::string &amp;desktop_env)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::DesktopAppInfo &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1DesktopAppInfo.html</anchorfile>
      <anchor>ac075226810f278017e3a0fbcc372e739</anchor>
      <arglist>(GDesktopAppInfo *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::UnixInputStream</name>
    <filename>classGio_1_1UnixInputStream.html</filename>
    <base>Gio::InputStream</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~UnixInputStream</name>
      <anchorfile>classGio_1_1UnixInputStream.html</anchorfile>
      <anchor>a21a51896fece91ec2034dea1a47f659b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GUnixInputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1UnixInputStream.html</anchorfile>
      <anchor>aa0b863b654d38a9e10f7d7d49b82c5ea</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GUnixInputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1UnixInputStream.html</anchorfile>
      <anchor>adc7b87c43606f90378a521df99220971</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GUnixInputStream *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1UnixInputStream.html</anchorfile>
      <anchor>a5f05de3f98b2dd8e7f0f2c5038fbc69f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_close_fd</name>
      <anchorfile>classGio_1_1UnixInputStream.html</anchorfile>
      <anchor>a86e845ad209749c3358634a58be66023</anchor>
      <arglist>(bool close_fd=true)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_close_fd</name>
      <anchorfile>classGio_1_1UnixInputStream.html</anchorfile>
      <anchor>a110e2c9201e53065f2140053ebb442c5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>get_fd</name>
      <anchorfile>classGio_1_1UnixInputStream.html</anchorfile>
      <anchor>a6bf398ce16adca31b594e0f4fad40a76</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; int &gt;</type>
      <name>property_fd</name>
      <anchorfile>classGio_1_1UnixInputStream.html</anchorfile>
      <anchor>a9fc70aa3eb7e8b9848bf0995351d51be</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; bool &gt;</type>
      <name>property_close_fd</name>
      <anchorfile>classGio_1_1UnixInputStream.html</anchorfile>
      <anchor>a1dd943a8606e68c30916b50f9c495d0b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_close_fd</name>
      <anchorfile>classGio_1_1UnixInputStream.html</anchorfile>
      <anchor>a136c4f6529c203b8aa613ebd9ac027af</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; UnixInputStream &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1UnixInputStream.html</anchorfile>
      <anchor>a70e7a49b38c8b8b93c47635cb3a193b8</anchor>
      <arglist>(int fd, bool close_fd_at_close)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>UnixInputStream</name>
      <anchorfile>classGio_1_1UnixInputStream.html</anchorfile>
      <anchor>a0238ab9e774980521c79ec866352a429</anchor>
      <arglist>(int fd, bool close_fd_at_close)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::UnixInputStream &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1UnixInputStream.html</anchorfile>
      <anchor>a631c2896887d90e8fa13ac8132c9f5db</anchor>
      <arglist>(GUnixInputStream *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::UnixOutputStream</name>
    <filename>classGio_1_1UnixOutputStream.html</filename>
    <base>Gio::OutputStream</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~UnixOutputStream</name>
      <anchorfile>classGio_1_1UnixOutputStream.html</anchorfile>
      <anchor>a176f5170fbd871cfc5a9ef60c9fc93e7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GUnixOutputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1UnixOutputStream.html</anchorfile>
      <anchor>ac22d258873e88661e29140587687d1d7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GUnixOutputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1UnixOutputStream.html</anchorfile>
      <anchor>ab9e89719d791ca893290ef5074fe2cf7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GUnixOutputStream *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1UnixOutputStream.html</anchorfile>
      <anchor>a9d24719266d36067e08320d597f84f0d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_close_fd</name>
      <anchorfile>classGio_1_1UnixOutputStream.html</anchorfile>
      <anchor>a537abb20777901b37115aa527c791599</anchor>
      <arglist>(bool close_fd=true)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_close_fd</name>
      <anchorfile>classGio_1_1UnixOutputStream.html</anchorfile>
      <anchor>a9cfacde4665024383bbb8d40c70c739f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>get_fd</name>
      <anchorfile>classGio_1_1UnixOutputStream.html</anchorfile>
      <anchor>a60dbaa5fc2db03c096452693b9eb6bf7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; int &gt;</type>
      <name>property_fd</name>
      <anchorfile>classGio_1_1UnixOutputStream.html</anchorfile>
      <anchor>a2c176ac39c262c3aa42ab49cc40baaff</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; bool &gt;</type>
      <name>property_close_fd</name>
      <anchorfile>classGio_1_1UnixOutputStream.html</anchorfile>
      <anchor>a9eec7de6ee2ae4829c944162ad4027cf</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_close_fd</name>
      <anchorfile>classGio_1_1UnixOutputStream.html</anchorfile>
      <anchor>aedf70cd26e305a13423a790b9c60efe1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; UnixOutputStream &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1UnixOutputStream.html</anchorfile>
      <anchor>a037edba8c8a72d0a102fed1f8a8ab9d3</anchor>
      <arglist>(int fd, bool close_fd_at_close)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>UnixOutputStream</name>
      <anchorfile>classGio_1_1UnixOutputStream.html</anchorfile>
      <anchor>ac935a3825494bcdb3033b5ab9cfd7391</anchor>
      <arglist>(int fd, bool close_fd_at_close)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::UnixOutputStream &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1UnixOutputStream.html</anchorfile>
      <anchor>ad0dc702aab1a415385bf6225fc71388f</anchor>
      <arglist>(GUnixOutputStream *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="namespace">
    <name>Glib</name>
    <filename>namespaceGlib.html</filename>
    <namespace>Glib::Ascii</namespace>
    <namespace>Glib::Container_Helpers</namespace>
    <namespace>Glib::Markup</namespace>
    <namespace>Glib::Unicode</namespace>
    <class kind="class">Glib::Checksum</class>
    <class kind="class">Glib::ConvertError</class>
    <class kind="class">Glib::IConv</class>
    <class kind="class">Glib::Date</class>
    <class kind="class">Glib::FileError</class>
    <class kind="class">Glib::DirIterator</class>
    <class kind="class">Glib::Dir</class>
    <class kind="class">Glib::IOChannelError</class>
    <class kind="class">Glib::IOChannel</class>
    <class kind="class">Glib::KeyFileError</class>
    <class kind="class">Glib::KeyFile</class>
    <class kind="class">Glib::MarkupError</class>
    <class kind="class">Glib::Module</class>
    <class kind="class">Glib::NodeTree</class>
    <class kind="class">Glib::OptionError</class>
    <class kind="class">Glib::OptionContext</class>
    <class kind="class">Glib::OptionEntry</class>
    <class kind="class">Glib::OptionGroup</class>
    <class kind="class">Glib::RegexError</class>
    <class kind="class">Glib::Regex</class>
    <class kind="class">Glib::ShellError</class>
    <class kind="class">Glib::SpawnError</class>
    <class kind="class">Glib::ThreadError</class>
    <class kind="class">Glib::Thread</class>
    <class kind="struct">Glib::StaticMutex</class>
    <class kind="class">Glib::Mutex</class>
    <class kind="struct">Glib::StaticRecMutex</class>
    <class kind="class">Glib::RecMutex</class>
    <class kind="struct">Glib::StaticRWLock</class>
    <class kind="class">Glib::RWLock</class>
    <class kind="class">Glib::Cond</class>
    <class kind="struct">Glib::StaticPrivate</class>
    <class kind="class">Glib::Private</class>
    <class kind="class">Glib::ValueArray</class>
    <class kind="class">Glib::SignalProxyBase</class>
    <class kind="class">Glib::SignalProxyNormal</class>
    <class kind="class">Glib::SignalProxy0</class>
    <class kind="class">Glib::SignalProxy1</class>
    <class kind="class">Glib::SignalProxy2</class>
    <class kind="class">Glib::SignalProxy3</class>
    <class kind="class">Glib::SignalProxy4</class>
    <class kind="class">Glib::SignalProxy5</class>
    <class kind="class">Glib::SignalProxy6</class>
    <class kind="class">Glib::Value&lt; bool &gt;</class>
    <class kind="class">Glib::Value&lt; char &gt;</class>
    <class kind="class">Glib::Value&lt; unsigned char &gt;</class>
    <class kind="class">Glib::Value&lt; int &gt;</class>
    <class kind="class">Glib::Value&lt; unsigned int &gt;</class>
    <class kind="class">Glib::Value&lt; long &gt;</class>
    <class kind="class">Glib::Value&lt; unsigned long &gt;</class>
    <class kind="class">Glib::Value&lt; long long &gt;</class>
    <class kind="class">Glib::Value&lt; unsigned long long &gt;</class>
    <class kind="class">Glib::Value&lt; float &gt;</class>
    <class kind="class">Glib::Value&lt; double &gt;</class>
    <class kind="class">Glib::Value&lt; void * &gt;</class>
    <class kind="class">Glib::ArrayHandle</class>
    <class kind="class">Glib::Sequence</class>
    <class kind="class">Glib::Dispatcher</class>
    <class kind="class">Glib::Error</class>
    <class kind="class">Glib::Exception</class>
    <class kind="class">Glib::HelperList</class>
    <class kind="class">Glib::Interface</class>
    <class kind="class">Glib::ListHandle</class>
    <class kind="class">Glib::PollFD</class>
    <class kind="class">Glib::SignalTimeout</class>
    <class kind="class">Glib::SignalIdle</class>
    <class kind="class">Glib::SignalIO</class>
    <class kind="class">Glib::SignalChildWatch</class>
    <class kind="class">Glib::MainContext</class>
    <class kind="class">Glib::MainLoop</class>
    <class kind="class">Glib::Source</class>
    <class kind="class">Glib::TimeoutSource</class>
    <class kind="class">Glib::IdleSource</class>
    <class kind="class">Glib::IOSource</class>
    <class kind="class">Glib::Object</class>
    <class kind="class">Glib::ObjectBase</class>
    <class kind="class">Glib::PatternSpec</class>
    <class kind="class">Glib::PropertyBase</class>
    <class kind="class">Glib::Property</class>
    <class kind="class">Glib::PropertyProxy</class>
    <class kind="class">Glib::PropertyProxy_WriteOnly</class>
    <class kind="class">Glib::PropertyProxy_ReadOnly</class>
    <class kind="class">Glib::SignalProxyProperty</class>
    <class kind="class">Glib::PropertyProxy_Base</class>
    <class kind="class">Glib::QueryQuark</class>
    <class kind="class">Glib::Quark</class>
    <class kind="class">Glib::Rand</class>
    <class kind="class">Glib::RefPtr</class>
    <class kind="class">Glib::SListHandle</class>
    <class kind="class">Glib::StreamIOChannel</class>
    <class kind="class">Glib::ThreadPool</class>
    <class kind="class">Glib::Timer</class>
    <class kind="struct">Glib::TimeVal</class>
    <class kind="class">Glib::ustring_Iterator</class>
    <class kind="class">Glib::ustring</class>
    <class kind="class">Glib::ValueBase</class>
    <class kind="class">Glib::ValueBase_Boxed</class>
    <class kind="class">Glib::ValueBase_Object</class>
    <class kind="class">Glib::ValueBase_Enum</class>
    <class kind="class">Glib::ValueBase_Flags</class>
    <class kind="class">Glib::ValueBase_String</class>
    <class kind="class">Glib::Value_Boxed</class>
    <class kind="class">Glib::Value&lt; std::string &gt;</class>
    <class kind="class">Glib::Value&lt; Glib::ustring &gt;</class>
    <class kind="class">Glib::Value_Enum</class>
    <class kind="class">Glib::Value_Flags</class>
    <class kind="class">Glib::Value_Pointer</class>
    <class kind="class">Glib::Value</class>
    <class kind="class">Glib::Value&lt; T * &gt;</class>
    <class kind="class">Glib::Value&lt; const T * &gt;</class>
    <member kind="typedef">
      <type>GPid</type>
      <name>Pid</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>a48d413f720e558ccfc0e5b141fc07f0e</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>ArrayHandle&lt; Glib::ustring &gt;</type>
      <name>StringArrayHandle</name>
      <anchorfile>group__ContHandles.html</anchorfile>
      <anchor>ga8e243b697be740f5f7d4b578ae50db41</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Glib::ArrayHandle&lt; Glib::ustring &gt;</type>
      <name>SArray</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>a4e357796ff84955c958209e877211f66</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>FileTest</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga33c24ccefbd130021f06708763e16ef2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_TEST_IS_REGULAR</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga33c24ccefbd130021f06708763e16ef2a3181e2e655e765b00dfdb1e1ea443f62</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_TEST_IS_SYMLINK</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga33c24ccefbd130021f06708763e16ef2a86cda9ff0bf25358070a9bc8b4a186d6</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_TEST_IS_DIR</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga33c24ccefbd130021f06708763e16ef2ad3679641c18e5e4d4578c2122492cea4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_TEST_IS_EXECUTABLE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga33c24ccefbd130021f06708763e16ef2ad9ab64f07fd4fc2105b53b7379265535</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_TEST_EXISTS</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga33c24ccefbd130021f06708763e16ef2a37c8f223bda6b6ce2875490351989ddd</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>SeekType</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gaa3767731311bdba4ef42dc99215e5cda</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SEEK_TYPE_CUR</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaa3767731311bdba4ef42dc99215e5cdaa48f0a394042c3a8e117b2ae64af33960</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SEEK_TYPE_SET</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaa3767731311bdba4ef42dc99215e5cdaa1e0d3b4a03e5dd32f135acc89982889f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SEEK_TYPE_END</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaa3767731311bdba4ef42dc99215e5cdaafa5ff5cdf7e6623866c717fe49cfbaec</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>IOStatus</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga23fb251e48485b62a9c2677bb1f87d5e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_STATUS_ERROR</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga23fb251e48485b62a9c2677bb1f87d5ea121996c81c45593110cd714bb81bc349</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_STATUS_NORMAL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga23fb251e48485b62a9c2677bb1f87d5eaf249c5b8e984c37db0847258aeeae86a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_STATUS_EOF</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga23fb251e48485b62a9c2677bb1f87d5ead42ae91b402716ab4faaec9b0f3823fe</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_STATUS_AGAIN</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga23fb251e48485b62a9c2677bb1f87d5ea5a33609d7ff07e1d711185c0765cf5de</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>IOFlags</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gaee093e5db5bc1ea5738771ba0d1af3b7</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_FLAG_APPEND</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaee093e5db5bc1ea5738771ba0d1af3b7a121e65986f06397730c4c36d09fb4dc7</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_FLAG_NONBLOCK</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaee093e5db5bc1ea5738771ba0d1af3b7a3724a778574d25ba0bd83139a80b2c0b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_FLAG_IS_READABLE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaee093e5db5bc1ea5738771ba0d1af3b7a162bfe5ccb18465d0f11e954cc4a89d9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_FLAG_IS_WRITEABLE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaee093e5db5bc1ea5738771ba0d1af3b7af9738e0234ae1d1f15c4512d6edb16db</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_FLAG_IS_SEEKABLE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaee093e5db5bc1ea5738771ba0d1af3b7ac1373a306084710994199b3de0137cfd</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_FLAG_GET_MASK</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaee093e5db5bc1ea5738771ba0d1af3b7a9431cd6fcef2a716b7d313bd9cde85b6</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_FLAG_SET_MASK</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaee093e5db5bc1ea5738771ba0d1af3b7a1d4db9b335a96f503cd491973b162105</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>KeyFileFlags</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga5866be36312563d91e5a7be27348459b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>KEY_FILE_NONE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga5866be36312563d91e5a7be27348459ba06a606cb7b5f244a0f3ad4f5e67b30bb</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>KEY_FILE_KEEP_COMMENTS</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga5866be36312563d91e5a7be27348459ba00058fa3d8e271d9ff5e1469dc39dc69</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>KEY_FILE_KEEP_TRANSLATIONS</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga5866be36312563d91e5a7be27348459ba7ff723c84c930b978dccd6732eebe985</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>ModuleFlags</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga502283ffbe523adf38c69905ec8640f3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MODULE_BIND_LAZY</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga502283ffbe523adf38c69905ec8640f3acd94d05ef9ba97ceb6f3904b87f5bbfc</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MODULE_BIND_LOCAL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga502283ffbe523adf38c69905ec8640f3a8e5768a91ee8dbf459785dee8b664b72</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MODULE_BIND_MASK</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga502283ffbe523adf38c69905ec8640f3a9cbf95b359863e9296457cbb0f193169</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>TraverseType</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gae3a70fa1e451da068323419e8c98e9a9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TRAVERSE_IN_ORDER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggae3a70fa1e451da068323419e8c98e9a9aa7f260b474a886df2bf1aefcfc0f14b2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TRAVERSE_PRE_ORDER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggae3a70fa1e451da068323419e8c98e9a9abed8efe71581ccb087323f38b6807661</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TRAVERSE_POST_ORDER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggae3a70fa1e451da068323419e8c98e9a9a0af70e322b94dfbbfc98b100d21cef4e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TRAVERSE_LEVEL_ORDER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggae3a70fa1e451da068323419e8c98e9a9a16cd819f4ab8175453f6287aeefad870</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>RegexCompileFlags</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gaaaedee3e1374af9f1d66ccd34252a68d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_CASELESS</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaaaedee3e1374af9f1d66ccd34252a68da0f604aee4eae77ce7bca901c8b3de37d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_MULTILINE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaaaedee3e1374af9f1d66ccd34252a68daee58700869ae67ad0823d10a7c51cb9d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_DOTALL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaaaedee3e1374af9f1d66ccd34252a68da7ec3013d10b6360c921d67f23ff585fa</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_EXTENDED</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaaaedee3e1374af9f1d66ccd34252a68da4ef80551354a8a16bcefaf9b35f55a17</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_ANCHORED</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaaaedee3e1374af9f1d66ccd34252a68da67404d06bba595dec28fb4e6e05da427</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_DOLLAR_ENDONLY</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaaaedee3e1374af9f1d66ccd34252a68da0d7cf52858b215b55ff10ccae9732dd4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_UNGREEDY</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaaaedee3e1374af9f1d66ccd34252a68daf9c564d8191b7220f0f072b3b694f8ac</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_RAW</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaaaedee3e1374af9f1d66ccd34252a68da3acb6bdd173741b57cf267be3a3c7f75</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_NO_AUTO_CAPTURE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaaaedee3e1374af9f1d66ccd34252a68dac6ccf906840973453a55625b2edf2f25</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_OPTIMIZE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaaaedee3e1374af9f1d66ccd34252a68da581257f414998f8ea0e0f55adf0844f0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_DUPNAMES</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaaaedee3e1374af9f1d66ccd34252a68da895a8a3fb7141b91a1890ee0bdb1a6b1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_NEWLINE_CR</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaaaedee3e1374af9f1d66ccd34252a68da3cab374f897aaac10d71c5437f9d77f3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_NEWLINE_LF</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaaaedee3e1374af9f1d66ccd34252a68dabbbc306156a05aa67fde8d86d6d3b3c9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_NEWLINE_CRLF</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaaaedee3e1374af9f1d66ccd34252a68da8a419c54023c5dbedbd8960c9367d68a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>RegexMatchFlags</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga8375c7f6797efc96929e8be89435c746</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_MATCH_ANCHORED</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga8375c7f6797efc96929e8be89435c746ac387b5b0e77b1726553e5d77e77191d9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_MATCH_NOTBOL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga8375c7f6797efc96929e8be89435c746afcdffce16a01e99f25f52bfe3deafd80</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_MATCH_NOTEOL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga8375c7f6797efc96929e8be89435c746a70b70be752f4874a262c15b99b3ee75f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_MATCH_NOTEMPTY</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga8375c7f6797efc96929e8be89435c746a58bc907f6f6e19c30456c895d18ea655</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_MATCH_PARTIAL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga8375c7f6797efc96929e8be89435c746aaa4d21e1c7f7ab1df117d433cafc5ad6</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_MATCH_NEWLINE_CR</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga8375c7f6797efc96929e8be89435c746aed663630c5623dc65f0ea23a04cf2979</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_MATCH_NEWLINE_LF</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga8375c7f6797efc96929e8be89435c746af5656ccd40cd632e00bc71b08834386e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_MATCH_NEWLINE_CRLF</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga8375c7f6797efc96929e8be89435c746a4b76b13cfd30f891108f491a58dbb2a9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_MATCH_NEWLINE_ANY</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga8375c7f6797efc96929e8be89435c746ac76fe84aa6df3f8e6af74504ff5e7ca8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>SpawnFlags</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga075918988c271e7fb63f1a1d083e26dd</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SPAWN_LEAVE_DESCRIPTORS_OPEN</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga075918988c271e7fb63f1a1d083e26ddaa2a457be3bdc07bbd0d32e1a63264d90</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SPAWN_DO_NOT_REAP_CHILD</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga075918988c271e7fb63f1a1d083e26dda0ad30b49d46750083ddd1e0643635e85</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SPAWN_SEARCH_PATH</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga075918988c271e7fb63f1a1d083e26dda341e5cb2803eb06a0f2f0431d6305e04</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SPAWN_STDOUT_TO_DEV_NULL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga075918988c271e7fb63f1a1d083e26dda450919630c2ce753374d1d05760bb205</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SPAWN_STDERR_TO_DEV_NULL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga075918988c271e7fb63f1a1d083e26dda5ae7fa0d4f6a0bdfc37adeb578634491</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SPAWN_CHILD_INHERITS_STDIN</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga075918988c271e7fb63f1a1d083e26dda9fb3c6cfddb2ef201f7b11829da8b5d0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SPAWN_FILE_AND_ARGV_ZERO</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga075918988c271e7fb63f1a1d083e26dda55dc12133953441059847e8633227a84</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>ThreadPriority</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga9b87dca6496b6ad53baec9ca01318448</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>THREAD_PRIORITY_LOW</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga9b87dca6496b6ad53baec9ca01318448a035a7bdc6a5b5eae6f644ed2605e8a37</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>THREAD_PRIORITY_NORMAL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga9b87dca6496b6ad53baec9ca01318448a6216bb25baaaca32642841ade911a92e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>THREAD_PRIORITY_HIGH</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga9b87dca6496b6ad53baec9ca01318448aef77081535e90116b203ce3b3b0fe523</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>THREAD_PRIORITY_URGENT</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga9b87dca6496b6ad53baec9ca01318448a5b79355bbd59c508995af57e0ed39a94</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>NotLock</name>
      <anchorfile>group__Threads.html</anchorfile>
      <anchor>ga2dd111336e3b057b51ca5871795fffa4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NOT_LOCK</name>
      <anchorfile>group__Threads.html</anchorfile>
      <anchor>gga2dd111336e3b057b51ca5871795fffa4a9681fb4e85e62ba64e39a12526eaa840</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>TryLock</name>
      <anchorfile>group__Threads.html</anchorfile>
      <anchor>ga7441a36336ea4cdb35c0fddbf3f97b19</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TRY_LOCK</name>
      <anchorfile>group__Threads.html</anchorfile>
      <anchor>gga7441a36336ea4cdb35c0fddbf3f97b19adf6b2565785992ff637cbc453988841d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>UnicodeType</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gadfbb414be3a4d127146fdca66dc7a46e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_CONTROL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46eac280382585f1014b43ed228760e7c558</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_FORMAT</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46eaaedc3e279c1c7e01f1bec907bbe313ab</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_UNASSIGNED</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46eafc32abac3afbe8380d54790f178fd3de</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_PRIVATE_USE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46ea5ca14907043380b1e9d725671bc71a56</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_SURROGATE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46ea0b99b4f93ef273ea4c49fb82970f5e54</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_LOWERCASE_LETTER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46eadb83c3e23724b6ef15888c6527a063bc</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_MODIFIER_LETTER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46eae6e48ddd5b4eacb4cbf67fa902743458</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_OTHER_LETTER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46ea57ced328464824fe23113e7b98a4ae61</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_TITLECASE_LETTER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46eab72e09c06a5aeffccdd94d5695dfcbc8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_UPPERCASE_LETTER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46ea8f344db3f8e39ed99bc2c9665ab96c89</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_COMBINING_MARK</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46ea5d22c0c4d39d68b815dccd52bb5ff01c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_ENCLOSING_MARK</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46ea4508b84626068a2dbf23a69b96475e6e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_NON_SPACING_MARK</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46ea857864a5d1c145cc3ff8ccba54834f19</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_DECIMAL_NUMBER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46eae75e5f353bc068ec3d8bf2555c540995</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_LETTER_NUMBER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46ea19811baedb3dbc8afddde43d00eb3cd9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_OTHER_NUMBER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46ea45a259cec90b0ada120fe7116be422b5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_CONNECT_PUNCTUATION</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46ea649c83b23fb3d9bd7bf1803858cc5afe</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_DASH_PUNCTUATION</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46eaa1169c4e20b3a47f597005f84f9fa7fc</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_CLOSE_PUNCTUATION</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46ea1ffaf2aac92ca1e818cf3e26b8301b90</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_FINAL_PUNCTUATION</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46eab549f212a3f340bd660a962b298409ff</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_INITIAL_PUNCTUATION</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46eab247e5e7480ecbf382b2128c600b8720</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_OTHER_PUNCTUATION</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46ea5c9416f9219bf9282c49b7ca831f0c9e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_OPEN_PUNCTUATION</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46ea806e11a7f8d1a0b0688a0237ad1fa190</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_CURRENCY_SYMBOL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46ea40b40c2bb5d39acee2b81327e2efb905</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_MODIFIER_SYMBOL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46ea5b693a82d2e497a2b13cae8d5668097c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_MATH_SYMBOL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46ea28100e9fa5a262bbd32b973303746490</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_OTHER_SYMBOL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46ea298582645a73c91d191b7e1dc61d214f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_LINE_SEPARATOR</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46ead7650a40ddf3741e87a1039eba56b1a5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_PARAGRAPH_SEPARATOR</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46ea5b3c71c265af11b331d0ec4240af1c8f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_SPACE_SEPARATOR</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46eac2eafb967dc62399aeb5ff27c8896b0d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>UnicodeBreakType</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga1af1a717c84d71aa4aabc9fc77b4d0ea</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_MANDATORY</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa37c762c3c7b080f5795ed6f828231923</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_CARRIAGE_RETURN</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa6b7c9d7a0ac78d14cf06b18bfeb2ccf9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_LINE_FEED</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa7839936b879938c5056bdb55eb0b6b7a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_COMBINING_MARK</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa014f326eb07effe48f1b771459caa7c4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_SURROGATE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa032b712c48700209c7cc414ca88cda34</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_ZERO_WIDTH_SPACE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaadb5ff8a11c4e596677d161903c732c56</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_INSEPARABLE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa38f51c8283586493a3ebd45fa3b0113e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_NON_BREAKING_GLUE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa47784c7e2cd80f6ac179de7f7a3f54e6</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_CONTINGENT</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaae80d6fef8acf765da47c8235e39f4896</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_SPACE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaab37a6597dbf2e248b610769be7e5cb3d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_AFTER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaada4027a9bfc5ffdf90e3be612adad7aa</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_BEFORE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaab1efcdcd3d6ecb55dff58a2e2ee1b9e4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_BEFORE_AND_AFTER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaaafce05d8590e1b40ec427f8f78cf15ee</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_HYPHEN</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa7e6dd69fc00fdc42ab091a2916426dbc</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_NON_STARTER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaabe412d94a1f7d9e92cc5a20f0b549626</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_OPEN_PUNCTUATION</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa52ebd39d1b02dfd368992a2ef8e7fa7d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_CLOSE_PUNCTUATION</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaad1284afc0511ab69aa18554b8306fbca</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_QUOTATION</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa8fe57a799eacc3299fd256285dd1246d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_EXCLAMATION</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaaf628849c1e5b531c022e12695c1f6f5d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_IDEOGRAPHIC</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa22047a88734e9fe1e9e0fef994cfb20b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_NUMERIC</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa50a61c3c53da7558d08c1fcbcfc3b138</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_INFIX_SEPARATOR</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa07f3d0d76db141033eff38ee7577ffd2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_SYMBOL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaafc02ec4862f016b6c2da35592f6cd62b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_ALPHABETIC</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaaea27a8970e74f93f485d45f6a1684586</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_PREFIX</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa580794ffc9992e65666adce0611eecb4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_POSTFIX</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa7ca3941d5dea03a5c824ae55212db01a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_COMPLEX_CONTEXT</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa3a96b8e59ba5815700d33c1f6006a339</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_AMBIGUOUS</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaae79244811e61b30eb68ee02dc45f1c09</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_UNKNOWN</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaaeb94f98b2233fae0afb38bf115b4b42d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_NEXT_LINE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa7ffad3080f483a6b97680db786836ced</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_WORD_JOINER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa9a74e7d947f75ef93d4e3aacebdb898b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_HANGUL_L_JAMO</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaab3449fb99a5694c3f6debd9d1a887a1b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_HANGUL_V_JAMO</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa156946aa6aec4f4e0f8e69d352f31f90</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_HANGUL_T_JAMO</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa37082de3ccd45cca392c6dee935d7cc0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_HANGUL_LV_SYLLABLE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa7a11c61184436fe2fb6e74d0ea916f86</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_HANGUL_LVT_SYLLABLE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa44dec475bcc1d26dc3ad905c302efc87</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>AsciiType</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga2e5a690ed07dfaa6f9ad9f1c57acd787</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ASCII_ALNUM</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga2e5a690ed07dfaa6f9ad9f1c57acd787af7d63a99479102b5391b44f631b5f009</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ASCII_ALPHA</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga2e5a690ed07dfaa6f9ad9f1c57acd787ac87947c729ac3c3f9f58b0ca28460152</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ASCII_CNTRL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga2e5a690ed07dfaa6f9ad9f1c57acd787a2e19c57ce5a6eac38d911a86cc44a2fb</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ASCII_DIGIT</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga2e5a690ed07dfaa6f9ad9f1c57acd787a9acd9a82d0670a3eb0377db782f48853</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ASCII_GRAPH</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga2e5a690ed07dfaa6f9ad9f1c57acd787a2ecdbe5137af423fce73ff2bbb34d625</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ASCII_LOWER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga2e5a690ed07dfaa6f9ad9f1c57acd787a875d3cb7494e1548db0d37ab44d4057e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ASCII_PRINT</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga2e5a690ed07dfaa6f9ad9f1c57acd787a9b1775043a8043d994c0c0ab890e86c4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ASCII_PUNCT</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga2e5a690ed07dfaa6f9ad9f1c57acd787ad3416d8662560db626259013ff72c58f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ASCII_SPACE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga2e5a690ed07dfaa6f9ad9f1c57acd787a7d7a68814efba3cf3d294475123413ce</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ASCII_UPPER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga2e5a690ed07dfaa6f9ad9f1c57acd787a5ae30681069b2ab88eed13e358c08090</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ASCII_XDIGIT</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga2e5a690ed07dfaa6f9ad9f1c57acd787ad78490a35d65839f2f06449e7e472337</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>NormalizeMode</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga18199b64f406e397627a4e7fc799f848</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NORMALIZE_DEFAULT</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga18199b64f406e397627a4e7fc799f848acbaee513b23e0066962df2e540cd4c99</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NORMALIZE_NFD</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga18199b64f406e397627a4e7fc799f848a169a0ae0910535038d8d403f874f0b5f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NORMALIZE_DEFAULT_COMPOSE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga18199b64f406e397627a4e7fc799f848ad9fb4be6b95958030771b4e8cba4144c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NORMALIZE_NFC</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga18199b64f406e397627a4e7fc799f848a20e4b8b42b12a7972ca4f6c84030978d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NORMALIZE_ALL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga18199b64f406e397627a4e7fc799f848aa1cf5911572000f5273dc46fe2c5b270</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NORMALIZE_NFKD</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga18199b64f406e397627a4e7fc799f848a995775ef324bbd76a91a74c7f2686867</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NORMALIZE_ALL_COMPOSE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga18199b64f406e397627a4e7fc799f848a7c98a2300648a33ca0ebc87fed999ca5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NORMALIZE_NFKC</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga18199b64f406e397627a4e7fc799f848aa7f62ac84c5ed8a8868cbb49a889dd98</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>OwnershipType</name>
      <anchorfile>group__ContHandles.html</anchorfile>
      <anchor>ga64c27560b41710ccf64a3679a3ba3f20</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>OWNERSHIP_NONE</name>
      <anchorfile>group__ContHandles.html</anchorfile>
      <anchor>gga64c27560b41710ccf64a3679a3ba3f20a7d594cffcc2d2d6c4313ddb4d6613c79</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>OWNERSHIP_SHALLOW</name>
      <anchorfile>group__ContHandles.html</anchorfile>
      <anchor>gga64c27560b41710ccf64a3679a3ba3f20a448c598cdc37e2de8a162e1020001715</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>OWNERSHIP_DEEP</name>
      <anchorfile>group__ContHandles.html</anchorfile>
      <anchor>gga64c27560b41710ccf64a3679a3ba3f20a2a6d6bfadc36f9eda31af79d32928c6a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>IOCondition</name>
      <anchorfile>group__MainLoop.html</anchorfile>
      <anchor>gabd96381793b70d4ae32c725926990918</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_IN</name>
      <anchorfile>group__MainLoop.html</anchorfile>
      <anchor>ggabd96381793b70d4ae32c725926990918af244f3e8c1c9525762f3630befd76336</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_OUT</name>
      <anchorfile>group__MainLoop.html</anchorfile>
      <anchor>ggabd96381793b70d4ae32c725926990918a60f61c8f26f2bb61afd3ad8afd673099</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_PRI</name>
      <anchorfile>group__MainLoop.html</anchorfile>
      <anchor>ggabd96381793b70d4ae32c725926990918a36bb5411dda1131e5c23e17a8619c820</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERR</name>
      <anchorfile>group__MainLoop.html</anchorfile>
      <anchor>ggabd96381793b70d4ae32c725926990918a2e402c9fd5879c49ef5359fa4189acd3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_HUP</name>
      <anchorfile>group__MainLoop.html</anchorfile>
      <anchor>ggabd96381793b70d4ae32c725926990918ab5dcc0e24c236c027b041d362dcff35b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_NVAL</name>
      <anchorfile>group__MainLoop.html</anchorfile>
      <anchor>ggabd96381793b70d4ae32c725926990918ad37b5d6ba6a0c1ad98510f352ac2f885</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PRIORITY_HIGH</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>a0c450f82b9e34689e2dda2038ba7834faa3219d7be6fa3282a80d7a850c401db9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PRIORITY_DEFAULT</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>a0c450f82b9e34689e2dda2038ba7834fa597ed3aa6067516c9c752896f3816b5e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PRIORITY_HIGH_IDLE</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>a0c450f82b9e34689e2dda2038ba7834faf2d20696a8afab425c00268d981e9897</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PRIORITY_DEFAULT_IDLE</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>a0c450f82b9e34689e2dda2038ba7834fae8c1127af0a2dab71f196a957dab8375</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PRIORITY_LOW</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>a0c450f82b9e34689e2dda2038ba7834fac6034649b50f9f92a69c1e67b92ecfc8</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_charset</name>
      <anchorfile>group__CharsetConv.html</anchorfile>
      <anchor>gabf5fac564c47a7a9ad6037044c3909f4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_charset</name>
      <anchorfile>group__CharsetConv.html</anchorfile>
      <anchor>ga88965337df48a173a6b013e8243e4631</anchor>
      <arglist>(std::string &amp;charset)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>convert</name>
      <anchorfile>group__CharsetConv.html</anchorfile>
      <anchor>ga58f7e4556c436a96c64b186bbc8f7f4c</anchor>
      <arglist>(const std::string &amp;str, const std::string &amp;to_codeset, const std::string &amp;from_codeset)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>convert_with_fallback</name>
      <anchorfile>group__CharsetConv.html</anchorfile>
      <anchor>ga40b5aa172fabd1f3dbf50a962d0d351f</anchor>
      <arglist>(const std::string &amp;str, const std::string &amp;to_codeset, const std::string &amp;from_codeset)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>convert_with_fallback</name>
      <anchorfile>group__CharsetConv.html</anchorfile>
      <anchor>gaf1b091e4397a7637e884148484b1f71e</anchor>
      <arglist>(const std::string &amp;str, const std::string &amp;to_codeset, const std::string &amp;from_codeset, const Glib::ustring &amp;fallback)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>locale_to_utf8</name>
      <anchorfile>group__CharsetConv.html</anchorfile>
      <anchor>ga4517b17f2aad4cd5c0e0640de212d928</anchor>
      <arglist>(const std::string &amp;opsys_string)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>locale_from_utf8</name>
      <anchorfile>group__CharsetConv.html</anchorfile>
      <anchor>gacc062729285890a7e9b22bece6fb987c</anchor>
      <arglist>(const Glib::ustring &amp;utf8_string)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>filename_to_utf8</name>
      <anchorfile>group__CharsetConv.html</anchorfile>
      <anchor>ga6cf95dc00505401594260a360d70c17b</anchor>
      <arglist>(const std::string &amp;opsys_string)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>filename_from_utf8</name>
      <anchorfile>group__CharsetConv.html</anchorfile>
      <anchor>ga2bd94064ad97b43324a7854b62f0835b</anchor>
      <arglist>(const Glib::ustring &amp;utf8_string)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>filename_from_uri</name>
      <anchorfile>group__CharsetConv.html</anchorfile>
      <anchor>gada23cd7f7dc8eb25e99b867a55551763</anchor>
      <arglist>(const Glib::ustring &amp;uri, Glib::ustring &amp;hostname)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>filename_from_uri</name>
      <anchorfile>group__CharsetConv.html</anchorfile>
      <anchor>gab1cb94f4a4a70bad06b715fb14a252d9</anchor>
      <arglist>(const Glib::ustring &amp;uri)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>filename_to_uri</name>
      <anchorfile>group__CharsetConv.html</anchorfile>
      <anchor>gae1b2f056bde3fbab578c602fe42e3de9</anchor>
      <arglist>(const std::string &amp;filename, const Glib::ustring &amp;hostname)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>filename_to_uri</name>
      <anchorfile>group__CharsetConv.html</anchorfile>
      <anchor>gaaf69aec83665229cc06596cf627d9d5a</anchor>
      <arglist>(const std::string &amp;filename)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>filename_display_basename</name>
      <anchorfile>group__CharsetConv.html</anchorfile>
      <anchor>ga05dd67157ad35da4401263247b6f4d81</anchor>
      <arglist>(const std::string &amp;filename)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>filename_display_name</name>
      <anchorfile>group__CharsetConv.html</anchorfile>
      <anchor>gabc1b404cc965f3da6beecddfe2623afc</anchor>
      <arglist>(const std::string &amp;filename)</arglist>
    </member>
    <member kind="function">
      <type>FileTest</type>
      <name>operator|</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga8e018d8609ba17b0f6955505a8363bf7</anchor>
      <arglist>(FileTest lhs, FileTest rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileTest</type>
      <name>operator&amp;</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gae652f47e7b61603b9a6b86b7251d5526</anchor>
      <arglist>(FileTest lhs, FileTest rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileTest</type>
      <name>operator^</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga6c089f23d6bfd92e083edc75519db75e</anchor>
      <arglist>(FileTest lhs, FileTest rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileTest</type>
      <name>operator~</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga948edadd8ee7442b83d37dc3c325f890</anchor>
      <arglist>(FileTest flags)</arglist>
    </member>
    <member kind="function">
      <type>FileTest &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga9a6f5470f667596e897f5bfbd1068283</anchor>
      <arglist>(FileTest &amp;lhs, FileTest rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileTest &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga112ada474a7aad83af2bd49403abf41e</anchor>
      <arglist>(FileTest &amp;lhs, FileTest rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileTest &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga2219c78993a5196ca2a435a18e0fc3a7</anchor>
      <arglist>(FileTest &amp;lhs, FileTest rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>file_test</name>
      <anchorfile>group__FileUtils.html</anchorfile>
      <anchor>ga0b2fce78896a9a84f7ea3a5646cc7d36</anchor>
      <arglist>(const std::string &amp;filename, FileTest test)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>mkstemp</name>
      <anchorfile>group__FileUtils.html</anchorfile>
      <anchor>gae4c8d716bd109b6b8e1420a8c20b3507</anchor>
      <arglist>(std::string &amp;filename_template)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>file_open_tmp</name>
      <anchorfile>group__FileUtils.html</anchorfile>
      <anchor>gae91f239f1cf0123399374deed54fbf3a</anchor>
      <arglist>(std::string &amp;name_used, const std::string &amp;prefix)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>file_open_tmp</name>
      <anchorfile>group__FileUtils.html</anchorfile>
      <anchor>ga682379de4ea119540b4bdc1759e93e1d</anchor>
      <arglist>(std::string &amp;name_used)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>file_get_contents</name>
      <anchorfile>group__FileUtils.html</anchorfile>
      <anchor>ga835da54212fe78e833ac55b49150b989</anchor>
      <arglist>(const std::string &amp;filename)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>file_set_contents</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>a4c6c4cb2115f410b15f09634909b0b7c</anchor>
      <arglist>(const std::string &amp;filename, const gchar *contents, gssize length)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>file_set_contents</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>a3e51edee26822f97749f589138776850</anchor>
      <arglist>(const std::string &amp;filename, const std::string &amp;contents)</arglist>
    </member>
    <member kind="function">
      <type>IOFlags</type>
      <name>operator|</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga0dd0a8800b6311ee8f3867eb27a72ae5</anchor>
      <arglist>(IOFlags lhs, IOFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>IOFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga7662618e73d046d4df5eb7cce3e487f8</anchor>
      <arglist>(IOFlags lhs, IOFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>IOFlags</type>
      <name>operator^</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gad61c57b0678c703e8a14230d18bacff7</anchor>
      <arglist>(IOFlags lhs, IOFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>IOFlags</type>
      <name>operator~</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga548c1cb09208fef57e5d0b3c992d71b9</anchor>
      <arglist>(IOFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>IOFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gac3539f6df5e0c0658726f4f0573146f9</anchor>
      <arglist>(IOFlags &amp;lhs, IOFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>IOFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gae84d9361a6154e6b0e8d099705ad6cad</anchor>
      <arglist>(IOFlags &amp;lhs, IOFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>IOFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga2180a5c566ced37bbeb37050d9632da9</anchor>
      <arglist>(IOFlags &amp;lhs, IOFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; IOChannel &gt;</type>
      <name>wrap</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>a671306f4a3a0cae5ab4d7a9d54886592</anchor>
      <arglist>(GIOChannel *gobject, bool take_copy=false)</arglist>
    </member>
    <member kind="function">
      <type>KeyFileFlags</type>
      <name>operator|</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gabac5e1493392116b118e4d1048e3fef0</anchor>
      <arglist>(KeyFileFlags lhs, KeyFileFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>KeyFileFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga1827ef58fe5e85d65ff8166e51b33556</anchor>
      <arglist>(KeyFileFlags lhs, KeyFileFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>KeyFileFlags</type>
      <name>operator^</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gacc28b21831114895abfdbae6c1908114</anchor>
      <arglist>(KeyFileFlags lhs, KeyFileFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>KeyFileFlags</type>
      <name>operator~</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gab99ff1d7c6d96da2ddfcfd1c4954e9b6</anchor>
      <arglist>(KeyFileFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>KeyFileFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga7096a34594825c90d7b6257935a62eb1</anchor>
      <arglist>(KeyFileFlags &amp;lhs, KeyFileFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>KeyFileFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga80dd56fcaea8bc3f0a5f21b9d3049877</anchor>
      <arglist>(KeyFileFlags &amp;lhs, KeyFileFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>KeyFileFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gac90869f74a743e2f99f55708c28a585d</anchor>
      <arglist>(KeyFileFlags &amp;lhs, KeyFileFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ModuleFlags</type>
      <name>operator|</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gade862759d091b90329ba8f85aa2fd010</anchor>
      <arglist>(ModuleFlags lhs, ModuleFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ModuleFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gaacd06c8457fa8f31c1483f96c4933ddf</anchor>
      <arglist>(ModuleFlags lhs, ModuleFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ModuleFlags</type>
      <name>operator^</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga333d93ef372c08c322d27ac05bda0e18</anchor>
      <arglist>(ModuleFlags lhs, ModuleFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ModuleFlags</type>
      <name>operator~</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gaaa723a5b4d33e54167f7adbb18746004</anchor>
      <arglist>(ModuleFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>ModuleFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gae9df767ea1ec74b0d9d9acce426a07a8</anchor>
      <arglist>(ModuleFlags &amp;lhs, ModuleFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ModuleFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gab903aa5397125ce37c66a259c4b1a5f5</anchor>
      <arglist>(ModuleFlags &amp;lhs, ModuleFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ModuleFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga8e73a634c6441630eddf8805b22dd163</anchor>
      <arglist>(ModuleFlags &amp;lhs, ModuleFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>RegexCompileFlags</type>
      <name>operator|</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga5c44b3a4eee7eefbb1f2d1d8f22642ca</anchor>
      <arglist>(RegexCompileFlags lhs, RegexCompileFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>RegexCompileFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga4ae748a01d312275d2ca4e15c5df5826</anchor>
      <arglist>(RegexCompileFlags lhs, RegexCompileFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>RegexCompileFlags</type>
      <name>operator^</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga69068f48bbea92cdd3cc7d69fdc017e1</anchor>
      <arglist>(RegexCompileFlags lhs, RegexCompileFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>RegexCompileFlags</type>
      <name>operator~</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gacb650222b1a3f6a44e72df95d815a7f8</anchor>
      <arglist>(RegexCompileFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>RegexCompileFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gae6fd65d5a674d2e2e453793d86fa64cd</anchor>
      <arglist>(RegexCompileFlags &amp;lhs, RegexCompileFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>RegexCompileFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gaeefcf05c20e07dde23268b83a1ff1c45</anchor>
      <arglist>(RegexCompileFlags &amp;lhs, RegexCompileFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>RegexCompileFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga1425051a4ffed939a1bff1e0543c9498</anchor>
      <arglist>(RegexCompileFlags &amp;lhs, RegexCompileFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>RegexMatchFlags</type>
      <name>operator|</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gab63da3a959cbd5f00f4fa535e35eda08</anchor>
      <arglist>(RegexMatchFlags lhs, RegexMatchFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>RegexMatchFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga29b80a6c4482fae8e19f9328ec0c3147</anchor>
      <arglist>(RegexMatchFlags lhs, RegexMatchFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>RegexMatchFlags</type>
      <name>operator^</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga06c395f619dffca3f0fc483fab302122</anchor>
      <arglist>(RegexMatchFlags lhs, RegexMatchFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>RegexMatchFlags</type>
      <name>operator~</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gaf192ce556cbd7ddb416e8078bdb09523</anchor>
      <arglist>(RegexMatchFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>RegexMatchFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga8f30deab298559a873d7beca40279ead</anchor>
      <arglist>(RegexMatchFlags &amp;lhs, RegexMatchFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>RegexMatchFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga283a3e82cd9d3da8746edbe13a6f616a</anchor>
      <arglist>(RegexMatchFlags &amp;lhs, RegexMatchFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>RegexMatchFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga402d81f594d95305aa6e275aa74126ae</anchor>
      <arglist>(RegexMatchFlags &amp;lhs, RegexMatchFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ArrayHandle&lt; std::string &gt;</type>
      <name>shell_parse_argv</name>
      <anchorfile>group__ShellUtils.html</anchorfile>
      <anchor>gabc52fcb14cfc7a5ba37ca821cc837818</anchor>
      <arglist>(const std::string &amp;command_line)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>shell_quote</name>
      <anchorfile>group__ShellUtils.html</anchorfile>
      <anchor>ga55ebfb935f2131b2ae40d339568f568c</anchor>
      <arglist>(const std::string &amp;unquoted_string)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>shell_unquote</name>
      <anchorfile>group__ShellUtils.html</anchorfile>
      <anchor>ga449dc37c6ea7e7563740df86e31c263c</anchor>
      <arglist>(const std::string &amp;quoted_string)</arglist>
    </member>
    <member kind="function">
      <type>SpawnFlags</type>
      <name>operator|</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gaba6cac919da111ebf69667bf9f8006ff</anchor>
      <arglist>(SpawnFlags lhs, SpawnFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SpawnFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga2d10b36fdc1ceb9fea2ffcd58406f3e2</anchor>
      <arglist>(SpawnFlags lhs, SpawnFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SpawnFlags</type>
      <name>operator^</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga84449a9a461b381f88f65435ef8389ec</anchor>
      <arglist>(SpawnFlags lhs, SpawnFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SpawnFlags</type>
      <name>operator~</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga065f45ca68d1397febf331293e4cc4de</anchor>
      <arglist>(SpawnFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>SpawnFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gabbe289c910b34a158f8dc22bb0b0095f</anchor>
      <arglist>(SpawnFlags &amp;lhs, SpawnFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SpawnFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga93f15ab009ea244c1d8b069e27ec193f</anchor>
      <arglist>(SpawnFlags &amp;lhs, SpawnFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SpawnFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga40166fcca8eb8ec5b148c82444553927</anchor>
      <arglist>(SpawnFlags &amp;lhs, SpawnFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>spawn_async_with_pipes</name>
      <anchorfile>group__Spawn.html</anchorfile>
      <anchor>ga0a530eed9f6343ea1d51cb8ec8051ce7</anchor>
      <arglist>(const std::string &amp;working_directory, const Glib::ArrayHandle&lt; std::string &gt; &amp;argv, const Glib::ArrayHandle&lt; std::string &gt; &amp;envp, SpawnFlags flags=SpawnFlags(0), const sigc::slot&lt; void &gt; &amp;child_setup=sigc::slot&lt; void &gt;(), Pid *child_pid=0, int *standard_input=0, int *standard_output=0, int *standard_error=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>spawn_async_with_pipes</name>
      <anchorfile>group__Spawn.html</anchorfile>
      <anchor>ga36b7c1d110d10f86f3ef5d6e10db206f</anchor>
      <arglist>(const std::string &amp;working_directory, const Glib::ArrayHandle&lt; std::string &gt; &amp;argv, SpawnFlags flags=SpawnFlags(0), const sigc::slot&lt; void &gt; &amp;child_setup=sigc::slot&lt; void &gt;(), Pid *child_pid=0, int *standard_input=0, int *standard_output=0, int *standard_error=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>spawn_async</name>
      <anchorfile>group__Spawn.html</anchorfile>
      <anchor>ga5d42ba801678215f3820382388df32b0</anchor>
      <arglist>(const std::string &amp;working_directory, const Glib::ArrayHandle&lt; std::string &gt; &amp;argv, const Glib::ArrayHandle&lt; std::string &gt; &amp;envp, SpawnFlags flags=SpawnFlags(0), const sigc::slot&lt; void &gt; &amp;child_setup=sigc::slot&lt; void &gt;(), Pid *child_pid=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>spawn_async</name>
      <anchorfile>group__Spawn.html</anchorfile>
      <anchor>ga0c4e1708989b50fb34266504cc038ee6</anchor>
      <arglist>(const std::string &amp;working_directory, const Glib::ArrayHandle&lt; std::string &gt; &amp;argv, SpawnFlags flags=SpawnFlags(0), const sigc::slot&lt; void &gt; &amp;child_setup=sigc::slot&lt; void &gt;(), Pid *child_pid=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>spawn_sync</name>
      <anchorfile>group__Spawn.html</anchorfile>
      <anchor>gad4fbf31fdb5536b104f4f75bf58c60e1</anchor>
      <arglist>(const std::string &amp;working_directory, const Glib::ArrayHandle&lt; std::string &gt; &amp;argv, const Glib::ArrayHandle&lt; std::string &gt; &amp;envp, SpawnFlags flags=SpawnFlags(0), const sigc::slot&lt; void &gt; &amp;child_setup=sigc::slot&lt; void &gt;(), std::string *standard_output=0, std::string *standard_error=0, int *exit_status=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>spawn_sync</name>
      <anchorfile>group__Spawn.html</anchorfile>
      <anchor>gacc157258907be90b58184baeebc9c740</anchor>
      <arglist>(const std::string &amp;working_directory, const Glib::ArrayHandle&lt; std::string &gt; &amp;argv, SpawnFlags flags=SpawnFlags(0), const sigc::slot&lt; void &gt; &amp;child_setup=sigc::slot&lt; void &gt;(), std::string *standard_output=0, std::string *standard_error=0, int *exit_status=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>spawn_command_line_async</name>
      <anchorfile>group__Spawn.html</anchorfile>
      <anchor>ga648167a4af607f87763f1334fe5a472f</anchor>
      <arglist>(const std::string &amp;command_line)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>spawn_command_line_sync</name>
      <anchorfile>group__Spawn.html</anchorfile>
      <anchor>ga713bdb79396eda85ad186cb2db89564f</anchor>
      <arglist>(const std::string &amp;command_line, std::string *standard_output=0, std::string *standard_error=0, int *exit_status=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>spawn_close_pid</name>
      <anchorfile>group__Spawn.html</anchorfile>
      <anchor>gaaea8f41c7a08af3b2919ce64fd0c27e5</anchor>
      <arglist>(Pid pid)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>thread_init</name>
      <anchorfile>group__Threads.html</anchorfile>
      <anchor>gab26d01c776801f1fff00753e97af4fc7</anchor>
      <arglist>(GThreadFunctions *vtable=0)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>thread_supported</name>
      <anchorfile>group__Threads.html</anchorfile>
      <anchor>gad59d126f6197035e6f6a31e7f4d87818</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>AsciiType</type>
      <name>operator|</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga5bc1518eb5547dbb8af77b944ccaa048</anchor>
      <arglist>(AsciiType lhs, AsciiType rhs)</arglist>
    </member>
    <member kind="function">
      <type>AsciiType</type>
      <name>operator&amp;</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga4c340e00aeb13a9124081f383283eed0</anchor>
      <arglist>(AsciiType lhs, AsciiType rhs)</arglist>
    </member>
    <member kind="function">
      <type>AsciiType</type>
      <name>operator^</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga682a545ca2e86b3e162305e4f14fa8d5</anchor>
      <arglist>(AsciiType lhs, AsciiType rhs)</arglist>
    </member>
    <member kind="function">
      <type>AsciiType</type>
      <name>operator~</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gad7ea47582094c6d092a8f485e1e709c6</anchor>
      <arglist>(AsciiType flags)</arglist>
    </member>
    <member kind="function">
      <type>AsciiType &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga69bba23f4c9a83c268d0599f241b8ebe</anchor>
      <arglist>(AsciiType &amp;lhs, AsciiType rhs)</arglist>
    </member>
    <member kind="function">
      <type>AsciiType &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga8f4b46bf548b21ef21a568ecc18a5871</anchor>
      <arglist>(AsciiType &amp;lhs, AsciiType rhs)</arglist>
    </member>
    <member kind="function">
      <type>AsciiType &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gac1b0239e539cf250333fe0adc04dbb41</anchor>
      <arglist>(AsciiType &amp;lhs, AsciiType rhs)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>uri_unescape_string</name>
      <anchorfile>group__UriUtils.html</anchorfile>
      <anchor>ga0c070cac984dc463fd60ccbdb4237e25</anchor>
      <arglist>(const std::string &amp;escaped_string, const std::string &amp;illegal_characters=std::string())</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>uri_parse_scheme</name>
      <anchorfile>group__UriUtils.html</anchorfile>
      <anchor>ga0cc4270d6796b2166964f08a5cb746b3</anchor>
      <arglist>(const std::string &amp;uri)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>uri_escape_string</name>
      <anchorfile>group__UriUtils.html</anchorfile>
      <anchor>gad902095ab5049111caa9207770b0a437</anchor>
      <arglist>(const std::string &amp;unescaped, const std::string &amp;reserved_chars_allowed=std::string(), bool allow_utf8=true)</arglist>
    </member>
    <member kind="function">
      <type>Sequence&lt; Iterator &gt;</type>
      <name>sequence</name>
      <anchorfile>group__ContHandles.html</anchorfile>
      <anchor>ga33e5a3a70ef5f7bed112046726ff8b04</anchor>
      <arglist>(Iterator pbegin, Iterator pend)</arglist>
    </member>
    <member kind="function">
      <type>sigc::connection</type>
      <name>add_exception_handler</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>a9a79a59cac511993cfea861bebd2f391</anchor>
      <arglist>(const sigc::slot&lt; void &gt; &amp;slot)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>init</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ac90aee10d0b90e3d8a96a86b5394f87b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>RefPtr&lt; ObjectBase &gt;</type>
      <name>wrap_interface</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>a75643fed688d354848a0379d3da00133</anchor>
      <arglist>(GObject *object, bool take_copy=false)</arglist>
    </member>
    <member kind="function">
      <type>IOCondition</type>
      <name>operator|</name>
      <anchorfile>group__MainLoop.html</anchorfile>
      <anchor>gab5937e9164f36f75ba87fd67903348d5</anchor>
      <arglist>(IOCondition lhs, IOCondition rhs)</arglist>
    </member>
    <member kind="function">
      <type>IOCondition</type>
      <name>operator&amp;</name>
      <anchorfile>group__MainLoop.html</anchorfile>
      <anchor>ga12928ddba0f38406f19d55547bac552b</anchor>
      <arglist>(IOCondition lhs, IOCondition rhs)</arglist>
    </member>
    <member kind="function">
      <type>IOCondition</type>
      <name>operator^</name>
      <anchorfile>group__MainLoop.html</anchorfile>
      <anchor>ga6416bbf923045261beb85241fff8ef0d</anchor>
      <arglist>(IOCondition lhs, IOCondition rhs)</arglist>
    </member>
    <member kind="function">
      <type>IOCondition</type>
      <name>operator~</name>
      <anchorfile>group__MainLoop.html</anchorfile>
      <anchor>ga85461947d24f306cefd2fe17999deb97</anchor>
      <arglist>(IOCondition flags)</arglist>
    </member>
    <member kind="function">
      <type>IOCondition &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__MainLoop.html</anchorfile>
      <anchor>ga8269a01826f8737d98ab0d345a0004f4</anchor>
      <arglist>(IOCondition &amp;lhs, IOCondition rhs)</arglist>
    </member>
    <member kind="function">
      <type>IOCondition &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__MainLoop.html</anchorfile>
      <anchor>ga11f46ad6051058eeeb34d5963a4f7c44</anchor>
      <arglist>(IOCondition &amp;lhs, IOCondition rhs)</arglist>
    </member>
    <member kind="function">
      <type>IOCondition &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__MainLoop.html</anchorfile>
      <anchor>ga995d6d5d01db67af62661bcd5dfd1ad6</anchor>
      <arglist>(IOCondition &amp;lhs, IOCondition rhs)</arglist>
    </member>
    <member kind="function">
      <type>SignalTimeout</type>
      <name>signal_timeout</name>
      <anchorfile>group__MainLoop.html</anchorfile>
      <anchor>gaadb206fcc112f086f9d47c016b1f2175</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>SignalIdle</type>
      <name>signal_idle</name>
      <anchorfile>group__MainLoop.html</anchorfile>
      <anchor>ga76792522d9680a05e232d3519a25f98d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>SignalIO</type>
      <name>signal_io</name>
      <anchorfile>group__MainLoop.html</anchorfile>
      <anchor>gaf391654b755a32169d18be4835677376</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>SignalChildWatch</type>
      <name>signal_child_watch</name>
      <anchorfile>group__MainLoop.html</anchorfile>
      <anchor>ga11ee7db80cc44ece02056a38bb049e3b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_application_name</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga9c2f67828083d74925b23c59ab868698</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_application_name</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga40e45835b7b461cba0f7a10fbb63c0d3</anchor>
      <arglist>(const Glib::ustring &amp;application_name)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_prgname</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga391655dededb496010eee2e92d0f1fdf</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_prgname</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga7d5c429822c09048892c4dee9c8e08c1</anchor>
      <arglist>(const std::string &amp;prgname)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>getenv</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga5e186fdb08835342a5866b11fe787ebb</anchor>
      <arglist>(const std::string &amp;variable, bool &amp;found)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>getenv</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga8e2c8f250aa7f059956737851ace08f6</anchor>
      <arglist>(const std::string &amp;variable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>setenv</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga862657f21e5a930541d048a920204f59</anchor>
      <arglist>(const std::string &amp;variable, const std::string &amp;value, bool overwrite=true)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unsetenv</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga6fb89001630714ec9ee5244cab56343e</anchor>
      <arglist>(const std::string &amp;variable)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_user_name</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga52964bfd712e8c9e688f668da51f3ed9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_real_name</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga30692e3263e66868878f535e0b7c9722</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_home_dir</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga9412ea70c7fea058c03211dac318f8e6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_tmp_dir</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>gac42272146fd9320958132f1591d28991</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_current_dir</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga06d93c95572d6a382b8cc4e09dd5a339</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_user_special_dir</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>gabc928a4e477df53f90e221a854cc73cb</anchor>
      <arglist>(GUserDirectory directory)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_user_data_dir</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga821b704b5ede1583e4057990976d394b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_user_config_dir</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>gae517b931f4753abcd48adb2769a8fc48</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_user_cache_dir</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>gaa68121f26e82df1c293c82b89c8998e5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>path_is_absolute</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>gad82525f39f7408f97f2c096c4f721b3b</anchor>
      <arglist>(const std::string &amp;filename)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>path_skip_root</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga306eee64abc3d28993895b826f4dd533</anchor>
      <arglist>(const std::string &amp;filename)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>path_get_basename</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga20ebf2917a7fce5d1901568017b95a35</anchor>
      <arglist>(const std::string &amp;filename)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>path_get_dirname</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>gae03457226c4239a74b83486739521434</anchor>
      <arglist>(const std::string &amp;filename)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>build_filename</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>gaa4a70bf050b3f318f87049ed30206a9a</anchor>
      <arglist>(const Glib::ArrayHandle&lt; std::string &gt; &amp;elements)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>build_filename</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>gada06023cc39be3a44eb68e38d6cbea6c</anchor>
      <arglist>(const std::string &amp;elem1, const std::string &amp;elem2)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>build_path</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga6afc89d45cc34f3cfce4a55f3f5e7afa</anchor>
      <arglist>(const std::string &amp;separator, const Glib::ArrayHandle&lt; std::string &gt; &amp;elements)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>find_program_in_path</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>gaa4c4ecb9a3eb803ae6d9dee51e1e5b14</anchor>
      <arglist>(const std::string &amp;program)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>str_has_prefix</name>
      <anchorfile>group__StringUtils.html</anchorfile>
      <anchor>ga6b7e8354049756e92a97554a107618ac</anchor>
      <arglist>(const std::string &amp;str, const std::string &amp;prefix)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>str_has_suffix</name>
      <anchorfile>group__StringUtils.html</anchorfile>
      <anchor>ga5c4e380ffc6617ac61ca92e203e45630</anchor>
      <arglist>(const std::string &amp;str, const std::string &amp;suffix)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>strescape</name>
      <anchorfile>group__StringUtils.html</anchorfile>
      <anchor>ga35e288b5ce34cb15eeec907421d2b77c</anchor>
      <arglist>(const std::string &amp;source)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>strescape</name>
      <anchorfile>group__StringUtils.html</anchorfile>
      <anchor>gad24f3547c8d6b3ec56d7f5805a11d6ab</anchor>
      <arglist>(const std::string &amp;source, const std::string &amp;exceptions)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>strcompress</name>
      <anchorfile>group__StringUtils.html</anchorfile>
      <anchor>ga85cd83bd40baf0119aac3ff0a9a5e7b2</anchor>
      <arglist>(const std::string &amp;source)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>strerror</name>
      <anchorfile>group__StringUtils.html</anchorfile>
      <anchor>ga1eb869894996c91c0f69dbff96714c71</anchor>
      <arglist>(int errnum)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>strsignal</name>
      <anchorfile>group__StringUtils.html</anchorfile>
      <anchor>ga44ce9f689aff8abe1e3073b209f360d3</anchor>
      <arglist>(int signum)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>usleep</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>a5d75264c8b47f13fb33f973b0d4fc73e</anchor>
      <arglist>(unsigned long microseconds)</arglist>
    </member>
    <member kind="function">
      <type>gunichar</type>
      <name>get_unichar_from_std_iterator</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>a1053052aad41d0dcf51f36c345bf4625</anchor>
      <arglist>(std::string::const_iterator pos)</arglist>
    </member>
    <member kind="function">
      <type>T::BaseObjectType *</type>
      <name>unwrap</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>a104920ed41b79c0b3b0aeaf3ed63d84b</anchor>
      <arglist>(T *ptr)</arglist>
    </member>
    <member kind="function">
      <type>const T::BaseObjectType *</type>
      <name>unwrap</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>a666f8c59e1804aeb02f48ff940fa602c</anchor>
      <arglist>(const T *ptr)</arglist>
    </member>
    <member kind="function">
      <type>T::BaseObjectType *</type>
      <name>unwrap</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>a5bbf90603746c170d0a99cef59bbe2d0</anchor>
      <arglist>(const Glib::RefPtr&lt; T &gt; &amp;ptr)</arglist>
    </member>
    <member kind="function">
      <type>const T::BaseObjectType *</type>
      <name>unwrap</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>a5bd5ddd4c962f4a26bf52a3ec783e8c5</anchor>
      <arglist>(const Glib::RefPtr&lt; const T &gt; &amp;ptr)</arglist>
    </member>
    <member kind="function">
      <type>T::BaseObjectType *</type>
      <name>unwrap_copy</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>a6cdcc90e63b4650a8f03f72bce01902a</anchor>
      <arglist>(const Glib::RefPtr&lt; T &gt; &amp;ptr)</arglist>
    </member>
    <member kind="function">
      <type>const T::BaseObjectType *</type>
      <name>unwrap_copy</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ad344713e5c0ac8ee6a46f9d04181a60e</anchor>
      <arglist>(const Glib::RefPtr&lt; const T &gt; &amp;ptr)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::Drive &gt;</type>
      <name>wrap</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>a3c4b3f9afbb1f72fcd0db0fb9d96a23e</anchor>
      <arglist>(GDrive *object, bool take_copy)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::Mount &gt;</type>
      <name>wrap</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>aecec41aa86f5a57489c23f367593802c</anchor>
      <arglist>(GMount *object, bool take_copy)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::Volume &gt;</type>
      <name>wrap</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>aa4ad6dff9c5f095f3b45b6af8124c883</anchor>
      <arglist>(GVolume *object, bool take_copy)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glib::Checksum</name>
    <filename>classGlib_1_1Checksum.html</filename>
    <member kind="enumeration">
      <name>ChecksumType</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga5d1c13a9d5c34bff7dd1e74654f282eb</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>CHECKSUM_MD5</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga5d1c13a9d5c34bff7dd1e74654f282eba3129e0040dd5c2541baadb2d3dd87ec3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>CHECKSUM_SHA1</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga5d1c13a9d5c34bff7dd1e74654f282eba7e5a02d18bd90f5988de70a06d22c7ad</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>CHECKSUM_SHA256</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga5d1c13a9d5c34bff7dd1e74654f282ebaf56ee9e607e115c54aaa7541ad9cb1b2</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Checksum</name>
      <anchorfile>classGlib_1_1Checksum.html</anchorfile>
      <anchor>a218ef89e5467d6cb8b2687813b286ced</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Checksum</name>
      <anchorfile>classGlib_1_1Checksum.html</anchorfile>
      <anchor>a1c27c48e7c6ad69617b8480b8aca4531</anchor>
      <arglist>(GChecksum *castitem, bool make_a_copy=false)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Checksum</name>
      <anchorfile>classGlib_1_1Checksum.html</anchorfile>
      <anchor>a4839f2e9e33ac5bdb1cf696d8ecf4a10</anchor>
      <arglist>(const Checksum &amp;src)</arglist>
    </member>
    <member kind="function">
      <type>Checksum &amp;</type>
      <name>operator=</name>
      <anchorfile>classGlib_1_1Checksum.html</anchorfile>
      <anchor>a830ae51f3f4cb4a024d3303f88bc6dcc</anchor>
      <arglist>(const Checksum &amp;src)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~Checksum</name>
      <anchorfile>classGlib_1_1Checksum.html</anchorfile>
      <anchor>a81332918818a0a29cd851e3811b1a0ef</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GChecksum *</type>
      <name>gobj</name>
      <anchorfile>classGlib_1_1Checksum.html</anchorfile>
      <anchor>a5bebbdf1ef296503c0eb86493e675cc7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GChecksum *</type>
      <name>gobj</name>
      <anchorfile>classGlib_1_1Checksum.html</anchorfile>
      <anchor>a40378be1df574c9f74fb7cc54d7b7056</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GChecksum *</type>
      <name>gobj_copy</name>
      <anchorfile>classGlib_1_1Checksum.html</anchorfile>
      <anchor>a6c2600dfa5258c5db06c7525396f8bb3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Checksum</name>
      <anchorfile>classGlib_1_1Checksum.html</anchorfile>
      <anchor>a774f43a89f371e8c50b6ff1da56291d8</anchor>
      <arglist>(ChecksumType checksum_type)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>operator bool</name>
      <anchorfile>classGlib_1_1Checksum.html</anchorfile>
      <anchor>ae817700e566bd94b9a71f358c4a4eeed</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>reset</name>
      <anchorfile>classGlib_1_1Checksum.html</anchorfile>
      <anchor>a75343718b489251d1ea7ea417674b2b6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>update</name>
      <anchorfile>classGlib_1_1Checksum.html</anchorfile>
      <anchor>a49c961d3ecf8a4c62bd2177c2e32ac79</anchor>
      <arglist>(const guchar *data, gsize length)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>update</name>
      <anchorfile>classGlib_1_1Checksum.html</anchorfile>
      <anchor>a6fa8c44666e92d66a6af10495e2df67d</anchor>
      <arglist>(const std::string &amp;data)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_digest</name>
      <anchorfile>classGlib_1_1Checksum.html</anchorfile>
      <anchor>a2dab438a05d0c74f25daea6c19af8f30</anchor>
      <arglist>(guint8 *buffer, gsize *digest_len) const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_string</name>
      <anchorfile>classGlib_1_1Checksum.html</anchorfile>
      <anchor>a139a8bb447bb6617ffd0b3a2ef38808b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static std::string</type>
      <name>compute_checksum</name>
      <anchorfile>classGlib_1_1Checksum.html</anchorfile>
      <anchor>a902b8dade7ce569804fa1819aaaa04d0</anchor>
      <arglist>(ChecksumType type, const guchar *data, gsize length)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static std::string</type>
      <name>compute_checksum</name>
      <anchorfile>classGlib_1_1Checksum.html</anchorfile>
      <anchor>a2c6508c0d2191d0e6ce4498457763f49</anchor>
      <arglist>(ChecksumType type, const std::string &amp;str)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static gssize</type>
      <name>get_length</name>
      <anchorfile>classGlib_1_1Checksum.html</anchorfile>
      <anchor>a2f288fe9e08a7ac4e4f81a6e1a957606</anchor>
      <arglist>(ChecksumType checksum_type)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>GChecksum *</type>
      <name>gobject_</name>
      <anchorfile>classGlib_1_1Checksum.html</anchorfile>
      <anchor>a7f5c4a8761c07e1062a8cb47d0b047b3</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>Glib::Checksum</type>
      <name>wrap</name>
      <anchorfile>classGlib_1_1Checksum.html</anchorfile>
      <anchor>aede26bdadd5441f327f6b36ce9a9fbf1</anchor>
      <arglist>(GChecksum *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glib::ConvertError</name>
    <filename>classGlib_1_1ConvertError.html</filename>
    <base>Glib::Error</base>
    <member kind="enumeration">
      <name>Code</name>
      <anchorfile>classGlib_1_1ConvertError.html</anchorfile>
      <anchor>aea4b79ac3149c1fcfcab32155e3561a9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NO_CONVERSION</name>
      <anchorfile>classGlib_1_1ConvertError.html</anchorfile>
      <anchor>aea4b79ac3149c1fcfcab32155e3561a9a8f2c0837cb3d39247edde4926ff34a74</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ILLEGAL_SEQUENCE</name>
      <anchorfile>classGlib_1_1ConvertError.html</anchorfile>
      <anchor>aea4b79ac3149c1fcfcab32155e3561a9a335a4cb227118026dd0c25661f294d10</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FAILED</name>
      <anchorfile>classGlib_1_1ConvertError.html</anchorfile>
      <anchor>aea4b79ac3149c1fcfcab32155e3561a9a6c5415ccb53faa02252bad81b7b5fc38</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PARTIAL_INPUT</name>
      <anchorfile>classGlib_1_1ConvertError.html</anchorfile>
      <anchor>aea4b79ac3149c1fcfcab32155e3561a9a0be7db7936eec0a931279e290e4b7635</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>BAD_URI</name>
      <anchorfile>classGlib_1_1ConvertError.html</anchorfile>
      <anchor>aea4b79ac3149c1fcfcab32155e3561a9a9f0c06afb8e2258f079faf99807c816d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NOT_ABSOLUTE_PATH</name>
      <anchorfile>classGlib_1_1ConvertError.html</anchorfile>
      <anchor>aea4b79ac3149c1fcfcab32155e3561a9a44f6211a4a40cd76eb56cd962a981c31</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>ConvertError</name>
      <anchorfile>classGlib_1_1ConvertError.html</anchorfile>
      <anchor>a99da762bafb432b501a9adaa378e48e1</anchor>
      <arglist>(Code error_code, const Glib::ustring &amp;error_message)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>ConvertError</name>
      <anchorfile>classGlib_1_1ConvertError.html</anchorfile>
      <anchor>a1f91f82109b547d84c67b1e6e4abc863</anchor>
      <arglist>(GError *gobject)</arglist>
    </member>
    <member kind="function">
      <type>Code</type>
      <name>code</name>
      <anchorfile>classGlib_1_1ConvertError.html</anchorfile>
      <anchor>a337140841bdec147d1e26406b566ebd1</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glib::IConv</name>
    <filename>classGlib_1_1IConv.html</filename>
    <member kind="function">
      <type></type>
      <name>IConv</name>
      <anchorfile>classGlib_1_1IConv.html</anchorfile>
      <anchor>abb841f9db0731eb8cbc4ea2a8a5d23d5</anchor>
      <arglist>(const std::string &amp;to_codeset, const std::string &amp;from_codeset)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>IConv</name>
      <anchorfile>classGlib_1_1IConv.html</anchorfile>
      <anchor>ad2722879e0465fec5d9f2c126a602557</anchor>
      <arglist>(GIConv gobject)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~IConv</name>
      <anchorfile>classGlib_1_1IConv.html</anchorfile>
      <anchor>ab56fc0ef68a7f7fee554728a16c6cba0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>size_t</type>
      <name>iconv</name>
      <anchorfile>classGlib_1_1IConv.html</anchorfile>
      <anchor>a15b01bcbafa643bb7c748bfe0048cb82</anchor>
      <arglist>(char **inbuf, gsize *inbytes_left, char **outbuf, gsize *outbytes_left)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>reset</name>
      <anchorfile>classGlib_1_1IConv.html</anchorfile>
      <anchor>ab0655474f54dd933d3f6959bdafffabe</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>convert</name>
      <anchorfile>classGlib_1_1IConv.html</anchorfile>
      <anchor>a82af42360f040532ebd4b215dc89a59d</anchor>
      <arglist>(const std::string &amp;str)</arglist>
    </member>
    <member kind="function">
      <type>GIConv</type>
      <name>gobj</name>
      <anchorfile>classGlib_1_1IConv.html</anchorfile>
      <anchor>a12a8c09489388d1efcf9b70586307614</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glib::Date</name>
    <filename>classGlib_1_1Date.html</filename>
    <member kind="enumeration">
      <name>Month</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga9781abc52ad49766808898743e44031f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>BAD_MONTH</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga9781abc52ad49766808898743e44031fa3c180cbd1a72ac6c1193374f07478043</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>JANUARY</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga9781abc52ad49766808898743e44031fadcae78391f0081dd887dbd5c62ce9e18</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FEBRUARY</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga9781abc52ad49766808898743e44031fafbb90abf68464b8e14a764cef1ced1e1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MARCH</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga9781abc52ad49766808898743e44031faaf1909bbb4cbf9a02db828ab35e52ce3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>APRIL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga9781abc52ad49766808898743e44031fa879774f2eee3f8807bbd8e3c25e3c5b2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MAY</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga9781abc52ad49766808898743e44031fa9da639bcfe895324daded17f4600116b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>JUNE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga9781abc52ad49766808898743e44031faaab22ac997e15a34995118694f8cbd2d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>JULY</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga9781abc52ad49766808898743e44031fae6d2bfb5bd12aace37808b1f5fe53afb</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>AUGUST</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga9781abc52ad49766808898743e44031fa846063b97ea9c5dd82cae8718bb75df1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SEPTEMBER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga9781abc52ad49766808898743e44031faa7e563e8689c07fac8f60f9f68f6cebb</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>OCTOBER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga9781abc52ad49766808898743e44031fa3c5a2a9a7bfcc9b7cbd57b89856c4989</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NOVEMBER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga9781abc52ad49766808898743e44031fac21038623ac787c4c94010d2334f6c8a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DECEMBER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga9781abc52ad49766808898743e44031fa2aed3776c7cb74418206e52677f394c7</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>Weekday</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga073c9f49a289b2036eb226bcdf16a2f1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>BAD_WEEKDAY</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga073c9f49a289b2036eb226bcdf16a2f1a0b852cafa7e3b36f3b87c8acd796be89</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MONDAY</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga073c9f49a289b2036eb226bcdf16a2f1ac75c38cdbe0d1a25346de7d5a1919f12</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TUESDAY</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga073c9f49a289b2036eb226bcdf16a2f1a3f573dae7a781f9f380b0adecdc068fc</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>WEDNESDAY</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga073c9f49a289b2036eb226bcdf16a2f1ab91831a000325a1ad3dd881f0db708e0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>THURSDAY</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga073c9f49a289b2036eb226bcdf16a2f1ac2be9a407f81cac5ef82ec308aa23cc9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FRIDAY</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga073c9f49a289b2036eb226bcdf16a2f1ad86f5fb6fa5f0f99e8f6980d5d78ceae</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SATURDAY</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga073c9f49a289b2036eb226bcdf16a2f1aa8703e1dd1d78272012d603e8ded6807</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SUNDAY</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga073c9f49a289b2036eb226bcdf16a2f1ac0ae61753cd0be03a4cee4ff0b209fb4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>DMY</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gac803072d86bbc2ce1f7d558c94f41ae1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DAY</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggac803072d86bbc2ce1f7d558c94f41ae1a340ad04532a2d66518f8eefdf1ac1b27</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MONTH</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggac803072d86bbc2ce1f7d558c94f41ae1a9da8611c47d68fe95d9026cf162bb350</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>YEAR</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggac803072d86bbc2ce1f7d558c94f41ae1a8eec7a614a99a9640e578862c13b5682</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>guint8</type>
      <name>Day</name>
      <anchorfile>classGlib_1_1Date.html</anchorfile>
      <anchor>a217c209f5b937185e730455aed95c4fa</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>guint16</type>
      <name>Year</name>
      <anchorfile>classGlib_1_1Date.html</anchorfile>
      <anchor>aa308aa855887d94a371adddfc23353c7</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Date</name>
      <anchorfile>classGlib_1_1Date.html</anchorfile>
      <anchor>addae9bb3e6075f950f548178289d31f3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Date</name>
      <anchorfile>classGlib_1_1Date.html</anchorfile>
      <anchor>a23300306fa973791ba6effc8757ac98d</anchor>
      <arglist>(Day day, Month month, Year year)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Date</name>
      <anchorfile>classGlib_1_1Date.html</anchorfile>
      <anchor>a04f4564ec663684b7062152ca56f5677</anchor>
      <arglist>(guint32 julian_day)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Date</name>
      <anchorfile>classGlib_1_1Date.html</anchorfile>
      <anchor>a42ea48c26d515c1206704915b71b5076</anchor>
      <arglist>(const GDate &amp;castitem)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Date</name>
      <anchorfile>classGlib_1_1Date.html</anchorfile>
      <anchor>a0ac5c4a615593ca72f6f0600ad678974</anchor>
      <arglist>(const Date &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>Date &amp;</type>
      <name>operator=</name>
      <anchorfile>classGlib_1_1Date.html</anchorfile>
      <anchor>ac51254df32aab40dd14cd7f9f8d8a3ac</anchor>
      <arglist>(const Date &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>GDate *</type>
      <name>gobj</name>
      <anchorfile>classGlib_1_1Date.html</anchorfile>
      <anchor>a4df664ef8c919b45dafaf1f666635ad8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GDate *</type>
      <name>gobj</name>
      <anchorfile>classGlib_1_1Date.html</anchorfile>
      <anchor>a38645890f6a00996a1590902616a4134</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>clear</name>
      <anchorfile>classGlib_1_1Date.html</anchorfile>
      <anchor>a5e0612d9073939b783b6fffea9b66709</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_parse</name>
      <anchorfile>classGlib_1_1Date.html</anchorfile>
      <anchor>a6bd2cb5903074d5d99d8640d96e84ebb</anchor>
      <arglist>(const Glib::ustring &amp;str)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_time</name>
      <anchorfile>classGlib_1_1Date.html</anchorfile>
      <anchor>a258e962376849e680005ad476b901737</anchor>
      <arglist>(time_t timet)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_time</name>
      <anchorfile>classGlib_1_1Date.html</anchorfile>
      <anchor>ab4bf594a78cd4270960c70705ec48328</anchor>
      <arglist>(const GTimeVal &amp;timeval)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_time_current</name>
      <anchorfile>classGlib_1_1Date.html</anchorfile>
      <anchor>a094ddd3269d18d76077471647406742c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_month</name>
      <anchorfile>classGlib_1_1Date.html</anchorfile>
      <anchor>a0e64dc591b387cc4847bfe62f71ced5c</anchor>
      <arglist>(Month month)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_day</name>
      <anchorfile>classGlib_1_1Date.html</anchorfile>
      <anchor>a1caed2e61aa1f492cb0e0f9dc28ff9e8</anchor>
      <arglist>(Day day)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_year</name>
      <anchorfile>classGlib_1_1Date.html</anchorfile>
      <anchor>a207373a135e2b93be1f88b949d468ba8</anchor>
      <arglist>(Year year)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_dmy</name>
      <anchorfile>classGlib_1_1Date.html</anchorfile>
      <anchor>a83e9f483203116684bd59d7a2457605c</anchor>
      <arglist>(Day day, Month month, Year year)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_julian</name>
      <anchorfile>classGlib_1_1Date.html</anchorfile>
      <anchor>a3991f6de084bb84de962b81316b6323e</anchor>
      <arglist>(guint32 julian_day)</arglist>
    </member>
    <member kind="function">
      <type>Date &amp;</type>
      <name>add_days</name>
      <anchorfile>classGlib_1_1Date.html</anchorfile>
      <anchor>a47cdaca7f0a4fb99f21ca6f2c5f6b609</anchor>
      <arglist>(int n_days)</arglist>
    </member>
    <member kind="function">
      <type>Date &amp;</type>
      <name>subtract_days</name>
      <anchorfile>classGlib_1_1Date.html</anchorfile>
      <anchor>aa811f0a4a953a9bd8e6623324a61a09a</anchor>
      <arglist>(int n_days)</arglist>
    </member>
    <member kind="function">
      <type>Date &amp;</type>
      <name>add_months</name>
      <anchorfile>classGlib_1_1Date.html</anchorfile>
      <anchor>a58c7a4bccf502bb9a9b10b1079a803ae</anchor>
      <arglist>(int n_months)</arglist>
    </member>
    <member kind="function">
      <type>Date &amp;</type>
      <name>subtract_months</name>
      <anchorfile>classGlib_1_1Date.html</anchorfile>
      <anchor>a543992d17cac03b125bcd2e5dbcbbcbf</anchor>
      <arglist>(int n_months)</arglist>
    </member>
    <member kind="function">
      <type>Date &amp;</type>
      <name>add_years</name>
      <anchorfile>classGlib_1_1Date.html</anchorfile>
      <anchor>a1ea49facb5ec94dbd6b22916da2616b4</anchor>
      <arglist>(int n_years)</arglist>
    </member>
    <member kind="function">
      <type>Date &amp;</type>
      <name>subtract_years</name>
      <anchorfile>classGlib_1_1Date.html</anchorfile>
      <anchor>ac06467e6b8d11f2cb6862142503e51af</anchor>
      <arglist>(int n_years)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>days_between</name>
      <anchorfile>classGlib_1_1Date.html</anchorfile>
      <anchor>a4fdbe0b37d9d8079919aa4921c781e5f</anchor>
      <arglist>(const Date &amp;rhs) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>compare</name>
      <anchorfile>classGlib_1_1Date.html</anchorfile>
      <anchor>a5961d351f9a2d3c924121b72bba9d88c</anchor>
      <arglist>(const Date &amp;rhs) const </arglist>
    </member>
    <member kind="function">
      <type>Date &amp;</type>
      <name>clamp</name>
      <anchorfile>classGlib_1_1Date.html</anchorfile>
      <anchor>aeaf508be8686588e138ea33c1f193c84</anchor>
      <arglist>(const Date &amp;min_date, const Date &amp;max_date)</arglist>
    </member>
    <member kind="function">
      <type>Date &amp;</type>
      <name>clamp_min</name>
      <anchorfile>classGlib_1_1Date.html</anchorfile>
      <anchor>a0d54f26f46455523492785048c0e8f11</anchor>
      <arglist>(const Date &amp;min_date)</arglist>
    </member>
    <member kind="function">
      <type>Date &amp;</type>
      <name>clamp_max</name>
      <anchorfile>classGlib_1_1Date.html</anchorfile>
      <anchor>a88f3580d08fcd5a6f78247386a81cab9</anchor>
      <arglist>(const Date &amp;max_date)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>order</name>
      <anchorfile>classGlib_1_1Date.html</anchorfile>
      <anchor>aa16d41a82334d8d83fb6dfbcedfc8214</anchor>
      <arglist>(Date &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>Weekday</type>
      <name>get_weekday</name>
      <anchorfile>classGlib_1_1Date.html</anchorfile>
      <anchor>adf8015784a264eaf9979f637dc109fbd</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Month</type>
      <name>get_month</name>
      <anchorfile>classGlib_1_1Date.html</anchorfile>
      <anchor>afcf98de21518e239368595bcb6eb467c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Year</type>
      <name>get_year</name>
      <anchorfile>classGlib_1_1Date.html</anchorfile>
      <anchor>a91e31618fdf40a89a0840013f74ca1cf</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Day</type>
      <name>get_day</name>
      <anchorfile>classGlib_1_1Date.html</anchorfile>
      <anchor>abb2790c552325e23523382dcc0b08a43</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>guint32</type>
      <name>get_julian</name>
      <anchorfile>classGlib_1_1Date.html</anchorfile>
      <anchor>aa2f8e64c2eab4380a0477095e9765809</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>unsigned int</type>
      <name>get_day_of_year</name>
      <anchorfile>classGlib_1_1Date.html</anchorfile>
      <anchor>abe65f54c4e39c48b9834e6195e65de4a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>unsigned int</type>
      <name>get_monday_week_of_year</name>
      <anchorfile>classGlib_1_1Date.html</anchorfile>
      <anchor>a5bb09d3eaeb81d5015d34321e2bdf7ed</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>unsigned int</type>
      <name>get_sunday_week_of_year</name>
      <anchorfile>classGlib_1_1Date.html</anchorfile>
      <anchor>a2fe45b46e0327ef8d65abd5539249d47</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>unsigned int</type>
      <name>get_iso8601_week_of_year</name>
      <anchorfile>classGlib_1_1Date.html</anchorfile>
      <anchor>af0add3ab3f88625e9b78eb4c648641ac</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_first_of_month</name>
      <anchorfile>classGlib_1_1Date.html</anchorfile>
      <anchor>a11fd435a1f2012324db453adff6a0450</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_last_of_month</name>
      <anchorfile>classGlib_1_1Date.html</anchorfile>
      <anchor>a7048990efde0b7e67e8bb73c6af8735e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>format_string</name>
      <anchorfile>classGlib_1_1Date.html</anchorfile>
      <anchor>a0b9a299ad1d7ba986b67adeeb5e35d91</anchor>
      <arglist>(const Glib::ustring &amp;format) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>to_struct_tm</name>
      <anchorfile>classGlib_1_1Date.html</anchorfile>
      <anchor>ac2f8feb4d819e6af421e6c5bb4ea2321</anchor>
      <arglist>(struct tm &amp;dest) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>valid</name>
      <anchorfile>classGlib_1_1Date.html</anchorfile>
      <anchor>aa716c3239e93a3e557a2e3349e12eb83</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static guint8</type>
      <name>get_days_in_month</name>
      <anchorfile>classGlib_1_1Date.html</anchorfile>
      <anchor>ac730164dfaafc48786e550a7d94831ce</anchor>
      <arglist>(Month month, Year year)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static guint8</type>
      <name>get_monday_weeks_in_year</name>
      <anchorfile>classGlib_1_1Date.html</anchorfile>
      <anchor>a2c9cb463927b05d4632dca5da920542f</anchor>
      <arglist>(Year year)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static guint8</type>
      <name>get_sunday_weeks_in_year</name>
      <anchorfile>classGlib_1_1Date.html</anchorfile>
      <anchor>ab670892479ab8b08a9523d14fbafef2d</anchor>
      <arglist>(Year year)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static bool</type>
      <name>is_leap_year</name>
      <anchorfile>classGlib_1_1Date.html</anchorfile>
      <anchor>a625818601b8b04e016b998ebd58294f1</anchor>
      <arglist>(Year year)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static bool</type>
      <name>valid_day</name>
      <anchorfile>classGlib_1_1Date.html</anchorfile>
      <anchor>a409a3205d2f1e138b88df36fe0d8b1a2</anchor>
      <arglist>(Day day)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static bool</type>
      <name>valid_month</name>
      <anchorfile>classGlib_1_1Date.html</anchorfile>
      <anchor>aee1b51e0602590b7bbebd404ed72bbca</anchor>
      <arglist>(Month month)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static bool</type>
      <name>valid_year</name>
      <anchorfile>classGlib_1_1Date.html</anchorfile>
      <anchor>a7ebb66795ecaa06a721d851451fc73ff</anchor>
      <arglist>(Year year)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static bool</type>
      <name>valid_weekday</name>
      <anchorfile>classGlib_1_1Date.html</anchorfile>
      <anchor>a72f37e25f74705d8b7f735b0b8aed5cd</anchor>
      <arglist>(Weekday weekday)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static bool</type>
      <name>valid_julian</name>
      <anchorfile>classGlib_1_1Date.html</anchorfile>
      <anchor>a7b94ac5b14f4051054897c07cbb86656</anchor>
      <arglist>(guint32 julian_day)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static bool</type>
      <name>valid_dmy</name>
      <anchorfile>classGlib_1_1Date.html</anchorfile>
      <anchor>acae6854623e46d783a0e19a5952871d1</anchor>
      <arglist>(Day day, Month month, Year year)</arglist>
    </member>
    <member kind="variable" static="yes">
      <type>static const Day</type>
      <name>BAD_DAY</name>
      <anchorfile>classGlib_1_1Date.html</anchorfile>
      <anchor>af6341bae69196cb5099f1133b2225b53</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>static const Year</type>
      <name>BAD_YEAR</name>
      <anchorfile>classGlib_1_1Date.html</anchorfile>
      <anchor>a836394324fc168ffac64734f7930b548</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>static const guint32</type>
      <name>BAD_JULIAN</name>
      <anchorfile>classGlib_1_1Date.html</anchorfile>
      <anchor>a2b4f287c712949a7dbd7ca61f0098531</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>classGlib_1_1Date.html</anchorfile>
      <anchor>ad12683e4457513f4f834e13c4e7f72f8</anchor>
      <arglist>(const Date &amp;lhs, const Date &amp;rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;</name>
      <anchorfile>classGlib_1_1Date.html</anchorfile>
      <anchor>a4e4faf476e7d66ef88aaca8b11a60175</anchor>
      <arglist>(const Date &amp;lhs, const Date &amp;rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;=</name>
      <anchorfile>classGlib_1_1Date.html</anchorfile>
      <anchor>acacb699d0fcffd2443c121586b7c22da</anchor>
      <arglist>(const Date &amp;lhs, const Date &amp;rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;=</name>
      <anchorfile>classGlib_1_1Date.html</anchorfile>
      <anchor>aa72d3f6e17c7aab4d16e9e50b5069e1a</anchor>
      <arglist>(const Date &amp;lhs, const Date &amp;rhs)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glib::FileError</name>
    <filename>classGlib_1_1FileError.html</filename>
    <base>Glib::Error</base>
    <member kind="enumeration">
      <name>Code</name>
      <anchorfile>classGlib_1_1FileError.html</anchorfile>
      <anchor>a0bdb855c813c7d07a424009706fc8f0b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EXISTS</name>
      <anchorfile>classGlib_1_1FileError.html</anchorfile>
      <anchor>a0bdb855c813c7d07a424009706fc8f0ba01ff8868a0b220c86c9324c99d3cd4fe</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IS_DIRECTORY</name>
      <anchorfile>classGlib_1_1FileError.html</anchorfile>
      <anchor>a0bdb855c813c7d07a424009706fc8f0baff115ce7e218cc5a4aae85ec8890ab94</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ACCESS_DENIED</name>
      <anchorfile>classGlib_1_1FileError.html</anchorfile>
      <anchor>a0bdb855c813c7d07a424009706fc8f0baa2e3135e38ebcc80a494528091ebd8de</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NAME_TOO_LONG</name>
      <anchorfile>classGlib_1_1FileError.html</anchorfile>
      <anchor>a0bdb855c813c7d07a424009706fc8f0ba8643f49fdab6a5ff782084c67135e1e1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NO_SUCH_ENTITY</name>
      <anchorfile>classGlib_1_1FileError.html</anchorfile>
      <anchor>a0bdb855c813c7d07a424009706fc8f0baeda2e83b22b1f6dc1da2694f1644e564</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NOT_DIRECTORY</name>
      <anchorfile>classGlib_1_1FileError.html</anchorfile>
      <anchor>a0bdb855c813c7d07a424009706fc8f0baa4f3b9115752cd9cf52a5b59f8909991</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NO_SUCH_DEVICE</name>
      <anchorfile>classGlib_1_1FileError.html</anchorfile>
      <anchor>a0bdb855c813c7d07a424009706fc8f0babb6c725bc086a2d279e757457b030571</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NOT_DEVICE</name>
      <anchorfile>classGlib_1_1FileError.html</anchorfile>
      <anchor>a0bdb855c813c7d07a424009706fc8f0badd3c96afe2ba945bb3560e16a9b93d59</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>READONLY_FILESYSTEM</name>
      <anchorfile>classGlib_1_1FileError.html</anchorfile>
      <anchor>a0bdb855c813c7d07a424009706fc8f0babeea9fce53d4885b4051984276f15a8b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TEXT_FILE_BUSY</name>
      <anchorfile>classGlib_1_1FileError.html</anchorfile>
      <anchor>a0bdb855c813c7d07a424009706fc8f0ba7e4dc1f2fd34848b7bc3000c272e1372</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FAULTY_ADDRESS</name>
      <anchorfile>classGlib_1_1FileError.html</anchorfile>
      <anchor>a0bdb855c813c7d07a424009706fc8f0badc06f883f118f4890129663191c6c17f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SYMLINK_LOOP</name>
      <anchorfile>classGlib_1_1FileError.html</anchorfile>
      <anchor>a0bdb855c813c7d07a424009706fc8f0ba162e633cd38eab5d522270c9a3ebcea2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NO_SPACE_LEFT</name>
      <anchorfile>classGlib_1_1FileError.html</anchorfile>
      <anchor>a0bdb855c813c7d07a424009706fc8f0bab01ef9f764fd9b893ce8642c41e767d8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NOT_ENOUGH_MEMORY</name>
      <anchorfile>classGlib_1_1FileError.html</anchorfile>
      <anchor>a0bdb855c813c7d07a424009706fc8f0ba370079127964629a1632d9ddb9e1675e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TOO_MANY_OPEN_FILES</name>
      <anchorfile>classGlib_1_1FileError.html</anchorfile>
      <anchor>a0bdb855c813c7d07a424009706fc8f0bae6695b16a229d85ed7fe04998ded8e69</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_TABLE_OVERFLOW</name>
      <anchorfile>classGlib_1_1FileError.html</anchorfile>
      <anchor>a0bdb855c813c7d07a424009706fc8f0ba270fd5509672b5315c89ba895cf0a03b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>BAD_FILE_DESCRIPTOR</name>
      <anchorfile>classGlib_1_1FileError.html</anchorfile>
      <anchor>a0bdb855c813c7d07a424009706fc8f0ba4fc249f01958f2637485f137984a2ef5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>INVALID_ARGUMENT</name>
      <anchorfile>classGlib_1_1FileError.html</anchorfile>
      <anchor>a0bdb855c813c7d07a424009706fc8f0ba9c342ad59c861942248c7c4f9856ffa3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>BROKEN_PIPE</name>
      <anchorfile>classGlib_1_1FileError.html</anchorfile>
      <anchor>a0bdb855c813c7d07a424009706fc8f0ba7973f973a753e33f7334606a7b94a484</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TRYAGAIN</name>
      <anchorfile>classGlib_1_1FileError.html</anchorfile>
      <anchor>a0bdb855c813c7d07a424009706fc8f0ba394d8e382562d6a1d98eeb324f7bb3ef</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>INTERRUPTED</name>
      <anchorfile>classGlib_1_1FileError.html</anchorfile>
      <anchor>a0bdb855c813c7d07a424009706fc8f0badddd41967fb43bd5299d7ca081e1fb2f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERROR</name>
      <anchorfile>classGlib_1_1FileError.html</anchorfile>
      <anchor>a0bdb855c813c7d07a424009706fc8f0ba9f036a8ebefce2b3e4d6212a81391f41</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NOT_OWNER</name>
      <anchorfile>classGlib_1_1FileError.html</anchorfile>
      <anchor>a0bdb855c813c7d07a424009706fc8f0baa10eb3f9c67a9d359927839c800e9d62</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NOSYS</name>
      <anchorfile>classGlib_1_1FileError.html</anchorfile>
      <anchor>a0bdb855c813c7d07a424009706fc8f0ba35c967e08b486a0e88197f5753d2df1a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FAILED</name>
      <anchorfile>classGlib_1_1FileError.html</anchorfile>
      <anchor>a0bdb855c813c7d07a424009706fc8f0ba1ff00bae55bf88a6bd4f5c70b78324b9</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>FileError</name>
      <anchorfile>classGlib_1_1FileError.html</anchorfile>
      <anchor>a0acf54ad7899f15d9dba10a42e551181</anchor>
      <arglist>(Code error_code, const Glib::ustring &amp;error_message)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>FileError</name>
      <anchorfile>classGlib_1_1FileError.html</anchorfile>
      <anchor>adc1bae15e4393814b23e7f0743a081cc</anchor>
      <arglist>(GError *gobject)</arglist>
    </member>
    <member kind="function">
      <type>Code</type>
      <name>code</name>
      <anchorfile>classGlib_1_1FileError.html</anchorfile>
      <anchor>a86041a573547b3b349ba0acf2bac7116</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glib::DirIterator</name>
    <filename>classGlib_1_1DirIterator.html</filename>
    <member kind="typedef">
      <type>std::input_iterator_tag</type>
      <name>iterator_category</name>
      <anchorfile>classGlib_1_1DirIterator.html</anchorfile>
      <anchor>a67db7ca7ce5696fe900df4f8428b2f67</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>std::string</type>
      <name>value_type</name>
      <anchorfile>classGlib_1_1DirIterator.html</anchorfile>
      <anchor>a596bae950cfcfbb815029929b9394bae</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>int</type>
      <name>difference_type</name>
      <anchorfile>classGlib_1_1DirIterator.html</anchorfile>
      <anchor>aea087419248faa8fc677d88f6cac928e</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>value_type</type>
      <name>reference</name>
      <anchorfile>classGlib_1_1DirIterator.html</anchorfile>
      <anchor>aaa1742565a52c5f7facc17f90f0680fb</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>void</type>
      <name>pointer</name>
      <anchorfile>classGlib_1_1DirIterator.html</anchorfile>
      <anchor>a40edc6b0e3915f39a58f068ae3246de9</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>DirIterator</name>
      <anchorfile>classGlib_1_1DirIterator.html</anchorfile>
      <anchor>a39fe47295f912691d1ba9e04fc4c6854</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>operator*</name>
      <anchorfile>classGlib_1_1DirIterator.html</anchorfile>
      <anchor>a58e96c2c6e629c1cbf285fe9e6b82502</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>DirIterator &amp;</type>
      <name>operator++</name>
      <anchorfile>classGlib_1_1DirIterator.html</anchorfile>
      <anchor>a094d89e945942a29635cbb5e065a8f41</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>operator++</name>
      <anchorfile>classGlib_1_1DirIterator.html</anchorfile>
      <anchor>a369cb93241e49b7aa1229848e88c3f15</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>classGlib_1_1DirIterator.html</anchorfile>
      <anchor>afcb6c09b21dc948643431c9118b9b714</anchor>
      <arglist>(const DirIterator &amp;rhs) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>classGlib_1_1DirIterator.html</anchorfile>
      <anchor>a29757be47b42f28e2c9a95b35a8cca3e</anchor>
      <arglist>(const DirIterator &amp;rhs) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glib::Dir</name>
    <filename>classGlib_1_1Dir.html</filename>
    <member kind="typedef">
      <type>DirIterator</type>
      <name>iterator</name>
      <anchorfile>classGlib_1_1Dir.html</anchorfile>
      <anchor>a47896460e9d37efc9e93af33e0d1ccf3</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>DirIterator</type>
      <name>const_iterator</name>
      <anchorfile>classGlib_1_1Dir.html</anchorfile>
      <anchor>a87555a3d202abc6535c0479378289c65</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Dir</name>
      <anchorfile>classGlib_1_1Dir.html</anchorfile>
      <anchor>abbcedb96cc9cf9cdfa37ab7164631fe9</anchor>
      <arglist>(const std::string &amp;path)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~Dir</name>
      <anchorfile>classGlib_1_1Dir.html</anchorfile>
      <anchor>a8de43168d60f9ffc12842b6d277834de</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>read_name</name>
      <anchorfile>classGlib_1_1Dir.html</anchorfile>
      <anchor>a0b7540337a31b10b5dd5775a46ff2f43</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>rewind</name>
      <anchorfile>classGlib_1_1Dir.html</anchorfile>
      <anchor>a13bc8d04aef36e4c77eb05710096ab26</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>close</name>
      <anchorfile>classGlib_1_1Dir.html</anchorfile>
      <anchor>a9d648d71ee0ac37f57b478f8d43a3bf9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>DirIterator</type>
      <name>begin</name>
      <anchorfile>classGlib_1_1Dir.html</anchorfile>
      <anchor>ae5b5900d5f7838b2437f36609c30d7ca</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>DirIterator</type>
      <name>end</name>
      <anchorfile>classGlib_1_1Dir.html</anchorfile>
      <anchor>aded8f8cb05e1aed5fb445569c44fff68</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glib::IOChannelError</name>
    <filename>classGlib_1_1IOChannelError.html</filename>
    <base>Glib::Error</base>
    <member kind="enumeration">
      <name>Code</name>
      <anchorfile>classGlib_1_1IOChannelError.html</anchorfile>
      <anchor>a8b02e9d69e0b5bb5455009c5929dbb03</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_TOO_BIG</name>
      <anchorfile>classGlib_1_1IOChannelError.html</anchorfile>
      <anchor>a8b02e9d69e0b5bb5455009c5929dbb03a9c5ed72205f48bdfdd06a7d9ced2da29</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>INVALID_ARGUMENT</name>
      <anchorfile>classGlib_1_1IOChannelError.html</anchorfile>
      <anchor>a8b02e9d69e0b5bb5455009c5929dbb03a1875c359005272d43ad2b611d73beec4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERROR</name>
      <anchorfile>classGlib_1_1IOChannelError.html</anchorfile>
      <anchor>a8b02e9d69e0b5bb5455009c5929dbb03a8ec5114383862e8cac043ec2075ad116</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IS_DIRECTORY</name>
      <anchorfile>classGlib_1_1IOChannelError.html</anchorfile>
      <anchor>a8b02e9d69e0b5bb5455009c5929dbb03aa0144b7fc1c2ddf9643b9e9f3f8ddf86</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NO_SPACE_LEFT</name>
      <anchorfile>classGlib_1_1IOChannelError.html</anchorfile>
      <anchor>a8b02e9d69e0b5bb5455009c5929dbb03a5dc764550200132f93026027c7c2f09a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NO_SUCH_DEVICE</name>
      <anchorfile>classGlib_1_1IOChannelError.html</anchorfile>
      <anchor>a8b02e9d69e0b5bb5455009c5929dbb03a4820ff376a2779d8d1d3ccea6137fcd5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>OVERFLOWN</name>
      <anchorfile>classGlib_1_1IOChannelError.html</anchorfile>
      <anchor>a8b02e9d69e0b5bb5455009c5929dbb03a64d5418a7200604cbf563cac1cf46de2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>BROKEN_PIPE</name>
      <anchorfile>classGlib_1_1IOChannelError.html</anchorfile>
      <anchor>a8b02e9d69e0b5bb5455009c5929dbb03a3112ffb043ecf58835762eb3d8204edb</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FAILED</name>
      <anchorfile>classGlib_1_1IOChannelError.html</anchorfile>
      <anchor>a8b02e9d69e0b5bb5455009c5929dbb03a5c504b82d394ef2594f13128fff403a3</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>IOChannelError</name>
      <anchorfile>classGlib_1_1IOChannelError.html</anchorfile>
      <anchor>ae1314f05ecea3220020d19b2823f545f</anchor>
      <arglist>(Code error_code, const Glib::ustring &amp;error_message)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>IOChannelError</name>
      <anchorfile>classGlib_1_1IOChannelError.html</anchorfile>
      <anchor>ab78f3d7ead385cf0ab1738686028c10d</anchor>
      <arglist>(GError *gobject)</arglist>
    </member>
    <member kind="function">
      <type>Code</type>
      <name>code</name>
      <anchorfile>classGlib_1_1IOChannelError.html</anchorfile>
      <anchor>ae3f6615b23b1cb01e2cfdf7deceecd7b</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glib::IOChannel</name>
    <filename>classGlib_1_1IOChannel.html</filename>
    <base>sigc::trackable</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~IOChannel</name>
      <anchorfile>classGlib_1_1IOChannel.html</anchorfile>
      <anchor>a0a6c1cddcf00c77c6ab99b096c86544f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>IOStatus</type>
      <name>read</name>
      <anchorfile>classGlib_1_1IOChannel.html</anchorfile>
      <anchor>ae5878a4510f52f194f18c0743f6a9b5c</anchor>
      <arglist>(gunichar &amp;thechar)</arglist>
    </member>
    <member kind="function">
      <type>IOStatus</type>
      <name>read</name>
      <anchorfile>classGlib_1_1IOChannel.html</anchorfile>
      <anchor>a1afb78d2e29a2f01a7034279a0c12636</anchor>
      <arglist>(char *buf, gsize count, gsize &amp;bytes_read)</arglist>
    </member>
    <member kind="function">
      <type>IOStatus</type>
      <name>read</name>
      <anchorfile>classGlib_1_1IOChannel.html</anchorfile>
      <anchor>a4553088deea02ebea2ab7a9e2cff0a1c</anchor>
      <arglist>(Glib::ustring &amp;str, gsize count)</arglist>
    </member>
    <member kind="function">
      <type>IOStatus</type>
      <name>read_line</name>
      <anchorfile>classGlib_1_1IOChannel.html</anchorfile>
      <anchor>a2950510fff168d5753ee1eb14714d67a</anchor>
      <arglist>(Glib::ustring &amp;line)</arglist>
    </member>
    <member kind="function">
      <type>IOStatus</type>
      <name>read_to_end</name>
      <anchorfile>classGlib_1_1IOChannel.html</anchorfile>
      <anchor>a0d64e84ab360b3c83399c94076487df1</anchor>
      <arglist>(Glib::ustring &amp;str)</arglist>
    </member>
    <member kind="function">
      <type>IOStatus</type>
      <name>write</name>
      <anchorfile>classGlib_1_1IOChannel.html</anchorfile>
      <anchor>acacb5599be21f549911c6aca5f820fcf</anchor>
      <arglist>(const Glib::ustring &amp;str)</arglist>
    </member>
    <member kind="function">
      <type>IOStatus</type>
      <name>write</name>
      <anchorfile>classGlib_1_1IOChannel.html</anchorfile>
      <anchor>a29114ed2bcb64b8af551271394968528</anchor>
      <arglist>(const char *buf, gssize count, gsize &amp;bytes_written)</arglist>
    </member>
    <member kind="function">
      <type>IOStatus</type>
      <name>write</name>
      <anchorfile>classGlib_1_1IOChannel.html</anchorfile>
      <anchor>a5e0a187ff012b3b90c6d3d8593c18e92</anchor>
      <arglist>(gunichar unichar)</arglist>
    </member>
    <member kind="function">
      <type>IOStatus</type>
      <name>seek</name>
      <anchorfile>classGlib_1_1IOChannel.html</anchorfile>
      <anchor>a65a5048c32ecde11827b5ae1973ee0b1</anchor>
      <arglist>(gint64 offset, SeekType type=SEEK_TYPE_SET)</arglist>
    </member>
    <member kind="function">
      <type>IOStatus</type>
      <name>flush</name>
      <anchorfile>classGlib_1_1IOChannel.html</anchorfile>
      <anchor>aba6702093bd1c58ea22231446ed2f6e4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>IOStatus</type>
      <name>close</name>
      <anchorfile>classGlib_1_1IOChannel.html</anchorfile>
      <anchor>a6affd4b4cbeeefe4965544f762922c35</anchor>
      <arglist>(bool flush=true)</arglist>
    </member>
    <member kind="function">
      <type>gsize</type>
      <name>get_buffer_size</name>
      <anchorfile>classGlib_1_1IOChannel.html</anchorfile>
      <anchor>a2f5c5979ad729df9524fcb1940e5d2fe</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_buffer_size</name>
      <anchorfile>classGlib_1_1IOChannel.html</anchorfile>
      <anchor>a535767c92f2678e5e72051f6f4bc5326</anchor>
      <arglist>(gsize size)</arglist>
    </member>
    <member kind="function">
      <type>IOFlags</type>
      <name>get_flags</name>
      <anchorfile>classGlib_1_1IOChannel.html</anchorfile>
      <anchor>ac15e424b863d398ed458315b7f799243</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>IOStatus</type>
      <name>set_flags</name>
      <anchorfile>classGlib_1_1IOChannel.html</anchorfile>
      <anchor>ab6c16c87c174d836247f47c2b87539fd</anchor>
      <arglist>(IOFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_buffered</name>
      <anchorfile>classGlib_1_1IOChannel.html</anchorfile>
      <anchor>abaf37b0d76cd41628fd0c41a674495de</anchor>
      <arglist>(bool buffered)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_buffered</name>
      <anchorfile>classGlib_1_1IOChannel.html</anchorfile>
      <anchor>a3013c245f30ca81e11c01f8a031b1745</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>IOCondition</type>
      <name>get_buffer_condition</name>
      <anchorfile>classGlib_1_1IOChannel.html</anchorfile>
      <anchor>a9ba943e998468e3b86d841c5aec8a551</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_close_on_unref</name>
      <anchorfile>classGlib_1_1IOChannel.html</anchorfile>
      <anchor>ac93b128c8ee396702b2a20c5a060949d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_close_on_unref</name>
      <anchorfile>classGlib_1_1IOChannel.html</anchorfile>
      <anchor>a3f4fbc2a4c3670863fbf504d7fc96253</anchor>
      <arglist>(bool do_close)</arglist>
    </member>
    <member kind="function">
      <type>IOStatus</type>
      <name>set_encoding</name>
      <anchorfile>classGlib_1_1IOChannel.html</anchorfile>
      <anchor>ab1d3ae667bd425ef830929a67cf526e0</anchor>
      <arglist>(const std::string &amp;encoding=std::string())</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_encoding</name>
      <anchorfile>classGlib_1_1IOChannel.html</anchorfile>
      <anchor>ae52a79ec5f3acc2b0990870668c4ea2a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_line_term</name>
      <anchorfile>classGlib_1_1IOChannel.html</anchorfile>
      <anchor>ad42d03bdd0288cf5517737a73f7268b3</anchor>
      <arglist>(const std::string &amp;term=std::string())</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_line_term</name>
      <anchorfile>classGlib_1_1IOChannel.html</anchorfile>
      <anchor>afd08e7a2a6cbfbdad2ef599c9eadcc01</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; IOSource &gt;</type>
      <name>create_watch</name>
      <anchorfile>classGlib_1_1IOChannel.html</anchorfile>
      <anchor>a755c88fe8c78dc0727b5686fc62b736c</anchor>
      <arglist>(IOCondition condition)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>reference</name>
      <anchorfile>classGlib_1_1IOChannel.html</anchorfile>
      <anchor>aa63e3a39347848387cd9422d0073a7be</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>unreference</name>
      <anchorfile>classGlib_1_1IOChannel.html</anchorfile>
      <anchor>a4c57bf6b00844fc3ddb9d0e60cac7dcf</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GIOChannel *</type>
      <name>gobj</name>
      <anchorfile>classGlib_1_1IOChannel.html</anchorfile>
      <anchor>ab05ed8535a51b04749e11386c845a581</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GIOChannel *</type>
      <name>gobj</name>
      <anchorfile>classGlib_1_1IOChannel.html</anchorfile>
      <anchor>aad550f12d9d2ec2fef0a2c7ba78f2595</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; IOChannel &gt;</type>
      <name>create_from_file</name>
      <anchorfile>classGlib_1_1IOChannel.html</anchorfile>
      <anchor>ac175ea1fd6ef84ac3758ca57b42b7f33</anchor>
      <arglist>(const std::string &amp;filename, const std::string &amp;mode)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; IOChannel &gt;</type>
      <name>create_from_fd</name>
      <anchorfile>classGlib_1_1IOChannel.html</anchorfile>
      <anchor>a078698e18f61bb75fe3fd33d82970f5d</anchor>
      <arglist>(int fd)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; IOChannel &gt;</type>
      <name>create_from_win32_fd</name>
      <anchorfile>classGlib_1_1IOChannel.html</anchorfile>
      <anchor>a1a22bd01752d233c23babdef800c0d87</anchor>
      <arglist>(int fd)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; IOChannel &gt;</type>
      <name>create_from_win32_socket</name>
      <anchorfile>classGlib_1_1IOChannel.html</anchorfile>
      <anchor>a087946554b86d42f1cd72277fd1b0530</anchor>
      <arglist>(int socket)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>IOChannel</name>
      <anchorfile>classGlib_1_1IOChannel.html</anchorfile>
      <anchor>aded3d9a998914bcac0b3f1aef1eeb974</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual IOStatus</type>
      <name>read_vfunc</name>
      <anchorfile>classGlib_1_1IOChannel.html</anchorfile>
      <anchor>abfb4faa07e80b86f21b0f18f0b8606cd</anchor>
      <arglist>(char *buf, gsize count, gsize &amp;bytes_read)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual IOStatus</type>
      <name>write_vfunc</name>
      <anchorfile>classGlib_1_1IOChannel.html</anchorfile>
      <anchor>a4ed5372da9d4ad3465012fc2317507b5</anchor>
      <arglist>(const char *buf, gsize count, gsize &amp;bytes_written)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual IOStatus</type>
      <name>seek_vfunc</name>
      <anchorfile>classGlib_1_1IOChannel.html</anchorfile>
      <anchor>a781de88aec2c032d05f74402779665f3</anchor>
      <arglist>(gint64 offset, SeekType type)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual IOStatus</type>
      <name>close_vfunc</name>
      <anchorfile>classGlib_1_1IOChannel.html</anchorfile>
      <anchor>a735b70808acbb542b04bf55b0133927e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual IOStatus</type>
      <name>set_flags_vfunc</name>
      <anchorfile>classGlib_1_1IOChannel.html</anchorfile>
      <anchor>af8f690f1e0a8945b75ad7be4949e44cf</anchor>
      <arglist>(IOFlags flags)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual IOFlags</type>
      <name>get_flags_vfunc</name>
      <anchorfile>classGlib_1_1IOChannel.html</anchorfile>
      <anchor>ae3326db3877358b563de11fb3dd8367f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual Glib::RefPtr&lt; Glib::Source &gt;</type>
      <name>create_watch_vfunc</name>
      <anchorfile>classGlib_1_1IOChannel.html</anchorfile>
      <anchor>a128f2bfd977617a6a1a7e4a7fbe6aa5b</anchor>
      <arglist>(IOCondition cond)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>GIOChannel *</type>
      <name>gobject_</name>
      <anchorfile>classGlib_1_1IOChannel.html</anchorfile>
      <anchor>a6683e47c0d78492b83d7021288d9b6d0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glib::KeyFileError</name>
    <filename>classGlib_1_1KeyFileError.html</filename>
    <base>Glib::Error</base>
    <member kind="enumeration">
      <name>Code</name>
      <anchorfile>classGlib_1_1KeyFileError.html</anchorfile>
      <anchor>aa3cd76f47263fa75421227221563be52</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNKNOWN_ENCODING</name>
      <anchorfile>classGlib_1_1KeyFileError.html</anchorfile>
      <anchor>aa3cd76f47263fa75421227221563be52a24279ab7c4d83ec8774f46f1f159a255</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PARSE</name>
      <anchorfile>classGlib_1_1KeyFileError.html</anchorfile>
      <anchor>aa3cd76f47263fa75421227221563be52a83fae4b5fa2f269a6d4afead8b8faf64</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NOT_FOUND</name>
      <anchorfile>classGlib_1_1KeyFileError.html</anchorfile>
      <anchor>aa3cd76f47263fa75421227221563be52a2d2b02b32304241674b66742f55e2d0a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>KEY_NOT_FOUND</name>
      <anchorfile>classGlib_1_1KeyFileError.html</anchorfile>
      <anchor>aa3cd76f47263fa75421227221563be52af5fc91a3801ecf05e20ab72578c78471</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>GROUP_NOT_FOUND</name>
      <anchorfile>classGlib_1_1KeyFileError.html</anchorfile>
      <anchor>aa3cd76f47263fa75421227221563be52ac5be98a4ce73c73130edbd4631d9ee39</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>INVALID_VALUE</name>
      <anchorfile>classGlib_1_1KeyFileError.html</anchorfile>
      <anchor>aa3cd76f47263fa75421227221563be52a7290dc045af91eab91d340e7f6fc6d76</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KeyFileError</name>
      <anchorfile>classGlib_1_1KeyFileError.html</anchorfile>
      <anchor>aecd9898aacf14a6d8b1f7965e04f227a</anchor>
      <arglist>(Code error_code, const Glib::ustring &amp;error_message)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KeyFileError</name>
      <anchorfile>classGlib_1_1KeyFileError.html</anchorfile>
      <anchor>a064f4a933c5c53a16ddb919609f5ddaa</anchor>
      <arglist>(GError *gobject)</arglist>
    </member>
    <member kind="function">
      <type>Code</type>
      <name>code</name>
      <anchorfile>classGlib_1_1KeyFileError.html</anchorfile>
      <anchor>af8f7b3b7c506398a3ee34956ded1f762</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glib::KeyFile</name>
    <filename>classGlib_1_1KeyFile.html</filename>
    <member kind="function">
      <type></type>
      <name>KeyFile</name>
      <anchorfile>classGlib_1_1KeyFile.html</anchorfile>
      <anchor>a574f57c39fa7627d0d38ee6660173cb6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~KeyFile</name>
      <anchorfile>classGlib_1_1KeyFile.html</anchorfile>
      <anchor>a76fdf6f57ba9719b92eadd883c27a3d6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KeyFile</name>
      <anchorfile>classGlib_1_1KeyFile.html</anchorfile>
      <anchor>ad9c90566b014ba59f545e9a663e6d34d</anchor>
      <arglist>(GKeyFile *castitem, bool takes_ownership=false)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>load_from_file</name>
      <anchorfile>classGlib_1_1KeyFile.html</anchorfile>
      <anchor>a8e5a625d648c0e84b0bf4a8cbf6d68cc</anchor>
      <arglist>(const std::string &amp;filename, KeyFileFlags flags=Glib::KEY_FILE_NONE)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>load_from_data</name>
      <anchorfile>classGlib_1_1KeyFile.html</anchorfile>
      <anchor>a22113e3fdfa834fc688e6429b2e6332f</anchor>
      <arglist>(const Glib::ustring &amp;data, KeyFileFlags flags=Glib::KEY_FILE_NONE)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>load_from_data_dirs</name>
      <anchorfile>classGlib_1_1KeyFile.html</anchorfile>
      <anchor>a53221a7f8720157e1ef6e635260570b8</anchor>
      <arglist>(const std::string &amp;file, std::string &amp;full_path, KeyFileFlags flags=Glib::KEY_FILE_NONE)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>to_data</name>
      <anchorfile>classGlib_1_1KeyFile.html</anchorfile>
      <anchor>acb65a298d161691468cdb7add19b00e8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_start_group</name>
      <anchorfile>classGlib_1_1KeyFile.html</anchorfile>
      <anchor>ab619afc4e670b960a09e0199151f8a8c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ArrayHandle&lt; Glib::ustring &gt;</type>
      <name>get_groups</name>
      <anchorfile>classGlib_1_1KeyFile.html</anchorfile>
      <anchor>a675e788637f83c2d29d268c8039b0aef</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ArrayHandle&lt; Glib::ustring &gt;</type>
      <name>get_keys</name>
      <anchorfile>classGlib_1_1KeyFile.html</anchorfile>
      <anchor>a108c2605d26beebd38330b745f55c5e1</anchor>
      <arglist>(const Glib::ustring &amp;group_name) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>has_group</name>
      <anchorfile>classGlib_1_1KeyFile.html</anchorfile>
      <anchor>a903e3a2a27d1a7a12e0b27d87a7b3da3</anchor>
      <arglist>(const Glib::ustring &amp;group_name) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>has_key</name>
      <anchorfile>classGlib_1_1KeyFile.html</anchorfile>
      <anchor>a00f44290cb03cc75ffafa1fdb006cc22</anchor>
      <arglist>(const Glib::ustring &amp;group_name, const Glib::ustring &amp;key) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_value</name>
      <anchorfile>classGlib_1_1KeyFile.html</anchorfile>
      <anchor>ae407e4614dbbdaf097098fbab19506fa</anchor>
      <arglist>(const Glib::ustring &amp;group_name, const Glib::ustring &amp;key) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_string</name>
      <anchorfile>classGlib_1_1KeyFile.html</anchorfile>
      <anchor>a966f044df7b35d1e7c77c96f1fe768dc</anchor>
      <arglist>(const Glib::ustring &amp;group_name, const Glib::ustring &amp;key) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_locale_string</name>
      <anchorfile>classGlib_1_1KeyFile.html</anchorfile>
      <anchor>a08218a8dbe2a8fb4200f7a0c93ede912</anchor>
      <arglist>(const Glib::ustring &amp;group_name, const Glib::ustring &amp;key) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_locale_string</name>
      <anchorfile>classGlib_1_1KeyFile.html</anchorfile>
      <anchor>a25eea13fdfc5c5ab235e2e72466cd53d</anchor>
      <arglist>(const Glib::ustring &amp;group_name, const Glib::ustring &amp;key, const Glib::ustring &amp;locale) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_boolean</name>
      <anchorfile>classGlib_1_1KeyFile.html</anchorfile>
      <anchor>a0d383ad579647505ff3376e93591aaa7</anchor>
      <arglist>(const Glib::ustring &amp;group_name, const Glib::ustring &amp;key) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>get_integer</name>
      <anchorfile>classGlib_1_1KeyFile.html</anchorfile>
      <anchor>a8829a3cac6a4addd232012b798fa63ea</anchor>
      <arglist>(const Glib::ustring &amp;key) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>get_integer</name>
      <anchorfile>classGlib_1_1KeyFile.html</anchorfile>
      <anchor>ad94dadf67bda687779774a34ac8c27e3</anchor>
      <arglist>(const Glib::ustring &amp;group_name, const Glib::ustring &amp;key) const </arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>get_double</name>
      <anchorfile>classGlib_1_1KeyFile.html</anchorfile>
      <anchor>ae3bcad9bb8c99a2b682fb3188d192675</anchor>
      <arglist>(const Glib::ustring &amp;key) const </arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>get_double</name>
      <anchorfile>classGlib_1_1KeyFile.html</anchorfile>
      <anchor>aa3dc433e0ea14dd66e2c843be7ded1ee</anchor>
      <arglist>(const Glib::ustring &amp;group_name, const Glib::ustring &amp;key) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_double</name>
      <anchorfile>classGlib_1_1KeyFile.html</anchorfile>
      <anchor>a2437f94f6c1f56de2de338445008651c</anchor>
      <arglist>(const Glib::ustring &amp;group_name, const Glib::ustring &amp;key, double value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_double</name>
      <anchorfile>classGlib_1_1KeyFile.html</anchorfile>
      <anchor>a44f05daea63a1188cae854ca77228355</anchor>
      <arglist>(const Glib::ustring &amp;key, double value)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ArrayHandle&lt; Glib::ustring &gt;</type>
      <name>get_string_list</name>
      <anchorfile>classGlib_1_1KeyFile.html</anchorfile>
      <anchor>a440aa963a6b393618b0c1947f274e955</anchor>
      <arglist>(const Glib::ustring &amp;group_name, const Glib::ustring &amp;key) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ArrayHandle&lt; Glib::ustring &gt;</type>
      <name>get_locale_string_list</name>
      <anchorfile>classGlib_1_1KeyFile.html</anchorfile>
      <anchor>aa811f080e3e9b82baac56ad188b058e1</anchor>
      <arglist>(const Glib::ustring &amp;group_name, const Glib::ustring &amp;key) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ArrayHandle&lt; Glib::ustring &gt;</type>
      <name>get_locale_string_list</name>
      <anchorfile>classGlib_1_1KeyFile.html</anchorfile>
      <anchor>a15475936afc7bd85a30624bc76a1122d</anchor>
      <arglist>(const Glib::ustring &amp;group_name, const Glib::ustring &amp;key, const Glib::ustring &amp;locale) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ArrayHandle&lt; bool &gt;</type>
      <name>get_boolean_list</name>
      <anchorfile>classGlib_1_1KeyFile.html</anchorfile>
      <anchor>a81a06db8c2ccb33c756f97ccb2f68561</anchor>
      <arglist>(const Glib::ustring &amp;group_name, const Glib::ustring &amp;key) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ArrayHandle&lt; int &gt;</type>
      <name>get_integer_list</name>
      <anchorfile>classGlib_1_1KeyFile.html</anchorfile>
      <anchor>af74312f2d086d1ec334773975dfe7b69</anchor>
      <arglist>(const Glib::ustring &amp;group_name, const Glib::ustring &amp;key) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ArrayHandle&lt; double &gt;</type>
      <name>get_double_list</name>
      <anchorfile>classGlib_1_1KeyFile.html</anchorfile>
      <anchor>ab1d747335102a96d99479e6827efb32f</anchor>
      <arglist>(const Glib::ustring &amp;group_name, const Glib::ustring &amp;key) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_comment</name>
      <anchorfile>classGlib_1_1KeyFile.html</anchorfile>
      <anchor>a23e315d219a3baecfc9c0a319ced6fb2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_comment</name>
      <anchorfile>classGlib_1_1KeyFile.html</anchorfile>
      <anchor>aa8e4501b6fb4e4adb701c2ca980f663e</anchor>
      <arglist>(const Glib::ustring &amp;group_name) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_comment</name>
      <anchorfile>classGlib_1_1KeyFile.html</anchorfile>
      <anchor>aab23bdbdac01a77d9b225d166fb2261c</anchor>
      <arglist>(const Glib::ustring &amp;group_name, const Glib::ustring &amp;key) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_list_separator</name>
      <anchorfile>classGlib_1_1KeyFile.html</anchorfile>
      <anchor>aed087a7066145f1859710b89dbef1ccb</anchor>
      <arglist>(gchar separator)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_value</name>
      <anchorfile>classGlib_1_1KeyFile.html</anchorfile>
      <anchor>a38bf60f9bdd209d28ae818e7dee6ea17</anchor>
      <arglist>(const Glib::ustring &amp;group_name, const Glib::ustring &amp;key, const Glib::ustring &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_string</name>
      <anchorfile>classGlib_1_1KeyFile.html</anchorfile>
      <anchor>a16cd249a1929d637432883848947f253</anchor>
      <arglist>(const Glib::ustring &amp;group_name, const Glib::ustring &amp;key, const Glib::ustring &amp;string)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_locale_string</name>
      <anchorfile>classGlib_1_1KeyFile.html</anchorfile>
      <anchor>a231e36c66336a198d4c55df81b93b711</anchor>
      <arglist>(const Glib::ustring &amp;group_name, const Glib::ustring &amp;key, const Glib::ustring &amp;locale, const Glib::ustring &amp;string)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_boolean</name>
      <anchorfile>classGlib_1_1KeyFile.html</anchorfile>
      <anchor>aab1b3899063e934ac72ba1be1a77c4a0</anchor>
      <arglist>(const Glib::ustring &amp;group_name, const Glib::ustring &amp;key, bool value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_integer</name>
      <anchorfile>classGlib_1_1KeyFile.html</anchorfile>
      <anchor>a8f61f47a667f07108023930bcefc1400</anchor>
      <arglist>(const Glib::ustring &amp;group_name, const Glib::ustring &amp;key, int value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_string_list</name>
      <anchorfile>classGlib_1_1KeyFile.html</anchorfile>
      <anchor>ace8cc2079068c4620c6498d7d831feff</anchor>
      <arglist>(const Glib::ustring &amp;group_name, const Glib::ustring &amp;key, const Glib::ArrayHandle&lt; Glib::ustring &gt; &amp;list)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_locale_string_list</name>
      <anchorfile>classGlib_1_1KeyFile.html</anchorfile>
      <anchor>a7b6c776cf8b5f5cbe5a9fa6bf343b8e4</anchor>
      <arglist>(const Glib::ustring &amp;group_name, const Glib::ustring &amp;key, const Glib::ustring &amp;locale, const Glib::ArrayHandle&lt; Glib::ustring &gt; &amp;list)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_boolean_list</name>
      <anchorfile>classGlib_1_1KeyFile.html</anchorfile>
      <anchor>a54b27ca6e8158558ba10d538673e6663</anchor>
      <arglist>(const Glib::ustring &amp;group_name, const Glib::ustring &amp;key, const Glib::ArrayHandle&lt; bool &gt; &amp;list)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_integer_list</name>
      <anchorfile>classGlib_1_1KeyFile.html</anchorfile>
      <anchor>a374ea5bbcd271412366aa5fc5bab0f1a</anchor>
      <arglist>(const Glib::ustring &amp;group_name, const Glib::ustring &amp;key, const Glib::ArrayHandle&lt; int &gt; &amp;list)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_double_list</name>
      <anchorfile>classGlib_1_1KeyFile.html</anchorfile>
      <anchor>a9af3496d225b0638df1ed633c435fad0</anchor>
      <arglist>(const Glib::ustring &amp;group_name, const Glib::ustring &amp;key, const Glib::ArrayHandle&lt; double &gt; &amp;list)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_comment</name>
      <anchorfile>classGlib_1_1KeyFile.html</anchorfile>
      <anchor>ac06f9d12cbc755feba6a3a11f34bac01</anchor>
      <arglist>(const Glib::ustring &amp;comment)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_comment</name>
      <anchorfile>classGlib_1_1KeyFile.html</anchorfile>
      <anchor>a0f1562adaf4ab68a34de7594391c1032</anchor>
      <arglist>(const Glib::ustring &amp;group_name, const Glib::ustring &amp;comment)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_comment</name>
      <anchorfile>classGlib_1_1KeyFile.html</anchorfile>
      <anchor>a03c7baab6e892e6a9917761f5200378a</anchor>
      <arglist>(const Glib::ustring &amp;group_name, const Glib::ustring &amp;key, const Glib::ustring &amp;comment)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove_comment</name>
      <anchorfile>classGlib_1_1KeyFile.html</anchorfile>
      <anchor>a0cdfad92274b403f45b75954eb167d64</anchor>
      <arglist>(const Glib::ustring &amp;group_name, const Glib::ustring &amp;key)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove_key</name>
      <anchorfile>classGlib_1_1KeyFile.html</anchorfile>
      <anchor>a0cc1601e227a57603997ddda9d6bc6e1</anchor>
      <arglist>(const Glib::ustring &amp;group_name, const Glib::ustring &amp;key)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove_group</name>
      <anchorfile>classGlib_1_1KeyFile.html</anchorfile>
      <anchor>af6fceaccb2cd166d6039dae0552900dd</anchor>
      <arglist>(const Glib::ustring &amp;group_name)</arglist>
    </member>
    <member kind="function">
      <type>GKeyFile *</type>
      <name>gobj</name>
      <anchorfile>classGlib_1_1KeyFile.html</anchorfile>
      <anchor>a456abd71e420eb7e211ba909f275e5e3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GKeyFile *</type>
      <name>gobj</name>
      <anchorfile>classGlib_1_1KeyFile.html</anchorfile>
      <anchor>a6eeac0981d8c90be7fbb21c8ae0c7804</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>GKeyFile *</type>
      <name>gobject_</name>
      <anchorfile>classGlib_1_1KeyFile.html</anchorfile>
      <anchor>a468dd6c8997d3b2e0e59b65174e603b0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>bool</type>
      <name>owns_gobject_</name>
      <anchorfile>classGlib_1_1KeyFile.html</anchorfile>
      <anchor>a5479765ba8e50cbd94beef60f65212b6</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glib::MarkupError</name>
    <filename>classGlib_1_1MarkupError.html</filename>
    <base>Glib::Error</base>
    <member kind="enumeration">
      <name>Code</name>
      <anchorfile>classGlib_1_1MarkupError.html</anchorfile>
      <anchor>a1422c4a583441bbe490b8ed47d7fe1a7</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>BAD_UTF8</name>
      <anchorfile>classGlib_1_1MarkupError.html</anchorfile>
      <anchor>ga1422c4a583441bbe490b8ed47d7fe1a7a30c6a6f1fcf9249db2692abc39b34c48</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EMPTY</name>
      <anchorfile>classGlib_1_1MarkupError.html</anchorfile>
      <anchor>ga1422c4a583441bbe490b8ed47d7fe1a7a5b3981a2a475d8b0ab4481c931c816dd</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PARSE</name>
      <anchorfile>classGlib_1_1MarkupError.html</anchorfile>
      <anchor>ga1422c4a583441bbe490b8ed47d7fe1a7adb7227e7bfab9c3409b7f5ce7da8075c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNKNOWN_ELEMENT</name>
      <anchorfile>classGlib_1_1MarkupError.html</anchorfile>
      <anchor>ga1422c4a583441bbe490b8ed47d7fe1a7a2a63efd807b6e40451b57e128b34d9f5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNKNOWN_ATTRIBUTE</name>
      <anchorfile>classGlib_1_1MarkupError.html</anchorfile>
      <anchor>ga1422c4a583441bbe490b8ed47d7fe1a7aef0a541fa2885ffc56d0703a55afa735</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>INVALID_CONTENT</name>
      <anchorfile>classGlib_1_1MarkupError.html</anchorfile>
      <anchor>ga1422c4a583441bbe490b8ed47d7fe1a7a4051754fb4e8f11408fe06445e99761e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MISSING_ATTRIBUTE</name>
      <anchorfile>classGlib_1_1MarkupError.html</anchorfile>
      <anchor>a1422c4a583441bbe490b8ed47d7fe1a7a5b9c50248b29c8796462fc28fd1e73e7</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>MarkupError</name>
      <anchorfile>classGlib_1_1MarkupError.html</anchorfile>
      <anchor>a6ae004c83ba5b4a32b3d7df5aa17dd19</anchor>
      <arglist>(Code error_code, const Glib::ustring &amp;error_message)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>MarkupError</name>
      <anchorfile>classGlib_1_1MarkupError.html</anchorfile>
      <anchor>aa5324bf1f53adf5fed4be252709a1e05</anchor>
      <arglist>(GError *gobject)</arglist>
    </member>
    <member kind="function">
      <type>Code</type>
      <name>code</name>
      <anchorfile>classGlib_1_1MarkupError.html</anchorfile>
      <anchor>a93533ff4c34e76e9617dce3dc616f322</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glib::Module</name>
    <filename>classGlib_1_1Module.html</filename>
    <member kind="function">
      <type></type>
      <name>Module</name>
      <anchorfile>classGlib_1_1Module.html</anchorfile>
      <anchor>a43a926bb46ae0ccc4d63217fcc0f31cd</anchor>
      <arglist>(const std::string &amp;file_name, ModuleFlags flags=ModuleFlags(0))</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Module</name>
      <anchorfile>classGlib_1_1Module.html</anchorfile>
      <anchor>a2b0353fc01a57653c0c60774efde274a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>operator bool</name>
      <anchorfile>classGlib_1_1Module.html</anchorfile>
      <anchor>a8426c52d92aa6be0f3077ee4ee71c5a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>make_resident</name>
      <anchorfile>classGlib_1_1Module.html</anchorfile>
      <anchor>af10c2ab1a24763db0702782d4928c06f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_symbol</name>
      <anchorfile>classGlib_1_1Module.html</anchorfile>
      <anchor>a9e424387004421e29f65491dd1643a09</anchor>
      <arglist>(const std::string &amp;symbol_name, void *&amp;symbol) const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_name</name>
      <anchorfile>classGlib_1_1Module.html</anchorfile>
      <anchor>a19636376bf76a118b572015220b4623a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GModule *</type>
      <name>gobj</name>
      <anchorfile>classGlib_1_1Module.html</anchorfile>
      <anchor>ac3b1db2a5e4dcb2771ce7376ab207951</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GModule *</type>
      <name>gobj</name>
      <anchorfile>classGlib_1_1Module.html</anchorfile>
      <anchor>ad3791a114fc85afd1a07644cd839243f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static bool</type>
      <name>get_supported</name>
      <anchorfile>classGlib_1_1Module.html</anchorfile>
      <anchor>ad135ce3f9e6b8b7441bd4ca8da2099fb</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static std::string</type>
      <name>get_last_error</name>
      <anchorfile>classGlib_1_1Module.html</anchorfile>
      <anchor>a40669f490a2e90d7c39ede58a7ef5c2b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static std::string</type>
      <name>build_path</name>
      <anchorfile>classGlib_1_1Module.html</anchorfile>
      <anchor>a5ea64e82147d3ba9edb75f71dfffc87c</anchor>
      <arglist>(const std::string &amp;directory, const std::string &amp;module_name)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>GModule *</type>
      <name>gobject_</name>
      <anchorfile>classGlib_1_1Module.html</anchorfile>
      <anchor>a12a777846a059ffc8277ba2f196cb68e</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glib::NodeTree</name>
    <filename>classGlib_1_1NodeTree.html</filename>
    <templarg></templarg>
    <member kind="enumeration">
      <name>TraverseFlags</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gad11179d39a4991e5b09f145d594a450e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TRAVERSE_LEAVES</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggad11179d39a4991e5b09f145d594a450ea7da8793fdd0c433870a5e6c2e3152898</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TRAVERSE_NON_LEAVES</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggad11179d39a4991e5b09f145d594a450ea6473ae1f054172ae349d01003fabf37f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TRAVERSE_ALL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggad11179d39a4991e5b09f145d594a450ea1be75d605b0c93ca7932110467536670</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TRAVERSE_MASK</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggad11179d39a4991e5b09f145d594a450ea6832c7b45443db4eed6f4cfbd3c04b69</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>sigc::slot&lt; bool, NodeTree&lt; T &gt; &amp; &gt;</type>
      <name>TraverseFunc</name>
      <anchorfile>classGlib_1_1NodeTree.html</anchorfile>
      <anchor>a9bfeda08667567d24bc28ea6b882f48a</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>sigc::slot&lt; void, NodeTree&lt; T &gt; &amp; &gt;</type>
      <name>ForeachFunc</name>
      <anchorfile>classGlib_1_1NodeTree.html</anchorfile>
      <anchor>aef52fbe6656101a9bf1dc8ad0c420979</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>NodeTree</name>
      <anchorfile>classGlib_1_1NodeTree.html</anchorfile>
      <anchor>a24d62b0424afc56cef69022c36bb16c5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>NodeTree</name>
      <anchorfile>classGlib_1_1NodeTree.html</anchorfile>
      <anchor>aa3909f3fe31329f176925791bbe368fb</anchor>
      <arglist>(const T &amp;the_data)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>NodeTree</name>
      <anchorfile>classGlib_1_1NodeTree.html</anchorfile>
      <anchor>a5c27a9b91aa532347e463f3629d20dd6</anchor>
      <arglist>(const NodeTree&lt; T &gt; &amp;node)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~NodeTree</name>
      <anchorfile>classGlib_1_1NodeTree.html</anchorfile>
      <anchor>a106a3ec5b9d0e0368aa43b4ef9bbe93e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>NodeTree&lt; T &gt; &amp;</type>
      <name>operator=</name>
      <anchorfile>classGlib_1_1NodeTree.html</anchorfile>
      <anchor>af265f6f216ea9209cec39992dd0b6175</anchor>
      <arglist>(const NodeTree&lt; T &gt; &amp;node)</arglist>
    </member>
    <member kind="function">
      <type>GNode *</type>
      <name>gobj</name>
      <anchorfile>classGlib_1_1NodeTree.html</anchorfile>
      <anchor>a7571a3bcf836821859f83406179921d9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GNode *</type>
      <name>gobj</name>
      <anchorfile>classGlib_1_1NodeTree.html</anchorfile>
      <anchor>a48d863d06ce73068895485b3a8b25e5c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>NodeTree&lt; T &gt; &amp;</type>
      <name>insert</name>
      <anchorfile>classGlib_1_1NodeTree.html</anchorfile>
      <anchor>a664b7930de8a3d5b2f9f691d6a5d2e44</anchor>
      <arglist>(int position, NodeTree&lt; T &gt; &amp;node)</arglist>
    </member>
    <member kind="function">
      <type>NodeTree&lt; T &gt; &amp;</type>
      <name>insert_before</name>
      <anchorfile>classGlib_1_1NodeTree.html</anchorfile>
      <anchor>a6c0185ff53ce6f0b6574b4b93c706a29</anchor>
      <arglist>(NodeTree&lt; T &gt; &amp;sibling, NodeTree&lt; T &gt; &amp;node)</arglist>
    </member>
    <member kind="function">
      <type>NodeTree&lt; T &gt; &amp;</type>
      <name>insert_after</name>
      <anchorfile>classGlib_1_1NodeTree.html</anchorfile>
      <anchor>a3217b1e57993a335daa02b7728385d32</anchor>
      <arglist>(NodeTree&lt; T &gt; &amp;sibling, NodeTree&lt; T &gt; &amp;node)</arglist>
    </member>
    <member kind="function">
      <type>NodeTree&lt; T &gt; &amp;</type>
      <name>append</name>
      <anchorfile>classGlib_1_1NodeTree.html</anchorfile>
      <anchor>a65a5e8732e2b140233eb1450ab6f35d4</anchor>
      <arglist>(NodeTree&lt; T &gt; &amp;node)</arglist>
    </member>
    <member kind="function">
      <type>NodeTree&lt; T &gt; &amp;</type>
      <name>prepend</name>
      <anchorfile>classGlib_1_1NodeTree.html</anchorfile>
      <anchor>ac6d84033181fdbe1d84491bf505d6a5b</anchor>
      <arglist>(NodeTree&lt; T &gt; &amp;node)</arglist>
    </member>
    <member kind="function">
      <type>NodeTree&lt; T &gt; *</type>
      <name>insert_data</name>
      <anchorfile>classGlib_1_1NodeTree.html</anchorfile>
      <anchor>a988e1fd1fa5a91ac794ea859db7bcc85</anchor>
      <arglist>(int position, const T &amp;the_data)</arglist>
    </member>
    <member kind="function">
      <type>NodeTree&lt; T &gt; *</type>
      <name>insert_data_before</name>
      <anchorfile>classGlib_1_1NodeTree.html</anchorfile>
      <anchor>aaa93210a10a5c3c3b31b728997354f81</anchor>
      <arglist>(NodeTree&lt; T &gt; &amp;sibling, const T &amp;the_data)</arglist>
    </member>
    <member kind="function">
      <type>NodeTree&lt; T &gt; *</type>
      <name>append_data</name>
      <anchorfile>classGlib_1_1NodeTree.html</anchorfile>
      <anchor>ac8d7b7ce8b478dfd87b8227e621b943c</anchor>
      <arglist>(const T &amp;the_data)</arglist>
    </member>
    <member kind="function">
      <type>NodeTree&lt; T &gt; *</type>
      <name>prepend_data</name>
      <anchorfile>classGlib_1_1NodeTree.html</anchorfile>
      <anchor>a2db3f440692e02d717bd9a4ec3b6604a</anchor>
      <arglist>(const T &amp;the_data)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>reverse_children</name>
      <anchorfile>classGlib_1_1NodeTree.html</anchorfile>
      <anchor>a125bbad27e6950b6d399b9746c9ffb60</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>NodeTree&lt; T &gt; *</type>
      <name>get_root</name>
      <anchorfile>classGlib_1_1NodeTree.html</anchorfile>
      <anchor>af0b6480bbb3d432db077c8a5a1682135</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const NodeTree&lt; T &gt; *</type>
      <name>get_root</name>
      <anchorfile>classGlib_1_1NodeTree.html</anchorfile>
      <anchor>aa1a618273dca912e2d3d0c2d3991afdf</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>traverse</name>
      <anchorfile>classGlib_1_1NodeTree.html</anchorfile>
      <anchor>a88164f3d6446ba63db1c7e633d1f042d</anchor>
      <arglist>(const TraverseFunc &amp;func, TraverseType order=TRAVERSE_IN_ORDER, TraverseFlags flags=TRAVERSE_ALL, int max_depth=-1)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>foreach</name>
      <anchorfile>classGlib_1_1NodeTree.html</anchorfile>
      <anchor>ac4dae53c67e86593c5533e86a39a7c42</anchor>
      <arglist>(const ForeachFunc &amp;func, TraverseFlags flags=TRAVERSE_ALL)</arglist>
    </member>
    <member kind="function">
      <type>NodeTree&lt; T &gt; *</type>
      <name>find_child</name>
      <anchorfile>classGlib_1_1NodeTree.html</anchorfile>
      <anchor>a7a553e458203bcc295bafc07c3662e9c</anchor>
      <arglist>(const T &amp;the_data, TraverseFlags flags=TRAVERSE_ALL)</arglist>
    </member>
    <member kind="function">
      <type>const NodeTree&lt; T &gt; *</type>
      <name>find_child</name>
      <anchorfile>classGlib_1_1NodeTree.html</anchorfile>
      <anchor>a10016f20b49c142f9582a5e69e956ee6</anchor>
      <arglist>(const T &amp;the_data, TraverseFlags flags=TRAVERSE_ALL) const </arglist>
    </member>
    <member kind="function">
      <type>NodeTree&lt; T &gt; *</type>
      <name>find</name>
      <anchorfile>classGlib_1_1NodeTree.html</anchorfile>
      <anchor>a2b7691f32ba16f902124c6c72110d1c5</anchor>
      <arglist>(const T &amp;the_data, TraverseType order=TRAVERSE_IN_ORDER, TraverseFlags flags=TRAVERSE_ALL)</arglist>
    </member>
    <member kind="function">
      <type>const NodeTree&lt; T &gt; *</type>
      <name>find</name>
      <anchorfile>classGlib_1_1NodeTree.html</anchorfile>
      <anchor>a84b95e45ee739d73cd35786c884d6880</anchor>
      <arglist>(const T &amp;the_data, TraverseType order=TRAVERSE_IN_ORDER, TraverseFlags flags=TRAVERSE_ALL) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>child_index</name>
      <anchorfile>classGlib_1_1NodeTree.html</anchorfile>
      <anchor>aa900e05a5eb8ae321b4569b412317d05</anchor>
      <arglist>(const T &amp;the_data) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>child_position</name>
      <anchorfile>classGlib_1_1NodeTree.html</anchorfile>
      <anchor>ae6bc31fc9c26678a5968cbe4fd3d4ba1</anchor>
      <arglist>(const NodeTree&lt; T &gt; &amp;child) const </arglist>
    </member>
    <member kind="function">
      <type>NodeTree&lt; T &gt; *</type>
      <name>first_child</name>
      <anchorfile>classGlib_1_1NodeTree.html</anchorfile>
      <anchor>ab64b292bd177d3d513125953141e3de9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const NodeTree&lt; T &gt; *</type>
      <name>first_child</name>
      <anchorfile>classGlib_1_1NodeTree.html</anchorfile>
      <anchor>accdea338939b60daa996850da811c71c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>NodeTree&lt; T &gt; *</type>
      <name>last_child</name>
      <anchorfile>classGlib_1_1NodeTree.html</anchorfile>
      <anchor>a1ac3c8a683876db6aeb8834baeff29ac</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const NodeTree&lt; T &gt; *</type>
      <name>last_child</name>
      <anchorfile>classGlib_1_1NodeTree.html</anchorfile>
      <anchor>acad549d047b291491a525b2f0a1e3346</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>NodeTree&lt; T &gt; *</type>
      <name>nth_child</name>
      <anchorfile>classGlib_1_1NodeTree.html</anchorfile>
      <anchor>ae956914aaa5bba966934bab270f9ee82</anchor>
      <arglist>(int n)</arglist>
    </member>
    <member kind="function">
      <type>const NodeTree&lt; T &gt; *</type>
      <name>nth_child</name>
      <anchorfile>classGlib_1_1NodeTree.html</anchorfile>
      <anchor>a92694bf6304a94fe68e8a01a525c5f4b</anchor>
      <arglist>(int n) const </arglist>
    </member>
    <member kind="function">
      <type>NodeTree&lt; T &gt; *</type>
      <name>first_sibling</name>
      <anchorfile>classGlib_1_1NodeTree.html</anchorfile>
      <anchor>a2021001eee1ff423ec2f0a759170e4fd</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const NodeTree&lt; T &gt; *</type>
      <name>first_sibling</name>
      <anchorfile>classGlib_1_1NodeTree.html</anchorfile>
      <anchor>a255ef0115a5ce2c5b0d09b06a25b2860</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>NodeTree&lt; T &gt; *</type>
      <name>prev_sibling</name>
      <anchorfile>classGlib_1_1NodeTree.html</anchorfile>
      <anchor>a6ed1973b99c794b1e52fdcb2fc41ba19</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const NodeTree&lt; T &gt; *</type>
      <name>prev_sibling</name>
      <anchorfile>classGlib_1_1NodeTree.html</anchorfile>
      <anchor>a4a13060df965cfe95ee2cdcc2ce1dc71</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>NodeTree&lt; T &gt; *</type>
      <name>next_sibling</name>
      <anchorfile>classGlib_1_1NodeTree.html</anchorfile>
      <anchor>a7b973fa140f0a392edf1d9f562c6809a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const NodeTree&lt; T &gt; *</type>
      <name>next_sibling</name>
      <anchorfile>classGlib_1_1NodeTree.html</anchorfile>
      <anchor>af7952c290182814a42eed558a3701b5a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>NodeTree&lt; T &gt; *</type>
      <name>last_sibling</name>
      <anchorfile>classGlib_1_1NodeTree.html</anchorfile>
      <anchor>a958c88a651bacc95d5ec944bc96df580</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const NodeTree&lt; T &gt; *</type>
      <name>last_sibling</name>
      <anchorfile>classGlib_1_1NodeTree.html</anchorfile>
      <anchor>a896b4501c34b121448a146bbb4b7165b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_leaf</name>
      <anchorfile>classGlib_1_1NodeTree.html</anchorfile>
      <anchor>a4b245acd3b836f19b2ed17a584cffca3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_root</name>
      <anchorfile>classGlib_1_1NodeTree.html</anchorfile>
      <anchor>aa0e8f12f34a1091df1fd7690b374cd0e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>guint</type>
      <name>depth</name>
      <anchorfile>classGlib_1_1NodeTree.html</anchorfile>
      <anchor>ac1ecb9d86f4e6d84a1ee5e98c400861a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>guint</type>
      <name>node_count</name>
      <anchorfile>classGlib_1_1NodeTree.html</anchorfile>
      <anchor>a95893b710363a62b6cc50bc350a3986c</anchor>
      <arglist>(TraverseFlags flags=TRAVERSE_ALL) const </arglist>
    </member>
    <member kind="function">
      <type>guint</type>
      <name>child_count</name>
      <anchorfile>classGlib_1_1NodeTree.html</anchorfile>
      <anchor>ac787f9ab75c5c765a17317a16d73a518</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_ancestor</name>
      <anchorfile>classGlib_1_1NodeTree.html</anchorfile>
      <anchor>acff54c49a239add277672c971c96c686</anchor>
      <arglist>(const NodeTree&lt; T &gt; &amp;descendant) const </arglist>
    </member>
    <member kind="function">
      <type>guint</type>
      <name>get_max_height</name>
      <anchorfile>classGlib_1_1NodeTree.html</anchorfile>
      <anchor>a034f08972248866c2563ea60993add7c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unlink</name>
      <anchorfile>classGlib_1_1NodeTree.html</anchorfile>
      <anchor>a63d3fec697451d006c61f3b64df22c78</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>T &amp;</type>
      <name>data</name>
      <anchorfile>classGlib_1_1NodeTree.html</anchorfile>
      <anchor>ae6159ff89698b40fea479cbafdc4f067</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const T &amp;</type>
      <name>data</name>
      <anchorfile>classGlib_1_1NodeTree.html</anchorfile>
      <anchor>a205cdaaa7bf5eb6a3750c8d4609dd122</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const NodeTree&lt; T &gt; *</type>
      <name>parent</name>
      <anchorfile>classGlib_1_1NodeTree.html</anchorfile>
      <anchor>a9a58a1c8f02136d52998a62897c5945d</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glib::OptionError</name>
    <filename>classGlib_1_1OptionError.html</filename>
    <base>Glib::Error</base>
    <member kind="enumeration">
      <name>Code</name>
      <anchorfile>classGlib_1_1OptionError.html</anchorfile>
      <anchor>a3ea5eb98a6e3179cf30c61aec0f92e0f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNKNOWN_OPTION</name>
      <anchorfile>classGlib_1_1OptionError.html</anchorfile>
      <anchor>a3ea5eb98a6e3179cf30c61aec0f92e0fadbffad617d2d2adc2b91b2d50e67d43f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>BAD_VALUE</name>
      <anchorfile>classGlib_1_1OptionError.html</anchorfile>
      <anchor>a3ea5eb98a6e3179cf30c61aec0f92e0fadccf631862138814c2c8c9fb5d68ee5b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FAILED</name>
      <anchorfile>classGlib_1_1OptionError.html</anchorfile>
      <anchor>a3ea5eb98a6e3179cf30c61aec0f92e0fa30e7457812a8f2a6c32eb982d9df7593</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>OptionError</name>
      <anchorfile>classGlib_1_1OptionError.html</anchorfile>
      <anchor>abcab818ae38ae2a190b74c04f7a62794</anchor>
      <arglist>(Code error_code, const Glib::ustring &amp;error_message)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>OptionError</name>
      <anchorfile>classGlib_1_1OptionError.html</anchorfile>
      <anchor>ace45974f225f53b08db04bb455c05b1f</anchor>
      <arglist>(GError *gobject)</arglist>
    </member>
    <member kind="function">
      <type>Code</type>
      <name>code</name>
      <anchorfile>classGlib_1_1OptionError.html</anchorfile>
      <anchor>a43c1d4a45248b644f498bb3e75902321</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glib::OptionContext</name>
    <filename>classGlib_1_1OptionContext.html</filename>
    <member kind="typedef">
      <type>sigc::slot&lt; Glib::ustring, const Glib::ustring &amp; &gt;</type>
      <name>SlotTranslate</name>
      <anchorfile>classGlib_1_1OptionContext.html</anchorfile>
      <anchor>afe53674752fc26dd9d4dd5388f988006</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>OptionContext</name>
      <anchorfile>classGlib_1_1OptionContext.html</anchorfile>
      <anchor>ad313150579fe7f769f1c5863f8867eab</anchor>
      <arglist>(const Glib::ustring &amp;parameter_string=Glib::ustring())</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>OptionContext</name>
      <anchorfile>classGlib_1_1OptionContext.html</anchorfile>
      <anchor>ae84b2223d374cf0756af7a08e6df811f</anchor>
      <arglist>(GOptionContext *castitem, bool take_ownership=false)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~OptionContext</name>
      <anchorfile>classGlib_1_1OptionContext.html</anchorfile>
      <anchor>a5871acd083020c408dcd2d399f981fd1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_help_enabled</name>
      <anchorfile>classGlib_1_1OptionContext.html</anchorfile>
      <anchor>ae31d88f6e0c9a3211af390e0d3f976c6</anchor>
      <arglist>(bool help_enabled=true)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_help_enabled</name>
      <anchorfile>classGlib_1_1OptionContext.html</anchorfile>
      <anchor>a4f33399c5395db9dd055f02a08712ec0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_ignore_unknown_options</name>
      <anchorfile>classGlib_1_1OptionContext.html</anchorfile>
      <anchor>a022f6c50d608b2fabdf7287caf588d73</anchor>
      <arglist>(bool ignore_unknown=true)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_ignore_unknown_options</name>
      <anchorfile>classGlib_1_1OptionContext.html</anchorfile>
      <anchor>aa15e010efafa83d8d953c026e036dd01</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>parse</name>
      <anchorfile>classGlib_1_1OptionContext.html</anchorfile>
      <anchor>a08ab225e3a4be10364f32948a6532726</anchor>
      <arglist>(int &amp;argc, char **&amp;argv)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>add_group</name>
      <anchorfile>classGlib_1_1OptionContext.html</anchorfile>
      <anchor>a2c81f14e99f9c84406f200286673b14e</anchor>
      <arglist>(OptionGroup &amp;group)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_main_group</name>
      <anchorfile>classGlib_1_1OptionContext.html</anchorfile>
      <anchor>ae6d57268ad6a1f05c5d6175ab8e11181</anchor>
      <arglist>(OptionGroup &amp;group)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_help</name>
      <anchorfile>classGlib_1_1OptionContext.html</anchorfile>
      <anchor>ab1728254b364468d687c985974068e3c</anchor>
      <arglist>(bool main_help, const OptionGroup &amp;group) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_help</name>
      <anchorfile>classGlib_1_1OptionContext.html</anchorfile>
      <anchor>a28927fd06f3bfe78009bcb6da4804aea</anchor>
      <arglist>(bool main_help=true) const </arglist>
    </member>
    <member kind="function">
      <type>GOptionContext *</type>
      <name>gobj</name>
      <anchorfile>classGlib_1_1OptionContext.html</anchorfile>
      <anchor>af87e77207d4a437598f485fe0e7294e0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GOptionContext *</type>
      <name>gobj</name>
      <anchorfile>classGlib_1_1OptionContext.html</anchorfile>
      <anchor>a11b48b2190d2d45f43bcc8d8e26f1eb1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_summary</name>
      <anchorfile>classGlib_1_1OptionContext.html</anchorfile>
      <anchor>abb126e75fdbd6ad904918313117fbeee</anchor>
      <arglist>(const Glib::ustring &amp;summary)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_summary</name>
      <anchorfile>classGlib_1_1OptionContext.html</anchorfile>
      <anchor>ac5ba7c5225e8122b1ee2aac0ed52dbac</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_description</name>
      <anchorfile>classGlib_1_1OptionContext.html</anchorfile>
      <anchor>a3d89734e8546a0e6051320a79ccf0816</anchor>
      <arglist>(const Glib::ustring &amp;description)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_description</name>
      <anchorfile>classGlib_1_1OptionContext.html</anchorfile>
      <anchor>ad69d2b96ea1b5c95a5237659bf93b6ad</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_translation_domain</name>
      <anchorfile>classGlib_1_1OptionContext.html</anchorfile>
      <anchor>a579ef7926ca89106eea5b3832eb5db15</anchor>
      <arglist>(const Glib::ustring &amp;domain)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_translate_func</name>
      <anchorfile>classGlib_1_1OptionContext.html</anchorfile>
      <anchor>acbb334944cbe596a7c1e51baa05b9adf</anchor>
      <arglist>(const SlotTranslate &amp;slot)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>GOptionContext *</type>
      <name>gobject_</name>
      <anchorfile>classGlib_1_1OptionContext.html</anchorfile>
      <anchor>ae5f0ab1971db754356144f720fa47ded</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>bool</type>
      <name>has_ownership_</name>
      <anchorfile>classGlib_1_1OptionContext.html</anchorfile>
      <anchor>aaf708c17aa94584e258cffd53b6344c6</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glib::OptionEntry</name>
    <filename>classGlib_1_1OptionEntry.html</filename>
    <member kind="enumeration">
      <name>Flags</name>
      <anchorfile>classGlib_1_1OptionEntry.html</anchorfile>
      <anchor>a5b550ab1ac9884bcc614653c9cf98280</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FLAG_HIDDEN</name>
      <anchorfile>classGlib_1_1OptionEntry.html</anchorfile>
      <anchor>a5b550ab1ac9884bcc614653c9cf98280adfc734d486122379ef2c37d9e8861644</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FLAG_IN_MAIN</name>
      <anchorfile>classGlib_1_1OptionEntry.html</anchorfile>
      <anchor>a5b550ab1ac9884bcc614653c9cf98280ab8f1e9721d33857527515dbadd3f822f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FLAG_REVERSE</name>
      <anchorfile>classGlib_1_1OptionEntry.html</anchorfile>
      <anchor>a5b550ab1ac9884bcc614653c9cf98280a24a4642bdefb942e56482f6b7d05561e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FLAG_NO_ARG</name>
      <anchorfile>classGlib_1_1OptionEntry.html</anchorfile>
      <anchor>a5b550ab1ac9884bcc614653c9cf98280a69aead0991d1cd5b29cd394c8174f25d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FLAG_FILENAME</name>
      <anchorfile>classGlib_1_1OptionEntry.html</anchorfile>
      <anchor>a5b550ab1ac9884bcc614653c9cf98280abc30a617bee9b427293fdfc13f546955</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FLAG_OPTIONAL_ARG</name>
      <anchorfile>classGlib_1_1OptionEntry.html</anchorfile>
      <anchor>a5b550ab1ac9884bcc614653c9cf98280ae7b4fc1fd7b9f41c6a91c48c8978e4ce</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FLAG_NOALIAS</name>
      <anchorfile>classGlib_1_1OptionEntry.html</anchorfile>
      <anchor>a5b550ab1ac9884bcc614653c9cf98280a9672830777db41b709ca74252f3afd27</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>OptionEntry</name>
      <anchorfile>classGlib_1_1OptionEntry.html</anchorfile>
      <anchor>aaeec52f8bd17268b8bba6e4746def3c3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>OptionEntry</name>
      <anchorfile>classGlib_1_1OptionEntry.html</anchorfile>
      <anchor>afa83c0423e913e528cb073b850bdf06a</anchor>
      <arglist>(const OptionEntry &amp;src)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~OptionEntry</name>
      <anchorfile>classGlib_1_1OptionEntry.html</anchorfile>
      <anchor>a8f84e2bdc3577ed1c1a2cb7e344eca0d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>OptionEntry &amp;</type>
      <name>operator=</name>
      <anchorfile>classGlib_1_1OptionEntry.html</anchorfile>
      <anchor>ae3070f22bf99398c42b51b71e44f8a7b</anchor>
      <arglist>(const OptionEntry &amp;src)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_long_name</name>
      <anchorfile>classGlib_1_1OptionEntry.html</anchorfile>
      <anchor>a1c7f2b04d13b8bfa0e36faa0d24d35cf</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_long_name</name>
      <anchorfile>classGlib_1_1OptionEntry.html</anchorfile>
      <anchor>a31a2a6dbb9cf995a5583fc5d18724ecd</anchor>
      <arglist>(const Glib::ustring &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>gchar</type>
      <name>get_short_name</name>
      <anchorfile>classGlib_1_1OptionEntry.html</anchorfile>
      <anchor>a81f59eb285439b4c6e863ad4e6435e1f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_short_name</name>
      <anchorfile>classGlib_1_1OptionEntry.html</anchorfile>
      <anchor>ac4e352caaf4a977dbbaf3352eed2e6fb</anchor>
      <arglist>(const gchar &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>get_flags</name>
      <anchorfile>classGlib_1_1OptionEntry.html</anchorfile>
      <anchor>a73ccebf305d55337d9001c614b4b90bb</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_flags</name>
      <anchorfile>classGlib_1_1OptionEntry.html</anchorfile>
      <anchor>a99ab7ba877bae068713085810d908e20</anchor>
      <arglist>(const int &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_description</name>
      <anchorfile>classGlib_1_1OptionEntry.html</anchorfile>
      <anchor>a2d21cdbc2fc6b6220bb43a63376f34d4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_description</name>
      <anchorfile>classGlib_1_1OptionEntry.html</anchorfile>
      <anchor>a62bc509cca2829535c1e65db5100fc05</anchor>
      <arglist>(const Glib::ustring &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_arg_description</name>
      <anchorfile>classGlib_1_1OptionEntry.html</anchorfile>
      <anchor>a1335b0adf09d6da089e5ef4348c19cd7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_arg_description</name>
      <anchorfile>classGlib_1_1OptionEntry.html</anchorfile>
      <anchor>ab9f1af6b5c5a8425dd357ccc07262eb2</anchor>
      <arglist>(const Glib::ustring &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>GOptionEntry *</type>
      <name>gobj</name>
      <anchorfile>classGlib_1_1OptionEntry.html</anchorfile>
      <anchor>a2c861668e4a9d4601e5b95ed05d05bc7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GOptionEntry *</type>
      <name>gobj</name>
      <anchorfile>classGlib_1_1OptionEntry.html</anchorfile>
      <anchor>af18b1584aedc0f26f406334b4840be84</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="variable">
      <type>enum Glib::OptionEntry::Flags</type>
      <name>GOptionFlags</name>
      <anchorfile>classGlib_1_1OptionEntry.html</anchorfile>
      <anchor>a309fc51cdc8e6815b034e8255a4e7852</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>GOptionEntry *</type>
      <name>gobject_</name>
      <anchorfile>classGlib_1_1OptionEntry.html</anchorfile>
      <anchor>ae69569ab0df3c4f00261d7b5d3230721</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glib::OptionGroup</name>
    <filename>classGlib_1_1OptionGroup.html</filename>
    <member kind="typedef">
      <type>std::vector&lt; Glib::ustring &gt;</type>
      <name>vecustrings</name>
      <anchorfile>classGlib_1_1OptionGroup.html</anchorfile>
      <anchor>a138f22b58260f1150ba6a1b177944732</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>std::vector&lt; std::string &gt;</type>
      <name>vecstrings</name>
      <anchorfile>classGlib_1_1OptionGroup.html</anchorfile>
      <anchor>a35ca2f93ada18a71a190f6120ccccbe4</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>OptionGroup</name>
      <anchorfile>classGlib_1_1OptionGroup.html</anchorfile>
      <anchor>ade69f722319b9fa89f310ffecc8f59b5</anchor>
      <arglist>(const Glib::ustring &amp;name, const Glib::ustring &amp;description, const Glib::ustring &amp;help_description=Glib::ustring())</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>OptionGroup</name>
      <anchorfile>classGlib_1_1OptionGroup.html</anchorfile>
      <anchor>aabf5a3a067f992f0fd400bf7906c2f76</anchor>
      <arglist>(GOptionGroup *castitem)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~OptionGroup</name>
      <anchorfile>classGlib_1_1OptionGroup.html</anchorfile>
      <anchor>a101d202836391404add68fe65d7d9767</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>on_pre_parse</name>
      <anchorfile>classGlib_1_1OptionGroup.html</anchorfile>
      <anchor>aaa9f099207de7735453997ad6234c8b8</anchor>
      <arglist>(OptionContext &amp;context, OptionGroup &amp;group)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>on_post_parse</name>
      <anchorfile>classGlib_1_1OptionGroup.html</anchorfile>
      <anchor>abe8a3bc20f23cbc677c042773b6a092f</anchor>
      <arglist>(OptionContext &amp;context, OptionGroup &amp;group)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>on_error</name>
      <anchorfile>classGlib_1_1OptionGroup.html</anchorfile>
      <anchor>a7cdff34c14d75c57e265a416925bad0f</anchor>
      <arglist>(OptionContext &amp;context, OptionGroup &amp;group)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>add_entry</name>
      <anchorfile>classGlib_1_1OptionGroup.html</anchorfile>
      <anchor>abe772a54bbad294d847b77349e86c8e9</anchor>
      <arglist>(const OptionEntry &amp;entry)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>add_entry</name>
      <anchorfile>classGlib_1_1OptionGroup.html</anchorfile>
      <anchor>a21c7501faad777f5fcd0b61d7c4d5395</anchor>
      <arglist>(const OptionEntry &amp;entry, bool &amp;arg)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>add_entry</name>
      <anchorfile>classGlib_1_1OptionGroup.html</anchorfile>
      <anchor>a6d9cf49759c1162a0b6b37284aa62494</anchor>
      <arglist>(const OptionEntry &amp;entry, int &amp;arg)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>add_entry</name>
      <anchorfile>classGlib_1_1OptionGroup.html</anchorfile>
      <anchor>af7741ffa0cec2c9d53ed3db902616a49</anchor>
      <arglist>(const OptionEntry &amp;entry, double &amp;arg)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>add_entry</name>
      <anchorfile>classGlib_1_1OptionGroup.html</anchorfile>
      <anchor>ab30d8b251e06607e8d2ca062609477f3</anchor>
      <arglist>(const OptionEntry &amp;entry, Glib::ustring &amp;arg)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>add_entry_filename</name>
      <anchorfile>classGlib_1_1OptionGroup.html</anchorfile>
      <anchor>a533fdd3d3360a9d3766dcaa60f184aee</anchor>
      <arglist>(const OptionEntry &amp;entry, std::string &amp;arg)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>add_entry</name>
      <anchorfile>classGlib_1_1OptionGroup.html</anchorfile>
      <anchor>af198c0dd532f1635aec904282109f130</anchor>
      <arglist>(const OptionEntry &amp;entry, vecustrings &amp;arg)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>add_entry_filename</name>
      <anchorfile>classGlib_1_1OptionGroup.html</anchorfile>
      <anchor>af983b4762a0ceb7fc884f75ad5234ef8</anchor>
      <arglist>(const OptionEntry &amp;entry, vecstrings &amp;arg)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_translation_domain</name>
      <anchorfile>classGlib_1_1OptionGroup.html</anchorfile>
      <anchor>ade081f34243662912f557521f7175606</anchor>
      <arglist>(const Glib::ustring &amp;domain)</arglist>
    </member>
    <member kind="function">
      <type>GOptionGroup *</type>
      <name>gobj</name>
      <anchorfile>classGlib_1_1OptionGroup.html</anchorfile>
      <anchor>afdf7f68b05a285cc5096a2a342d48bf4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GOptionGroup *</type>
      <name>gobj</name>
      <anchorfile>classGlib_1_1OptionGroup.html</anchorfile>
      <anchor>ab2e09acc9712806287c549263a7ef689</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GOptionGroup *</type>
      <name>gobj_give_ownership</name>
      <anchorfile>classGlib_1_1OptionGroup.html</anchorfile>
      <anchor>a675828be7840ff47c049a700297516e6</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glib::RegexError</name>
    <filename>classGlib_1_1RegexError.html</filename>
    <base>Glib::Error</base>
    <member kind="enumeration">
      <name>Code</name>
      <anchorfile>classGlib_1_1RegexError.html</anchorfile>
      <anchor>a0f1ec693485b5b6c8148045e6ffa3aee</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>COMPILE</name>
      <anchorfile>classGlib_1_1RegexError.html</anchorfile>
      <anchor>a0f1ec693485b5b6c8148045e6ffa3aeeac11a5bc06049b1aa4a29f359d9699311</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>OPTIMIZE</name>
      <anchorfile>classGlib_1_1RegexError.html</anchorfile>
      <anchor>a0f1ec693485b5b6c8148045e6ffa3aeeadb70846fd70476234317a85c25ec1e5c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REPLACE</name>
      <anchorfile>classGlib_1_1RegexError.html</anchorfile>
      <anchor>a0f1ec693485b5b6c8148045e6ffa3aeea964b2c225a4537f809fc16936bc51311</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MATCH</name>
      <anchorfile>classGlib_1_1RegexError.html</anchorfile>
      <anchor>a0f1ec693485b5b6c8148045e6ffa3aeea28b46b9e23b2bf005f3412ea50a89921</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>INTERNAL</name>
      <anchorfile>classGlib_1_1RegexError.html</anchorfile>
      <anchor>a0f1ec693485b5b6c8148045e6ffa3aeeacbbe88b39fff55c68900c886c5b4c207</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>STRAY_BACKSLASH</name>
      <anchorfile>classGlib_1_1RegexError.html</anchorfile>
      <anchor>a0f1ec693485b5b6c8148045e6ffa3aeeab09a150d6a58d66d265a2692336e52d8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MISSING_CONTROL_CHAR</name>
      <anchorfile>classGlib_1_1RegexError.html</anchorfile>
      <anchor>a0f1ec693485b5b6c8148045e6ffa3aeea6ab3f5cb7bd168665596f609c6f6bf30</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNRECOGNIZED_ESCAPE</name>
      <anchorfile>classGlib_1_1RegexError.html</anchorfile>
      <anchor>a0f1ec693485b5b6c8148045e6ffa3aeea33644134a56f87fa49b5d844270ed115</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>QUANTIFIERS_OUT_OF_ORDER</name>
      <anchorfile>classGlib_1_1RegexError.html</anchorfile>
      <anchor>a0f1ec693485b5b6c8148045e6ffa3aeea13d752269e2517ee7c1da6a7d3ccd584</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>QUANTIFIER_TOO_BIG</name>
      <anchorfile>classGlib_1_1RegexError.html</anchorfile>
      <anchor>a0f1ec693485b5b6c8148045e6ffa3aeea24d6bfcc787eea10791c71c794940c32</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNTERMINATED_CHARACTER_CLASS</name>
      <anchorfile>classGlib_1_1RegexError.html</anchorfile>
      <anchor>a0f1ec693485b5b6c8148045e6ffa3aeeab3280ae08c36e2d9aaf300ce0398a4fa</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>INVALID_ESCAPE_IN_CHARACTER_CLASS</name>
      <anchorfile>classGlib_1_1RegexError.html</anchorfile>
      <anchor>a0f1ec693485b5b6c8148045e6ffa3aeea37050b2967a0bb386dc67c103bb7010b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>RANGE_OUT_OF_ORDER</name>
      <anchorfile>classGlib_1_1RegexError.html</anchorfile>
      <anchor>a0f1ec693485b5b6c8148045e6ffa3aeead6b388a8bbcd5ccf8da8eb37710d39ae</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NOTHING_TO_REPEAT</name>
      <anchorfile>classGlib_1_1RegexError.html</anchorfile>
      <anchor>a0f1ec693485b5b6c8148045e6ffa3aeea7e70a821f568e0a377549b4ffb960882</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNRECOGNIZED_CHARACTER</name>
      <anchorfile>classGlib_1_1RegexError.html</anchorfile>
      <anchor>a0f1ec693485b5b6c8148045e6ffa3aeea526bb53f3338d8a54bd24c8746153396</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>POSIX_NAMED_CLASS_OUTSIDE_CLASS</name>
      <anchorfile>classGlib_1_1RegexError.html</anchorfile>
      <anchor>a0f1ec693485b5b6c8148045e6ffa3aeeaa3e8d09cb921d7e27e2bd79191af2564</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNMATCHED_PARENTHESIS</name>
      <anchorfile>classGlib_1_1RegexError.html</anchorfile>
      <anchor>a0f1ec693485b5b6c8148045e6ffa3aeeaffba2d7484326e06d5a914baf701fc6c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>INEXISTENT_SUBPATTERN_REFERENCE</name>
      <anchorfile>classGlib_1_1RegexError.html</anchorfile>
      <anchor>a0f1ec693485b5b6c8148045e6ffa3aeea8fb24662419e3a9a6133af54c4710c29</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNTERMINATED_COMMENT</name>
      <anchorfile>classGlib_1_1RegexError.html</anchorfile>
      <anchor>a0f1ec693485b5b6c8148045e6ffa3aeea8ccdb4a0c2f080a7f9b9b861041905f4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EXPRESSION_TOO_LARGE</name>
      <anchorfile>classGlib_1_1RegexError.html</anchorfile>
      <anchor>a0f1ec693485b5b6c8148045e6ffa3aeea91f45235369ec1cc16730c91b04ef4fb</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MEMORY_ERROR</name>
      <anchorfile>classGlib_1_1RegexError.html</anchorfile>
      <anchor>a0f1ec693485b5b6c8148045e6ffa3aeeaa118cb6d4d3bb626ae3a9bf30d9d3e1f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>VARIABLE_LENGTH_LOOKBEHIND</name>
      <anchorfile>classGlib_1_1RegexError.html</anchorfile>
      <anchor>a0f1ec693485b5b6c8148045e6ffa3aeea5e6a6cbf028bf8b738b3f3a8c245e716</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MALFORMED_CONDITION</name>
      <anchorfile>classGlib_1_1RegexError.html</anchorfile>
      <anchor>a0f1ec693485b5b6c8148045e6ffa3aeea7a1872fdb4f8f4f6cdfbd20621940464</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TOO_MANY_CONDITIONAL_BRANCHES</name>
      <anchorfile>classGlib_1_1RegexError.html</anchorfile>
      <anchor>a0f1ec693485b5b6c8148045e6ffa3aeea306ed7e26afbc0033dfcb6a9165d1fab</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ASSERTION_EXPECTED</name>
      <anchorfile>classGlib_1_1RegexError.html</anchorfile>
      <anchor>a0f1ec693485b5b6c8148045e6ffa3aeea4fd6136d54e278a286c940115a96e269</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNKNOWN_POSIX_CLASS_NAME</name>
      <anchorfile>classGlib_1_1RegexError.html</anchorfile>
      <anchor>a0f1ec693485b5b6c8148045e6ffa3aeeaf294d16429ddf572e9ec823d48316f31</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>POSIX_COLLATING_ELEMENTS_NOT_SUPPORTED</name>
      <anchorfile>classGlib_1_1RegexError.html</anchorfile>
      <anchor>a0f1ec693485b5b6c8148045e6ffa3aeea0fdf31394ac2b038b4f03bb6c865125b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>HEX_CODE_TOO_LARGE</name>
      <anchorfile>classGlib_1_1RegexError.html</anchorfile>
      <anchor>a0f1ec693485b5b6c8148045e6ffa3aeeafc09d459086b1defaeacd98061e90688</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>INVALID_CONDITION</name>
      <anchorfile>classGlib_1_1RegexError.html</anchorfile>
      <anchor>a0f1ec693485b5b6c8148045e6ffa3aeea8f51cca8f5b24f262bb8d441b1d13df5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SINGLE_BYTE_MATCH_IN_LOOKBEHIND</name>
      <anchorfile>classGlib_1_1RegexError.html</anchorfile>
      <anchor>a0f1ec693485b5b6c8148045e6ffa3aeeaa5e256f27139c4e0797e72bc1b0558dc</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>INFINITE_LOOP</name>
      <anchorfile>classGlib_1_1RegexError.html</anchorfile>
      <anchor>a0f1ec693485b5b6c8148045e6ffa3aeeacd23493cf9362c3ffb4e362555068202</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MISSING_SUBPATTERN_NAME_TERMINATOR</name>
      <anchorfile>classGlib_1_1RegexError.html</anchorfile>
      <anchor>a0f1ec693485b5b6c8148045e6ffa3aeeafb1ca877c760c4ce5c18e8431018547a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DUPLICATE_SUBPATTERN_NAME</name>
      <anchorfile>classGlib_1_1RegexError.html</anchorfile>
      <anchor>a0f1ec693485b5b6c8148045e6ffa3aeead4db2fafc63aa0903c5f1b5162dfe144</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MALFORMED_PROPERTY</name>
      <anchorfile>classGlib_1_1RegexError.html</anchorfile>
      <anchor>a0f1ec693485b5b6c8148045e6ffa3aeea873ce37b67fc7c09ae809d7b69b9e995</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNKNOWN_PROPERTY</name>
      <anchorfile>classGlib_1_1RegexError.html</anchorfile>
      <anchor>a0f1ec693485b5b6c8148045e6ffa3aeea5dc05a927bfb03177be6b8e02110a56d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SUBPATTERN_NAME_TOO_LONG</name>
      <anchorfile>classGlib_1_1RegexError.html</anchorfile>
      <anchor>a0f1ec693485b5b6c8148045e6ffa3aeeac3a68206322e6a29fed5f226ad6a1363</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TOO_MANY_SUBPATTERNS</name>
      <anchorfile>classGlib_1_1RegexError.html</anchorfile>
      <anchor>a0f1ec693485b5b6c8148045e6ffa3aeeae721479a6010c73363237f3e1fe9593a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>INVALID_OCTAL_VALUE</name>
      <anchorfile>classGlib_1_1RegexError.html</anchorfile>
      <anchor>a0f1ec693485b5b6c8148045e6ffa3aeea3637d2d1401f99319f36fdd7b93fa4cc</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TOO_MANY_BRANCHES_IN_DEFINE</name>
      <anchorfile>classGlib_1_1RegexError.html</anchorfile>
      <anchor>a0f1ec693485b5b6c8148045e6ffa3aeea9fb84562d9b50996ced63b50cec435ed</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DEFINE_REPETION</name>
      <anchorfile>classGlib_1_1RegexError.html</anchorfile>
      <anchor>a0f1ec693485b5b6c8148045e6ffa3aeea5dab0875b3b65a3137a4de2fc8ebebfd</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>INCONSISTENT_NEWLINE_OPTIONS</name>
      <anchorfile>classGlib_1_1RegexError.html</anchorfile>
      <anchor>a0f1ec693485b5b6c8148045e6ffa3aeea4ba4eaee2bb95111513ae76be9293b41</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MISSING_BACK_REFERENCE</name>
      <anchorfile>classGlib_1_1RegexError.html</anchorfile>
      <anchor>a0f1ec693485b5b6c8148045e6ffa3aeeaf89dea2fbfb11afb96019ba07b527176</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>RegexError</name>
      <anchorfile>classGlib_1_1RegexError.html</anchorfile>
      <anchor>a817d8fc1cd64ac013e8a971134880103</anchor>
      <arglist>(Code error_code, const Glib::ustring &amp;error_message)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>RegexError</name>
      <anchorfile>classGlib_1_1RegexError.html</anchorfile>
      <anchor>addb3a6d45d66c56a3b4a53aa4b188f02</anchor>
      <arglist>(GError *gobject)</arglist>
    </member>
    <member kind="function">
      <type>Code</type>
      <name>code</name>
      <anchorfile>classGlib_1_1RegexError.html</anchorfile>
      <anchor>ae8797270b48b55796c372a6f97c193cf</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glib::Regex</name>
    <filename>classGlib_1_1Regex.html</filename>
    <member kind="function">
      <type>void</type>
      <name>reference</name>
      <anchorfile>classGlib_1_1Regex.html</anchorfile>
      <anchor>a6099ec7a4be34e4fec017a9d18eeb7f4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unreference</name>
      <anchorfile>classGlib_1_1Regex.html</anchorfile>
      <anchor>a661a9b85f52dbaaa68a6495ace7df50a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GRegex *</type>
      <name>gobj</name>
      <anchorfile>classGlib_1_1Regex.html</anchorfile>
      <anchor>a640d1c5b6bc6ff05461dbf11b97e4477</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GRegex *</type>
      <name>gobj</name>
      <anchorfile>classGlib_1_1Regex.html</anchorfile>
      <anchor>ae5c9e3ee8fd94e728128ff8eacb138c1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GRegex *</type>
      <name>gobj_copy</name>
      <anchorfile>classGlib_1_1Regex.html</anchorfile>
      <anchor>a6766b1090ea2e97757a5585aca14f926</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_pattern</name>
      <anchorfile>classGlib_1_1Regex.html</anchorfile>
      <anchor>a802f0517b6bb5d72e55bc1dcaa8174a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>get_max_backref</name>
      <anchorfile>classGlib_1_1Regex.html</anchorfile>
      <anchor>ac7123b6f880561ff94134c808a254387</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>get_capture_count</name>
      <anchorfile>classGlib_1_1Regex.html</anchorfile>
      <anchor>a891b0f5b73a2beb390330778a0114c94</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>get_string_number</name>
      <anchorfile>classGlib_1_1Regex.html</anchorfile>
      <anchor>a033e3e0480fc5904d307f06a35e3240b</anchor>
      <arglist>(const Glib::ustring &amp;name) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>match</name>
      <anchorfile>classGlib_1_1Regex.html</anchorfile>
      <anchor>ad19516ab8cbcad727a159160a50bf26e</anchor>
      <arglist>(const Glib::ustring &amp;string, RegexMatchFlags match_options=static_cast&lt; RegexMatchFlags &gt;(0))</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>match</name>
      <anchorfile>classGlib_1_1Regex.html</anchorfile>
      <anchor>acbbd6f902b679b6b34554099a2ef67ef</anchor>
      <arglist>(const Glib::ustring &amp;string, int start_position, RegexMatchFlags match_options)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>match</name>
      <anchorfile>classGlib_1_1Regex.html</anchorfile>
      <anchor>a6e0224ad096ba88c94e6e648a619f163</anchor>
      <arglist>(const Glib::ustring &amp;string, gssize string_len, int start_position, RegexMatchFlags match_options)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>match_all</name>
      <anchorfile>classGlib_1_1Regex.html</anchorfile>
      <anchor>a8e2a2daa7f18c41ca37080cdd4842fae</anchor>
      <arglist>(const Glib::ustring &amp;string, RegexMatchFlags match_options=static_cast&lt; RegexMatchFlags &gt;(0))</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>match_all</name>
      <anchorfile>classGlib_1_1Regex.html</anchorfile>
      <anchor>adf0dc5f15631c6a090c5724bfa71f4bf</anchor>
      <arglist>(const Glib::ustring &amp;string, int start_position, RegexMatchFlags match_options)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>match_all</name>
      <anchorfile>classGlib_1_1Regex.html</anchorfile>
      <anchor>a2e393570c407f42cbf4e223fab19f499</anchor>
      <arglist>(const Glib::ustring &amp;string, gssize string_len, int start_position, RegexMatchFlags match_options)</arglist>
    </member>
    <member kind="function">
      <type>Glib::StringArrayHandle</type>
      <name>split</name>
      <anchorfile>classGlib_1_1Regex.html</anchorfile>
      <anchor>a447bbb8dc8ca457d1c1a4ab0740ced7e</anchor>
      <arglist>(const Glib::ustring &amp;string, RegexMatchFlags match_options=static_cast&lt; RegexMatchFlags &gt;(0))</arglist>
    </member>
    <member kind="function">
      <type>Glib::StringArrayHandle</type>
      <name>split</name>
      <anchorfile>classGlib_1_1Regex.html</anchorfile>
      <anchor>ace0220e0ed2d7bd7771030e360e5141f</anchor>
      <arglist>(const gchar *string, gssize string_len, int start_position, RegexMatchFlags match_options=static_cast&lt; RegexMatchFlags &gt;(0), int max_tokens=0) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::StringArrayHandle</type>
      <name>split</name>
      <anchorfile>classGlib_1_1Regex.html</anchorfile>
      <anchor>a3f2f68542607519a358dd0ada1b5e3d5</anchor>
      <arglist>(const Glib::ustring &amp;string, int start_position, RegexMatchFlags match_options, int max_tokens) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>replace</name>
      <anchorfile>classGlib_1_1Regex.html</anchorfile>
      <anchor>ae9f40c233d33361814252f8bfb00a716</anchor>
      <arglist>(const gchar *string, gssize string_len, int start_position, const Glib::ustring &amp;replacement, RegexMatchFlags match_options=static_cast&lt; RegexMatchFlags &gt;(0))</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>replace</name>
      <anchorfile>classGlib_1_1Regex.html</anchorfile>
      <anchor>add3848dcec1b22547ab57fddbfdaec1d</anchor>
      <arglist>(const Glib::ustring &amp;string, int start_position, const Glib::ustring &amp;replacement, RegexMatchFlags match_options)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>replace_literal</name>
      <anchorfile>classGlib_1_1Regex.html</anchorfile>
      <anchor>a4bccbbffa1c84249b35201ee6e6f39c9</anchor>
      <arglist>(const gchar *string, gssize string_len, int start_position, const Glib::ustring &amp;replacement, RegexMatchFlags match_options=static_cast&lt; RegexMatchFlags &gt;(0))</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>replace_literal</name>
      <anchorfile>classGlib_1_1Regex.html</anchorfile>
      <anchor>a6660f8fcf2ec8a6e90a7ecc85ced0e2a</anchor>
      <arglist>(const Glib::ustring &amp;string, int start_position, const Glib::ustring &amp;replacement, RegexMatchFlags match_options)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>replace_eval</name>
      <anchorfile>classGlib_1_1Regex.html</anchorfile>
      <anchor>ac5a2cf889ebf233c5d467b3816c8d533</anchor>
      <arglist>(const Glib::ustring &amp;string, gssize string_len, int start_position, RegexMatchFlags match_options, GRegexEvalCallback eval, gpointer user_data)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Glib::Regex &gt;</type>
      <name>create</name>
      <anchorfile>classGlib_1_1Regex.html</anchorfile>
      <anchor>a09d723a3b495453399d9f685b528727a</anchor>
      <arglist>(const Glib::ustring &amp;pattern, RegexCompileFlags compile_options=static_cast&lt; RegexCompileFlags &gt;(0), RegexMatchFlags match_options=static_cast&lt; RegexMatchFlags &gt;(0))</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::ustring</type>
      <name>escape_string</name>
      <anchorfile>classGlib_1_1Regex.html</anchorfile>
      <anchor>abc2c9b4f7d042a125d0d65fb16b71ff1</anchor>
      <arglist>(const Glib::ustring &amp;string)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static bool</type>
      <name>match_simple</name>
      <anchorfile>classGlib_1_1Regex.html</anchorfile>
      <anchor>a74905e31f14819b84c9e9cb53c79ca6c</anchor>
      <arglist>(const Glib::ustring &amp;pattern, const Glib::ustring &amp;string, RegexCompileFlags compile_options=static_cast&lt; RegexCompileFlags &gt;(0), RegexMatchFlags match_options=static_cast&lt; RegexMatchFlags &gt;(0))</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::StringArrayHandle</type>
      <name>split_simple</name>
      <anchorfile>classGlib_1_1Regex.html</anchorfile>
      <anchor>aa0911a410fa5295667d54e900cce7f10</anchor>
      <arglist>(const Glib::ustring &amp;pattern, const Glib::ustring &amp;string, RegexCompileFlags compile_options=static_cast&lt; RegexCompileFlags &gt;(0), RegexMatchFlags match_options=static_cast&lt; RegexMatchFlags &gt;(0))</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static bool</type>
      <name>check_replacement</name>
      <anchorfile>classGlib_1_1Regex.html</anchorfile>
      <anchor>a54071d7bdd63db75099445fe0c84580c</anchor>
      <arglist>(const Glib::ustring &amp;replacement, gboolean *has_references)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Regex</name>
      <anchorfile>classGlib_1_1Regex.html</anchorfile>
      <anchor>ad4d1d89ce7ff8a5b9294e9d8035319a8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>operator delete</name>
      <anchorfile>classGlib_1_1Regex.html</anchorfile>
      <anchor>afd2c035dacc69786e469f56db2ea3899</anchor>
      <arglist>(void *, size_t)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Glib::Regex &gt;</type>
      <name>wrap</name>
      <anchorfile>classGlib_1_1Regex.html</anchorfile>
      <anchor>aa502a39684fb9d59dc689da8bb9d9da8</anchor>
      <arglist>(GRegex *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glib::ShellError</name>
    <filename>classGlib_1_1ShellError.html</filename>
    <base>Glib::Error</base>
    <member kind="enumeration">
      <name>Code</name>
      <anchorfile>classGlib_1_1ShellError.html</anchorfile>
      <anchor>ae36e02f4bf8e48d4fe678b30b5300435</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>BAD_QUOTING</name>
      <anchorfile>classGlib_1_1ShellError.html</anchorfile>
      <anchor>ae36e02f4bf8e48d4fe678b30b5300435a87a1f1990f15ec29470015c546099f15</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EMPTY_STRING</name>
      <anchorfile>classGlib_1_1ShellError.html</anchorfile>
      <anchor>ae36e02f4bf8e48d4fe678b30b5300435af5f165fd69f79da629715dd146065b3a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FAILED</name>
      <anchorfile>classGlib_1_1ShellError.html</anchorfile>
      <anchor>ae36e02f4bf8e48d4fe678b30b5300435a26b92b828bad17cb4bf1fba0ea6b51d8</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>ShellError</name>
      <anchorfile>classGlib_1_1ShellError.html</anchorfile>
      <anchor>a2ad6bcad67427196b05b0be32703d148</anchor>
      <arglist>(Code error_code, const Glib::ustring &amp;error_message)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>ShellError</name>
      <anchorfile>classGlib_1_1ShellError.html</anchorfile>
      <anchor>a3398d25526f1c1262c754320e815ba32</anchor>
      <arglist>(GError *gobject)</arglist>
    </member>
    <member kind="function">
      <type>Code</type>
      <name>code</name>
      <anchorfile>classGlib_1_1ShellError.html</anchorfile>
      <anchor>af6494bba8a72c2aed2687f226f9cbacb</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glib::SpawnError</name>
    <filename>classGlib_1_1SpawnError.html</filename>
    <base>Glib::Error</base>
    <member kind="enumeration">
      <name>Code</name>
      <anchorfile>classGlib_1_1SpawnError.html</anchorfile>
      <anchor>afb7753661f7b0607951aa8881380ed1b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FORK</name>
      <anchorfile>classGlib_1_1SpawnError.html</anchorfile>
      <anchor>afb7753661f7b0607951aa8881380ed1baab272f8c8364b7fe1f2c1f9ce6a4d932</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>READ</name>
      <anchorfile>classGlib_1_1SpawnError.html</anchorfile>
      <anchor>afb7753661f7b0607951aa8881380ed1ba37ffd619ad4510d59b4649b2fa049f2e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>CHDIR</name>
      <anchorfile>classGlib_1_1SpawnError.html</anchorfile>
      <anchor>afb7753661f7b0607951aa8881380ed1bac5eac452082cfe3028beff42b0d6b691</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ACCES</name>
      <anchorfile>classGlib_1_1SpawnError.html</anchorfile>
      <anchor>afb7753661f7b0607951aa8881380ed1ba10d4616b0b9d9d15fc578b1f8d24bd7e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PERM</name>
      <anchorfile>classGlib_1_1SpawnError.html</anchorfile>
      <anchor>afb7753661f7b0607951aa8881380ed1badb86e737d1aad71dd6532ac538f597ba</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TOOBIG</name>
      <anchorfile>classGlib_1_1SpawnError.html</anchorfile>
      <anchor>afb7753661f7b0607951aa8881380ed1baa54cc8357ae3549f0a9632150abc79c8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NOEXEC</name>
      <anchorfile>classGlib_1_1SpawnError.html</anchorfile>
      <anchor>afb7753661f7b0607951aa8881380ed1ba6c56a0a76b5c1592a9f27360b6185198</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NAMETOOLONG</name>
      <anchorfile>classGlib_1_1SpawnError.html</anchorfile>
      <anchor>afb7753661f7b0607951aa8881380ed1ba935d2d515caf353cc72e3d83fe6ca73f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NOENT</name>
      <anchorfile>classGlib_1_1SpawnError.html</anchorfile>
      <anchor>afb7753661f7b0607951aa8881380ed1ba3f2b31be9ce24ed5ab81b7bcbdaa692f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NOMEM</name>
      <anchorfile>classGlib_1_1SpawnError.html</anchorfile>
      <anchor>afb7753661f7b0607951aa8881380ed1baf4ec02a278d149f15c321a08f178d9f1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NOTDIR</name>
      <anchorfile>classGlib_1_1SpawnError.html</anchorfile>
      <anchor>afb7753661f7b0607951aa8881380ed1bab036aa59800c9cc46f7f77589a834972</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>LOOP</name>
      <anchorfile>classGlib_1_1SpawnError.html</anchorfile>
      <anchor>afb7753661f7b0607951aa8881380ed1bace672c6e10f2d3d902556bbec469ef79</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TXTBUSY</name>
      <anchorfile>classGlib_1_1SpawnError.html</anchorfile>
      <anchor>afb7753661f7b0607951aa8881380ed1baa4c93d16fd3f7325c7a5c28dba3bc3ff</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO</name>
      <anchorfile>classGlib_1_1SpawnError.html</anchorfile>
      <anchor>afb7753661f7b0607951aa8881380ed1ba945a3a6fefecec1a9117e3c004ac7b29</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NFILE</name>
      <anchorfile>classGlib_1_1SpawnError.html</anchorfile>
      <anchor>afb7753661f7b0607951aa8881380ed1bacf9724846be21b1bf67459439d70e7ea</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MFILE</name>
      <anchorfile>classGlib_1_1SpawnError.html</anchorfile>
      <anchor>afb7753661f7b0607951aa8881380ed1ba26fed21264f3d266ecf7717bd95a9d3a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>INVAL</name>
      <anchorfile>classGlib_1_1SpawnError.html</anchorfile>
      <anchor>afb7753661f7b0607951aa8881380ed1bafa94e4842081fb87483c95de9d3eb73e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ISDIR</name>
      <anchorfile>classGlib_1_1SpawnError.html</anchorfile>
      <anchor>afb7753661f7b0607951aa8881380ed1bacd5f1c45eae2de57269e5eeb0c56fd5e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>LIBBAD</name>
      <anchorfile>classGlib_1_1SpawnError.html</anchorfile>
      <anchor>afb7753661f7b0607951aa8881380ed1ba663c56fe66788d6a294f435d7f9824f6</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SpawnError</name>
      <anchorfile>classGlib_1_1SpawnError.html</anchorfile>
      <anchor>a29eb55d60f444f4d84e1a505defa2a10</anchor>
      <arglist>(Code error_code, const Glib::ustring &amp;error_message)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SpawnError</name>
      <anchorfile>classGlib_1_1SpawnError.html</anchorfile>
      <anchor>a7a3b357b3521a7f28c1517429d57eb31</anchor>
      <arglist>(GError *gobject)</arglist>
    </member>
    <member kind="function">
      <type>Code</type>
      <name>code</name>
      <anchorfile>classGlib_1_1SpawnError.html</anchorfile>
      <anchor>a42aa5204c37243835eb2c51df579b610</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glib::ThreadError</name>
    <filename>classGlib_1_1ThreadError.html</filename>
    <base>Glib::Error</base>
    <member kind="enumeration">
      <name>Code</name>
      <anchorfile>classGlib_1_1ThreadError.html</anchorfile>
      <anchor>a6b42834d5d29377db4aa1c4a79f63952</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>AGAIN</name>
      <anchorfile>classGlib_1_1ThreadError.html</anchorfile>
      <anchor>a6b42834d5d29377db4aa1c4a79f63952a77b06db0f346d5946ff02dbbb9b629a5</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>ThreadError</name>
      <anchorfile>classGlib_1_1ThreadError.html</anchorfile>
      <anchor>aac882a2e31fd93acfb341ca0ed3f1192</anchor>
      <arglist>(Code error_code, const Glib::ustring &amp;error_message)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>ThreadError</name>
      <anchorfile>classGlib_1_1ThreadError.html</anchorfile>
      <anchor>a51e5c3c760bfa1b7867a29eb1637ea1f</anchor>
      <arglist>(GError *gobject)</arglist>
    </member>
    <member kind="function">
      <type>Code</type>
      <name>code</name>
      <anchorfile>classGlib_1_1ThreadError.html</anchorfile>
      <anchor>a6a73deb2a8ea71fb40bc5b93ba2dda56</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glib::Thread</name>
    <filename>classGlib_1_1Thread.html</filename>
    <class kind="class">Glib::Thread::Exit</class>
    <member kind="function">
      <type>bool</type>
      <name>joinable</name>
      <anchorfile>classGlib_1_1Thread.html</anchorfile>
      <anchor>a9feee4b860d9928f86b9d255e2f2b133</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>join</name>
      <anchorfile>classGlib_1_1Thread.html</anchorfile>
      <anchor>ab95e51699279fd84c9577c45d76b0d8e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_priority</name>
      <anchorfile>classGlib_1_1Thread.html</anchorfile>
      <anchor>a3b323f981147d7eb4b4bd03f3fbdccf5</anchor>
      <arglist>(ThreadPriority priority)</arglist>
    </member>
    <member kind="function">
      <type>ThreadPriority</type>
      <name>get_priority</name>
      <anchorfile>classGlib_1_1Thread.html</anchorfile>
      <anchor>a28d1bcf53d846b8b0d75b93178a614ab</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GThread *</type>
      <name>gobj</name>
      <anchorfile>classGlib_1_1Thread.html</anchorfile>
      <anchor>a28fbc6c46928a90d82114fa9b6b63196</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GThread *</type>
      <name>gobj</name>
      <anchorfile>classGlib_1_1Thread.html</anchorfile>
      <anchor>a351fa5fb621a394e28037c4f50ab69ad</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Thread *</type>
      <name>create</name>
      <anchorfile>classGlib_1_1Thread.html</anchorfile>
      <anchor>ab165854ff2fc9b454ee4d97050485782</anchor>
      <arglist>(const sigc::slot&lt; void &gt; &amp;slot, bool joinable)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Thread *</type>
      <name>create</name>
      <anchorfile>classGlib_1_1Thread.html</anchorfile>
      <anchor>af30a7a8b037c7c7a3802aa2a22cf612d</anchor>
      <arglist>(const sigc::slot&lt; void &gt; &amp;slot, unsigned long stack_size, bool joinable, bool bound, ThreadPriority priority)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Thread *</type>
      <name>self</name>
      <anchorfile>classGlib_1_1Thread.html</anchorfile>
      <anchor>a9db6864c35701b1c179f48217ab76cca</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>yield</name>
      <anchorfile>classGlib_1_1Thread.html</anchorfile>
      <anchor>acad8be7a8093ef3aca32344264461011</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Thread *</type>
      <name>wrap</name>
      <anchorfile>group__Threads.html</anchorfile>
      <anchor>ga6bfbb3119eaac9fa8cb725aa1e82f61e</anchor>
      <arglist>(GThread *gobject)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glib::Thread::Exit</name>
    <filename>classGlib_1_1Thread_1_1Exit.html</filename>
  </compound>
  <compound kind="struct">
    <name>Glib::StaticMutex</name>
    <filename>structGlib_1_1StaticMutex.html</filename>
    <member kind="function">
      <type>void</type>
      <name>lock</name>
      <anchorfile>structGlib_1_1StaticMutex.html</anchorfile>
      <anchor>a7052b89e18e8c7fa2c987dc429a01296</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>trylock</name>
      <anchorfile>structGlib_1_1StaticMutex.html</anchorfile>
      <anchor>a874e22be27896359ecb4008cd6e6f8ab</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unlock</name>
      <anchorfile>structGlib_1_1StaticMutex.html</anchorfile>
      <anchor>a539181ea215c00c84e90d4f7a0131e4d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>operator Mutex &amp;</name>
      <anchorfile>structGlib_1_1StaticMutex.html</anchorfile>
      <anchor>a144e7de846446e2ce1740adc7bf0dc9a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GStaticMutex *</type>
      <name>gobj</name>
      <anchorfile>structGlib_1_1StaticMutex.html</anchorfile>
      <anchor>a381d25917d27c665d3db638b4aa8b743</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="define">
      <type></type>
      <name>GLIBMM_STATIC_MUTEX_INIT</name>
      <anchorfile>structGlib_1_1StaticMutex.html</anchorfile>
      <anchor>ae6c90ef370e11fbbe9f0cf8fa295dd0b</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glib::Mutex</name>
    <filename>classGlib_1_1Mutex.html</filename>
    <class kind="class">Glib::Mutex::Lock</class>
    <member kind="function">
      <type></type>
      <name>Mutex</name>
      <anchorfile>classGlib_1_1Mutex.html</anchorfile>
      <anchor>a0e529e72691cbab324f7c70110d95031</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~Mutex</name>
      <anchorfile>classGlib_1_1Mutex.html</anchorfile>
      <anchor>ac1a701f93ad62d97f9c34e98b6b3f7be</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>lock</name>
      <anchorfile>classGlib_1_1Mutex.html</anchorfile>
      <anchor>abd565d2c03dbd7526729b8e56ecc675e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>trylock</name>
      <anchorfile>classGlib_1_1Mutex.html</anchorfile>
      <anchor>aa564c753a2e51994c3faee2b1d8c903c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unlock</name>
      <anchorfile>classGlib_1_1Mutex.html</anchorfile>
      <anchor>a254d550a0e2197d46fa7268475f19824</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GMutex *</type>
      <name>gobj</name>
      <anchorfile>classGlib_1_1Mutex.html</anchorfile>
      <anchor>affe6aea5c5044a51422dd08f2dc06d98</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glib::Mutex::Lock</name>
    <filename>classGlib_1_1Mutex_1_1Lock.html</filename>
    <member kind="function">
      <type></type>
      <name>Lock</name>
      <anchorfile>classGlib_1_1Mutex_1_1Lock.html</anchorfile>
      <anchor>ab203085bd7e2fa065f2e770ff501882e</anchor>
      <arglist>(Mutex &amp;mutex)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Lock</name>
      <anchorfile>classGlib_1_1Mutex_1_1Lock.html</anchorfile>
      <anchor>a613aa058601c9f05d5663cfc005093a8</anchor>
      <arglist>(Mutex &amp;mutex, NotLock)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Lock</name>
      <anchorfile>classGlib_1_1Mutex_1_1Lock.html</anchorfile>
      <anchor>ae795f9ed3b07389eb856be7610362cde</anchor>
      <arglist>(Mutex &amp;mutex, TryLock)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~Lock</name>
      <anchorfile>classGlib_1_1Mutex_1_1Lock.html</anchorfile>
      <anchor>a84f0589eee0654ec60f6773ca9336752</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>acquire</name>
      <anchorfile>classGlib_1_1Mutex_1_1Lock.html</anchorfile>
      <anchor>a1f892502061ae908452f7eb0ac920065</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>try_acquire</name>
      <anchorfile>classGlib_1_1Mutex_1_1Lock.html</anchorfile>
      <anchor>af2c4e590e2c7f3820df5a4fa8293f280</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>release</name>
      <anchorfile>classGlib_1_1Mutex_1_1Lock.html</anchorfile>
      <anchor>ac5bfb4e0c5adf5787c5d5570acc1a25c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>locked</name>
      <anchorfile>classGlib_1_1Mutex_1_1Lock.html</anchorfile>
      <anchor>a5cfe52efbd461ff26ecb9b4dc76cb9bd</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>Glib::StaticRecMutex</name>
    <filename>structGlib_1_1StaticRecMutex.html</filename>
    <member kind="function">
      <type>void</type>
      <name>lock</name>
      <anchorfile>structGlib_1_1StaticRecMutex.html</anchorfile>
      <anchor>af318bffd84f77b39dbfe65bf654c265b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>trylock</name>
      <anchorfile>structGlib_1_1StaticRecMutex.html</anchorfile>
      <anchor>ad59351bd8e600907511b9ed8a693c1ff</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unlock</name>
      <anchorfile>structGlib_1_1StaticRecMutex.html</anchorfile>
      <anchor>aed1a4127138ac49d4d7f2c27da7c236b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>lock_full</name>
      <anchorfile>structGlib_1_1StaticRecMutex.html</anchorfile>
      <anchor>a9c1fbb797f5e0b72b885186e67ae6ebd</anchor>
      <arglist>(unsigned int depth)</arglist>
    </member>
    <member kind="function">
      <type>unsigned int</type>
      <name>unlock_full</name>
      <anchorfile>structGlib_1_1StaticRecMutex.html</anchorfile>
      <anchor>a380a6ae88b358e5b8661a7e765b19e8e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>operator RecMutex &amp;</name>
      <anchorfile>structGlib_1_1StaticRecMutex.html</anchorfile>
      <anchor>a8fbcf435aeb1c8797f7f4584cf06e0e6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GStaticRecMutex *</type>
      <name>gobj</name>
      <anchorfile>structGlib_1_1StaticRecMutex.html</anchorfile>
      <anchor>afc0c434e6d72bc3260346d79e8dd5588</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="define">
      <type></type>
      <name>GLIBMM_STATIC_REC_MUTEX_INIT</name>
      <anchorfile>structGlib_1_1StaticRecMutex.html</anchorfile>
      <anchor>a7bf8f07d9998d8852e5e7632ef908f68</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glib::RecMutex</name>
    <filename>classGlib_1_1RecMutex.html</filename>
    <base>Glib::StaticRecMutex</base>
    <class kind="class">Glib::RecMutex::Lock</class>
    <member kind="function">
      <type></type>
      <name>RecMutex</name>
      <anchorfile>classGlib_1_1RecMutex.html</anchorfile>
      <anchor>a91462697c0142d75e0b6fe7c3ddb751a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~RecMutex</name>
      <anchorfile>classGlib_1_1RecMutex.html</anchorfile>
      <anchor>adee3de2eb61684af89e311ab6b940473</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glib::RecMutex::Lock</name>
    <filename>classGlib_1_1RecMutex_1_1Lock.html</filename>
    <member kind="function">
      <type></type>
      <name>Lock</name>
      <anchorfile>classGlib_1_1RecMutex_1_1Lock.html</anchorfile>
      <anchor>a7648e1bd74aa9c4a3eadcee85790d24e</anchor>
      <arglist>(RecMutex &amp;mutex)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Lock</name>
      <anchorfile>classGlib_1_1RecMutex_1_1Lock.html</anchorfile>
      <anchor>a8c1f4e93c943c7778b525b3e0911ef91</anchor>
      <arglist>(RecMutex &amp;mutex, NotLock)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Lock</name>
      <anchorfile>classGlib_1_1RecMutex_1_1Lock.html</anchorfile>
      <anchor>a128643b7286fe5ef281c05955991d74c</anchor>
      <arglist>(RecMutex &amp;mutex, TryLock)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~Lock</name>
      <anchorfile>classGlib_1_1RecMutex_1_1Lock.html</anchorfile>
      <anchor>a71c88960ca417bd926a5a037f6f1808c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>acquire</name>
      <anchorfile>classGlib_1_1RecMutex_1_1Lock.html</anchorfile>
      <anchor>abcdab81c9e753579247652bca0cb4116</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>try_acquire</name>
      <anchorfile>classGlib_1_1RecMutex_1_1Lock.html</anchorfile>
      <anchor>a47ee33f9ea131e215acb8eaa5f47b4c5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>release</name>
      <anchorfile>classGlib_1_1RecMutex_1_1Lock.html</anchorfile>
      <anchor>a480a9e87a8e8ce59faf09487ded6bdcc</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>locked</name>
      <anchorfile>classGlib_1_1RecMutex_1_1Lock.html</anchorfile>
      <anchor>acf1b4168f46b15425251e053087b0b8d</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>Glib::StaticRWLock</name>
    <filename>structGlib_1_1StaticRWLock.html</filename>
    <member kind="function">
      <type>void</type>
      <name>reader_lock</name>
      <anchorfile>structGlib_1_1StaticRWLock.html</anchorfile>
      <anchor>af80746638d6252c24243fcf3159d15ec</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>reader_trylock</name>
      <anchorfile>structGlib_1_1StaticRWLock.html</anchorfile>
      <anchor>a1cf789f9ffd606ad71d0e8fd13578708</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>reader_unlock</name>
      <anchorfile>structGlib_1_1StaticRWLock.html</anchorfile>
      <anchor>ad5aae43bc4a3c632823bfc81fe8a70cb</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writer_lock</name>
      <anchorfile>structGlib_1_1StaticRWLock.html</anchorfile>
      <anchor>a9cd606ef6f61488478d92ffc02ae0b2f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>writer_trylock</name>
      <anchorfile>structGlib_1_1StaticRWLock.html</anchorfile>
      <anchor>ae6e4e019daf5f307a5c1be6ee20953a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writer_unlock</name>
      <anchorfile>structGlib_1_1StaticRWLock.html</anchorfile>
      <anchor>a3ee12daec94dc696956fcd7b89265b5a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>operator RWLock &amp;</name>
      <anchorfile>structGlib_1_1StaticRWLock.html</anchorfile>
      <anchor>a91c0f044b25a8ac53ef46ce08ac73c9e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GStaticRWLock *</type>
      <name>gobj</name>
      <anchorfile>structGlib_1_1StaticRWLock.html</anchorfile>
      <anchor>a4714a65b490f29119d021cecb4931e02</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="define">
      <type></type>
      <name>GLIBMM_STATIC_RW_LOCK_INIT</name>
      <anchorfile>structGlib_1_1StaticRWLock.html</anchorfile>
      <anchor>ac075558893159f342830e8d3df59c6eb</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glib::RWLock</name>
    <filename>classGlib_1_1RWLock.html</filename>
    <base>Glib::StaticRWLock</base>
    <class kind="class">Glib::RWLock::ReaderLock</class>
    <class kind="class">Glib::RWLock::WriterLock</class>
    <member kind="function">
      <type></type>
      <name>RWLock</name>
      <anchorfile>classGlib_1_1RWLock.html</anchorfile>
      <anchor>a71bb74cd3035b4abf617a10cfc50b723</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~RWLock</name>
      <anchorfile>classGlib_1_1RWLock.html</anchorfile>
      <anchor>acb72fd652e847296b580f796bb82fa36</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glib::RWLock::ReaderLock</name>
    <filename>classGlib_1_1RWLock_1_1ReaderLock.html</filename>
    <member kind="function">
      <type></type>
      <name>ReaderLock</name>
      <anchorfile>classGlib_1_1RWLock_1_1ReaderLock.html</anchorfile>
      <anchor>a3ec567d55a84fb8ddf5892ae8adf5a6f</anchor>
      <arglist>(RWLock &amp;rwlock)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>ReaderLock</name>
      <anchorfile>classGlib_1_1RWLock_1_1ReaderLock.html</anchorfile>
      <anchor>aa22f3de258861a7c9cfbf2c420bf60d8</anchor>
      <arglist>(RWLock &amp;rwlock, NotLock)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>ReaderLock</name>
      <anchorfile>classGlib_1_1RWLock_1_1ReaderLock.html</anchorfile>
      <anchor>af3f9ffabd993ae5cc40f91afb673e96d</anchor>
      <arglist>(RWLock &amp;rwlock, TryLock)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~ReaderLock</name>
      <anchorfile>classGlib_1_1RWLock_1_1ReaderLock.html</anchorfile>
      <anchor>afa8de82014987c3834dea5142642402a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>acquire</name>
      <anchorfile>classGlib_1_1RWLock_1_1ReaderLock.html</anchorfile>
      <anchor>ae36282c4d009bf76910d37c5b010cc7c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>try_acquire</name>
      <anchorfile>classGlib_1_1RWLock_1_1ReaderLock.html</anchorfile>
      <anchor>ad30060213dc44abf4b3cfed6ad6fe2ea</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>release</name>
      <anchorfile>classGlib_1_1RWLock_1_1ReaderLock.html</anchorfile>
      <anchor>a6859ec0e0caf92a7f3da8c96b9e22082</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>locked</name>
      <anchorfile>classGlib_1_1RWLock_1_1ReaderLock.html</anchorfile>
      <anchor>a4d2188db0b43037dc7353385a6869e5f</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glib::RWLock::WriterLock</name>
    <filename>classGlib_1_1RWLock_1_1WriterLock.html</filename>
    <member kind="function">
      <type></type>
      <name>WriterLock</name>
      <anchorfile>classGlib_1_1RWLock_1_1WriterLock.html</anchorfile>
      <anchor>a5aca4e3617470e59344f4c7f64b226ab</anchor>
      <arglist>(RWLock &amp;rwlock)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>WriterLock</name>
      <anchorfile>classGlib_1_1RWLock_1_1WriterLock.html</anchorfile>
      <anchor>a8eaaeaf2e0979b8032600c0a1144bf46</anchor>
      <arglist>(RWLock &amp;rwlock, NotLock)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>WriterLock</name>
      <anchorfile>classGlib_1_1RWLock_1_1WriterLock.html</anchorfile>
      <anchor>aa662238d1b2026823bcfafaf1f9b63d4</anchor>
      <arglist>(RWLock &amp;rwlock, TryLock)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~WriterLock</name>
      <anchorfile>classGlib_1_1RWLock_1_1WriterLock.html</anchorfile>
      <anchor>a47bfa749496840f33b7f8451eb637850</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>acquire</name>
      <anchorfile>classGlib_1_1RWLock_1_1WriterLock.html</anchorfile>
      <anchor>ae508867d3b32dc73deab37cd5d785f4a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>try_acquire</name>
      <anchorfile>classGlib_1_1RWLock_1_1WriterLock.html</anchorfile>
      <anchor>a597521878f1829509119c5b76ad96032</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>release</name>
      <anchorfile>classGlib_1_1RWLock_1_1WriterLock.html</anchorfile>
      <anchor>af8028a0eaebcebc1d71e2658e6b66b7f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>locked</name>
      <anchorfile>classGlib_1_1RWLock_1_1WriterLock.html</anchorfile>
      <anchor>a2e6e9c3ffb9280efccd3b1523d6fcf6f</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glib::Cond</name>
    <filename>classGlib_1_1Cond.html</filename>
    <member kind="function">
      <type></type>
      <name>Cond</name>
      <anchorfile>classGlib_1_1Cond.html</anchorfile>
      <anchor>a2182b1171de3bdd0b97ab2f16d88a17a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~Cond</name>
      <anchorfile>classGlib_1_1Cond.html</anchorfile>
      <anchor>a67919ec3f33e19185f72d9c1a0043605</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>signal</name>
      <anchorfile>classGlib_1_1Cond.html</anchorfile>
      <anchor>a072cb37a06a695b54370209bc3280f4d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>broadcast</name>
      <anchorfile>classGlib_1_1Cond.html</anchorfile>
      <anchor>a2ed0ec9fc4e29140f8854a05bfb5df3b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>wait</name>
      <anchorfile>classGlib_1_1Cond.html</anchorfile>
      <anchor>ae989bf2891954ff5ed745f447cdccf2a</anchor>
      <arglist>(Mutex &amp;mutex)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>timed_wait</name>
      <anchorfile>classGlib_1_1Cond.html</anchorfile>
      <anchor>acb37b09bf04ae36e30ec32c2f3d4af69</anchor>
      <arglist>(Mutex &amp;mutex, const Glib::TimeVal &amp;abs_time)</arglist>
    </member>
    <member kind="function">
      <type>GCond *</type>
      <name>gobj</name>
      <anchorfile>classGlib_1_1Cond.html</anchorfile>
      <anchor>a27a794031bc8a6c104db3b9977254c61</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>Glib::StaticPrivate</name>
    <filename>structGlib_1_1StaticPrivate.html</filename>
    <templarg></templarg>
    <member kind="typedef">
      <type>void(*</type>
      <name>DestroyNotifyFunc</name>
      <anchorfile>structGlib_1_1StaticPrivate.html</anchorfile>
      <anchor>a271c1862566ae25cc81642040847fadb</anchor>
      <arglist>)(void *)</arglist>
    </member>
    <member kind="function">
      <type>T *</type>
      <name>get</name>
      <anchorfile>structGlib_1_1StaticPrivate.html</anchorfile>
      <anchor>ad208b161d8e65e26ab559da7a306e1ed</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set</name>
      <anchorfile>structGlib_1_1StaticPrivate.html</anchorfile>
      <anchor>a35d07a85ca83076789c2dcb268d6c25d</anchor>
      <arglist>(T *data, DestroyNotifyFunc notify_func=&amp;StaticPrivate&lt; T &gt;::delete_ptr)</arglist>
    </member>
    <member kind="function">
      <type>GStaticPrivate *</type>
      <name>gobj</name>
      <anchorfile>structGlib_1_1StaticPrivate.html</anchorfile>
      <anchor>abfc8325b959a71497571c53c37141d58</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>delete_ptr</name>
      <anchorfile>structGlib_1_1StaticPrivate.html</anchorfile>
      <anchor>a6c230680af925b13a85ce8507549ab76</anchor>
      <arglist>(void *data)</arglist>
    </member>
    <member kind="define">
      <type></type>
      <name>GLIBMM_STATIC_PRIVATE_INIT</name>
      <anchorfile>structGlib_1_1StaticPrivate.html</anchorfile>
      <anchor>afdbb70766398f948bc346fef14f1a53f</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glib::Private</name>
    <filename>classGlib_1_1Private.html</filename>
    <templarg></templarg>
    <member kind="typedef">
      <type>void(*</type>
      <name>DestructorFunc</name>
      <anchorfile>classGlib_1_1Private.html</anchorfile>
      <anchor>aa98c1daee2c349a4ff6173843351a6fb</anchor>
      <arglist>)(void *)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Private</name>
      <anchorfile>classGlib_1_1Private.html</anchorfile>
      <anchor>a398953b6c89edf91b5b1be28f453006d</anchor>
      <arglist>(DestructorFunc destructor_func=&amp;Private&lt; T &gt;::delete_ptr)</arglist>
    </member>
    <member kind="function">
      <type>T *</type>
      <name>get</name>
      <anchorfile>classGlib_1_1Private.html</anchorfile>
      <anchor>a7d643790e7724ef7f63ca0b2f9309768</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set</name>
      <anchorfile>classGlib_1_1Private.html</anchorfile>
      <anchor>a7e4636b15cd3f43010fadea300791dd2</anchor>
      <arglist>(T *data)</arglist>
    </member>
    <member kind="function">
      <type>GPrivate *</type>
      <name>gobj</name>
      <anchorfile>classGlib_1_1Private.html</anchorfile>
      <anchor>abc4b19a17ca795b2878b5fd5a14f6fc9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>delete_ptr</name>
      <anchorfile>classGlib_1_1Private.html</anchorfile>
      <anchor>ac98db7269b43438fb45313092ee80cb6</anchor>
      <arglist>(void *data)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glib::ValueArray</name>
    <filename>classGlib_1_1ValueArray.html</filename>
    <member kind="typedef">
      <type>sigc::slot&lt; int, const Glib::ValueBase &amp;, const Glib::ValueBase &amp; &gt;</type>
      <name>SlotCompare</name>
      <anchorfile>classGlib_1_1ValueArray.html</anchorfile>
      <anchor>ad4c19ec101b806a29cc3ab3f2c8ddd41</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>ValueArray</name>
      <anchorfile>classGlib_1_1ValueArray.html</anchorfile>
      <anchor>aa403923648ca619054e4c8b8be1bb801</anchor>
      <arglist>(GValueArray *gobject, bool make_a_copy=true)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>ValueArray</name>
      <anchorfile>classGlib_1_1ValueArray.html</anchorfile>
      <anchor>a5edd2ac638c259f60fd99bb48b95bdc6</anchor>
      <arglist>(const ValueArray &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>ValueArray &amp;</type>
      <name>operator=</name>
      <anchorfile>classGlib_1_1ValueArray.html</anchorfile>
      <anchor>aff63102ffe3754919ac79b0dcb8588bf</anchor>
      <arglist>(const ValueArray &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~ValueArray</name>
      <anchorfile>classGlib_1_1ValueArray.html</anchorfile>
      <anchor>a5faaac10ee8876d546e4c86e5c37db7e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>swap</name>
      <anchorfile>classGlib_1_1ValueArray.html</anchorfile>
      <anchor>ad273ae0b8f05b91c78f0d372cf273bb3</anchor>
      <arglist>(ValueArray &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>GValueArray *</type>
      <name>gobj</name>
      <anchorfile>classGlib_1_1ValueArray.html</anchorfile>
      <anchor>a5ba764739af03092ea3bfebdf3bdc079</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GValueArray *</type>
      <name>gobj</name>
      <anchorfile>classGlib_1_1ValueArray.html</anchorfile>
      <anchor>a5c9dfbd4b5088750a7d141621122f348</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GValueArray *</type>
      <name>gobj_copy</name>
      <anchorfile>classGlib_1_1ValueArray.html</anchorfile>
      <anchor>a55215a65d59dfeff744b4cdc1695a37b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>ValueArray</name>
      <anchorfile>classGlib_1_1ValueArray.html</anchorfile>
      <anchor>a8bdecaaa39e7f8159637768e495bfa5c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>ValueArray</name>
      <anchorfile>classGlib_1_1ValueArray.html</anchorfile>
      <anchor>a836e8fb2bc4e0c5dd4030599ae7f1ffa</anchor>
      <arglist>(guint n_preallocated)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_nth</name>
      <anchorfile>classGlib_1_1ValueArray.html</anchorfile>
      <anchor>a2c32fe81f5d6cdf3040b8e621b02b02d</anchor>
      <arglist>(guint index, Glib::ValueBase &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ValueArray &amp;</type>
      <name>append</name>
      <anchorfile>classGlib_1_1ValueArray.html</anchorfile>
      <anchor>abe238a2bc7c967a0941a416f1caa650d</anchor>
      <arglist>(const Glib::ValueBase &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ValueArray &amp;</type>
      <name>prepend</name>
      <anchorfile>classGlib_1_1ValueArray.html</anchorfile>
      <anchor>af7c30ee85c708e917cb4f0779a0ca31c</anchor>
      <arglist>(const Glib::ValueBase &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ValueArray &amp;</type>
      <name>insert</name>
      <anchorfile>classGlib_1_1ValueArray.html</anchorfile>
      <anchor>a14fa8d4fa2bba2386ae79bbe816f1c42</anchor>
      <arglist>(guint index, const Glib::ValueBase &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ValueArray &amp;</type>
      <name>remove</name>
      <anchorfile>classGlib_1_1ValueArray.html</anchorfile>
      <anchor>a30dd7f25f52351968e88c545bbf911c8</anchor>
      <arglist>(guint index)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ValueArray &amp;</type>
      <name>sort</name>
      <anchorfile>classGlib_1_1ValueArray.html</anchorfile>
      <anchor>aa62247fd9a4574141f09814affe8ab8f</anchor>
      <arglist>(const SlotCompare &amp;compare_func)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>GValueArray *</type>
      <name>gobject_</name>
      <anchorfile>classGlib_1_1ValueArray.html</anchorfile>
      <anchor>a9b4925a477575dacae2507e5c57ed6bd</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>Glib::ValueArray</type>
      <name>wrap</name>
      <anchorfile>classGlib_1_1ValueArray.html</anchorfile>
      <anchor>ad7bd84e60b7a67eb393a76b7da88d937</anchor>
      <arglist>(GValueArray *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glib::SignalProxyBase</name>
    <filename>classGlib_1_1SignalProxyBase.html</filename>
    <member kind="function">
      <type></type>
      <name>SignalProxyBase</name>
      <anchorfile>classGlib_1_1SignalProxyBase.html</anchorfile>
      <anchor>af340b9d05531bbf31e50d3b0ec6dec06</anchor>
      <arglist>(Glib::ObjectBase *obj)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>ObjectBase *</type>
      <name>obj_</name>
      <anchorfile>classGlib_1_1SignalProxyBase.html</anchorfile>
      <anchor>af0a2ac9d830f483801c24d551e1eb57c</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glib::SignalProxyNormal</name>
    <filename>classGlib_1_1SignalProxyNormal.html</filename>
    <base>Glib::SignalProxyBase</base>
    <member kind="function">
      <type></type>
      <name>~SignalProxyNormal</name>
      <anchorfile>classGlib_1_1SignalProxyNormal.html</anchorfile>
      <anchor>acb9ee0a3481abefb01456306c640a8c5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>emission_stop</name>
      <anchorfile>classGlib_1_1SignalProxyNormal.html</anchorfile>
      <anchor>a8142f5d5f986aea2ce8bfb22d8d38cf2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>SignalProxyNormal</name>
      <anchorfile>classGlib_1_1SignalProxyNormal.html</anchorfile>
      <anchor>a17cc3a55165dfbf0b2681aace390e82c</anchor>
      <arglist>(Glib::ObjectBase *obj, const SignalProxyInfo *info)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>sigc::slot_base &amp;</type>
      <name>connect_</name>
      <anchorfile>classGlib_1_1SignalProxyNormal.html</anchorfile>
      <anchor>a051e24c3af5f41c269351d49a8d3a1aa</anchor>
      <arglist>(const sigc::slot_base &amp;slot, bool after)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>sigc::slot_base &amp;</type>
      <name>connect_notify_</name>
      <anchorfile>classGlib_1_1SignalProxyNormal.html</anchorfile>
      <anchor>a2b05fbe06539c4fb26e2afc7fb2b8bc6</anchor>
      <arglist>(const sigc::slot_base &amp;slot, bool after)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glib::SignalProxy0</name>
    <filename>classGlib_1_1SignalProxy0.html</filename>
    <templarg></templarg>
    <base>Glib::SignalProxyNormal</base>
    <member kind="typedef">
      <type>sigc::slot&lt; R &gt;</type>
      <name>SlotType</name>
      <anchorfile>classGlib_1_1SignalProxy0.html</anchorfile>
      <anchor>aa4300c4457e00ddea67b8acabfeabba2</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>sigc::slot&lt; void &gt;</type>
      <name>VoidSlotType</name>
      <anchorfile>classGlib_1_1SignalProxy0.html</anchorfile>
      <anchor>aac0788d3e60fb9447c3a7609a106dc4e</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SignalProxy0</name>
      <anchorfile>classGlib_1_1SignalProxy0.html</anchorfile>
      <anchor>a315e1db5a8d1b5bab0c505b5450d964a</anchor>
      <arglist>(ObjectBase *obj, const SignalProxyInfo *info)</arglist>
    </member>
    <member kind="function">
      <type>sigc::connection</type>
      <name>connect</name>
      <anchorfile>classGlib_1_1SignalProxy0.html</anchorfile>
      <anchor>ad6c26072ea85fe6e61895b0750421e92</anchor>
      <arglist>(const SlotType &amp;slot, bool after=true)</arglist>
    </member>
    <member kind="function">
      <type>sigc::connection</type>
      <name>connect_notify</name>
      <anchorfile>classGlib_1_1SignalProxy0.html</anchorfile>
      <anchor>a90322c64ca5a87ad417b54e03d0fece6</anchor>
      <arglist>(const VoidSlotType &amp;slot, bool after=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glib::SignalProxy1</name>
    <filename>classGlib_1_1SignalProxy1.html</filename>
    <templarg></templarg>
    <templarg></templarg>
    <base>Glib::SignalProxyNormal</base>
    <member kind="typedef">
      <type>sigc::slot&lt; R, P1 &gt;</type>
      <name>SlotType</name>
      <anchorfile>classGlib_1_1SignalProxy1.html</anchorfile>
      <anchor>a74fd55d7458f04ca1fbb90710f50b664</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>sigc::slot&lt; void, P1 &gt;</type>
      <name>VoidSlotType</name>
      <anchorfile>classGlib_1_1SignalProxy1.html</anchorfile>
      <anchor>a415fd197f0d86750931a1c48ed4c284f</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SignalProxy1</name>
      <anchorfile>classGlib_1_1SignalProxy1.html</anchorfile>
      <anchor>a2dd1136fffb5f33c26a6d8d5018b3580</anchor>
      <arglist>(ObjectBase *obj, const SignalProxyInfo *info)</arglist>
    </member>
    <member kind="function">
      <type>sigc::connection</type>
      <name>connect</name>
      <anchorfile>classGlib_1_1SignalProxy1.html</anchorfile>
      <anchor>a22fdfb42d11a9a838bc50377e7c9e1a6</anchor>
      <arglist>(const SlotType &amp;slot, bool after=true)</arglist>
    </member>
    <member kind="function">
      <type>sigc::connection</type>
      <name>connect_notify</name>
      <anchorfile>classGlib_1_1SignalProxy1.html</anchorfile>
      <anchor>a1dd40d7c3475124bb78053805fbde3f8</anchor>
      <arglist>(const VoidSlotType &amp;slot, bool after=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glib::SignalProxy2</name>
    <filename>classGlib_1_1SignalProxy2.html</filename>
    <templarg></templarg>
    <templarg></templarg>
    <templarg></templarg>
    <base>Glib::SignalProxyNormal</base>
    <member kind="typedef">
      <type>sigc::slot&lt; R, P1, P2 &gt;</type>
      <name>SlotType</name>
      <anchorfile>classGlib_1_1SignalProxy2.html</anchorfile>
      <anchor>a7fd887895fb7faaafd71497222d8b895</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>sigc::slot&lt; void, P1, P2 &gt;</type>
      <name>VoidSlotType</name>
      <anchorfile>classGlib_1_1SignalProxy2.html</anchorfile>
      <anchor>aa3768003cbf85e170e5268ce0153cc28</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SignalProxy2</name>
      <anchorfile>classGlib_1_1SignalProxy2.html</anchorfile>
      <anchor>acc63a503d2e03b7fead353796a16aa4a</anchor>
      <arglist>(ObjectBase *obj, const SignalProxyInfo *info)</arglist>
    </member>
    <member kind="function">
      <type>sigc::connection</type>
      <name>connect</name>
      <anchorfile>classGlib_1_1SignalProxy2.html</anchorfile>
      <anchor>a66b5747c9db52041b508bc889ff36fcb</anchor>
      <arglist>(const SlotType &amp;slot, bool after=true)</arglist>
    </member>
    <member kind="function">
      <type>sigc::connection</type>
      <name>connect_notify</name>
      <anchorfile>classGlib_1_1SignalProxy2.html</anchorfile>
      <anchor>af3711e737bbcbce60105da0c54d573d1</anchor>
      <arglist>(const VoidSlotType &amp;slot, bool after=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glib::SignalProxy3</name>
    <filename>classGlib_1_1SignalProxy3.html</filename>
    <templarg></templarg>
    <templarg></templarg>
    <templarg></templarg>
    <templarg></templarg>
    <base>Glib::SignalProxyNormal</base>
    <member kind="typedef">
      <type>sigc::slot&lt; R, P1, P2, P3 &gt;</type>
      <name>SlotType</name>
      <anchorfile>classGlib_1_1SignalProxy3.html</anchorfile>
      <anchor>ab5d5438ce6ed3166b6c52d25846c81c8</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>sigc::slot&lt; void, P1, P2, P3 &gt;</type>
      <name>VoidSlotType</name>
      <anchorfile>classGlib_1_1SignalProxy3.html</anchorfile>
      <anchor>a42233030672ff6bec3c0dafd2a8466d4</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SignalProxy3</name>
      <anchorfile>classGlib_1_1SignalProxy3.html</anchorfile>
      <anchor>a3b4115c9c7c64a716232900dfdcfcde5</anchor>
      <arglist>(ObjectBase *obj, const SignalProxyInfo *info)</arglist>
    </member>
    <member kind="function">
      <type>sigc::connection</type>
      <name>connect</name>
      <anchorfile>classGlib_1_1SignalProxy3.html</anchorfile>
      <anchor>a1787ab4cf55c107e3cf89c76b1f080b5</anchor>
      <arglist>(const SlotType &amp;slot, bool after=true)</arglist>
    </member>
    <member kind="function">
      <type>sigc::connection</type>
      <name>connect_notify</name>
      <anchorfile>classGlib_1_1SignalProxy3.html</anchorfile>
      <anchor>a7c36c3b4bae5eaed0eb6268abab7b247</anchor>
      <arglist>(const VoidSlotType &amp;slot, bool after=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glib::SignalProxy4</name>
    <filename>classGlib_1_1SignalProxy4.html</filename>
    <templarg></templarg>
    <templarg></templarg>
    <templarg></templarg>
    <templarg></templarg>
    <templarg></templarg>
    <base>Glib::SignalProxyNormal</base>
    <member kind="typedef">
      <type>sigc::slot&lt; R, P1, P2, P3, P4 &gt;</type>
      <name>SlotType</name>
      <anchorfile>classGlib_1_1SignalProxy4.html</anchorfile>
      <anchor>ac2e60a471ecf54d19180816735c4d4c3</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>sigc::slot&lt; void, P1, P2, P3, P4 &gt;</type>
      <name>VoidSlotType</name>
      <anchorfile>classGlib_1_1SignalProxy4.html</anchorfile>
      <anchor>a048515fb890163551ff6394f1a8086e2</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SignalProxy4</name>
      <anchorfile>classGlib_1_1SignalProxy4.html</anchorfile>
      <anchor>a45e43eedffc2d6e4590032a1b2970a92</anchor>
      <arglist>(ObjectBase *obj, const SignalProxyInfo *info)</arglist>
    </member>
    <member kind="function">
      <type>sigc::connection</type>
      <name>connect</name>
      <anchorfile>classGlib_1_1SignalProxy4.html</anchorfile>
      <anchor>aba46198055c59fe77a23f9aeb73bd6e9</anchor>
      <arglist>(const SlotType &amp;slot, bool after=true)</arglist>
    </member>
    <member kind="function">
      <type>sigc::connection</type>
      <name>connect_notify</name>
      <anchorfile>classGlib_1_1SignalProxy4.html</anchorfile>
      <anchor>ad0a0c683c2a4e6cb6256e8394d74858e</anchor>
      <arglist>(const VoidSlotType &amp;slot, bool after=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glib::SignalProxy5</name>
    <filename>classGlib_1_1SignalProxy5.html</filename>
    <templarg></templarg>
    <templarg></templarg>
    <templarg></templarg>
    <templarg></templarg>
    <templarg></templarg>
    <templarg></templarg>
    <base>Glib::SignalProxyNormal</base>
    <member kind="typedef">
      <type>sigc::slot&lt; R, P1, P2, P3, P4, P5 &gt;</type>
      <name>SlotType</name>
      <anchorfile>classGlib_1_1SignalProxy5.html</anchorfile>
      <anchor>a3034ac856495c243c3605228295e19da</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>sigc::slot&lt; void, P1, P2, P3, P4, P5 &gt;</type>
      <name>VoidSlotType</name>
      <anchorfile>classGlib_1_1SignalProxy5.html</anchorfile>
      <anchor>a269a9b11fa49a786f93d874c5d69d705</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SignalProxy5</name>
      <anchorfile>classGlib_1_1SignalProxy5.html</anchorfile>
      <anchor>a66342621153089f9ba317d42277a8ffd</anchor>
      <arglist>(ObjectBase *obj, const SignalProxyInfo *info)</arglist>
    </member>
    <member kind="function">
      <type>sigc::connection</type>
      <name>connect</name>
      <anchorfile>classGlib_1_1SignalProxy5.html</anchorfile>
      <anchor>aeb7dfcbe15052cec862881d007860a88</anchor>
      <arglist>(const SlotType &amp;slot, bool after=true)</arglist>
    </member>
    <member kind="function">
      <type>sigc::connection</type>
      <name>connect_notify</name>
      <anchorfile>classGlib_1_1SignalProxy5.html</anchorfile>
      <anchor>a742cf5ed309d74f225017c1c0a73b511</anchor>
      <arglist>(const VoidSlotType &amp;slot, bool after=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glib::SignalProxy6</name>
    <filename>classGlib_1_1SignalProxy6.html</filename>
    <templarg></templarg>
    <templarg></templarg>
    <templarg></templarg>
    <templarg></templarg>
    <templarg></templarg>
    <templarg></templarg>
    <templarg></templarg>
    <base>Glib::SignalProxyNormal</base>
    <member kind="typedef">
      <type>sigc::slot&lt; R, P1, P2, P3, P4, P5, P6 &gt;</type>
      <name>SlotType</name>
      <anchorfile>classGlib_1_1SignalProxy6.html</anchorfile>
      <anchor>aae4a380b85f13a825abb7ebc6a256925</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>sigc::slot&lt; void, P1, P2, P3, P4, P5, P6 &gt;</type>
      <name>VoidSlotType</name>
      <anchorfile>classGlib_1_1SignalProxy6.html</anchorfile>
      <anchor>a6ec6f095e6f25507cf5a9ef924dccdbe</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SignalProxy6</name>
      <anchorfile>classGlib_1_1SignalProxy6.html</anchorfile>
      <anchor>a8f10bc1c1fd13b5413c7c7329ce1da05</anchor>
      <arglist>(ObjectBase *obj, const SignalProxyInfo *info)</arglist>
    </member>
    <member kind="function">
      <type>sigc::connection</type>
      <name>connect</name>
      <anchorfile>classGlib_1_1SignalProxy6.html</anchorfile>
      <anchor>a9c812f443964c3ccee3ff1b3af20c15f</anchor>
      <arglist>(const SlotType &amp;slot, bool after=true)</arglist>
    </member>
    <member kind="function">
      <type>sigc::connection</type>
      <name>connect_notify</name>
      <anchorfile>classGlib_1_1SignalProxy6.html</anchorfile>
      <anchor>accd447826dc93315aec8a764dc3785d4</anchor>
      <arglist>(const VoidSlotType &amp;slot, bool after=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glib::Value&lt; bool &gt;</name>
    <filename>classGlib_1_1Value_3_01bool_01_4.html</filename>
    <base>Glib::ValueBase</base>
    <member kind="typedef">
      <type>bool</type>
      <name>CppType</name>
      <anchorfile>classGlib_1_1Value_3_01bool_01_4.html</anchorfile>
      <anchor>ae88fb44930dbc920dac73e65c99e730c</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>gboolean</type>
      <name>CType</name>
      <anchorfile>classGlib_1_1Value_3_01bool_01_4.html</anchorfile>
      <anchor>a03e98e6b149669bab502ab2b40430125</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set</name>
      <anchorfile>classGlib_1_1Value_3_01bool_01_4.html</anchorfile>
      <anchor>a9fbbbc99675113812fad12fdda11a0f2</anchor>
      <arglist>(bool data)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get</name>
      <anchorfile>classGlib_1_1Value_3_01bool_01_4.html</anchorfile>
      <anchor>ac15f58528e1d076a95864787c1a5798f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static GType</type>
      <name>value_type</name>
      <anchorfile>classGlib_1_1Value_3_01bool_01_4.html</anchorfile>
      <anchor>a66381d27357321419bfe1b3f15ec1f8b</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glib::Value&lt; char &gt;</name>
    <filename>classGlib_1_1Value_3_01char_01_4.html</filename>
    <base>Glib::ValueBase</base>
    <member kind="typedef">
      <type>char</type>
      <name>CppType</name>
      <anchorfile>classGlib_1_1Value_3_01char_01_4.html</anchorfile>
      <anchor>ace3fb1ef40b0bb9bd7531b29fd7c23c4</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>gchar</type>
      <name>CType</name>
      <anchorfile>classGlib_1_1Value_3_01char_01_4.html</anchorfile>
      <anchor>aa73240b41e9a7a5070d059cf48998b54</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set</name>
      <anchorfile>classGlib_1_1Value_3_01char_01_4.html</anchorfile>
      <anchor>a2de97ae867d772bdb9da89e1359217bc</anchor>
      <arglist>(char data)</arglist>
    </member>
    <member kind="function">
      <type>char</type>
      <name>get</name>
      <anchorfile>classGlib_1_1Value_3_01char_01_4.html</anchorfile>
      <anchor>a4d7b34e59b6c4794068cc81c0e9fa451</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static GType</type>
      <name>value_type</name>
      <anchorfile>classGlib_1_1Value_3_01char_01_4.html</anchorfile>
      <anchor>aa3d698cb7af0a5ca27e462370a66971e</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glib::Value&lt; unsigned char &gt;</name>
    <filename>classGlib_1_1Value_3_01unsigned_01char_01_4.html</filename>
    <base>Glib::ValueBase</base>
    <member kind="typedef">
      <type>unsigned char</type>
      <name>CppType</name>
      <anchorfile>classGlib_1_1Value_3_01unsigned_01char_01_4.html</anchorfile>
      <anchor>a12690f5fdde4602c8be31f5641671d79</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>guchar</type>
      <name>CType</name>
      <anchorfile>classGlib_1_1Value_3_01unsigned_01char_01_4.html</anchorfile>
      <anchor>aa6e944a254862b4172ffb2f73f164b20</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set</name>
      <anchorfile>classGlib_1_1Value_3_01unsigned_01char_01_4.html</anchorfile>
      <anchor>aab3178311695a913986d7e7741f65ccc</anchor>
      <arglist>(unsigned char data)</arglist>
    </member>
    <member kind="function">
      <type>unsigned char</type>
      <name>get</name>
      <anchorfile>classGlib_1_1Value_3_01unsigned_01char_01_4.html</anchorfile>
      <anchor>ad9052868813c9a91b8f74e98aafc8cf2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static GType</type>
      <name>value_type</name>
      <anchorfile>classGlib_1_1Value_3_01unsigned_01char_01_4.html</anchorfile>
      <anchor>ac697709ac8d7a4ccfb19d79e69c3739d</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glib::Value&lt; int &gt;</name>
    <filename>classGlib_1_1Value_3_01int_01_4.html</filename>
    <base>Glib::ValueBase</base>
    <member kind="typedef">
      <type>int</type>
      <name>CppType</name>
      <anchorfile>classGlib_1_1Value_3_01int_01_4.html</anchorfile>
      <anchor>a488f430153510c8234488c2616fbab8c</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>gint</type>
      <name>CType</name>
      <anchorfile>classGlib_1_1Value_3_01int_01_4.html</anchorfile>
      <anchor>aa49fa1442738ee32438f57060a5c5495</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set</name>
      <anchorfile>classGlib_1_1Value_3_01int_01_4.html</anchorfile>
      <anchor>abd4c8e675046c0010591b10116c9e3aa</anchor>
      <arglist>(int data)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>get</name>
      <anchorfile>classGlib_1_1Value_3_01int_01_4.html</anchorfile>
      <anchor>a11ee320cab4dd4d8b16a76764cbc1a2f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static GType</type>
      <name>value_type</name>
      <anchorfile>classGlib_1_1Value_3_01int_01_4.html</anchorfile>
      <anchor>a3cae9644d1b1b7f70391ee14bb3b7478</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glib::Value&lt; unsigned int &gt;</name>
    <filename>classGlib_1_1Value_3_01unsigned_01int_01_4.html</filename>
    <base>Glib::ValueBase</base>
    <member kind="typedef">
      <type>unsigned int</type>
      <name>CppType</name>
      <anchorfile>classGlib_1_1Value_3_01unsigned_01int_01_4.html</anchorfile>
      <anchor>a9f4c47503ccda8cc3cb8df5ba53ef4dc</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>guint</type>
      <name>CType</name>
      <anchorfile>classGlib_1_1Value_3_01unsigned_01int_01_4.html</anchorfile>
      <anchor>a3bc327c92170cb334e4ed7c0e95f4ac4</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set</name>
      <anchorfile>classGlib_1_1Value_3_01unsigned_01int_01_4.html</anchorfile>
      <anchor>ac3fda3995e4a33f71f359785d8fa8a88</anchor>
      <arglist>(unsigned int data)</arglist>
    </member>
    <member kind="function">
      <type>unsigned int</type>
      <name>get</name>
      <anchorfile>classGlib_1_1Value_3_01unsigned_01int_01_4.html</anchorfile>
      <anchor>a6cc745b3b9d106ea2a4f5ccb5eb16722</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static GType</type>
      <name>value_type</name>
      <anchorfile>classGlib_1_1Value_3_01unsigned_01int_01_4.html</anchorfile>
      <anchor>a31035397d045545690e68a1a08619b6a</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glib::Value&lt; long &gt;</name>
    <filename>classGlib_1_1Value_3_01long_01_4.html</filename>
    <base>Glib::ValueBase</base>
    <member kind="typedef">
      <type>long</type>
      <name>CppType</name>
      <anchorfile>classGlib_1_1Value_3_01long_01_4.html</anchorfile>
      <anchor>a2438871713d4f6fa942cf5321bfc543a</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>glong</type>
      <name>CType</name>
      <anchorfile>classGlib_1_1Value_3_01long_01_4.html</anchorfile>
      <anchor>a5acd60426eb1c8237812342aa115f856</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set</name>
      <anchorfile>classGlib_1_1Value_3_01long_01_4.html</anchorfile>
      <anchor>a8e572e84d90bf91abfb7dd5b476e5b9e</anchor>
      <arglist>(long data)</arglist>
    </member>
    <member kind="function">
      <type>long</type>
      <name>get</name>
      <anchorfile>classGlib_1_1Value_3_01long_01_4.html</anchorfile>
      <anchor>a948ae4d98cf20efe9bc7ac30686af7a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static GType</type>
      <name>value_type</name>
      <anchorfile>classGlib_1_1Value_3_01long_01_4.html</anchorfile>
      <anchor>a330f13a348fd72f361642380a19bf60f</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glib::Value&lt; unsigned long &gt;</name>
    <filename>classGlib_1_1Value_3_01unsigned_01long_01_4.html</filename>
    <base>Glib::ValueBase</base>
    <member kind="typedef">
      <type>unsigned long</type>
      <name>CppType</name>
      <anchorfile>classGlib_1_1Value_3_01unsigned_01long_01_4.html</anchorfile>
      <anchor>a356e9890b6eefb45260c0ad4cfb731f6</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>gulong</type>
      <name>CType</name>
      <anchorfile>classGlib_1_1Value_3_01unsigned_01long_01_4.html</anchorfile>
      <anchor>ac21b6d7d6e739939ccd318c9449f8ab3</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set</name>
      <anchorfile>classGlib_1_1Value_3_01unsigned_01long_01_4.html</anchorfile>
      <anchor>a89a290484aa20b8299a66b1023e8f135</anchor>
      <arglist>(unsigned long data)</arglist>
    </member>
    <member kind="function">
      <type>unsigned long</type>
      <name>get</name>
      <anchorfile>classGlib_1_1Value_3_01unsigned_01long_01_4.html</anchorfile>
      <anchor>a9b4981d84a70b62e440c5c91e217aed8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static GType</type>
      <name>value_type</name>
      <anchorfile>classGlib_1_1Value_3_01unsigned_01long_01_4.html</anchorfile>
      <anchor>a6abf2858362e23a94500242db4ad957c</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glib::Value&lt; long long &gt;</name>
    <filename>classGlib_1_1Value_3_01long_01long_01_4.html</filename>
    <base>Glib::ValueBase</base>
    <member kind="typedef">
      <type>long long</type>
      <name>CppType</name>
      <anchorfile>classGlib_1_1Value_3_01long_01long_01_4.html</anchorfile>
      <anchor>abc1c49c64d34fc457730f6da71c02b8d</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>gint64</type>
      <name>CType</name>
      <anchorfile>classGlib_1_1Value_3_01long_01long_01_4.html</anchorfile>
      <anchor>a35059c27560d29558671037cc7a7eca6</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set</name>
      <anchorfile>classGlib_1_1Value_3_01long_01long_01_4.html</anchorfile>
      <anchor>a5f9d39c582e8eebccddf95614c45a8a6</anchor>
      <arglist>(long long data)</arglist>
    </member>
    <member kind="function">
      <type>long long</type>
      <name>get</name>
      <anchorfile>classGlib_1_1Value_3_01long_01long_01_4.html</anchorfile>
      <anchor>a18fb60e520c80f2a7e089ca74d66b9c2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static GType</type>
      <name>value_type</name>
      <anchorfile>classGlib_1_1Value_3_01long_01long_01_4.html</anchorfile>
      <anchor>a93480551d41d8690fbe9207b040f7843</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glib::Value&lt; unsigned long long &gt;</name>
    <filename>classGlib_1_1Value_3_01unsigned_01long_01long_01_4.html</filename>
    <base>Glib::ValueBase</base>
    <member kind="typedef">
      <type>unsigned long long</type>
      <name>CppType</name>
      <anchorfile>classGlib_1_1Value_3_01unsigned_01long_01long_01_4.html</anchorfile>
      <anchor>a56c12feb80208cb23be5caef7db06012</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>guint64</type>
      <name>CType</name>
      <anchorfile>classGlib_1_1Value_3_01unsigned_01long_01long_01_4.html</anchorfile>
      <anchor>a6bc8edb39e7e3ee0b26ee993ebbd7d8a</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set</name>
      <anchorfile>classGlib_1_1Value_3_01unsigned_01long_01long_01_4.html</anchorfile>
      <anchor>a190b1c8b1a2496a9b139d98c465eaffa</anchor>
      <arglist>(unsigned long long data)</arglist>
    </member>
    <member kind="function">
      <type>unsigned long long</type>
      <name>get</name>
      <anchorfile>classGlib_1_1Value_3_01unsigned_01long_01long_01_4.html</anchorfile>
      <anchor>a516c72a7c3c8e215db3fed4ed78d4b74</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static GType</type>
      <name>value_type</name>
      <anchorfile>classGlib_1_1Value_3_01unsigned_01long_01long_01_4.html</anchorfile>
      <anchor>a9a3dd742b5c9c26b883cdd9ee0287f20</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glib::Value&lt; float &gt;</name>
    <filename>classGlib_1_1Value_3_01float_01_4.html</filename>
    <base>Glib::ValueBase</base>
    <member kind="typedef">
      <type>float</type>
      <name>CppType</name>
      <anchorfile>classGlib_1_1Value_3_01float_01_4.html</anchorfile>
      <anchor>a433a5e8f5ef4b7acb5380c4caf8c3ea8</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>gfloat</type>
      <name>CType</name>
      <anchorfile>classGlib_1_1Value_3_01float_01_4.html</anchorfile>
      <anchor>a0be64034f31780a00829318259a5b7f8</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set</name>
      <anchorfile>classGlib_1_1Value_3_01float_01_4.html</anchorfile>
      <anchor>a14489a9eb51ff17ac80f07ecc1ac9c15</anchor>
      <arglist>(float data)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>get</name>
      <anchorfile>classGlib_1_1Value_3_01float_01_4.html</anchorfile>
      <anchor>a7a63eac6755dd38d690ffa0d5d07d13e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static GType</type>
      <name>value_type</name>
      <anchorfile>classGlib_1_1Value_3_01float_01_4.html</anchorfile>
      <anchor>a887a33770700af739023cc24f5bea16c</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glib::Value&lt; double &gt;</name>
    <filename>classGlib_1_1Value_3_01double_01_4.html</filename>
    <base>Glib::ValueBase</base>
    <member kind="typedef">
      <type>double</type>
      <name>CppType</name>
      <anchorfile>classGlib_1_1Value_3_01double_01_4.html</anchorfile>
      <anchor>a26d2764c822a4d9df661bd0bc8fd9f86</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>gdouble</type>
      <name>CType</name>
      <anchorfile>classGlib_1_1Value_3_01double_01_4.html</anchorfile>
      <anchor>ad421fba746b8423ad60a944c0ae42a9e</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set</name>
      <anchorfile>classGlib_1_1Value_3_01double_01_4.html</anchorfile>
      <anchor>aef6e3c7dfda4a135bb2ee37b4ba468f8</anchor>
      <arglist>(double data)</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>get</name>
      <anchorfile>classGlib_1_1Value_3_01double_01_4.html</anchorfile>
      <anchor>af1d30d9013028b281b80e17acd1021a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static GType</type>
      <name>value_type</name>
      <anchorfile>classGlib_1_1Value_3_01double_01_4.html</anchorfile>
      <anchor>a046afc0453d84b0accb5e5e23bcd7521</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glib::Value&lt; void * &gt;</name>
    <filename>classGlib_1_1Value_3_01void_01_5_01_4.html</filename>
    <base>Glib::ValueBase</base>
    <member kind="typedef">
      <type>void *</type>
      <name>CppType</name>
      <anchorfile>classGlib_1_1Value_3_01void_01_5_01_4.html</anchorfile>
      <anchor>a6aee0d99ba9bc3a023b71955f3f8d507</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>gpointer</type>
      <name>CType</name>
      <anchorfile>classGlib_1_1Value_3_01void_01_5_01_4.html</anchorfile>
      <anchor>abab9376bc45d880dd7d5159b8a0fb3c5</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set</name>
      <anchorfile>classGlib_1_1Value_3_01void_01_5_01_4.html</anchorfile>
      <anchor>a30f8bdfdaa2391c0a4f60f179ac30082</anchor>
      <arglist>(void *data)</arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>get</name>
      <anchorfile>classGlib_1_1Value_3_01void_01_5_01_4.html</anchorfile>
      <anchor>ad501fcb3182b6d49a48d0a240b5a4efe</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static GType</type>
      <name>value_type</name>
      <anchorfile>classGlib_1_1Value_3_01void_01_5_01_4.html</anchorfile>
      <anchor>a14370792a114bc30b65d7b6992bceb2d</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glib::ArrayHandle</name>
    <filename>classGlib_1_1ArrayHandle.html</filename>
    <templarg></templarg>
    <templarg></templarg>
    <member kind="typedef">
      <type>Tr::CppType</type>
      <name>CppType</name>
      <anchorfile>classGlib_1_1ArrayHandle.html</anchorfile>
      <anchor>ad9ca8fd0074e25366ce9ae85c0da9ffe</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Tr::CType</type>
      <name>CType</name>
      <anchorfile>classGlib_1_1ArrayHandle.html</anchorfile>
      <anchor>a2161a555c5f651233af6aa32cfd016d8</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>CppType</type>
      <name>value_type</name>
      <anchorfile>classGlib_1_1ArrayHandle.html</anchorfile>
      <anchor>a6775de1220d2725511f79629f0d3a63a</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>size_t</type>
      <name>size_type</name>
      <anchorfile>classGlib_1_1ArrayHandle.html</anchorfile>
      <anchor>afeb69cdde48519d9064005add7da8230</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>ptrdiff_t</type>
      <name>difference_type</name>
      <anchorfile>classGlib_1_1ArrayHandle.html</anchorfile>
      <anchor>af60a5061ee1b430b7b3330059de02e39</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Glib::Container_Helpers::ArrayHandleIterator&lt; Tr &gt;</type>
      <name>const_iterator</name>
      <anchorfile>classGlib_1_1ArrayHandle.html</anchorfile>
      <anchor>acd735f11ade4130e520ef66bd5800aef</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Glib::Container_Helpers::ArrayHandleIterator&lt; Tr &gt;</type>
      <name>iterator</name>
      <anchorfile>classGlib_1_1ArrayHandle.html</anchorfile>
      <anchor>a8aba00ae24aa2813f378fd157dba99c4</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>ArrayHandle</name>
      <anchorfile>classGlib_1_1ArrayHandle.html</anchorfile>
      <anchor>a7a261c3c3e4e1b0ead57b134625e6e3e</anchor>
      <arglist>(const Cont &amp;container)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>ArrayHandle</name>
      <anchorfile>classGlib_1_1ArrayHandle.html</anchorfile>
      <anchor>a4a7138271154d742d6f4a2adc7995eb5</anchor>
      <arglist>(const CType *array, size_t array_size, Glib::OwnershipType ownership)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>ArrayHandle</name>
      <anchorfile>classGlib_1_1ArrayHandle.html</anchorfile>
      <anchor>a9cdca99f478f47db5c317097d68d45b9</anchor>
      <arglist>(const CType *array, Glib::OwnershipType ownership)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>ArrayHandle</name>
      <anchorfile>classGlib_1_1ArrayHandle.html</anchorfile>
      <anchor>ac8a366a9b0b2f464f431a84228348931</anchor>
      <arglist>(const ArrayHandle&lt; T, Tr &gt; &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~ArrayHandle</name>
      <anchorfile>classGlib_1_1ArrayHandle.html</anchorfile>
      <anchor>a0f94a99de78be3475f1b30adfd96fc6d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const_iterator</type>
      <name>begin</name>
      <anchorfile>classGlib_1_1ArrayHandle.html</anchorfile>
      <anchor>aa6a2e163a4d195aac53c75cb02be7601</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const_iterator</type>
      <name>end</name>
      <anchorfile>classGlib_1_1ArrayHandle.html</anchorfile>
      <anchor>a4ac069ea1060d9c0ac46efce7694e7ff</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>operator std::vector&lt; U &gt;</name>
      <anchorfile>classGlib_1_1ArrayHandle.html</anchorfile>
      <anchor>a018232fba86f8a8240d6eeefddd60979</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>operator std::deque&lt; U &gt;</name>
      <anchorfile>classGlib_1_1ArrayHandle.html</anchorfile>
      <anchor>a7f3b5412c37be94f2435c59fe4b1fbe4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>operator std::list&lt; U &gt;</name>
      <anchorfile>classGlib_1_1ArrayHandle.html</anchorfile>
      <anchor>a9176b251159d2646d43bc6355201cfaa</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>assign_to</name>
      <anchorfile>classGlib_1_1ArrayHandle.html</anchorfile>
      <anchor>a3dbda14c24e7c445fad97dea25182109</anchor>
      <arglist>(Cont &amp;container) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy</name>
      <anchorfile>classGlib_1_1ArrayHandle.html</anchorfile>
      <anchor>aafc535e0cc77d2c1f53709f726164d2b</anchor>
      <arglist>(Out pdest) const </arglist>
    </member>
    <member kind="function">
      <type>const CType *</type>
      <name>data</name>
      <anchorfile>classGlib_1_1ArrayHandle.html</anchorfile>
      <anchor>a8794146efa526907e7c9cd6fc336cbf8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>size_t</type>
      <name>size</name>
      <anchorfile>classGlib_1_1ArrayHandle.html</anchorfile>
      <anchor>ab78550b32462c01af61e626aaec484c0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>empty</name>
      <anchorfile>classGlib_1_1ArrayHandle.html</anchorfile>
      <anchor>a6d3451afee37c942602a6db774838ffc</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glib::Sequence</name>
    <filename>classGlib_1_1Sequence.html</filename>
    <templarg></templarg>
    <member kind="function">
      <type></type>
      <name>Sequence</name>
      <anchorfile>classGlib_1_1Sequence.html</anchorfile>
      <anchor>a2f556fc5bb85887bfeb6547e0076adb4</anchor>
      <arglist>(Iterator pbegin, Iterator pend)</arglist>
    </member>
    <member kind="function">
      <type>Iterator</type>
      <name>begin</name>
      <anchorfile>classGlib_1_1Sequence.html</anchorfile>
      <anchor>a6d7083f5215ac6dd6d3197be858abcd2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Iterator</type>
      <name>end</name>
      <anchorfile>classGlib_1_1Sequence.html</anchorfile>
      <anchor>a3b5ed96c1fb03690b3baef6a97ae0b21</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>size_t</type>
      <name>size</name>
      <anchorfile>classGlib_1_1Sequence.html</anchorfile>
      <anchor>ae8d05d5808189308272a3f6b2512ad40</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glib::Dispatcher</name>
    <filename>classGlib_1_1Dispatcher.html</filename>
    <member kind="function">
      <type></type>
      <name>Dispatcher</name>
      <anchorfile>classGlib_1_1Dispatcher.html</anchorfile>
      <anchor>a1883255c63f36e1d218ccf3f1abfa992</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Dispatcher</name>
      <anchorfile>classGlib_1_1Dispatcher.html</anchorfile>
      <anchor>a14692fe3e39140fc164cbd03149a7ce1</anchor>
      <arglist>(const Glib::RefPtr&lt; MainContext &gt; &amp;context)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~Dispatcher</name>
      <anchorfile>classGlib_1_1Dispatcher.html</anchorfile>
      <anchor>a6d220afa9063f8cf1364d5a1c73eb010</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>emit</name>
      <anchorfile>classGlib_1_1Dispatcher.html</anchorfile>
      <anchor>a07b89c90f931db118c8c184d0615ce92</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>operator()</name>
      <anchorfile>classGlib_1_1Dispatcher.html</anchorfile>
      <anchor>a4610275deedf1324bf71afde1c8c71ea</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>sigc::connection</type>
      <name>connect</name>
      <anchorfile>classGlib_1_1Dispatcher.html</anchorfile>
      <anchor>a63645395ac79c03b5ec9e81d8099dea7</anchor>
      <arglist>(const sigc::slot&lt; void &gt; &amp;slot)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glib::Error</name>
    <filename>classGlib_1_1Error.html</filename>
    <base>Glib::Exception</base>
    <member kind="function">
      <type></type>
      <name>Error</name>
      <anchorfile>classGlib_1_1Error.html</anchorfile>
      <anchor>a2639aeb2b6a6c43662cf17b8c88a122d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Error</name>
      <anchorfile>classGlib_1_1Error.html</anchorfile>
      <anchor>a40547bd64c5de1ada0feb948428524e5</anchor>
      <arglist>(GQuark domain, int code, const Glib::ustring &amp;message)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Error</name>
      <anchorfile>classGlib_1_1Error.html</anchorfile>
      <anchor>a70257ceb030e4d9dd3ac9a6482830d24</anchor>
      <arglist>(GError *gobject, bool take_copy=false)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Error</name>
      <anchorfile>classGlib_1_1Error.html</anchorfile>
      <anchor>a715ed79ccf7d2fa3a357014fc614a4a4</anchor>
      <arglist>(const Error &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>Error &amp;</type>
      <name>operator=</name>
      <anchorfile>classGlib_1_1Error.html</anchorfile>
      <anchor>a6fd059d3c4d24c3f6a0f6999be41b138</anchor>
      <arglist>(const Error &amp;other)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Error</name>
      <anchorfile>classGlib_1_1Error.html</anchorfile>
      <anchor>ae58400627bb4445a54651ae95bb63829</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GQuark</type>
      <name>domain</name>
      <anchorfile>classGlib_1_1Error.html</anchorfile>
      <anchor>a8d0366db925669aa5841f21e48f278c4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>code</name>
      <anchorfile>classGlib_1_1Error.html</anchorfile>
      <anchor>a073623423095dc52db289bf04a146648</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::ustring</type>
      <name>what</name>
      <anchorfile>classGlib_1_1Error.html</anchorfile>
      <anchor>ac5a9ff59ba32b2ddc24c5c6c0c86d605</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>matches</name>
      <anchorfile>classGlib_1_1Error.html</anchorfile>
      <anchor>aae4921c01b2852ddb48984b4a5ec760c</anchor>
      <arglist>(GQuark domain, int code) const </arglist>
    </member>
    <member kind="function">
      <type>GError *</type>
      <name>gobj</name>
      <anchorfile>classGlib_1_1Error.html</anchorfile>
      <anchor>a69e6636c8ed726b1468ed61c07d65816</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GError *</type>
      <name>gobj</name>
      <anchorfile>classGlib_1_1Error.html</anchorfile>
      <anchor>a41b5a27b917ecb6a0176387bf357d8cc</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>GError *</type>
      <name>gobject_</name>
      <anchorfile>classGlib_1_1Error.html</anchorfile>
      <anchor>aaf45a78024403f011e31a73c1361c59a</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glib::Exception</name>
    <filename>classGlib_1_1Exception.html</filename>
    <member kind="function" virtualness="pure">
      <type>virtual</type>
      <name>~Exception</name>
      <anchorfile>classGlib_1_1Exception.html</anchorfile>
      <anchor>a44a9c79be10c68a6861f015217ce18fb</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual Glib::ustring</type>
      <name>what</name>
      <anchorfile>classGlib_1_1Exception.html</anchorfile>
      <anchor>a2423c81571a101571751fe0a046beef0</anchor>
      <arglist>() const =0</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glib::HelperList</name>
    <filename>classGlib_1_1HelperList.html</filename>
    <templarg></templarg>
    <templarg></templarg>
    <templarg></templarg>
    <member kind="typedef">
      <type>T_Child</type>
      <name>value_type</name>
      <anchorfile>classGlib_1_1HelperList.html</anchorfile>
      <anchor>a3b4451feb1e5c827809b0683fab225c3</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>value_type &amp;</type>
      <name>reference</name>
      <anchorfile>classGlib_1_1HelperList.html</anchorfile>
      <anchor>a435dafddf9beda6c5ff688ae22f80031</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>const value_type &amp;</type>
      <name>const_reference</name>
      <anchorfile>classGlib_1_1HelperList.html</anchorfile>
      <anchor>a2b2af43788aef5aafd2bbb7bc8d9f13f</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>T_Iterator</type>
      <name>iterator</name>
      <anchorfile>classGlib_1_1HelperList.html</anchorfile>
      <anchor>a1dcce9f64cf02136eb201d1f04a844a7</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>List_ConstIterator&lt; iterator &gt;</type>
      <name>const_iterator</name>
      <anchorfile>classGlib_1_1HelperList.html</anchorfile>
      <anchor>aaea545a89905ab1ebe26e053c53356f9</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>List_ReverseIterator&lt; iterator &gt;</type>
      <name>reverse_iterator</name>
      <anchorfile>classGlib_1_1HelperList.html</anchorfile>
      <anchor>a3c6722e1398ae20a1adee87cc2c82fb2</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>List_ConstIterator&lt; reverse_iterator &gt;</type>
      <name>const_reverse_iterator</name>
      <anchorfile>classGlib_1_1HelperList.html</anchorfile>
      <anchor>a98d0b312ab29c9f5d2cb5f3dbcf76ac1</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>T_CppElement</type>
      <name>element_type</name>
      <anchorfile>classGlib_1_1HelperList.html</anchorfile>
      <anchor>a80a39df0948d7f233e620319715fbfef</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>size_t</type>
      <name>difference_type</name>
      <anchorfile>classGlib_1_1HelperList.html</anchorfile>
      <anchor>a6b32b79a4705baa8c259b5fdb85c0e64</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>size_t</type>
      <name>size_type</name>
      <anchorfile>classGlib_1_1HelperList.html</anchorfile>
      <anchor>a20c684001ef0b6c49732f4baa87f0ca8</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>HelperList</name>
      <anchorfile>classGlib_1_1HelperList.html</anchorfile>
      <anchor>ac8e607070eb44e5a6e2d431260d1fff4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>HelperList</name>
      <anchorfile>classGlib_1_1HelperList.html</anchorfile>
      <anchor>aa6a1fdb8068c9a6ff8e42f626c521743</anchor>
      <arglist>(GObject *gp)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~HelperList</name>
      <anchorfile>classGlib_1_1HelperList.html</anchorfile>
      <anchor>aab4e8cc0faf4cf94666eb8799fb161c8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual iterator</type>
      <name>erase</name>
      <anchorfile>classGlib_1_1HelperList.html</anchorfile>
      <anchor>a4bee97685b3fc46d076721f82092f12b</anchor>
      <arglist>(iterator)=0</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>erase</name>
      <anchorfile>classGlib_1_1HelperList.html</anchorfile>
      <anchor>a411996bdc0ef3623a1d0e1e0d307de4f</anchor>
      <arglist>(iterator start, iterator stop)</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>remove</name>
      <anchorfile>classGlib_1_1HelperList.html</anchorfile>
      <anchor>a19373c8c69f4480a98208ed41a5ce176</anchor>
      <arglist>(const_reference)=0</arglist>
    </member>
    <member kind="function">
      <type>size_type</type>
      <name>size</name>
      <anchorfile>classGlib_1_1HelperList.html</anchorfile>
      <anchor>a6e57dbedd07db274cca4fc96c4dc1a99</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>size_type</type>
      <name>max_size</name>
      <anchorfile>classGlib_1_1HelperList.html</anchorfile>
      <anchor>a1804cd42b3665f7cc6d82a41080361ef</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>empty</name>
      <anchorfile>classGlib_1_1HelperList.html</anchorfile>
      <anchor>a719bfa3471825fd4d5b7061504ed9e1b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>iterator</type>
      <name>begin</name>
      <anchorfile>classGlib_1_1HelperList.html</anchorfile>
      <anchor>ab9e537275fd961f09b7fa0c6670c973c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>iterator</type>
      <name>end</name>
      <anchorfile>classGlib_1_1HelperList.html</anchorfile>
      <anchor>a8569a041346fb38b60eb2aec0662bb30</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const_iterator</type>
      <name>begin</name>
      <anchorfile>classGlib_1_1HelperList.html</anchorfile>
      <anchor>a19f577c7429327eb077c723b893b1abf</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const_iterator</type>
      <name>end</name>
      <anchorfile>classGlib_1_1HelperList.html</anchorfile>
      <anchor>a86bb7c980a0ef4277471ba29e2a59e12</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>reverse_iterator</type>
      <name>rbegin</name>
      <anchorfile>classGlib_1_1HelperList.html</anchorfile>
      <anchor>a1c6d98170261d1b9c89d34ce359827f3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>reverse_iterator</type>
      <name>rend</name>
      <anchorfile>classGlib_1_1HelperList.html</anchorfile>
      <anchor>a9724ef5c75c231a1b31b6220239e007f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const_reverse_iterator</type>
      <name>rbegin</name>
      <anchorfile>classGlib_1_1HelperList.html</anchorfile>
      <anchor>a67f0e94fa89408e7957189b08d049a4f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const_reverse_iterator</type>
      <name>rend</name>
      <anchorfile>classGlib_1_1HelperList.html</anchorfile>
      <anchor>a6cb331f7ecc76bdcf8a8f1af5a7e7b83</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>reference</type>
      <name>front</name>
      <anchorfile>classGlib_1_1HelperList.html</anchorfile>
      <anchor>a103bc1541be3a1fe5c9d23aa9d23d98a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>reference</type>
      <name>back</name>
      <anchorfile>classGlib_1_1HelperList.html</anchorfile>
      <anchor>aaae13a6d35339259d14750014ebe480a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>reference</type>
      <name>operator[]</name>
      <anchorfile>classGlib_1_1HelperList.html</anchorfile>
      <anchor>a92b37fcdf4dfee983e8ea2af4b710bf4</anchor>
      <arglist>(size_type l) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>pop_front</name>
      <anchorfile>classGlib_1_1HelperList.html</anchorfile>
      <anchor>a28f275f049a351f9cc2bd4162de3ec6f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>pop_back</name>
      <anchorfile>classGlib_1_1HelperList.html</anchorfile>
      <anchor>a772423e892bd3ed57a11a544a0608b9e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>clear</name>
      <anchorfile>classGlib_1_1HelperList.html</anchorfile>
      <anchor>a9f7bc99c64db14a448d70db0c008eb71</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GObject *</type>
      <name>gparent</name>
      <anchorfile>classGlib_1_1HelperList.html</anchorfile>
      <anchor>a3dc8d631ba89f7173882a50dd4dc03d8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GObject *</type>
      <name>gparent</name>
      <anchorfile>classGlib_1_1HelperList.html</anchorfile>
      <anchor>ac3c3de8a7a9ca70ae15ae2503912a21f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="protected" virtualness="pure">
      <type>virtual GList *&amp;</type>
      <name>glist</name>
      <anchorfile>classGlib_1_1HelperList.html</anchorfile>
      <anchor>a7ecdcc677de72ffe14d6c43ccc02ede8</anchor>
      <arglist>() const =0</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>iterator</type>
      <name>begin_</name>
      <anchorfile>classGlib_1_1HelperList.html</anchorfile>
      <anchor>a9ac2bf92224630aab4fcc374b9febe2d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="protected">
      <type>iterator</type>
      <name>end_</name>
      <anchorfile>classGlib_1_1HelperList.html</anchorfile>
      <anchor>a545ca00edc737af427e693c63dab4d85</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>GObject *</type>
      <name>gparent_</name>
      <anchorfile>classGlib_1_1HelperList.html</anchorfile>
      <anchor>a48e04ecc5c170b9e84af28b8df046f2f</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glib::Interface</name>
    <filename>classGlib_1_1Interface.html</filename>
    <base virtualness="virtual">Glib::ObjectBase</base>
    <member kind="function">
      <type></type>
      <name>Interface</name>
      <anchorfile>classGlib_1_1Interface.html</anchorfile>
      <anchor>ae05bf6a4ce0f0992c2ad01429d13f9f7</anchor>
      <arglist>(const Glib::Interface_Class &amp;interface_class)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Interface</name>
      <anchorfile>classGlib_1_1Interface.html</anchorfile>
      <anchor>a00253b22a76f751f1627865451cbc404</anchor>
      <arglist>(GObject *castitem)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Interface</name>
      <anchorfile>classGlib_1_1Interface.html</anchorfile>
      <anchor>a8e12a7a3e0281e28798326ad65e3560c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GObject *</type>
      <name>gobj</name>
      <anchorfile>classGlib_1_1Interface.html</anchorfile>
      <anchor>a969e9396f75132a9577428f4fa932d42</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GObject *</type>
      <name>gobj</name>
      <anchorfile>classGlib_1_1Interface.html</anchorfile>
      <anchor>a70a443071a69d3372c2cdd7128a91ed1</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glib::ListHandle</name>
    <filename>classGlib_1_1ListHandle.html</filename>
    <templarg></templarg>
    <templarg></templarg>
    <member kind="typedef">
      <type>Tr::CppType</type>
      <name>CppType</name>
      <anchorfile>classGlib_1_1ListHandle.html</anchorfile>
      <anchor>ab199f3051fababc22e222dd062a98455</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Tr::CType</type>
      <name>CType</name>
      <anchorfile>classGlib_1_1ListHandle.html</anchorfile>
      <anchor>a4bd7e0897feb485c068580ddb3d2ffa8</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>CppType</type>
      <name>value_type</name>
      <anchorfile>classGlib_1_1ListHandle.html</anchorfile>
      <anchor>aca0af53b553d99c0bd0d89cff6bcec4d</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>size_t</type>
      <name>size_type</name>
      <anchorfile>classGlib_1_1ListHandle.html</anchorfile>
      <anchor>a7a5d006b9304712af0aef4de46cd6a83</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>ptrdiff_t</type>
      <name>difference_type</name>
      <anchorfile>classGlib_1_1ListHandle.html</anchorfile>
      <anchor>a1523aa68df936d6833f899b40b16c4bc</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Glib::Container_Helpers::ListHandleIterator&lt; Tr &gt;</type>
      <name>const_iterator</name>
      <anchorfile>classGlib_1_1ListHandle.html</anchorfile>
      <anchor>ae17fbd0767ba97ba409be1b8eed016e6</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Glib::Container_Helpers::ListHandleIterator&lt; Tr &gt;</type>
      <name>iterator</name>
      <anchorfile>classGlib_1_1ListHandle.html</anchorfile>
      <anchor>af52a28438ef1ba99c203aa51947b238c</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>ListHandle</name>
      <anchorfile>classGlib_1_1ListHandle.html</anchorfile>
      <anchor>ab59f9228aad5bc2c463e802d2cfdffe3</anchor>
      <arglist>(const Cont &amp;container)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>ListHandle</name>
      <anchorfile>classGlib_1_1ListHandle.html</anchorfile>
      <anchor>a36115ce113139df07308f2800f3eb2de</anchor>
      <arglist>(GList *glist, Glib::OwnershipType ownership)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>ListHandle</name>
      <anchorfile>classGlib_1_1ListHandle.html</anchorfile>
      <anchor>aa07b040bd5462d9f4693a2b32baa212a</anchor>
      <arglist>(const ListHandle&lt; T, Tr &gt; &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~ListHandle</name>
      <anchorfile>classGlib_1_1ListHandle.html</anchorfile>
      <anchor>a1822fff1efe8aba9c0684598ddc291e0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const_iterator</type>
      <name>begin</name>
      <anchorfile>classGlib_1_1ListHandle.html</anchorfile>
      <anchor>a5ce04b9462c6d93d41584319d8a55512</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const_iterator</type>
      <name>end</name>
      <anchorfile>classGlib_1_1ListHandle.html</anchorfile>
      <anchor>a79a10a94cf804320e34efa10bc19d89d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>operator std::vector&lt; U &gt;</name>
      <anchorfile>classGlib_1_1ListHandle.html</anchorfile>
      <anchor>a0f53393e26cb1bab3374e8610e2a6f2d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>operator std::deque&lt; U &gt;</name>
      <anchorfile>classGlib_1_1ListHandle.html</anchorfile>
      <anchor>a09825f006510fcc06812c087771b5415</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>operator std::list&lt; U &gt;</name>
      <anchorfile>classGlib_1_1ListHandle.html</anchorfile>
      <anchor>a4afa08ac82e6feb849a53d7fe44173b1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>assign_to</name>
      <anchorfile>classGlib_1_1ListHandle.html</anchorfile>
      <anchor>a86b4475ccf05a5bbbe7820ac6ee3c097</anchor>
      <arglist>(Cont &amp;container) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy</name>
      <anchorfile>classGlib_1_1ListHandle.html</anchorfile>
      <anchor>a80757fc385e3d91cf61920ac4a168b70</anchor>
      <arglist>(Out pdest) const </arglist>
    </member>
    <member kind="function">
      <type>GList *</type>
      <name>data</name>
      <anchorfile>classGlib_1_1ListHandle.html</anchorfile>
      <anchor>a63127f932d732a8c5db19b486ca977ba</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>size_t</type>
      <name>size</name>
      <anchorfile>classGlib_1_1ListHandle.html</anchorfile>
      <anchor>ac6f7d604ef6ba46603a0fefcf08d4f3d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>empty</name>
      <anchorfile>classGlib_1_1ListHandle.html</anchorfile>
      <anchor>a6506f89c461c3e5472e85e440b5cf3fe</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glib::PollFD</name>
    <filename>classGlib_1_1PollFD.html</filename>
    <member kind="function">
      <type></type>
      <name>PollFD</name>
      <anchorfile>classGlib_1_1PollFD.html</anchorfile>
      <anchor>a7ae711b0cc1ce1b0cd467381955dc62e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>PollFD</name>
      <anchorfile>classGlib_1_1PollFD.html</anchorfile>
      <anchor>a902e5f082ecb994abff2ddbedd8a4992</anchor>
      <arglist>(int fd)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>PollFD</name>
      <anchorfile>classGlib_1_1PollFD.html</anchorfile>
      <anchor>a409d8d7cbbcc89331cd46944791b6657</anchor>
      <arglist>(int fd, IOCondition events)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_fd</name>
      <anchorfile>classGlib_1_1PollFD.html</anchorfile>
      <anchor>af22b12cf9e39e5a6467b8d9b338eb6f9</anchor>
      <arglist>(int fd)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>get_fd</name>
      <anchorfile>classGlib_1_1PollFD.html</anchorfile>
      <anchor>aed3cce9d7f50df212b5680f671518ea6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_events</name>
      <anchorfile>classGlib_1_1PollFD.html</anchorfile>
      <anchor>a0ff97568715e76d4cc57f8099f0c2b38</anchor>
      <arglist>(IOCondition events)</arglist>
    </member>
    <member kind="function">
      <type>IOCondition</type>
      <name>get_events</name>
      <anchorfile>classGlib_1_1PollFD.html</anchorfile>
      <anchor>a3796334fca0f347be79f8cc209ffc412</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_revents</name>
      <anchorfile>classGlib_1_1PollFD.html</anchorfile>
      <anchor>a6cdd3635d279b0ec322dca7604e692c9</anchor>
      <arglist>(IOCondition revents)</arglist>
    </member>
    <member kind="function">
      <type>IOCondition</type>
      <name>get_revents</name>
      <anchorfile>classGlib_1_1PollFD.html</anchorfile>
      <anchor>ad89b1655f967e43b1ad953cd0fc1122e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GPollFD *</type>
      <name>gobj</name>
      <anchorfile>classGlib_1_1PollFD.html</anchorfile>
      <anchor>a2ecf367bcde791507e699bac3a38bb1d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GPollFD *</type>
      <name>gobj</name>
      <anchorfile>classGlib_1_1PollFD.html</anchorfile>
      <anchor>ab0913925b29613809c0d6a5fcd43625d</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glib::SignalTimeout</name>
    <filename>classGlib_1_1SignalTimeout.html</filename>
    <member kind="function">
      <type>sigc::connection</type>
      <name>connect</name>
      <anchorfile>classGlib_1_1SignalTimeout.html</anchorfile>
      <anchor>a75b555ed13d91e6903e927f9e0d7afd2</anchor>
      <arglist>(const sigc::slot&lt; bool &gt; &amp;slot, unsigned int interval, int priority=PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>connect_once</name>
      <anchorfile>classGlib_1_1SignalTimeout.html</anchorfile>
      <anchor>a4ea8fdd120102d7963709916f28b2bcc</anchor>
      <arglist>(const sigc::slot&lt; void &gt; &amp;slot, unsigned int interval, int priority=PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>sigc::connection</type>
      <name>connect_seconds</name>
      <anchorfile>classGlib_1_1SignalTimeout.html</anchorfile>
      <anchor>a02ad93aa55aa48d48263df628b69fa95</anchor>
      <arglist>(const sigc::slot&lt; bool &gt; &amp;slot, unsigned int interval, int priority=PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>connect_seconds_once</name>
      <anchorfile>classGlib_1_1SignalTimeout.html</anchorfile>
      <anchor>aebbfd6e94c3c04bfac53f89e53fafa93</anchor>
      <arglist>(const sigc::slot&lt; void &gt; &amp;slot, unsigned int interval, int priority=PRIORITY_DEFAULT)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glib::SignalIdle</name>
    <filename>classGlib_1_1SignalIdle.html</filename>
    <member kind="function">
      <type>sigc::connection</type>
      <name>connect</name>
      <anchorfile>classGlib_1_1SignalIdle.html</anchorfile>
      <anchor>ac8befbaf1d10a17d1f3f75143e967a3f</anchor>
      <arglist>(const sigc::slot&lt; bool &gt; &amp;slot, int priority=PRIORITY_DEFAULT_IDLE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>connect_once</name>
      <anchorfile>classGlib_1_1SignalIdle.html</anchorfile>
      <anchor>a94217dc63e35f96b5cee4c48f2cdd020</anchor>
      <arglist>(const sigc::slot&lt; void &gt; &amp;slot, int priority=PRIORITY_DEFAULT_IDLE)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glib::SignalIO</name>
    <filename>classGlib_1_1SignalIO.html</filename>
    <member kind="function">
      <type>sigc::connection</type>
      <name>connect</name>
      <anchorfile>classGlib_1_1SignalIO.html</anchorfile>
      <anchor>ac205b21234d26094e75e0931c968c5d2</anchor>
      <arglist>(const sigc::slot&lt; bool, IOCondition &gt; &amp;slot, int fd, IOCondition condition, int priority=PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>sigc::connection</type>
      <name>connect</name>
      <anchorfile>classGlib_1_1SignalIO.html</anchorfile>
      <anchor>a779227bae6390b055243d1f3083a5388</anchor>
      <arglist>(const sigc::slot&lt; bool, IOCondition &gt; &amp;slot, const Glib::RefPtr&lt; IOChannel &gt; &amp;channel, IOCondition condition, int priority=PRIORITY_DEFAULT)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glib::SignalChildWatch</name>
    <filename>classGlib_1_1SignalChildWatch.html</filename>
    <member kind="function">
      <type>sigc::connection</type>
      <name>connect</name>
      <anchorfile>classGlib_1_1SignalChildWatch.html</anchorfile>
      <anchor>a4c2f5be316b9600133129cc974b6b5bb</anchor>
      <arglist>(const sigc::slot&lt; void, GPid, int &gt; &amp;slot, GPid pid, int priority=PRIORITY_DEFAULT)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glib::MainContext</name>
    <filename>classGlib_1_1MainContext.html</filename>
    <member kind="typedef">
      <type>Glib::MainContext</type>
      <name>CppObjectType</name>
      <anchorfile>classGlib_1_1MainContext.html</anchorfile>
      <anchor>a1cbedd2b4d723f53cd98df1bb757f904</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>GMainContext</type>
      <name>BaseObjectType</name>
      <anchorfile>classGlib_1_1MainContext.html</anchorfile>
      <anchor>ada2ea4035a4809198aecbc748b750495</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>iteration</name>
      <anchorfile>classGlib_1_1MainContext.html</anchorfile>
      <anchor>afde2e29315da1239af998f1826ad5e88</anchor>
      <arglist>(bool may_block)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>pending</name>
      <anchorfile>classGlib_1_1MainContext.html</anchorfile>
      <anchor>acf4631ab57318f39f3e15d98ac1aaa5c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>wakeup</name>
      <anchorfile>classGlib_1_1MainContext.html</anchorfile>
      <anchor>a5a5e60018f7549f064e71b34b1668020</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>acquire</name>
      <anchorfile>classGlib_1_1MainContext.html</anchorfile>
      <anchor>aa92ee9cfb192aa5eb6c2aa0841068bbc</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>wait</name>
      <anchorfile>classGlib_1_1MainContext.html</anchorfile>
      <anchor>a68c3d19af76d4b32aeae9d2e4f5c230f</anchor>
      <arglist>(Glib::Cond &amp;cond, Glib::Mutex &amp;mutex)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>release</name>
      <anchorfile>classGlib_1_1MainContext.html</anchorfile>
      <anchor>ace2d9cdfa27cbe30026932de0526f730</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>prepare</name>
      <anchorfile>classGlib_1_1MainContext.html</anchorfile>
      <anchor>af6d1fccb3c1f5aab758d5eb1b3c15d6a</anchor>
      <arglist>(int &amp;priority)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>prepare</name>
      <anchorfile>classGlib_1_1MainContext.html</anchorfile>
      <anchor>abd1bdf8fcb0130152237e87942c89ee1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>query</name>
      <anchorfile>classGlib_1_1MainContext.html</anchorfile>
      <anchor>a49e8976cec1ae4f5b5c30feea6094927</anchor>
      <arglist>(int max_priority, int &amp;timeout, std::vector&lt; PollFD &gt; &amp;fds)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>check</name>
      <anchorfile>classGlib_1_1MainContext.html</anchorfile>
      <anchor>a8061ef816d51cc27372f016c683cc513</anchor>
      <arglist>(int max_priority, std::vector&lt; PollFD &gt; &amp;fds)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>dispatch</name>
      <anchorfile>classGlib_1_1MainContext.html</anchorfile>
      <anchor>a5c1f06dbac3bbf771c25ce76af0d4880</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_poll_func</name>
      <anchorfile>classGlib_1_1MainContext.html</anchorfile>
      <anchor>ad8383c8f1a1a03b904f9be608ad8eaaf</anchor>
      <arglist>(GPollFunc poll_func)</arglist>
    </member>
    <member kind="function">
      <type>GPollFunc</type>
      <name>get_poll_func</name>
      <anchorfile>classGlib_1_1MainContext.html</anchorfile>
      <anchor>a34a0b1e31173e163f11053dbcf21b84c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>add_poll</name>
      <anchorfile>classGlib_1_1MainContext.html</anchorfile>
      <anchor>a7cdbe7d102a781b6aded3cdda45fef34</anchor>
      <arglist>(PollFD &amp;fd, int priority)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove_poll</name>
      <anchorfile>classGlib_1_1MainContext.html</anchorfile>
      <anchor>a33ea2db49dd93739599d19756c251627</anchor>
      <arglist>(PollFD &amp;fd)</arglist>
    </member>
    <member kind="function">
      <type>SignalTimeout</type>
      <name>signal_timeout</name>
      <anchorfile>classGlib_1_1MainContext.html</anchorfile>
      <anchor>adf307c9028858449e932f5fff100d432</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>SignalIdle</type>
      <name>signal_idle</name>
      <anchorfile>classGlib_1_1MainContext.html</anchorfile>
      <anchor>a2a12990fb67f7b5c1ed61e36952dd827</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>SignalIO</type>
      <name>signal_io</name>
      <anchorfile>classGlib_1_1MainContext.html</anchorfile>
      <anchor>a8c8a4283456eb9036cc09dc3aaf203dc</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>SignalChildWatch</type>
      <name>signal_child_watch</name>
      <anchorfile>classGlib_1_1MainContext.html</anchorfile>
      <anchor>ab646f19ce79faa35d97e8af93e6ca6d6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>reference</name>
      <anchorfile>classGlib_1_1MainContext.html</anchorfile>
      <anchor>a71499a662e6ac07590a0972b1b0eac64</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unreference</name>
      <anchorfile>classGlib_1_1MainContext.html</anchorfile>
      <anchor>a8eaf5d38c393770f150db7bad9a67f9e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GMainContext *</type>
      <name>gobj</name>
      <anchorfile>classGlib_1_1MainContext.html</anchorfile>
      <anchor>a0fbf5178aca208161051097f034d3694</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GMainContext *</type>
      <name>gobj</name>
      <anchorfile>classGlib_1_1MainContext.html</anchorfile>
      <anchor>a1814534a832aecafba4a790e7b5ca25d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GMainContext *</type>
      <name>gobj_copy</name>
      <anchorfile>classGlib_1_1MainContext.html</anchorfile>
      <anchor>a3a841522a3db9ceb73742f9f235c3d2b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; MainContext &gt;</type>
      <name>create</name>
      <anchorfile>classGlib_1_1MainContext.html</anchorfile>
      <anchor>a31bd96bf707a21c8a3003337dd3af9c4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; MainContext &gt;</type>
      <name>get_default</name>
      <anchorfile>classGlib_1_1MainContext.html</anchorfile>
      <anchor>a1502cbed045a9fb27d18c6975e1d255d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; MainContext &gt;</type>
      <name>wrap</name>
      <anchorfile>group__MainLoop.html</anchorfile>
      <anchor>ga043c5714afbad2745b27301dd58470a4</anchor>
      <arglist>(GMainContext *gobject, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glib::MainLoop</name>
    <filename>classGlib_1_1MainLoop.html</filename>
    <member kind="typedef">
      <type>Glib::MainLoop</type>
      <name>CppObjectType</name>
      <anchorfile>classGlib_1_1MainLoop.html</anchorfile>
      <anchor>a5cf7f1f3137b7ecfde3a843087cc89d8</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>GMainLoop</type>
      <name>BaseObjectType</name>
      <anchorfile>classGlib_1_1MainLoop.html</anchorfile>
      <anchor>ad5e8a0005860126cac043cb60be70078</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>run</name>
      <anchorfile>classGlib_1_1MainLoop.html</anchorfile>
      <anchor>a4cc8eeba5dd463189737f859974ae158</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>quit</name>
      <anchorfile>classGlib_1_1MainLoop.html</anchorfile>
      <anchor>ae1a76ab4fe58b23ec8238d6aa40cbab9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_running</name>
      <anchorfile>classGlib_1_1MainLoop.html</anchorfile>
      <anchor>a9dca351bd77e00412f5e73eacc41c5fd</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; MainContext &gt;</type>
      <name>get_context</name>
      <anchorfile>classGlib_1_1MainLoop.html</anchorfile>
      <anchor>a37b86faf3ae28cfa49c15b73b15a24f1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>reference</name>
      <anchorfile>classGlib_1_1MainLoop.html</anchorfile>
      <anchor>a5e40799cc2e26b57227c269f0d4dd831</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unreference</name>
      <anchorfile>classGlib_1_1MainLoop.html</anchorfile>
      <anchor>a26ac94620e6b7887aedb20df468a9123</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GMainLoop *</type>
      <name>gobj</name>
      <anchorfile>classGlib_1_1MainLoop.html</anchorfile>
      <anchor>aa53b9c0c885e28390b45e83aef4b2934</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GMainLoop *</type>
      <name>gobj</name>
      <anchorfile>classGlib_1_1MainLoop.html</anchorfile>
      <anchor>aeef011a123044d42b0422c36d28c450a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GMainLoop *</type>
      <name>gobj_copy</name>
      <anchorfile>classGlib_1_1MainLoop.html</anchorfile>
      <anchor>af4d2883d0ce518a137f49f131225a99d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; MainLoop &gt;</type>
      <name>create</name>
      <anchorfile>classGlib_1_1MainLoop.html</anchorfile>
      <anchor>a37a1dcf3cb167cf02260111f533d0b5b</anchor>
      <arglist>(bool is_running=false)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; MainLoop &gt;</type>
      <name>create</name>
      <anchorfile>classGlib_1_1MainLoop.html</anchorfile>
      <anchor>ab02f157ce27cd8aa5592eabc739ccdec</anchor>
      <arglist>(const Glib::RefPtr&lt; MainContext &gt; &amp;context, bool is_running=false)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static int</type>
      <name>depth</name>
      <anchorfile>classGlib_1_1MainLoop.html</anchorfile>
      <anchor>a023045e5b0069af8260e721fde21f4c6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; MainLoop &gt;</type>
      <name>wrap</name>
      <anchorfile>group__MainLoop.html</anchorfile>
      <anchor>ga22ea72cda4ef327ca03fb72d6a3bea89</anchor>
      <arglist>(GMainLoop *gobject, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glib::Source</name>
    <filename>classGlib_1_1Source.html</filename>
    <member kind="typedef">
      <type>Glib::Source</type>
      <name>CppObjectType</name>
      <anchorfile>classGlib_1_1Source.html</anchorfile>
      <anchor>a2edc89f6c4601e50f5aa22cb36eb9437</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>GSource</type>
      <name>BaseObjectType</name>
      <anchorfile>classGlib_1_1Source.html</anchorfile>
      <anchor>a6dbe7bc8cfb1b72d61f06a180119db7b</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>unsigned int</type>
      <name>attach</name>
      <anchorfile>classGlib_1_1Source.html</anchorfile>
      <anchor>aa61d28e643f2b286203b0d8e533b2c88</anchor>
      <arglist>(const Glib::RefPtr&lt; MainContext &gt; &amp;context)</arglist>
    </member>
    <member kind="function">
      <type>unsigned int</type>
      <name>attach</name>
      <anchorfile>classGlib_1_1Source.html</anchorfile>
      <anchor>a77c4b83960b2fd8d65b10ade1fc2e2fb</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>destroy</name>
      <anchorfile>classGlib_1_1Source.html</anchorfile>
      <anchor>a98c983f075cdcb77c576b10900b3e052</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_priority</name>
      <anchorfile>classGlib_1_1Source.html</anchorfile>
      <anchor>a0c485044d82729a97b19cbcb841f3c53</anchor>
      <arglist>(int priority)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>get_priority</name>
      <anchorfile>classGlib_1_1Source.html</anchorfile>
      <anchor>abdbea3f0b3404098729945a9973d638e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_can_recurse</name>
      <anchorfile>classGlib_1_1Source.html</anchorfile>
      <anchor>a9ca4bf99d7837587021e3cafd6775aba</anchor>
      <arglist>(bool can_recurse)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_can_recurse</name>
      <anchorfile>classGlib_1_1Source.html</anchorfile>
      <anchor>ada9f428f6265066eb9879b95246795be</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>unsigned int</type>
      <name>get_id</name>
      <anchorfile>classGlib_1_1Source.html</anchorfile>
      <anchor>ad4b66f89818dcc0c22479ec3c4f8f21e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; MainContext &gt;</type>
      <name>get_context</name>
      <anchorfile>classGlib_1_1Source.html</anchorfile>
      <anchor>a42935adf57e6605188e38236cb14b607</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GSource *</type>
      <name>gobj</name>
      <anchorfile>classGlib_1_1Source.html</anchorfile>
      <anchor>a4e855292e2a99861f33c3ba3e5cc3486</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GSource *</type>
      <name>gobj</name>
      <anchorfile>classGlib_1_1Source.html</anchorfile>
      <anchor>af22441954ace1f7d0d1e0314a9778787</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GSource *</type>
      <name>gobj_copy</name>
      <anchorfile>classGlib_1_1Source.html</anchorfile>
      <anchor>affb708925e62814627bb2d332e1de0ec</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>reference</name>
      <anchorfile>classGlib_1_1Source.html</anchorfile>
      <anchor>a72a59a45934a94a26aea8de5f1262235</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unreference</name>
      <anchorfile>classGlib_1_1Source.html</anchorfile>
      <anchor>a7c87c88cbce09d3a7fb10c4e9856f57f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Source &gt;</type>
      <name>create</name>
      <anchorfile>classGlib_1_1Source.html</anchorfile>
      <anchor>aeaffb039abf99982d7a89403bca71569</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>destroy_notify_callback</name>
      <anchorfile>classGlib_1_1Source.html</anchorfile>
      <anchor>af6135656536048436ebbb6424d366800</anchor>
      <arglist>(void *data)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Source</name>
      <anchorfile>classGlib_1_1Source.html</anchorfile>
      <anchor>a9d081ba880470694d7aae3daaee30198</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Source</name>
      <anchorfile>classGlib_1_1Source.html</anchorfile>
      <anchor>accc8cdb2f85ee750e196236a6533b1f0</anchor>
      <arglist>(GSource *cast_item, GSourceFunc callback_func)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual</type>
      <name>~Source</name>
      <anchorfile>classGlib_1_1Source.html</anchorfile>
      <anchor>ab075ead07aec68d085190935fe49ba22</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>sigc::connection</type>
      <name>connect_generic</name>
      <anchorfile>classGlib_1_1Source.html</anchorfile>
      <anchor>a7ee23894376489ae9cebf18bada4e014</anchor>
      <arglist>(const sigc::slot_base &amp;slot)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>add_poll</name>
      <anchorfile>classGlib_1_1Source.html</anchorfile>
      <anchor>a3a0843a960cad7a25919a682c37c9d03</anchor>
      <arglist>(PollFD &amp;poll_fd)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>remove_poll</name>
      <anchorfile>classGlib_1_1Source.html</anchorfile>
      <anchor>a67b7133527caa4f788674af0b4f185b2</anchor>
      <arglist>(PollFD &amp;poll_fd)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>get_current_time</name>
      <anchorfile>classGlib_1_1Source.html</anchorfile>
      <anchor>aec16c75c6c202ea5cb4667aef2637d3c</anchor>
      <arglist>(Glib::TimeVal &amp;current_time)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="pure">
      <type>virtual bool</type>
      <name>prepare</name>
      <anchorfile>classGlib_1_1Source.html</anchorfile>
      <anchor>abc0e9e88fa74766818d317cd75d6aa3f</anchor>
      <arglist>(int &amp;timeout)=0</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="pure">
      <type>virtual bool</type>
      <name>check</name>
      <anchorfile>classGlib_1_1Source.html</anchorfile>
      <anchor>a914448375c7e0dfcee1a686a006c685d</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="pure">
      <type>virtual bool</type>
      <name>dispatch</name>
      <anchorfile>classGlib_1_1Source.html</anchorfile>
      <anchor>aaf867fd3b09fc05d9c3e20cd89f35bd9</anchor>
      <arglist>(sigc::slot_base *slot)=0</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glib::TimeoutSource</name>
    <filename>classGlib_1_1TimeoutSource.html</filename>
    <base>Glib::Source</base>
    <member kind="typedef">
      <type>Glib::TimeoutSource</type>
      <name>CppObjectType</name>
      <anchorfile>classGlib_1_1TimeoutSource.html</anchorfile>
      <anchor>a922118e49e86690ad1b1b343734eaec6</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>sigc::connection</type>
      <name>connect</name>
      <anchorfile>classGlib_1_1TimeoutSource.html</anchorfile>
      <anchor>afd5504a056dbbf1c2aa38450c59c197d</anchor>
      <arglist>(const sigc::slot&lt; bool &gt; &amp;slot)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; TimeoutSource &gt;</type>
      <name>create</name>
      <anchorfile>classGlib_1_1TimeoutSource.html</anchorfile>
      <anchor>aafe1898dd9ded8c66fc1dc9e9ba80884</anchor>
      <arglist>(unsigned int interval)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>TimeoutSource</name>
      <anchorfile>classGlib_1_1TimeoutSource.html</anchorfile>
      <anchor>a1477a30365d9b50fc3a02c92535d084c</anchor>
      <arglist>(unsigned int interval)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual</type>
      <name>~TimeoutSource</name>
      <anchorfile>classGlib_1_1TimeoutSource.html</anchorfile>
      <anchor>abe7d69a1390602de55a5207b1e25d64e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual bool</type>
      <name>prepare</name>
      <anchorfile>classGlib_1_1TimeoutSource.html</anchorfile>
      <anchor>a08b0603920ff6ca9d3986121d584746a</anchor>
      <arglist>(int &amp;timeout)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual bool</type>
      <name>check</name>
      <anchorfile>classGlib_1_1TimeoutSource.html</anchorfile>
      <anchor>a1d618d99c0d7d6b65b0118174e1cfdfc</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual bool</type>
      <name>dispatch</name>
      <anchorfile>classGlib_1_1TimeoutSource.html</anchorfile>
      <anchor>a27f49b37169765057787f68dabb0cad3</anchor>
      <arglist>(sigc::slot_base *slot)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glib::IdleSource</name>
    <filename>classGlib_1_1IdleSource.html</filename>
    <base>Glib::Source</base>
    <member kind="typedef">
      <type>Glib::IdleSource</type>
      <name>CppObjectType</name>
      <anchorfile>classGlib_1_1IdleSource.html</anchorfile>
      <anchor>a0b70fdba79b73916c80aade11346aff9</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>sigc::connection</type>
      <name>connect</name>
      <anchorfile>classGlib_1_1IdleSource.html</anchorfile>
      <anchor>aeac761cf8634206bf4e599ae468140e1</anchor>
      <arglist>(const sigc::slot&lt; bool &gt; &amp;slot)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; IdleSource &gt;</type>
      <name>create</name>
      <anchorfile>classGlib_1_1IdleSource.html</anchorfile>
      <anchor>a2d60b73fff1919fb0b9022a4d9a0b148</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>IdleSource</name>
      <anchorfile>classGlib_1_1IdleSource.html</anchorfile>
      <anchor>a4970d5053f39e3200ae09d15b7a9507f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual</type>
      <name>~IdleSource</name>
      <anchorfile>classGlib_1_1IdleSource.html</anchorfile>
      <anchor>a898491e226ae73dfc191f81905ae8165</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual bool</type>
      <name>prepare</name>
      <anchorfile>classGlib_1_1IdleSource.html</anchorfile>
      <anchor>acc5555f554ce39e52a039da6a49bd259</anchor>
      <arglist>(int &amp;timeout)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual bool</type>
      <name>check</name>
      <anchorfile>classGlib_1_1IdleSource.html</anchorfile>
      <anchor>ad909d691258ed037243d2ae444160964</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual bool</type>
      <name>dispatch</name>
      <anchorfile>classGlib_1_1IdleSource.html</anchorfile>
      <anchor>a47da1054d939bd656d704c719ddd5633</anchor>
      <arglist>(sigc::slot_base *slot_data)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glib::IOSource</name>
    <filename>classGlib_1_1IOSource.html</filename>
    <base>Glib::Source</base>
    <member kind="typedef">
      <type>Glib::IOSource</type>
      <name>CppObjectType</name>
      <anchorfile>classGlib_1_1IOSource.html</anchorfile>
      <anchor>a53b297a9c28f4dfbdb25dcbd12676797</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>sigc::connection</type>
      <name>connect</name>
      <anchorfile>classGlib_1_1IOSource.html</anchorfile>
      <anchor>a2fc25e8e5d5ff2a1388226b92a6d7164</anchor>
      <arglist>(const sigc::slot&lt; bool, IOCondition &gt; &amp;slot)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; IOSource &gt;</type>
      <name>create</name>
      <anchorfile>classGlib_1_1IOSource.html</anchorfile>
      <anchor>ac2dd533bf8293c42a157173d8a64a9fa</anchor>
      <arglist>(int fd, IOCondition condition)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; IOSource &gt;</type>
      <name>create</name>
      <anchorfile>classGlib_1_1IOSource.html</anchorfile>
      <anchor>ae47864cf6220de79dc9902719917750e</anchor>
      <arglist>(const Glib::RefPtr&lt; IOChannel &gt; &amp;channel, IOCondition condition)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>IOSource</name>
      <anchorfile>classGlib_1_1IOSource.html</anchorfile>
      <anchor>a93fc45dbe64b0c3f1a8d1fae1ede3625</anchor>
      <arglist>(int fd, IOCondition condition)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>IOSource</name>
      <anchorfile>classGlib_1_1IOSource.html</anchorfile>
      <anchor>ac6f9fd1ae2a5767e84bfb948419a168e</anchor>
      <arglist>(const Glib::RefPtr&lt; IOChannel &gt; &amp;channel, IOCondition condition)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual</type>
      <name>~IOSource</name>
      <anchorfile>classGlib_1_1IOSource.html</anchorfile>
      <anchor>a6a55eea63478f8ecb56d3fb147940cfc</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual bool</type>
      <name>prepare</name>
      <anchorfile>classGlib_1_1IOSource.html</anchorfile>
      <anchor>a3a4aec26372e72bdfb709e6fe37a205d</anchor>
      <arglist>(int &amp;timeout)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual bool</type>
      <name>check</name>
      <anchorfile>classGlib_1_1IOSource.html</anchorfile>
      <anchor>a110d00d58e547a8c3f0af3885c7ec7cb</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual bool</type>
      <name>dispatch</name>
      <anchorfile>classGlib_1_1IOSource.html</anchorfile>
      <anchor>aaf471a16f9b9659af63d8f0b39cea51f</anchor>
      <arglist>(sigc::slot_base *slot)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glib::Object</name>
    <filename>classGlib_1_1Object.html</filename>
    <base virtualness="virtual">Glib::ObjectBase</base>
    <member kind="typedef">
      <type>void(*</type>
      <name>DestroyNotify</name>
      <anchorfile>classGlib_1_1Object.html</anchorfile>
      <anchor>a1d8d9f3c19b59eda96c40beca8d520e0</anchor>
      <arglist>)(gpointer data)</arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>get_data</name>
      <anchorfile>classGlib_1_1Object.html</anchorfile>
      <anchor>a0e6581bcbcc6197cca07df24bb91c492</anchor>
      <arglist>(const QueryQuark &amp;key)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_data</name>
      <anchorfile>classGlib_1_1Object.html</anchorfile>
      <anchor>afff7a375a862f3f899daaa99710122fa</anchor>
      <arglist>(const Quark &amp;key, void *data)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_data</name>
      <anchorfile>classGlib_1_1Object.html</anchorfile>
      <anchor>a1febe3bae2dd71756e98e523cd33c1b4</anchor>
      <arglist>(const Quark &amp;key, void *data, DestroyNotify notify)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove_data</name>
      <anchorfile>classGlib_1_1Object.html</anchorfile>
      <anchor>aada5b50844bda7ee02bed0ae2a715c00</anchor>
      <arglist>(const QueryQuark &amp;quark)</arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>steal_data</name>
      <anchorfile>classGlib_1_1Object.html</anchorfile>
      <anchor>ab454f71bd74403b0cc46d3cbbedd6b0e</anchor>
      <arglist>(const QueryQuark &amp;quark)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Object</name>
      <anchorfile>classGlib_1_1Object.html</anchorfile>
      <anchor>ad43f7c5ad0336e1eb3af622392a112eb</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Object</name>
      <anchorfile>classGlib_1_1Object.html</anchorfile>
      <anchor>a6d72588496bd7ac03f72420021fb94a5</anchor>
      <arglist>(const Glib::ConstructParams &amp;construct_params)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Object</name>
      <anchorfile>classGlib_1_1Object.html</anchorfile>
      <anchor>a6f490eeaeb71db673c36799a0f729be5</anchor>
      <arglist>(GObject *castitem)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual</type>
      <name>~Object</name>
      <anchorfile>classGlib_1_1Object.html</anchorfile>
      <anchor>a5ae4319439a3a03d8f803fb5a27f12df</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Glib::Object &gt;</type>
      <name>wrap</name>
      <anchorfile>classGlib_1_1Object.html</anchorfile>
      <anchor>ae4dea9a8dc611d6e4400a5b6a3cb4e7f</anchor>
      <arglist>(GObject *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glib::ObjectBase</name>
    <filename>classGlib_1_1ObjectBase.html</filename>
    <base virtualness="virtual">sigc::trackable</base>
    <member kind="function">
      <type>void</type>
      <name>set_property_value</name>
      <anchorfile>classGlib_1_1ObjectBase.html</anchorfile>
      <anchor>aab599d3eec4b4a9ddc95ccdc6100053d</anchor>
      <arglist>(const Glib::ustring &amp;property_name, const Glib::ValueBase &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_property_value</name>
      <anchorfile>classGlib_1_1ObjectBase.html</anchorfile>
      <anchor>a5e30750441b92f0246c9d4ece95fc8a0</anchor>
      <arglist>(const Glib::ustring &amp;property_name, Glib::ValueBase &amp;value) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_property</name>
      <anchorfile>classGlib_1_1ObjectBase.html</anchorfile>
      <anchor>a804777e39f95c7221febc3ce2c72332b</anchor>
      <arglist>(const Glib::ustring &amp;property_name, const PropertyType &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_property</name>
      <anchorfile>classGlib_1_1ObjectBase.html</anchorfile>
      <anchor>a99efdd4fceb7028ea54ec53ab680d60b</anchor>
      <arglist>(const Glib::ustring &amp;property_name, PropertyType &amp;value) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>connect_property_changed</name>
      <anchorfile>classGlib_1_1ObjectBase.html</anchorfile>
      <anchor>adc6c1e8f094275114d6e2c3ef3a33f98</anchor>
      <arglist>(const Glib::ustring &amp;property_name, const sigc::slot&lt; void &gt; &amp;slot)</arglist>
    </member>
    <member kind="function">
      <type>sigc::connection</type>
      <name>connect_property_changed_with_return</name>
      <anchorfile>classGlib_1_1ObjectBase.html</anchorfile>
      <anchor>a896d7773c00bd2dcd310c861282ee8d1</anchor>
      <arglist>(const Glib::ustring &amp;property_name, const sigc::slot&lt; void &gt; &amp;slot)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>freeze_notify</name>
      <anchorfile>classGlib_1_1ObjectBase.html</anchorfile>
      <anchor>a6e9e13b75f116c20212d318204ce8ea3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>thaw_notify</name>
      <anchorfile>classGlib_1_1ObjectBase.html</anchorfile>
      <anchor>a1bd8ea7bd8c4084ade6b3c27dddf06a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>reference</name>
      <anchorfile>classGlib_1_1ObjectBase.html</anchorfile>
      <anchor>a896a8a5db20043ea82956e3ef4b9c4ae</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>unreference</name>
      <anchorfile>classGlib_1_1ObjectBase.html</anchorfile>
      <anchor>a3234b8ffb2a35b927e2978c8f3bfbfe3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GObject *</type>
      <name>gobj</name>
      <anchorfile>classGlib_1_1ObjectBase.html</anchorfile>
      <anchor>a4c6efc18be8cb9c56e58fc0bd20fafbe</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GObject *</type>
      <name>gobj</name>
      <anchorfile>classGlib_1_1ObjectBase.html</anchorfile>
      <anchor>a778a94181132976bbfb0519793f3b32e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GObject *</type>
      <name>gobj_copy</name>
      <anchorfile>classGlib_1_1ObjectBase.html</anchorfile>
      <anchor>a9b2a5eb93102f1849e5419016e22a15f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>ObjectBase</name>
      <anchorfile>classGlib_1_1ObjectBase.html</anchorfile>
      <anchor>a27d3451d9ca28d6a2f00838d7c56d545</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>ObjectBase</name>
      <anchorfile>classGlib_1_1ObjectBase.html</anchorfile>
      <anchor>ad4ef18214894c6874579313ab21d1018</anchor>
      <arglist>(const char *custom_type_name)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>ObjectBase</name>
      <anchorfile>classGlib_1_1ObjectBase.html</anchorfile>
      <anchor>a3d59b4d85b0ee72a727e6b2e1b31a2ff</anchor>
      <arglist>(const std::type_info &amp;custom_type_info)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="pure">
      <type>virtual</type>
      <name>~ObjectBase</name>
      <anchorfile>classGlib_1_1ObjectBase.html</anchorfile>
      <anchor>a42ac047a06c36c2d9c75f7cffc537dc4</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>initialize</name>
      <anchorfile>classGlib_1_1ObjectBase.html</anchorfile>
      <anchor>a3faafb14c4f0ca60fbf0f5f5c4d549d0</anchor>
      <arglist>(GObject *castitem)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glib::PatternSpec</name>
    <filename>classGlib_1_1PatternSpec.html</filename>
    <member kind="function">
      <type></type>
      <name>PatternSpec</name>
      <anchorfile>classGlib_1_1PatternSpec.html</anchorfile>
      <anchor>afc18aa40675afcdf3e62c6f5ac4d67e9</anchor>
      <arglist>(const Glib::ustring &amp;pattern)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>PatternSpec</name>
      <anchorfile>classGlib_1_1PatternSpec.html</anchorfile>
      <anchor>ab8c5ce3d5297d01f0db9055bfa61d9fa</anchor>
      <arglist>(GPatternSpec *gobject)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~PatternSpec</name>
      <anchorfile>classGlib_1_1PatternSpec.html</anchorfile>
      <anchor>a632b3dddb4474c101ba5928c56e9241f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>match</name>
      <anchorfile>classGlib_1_1PatternSpec.html</anchorfile>
      <anchor>ab7b6f1a9be3dacfbbd9b8ccf250879ba</anchor>
      <arglist>(const Glib::ustring &amp;str) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>match</name>
      <anchorfile>classGlib_1_1PatternSpec.html</anchorfile>
      <anchor>a01ffc20a65f707383f2940c5b23918b0</anchor>
      <arglist>(const Glib::ustring &amp;str, const Glib::ustring &amp;str_reversed) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>classGlib_1_1PatternSpec.html</anchorfile>
      <anchor>a1fc213b6fa0c79676b0813f4f6844d2d</anchor>
      <arglist>(const PatternSpec &amp;rhs) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>classGlib_1_1PatternSpec.html</anchorfile>
      <anchor>a8ee9597a79da95097edebc084ef7189c</anchor>
      <arglist>(const PatternSpec &amp;rhs) const </arglist>
    </member>
    <member kind="function">
      <type>GPatternSpec *</type>
      <name>gobj</name>
      <anchorfile>classGlib_1_1PatternSpec.html</anchorfile>
      <anchor>a6c01de7b965dd5bbe2bdce8527ac9af5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GPatternSpec *</type>
      <name>gobj</name>
      <anchorfile>classGlib_1_1PatternSpec.html</anchorfile>
      <anchor>a833bfbd56088c2edf1d17546ac9d4b78</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glib::PropertyBase</name>
    <filename>classGlib_1_1PropertyBase.html</filename>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_name</name>
      <anchorfile>classGlib_1_1PropertyBase.html</anchorfile>
      <anchor>a89dee7c3023f99bf2d1ce8792177a91d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>notify</name>
      <anchorfile>classGlib_1_1PropertyBase.html</anchorfile>
      <anchor>ada1c2294c7b3b159af8b5dad1ad02c16</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>PropertyBase</name>
      <anchorfile>classGlib_1_1PropertyBase.html</anchorfile>
      <anchor>aa6c0b97d8561766b8f4a9f5a183c9f00</anchor>
      <arglist>(Glib::Object &amp;object, GType value_type)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>~PropertyBase</name>
      <anchorfile>classGlib_1_1PropertyBase.html</anchorfile>
      <anchor>abe19b39fa1b7b75b95da94390f8bc19b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>bool</type>
      <name>lookup_property</name>
      <anchorfile>classGlib_1_1PropertyBase.html</anchorfile>
      <anchor>a4a0e9de0bb457270b6c307d14e9c5a02</anchor>
      <arglist>(const Glib::ustring &amp;name)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>install_property</name>
      <anchorfile>classGlib_1_1PropertyBase.html</anchorfile>
      <anchor>a5d63e95270aa1aa16f9a9c896897184c</anchor>
      <arglist>(GParamSpec *param_spec)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>const char *</type>
      <name>get_name_internal</name>
      <anchorfile>classGlib_1_1PropertyBase.html</anchorfile>
      <anchor>a357eabbcb3ce5a694370d73a4921337e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>Glib::Object *</type>
      <name>object_</name>
      <anchorfile>classGlib_1_1PropertyBase.html</anchorfile>
      <anchor>a7191a31bd5cb2665947378ea58b3a4ed</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>Glib::ValueBase</type>
      <name>value_</name>
      <anchorfile>classGlib_1_1PropertyBase.html</anchorfile>
      <anchor>a82bc5e296e19c2d7e42a0b78fb5f2062</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>GParamSpec *</type>
      <name>param_spec_</name>
      <anchorfile>classGlib_1_1PropertyBase.html</anchorfile>
      <anchor>a227edf3035194bbb6f161c4ae9a74280</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glib::Property</name>
    <filename>classGlib_1_1Property.html</filename>
    <templarg></templarg>
    <base>Glib::PropertyBase</base>
    <member kind="typedef">
      <type>T</type>
      <name>PropertyType</name>
      <anchorfile>classGlib_1_1Property.html</anchorfile>
      <anchor>a7ab4e7520876b32d031842816c8b33f9</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Glib::Value&lt; T &gt;</type>
      <name>ValueType</name>
      <anchorfile>classGlib_1_1Property.html</anchorfile>
      <anchor>a9e0517ff48ae26638e22768506769afa</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Property</name>
      <anchorfile>classGlib_1_1Property.html</anchorfile>
      <anchor>a3a9605f1efc1c170059804bed07a41ac</anchor>
      <arglist>(Glib::Object &amp;object, const Glib::ustring &amp;name)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Property</name>
      <anchorfile>classGlib_1_1Property.html</anchorfile>
      <anchor>a9bd490d36e1068ba4c1225d941530603</anchor>
      <arglist>(Glib::Object &amp;object, const Glib::ustring &amp;name, const PropertyType &amp;default_value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_value</name>
      <anchorfile>classGlib_1_1Property.html</anchorfile>
      <anchor>a19fbb8ff9bad70974e28e487284a48db</anchor>
      <arglist>(const PropertyType &amp;data)</arglist>
    </member>
    <member kind="function">
      <type>PropertyType</type>
      <name>get_value</name>
      <anchorfile>classGlib_1_1Property.html</anchorfile>
      <anchor>ad8d4a26b3ee23cb7f3b5067a2a7fc77b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Property&lt; T &gt; &amp;</type>
      <name>operator=</name>
      <anchorfile>classGlib_1_1Property.html</anchorfile>
      <anchor>a07169f608d8d53833c305da5936a922e</anchor>
      <arglist>(const PropertyType &amp;data)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>operator PropertyType</name>
      <anchorfile>classGlib_1_1Property.html</anchorfile>
      <anchor>a0c32a8465004fcd2c300f84b75666335</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; T &gt;</type>
      <name>get_proxy</name>
      <anchorfile>classGlib_1_1Property.html</anchorfile>
      <anchor>a50f48c982d6d2fbd1fcf60bd6965a34f</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glib::PropertyProxy</name>
    <filename>classGlib_1_1PropertyProxy.html</filename>
    <templarg></templarg>
    <base>Glib::PropertyProxy_Base</base>
    <member kind="typedef">
      <type>T</type>
      <name>PropertyType</name>
      <anchorfile>classGlib_1_1PropertyProxy.html</anchorfile>
      <anchor>ad5f4eac0a367fae18b0db33ab6c42235</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>PropertyProxy</name>
      <anchorfile>classGlib_1_1PropertyProxy.html</anchorfile>
      <anchor>af8353d01e3ae6134eaceaf900ffb84b9</anchor>
      <arglist>(ObjectBase *obj, const char *name)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_value</name>
      <anchorfile>classGlib_1_1PropertyProxy.html</anchorfile>
      <anchor>aff4eb140b4f4da0488c4387c1047ad82</anchor>
      <arglist>(const PropertyType &amp;data)</arglist>
    </member>
    <member kind="function">
      <type>PropertyType</type>
      <name>get_value</name>
      <anchorfile>classGlib_1_1PropertyProxy.html</anchorfile>
      <anchor>a4bbf4c99c138e7e33ce6393147b4e121</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>reset_value</name>
      <anchorfile>classGlib_1_1PropertyProxy.html</anchorfile>
      <anchor>a4ea1719ff572be400fdce1f3257fdf59</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>PropertyProxy&lt; T &gt; &amp;</type>
      <name>operator=</name>
      <anchorfile>classGlib_1_1PropertyProxy.html</anchorfile>
      <anchor>add4490830382a8173acf097dffffd92e</anchor>
      <arglist>(const PropertyType &amp;data)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>operator PropertyType</name>
      <anchorfile>classGlib_1_1PropertyProxy.html</anchorfile>
      <anchor>a127addf739d2d3f40c4a066a543ef967</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glib::PropertyProxy_WriteOnly</name>
    <filename>classGlib_1_1PropertyProxy__WriteOnly.html</filename>
    <templarg></templarg>
    <base>Glib::PropertyProxy_Base</base>
    <member kind="typedef">
      <type>T</type>
      <name>PropertyType</name>
      <anchorfile>classGlib_1_1PropertyProxy__WriteOnly.html</anchorfile>
      <anchor>ab793e05112b9cf356d29f32f3a4389c7</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>PropertyProxy_WriteOnly</name>
      <anchorfile>classGlib_1_1PropertyProxy__WriteOnly.html</anchorfile>
      <anchor>aa8fc4a6944fa92745e6db12f8a102e04</anchor>
      <arglist>(ObjectBase *obj, const char *name)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_value</name>
      <anchorfile>classGlib_1_1PropertyProxy__WriteOnly.html</anchorfile>
      <anchor>a30500a1c44729093af1e5e9b1110b80a</anchor>
      <arglist>(const PropertyType &amp;data)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>reset_value</name>
      <anchorfile>classGlib_1_1PropertyProxy__WriteOnly.html</anchorfile>
      <anchor>a000abcd69676eeb0afefd671e4670c28</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>PropertyProxy_WriteOnly&lt; T &gt; &amp;</type>
      <name>operator=</name>
      <anchorfile>classGlib_1_1PropertyProxy__WriteOnly.html</anchorfile>
      <anchor>aa62bc22fa9389657d8562d375b616401</anchor>
      <arglist>(const PropertyType &amp;data)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glib::PropertyProxy_ReadOnly</name>
    <filename>classGlib_1_1PropertyProxy__ReadOnly.html</filename>
    <templarg></templarg>
    <base>Glib::PropertyProxy_Base</base>
    <member kind="typedef">
      <type>T</type>
      <name>PropertyType</name>
      <anchorfile>classGlib_1_1PropertyProxy__ReadOnly.html</anchorfile>
      <anchor>ae9be436770223139b25acd136fd1e2da</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>PropertyProxy_ReadOnly</name>
      <anchorfile>classGlib_1_1PropertyProxy__ReadOnly.html</anchorfile>
      <anchor>a49910fa712bce1cd0ae51e6728f9619f</anchor>
      <arglist>(const ObjectBase *obj, const char *name)</arglist>
    </member>
    <member kind="function">
      <type>PropertyType</type>
      <name>get_value</name>
      <anchorfile>classGlib_1_1PropertyProxy__ReadOnly.html</anchorfile>
      <anchor>a187f0f2ba5e18198fd0cc64381b466ce</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>operator PropertyType</name>
      <anchorfile>classGlib_1_1PropertyProxy__ReadOnly.html</anchorfile>
      <anchor>af03f7075d100e4e0f8759bde8990b80f</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glib::SignalProxyProperty</name>
    <filename>classGlib_1_1SignalProxyProperty.html</filename>
    <base>Glib::SignalProxyBase</base>
    <member kind="typedef">
      <type>sigc::slot&lt; void &gt;</type>
      <name>SlotType</name>
      <anchorfile>classGlib_1_1SignalProxyProperty.html</anchorfile>
      <anchor>ac9c7309b66266e9da0b24d99988174b8</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SignalProxyProperty</name>
      <anchorfile>classGlib_1_1SignalProxyProperty.html</anchorfile>
      <anchor>a7fedeaa4f15140fa40b99b2dd5a9657b</anchor>
      <arglist>(Glib::ObjectBase *obj, const gchar *property_name)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SignalProxyProperty</name>
      <anchorfile>classGlib_1_1SignalProxyProperty.html</anchorfile>
      <anchor>a7f3c64d03b63a01cd29077fb4792988d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>sigc::connection</type>
      <name>connect</name>
      <anchorfile>classGlib_1_1SignalProxyProperty.html</anchorfile>
      <anchor>a911d4e8417d1ee28b4286030ddb40e4c</anchor>
      <arglist>(const SlotType &amp;sl)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>const char *</type>
      <name>property_name_</name>
      <anchorfile>classGlib_1_1SignalProxyProperty.html</anchorfile>
      <anchor>a74a5e9f3fe2b3029bb4eb0110cd57cd1</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glib::PropertyProxy_Base</name>
    <filename>classGlib_1_1PropertyProxy__Base.html</filename>
    <member kind="function">
      <type></type>
      <name>PropertyProxy_Base</name>
      <anchorfile>classGlib_1_1PropertyProxy__Base.html</anchorfile>
      <anchor>a249bf7fbed57d8feca6280747e85cd35</anchor>
      <arglist>(ObjectBase *obj, const char *property_name)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>PropertyProxy_Base</name>
      <anchorfile>classGlib_1_1PropertyProxy__Base.html</anchorfile>
      <anchor>ad21a12ef0a572caec3b160561f60e8ee</anchor>
      <arglist>(const PropertyProxy_Base &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>SignalProxyProperty</type>
      <name>signal_changed</name>
      <anchorfile>classGlib_1_1PropertyProxy__Base.html</anchorfile>
      <anchor>a19357ed2e9492700e37215edb81fd071</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>ObjectBase *</type>
      <name>get_object</name>
      <anchorfile>classGlib_1_1PropertyProxy__Base.html</anchorfile>
      <anchor>a0a0360fc03da108b2748285c834c81f5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>get_name</name>
      <anchorfile>classGlib_1_1PropertyProxy__Base.html</anchorfile>
      <anchor>a99f16695928aa09959de3046eaa6c266</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>set_property_</name>
      <anchorfile>classGlib_1_1PropertyProxy__Base.html</anchorfile>
      <anchor>a062bab7773ae2e9666a26fb6426003d2</anchor>
      <arglist>(const Glib::ValueBase &amp;value)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>get_property_</name>
      <anchorfile>classGlib_1_1PropertyProxy__Base.html</anchorfile>
      <anchor>ad8d3fea5cc9fe955bd1cb29d8d37da99</anchor>
      <arglist>(Glib::ValueBase &amp;value) const </arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>reset_property_</name>
      <anchorfile>classGlib_1_1PropertyProxy__Base.html</anchorfile>
      <anchor>a2551363499a510336507194725de6c43</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>ObjectBase *</type>
      <name>obj_</name>
      <anchorfile>classGlib_1_1PropertyProxy__Base.html</anchorfile>
      <anchor>ae027890146dbc4acfa49634e7c44cce9</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>const char *</type>
      <name>property_name_</name>
      <anchorfile>classGlib_1_1PropertyProxy__Base.html</anchorfile>
      <anchor>af76cdd8c35935963d0f9d5975e81a726</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glib::QueryQuark</name>
    <filename>classGlib_1_1QueryQuark.html</filename>
    <member kind="function">
      <type></type>
      <name>QueryQuark</name>
      <anchorfile>classGlib_1_1QueryQuark.html</anchorfile>
      <anchor>a4373d14f457d6fa855ba8856ab2aa7a3</anchor>
      <arglist>(const GQuark &amp;q)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>QueryQuark</name>
      <anchorfile>classGlib_1_1QueryQuark.html</anchorfile>
      <anchor>af9aec4964064bfc5729d3c1dea64bfc2</anchor>
      <arglist>(const ustring &amp;s)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>QueryQuark</name>
      <anchorfile>classGlib_1_1QueryQuark.html</anchorfile>
      <anchor>a689ea595339a8aa820889679566dad9c</anchor>
      <arglist>(const char *s)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~QueryQuark</name>
      <anchorfile>classGlib_1_1QueryQuark.html</anchorfile>
      <anchor>a11d61a902d6a2d7fa0320d8dccdd80ae</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QueryQuark &amp;</type>
      <name>operator=</name>
      <anchorfile>classGlib_1_1QueryQuark.html</anchorfile>
      <anchor>a38371df4b4b7b1f8a507cb5005926a4b</anchor>
      <arglist>(const QueryQuark &amp;q)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>operator ustring</name>
      <anchorfile>classGlib_1_1QueryQuark.html</anchorfile>
      <anchor>afad20a823ed00ee534d73c85c7356cbe</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>operator GQuark</name>
      <anchorfile>classGlib_1_1QueryQuark.html</anchorfile>
      <anchor>a60cc4d06c14341960cddd6210c97ecd1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GQuark</type>
      <name>id</name>
      <anchorfile>classGlib_1_1QueryQuark.html</anchorfile>
      <anchor>aa242f5723b6e2f856ee8a7dabad54908</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glib::Quark</name>
    <filename>classGlib_1_1Quark.html</filename>
    <base>Glib::QueryQuark</base>
    <member kind="function">
      <type></type>
      <name>Quark</name>
      <anchorfile>classGlib_1_1Quark.html</anchorfile>
      <anchor>a951c36a3aeeba482e72e7ee1e1af1d3f</anchor>
      <arglist>(const ustring &amp;s)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Quark</name>
      <anchorfile>classGlib_1_1Quark.html</anchorfile>
      <anchor>a6b629a0d8f6a4ba0da254b180cab4cc4</anchor>
      <arglist>(const char *s)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~Quark</name>
      <anchorfile>classGlib_1_1Quark.html</anchorfile>
      <anchor>af332fd59c51a2e805609af0e4be19e29</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glib::Rand</name>
    <filename>classGlib_1_1Rand.html</filename>
    <member kind="function">
      <type></type>
      <name>Rand</name>
      <anchorfile>classGlib_1_1Rand.html</anchorfile>
      <anchor>a61110e0e8ef1566076feacdb4d472f78</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Rand</name>
      <anchorfile>classGlib_1_1Rand.html</anchorfile>
      <anchor>acec64f502eee6193abc892e85c0c4577</anchor>
      <arglist>(guint32 seed)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~Rand</name>
      <anchorfile>classGlib_1_1Rand.html</anchorfile>
      <anchor>ae0c1611e959aeeafb8f9a3f73c7ac59d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_seed</name>
      <anchorfile>classGlib_1_1Rand.html</anchorfile>
      <anchor>a4a545e4f20bd7e603c14d46c17d3fe4f</anchor>
      <arglist>(guint32 seed)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_bool</name>
      <anchorfile>classGlib_1_1Rand.html</anchorfile>
      <anchor>a4d90f1e3ef59d0b071efa0445b6fb469</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>guint32</type>
      <name>get_int</name>
      <anchorfile>classGlib_1_1Rand.html</anchorfile>
      <anchor>a22cefc85a2eb30bfcae6180a5ff33338</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>gint32</type>
      <name>get_int_range</name>
      <anchorfile>classGlib_1_1Rand.html</anchorfile>
      <anchor>a182b9a36db153d316baf5efb1ece9fd7</anchor>
      <arglist>(gint32 begin, gint32 end)</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>get_double</name>
      <anchorfile>classGlib_1_1Rand.html</anchorfile>
      <anchor>ae439c4403f696ee326c2569386e99819</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>get_double_range</name>
      <anchorfile>classGlib_1_1Rand.html</anchorfile>
      <anchor>a997d49286a48fdc484f643bf665bef86</anchor>
      <arglist>(double begin, double end)</arglist>
    </member>
    <member kind="function">
      <type>GRand *</type>
      <name>gobj</name>
      <anchorfile>classGlib_1_1Rand.html</anchorfile>
      <anchor>a9e0662cd37ac942a23d434ae8fe861e1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GRand *</type>
      <name>gobj</name>
      <anchorfile>classGlib_1_1Rand.html</anchorfile>
      <anchor>aa47686d4dc285684c86879bb5dfb5a57</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glib::RefPtr</name>
    <filename>classGlib_1_1RefPtr.html</filename>
    <templarg>T_CppObject</templarg>
    <member kind="function">
      <type></type>
      <name>RefPtr</name>
      <anchorfile>classGlib_1_1RefPtr.html</anchorfile>
      <anchor>a8b6c39656dbc5d452933b35faf352f74</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~RefPtr</name>
      <anchorfile>classGlib_1_1RefPtr.html</anchorfile>
      <anchor>a36b7fbe4a04bfe51f56b3c7062bb1316</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>RefPtr</name>
      <anchorfile>classGlib_1_1RefPtr.html</anchorfile>
      <anchor>aca71e4ac99f37bf901ca3709a4bcf487</anchor>
      <arglist>(T_CppObject *pCppObject)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>RefPtr</name>
      <anchorfile>classGlib_1_1RefPtr.html</anchorfile>
      <anchor>abaf32caf7deadcabeec0fd7f95bd1d7f</anchor>
      <arglist>(const RefPtr&lt; T_CppObject &gt; &amp;src)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>RefPtr</name>
      <anchorfile>classGlib_1_1RefPtr.html</anchorfile>
      <anchor>a98888fc0f3ce85f63be12a7a7cf96e5f</anchor>
      <arglist>(const RefPtr&lt; T_CastFrom &gt; &amp;src)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>swap</name>
      <anchorfile>classGlib_1_1RefPtr.html</anchorfile>
      <anchor>ab54eb64fe0e872a0b88119107a5ba1f3</anchor>
      <arglist>(RefPtr&lt; T_CppObject &gt; &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>RefPtr&lt; T_CppObject &gt; &amp;</type>
      <name>operator=</name>
      <anchorfile>classGlib_1_1RefPtr.html</anchorfile>
      <anchor>a80ea91e3e0e0c460f941266980e14416</anchor>
      <arglist>(const RefPtr&lt; T_CppObject &gt; &amp;src)</arglist>
    </member>
    <member kind="function">
      <type>RefPtr&lt; T_CppObject &gt; &amp;</type>
      <name>operator=</name>
      <anchorfile>classGlib_1_1RefPtr.html</anchorfile>
      <anchor>a36aa3105afb9b4787aad014cf347deb4</anchor>
      <arglist>(const RefPtr&lt; T_CastFrom &gt; &amp;src)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>classGlib_1_1RefPtr.html</anchorfile>
      <anchor>a94830ac72b547040600ba157af592a93</anchor>
      <arglist>(const RefPtr&lt; T_CppObject &gt; &amp;src) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>classGlib_1_1RefPtr.html</anchorfile>
      <anchor>a18d79f08aeea24f8fdc6ed6f94c428fb</anchor>
      <arglist>(const RefPtr&lt; T_CppObject &gt; &amp;src) const </arglist>
    </member>
    <member kind="function">
      <type>T_CppObject *</type>
      <name>operator-&gt;</name>
      <anchorfile>classGlib_1_1RefPtr.html</anchorfile>
      <anchor>a62cd21eed81024435a6ec778e991365c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>operator bool</name>
      <anchorfile>classGlib_1_1RefPtr.html</anchorfile>
      <anchor>a8a7604cb37dea79a1f3e4015621bce46</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>clear</name>
      <anchorfile>classGlib_1_1RefPtr.html</anchorfile>
      <anchor>ab7fb103f02d4a0fb21d7a8d0824047cc</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>reset</name>
      <anchorfile>classGlib_1_1RefPtr.html</anchorfile>
      <anchor>abdcc38a6aeef7ae330c045eaf9324b71</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static RefPtr&lt; T_CppObject &gt;</type>
      <name>cast_dynamic</name>
      <anchorfile>classGlib_1_1RefPtr.html</anchorfile>
      <anchor>a5315f011eeb21ec3858b5f7e8e72a9d1</anchor>
      <arglist>(const RefPtr&lt; T_CastFrom &gt; &amp;src)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static RefPtr&lt; T_CppObject &gt;</type>
      <name>cast_static</name>
      <anchorfile>classGlib_1_1RefPtr.html</anchorfile>
      <anchor>a548fd6f5629a269e6ac0fd3db9c4fe6b</anchor>
      <arglist>(const RefPtr&lt; T_CastFrom &gt; &amp;src)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static RefPtr&lt; T_CppObject &gt;</type>
      <name>cast_const</name>
      <anchorfile>classGlib_1_1RefPtr.html</anchorfile>
      <anchor>a7891cd91b8a2f6d68226574bd21fe193</anchor>
      <arglist>(const RefPtr&lt; T_CastFrom &gt; &amp;src)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glib::SListHandle</name>
    <filename>classGlib_1_1SListHandle.html</filename>
    <templarg></templarg>
    <templarg></templarg>
    <member kind="typedef">
      <type>Tr::CppType</type>
      <name>CppType</name>
      <anchorfile>classGlib_1_1SListHandle.html</anchorfile>
      <anchor>a1a0f5b4ea6dfa404fd750e1d5a299cb5</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Tr::CType</type>
      <name>CType</name>
      <anchorfile>classGlib_1_1SListHandle.html</anchorfile>
      <anchor>ae27beb74adc3d2b29e4f162ecdac2daf</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>CppType</type>
      <name>value_type</name>
      <anchorfile>classGlib_1_1SListHandle.html</anchorfile>
      <anchor>abf106ec7c2ad5f59a05dccbb9cbabb9f</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>size_t</type>
      <name>size_type</name>
      <anchorfile>classGlib_1_1SListHandle.html</anchorfile>
      <anchor>aced9c2ca535ce9b75b692f1c13f18e94</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>ptrdiff_t</type>
      <name>difference_type</name>
      <anchorfile>classGlib_1_1SListHandle.html</anchorfile>
      <anchor>a830d595698763d001820cd2521c83da5</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Glib::Container_Helpers::SListHandleIterator&lt; Tr &gt;</type>
      <name>const_iterator</name>
      <anchorfile>classGlib_1_1SListHandle.html</anchorfile>
      <anchor>ad9a2637f0adec0d2dc56b8f26aaa9bcb</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Glib::Container_Helpers::SListHandleIterator&lt; Tr &gt;</type>
      <name>iterator</name>
      <anchorfile>classGlib_1_1SListHandle.html</anchorfile>
      <anchor>a37ffca039dc422b61f08981a87b62838</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SListHandle</name>
      <anchorfile>classGlib_1_1SListHandle.html</anchorfile>
      <anchor>a6680123784dcdc2528c5e4677d383944</anchor>
      <arglist>(const Cont &amp;container)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SListHandle</name>
      <anchorfile>classGlib_1_1SListHandle.html</anchorfile>
      <anchor>a14f6477eed92aeda49ade71915a6a172</anchor>
      <arglist>(GSList *glist, Glib::OwnershipType ownership)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SListHandle</name>
      <anchorfile>classGlib_1_1SListHandle.html</anchorfile>
      <anchor>a0c35999d203ce8723ed2b7fd0579887e</anchor>
      <arglist>(const SListHandle&lt; T, Tr &gt; &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SListHandle</name>
      <anchorfile>classGlib_1_1SListHandle.html</anchorfile>
      <anchor>afe0de87e1ce88e589d9ea62e1b3d1f73</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const_iterator</type>
      <name>begin</name>
      <anchorfile>classGlib_1_1SListHandle.html</anchorfile>
      <anchor>a4e5ceedb31cd4551f928db6b3bcbb414</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const_iterator</type>
      <name>end</name>
      <anchorfile>classGlib_1_1SListHandle.html</anchorfile>
      <anchor>a6cab595825c6ddf437ca9c35e1222835</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>operator std::vector&lt; U &gt;</name>
      <anchorfile>classGlib_1_1SListHandle.html</anchorfile>
      <anchor>ac924e0efe6c72ed2235bc8223ee5158d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>operator std::deque&lt; U &gt;</name>
      <anchorfile>classGlib_1_1SListHandle.html</anchorfile>
      <anchor>a73314b7e0ef2189d524c22e8954e662b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>operator std::list&lt; U &gt;</name>
      <anchorfile>classGlib_1_1SListHandle.html</anchorfile>
      <anchor>a3b09a68a39972b3b37d80b183071f15f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>assign_to</name>
      <anchorfile>classGlib_1_1SListHandle.html</anchorfile>
      <anchor>a6816037b792a8a89b9b19094351a8857</anchor>
      <arglist>(Cont &amp;container) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy</name>
      <anchorfile>classGlib_1_1SListHandle.html</anchorfile>
      <anchor>adc87e634bd1b1a62ae5b3a0773cf2b0f</anchor>
      <arglist>(Out pdest) const </arglist>
    </member>
    <member kind="function">
      <type>GSList *</type>
      <name>data</name>
      <anchorfile>classGlib_1_1SListHandle.html</anchorfile>
      <anchor>a6eecd613408202c9fa0ee68c6acf51cd</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>size_t</type>
      <name>size</name>
      <anchorfile>classGlib_1_1SListHandle.html</anchorfile>
      <anchor>a7c6d991e85fb74779bc4be046318a8f5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>empty</name>
      <anchorfile>classGlib_1_1SListHandle.html</anchorfile>
      <anchor>a60e282c29d1e15cc25d161afb0de0f9f</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glib::StreamIOChannel</name>
    <filename>classGlib_1_1StreamIOChannel.html</filename>
    <base>Glib::IOChannel</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~StreamIOChannel</name>
      <anchorfile>classGlib_1_1StreamIOChannel.html</anchorfile>
      <anchor>ab2258ca857b53e12918f4acff37b69bb</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; StreamIOChannel &gt;</type>
      <name>create</name>
      <anchorfile>classGlib_1_1StreamIOChannel.html</anchorfile>
      <anchor>af05ec7633a97902748738417ae742d5d</anchor>
      <arglist>(std::istream &amp;stream)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; StreamIOChannel &gt;</type>
      <name>create</name>
      <anchorfile>classGlib_1_1StreamIOChannel.html</anchorfile>
      <anchor>aeb3177836df152b6b4a4debacbffbb16</anchor>
      <arglist>(std::ostream &amp;stream)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; StreamIOChannel &gt;</type>
      <name>create</name>
      <anchorfile>classGlib_1_1StreamIOChannel.html</anchorfile>
      <anchor>aa8b797316447a92a1cd657799922b2da</anchor>
      <arglist>(std::iostream &amp;stream)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>StreamIOChannel</name>
      <anchorfile>classGlib_1_1StreamIOChannel.html</anchorfile>
      <anchor>aef1abb0c118ab43a97b00a860ccf6204</anchor>
      <arglist>(std::istream *stream_in, std::ostream *stream_out)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual IOStatus</type>
      <name>read_vfunc</name>
      <anchorfile>classGlib_1_1StreamIOChannel.html</anchorfile>
      <anchor>aad85c2e9149428db83575ff98bdac482</anchor>
      <arglist>(char *buf, gsize count, gsize &amp;bytes_read)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual IOStatus</type>
      <name>write_vfunc</name>
      <anchorfile>classGlib_1_1StreamIOChannel.html</anchorfile>
      <anchor>a9b6ce8cea1b948c1d408c946c4ad27eb</anchor>
      <arglist>(const char *buf, gsize count, gsize &amp;bytes_written)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual IOStatus</type>
      <name>seek_vfunc</name>
      <anchorfile>classGlib_1_1StreamIOChannel.html</anchorfile>
      <anchor>a82c4a6b077c542d1b79c23ecc6b1772f</anchor>
      <arglist>(gint64 offset, SeekType type)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual IOStatus</type>
      <name>close_vfunc</name>
      <anchorfile>classGlib_1_1StreamIOChannel.html</anchorfile>
      <anchor>a20deabe6a3bc6b1488975375e61af626</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual IOStatus</type>
      <name>set_flags_vfunc</name>
      <anchorfile>classGlib_1_1StreamIOChannel.html</anchorfile>
      <anchor>add1a29876a6d3b553f41ef21dd654f67</anchor>
      <arglist>(IOFlags flags)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual IOFlags</type>
      <name>get_flags_vfunc</name>
      <anchorfile>classGlib_1_1StreamIOChannel.html</anchorfile>
      <anchor>a29a782e3ab6d7fc1b77f612c97c195f6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual Glib::RefPtr&lt; Glib::Source &gt;</type>
      <name>create_watch_vfunc</name>
      <anchorfile>classGlib_1_1StreamIOChannel.html</anchorfile>
      <anchor>a77595f06e524cd2cb3dc7958fd274f4f</anchor>
      <arglist>(IOCondition cond)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>std::istream *</type>
      <name>stream_in_</name>
      <anchorfile>classGlib_1_1StreamIOChannel.html</anchorfile>
      <anchor>a81a491b37d051a0ea5a3c3f8177d74ea</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>std::ostream *</type>
      <name>stream_out_</name>
      <anchorfile>classGlib_1_1StreamIOChannel.html</anchorfile>
      <anchor>a83bcd47600a9a4ab6c3f500479f683c5</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glib::ThreadPool</name>
    <filename>classGlib_1_1ThreadPool.html</filename>
    <member kind="function">
      <type></type>
      <name>ThreadPool</name>
      <anchorfile>classGlib_1_1ThreadPool.html</anchorfile>
      <anchor>afd549a2867eafe34663d8935c17efbe2</anchor>
      <arglist>(int max_threads=-1, bool exclusive=false)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~ThreadPool</name>
      <anchorfile>classGlib_1_1ThreadPool.html</anchorfile>
      <anchor>aaed3b188194822da768fa9a29e608b16</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push</name>
      <anchorfile>classGlib_1_1ThreadPool.html</anchorfile>
      <anchor>a7b37fdac9f7a6e4a8791b4668e23e264</anchor>
      <arglist>(const sigc::slot&lt; void &gt; &amp;slot)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_max_threads</name>
      <anchorfile>classGlib_1_1ThreadPool.html</anchorfile>
      <anchor>ae19ed9a523788e40509ee4f39d2b10a9</anchor>
      <arglist>(int max_threads)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>get_max_threads</name>
      <anchorfile>classGlib_1_1ThreadPool.html</anchorfile>
      <anchor>a6dbe83ceeb65fd0f157e1b1895ed3db5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>unsigned int</type>
      <name>get_num_threads</name>
      <anchorfile>classGlib_1_1ThreadPool.html</anchorfile>
      <anchor>a2a6bc66c4eb03e346429e6f7fe3a5fe3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>unsigned int</type>
      <name>unprocessed</name>
      <anchorfile>classGlib_1_1ThreadPool.html</anchorfile>
      <anchor>a8eb62f226a5f5e2f93b66b25c49cc401</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_exclusive</name>
      <anchorfile>classGlib_1_1ThreadPool.html</anchorfile>
      <anchor>ab59582875f80b94bf4707c1c77f234ba</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>shutdown</name>
      <anchorfile>classGlib_1_1ThreadPool.html</anchorfile>
      <anchor>a14a3e00a1fec5fec2bded78ea6a2b796</anchor>
      <arglist>(bool immediately=false)</arglist>
    </member>
    <member kind="function">
      <type>GThreadPool *</type>
      <name>gobj</name>
      <anchorfile>classGlib_1_1ThreadPool.html</anchorfile>
      <anchor>ac7f444f305942afb54c45204f509bc39</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GThreadPool *</type>
      <name>gobj</name>
      <anchorfile>classGlib_1_1ThreadPool.html</anchorfile>
      <anchor>aba0bd84d5851f3a64269685dc102cd4b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>set_max_unused_threads</name>
      <anchorfile>classGlib_1_1ThreadPool.html</anchorfile>
      <anchor>af057a2e30dc3e32137944f71658467db</anchor>
      <arglist>(int max_threads)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static int</type>
      <name>get_max_unused_threads</name>
      <anchorfile>classGlib_1_1ThreadPool.html</anchorfile>
      <anchor>aa0bb8c1914b2e36fa0222bbaeb44b94e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static unsigned int</type>
      <name>get_num_unused_threads</name>
      <anchorfile>classGlib_1_1ThreadPool.html</anchorfile>
      <anchor>a9904f39dc346cd44296f361415147ae1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>stop_unused_threads</name>
      <anchorfile>classGlib_1_1ThreadPool.html</anchorfile>
      <anchor>a132a7f8416d29f9499ed87ba102c37a3</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glib::Timer</name>
    <filename>classGlib_1_1Timer.html</filename>
    <member kind="function">
      <type></type>
      <name>Timer</name>
      <anchorfile>classGlib_1_1Timer.html</anchorfile>
      <anchor>a1ff80cf54560a168274fa69be8f0c280</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~Timer</name>
      <anchorfile>classGlib_1_1Timer.html</anchorfile>
      <anchor>a261ce5699feab81230a37fd6f2f80fb4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>start</name>
      <anchorfile>classGlib_1_1Timer.html</anchorfile>
      <anchor>a05067986b126f147111357ff7693aea6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stop</name>
      <anchorfile>classGlib_1_1Timer.html</anchorfile>
      <anchor>a3c54e67ddbc01f39b843b1df45aa3c17</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>reset</name>
      <anchorfile>classGlib_1_1Timer.html</anchorfile>
      <anchor>a82d5eef4159c73d8412b9e927073625b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>elapsed</name>
      <anchorfile>classGlib_1_1Timer.html</anchorfile>
      <anchor>aa1cb1f3f0105ad140122e661b4c74b6a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>elapsed</name>
      <anchorfile>classGlib_1_1Timer.html</anchorfile>
      <anchor>ac627928a24ff72cce9779675606aba3d</anchor>
      <arglist>(unsigned long &amp;microseconds) const </arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>Glib::TimeVal</name>
    <filename>structGlib_1_1TimeVal.html</filename>
    <member kind="function">
      <type></type>
      <name>TimeVal</name>
      <anchorfile>structGlib_1_1TimeVal.html</anchorfile>
      <anchor>ab1861a9cd1f66b581b99ba9bb9456626</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>TimeVal</name>
      <anchorfile>structGlib_1_1TimeVal.html</anchorfile>
      <anchor>ac72a9eada5c330236f7bc7f305b19179</anchor>
      <arglist>(long seconds, long microseconds)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>TimeVal</name>
      <anchorfile>structGlib_1_1TimeVal.html</anchorfile>
      <anchor>a5f889cb372ca5abb6796cfec44b8cc0d</anchor>
      <arglist>(const GTimeVal &amp;gtimeval)</arglist>
    </member>
    <member kind="function">
      <type>TimeVal &amp;</type>
      <name>operator=</name>
      <anchorfile>structGlib_1_1TimeVal.html</anchorfile>
      <anchor>a2098aff57cd47005faacb51854ede6a9</anchor>
      <arglist>(const GTimeVal &amp;gtimeval)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>assign_current_time</name>
      <anchorfile>structGlib_1_1TimeVal.html</anchorfile>
      <anchor>a9e28e3310fc1ee5e2dba7a7ed9cbb97e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>assign_from_iso8601</name>
      <anchorfile>structGlib_1_1TimeVal.html</anchorfile>
      <anchor>a0dbe47db920938db0676eb4d7a5b1abe</anchor>
      <arglist>(const Glib::ustring &amp;iso_date)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>add</name>
      <anchorfile>structGlib_1_1TimeVal.html</anchorfile>
      <anchor>ac94c07dbb768f3d1c68731e735f074ba</anchor>
      <arglist>(const TimeVal &amp;rhs)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>subtract</name>
     