#ifndef GNOME_APP_LIB__COLOR_GROUP_H
#define GNOME_APP_LIB__COLOR_GROUP_H

#include <libgnomeui/gnome-canvas.h>
#include <libgnome/gnome-defs.h>
#include <gtk/gtkobject.h>

BEGIN_GNOME_DECLS

typedef gboolean (* CbCustomColors) (GdkColor const * const color, gpointer data);

typedef struct _ColorGroup {
	GtkObject  parent;

        gchar     *name;
	gpointer   context;

        GPtrArray *history;         /* The custom color history */
	gint       history_size;    /* length of color_history */
} ColorGroup;

typedef struct {
	GtkObjectClass parent_class;
	
	/* Signals emited by this object */
	void (*custom_color_add) (ColorGroup *color_group, GdkColor const * const color);
} ColorGroupClass;

#define COLOR_GROUP_TYPE     (color_group_get_type ())
#define COLOR_GROUP(obj)     (GTK_CHECK_CAST((obj), COLOR_GROUP_TYPE, ColorGroup))
#define COLOR_GROUP_CLASS(k) (GTK_CHECK_CLASS_CAST(k), COLOR_GROUP_TYPE)
#define IS_COLOR_GROUP(obj)  (GTK_CHECK_TYPE((obj), COLOR_GROUP_TYPE))

GtkType         color_group_get_type  (void);
ColorGroup     *color_group_fetch (const gchar *name, gpointer context);
ColorGroup     *color_group_get   (const gchar *name, gpointer context);

void            color_group_set_history_size (ColorGroup *cg, gint size);
gint            color_group_get_history_size (ColorGroup *cg);

void            color_group_get_custom_colors (ColorGroup *cg, CbCustomColors callback,
					       gpointer user_data);
void            color_group_add_color	      (ColorGroup *cg, GdkColor const * const color);

END_GNOME_DECLS

#endif /* GNOME_APP_LIB__COLOR_GROUP_H */
