from DisplayTarget import DisplayTarget
from utils.datatypes import *

import gtk



class TargetImage(DisplayTarget):

    def __init__(self, parent, display):

        self.__original_image = None
        self.__uri = ""
        self.__scale = 1.0

        self.__cache = {}
        

        DisplayTarget.__init__(self, parent, display)

        self.__widget = gtk.Image()
        self.__widget.show()

        self.add(self.__widget)

        self._set_property_type("uri", TYPE_STRING)
        self._set_property_type("scale", TYPE_FLOAT)



    def set_config(self, key, value):

        value = self._convert_type(key, value)

        if (key == "uri"): self.__load_image(value)
        elif (key == "scale"): self.__scale_image(value)

        else:
            DisplayTarget.set_config(self, key, value)




    def __load_image(self, uri):

        if (uri != self.__uri):
            self.__original_image = gtk.gdk.pixbuf_new_from_file(uri)
            self.__widget.set_from_pixbuf(self.__original_image)
            self.__uri = uri
            self.__cache = {}
        #end if



    def __scale_image(self, scale):

        if (self.__cache and abs(self.__scale - scale) < 0.01): return

        key = int(scale * 20)
        if (self.__cache.has_key(key)):
            scaled = self.__cache[key]

        else:
            width = int(self.__original_image.get_width() * scale)
            height = int(self.__original_image.get_height() * scale)
            scaled = self.__original_image.scale_simple(width, height, 3)
            self.__cache[key] = scaled
            
        self.__widget.set_from_pixbuf(scaled)
        self.__scale = scale
