/* utils.c generated by valac 0.13.1.106-1068, the Vala compiler
 * generated from utils.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Philip Withnall <philip.withnall@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <folks/folks.h>
#include <stdarg.h>
#include <stdio.h>
#include <gio/gio.h>
#include <gobject/gvaluecollector.h>


#define FOLKS_INSPECT_TYPE_UTILS (folks_inspect_utils_get_type ())
#define FOLKS_INSPECT_UTILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_INSPECT_TYPE_UTILS, FolksInspectUtils))
#define FOLKS_INSPECT_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_INSPECT_TYPE_UTILS, FolksInspectUtilsClass))
#define FOLKS_INSPECT_IS_UTILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_INSPECT_TYPE_UTILS))
#define FOLKS_INSPECT_IS_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_INSPECT_TYPE_UTILS))
#define FOLKS_INSPECT_UTILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_INSPECT_TYPE_UTILS, FolksInspectUtilsClass))

typedef struct _FolksInspectUtils FolksInspectUtils;
typedef struct _FolksInspectUtilsClass FolksInspectUtilsClass;
typedef struct _FolksInspectUtilsPrivate FolksInspectUtilsPrivate;

#define FOLKS_INSPECT_TYPE_COMMAND (folks_inspect_command_get_type ())
#define FOLKS_INSPECT_COMMAND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_INSPECT_TYPE_COMMAND, FolksInspectCommand))
#define FOLKS_INSPECT_COMMAND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_INSPECT_TYPE_COMMAND, FolksInspectCommandClass))
#define FOLKS_INSPECT_IS_COMMAND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_INSPECT_TYPE_COMMAND))
#define FOLKS_INSPECT_IS_COMMAND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_INSPECT_TYPE_COMMAND))
#define FOLKS_INSPECT_COMMAND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_INSPECT_TYPE_COMMAND, FolksInspectCommandClass))

typedef struct _FolksInspectCommand FolksInspectCommand;
typedef struct _FolksInspectCommandClass FolksInspectCommandClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define FOLKS_INSPECT_TYPE_CLIENT (folks_inspect_client_get_type ())
#define FOLKS_INSPECT_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_INSPECT_TYPE_CLIENT, FolksInspectClient))
#define FOLKS_INSPECT_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_INSPECT_TYPE_CLIENT, FolksInspectClientClass))
#define FOLKS_INSPECT_IS_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_INSPECT_TYPE_CLIENT))
#define FOLKS_INSPECT_IS_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_INSPECT_TYPE_CLIENT))
#define FOLKS_INSPECT_CLIENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_INSPECT_TYPE_CLIENT, FolksInspectClientClass))

typedef struct _FolksInspectClient FolksInspectClient;
typedef struct _FolksInspectClientClass FolksInspectClientClass;
typedef struct _FolksInspectClientPrivate FolksInspectClientPrivate;
typedef struct _FolksInspectParamSpecUtils FolksInspectParamSpecUtils;

struct _FolksInspectUtils {
	GTypeInstance parent_instance;
	volatile int ref_count;
	FolksInspectUtilsPrivate * priv;
};

struct _FolksInspectUtilsClass {
	GTypeClass parent_class;
	void (*finalize) (FolksInspectUtils *self);
};

struct _FolksInspectClient {
	GObject parent_instance;
	FolksInspectClientPrivate * priv;
	GeeHashMap* commands;
};

struct _FolksInspectClientClass {
	GObjectClass parent_class;
};

struct _FolksInspectParamSpecUtils {
	GParamSpec parent_instance;
};


static gpointer folks_inspect_utils_parent_class = NULL;
static guint folks_inspect_utils_indentation;
static guint folks_inspect_utils_indentation = (guint) 0;
static gchar* folks_inspect_utils_indentation_string;
static gchar* folks_inspect_utils_indentation_string = NULL;
static GeeMapIterator* folks_inspect_utils_command_name_iter;
static GeeMapIterator* folks_inspect_utils_command_name_iter = NULL;
static GeeMapIterator* folks_inspect_utils_individual_id_iter;
static GeeMapIterator* folks_inspect_utils_individual_id_iter = NULL;
static GeeIterator* folks_inspect_utils_persona_uid_iter;
static GeeIterator* folks_inspect_utils_persona_uid_iter = NULL;
static GeeIterator* folks_inspect_utils_backend_name_iter;
static GeeIterator* folks_inspect_utils_backend_name_iter = NULL;
static GeeMapIterator* folks_inspect_utils_persona_store_id_iter;
static GeeMapIterator* folks_inspect_utils_persona_store_id_iter = NULL;
extern FolksInspectClient* main_client;

gpointer folks_inspect_utils_ref (gpointer instance);
void folks_inspect_utils_unref (gpointer instance);
GParamSpec* folks_inspect_param_spec_utils (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void folks_inspect_value_set_utils (GValue* value, gpointer v_object);
void folks_inspect_value_take_utils (GValue* value, gpointer v_object);
gpointer folks_inspect_value_get_utils (const GValue* value);
GType folks_inspect_utils_get_type (void) G_GNUC_CONST;
enum  {
	FOLKS_INSPECT_UTILS_DUMMY_PROPERTY
};
gpointer folks_inspect_command_ref (gpointer instance);
void folks_inspect_command_unref (gpointer instance);
GParamSpec* folks_inspect_param_spec_command (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void folks_inspect_value_set_command (GValue* value, gpointer v_object);
void folks_inspect_value_take_command (GValue* value, gpointer v_object);
gpointer folks_inspect_value_get_command (const GValue* value);
GType folks_inspect_command_get_type (void) G_GNUC_CONST;
void folks_inspect_utils_init (void);
static void folks_inspect_utils_transform_object_to_string (GValue* src, GValue* dest);
static void _folks_inspect_utils_transform_object_to_string_gvalue_transform (GValue* src_value, GValue* dest_value);
static void folks_inspect_utils_transform_persona_store_to_string (GValue* src, GValue* dest);
static void _folks_inspect_utils_transform_persona_store_to_string_gvalue_transform (GValue* src_value, GValue* dest_value);
static void folks_inspect_utils_transform_string_array_to_string (GValue* src, GValue* dest);
static void _folks_inspect_utils_transform_string_array_to_string_gvalue_transform (GValue* src_value, GValue* dest_value);
void folks_inspect_utils_indent (void);
void folks_inspect_utils_unindent (void);
void folks_inspect_utils_print_line (const gchar* format, ...);
void folks_inspect_utils_print_individual (FolksIndividual* individual, gboolean show_personas);
static gchar* folks_inspect_utils_property_to_string (GType object_type, const gchar* prop_name, GValue* prop_value);
void folks_inspect_utils_print_persona (FolksPersona* persona);
void folks_inspect_utils_print_persona_store (FolksPersonaStore* store, gboolean show_personas);
gchar* folks_inspect_utils_transform_value_to_string (GValue* prop_value);
gchar* folks_inspect_utils_command_name_completion_cb (const gchar* word, gint state);
GType folks_inspect_client_get_type (void) G_GNUC_CONST;
gchar* folks_inspect_utils_individual_id_completion_cb (const gchar* word, gint state);
FolksIndividualAggregator* folks_inspect_client_get_aggregator (FolksInspectClient* self);
gchar* folks_inspect_utils_persona_uid_completion_cb (const gchar* word, gint state);
gchar* folks_inspect_utils_backend_name_completion_cb (const gchar* word, gint state);
FolksBackendStore* folks_inspect_client_get_backend_store (FolksInspectClient* self);
gchar* folks_inspect_utils_persona_store_id_completion_cb (const gchar* word, gint state);
FolksInspectUtils* folks_inspect_utils_new (void);
FolksInspectUtils* folks_inspect_utils_construct (GType object_type);
static void folks_inspect_utils_finalize (FolksInspectUtils* obj);


static void _folks_inspect_utils_transform_object_to_string_gvalue_transform (GValue* src_value, GValue* dest_value) {
	folks_inspect_utils_transform_object_to_string (src_value, dest_value);
}


static void _folks_inspect_utils_transform_persona_store_to_string_gvalue_transform (GValue* src_value, GValue* dest_value) {
	folks_inspect_utils_transform_persona_store_to_string (src_value, dest_value);
}


static void _folks_inspect_utils_transform_string_array_to_string_gvalue_transform (GValue* src_value, GValue* dest_value) {
	folks_inspect_utils_transform_string_array_to_string (src_value, dest_value);
}


void folks_inspect_utils_init (void) {
	gchar* _tmp0_;
	_tmp0_ = g_strdup ("");
	_g_free0 (folks_inspect_utils_indentation_string);
	folks_inspect_utils_indentation_string = _tmp0_;
	g_value_register_transform_func (G_TYPE_OBJECT, G_TYPE_STRING, _folks_inspect_utils_transform_object_to_string_gvalue_transform);
	g_value_register_transform_func (FOLKS_TYPE_PERSONA_STORE, G_TYPE_STRING, _folks_inspect_utils_transform_persona_store_to_string_gvalue_transform);
	g_value_register_transform_func (G_TYPE_STRV, G_TYPE_STRING, _folks_inspect_utils_transform_string_array_to_string_gvalue_transform);
}


static void folks_inspect_utils_transform_object_to_string (GValue* src, GValue* dest) {
	GValue _dest = {0};
	GValue _tmp0_ = {0};
	GValue _tmp1_;
	GValue dest_tmp;
	GObject* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	GValue _tmp4_;
	GValue _tmp5_ = {0};
	g_value_init (&_tmp0_, G_TYPE_STRING);
	_tmp1_ = _tmp0_;
	dest_tmp = _tmp1_;
	_tmp2_ = g_value_get_object (src);
	_tmp3_ = g_strdup_printf ("%p", _tmp2_);
	g_value_take_string (&dest_tmp, _tmp3_);
	_tmp4_ = dest_tmp;
	if (G_IS_VALUE (&_tmp4_)) {
		g_value_init (&_tmp5_, G_VALUE_TYPE (&_tmp4_));
		g_value_copy (&_tmp4_, &_tmp5_);
	} else {
		_tmp5_ = _tmp4_;
	}
	G_IS_VALUE (&_dest) ? (g_value_unset (&_dest), NULL) : NULL;
	_dest = _tmp5_;
	G_IS_VALUE (&dest_tmp) ? (g_value_unset (&dest_tmp), NULL) : NULL;
	if (dest) {
		*dest = _dest;
	} else {
		G_IS_VALUE (&_dest) ? (g_value_unset (&_dest), NULL) : NULL;
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void folks_inspect_utils_transform_persona_store_to_string (GValue* src, GValue* dest) {
	GValue _dest = {0};
	GValue _tmp0_ = {0};
	GValue _tmp1_;
	GValue dest_tmp;
	GObject* _tmp2_ = NULL;
	FolksPersonaStore* _tmp3_;
	FolksPersonaStore* store;
	FolksPersonaStore* _tmp4_;
	FolksPersonaStore* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	FolksPersonaStore* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	FolksPersonaStore* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_ = NULL;
	GValue _tmp15_;
	GValue _tmp16_ = {0};
	g_value_init (&_tmp0_, G_TYPE_STRING);
	_tmp1_ = _tmp0_;
	dest_tmp = _tmp1_;
	_tmp2_ = g_value_get_object (src);
	_tmp3_ = _g_object_ref0 (FOLKS_PERSONA_STORE (_tmp2_));
	store = _tmp3_;
	_tmp4_ = store;
	_tmp5_ = store;
	_tmp6_ = folks_persona_store_get_type_id (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = store;
	_tmp9_ = folks_persona_store_get_id (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = store;
	_tmp12_ = folks_persona_store_get_display_name (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_strdup_printf ("%p: %s, %s (%s)", _tmp4_, _tmp7_, _tmp10_, _tmp13_);
	g_value_take_string (&dest_tmp, _tmp14_);
	_tmp15_ = dest_tmp;
	if (G_IS_VALUE (&_tmp15_)) {
		g_value_init (&_tmp16_, G_VALUE_TYPE (&_tmp15_));
		g_value_copy (&_tmp15_, &_tmp16_);
	} else {
		_tmp16_ = _tmp15_;
	}
	G_IS_VALUE (&_dest) ? (g_value_unset (&_dest), NULL) : NULL;
	_dest = _tmp16_;
	_g_object_unref0 (store);
	G_IS_VALUE (&dest_tmp) ? (g_value_unset (&dest_tmp), NULL) : NULL;
	if (dest) {
		*dest = _dest;
	} else {
		G_IS_VALUE (&_dest) ? (g_value_unset (&_dest), NULL) : NULL;
	}
}


static void folks_inspect_utils_transform_string_array_to_string (GValue* src, GValue* dest) {
	GValue _dest = {0};
	GValue _tmp0_ = {0};
	GValue _tmp1_;
	GValue dest_tmp;
	void* _tmp2_ = NULL;
	gchar** array;
	gint array_length1;
	gint _array_size_;
	gchar* _tmp3_;
	gchar* output;
	gboolean first;
	gchar** _tmp4_;
	gint _tmp4__length1;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	GValue _tmp18_;
	GValue _tmp19_ = {0};
	g_value_init (&_tmp0_, G_TYPE_STRING);
	_tmp1_ = _tmp0_;
	dest_tmp = _tmp1_;
	_tmp2_ = g_value_get_boxed (src);
	array = (gchar**) _tmp2_;
	array_length1 = -1;
	_array_size_ = array_length1;
	_tmp3_ = g_strdup ("{ ");
	output = _tmp3_;
	first = TRUE;
	_tmp4_ = array;
	_tmp4__length1 = array_length1;
	{
		gchar** element_collection = NULL;
		gint element_collection_length1 = 0;
		gint _element_collection_size_ = 0;
		gint element_it = 0;
		element_collection = _tmp4_;
		element_collection_length1 = _tmp4__length1;
		for (element_it = 0; element_it < _tmp4__length1; element_it = element_it + 1) {
			gchar* _tmp5_;
			gchar* element = NULL;
			_tmp5_ = g_strdup (element_collection[element_it]);
			element = _tmp5_;
			{
				gboolean _tmp6_;
				const gchar* _tmp9_;
				const gchar* _tmp10_;
				gchar* _tmp11_ = NULL;
				gchar* _tmp12_;
				gchar* _tmp13_;
				_tmp6_ = first;
				if (_tmp6_ == FALSE) {
					const gchar* _tmp7_;
					gchar* _tmp8_;
					_tmp7_ = output;
					_tmp8_ = g_strconcat (_tmp7_, ", ", NULL);
					_g_free0 (output);
					output = _tmp8_;
				}
				_tmp9_ = output;
				_tmp10_ = element;
				_tmp11_ = g_strdup_printf ("'%s'", _tmp10_);
				_tmp12_ = _tmp11_;
				_tmp13_ = g_strconcat (_tmp9_, _tmp12_, NULL);
				_g_free0 (output);
				output = _tmp13_;
				_g_free0 (_tmp12_);
				first = FALSE;
				_g_free0 (element);
			}
		}
	}
	_tmp14_ = output;
	_tmp15_ = g_strconcat (_tmp14_, " }", NULL);
	_g_free0 (output);
	output = _tmp15_;
	_tmp16_ = output;
	_tmp17_ = g_strdup (_tmp16_);
	g_value_take_string (&dest_tmp, _tmp17_);
	_tmp18_ = dest_tmp;
	if (G_IS_VALUE (&_tmp18_)) {
		g_value_init (&_tmp19_, G_VALUE_TYPE (&_tmp18_));
		g_value_copy (&_tmp18_, &_tmp19_);
	} else {
		_tmp19_ = _tmp18_;
	}
	G_IS_VALUE (&_dest) ? (g_value_unset (&_dest), NULL) : NULL;
	_dest = _tmp19_;
	_g_free0 (output);
	G_IS_VALUE (&dest_tmp) ? (g_value_unset (&dest_tmp), NULL) : NULL;
	if (dest) {
		*dest = _dest;
	} else {
		G_IS_VALUE (&_dest) ? (g_value_unset (&_dest), NULL) : NULL;
	}
}


void folks_inspect_utils_indent (void) {
	guint _tmp0_;
	guint _tmp1_;
	gchar* _tmp2_ = NULL;
	_tmp0_ = folks_inspect_utils_indentation;
	folks_inspect_utils_indentation = _tmp0_ + 2;
	_tmp1_ = folks_inspect_utils_indentation;
	_tmp2_ = g_strnfill ((gsize) _tmp1_, ' ');
	_g_free0 (folks_inspect_utils_indentation_string);
	folks_inspect_utils_indentation_string = _tmp2_;
}


void folks_inspect_utils_unindent (void) {
	guint _tmp0_;
	guint _tmp1_;
	gchar* _tmp2_ = NULL;
	_tmp0_ = folks_inspect_utils_indentation;
	folks_inspect_utils_indentation = _tmp0_ - 2;
	_tmp1_ = folks_inspect_utils_indentation;
	_tmp2_ = g_strnfill ((gsize) _tmp1_, ' ');
	_g_free0 (folks_inspect_utils_indentation_string);
	folks_inspect_utils_indentation_string = _tmp2_;
}


void folks_inspect_utils_print_line (const gchar* format, ...) {
	va_list valist;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* output;
	FILE* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	g_return_if_fail (format != NULL);
	va_start (valist, format);
	_tmp0_ = format;
	_tmp1_ = g_strdup_vprintf (_tmp0_, valist);
	output = _tmp1_;
	_tmp2_ = stdout;
	_tmp3_ = folks_inspect_utils_indentation_string;
	_tmp4_ = output;
	fprintf (_tmp2_, "%s%s\n", _tmp3_, _tmp4_);
	_g_free0 (output);
	va_end (valist);
}


void folks_inspect_utils_print_individual (FolksIndividual* individual, gboolean show_personas) {
	FolksIndividual* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	FolksIndividual* _tmp3_;
	GeeSet* _tmp4_;
	GeeSet* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	FolksIndividual* _tmp8_;
	GObjectClass* _tmp9_ = NULL;
	guint _tmp10_;
	GParamSpec** _tmp11_ = NULL;
	GParamSpec** properties;
	gint properties_length1;
	gint _properties_size_;
	GParamSpec** _tmp12_;
	gint _tmp12__length1;
	gboolean _tmp34_;
	g_return_if_fail (individual != NULL);
	_tmp0_ = individual;
	_tmp1_ = folks_individual_get_id (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = individual;
	_tmp4_ = folks_individual_get_personas (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = gee_collection_get_size ((GeeCollection*) _tmp5_);
	_tmp7_ = _tmp6_;
	folks_inspect_utils_print_line ("Individual '%s' with %u personas:", _tmp2_, (guint) _tmp7_);
	_tmp8_ = individual;
	_tmp9_ = G_OBJECT_GET_CLASS ((GObject*) _tmp8_);
	_tmp11_ = g_object_class_list_properties (_tmp9_, &_tmp10_);
	properties = _tmp11_;
	properties_length1 = _tmp10_;
	_properties_size_ = properties_length1;
	folks_inspect_utils_indent ();
	_tmp12_ = properties;
	_tmp12__length1 = properties_length1;
	{
		GParamSpec** pspec_collection = NULL;
		gint pspec_collection_length1 = 0;
		gint _pspec_collection_size_ = 0;
		gint pspec_it = 0;
		pspec_collection = _tmp12_;
		pspec_collection_length1 = _tmp12__length1;
		for (pspec_it = 0; pspec_it < _tmp12__length1; pspec_it = pspec_it + 1) {
			GParamSpec* pspec = NULL;
			pspec = pspec_collection[pspec_it];
			{
				GValue prop_value = {0};
				gchar* output_string = NULL;
				gboolean _tmp13_ = FALSE;
				gboolean _tmp14_;
				gboolean _tmp17_;
				GParamSpec* _tmp18_;
				GType _tmp19_;
				GValue _tmp20_ = {0};
				GValue _tmp21_;
				FolksIndividual* _tmp22_;
				GParamSpec* _tmp23_;
				const gchar* _tmp24_ = NULL;
				FolksIndividual* _tmp25_;
				GType _tmp26_ = 0UL;
				GParamSpec* _tmp27_;
				const gchar* _tmp28_ = NULL;
				GValue _tmp29_;
				gchar* _tmp30_ = NULL;
				GParamSpec* _tmp31_;
				const gchar* _tmp32_ = NULL;
				const gchar* _tmp33_;
				_tmp14_ = show_personas;
				if (_tmp14_ == TRUE) {
					GParamSpec* _tmp15_;
					const gchar* _tmp16_ = NULL;
					_tmp15_ = pspec;
					_tmp16_ = g_param_spec_get_name (_tmp15_);
					_tmp13_ = g_strcmp0 (_tmp16_, "personas") == 0;
				} else {
					_tmp13_ = FALSE;
				}
				_tmp17_ = _tmp13_;
				if (_tmp17_) {
					_g_free0 (output_string);
					G_IS_VALUE (&prop_value) ? (g_value_unset (&prop_value), NULL) : NULL;
					continue;
				}
				_tmp18_ = pspec;
				_tmp19_ = _tmp18_->value_type;
				g_value_init (&_tmp20_, _tmp19_);
				_tmp21_ = _tmp20_;
				G_IS_VALUE (&prop_value) ? (g_value_unset (&prop_value), NULL) : NULL;
				prop_value = _tmp21_;
				_tmp22_ = individual;
				_tmp23_ = pspec;
				_tmp24_ = g_param_spec_get_name (_tmp23_);
				g_object_get_property ((GObject*) _tmp22_, _tmp24_, &prop_value);
				_tmp25_ = individual;
				_tmp26_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp25_);
				_tmp27_ = pspec;
				_tmp28_ = g_param_spec_get_name (_tmp27_);
				_tmp29_ = prop_value;
				_tmp30_ = folks_inspect_utils_property_to_string (_tmp26_, _tmp28_, &_tmp29_);
				_g_free0 (output_string);
				output_string = _tmp30_;
				_tmp31_ = pspec;
				_tmp32_ = g_param_spec_get_nick (_tmp31_);
				_tmp33_ = output_string;
				folks_inspect_utils_print_line ("%-20s  %s", _tmp32_, _tmp33_);
				_g_free0 (output_string);
				G_IS_VALUE (&prop_value) ? (g_value_unset (&prop_value), NULL) : NULL;
			}
		}
	}
	_tmp34_ = show_personas;
	if (_tmp34_ == TRUE) {
		folks_inspect_utils_print_line ("");
		folks_inspect_utils_print_line ("Personas:");
		folks_inspect_utils_indent ();
		{
			FolksIndividual* _tmp35_;
			GeeSet* _tmp36_;
			GeeSet* _tmp37_;
			GeeIterator* _tmp38_ = NULL;
			GeeIterator* _persona_it;
			_tmp35_ = individual;
			_tmp36_ = folks_individual_get_personas (_tmp35_);
			_tmp37_ = _tmp36_;
			_tmp38_ = gee_iterable_iterator ((GeeIterable*) _tmp37_);
			_persona_it = _tmp38_;
			while (TRUE) {
				GeeIterator* _tmp39_;
				gboolean _tmp40_ = FALSE;
				GeeIterator* _tmp41_;
				gpointer _tmp42_ = NULL;
				FolksPersona* persona;
				FolksPersona* _tmp43_;
				_tmp39_ = _persona_it;
				_tmp40_ = gee_iterator_next (_tmp39_);
				if (!_tmp40_) {
					break;
				}
				_tmp41_ = _persona_it;
				_tmp42_ = gee_iterator_get (_tmp41_);
				persona = (FolksPersona*) _tmp42_;
				_tmp43_ = persona;
				folks_inspect_utils_print_persona (_tmp43_);
				_g_object_unref0 (persona);
			}
			_g_object_unref0 (_persona_it);
		}
		folks_inspect_utils_unindent ();
	}
	folks_inspect_utils_unindent ();
}


void folks_inspect_utils_print_persona (FolksPersona* persona) {
	FolksPersona* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	FolksPersona* _tmp3_;
	GObjectClass* _tmp4_ = NULL;
	guint _tmp5_;
	GParamSpec** _tmp6_ = NULL;
	GParamSpec** properties;
	gint properties_length1;
	gint _properties_size_;
	GParamSpec** _tmp7_;
	gint _tmp7__length1;
	g_return_if_fail (persona != NULL);
	_tmp0_ = persona;
	_tmp1_ = folks_persona_get_uid (_tmp0_);
	_tmp2_ = _tmp1_;
	folks_inspect_utils_print_line ("Persona '%s':", _tmp2_);
	_tmp3_ = persona;
	_tmp4_ = G_OBJECT_GET_CLASS ((GObject*) _tmp3_);
	_tmp6_ = g_object_class_list_properties (_tmp4_, &_tmp5_);
	properties = _tmp6_;
	properties_length1 = _tmp5_;
	_properties_size_ = properties_length1;
	folks_inspect_utils_indent ();
	_tmp7_ = properties;
	_tmp7__length1 = properties_length1;
	{
		GParamSpec** pspec_collection = NULL;
		gint pspec_collection_length1 = 0;
		gint _pspec_collection_size_ = 0;
		gint pspec_it = 0;
		pspec_collection = _tmp7_;
		pspec_collection_length1 = _tmp7__length1;
		for (pspec_it = 0; pspec_it < _tmp7__length1; pspec_it = pspec_it + 1) {
			GParamSpec* pspec = NULL;
			pspec = pspec_collection[pspec_it];
			{
				GValue prop_value = {0};
				gchar* output_string = NULL;
				GParamSpec* _tmp8_;
				GType _tmp9_;
				GValue _tmp10_ = {0};
				GValue _tmp11_;
				FolksPersona* _tmp12_;
				GParamSpec* _tmp13_;
				const gchar* _tmp14_ = NULL;
				FolksPersona* _tmp15_;
				GType _tmp16_ = 0UL;
				GParamSpec* _tmp17_;
				const gchar* _tmp18_ = NULL;
				GValue _tmp19_;
				gchar* _tmp20_ = NULL;
				GParamSpec* _tmp21_;
				const gchar* _tmp22_ = NULL;
				const gchar* _tmp23_;
				_tmp8_ = pspec;
				_tmp9_ = _tmp8_->value_type;
				g_value_init (&_tmp10_, _tmp9_);
				_tmp11_ = _tmp10_;
				G_IS_VALUE (&prop_value) ? (g_value_unset (&prop_value), NULL) : NULL;
				prop_value = _tmp11_;
				_tmp12_ = persona;
				_tmp13_ = pspec;
				_tmp14_ = g_param_spec_get_name (_tmp13_);
				g_object_get_property ((GObject*) _tmp12_, _tmp14_, &prop_value);
				_tmp15_ = persona;
				_tmp16_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp15_);
				_tmp17_ = pspec;
				_tmp18_ = g_param_spec_get_name (_tmp17_);
				_tmp19_ = prop_value;
				_tmp20_ = folks_inspect_utils_property_to_string (_tmp16_, _tmp18_, &_tmp19_);
				_g_free0 (output_string);
				output_string = _tmp20_;
				_tmp21_ = pspec;
				_tmp22_ = g_param_spec_get_nick (_tmp21_);
				_tmp23_ = output_string;
				folks_inspect_utils_print_line ("%-20s  %s", _tmp22_, _tmp23_);
				_g_free0 (output_string);
				G_IS_VALUE (&prop_value) ? (g_value_unset (&prop_value), NULL) : NULL;
			}
		}
	}
	folks_inspect_utils_unindent ();
}


void folks_inspect_utils_print_persona_store (FolksPersonaStore* store, gboolean show_personas) {
	FolksPersonaStore* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	FolksPersonaStore* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	FolksPersonaStore* _tmp9_;
	GeeMap* _tmp10_;
	GeeMap* _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	FolksPersonaStore* _tmp14_;
	GObjectClass* _tmp15_ = NULL;
	guint _tmp16_;
	GParamSpec** _tmp17_ = NULL;
	GParamSpec** properties;
	gint properties_length1;
	gint _properties_size_;
	GParamSpec** _tmp18_;
	gint _tmp18__length1;
	gboolean _tmp40_;
	g_return_if_fail (store != NULL);
	_tmp0_ = store;
	_tmp1_ = folks_persona_store_get_is_prepared (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == FALSE) {
		FolksPersonaStore* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		_tmp3_ = store;
		_tmp4_ = folks_persona_store_get_id (_tmp3_);
		_tmp5_ = _tmp4_;
		folks_inspect_utils_print_line ("Persona store '%s':", _tmp5_);
		folks_inspect_utils_indent ();
		folks_inspect_utils_print_line ("Not prepared.");
		folks_inspect_utils_unindent ();
		return;
	}
	_tmp6_ = store;
	_tmp7_ = folks_persona_store_get_id (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = store;
	_tmp10_ = folks_persona_store_get_personas (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = gee_map_get_size (_tmp11_);
	_tmp13_ = _tmp12_;
	folks_inspect_utils_print_line ("Persona store '%s' with %u personas:", _tmp8_, (guint) _tmp13_);
	_tmp14_ = store;
	_tmp15_ = G_OBJECT_GET_CLASS ((GObject*) _tmp14_);
	_tmp17_ = g_object_class_list_properties (_tmp15_, &_tmp16_);
	properties = _tmp17_;
	properties_length1 = _tmp16_;
	_properties_size_ = properties_length1;
	folks_inspect_utils_indent ();
	_tmp18_ = properties;
	_tmp18__length1 = properties_length1;
	{
		GParamSpec** pspec_collection = NULL;
		gint pspec_collection_length1 = 0;
		gint _pspec_collection_size_ = 0;
		gint pspec_it = 0;
		pspec_collection = _tmp18_;
		pspec_collection_length1 = _tmp18__length1;
		for (pspec_it = 0; pspec_it < _tmp18__length1; pspec_it = pspec_it + 1) {
			GParamSpec* pspec = NULL;
			pspec = pspec_collection[pspec_it];
			{
				GValue prop_value = {0};
				gchar* output_string = NULL;
				gboolean _tmp19_ = FALSE;
				gboolean _tmp20_;
				gboolean _tmp23_;
				GParamSpec* _tmp24_;
				GType _tmp25_;
				GValue _tmp26_ = {0};
				GValue _tmp27_;
				FolksPersonaStore* _tmp28_;
				GParamSpec* _tmp29_;
				const gchar* _tmp30_ = NULL;
				FolksPersonaStore* _tmp31_;
				GType _tmp32_ = 0UL;
				GParamSpec* _tmp33_;
				const gchar* _tmp34_ = NULL;
				GValue _tmp35_;
				gchar* _tmp36_ = NULL;
				GParamSpec* _tmp37_;
				const gchar* _tmp38_ = NULL;
				const gchar* _tmp39_;
				_tmp20_ = show_personas;
				if (_tmp20_ == TRUE) {
					GParamSpec* _tmp21_;
					const gchar* _tmp22_ = NULL;
					_tmp21_ = pspec;
					_tmp22_ = g_param_spec_get_name (_tmp21_);
					_tmp19_ = g_strcmp0 (_tmp22_, "personas") == 0;
				} else {
					_tmp19_ = FALSE;
				}
				_tmp23_ = _tmp19_;
				if (_tmp23_) {
					_g_free0 (output_string);
					G_IS_VALUE (&prop_value) ? (g_value_unset (&prop_value), NULL) : NULL;
					continue;
				}
				_tmp24_ = pspec;
				_tmp25_ = _tmp24_->value_type;
				g_value_init (&_tmp26_, _tmp25_);
				_tmp27_ = _tmp26_;
				G_IS_VALUE (&prop_value) ? (g_value_unset (&prop_value), NULL) : NULL;
				prop_value = _tmp27_;
				_tmp28_ = store;
				_tmp29_ = pspec;
				_tmp30_ = g_param_spec_get_name (_tmp29_);
				g_object_get_property ((GObject*) _tmp28_, _tmp30_, &prop_value);
				_tmp31_ = store;
				_tmp32_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp31_);
				_tmp33_ = pspec;
				_tmp34_ = g_param_spec_get_name (_tmp33_);
				_tmp35_ = prop_value;
				_tmp36_ = folks_inspect_utils_property_to_string (_tmp32_, _tmp34_, &_tmp35_);
				_g_free0 (output_string);
				output_string = _tmp36_;
				_tmp37_ = pspec;
				_tmp38_ = g_param_spec_get_nick (_tmp37_);
				_tmp39_ = output_string;
				folks_inspect_utils_print_line ("%-20s  %s", _tmp38_, _tmp39_);
				_g_free0 (output_string);
				G_IS_VALUE (&prop_value) ? (g_value_unset (&prop_value), NULL) : NULL;
			}
		}
	}
	_tmp40_ = show_personas;
	if (_tmp40_ == TRUE) {
		folks_inspect_utils_print_line ("");
		folks_inspect_utils_print_line ("Personas:");
		folks_inspect_utils_indent ();
		{
			FolksPersonaStore* _tmp41_;
			GeeMap* _tmp42_;
			GeeMap* _tmp43_;
			GeeCollection* _tmp44_;
			GeeCollection* _tmp45_;
			GeeCollection* _tmp46_;
			GeeIterator* _tmp47_ = NULL;
			GeeIterator* _tmp48_;
			GeeIterator* _persona_it;
			_tmp41_ = store;
			_tmp42_ = folks_persona_store_get_personas (_tmp41_);
			_tmp43_ = _tmp42_;
			_tmp44_ = gee_map_get_values (_tmp43_);
			_tmp45_ = _tmp44_;
			_tmp46_ = _tmp45_;
			_tmp47_ = gee_iterable_iterator ((GeeIterable*) _tmp46_);
			_tmp48_ = _tmp47_;
			_g_object_unref0 (_tmp46_);
			_persona_it = _tmp48_;
			while (TRUE) {
				GeeIterator* _tmp49_;
				gboolean _tmp50_ = FALSE;
				GeeIterator* _tmp51_;
				gpointer _tmp52_ = NULL;
				FolksPersona* persona;
				FolksPersona* _tmp53_;
				_tmp49_ = _persona_it;
				_tmp50_ = gee_iterator_next (_tmp49_);
				if (!_tmp50_) {
					break;
				}
				_tmp51_ = _persona_it;
				_tmp52_ = gee_iterator_get (_tmp51_);
				persona = (FolksPersona*) _tmp52_;
				_tmp53_ = persona;
				folks_inspect_utils_print_persona (_tmp53_);
				_g_object_unref0 (persona);
			}
			_g_object_unref0 (_persona_it);
		}
		folks_inspect_utils_unindent ();
	}
	folks_inspect_utils_unindent ();
}


static gchar* g_date_time_to_string (GDateTime* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_date_time_format (self, "%FT%H:%M:%S%z");
	result = _tmp0_;
	return result;
}


static gchar* folks_inspect_utils_property_to_string (GType object_type, const gchar* prop_name, GValue* prop_value) {
	gchar* result = NULL;
	gchar* output_string = NULL;
	gboolean _tmp0_ = FALSE;
	GType _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp4_;
	GValue _tmp247_;
	gchar* _tmp248_ = NULL;
	g_return_val_if_fail (prop_name != NULL, NULL);
	_tmp1_ = object_type;
	_tmp2_ = g_type_is_a (_tmp1_, FOLKS_TYPE_INDIVIDUAL);
	if (_tmp2_) {
		const gchar* _tmp3_;
		_tmp3_ = prop_name;
		_tmp0_ = g_strcmp0 (_tmp3_, "personas") == 0;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp4_ = _tmp0_;
	if (_tmp4_) {
		GObject* _tmp5_ = NULL;
		GeeSet* _tmp6_;
		GeeSet* personas;
		GeeSet* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gchar* _tmp10_ = NULL;
		_tmp5_ = g_value_get_object (prop_value);
		_tmp6_ = _g_object_ref0 (GEE_SET (_tmp5_));
		personas = _tmp6_;
		_tmp7_ = personas;
		_tmp8_ = gee_collection_get_size ((GeeCollection*) _tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strdup_printf ("List of %u personas", (guint) _tmp9_);
		result = _tmp10_;
		_g_object_unref0 (personas);
		_g_free0 (output_string);
		return result;
	} else {
		gboolean _tmp11_ = FALSE;
		GType _tmp12_;
		gboolean _tmp13_ = FALSE;
		gboolean _tmp15_;
		_tmp12_ = object_type;
		_tmp13_ = g_type_is_a (_tmp12_, FOLKS_TYPE_PERSONA_STORE);
		if (_tmp13_) {
			const gchar* _tmp14_;
			_tmp14_ = prop_name;
			_tmp11_ = g_strcmp0 (_tmp14_, "personas") == 0;
		} else {
			_tmp11_ = FALSE;
		}
		_tmp15_ = _tmp11_;
		if (_tmp15_) {
			GObject* _tmp16_ = NULL;
			GeeMap* _tmp17_;
			GeeMap* personas;
			GeeMap* _tmp18_;
			gint _tmp19_;
			gint _tmp20_;
			gchar* _tmp21_ = NULL;
			_tmp16_ = g_value_get_object (prop_value);
			_tmp17_ = _g_object_ref0 (GEE_MAP (_tmp16_));
			personas = _tmp17_;
			_tmp18_ = personas;
			_tmp19_ = gee_map_get_size (_tmp18_);
			_tmp20_ = _tmp19_;
			_tmp21_ = g_strdup_printf ("Set of %u personas", (guint) _tmp20_);
			result = _tmp21_;
			_g_object_unref0 (personas);
			_g_free0 (output_string);
			return result;
		} else {
			gboolean _tmp22_ = FALSE;
			const gchar* _tmp23_;
			gboolean _tmp25_;
			_tmp23_ = prop_name;
			if (g_strcmp0 (_tmp23_, "groups") == 0) {
				_tmp22_ = TRUE;
			} else {
				const gchar* _tmp24_;
				_tmp24_ = prop_name;
				_tmp22_ = g_strcmp0 (_tmp24_, "local-ids") == 0;
			}
			_tmp25_ = _tmp22_;
			if (_tmp25_) {
				GObject* _tmp26_ = NULL;
				GeeSet* _tmp27_;
				GeeSet* groups;
				gchar* _tmp28_;
				gboolean first;
				const gchar* _tmp43_;
				gchar* _tmp44_;
				_tmp26_ = g_value_get_object (prop_value);
				_tmp27_ = _g_object_ref0 (GEE_SET (_tmp26_));
				groups = _tmp27_;
				_tmp28_ = g_strdup ("{ ");
				_g_free0 (output_string);
				output_string = _tmp28_;
				first = TRUE;
				{
					GeeSet* _tmp29_;
					GeeIterator* _tmp30_ = NULL;
					GeeIterator* _group_it;
					_tmp29_ = groups;
					_tmp30_ = gee_iterable_iterator ((GeeIterable*) _tmp29_);
					_group_it = _tmp30_;
					while (TRUE) {
						GeeIterator* _tmp31_;
						gboolean _tmp32_ = FALSE;
						GeeIterator* _tmp33_;
						gpointer _tmp34_ = NULL;
						gchar* group;
						gboolean _tmp35_;
						const gchar* _tmp38_;
						const gchar* _tmp39_;
						gchar* _tmp40_ = NULL;
						gchar* _tmp41_;
						gchar* _tmp42_;
						_tmp31_ = _group_it;
						_tmp32_ = gee_iterator_next (_tmp31_);
						if (!_tmp32_) {
							break;
						}
						_tmp33_ = _group_it;
						_tmp34_ = gee_iterator_get (_tmp33_);
						group = (gchar*) _tmp34_;
						_tmp35_ = first;
						if (_tmp35_ == FALSE) {
							const gchar* _tmp36_;
							gchar* _tmp37_;
							_tmp36_ = output_string;
							_tmp37_ = g_strconcat (_tmp36_, ", ", NULL);
							_g_free0 (output_string);
							output_string = _tmp37_;
						}
						_tmp38_ = output_string;
						_tmp39_ = group;
						_tmp40_ = g_strdup_printf ("'%s'", _tmp39_);
						_tmp41_ = _tmp40_;
						_tmp42_ = g_strconcat (_tmp38_, _tmp41_, NULL);
						_g_free0 (output_string);
						output_string = _tmp42_;
						_g_free0 (_tmp41_);
						first = FALSE;
						_g_free0 (group);
					}
					_g_object_unref0 (_group_it);
				}
				_tmp43_ = output_string;
				_tmp44_ = g_strconcat (_tmp43_, " }", NULL);
				_g_free0 (output_string);
				output_string = _tmp44_;
				result = output_string;
				_g_object_unref0 (groups);
				return result;
			} else {
				const gchar* _tmp45_;
				_tmp45_ = prop_name;
				if (g_strcmp0 (_tmp45_, "avatar") == 0) {
					gchar* ret;
					GObject* _tmp46_ = NULL;
					GLoadableIcon* _tmp47_;
					GLoadableIcon* avatar;
					gboolean _tmp48_ = FALSE;
					gboolean _tmp49_ = FALSE;
					GLoadableIcon* _tmp50_;
					gboolean _tmp52_;
					gboolean _tmp55_;
					ret = NULL;
					_tmp46_ = g_value_get_object (prop_value);
					_tmp47_ = _g_object_ref0 (G_LOADABLE_ICON (_tmp46_));
					avatar = _tmp47_;
					_tmp50_ = avatar;
					if (_tmp50_ != NULL) {
						GLoadableIcon* _tmp51_;
						_tmp51_ = avatar;
						_tmp49_ = G_IS_FILE_ICON (_tmp51_);
					} else {
						_tmp49_ = FALSE;
					}
					_tmp52_ = _tmp49_;
					if (_tmp52_) {
						GLoadableIcon* _tmp53_;
						GFile* _tmp54_ = NULL;
						_tmp53_ = avatar;
						_tmp54_ = g_file_icon_get_file (G_FILE_ICON (_tmp53_));
						_tmp48_ = _tmp54_ != NULL;
					} else {
						_tmp48_ = FALSE;
					}
					_tmp55_ = _tmp48_;
					if (_tmp55_) {
						GLoadableIcon* _tmp56_;
						GLoadableIcon* _tmp57_;
						GFile* _tmp58_ = NULL;
						gchar* _tmp59_ = NULL;
						gchar* _tmp60_;
						gchar* _tmp61_ = NULL;
						_tmp56_ = avatar;
						_tmp57_ = avatar;
						_tmp58_ = g_file_icon_get_file (G_FILE_ICON (_tmp57_));
						_tmp59_ = g_file_get_uri (_tmp58_);
						_tmp60_ = _tmp59_;
						_tmp61_ = g_strdup_printf ("%p (file: %s)", _tmp56_, _tmp60_);
						_g_free0 (ret);
						ret = _tmp61_;
						_g_free0 (_tmp60_);
					} else {
						GLoadableIcon* _tmp62_;
						_tmp62_ = avatar;
						if (_tmp62_ != NULL) {
							GLoadableIcon* _tmp63_;
							gchar* _tmp64_ = NULL;
							_tmp63_ = avatar;
							_tmp64_ = g_strdup_printf ("%p", _tmp63_);
							_g_free0 (ret);
							ret = _tmp64_;
						}
					}
					result = ret;
					_g_object_unref0 (avatar);
					_g_free0 (output_string);
					return result;
				} else {
					const gchar* _tmp65_;
					_tmp65_ = prop_name;
					if (g_strcmp0 (_tmp65_, "im-addresses") == 0) {
						GObject* _tmp66_ = NULL;
						GeeMultiMap* _tmp67_;
						GeeMultiMap* im_addresses;
						gchar* _tmp68_;
						gboolean first;
						const gchar* _tmp105_;
						gchar* _tmp106_;
						_tmp66_ = g_value_get_object (prop_value);
						_tmp67_ = _g_object_ref0 (GEE_MULTI_MAP (_tmp66_));
						im_addresses = _tmp67_;
						_tmp68_ = g_strdup ("{ ");
						_g_free0 (output_string);
						output_string = _tmp68_;
						first = TRUE;
						{
							GeeMultiMap* _tmp69_;
							GeeSet* _tmp70_ = NULL;
							GeeSet* _tmp71_;
							GeeIterator* _tmp72_ = NULL;
							GeeIterator* _tmp73_;
							GeeIterator* _protocol_it;
							_tmp69_ = im_addresses;
							_tmp70_ = gee_multi_map_get_keys (_tmp69_);
							_tmp71_ = _tmp70_;
							_tmp72_ = gee_iterable_iterator ((GeeIterable*) _tmp71_);
							_tmp73_ = _tmp72_;
							_g_object_unref0 (_tmp71_);
							_protocol_it = _tmp73_;
							while (TRUE) {
								GeeIterator* _tmp74_;
								gboolean _tmp75_ = FALSE;
								GeeIterator* _tmp76_;
								gpointer _tmp77_ = NULL;
								gchar* protocol;
								gboolean _tmp78_;
								const gchar* _tmp81_;
								const gchar* _tmp82_;
								gchar* _tmp83_ = NULL;
								gchar* _tmp84_;
								gchar* _tmp85_;
								GeeMultiMap* _tmp86_;
								const gchar* _tmp87_;
								GeeCollection* _tmp88_ = NULL;
								GeeCollection* addresses;
								gboolean _first;
								const gchar* _tmp103_;
								gchar* _tmp104_;
								_tmp74_ = _protocol_it;
								_tmp75_ = gee_iterator_next (_tmp74_);
								if (!_tmp75_) {
									break;
								}
								_tmp76_ = _protocol_it;
								_tmp77_ = gee_iterator_get (_tmp76_);
								protocol = (gchar*) _tmp77_;
								_tmp78_ = first;
								if (_tmp78_ == FALSE) {
									const gchar* _tmp79_;
									gchar* _tmp80_;
									_tmp79_ = output_string;
									_tmp80_ = g_strconcat (_tmp79_, ", ", NULL);
									_g_free0 (output_string);
									output_string = _tmp80_;
								}
								_tmp81_ = output_string;
								_tmp82_ = protocol;
								_tmp83_ = g_strdup_printf ("'%s' : { ", _tmp82_);
								_tmp84_ = _tmp83_;
								_tmp85_ = g_strconcat (_tmp81_, _tmp84_, NULL);
								_g_free0 (output_string);
								output_string = _tmp85_;
								_g_free0 (_tmp84_);
								first = FALSE;
								_tmp86_ = im_addresses;
								_tmp87_ = protocol;
								_tmp88_ = gee_multi_map_get (_tmp86_, _tmp87_);
								addresses = _tmp88_;
								_first = TRUE;
								{
									GeeCollection* _tmp89_;
									GeeIterator* _tmp90_ = NULL;
									GeeIterator* _a_it;
									_tmp89_ = addresses;
									_tmp90_ = gee_iterable_iterator ((GeeIterable*) _tmp89_);
									_a_it = _tmp90_;
									while (TRUE) {
										GeeIterator* _tmp91_;
										gboolean _tmp92_ = FALSE;
										GeeIterator* _tmp93_;
										gpointer _tmp94_ = NULL;
										gchar* a;
										gboolean _tmp95_;
										const gchar* _tmp98_;
										const gchar* _tmp99_;
										gchar* _tmp100_ = NULL;
										gchar* _tmp101_;
										gchar* _tmp102_;
										_tmp91_ = _a_it;
										_tmp92_ = gee_iterator_next (_tmp91_);
										if (!_tmp92_) {
											break;
										}
										_tmp93_ = _a_it;
										_tmp94_ = gee_iterator_get (_tmp93_);
										a = (gchar*) _tmp94_;
										_tmp95_ = _first;
										if (_tmp95_ == FALSE) {
											const gchar* _tmp96_;
											gchar* _tmp97_;
											_tmp96_ = output_string;
											_tmp97_ = g_strconcat (_tmp96_, ", ", NULL);
											_g_free0 (output_string);
											output_string = _tmp97_;
										}
										_tmp98_ = output_string;
										_tmp99_ = a;
										_tmp100_ = g_strdup_printf ("'%s'", (const gchar*) _tmp99_);
										_tmp101_ = _tmp100_;
										_tmp102_ = g_strconcat (_tmp98_, _tmp101_, NULL);
										_g_free0 (output_string);
										output_string = _tmp102_;
										_g_free0 (_tmp101_);
										_first = FALSE;
										_g_free0 (a);
									}
									_g_object_unref0 (_a_it);
								}
								_tmp103_ = output_string;
								_tmp104_ = g_strconcat (_tmp103_, " }", NULL);
								_g_free0 (output_string);
								output_string = _tmp104_;
								_g_object_unref0 (addresses);
								_g_free0 (protocol);
							}
							_g_object_unref0 (_protocol_it);
						}
						_tmp105_ = output_string;
						_tmp106_ = g_strconcat (_tmp105_, " }", NULL);
						_g_free0 (output_string);
						output_string = _tmp106_;
						result = output_string;
						_g_object_unref0 (im_addresses);
						return result;
					} else {
						const gchar* _tmp107_;
						const gchar* _tmp108_ = NULL;
						_tmp107_ = prop_name;
						_tmp108_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_WEB_SERVICE_ADDRESSES);
						if (g_strcmp0 (_tmp107_, _tmp108_) == 0) {
							GObject* _tmp109_ = NULL;
							GeeMultiMap* _tmp110_;
							GeeMultiMap* web_service_addresses;
							gchar* _tmp111_;
							gboolean first;
							const gchar* _tmp148_;
							gchar* _tmp149_;
							_tmp109_ = g_value_get_object (prop_value);
							_tmp110_ = _g_object_ref0 (GEE_MULTI_MAP (_tmp109_));
							web_service_addresses = _tmp110_;
							_tmp111_ = g_strdup ("{ ");
							_g_free0 (output_string);
							output_string = _tmp111_;
							first = TRUE;
							{
								GeeMultiMap* _tmp112_;
								GeeSet* _tmp113_ = NULL;
								GeeSet* _tmp114_;
								GeeIterator* _tmp115_ = NULL;
								GeeIterator* _tmp116_;
								GeeIterator* _web_service_it;
								_tmp112_ = web_service_addresses;
								_tmp113_ = gee_multi_map_get_keys (_tmp112_);
								_tmp114_ = _tmp113_;
								_tmp115_ = gee_iterable_iterator ((GeeIterable*) _tmp114_);
								_tmp116_ = _tmp115_;
								_g_object_unref0 (_tmp114_);
								_web_service_it = _tmp116_;
								while (TRUE) {
									GeeIterator* _tmp117_;
									gboolean _tmp118_ = FALSE;
									GeeIterator* _tmp119_;
									gpointer _tmp120_ = NULL;
									gchar* web_service;
									gboolean _tmp121_;
									const gchar* _tmp124_;
									const gchar* _tmp125_;
									gchar* _tmp126_ = NULL;
									gchar* _tmp127_;
									gchar* _tmp128_;
									GeeMultiMap* _tmp129_;
									const gchar* _tmp130_;
									GeeCollection* _tmp131_ = NULL;
									GeeCollection* addresses;
									gboolean _first;
									const gchar* _tmp146_;
									gchar* _tmp147_;
									_tmp117_ = _web_service_it;
									_tmp118_ = gee_iterator_next (_tmp117_);
									if (!_tmp118_) {
										break;
									}
									_tmp119_ = _web_service_it;
									_tmp120_ = gee_iterator_get (_tmp119_);
									web_service = (gchar*) _tmp120_;
									_tmp121_ = first;
									if (_tmp121_ == FALSE) {
										const gchar* _tmp122_;
										gchar* _tmp123_;
										_tmp122_ = output_string;
										_tmp123_ = g_strconcat (_tmp122_, ", ", NULL);
										_g_free0 (output_string);
										output_string = _tmp123_;
									}
									_tmp124_ = output_string;
									_tmp125_ = web_service;
									_tmp126_ = g_strdup_printf ("'%s' : { ", _tmp125_);
									_tmp127_ = _tmp126_;
									_tmp128_ = g_strconcat (_tmp124_, _tmp127_, NULL);
									_g_free0 (output_string);
									output_string = _tmp128_;
									_g_free0 (_tmp127_);
									first = FALSE;
									_tmp129_ = web_service_addresses;
									_tmp130_ = web_service;
									_tmp131_ = gee_multi_map_get (_tmp129_, _tmp130_);
									addresses = _tmp131_;
									_first = TRUE;
									{
										GeeCollection* _tmp132_;
										GeeIterator* _tmp133_ = NULL;
										GeeIterator* _a_it;
										_tmp132_ = addresses;
										_tmp133_ = gee_iterable_iterator ((GeeIterable*) _tmp132_);
										_a_it = _tmp133_;
										while (TRUE) {
											GeeIterator* _tmp134_;
											gboolean _tmp135_ = FALSE;
											GeeIterator* _tmp136_;
											gpointer _tmp137_ = NULL;
											gchar* a;
											gboolean _tmp138_;
											const gchar* _tmp141_;
											const gchar* _tmp142_;
											gchar* _tmp143_ = NULL;
											gchar* _tmp144_;
											gchar* _tmp145_;
											_tmp134_ = _a_it;
											_tmp135_ = gee_iterator_next (_tmp134_);
											if (!_tmp135_) {
												break;
											}
											_tmp136_ = _a_it;
											_tmp137_ = gee_iterator_get (_tmp136_);
											a = (gchar*) _tmp137_;
											_tmp138_ = _first;
											if (_tmp138_ == FALSE) {
												const gchar* _tmp139_;
												gchar* _tmp140_;
												_tmp139_ = output_string;
												_tmp140_ = g_strconcat (_tmp139_, ", ", NULL);
												_g_free0 (output_string);
												output_string = _tmp140_;
											}
											_tmp141_ = output_string;
											_tmp142_ = a;
											_tmp143_ = g_strdup_printf ("'%s'", (const gchar*) _tmp142_);
											_tmp144_ = _tmp143_;
											_tmp145_ = g_strconcat (_tmp141_, _tmp144_, NULL);
											_g_free0 (output_string);
											output_string = _tmp145_;
											_g_free0 (_tmp144_);
											_first = FALSE;
											_g_free0 (a);
										}
										_g_object_unref0 (_a_it);
									}
									_tmp146_ = output_string;
									_tmp147_ = g_strconcat (_tmp146_, " }", NULL);
									_g_free0 (output_string);
									output_string = _tmp147_;
									_g_object_unref0 (addresses);
									_g_free0 (web_service);
								}
								_g_object_unref0 (_web_service_it);
							}
							_tmp148_ = output_string;
							_tmp149_ = g_strconcat (_tmp148_, " }", NULL);
							_g_free0 (output_string);
							output_string = _tmp149_;
							result = output_string;
							_g_object_unref0 (web_service_addresses);
							return result;
						} else {
							gboolean _tmp150_ = FALSE;
							gboolean _tmp151_ = FALSE;
							const gchar* _tmp152_;
							gboolean _tmp154_;
							gboolean _tmp156_;
							_tmp152_ = prop_name;
							if (g_strcmp0 (_tmp152_, "email-addresses") == 0) {
								_tmp151_ = TRUE;
							} else {
								const gchar* _tmp153_;
								_tmp153_ = prop_name;
								_tmp151_ = g_strcmp0 (_tmp153_, "phone-numbers") == 0;
							}
							_tmp154_ = _tmp151_;
							if (_tmp154_) {
								_tmp150_ = TRUE;
							} else {
								const gchar* _tmp155_;
								_tmp155_ = prop_name;
								_tmp150_ = g_strcmp0 (_tmp155_, "urls") == 0;
							}
							_tmp156_ = _tmp150_;
							if (_tmp156_) {
								gchar* _tmp157_;
								gboolean first;
								GObject* _tmp158_ = NULL;
								GeeSet* _tmp159_;
								GeeSet* prop_list;
								const gchar* _tmp174_;
								gchar* _tmp175_;
								_tmp157_ = g_strdup ("{ ");
								_g_free0 (output_string);
								output_string = _tmp157_;
								first = TRUE;
								_tmp158_ = g_value_get_object (prop_value);
								_tmp159_ = _g_object_ref0 (GEE_SET (_tmp158_));
								prop_list = _tmp159_;
								{
									GeeSet* _tmp160_;
									GeeIterator* _tmp161_ = NULL;
									GeeIterator* _p_it;
									_tmp160_ = prop_list;
									_tmp161_ = gee_iterable_iterator ((GeeIterable*) _tmp160_);
									_p_it = _tmp161_;
									while (TRUE) {
										GeeIterator* _tmp162_;
										gboolean _tmp163_ = FALSE;
										GeeIterator* _tmp164_;
										gpointer _tmp165_ = NULL;
										FolksAbstractFieldDetails* p;
										gboolean _tmp166_;
										const gchar* _tmp169_;
										FolksAbstractFieldDetails* _tmp170_;
										gconstpointer _tmp171_;
										const gchar* _tmp172_;
										gchar* _tmp173_;
										_tmp162_ = _p_it;
										_tmp163_ = gee_iterator_next (_tmp162_);
										if (!_tmp163_) {
											break;
										}
										_tmp164_ = _p_it;
										_tmp165_ = gee_iterator_get (_tmp164_);
										p = (FolksAbstractFieldDetails*) _tmp165_;
										_tmp166_ = first;
										if (!_tmp166_) {
											const gchar* _tmp167_;
											gchar* _tmp168_;
											_tmp167_ = output_string;
											_tmp168_ = g_strconcat (_tmp167_, ", ", NULL);
											_g_free0 (output_string);
											output_string = _tmp168_;
										}
										_tmp169_ = output_string;
										_tmp170_ = p;
										_tmp171_ = folks_abstract_field_details_get_value (_tmp170_);
										_tmp172_ = _tmp171_;
										_tmp173_ = g_strconcat (_tmp169_, (const gchar*) _tmp172_, NULL);
										_g_free0 (output_string);
										output_string = _tmp173_;
										first = FALSE;
										_g_object_unref0 (p);
									}
									_g_object_unref0 (_p_it);
								}
								_tmp174_ = output_string;
								_tmp175_ = g_strconcat (_tmp174_, " }", NULL);
								_g_free0 (output_string);
								output_string = _tmp175_;
								result = output_string;
								_g_object_unref0 (prop_list);
								return result;
							} else {
								const gchar* _tmp176_;
								_tmp176_ = prop_name;
								if (g_strcmp0 (_tmp176_, "birthday") == 0) {
									void* _tmp177_ = NULL;
									GDateTime* dobj;
									GDateTime* _tmp178_;
									_tmp177_ = g_value_get_boxed (prop_value);
									dobj = (GDateTime*) _tmp177_;
									_tmp178_ = dobj;
									if (_tmp178_ != NULL) {
										GDateTime* _tmp179_;
										gchar* _tmp180_ = NULL;
										_tmp179_ = dobj;
										_tmp180_ = g_date_time_to_string (_tmp179_);
										result = _tmp180_;
										_g_free0 (output_string);
										return result;
									} else {
										gchar* _tmp181_;
										_tmp181_ = g_strdup ("");
										result = _tmp181_;
										_g_free0 (output_string);
										return result;
									}
								} else {
									const gchar* _tmp182_;
									_tmp182_ = prop_name;
									if (g_strcmp0 (_tmp182_, "postal-addresses") == 0) {
										gchar* _tmp183_;
										gboolean first;
										GObject* _tmp184_ = NULL;
										GeeSet* _tmp185_;
										GeeSet* prop_list;
										const gchar* _tmp200_;
										gchar* _tmp201_;
										_tmp183_ = g_strdup ("{ ");
										_g_free0 (output_string);
										output_string = _tmp183_;
										first = TRUE;
										_tmp184_ = g_value_get_object (prop_value);
										_tmp185_ = _g_object_ref0 (GEE_SET (_tmp184_));
										prop_list = _tmp185_;
										{
											GeeSet* _tmp186_;
											GeeIterator* _tmp187_ = NULL;
											GeeIterator* _p_it;
											_tmp186_ = prop_list;
											_tmp187_ = gee_iterable_iterator ((GeeIterable*) _tmp186_);
											_p_it = _tmp187_;
											while (TRUE) {
												GeeIterator* _tmp188_;
												gboolean _tmp189_ = FALSE;
												GeeIterator* _tmp190_;
												gpointer _tmp191_ = NULL;
												FolksPostalAddress* p;
												gboolean _tmp192_;
												const gchar* _tmp195_;
												FolksPostalAddress* _tmp196_;
												gchar* _tmp197_ = NULL;
												gchar* _tmp198_;
												gchar* _tmp199_;
												_tmp188_ = _p_it;
												_tmp189_ = gee_iterator_next (_tmp188_);
												if (!_tmp189_) {
													break;
												}
												_tmp190_ = _p_it;
												_tmp191_ = gee_iterator_get (_tmp190_);
												p = (FolksPostalAddress*) _tmp191_;
												_tmp192_ = first;
												if (!_tmp192_) {
													const gchar* _tmp193_;
													gchar* _tmp194_;
													_tmp193_ = output_string;
													_tmp194_ = g_strconcat (_tmp193_, ". ", NULL);
													_g_free0 (output_string);
													output_string = _tmp194_;
												}
												_tmp195_ = output_string;
												_tmp196_ = p;
												_tmp197_ = folks_postal_address_to_string (_tmp196_);
												_tmp198_ = _tmp197_;
												_tmp199_ = g_strconcat (_tmp195_, _tmp198_, NULL);
												_g_free0 (output_string);
												output_string = _tmp199_;
												_g_free0 (_tmp198_);
												first = FALSE;
												_g_object_unref0 (p);
											}
											_g_object_unref0 (_p_it);
										}
										_tmp200_ = output_string;
										_tmp201_ = g_strconcat (_tmp200_, " }", NULL);
										_g_free0 (output_string);
										output_string = _tmp201_;
										result = output_string;
										_g_object_unref0 (prop_list);
										return result;
									} else {
										const gchar* _tmp202_;
										_tmp202_ = prop_name;
										if (g_strcmp0 (_tmp202_, "notes") == 0) {
											GObject* _tmp203_ = NULL;
											GeeSet* _tmp204_;
											GeeSet* notes;
											gchar* _tmp205_;
											gboolean first;
											const gchar* _tmp220_;
											gchar* _tmp221_;
											_tmp203_ = g_value_get_object (prop_value);
											_tmp204_ = _g_object_ref0 (GEE_IS_SET (_tmp203_) ? ((GeeSet*) _tmp203_) : NULL);
											notes = _tmp204_;
											_tmp205_ = g_strdup ("{ ");
											_g_free0 (output_string);
											output_string = _tmp205_;
											first = TRUE;
											{
												GeeSet* _tmp206_;
												GeeIterator* _tmp207_ = NULL;
												GeeIterator* _note_it;
												_tmp206_ = notes;
												_tmp207_ = gee_iterable_iterator ((GeeIterable*) _tmp206_);
												_note_it = _tmp207_;
												while (TRUE) {
													GeeIterator* _tmp208_;
													gboolean _tmp209_ = FALSE;
													GeeIterator* _tmp210_;
													gpointer _tmp211_ = NULL;
													FolksNoteFieldDetails* note;
													gboolean _tmp212_;
													const gchar* _tmp215_;
													FolksNoteFieldDetails* _tmp216_;
													const gchar* _tmp217_;
													const gchar* _tmp218_;
													gchar* _tmp219_;
													_tmp208_ = _note_it;
													_tmp209_ = gee_iterator_next (_tmp208_);
													if (!_tmp209_) {
														break;
													}
													_tmp210_ = _note_it;
													_tmp211_ = gee_iterator_get (_tmp210_);
													note = (FolksNoteFieldDetails*) _tmp211_;
													_tmp212_ = first;
													if (!_tmp212_) {
														const gchar* _tmp213_;
														gchar* _tmp214_;
														_tmp213_ = output_string;
														_tmp214_ = g_strconcat (_tmp213_, ", ", NULL);
														_g_free0 (output_string);
														output_string = _tmp214_;
													}
													_tmp215_ = output_string;
													_tmp216_ = note;
													_tmp217_ = folks_note_field_details_get_uid (_tmp216_);
													_tmp218_ = _tmp217_;
													_tmp219_ = g_strconcat (_tmp215_, _tmp218_, NULL);
													_g_free0 (output_string);
													output_string = _tmp219_;
													first = FALSE;
													_g_object_unref0 (note);
												}
												_g_object_unref0 (_note_it);
											}
											_tmp220_ = output_string;
											_tmp221_ = g_strconcat (_tmp220_, " }", NULL);
											_g_free0 (output_string);
											output_string = _tmp221_;
											result = output_string;
											_g_object_unref0 (notes);
											return result;
										} else {
											const gchar* _tmp222_;
											_tmp222_ = prop_name;
											if (g_strcmp0 (_tmp222_, "roles") == 0) {
												GObject* _tmp223_ = NULL;
												GeeSet* _tmp224_;
												GeeSet* roles;
												gchar* _tmp225_;
												gboolean first;
												const gchar* _tmp240_;
												gchar* _tmp241_;
												_tmp223_ = g_value_get_object (prop_value);
												_tmp224_ = _g_object_ref0 (GEE_SET (_tmp223_));
												roles = _tmp224_;
												_tmp225_ = g_strdup ("{ ");
												_g_free0 (output_string);
												output_string = _tmp225_;
												first = TRUE;
												{
													GeeSet* _tmp226_;
													GeeIterator* _tmp227_ = NULL;
													GeeIterator* _role_it;
													_tmp226_ = roles;
													_tmp227_ = gee_iterable_iterator ((GeeIterable*) _tmp226_);
													_role_it = _tmp227_;
													while (TRUE) {
														GeeIterator* _tmp228_;
														gboolean _tmp229_ = FALSE;
														GeeIterator* _tmp230_;
														gpointer _tmp231_ = NULL;
														FolksRole* role;
														gboolean _tmp232_;
														const gchar* _tmp235_;
														FolksRole* _tmp236_;
														gchar* _tmp237_ = NULL;
														gchar* _tmp238_;
														gchar* _tmp239_;
														_tmp228_ = _role_it;
														_tmp229_ = gee_iterator_next (_tmp228_);
														if (!_tmp229_) {
															break;
														}
														_tmp230_ = _role_it;
														_tmp231_ = gee_iterator_get (_tmp230_);
														role = (FolksRole*) _tmp231_;
														_tmp232_ = first;
														if (!_tmp232_) {
															const gchar* _tmp233_;
															gchar* _tmp234_;
															_tmp233_ = output_string;
															_tmp234_ = g_strconcat (_tmp233_, ", ", NULL);
															_g_free0 (output_string);
															output_string = _tmp234_;
														}
														_tmp235_ = output_string;
														_tmp236_ = role;
														_tmp237_ = folks_role_to_string (_tmp236_);
														_tmp238_ = _tmp237_;
														_tmp239_ = g_strconcat (_tmp235_, _tmp238_, NULL);
														_g_free0 (output_string);
														output_string = _tmp239_;
														_g_free0 (_tmp238_);
														first = FALSE;
														_g_object_unref0 (role);
													}
													_g_object_unref0 (_role_it);
												}
												_tmp240_ = output_string;
												_tmp241_ = g_strconcat (_tmp240_, " }", NULL);
												_g_free0 (output_string);
												output_string = _tmp241_;
												result = output_string;
												_g_object_unref0 (roles);
												return result;
											} else {
												const gchar* _tmp242_;
												_tmp242_ = prop_name;
												if (g_strcmp0 (_tmp242_, "structured-name") == 0) {
													GObject* _tmp243_ = NULL;
													FolksStructuredName* sn;
													gchar* ret;
													FolksStructuredName* _tmp244_;
													_tmp243_ = g_value_get_object (prop_value);
													sn = FOLKS_STRUCTURED_NAME (_tmp243_);
													ret = NULL;
													_tmp244_ = sn;
													if (_tmp244_ != NULL) {
														FolksStructuredName* _tmp245_;
														gchar* _tmp246_ = NULL;
														_tmp245_ = sn;
														_tmp246_ = folks_structured_name_to_string (_tmp245_);
														_g_free0 (ret);
														ret = _tmp246_;
													}
													result = ret;
													_g_free0 (output_string);
													return result;
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	_tmp247_ = *prop_value;
	_tmp248_ = folks_inspect_utils_transform_value_to_string (&_tmp247_);
	result = _tmp248_;
	_g_free0 (output_string);
	return result;
}


gchar* folks_inspect_utils_transform_value_to_string (GValue* prop_value) {
	gchar* result = NULL;
	GType _tmp0_ = 0UL;
	gboolean _tmp1_ = FALSE;
	_tmp0_ = G_VALUE_TYPE (prop_value);
	_tmp1_ = g_value_type_transformable (_tmp0_, G_TYPE_STRING);
	if (_tmp1_) {
		GValue _tmp2_ = {0};
		GValue _tmp3_;
		GValue string_value;
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		g_value_init (&_tmp2_, G_TYPE_STRING);
		_tmp3_ = _tmp2_;
		string_value = _tmp3_;
		g_value_transform (prop_value, &string_value);
		_tmp4_ = g_value_get_string (&string_value);
		_tmp5_ = g_strdup (_tmp4_);
		result = _tmp5_;
		G_IS_VALUE (&string_value) ? (g_value_unset (&string_value), NULL) : NULL;
		return result;
	} else {
		GType _tmp6_ = 0UL;
		const gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		_tmp6_ = G_VALUE_TYPE (prop_value);
		_tmp7_ = g_type_name (_tmp6_);
		_tmp8_ = g_type_name (G_TYPE_STRING);
		_tmp9_ = g_strdup_printf ("Can't convert from type '%s' to '%s'", _tmp7_, _tmp8_);
		result = _tmp9_;
		return result;
	}
}


gchar* folks_inspect_utils_command_name_completion_cb (const gchar* word, gint state) {
	gchar* result = NULL;
	gint _tmp0_;
	g_return_val_if_fail (word != NULL, NULL);
	_tmp0_ = state;
	if (_tmp0_ == 0) {
		FolksInspectClient* _tmp1_;
		GeeHashMap* _tmp2_;
		GeeMapIterator* _tmp3_ = NULL;
		_tmp1_ = main_client;
		_tmp2_ = _tmp1_->commands;
		_tmp3_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) _tmp2_);
		_g_object_unref0 (folks_inspect_utils_command_name_iter);
		folks_inspect_utils_command_name_iter = _tmp3_;
	}
	while (TRUE) {
		GeeMapIterator* _tmp4_;
		gboolean _tmp5_ = FALSE;
		GeeMapIterator* _tmp6_;
		gpointer _tmp7_ = NULL;
		gchar* command_name;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		gboolean _tmp10_ = FALSE;
		_tmp4_ = folks_inspect_utils_command_name_iter;
		_tmp5_ = gee_map_iterator_next (_tmp4_);
		if (!(_tmp5_ == TRUE)) {
			break;
		}
		_tmp6_ = folks_inspect_utils_command_name_iter;
		_tmp7_ = gee_map_iterator_get_key (_tmp6_);
		command_name = (gchar*) _tmp7_;
		_tmp8_ = command_name;
		_tmp9_ = word;
		_tmp10_ = g_str_has_prefix (_tmp8_, _tmp9_);
		if (_tmp10_) {
			result = command_name;
			return result;
		}
		_g_free0 (command_name);
	}
	_g_object_unref0 (folks_inspect_utils_command_name_iter);
	folks_inspect_utils_command_name_iter = NULL;
	result = NULL;
	return result;
}


gchar* folks_inspect_utils_individual_id_completion_cb (const gchar* word, gint state) {
	gchar* result = NULL;
	gint _tmp0_;
	g_return_val_if_fail (word != NULL, NULL);
	_tmp0_ = state;
	if (_tmp0_ == 0) {
		FolksInspectClient* _tmp1_;
		FolksIndividualAggregator* _tmp2_;
		FolksIndividualAggregator* _tmp3_;
		GeeMap* _tmp4_;
		GeeMap* _tmp5_;
		GeeMapIterator* _tmp6_ = NULL;
		_tmp1_ = main_client;
		_tmp2_ = folks_inspect_client_get_aggregator (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = folks_individual_aggregator_get_individuals (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = gee_map_map_iterator (_tmp5_);
		_g_object_unref0 (folks_inspect_utils_individual_id_iter);
		folks_inspect_utils_individual_id_iter = _tmp6_;
	}
	while (TRUE) {
		GeeMapIterator* _tmp7_;
		gboolean _tmp8_ = FALSE;
		GeeMapIterator* _tmp9_;
		gpointer _tmp10_ = NULL;
		gchar* id;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		gboolean _tmp13_ = FALSE;
		_tmp7_ = folks_inspect_utils_individual_id_iter;
		_tmp8_ = gee_map_iterator_next (_tmp7_);
		if (!(_tmp8_ == TRUE)) {
			break;
		}
		_tmp9_ = folks_inspect_utils_individual_id_iter;
		_tmp10_ = gee_map_iterator_get_key (_tmp9_);
		id = (gchar*) _tmp10_;
		_tmp11_ = id;
		_tmp12_ = word;
		_tmp13_ = g_str_has_prefix (_tmp11_, _tmp12_);
		if (_tmp13_) {
			result = id;
			return result;
		}
		_g_free0 (id);
	}
	_g_object_unref0 (folks_inspect_utils_individual_id_iter);
	folks_inspect_utils_individual_id_iter = NULL;
	result = NULL;
	return result;
}


gchar* folks_inspect_utils_persona_uid_completion_cb (const gchar* word, gint state) {
	gchar* result = NULL;
	gint _tmp0_;
	g_return_val_if_fail (word != NULL, NULL);
	_tmp0_ = state;
	if (_tmp0_ == 0) {
		FolksInspectClient* _tmp1_;
		FolksIndividualAggregator* _tmp2_;
		FolksIndividualAggregator* _tmp3_;
		GeeMap* _tmp4_;
		GeeMap* _tmp5_;
		GeeMapIterator* _tmp6_ = NULL;
		_tmp1_ = main_client;
		_tmp2_ = folks_inspect_client_get_aggregator (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = folks_individual_aggregator_get_individuals (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = gee_map_map_iterator (_tmp5_);
		_g_object_unref0 (folks_inspect_utils_individual_id_iter);
		folks_inspect_utils_individual_id_iter = _tmp6_;
		_g_object_unref0 (folks_inspect_utils_persona_uid_iter);
		folks_inspect_utils_persona_uid_iter = NULL;
	}
	while (TRUE) {
		gboolean _tmp7_ = FALSE;
		GeeIterator* _tmp8_;
		gboolean _tmp11_;
		GeeMapIterator* _tmp12_;
		gpointer _tmp13_ = NULL;
		FolksIndividual* individual;
		GeeIterator* _tmp14_;
		_tmp8_ = folks_inspect_utils_persona_uid_iter;
		if (_tmp8_ != NULL) {
			_tmp7_ = TRUE;
		} else {
			GeeMapIterator* _tmp9_;
			gboolean _tmp10_ = FALSE;
			_tmp9_ = folks_inspect_utils_individual_id_iter;
			_tmp10_ = gee_map_iterator_next (_tmp9_);
			_tmp7_ = _tmp10_ == TRUE;
		}
		_tmp11_ = _tmp7_;
		if (!_tmp11_) {
			break;
		}
		_tmp12_ = folks_inspect_utils_individual_id_iter;
		_tmp13_ = gee_map_iterator_get_value (_tmp12_);
		individual = (FolksIndividual*) _tmp13_;
		_tmp14_ = folks_inspect_utils_persona_uid_iter;
		if (_tmp14_ == NULL) {
			FolksIndividual* _tmp15_;
			FolksIndividual* _tmp16_;
			GeeSet* _tmp17_;
			GeeSet* _tmp18_;
			GeeIterator* _tmp19_ = NULL;
			_tmp15_ = individual;
			g_assert (_tmp15_ != NULL);
			_tmp16_ = individual;
			_tmp17_ = folks_individual_get_personas (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = gee_iterable_iterator ((GeeIterable*) _tmp18_);
			_g_object_unref0 (folks_inspect_utils_persona_uid_iter);
			folks_inspect_utils_persona_uid_iter = _tmp19_;
		}
		while (TRUE) {
			GeeIterator* _tmp20_;
			gboolean _tmp21_ = FALSE;
			GeeIterator* _tmp22_;
			gpointer _tmp23_ = NULL;
			FolksPersona* persona;
			FolksPersona* _tmp24_;
			const gchar* _tmp25_;
			const gchar* _tmp26_;
			const gchar* _tmp27_;
			gboolean _tmp28_ = FALSE;
			_tmp20_ = folks_inspect_utils_persona_uid_iter;
			_tmp21_ = gee_iterator_next (_tmp20_);
			if (!_tmp21_) {
				break;
			}
			_tmp22_ = folks_inspect_utils_persona_uid_iter;
			_tmp23_ = gee_iterator_get (_tmp22_);
			persona = (FolksPersona*) _tmp23_;
			_tmp24_ = persona;
			_tmp25_ = folks_persona_get_uid (_tmp24_);
			_tmp26_ = _tmp25_;
			_tmp27_ = word;
			_tmp28_ = g_str_has_prefix (_tmp26_, _tmp27_);
			if (_tmp28_) {
				FolksPersona* _tmp29_;
				const gchar* _tmp30_;
				const gchar* _tmp31_;
				gchar* _tmp32_;
				_tmp29_ = persona;
				_tmp30_ = folks_persona_get_uid (_tmp29_);
				_tmp31_ = _tmp30_;
				_tmp32_ = g_strdup (_tmp31_);
				result = _tmp32_;
				_g_object_unref0 (persona);
				_g_object_unref0 (individual);
				return result;
			}
			_g_object_unref0 (persona);
		}
		_g_object_unref0 (folks_inspect_utils_persona_uid_iter);
		folks_inspect_utils_persona_uid_iter = NULL;
		_g_object_unref0 (individual);
	}
	_g_object_unref0 (folks_inspect_utils_individual_id_iter);
	folks_inspect_utils_individual_id_iter = NULL;
	result = NULL;
	return result;
}


gchar* folks_inspect_utils_backend_name_completion_cb (const gchar* word, gint state) {
	gchar* result = NULL;
	gint _tmp0_;
	g_return_val_if_fail (word != NULL, NULL);
	_tmp0_ = state;
	if (_tmp0_ == 0) {
		FolksInspectClient* _tmp1_;
		FolksBackendStore* _tmp2_;
		FolksBackendStore* _tmp3_;
		GeeCollection* _tmp4_ = NULL;
		GeeCollection* _tmp5_;
		GeeIterator* _tmp6_ = NULL;
		_tmp1_ = main_client;
		_tmp2_ = folks_inspect_client_get_backend_store (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = folks_backend_store_list_backends (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = gee_iterable_iterator ((GeeIterable*) _tmp5_);
		_g_object_unref0 (folks_inspect_utils_backend_name_iter);
		folks_inspect_utils_backend_name_iter = _tmp6_;
		_g_object_unref0 (_tmp5_);
	}
	while (TRUE) {
		GeeIterator* _tmp7_;
		gboolean _tmp8_ = FALSE;
		GeeIterator* _tmp9_;
		gpointer _tmp10_ = NULL;
		FolksBackend* backend;
		FolksBackend* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		gboolean _tmp15_ = FALSE;
		_tmp7_ = folks_inspect_utils_backend_name_iter;
		_tmp8_ = gee_iterator_next (_tmp7_);
		if (!(_tmp8_ == TRUE)) {
			break;
		}
		_tmp9_ = folks_inspect_utils_backend_name_iter;
		_tmp10_ = gee_iterator_get (_tmp9_);
		backend = (FolksBackend*) _tmp10_;
		_tmp11_ = backend;
		_tmp12_ = folks_backend_get_name (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = word;
		_tmp15_ = g_str_has_prefix (_tmp13_, _tmp14_);
		if (_tmp15_) {
			FolksBackend* _tmp16_;
			const gchar* _tmp17_;
			const gchar* _tmp18_;
			gchar* _tmp19_;
			_tmp16_ = backend;
			_tmp17_ = folks_backend_get_name (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = g_strdup (_tmp18_);
			result = _tmp19_;
			_g_object_unref0 (backend);
			return result;
		}
		_g_object_unref0 (backend);
	}
	_g_object_unref0 (folks_inspect_utils_backend_name_iter);
	folks_inspect_utils_backend_name_iter = NULL;
	result = NULL;
	return result;
}


gchar* folks_inspect_utils_persona_store_id_completion_cb (const gchar* word, gint state) {
	gchar* result = NULL;
	gint _tmp0_;
	g_return_val_if_fail (word != NULL, NULL);
	_tmp0_ = state;
	if (_tmp0_ == 0) {
		FolksInspectClient* _tmp1_;
		FolksBackendStore* _tmp2_;
		FolksBackendStore* _tmp3_;
		GeeCollection* _tmp4_ = NULL;
		GeeCollection* _tmp5_;
		GeeIterator* _tmp6_ = NULL;
		_tmp1_ = main_client;
		_tmp2_ = folks_inspect_client_get_backend_store (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = folks_backend_store_list_backends (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = gee_iterable_iterator ((GeeIterable*) _tmp5_);
		_g_object_unref0 (folks_inspect_utils_backend_name_iter);
		folks_inspect_utils_backend_name_iter = _tmp6_;
		_g_object_unref0 (_tmp5_);
		_g_object_unref0 (folks_inspect_utils_persona_store_id_iter);
		folks_inspect_utils_persona_store_id_iter = NULL;
	}
	while (TRUE) {
		gboolean _tmp7_ = FALSE;
		GeeMapIterator* _tmp8_;
		gboolean _tmp11_;
		GeeMapIterator* _tmp12_;
		_tmp8_ = folks_inspect_utils_persona_store_id_iter;
		if (_tmp8_ != NULL) {
			_tmp7_ = TRUE;
		} else {
			GeeIterator* _tmp9_;
			gboolean _tmp10_ = FALSE;
			_tmp9_ = folks_inspect_utils_backend_name_iter;
			_tmp10_ = gee_iterator_next (_tmp9_);
			_tmp7_ = _tmp10_ == TRUE;
		}
		_tmp11_ = _tmp7_;
		if (!_tmp11_) {
			break;
		}
		_tmp12_ = folks_inspect_utils_persona_store_id_iter;
		if (_tmp12_ == NULL) {
			GeeIterator* _tmp13_;
			gpointer _tmp14_ = NULL;
			FolksBackend* backend;
			FolksBackend* _tmp15_;
			GeeMap* _tmp16_;
			GeeMap* _tmp17_;
			GeeMapIterator* _tmp18_ = NULL;
			_tmp13_ = folks_inspect_utils_backend_name_iter;
			_tmp14_ = gee_iterator_get (_tmp13_);
			backend = (FolksBackend*) _tmp14_;
			_tmp15_ = backend;
			_tmp16_ = folks_backend_get_persona_stores (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = gee_map_map_iterator (_tmp17_);
			_g_object_unref0 (folks_inspect_utils_persona_store_id_iter);
			folks_inspect_utils_persona_store_id_iter = _tmp18_;
			_g_object_unref0 (backend);
		}
		while (TRUE) {
			GeeMapIterator* _tmp19_;
			gboolean _tmp20_ = FALSE;
			GeeMapIterator* _tmp21_;
			gpointer _tmp22_ = NULL;
			gchar* id;
			const gchar* _tmp23_;
			const gchar* _tmp24_;
			gboolean _tmp25_ = FALSE;
			_tmp19_ = folks_inspect_utils_persona_store_id_iter;
			_tmp20_ = gee_map_iterator_next (_tmp19_);
			if (!(_tmp20_ == TRUE)) {
				break;
			}
			_tmp21_ = folks_inspect_utils_persona_store_id_iter;
			_tmp22_ = gee_map_iterator_get_key (_tmp21_);
			id = (gchar*) _tmp22_;
			_tmp23_ = id;
			_tmp24_ = word;
			_tmp25_ = g_str_has_prefix (_tmp23_, _tmp24_);
			if (_tmp25_) {
				result = id;
				return result;
			}
			_g_free0 (id);
		}
		_g_object_unref0 (folks_inspect_utils_persona_store_id_iter);
		folks_inspect_utils_persona_store_id_iter = NULL;
	}
	_g_object_unref0 (folks_inspect_utils_backend_name_iter);
	folks_inspect_utils_backend_name_iter = NULL;
	result = NULL;
	return result;
}


FolksInspectUtils* folks_inspect_utils_construct (GType object_type) {
	FolksInspectUtils* self = NULL;
	self = (FolksInspectUtils*) g_type_create_instance (object_type);
	return self;
}


FolksInspectUtils* folks_inspect_utils_new (void) {
	return folks_inspect_utils_construct (FOLKS_INSPECT_TYPE_UTILS);
}


static void folks_inspect_value_utils_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void folks_inspect_value_utils_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		folks_inspect_utils_unref (value->data[0].v_pointer);
	}
}


static void folks_inspect_value_utils_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = folks_inspect_utils_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer folks_inspect_value_utils_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* folks_inspect_value_utils_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		FolksInspectUtils* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = folks_inspect_utils_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* folks_inspect_value_utils_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	FolksInspectUtils** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = folks_inspect_utils_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* folks_inspect_param_spec_utils (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	FolksInspectParamSpecUtils* spec;
	g_return_val_if_fail (g_type_is_a (object_type, FOLKS_INSPECT_TYPE_UTILS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer folks_inspect_value_get_utils (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FOLKS_INSPECT_TYPE_UTILS), NULL);
	return value->data[0].v_pointer;
}


void folks_inspect_value_set_utils (GValue* value, gpointer v_object) {
	FolksInspectUtils* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FOLKS_INSPECT_TYPE_UTILS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, FOLKS_INSPECT_TYPE_UTILS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		folks_inspect_utils_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		folks_inspect_utils_unref (old);
	}
}


void folks_inspect_value_take_utils (GValue* value, gpointer v_object) {
	FolksInspectUtils* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FOLKS_INSPECT_TYPE_UTILS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, FOLKS_INSPECT_TYPE_UTILS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		folks_inspect_utils_unref (old);
	}
}


static void folks_inspect_utils_class_init (FolksInspectUtilsClass * klass) {
	gchar* _tmp0_;
	folks_inspect_utils_parent_class = g_type_class_peek_parent (klass);
	FOLKS_INSPECT_UTILS_CLASS (klass)->finalize = folks_inspect_utils_finalize;
	_tmp0_ = g_strdup ("");
	folks_inspect_utils_indentation_string = _tmp0_;
}


static void folks_inspect_utils_instance_init (FolksInspectUtils * self) {
	self->ref_count = 1;
}


static void folks_inspect_utils_finalize (FolksInspectUtils* obj) {
	FolksInspectUtils * self;
	self = FOLKS_INSPECT_UTILS (obj);
}


GType folks_inspect_utils_get_type (void) {
	static volatile gsize folks_inspect_utils_type_id__volatile = 0;
	if (g_once_init_enter (&folks_inspect_utils_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { folks_inspect_value_utils_init, folks_inspect_value_utils_free_value, folks_inspect_value_utils_copy_value, folks_inspect_value_utils_peek_pointer, "p", folks_inspect_value_utils_collect_value, "p", folks_inspect_value_utils_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (FolksInspectUtilsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_inspect_utils_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksInspectUtils), 0, (GInstanceInitFunc) folks_inspect_utils_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType folks_inspect_utils_type_id;
		folks_inspect_utils_type_id = g_type_register_fundamental (g_type_fundamental_next (), "FolksInspectUtils", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&folks_inspect_utils_type_id__volatile, folks_inspect_utils_type_id);
	}
	return folks_inspect_utils_type_id__volatile;
}


gpointer folks_inspect_utils_ref (gpointer instance) {
	FolksInspectUtils* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void folks_inspect_utils_unref (gpointer instance) {
	FolksInspectUtils* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		FOLKS_INSPECT_UTILS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



