/* command-linking.c generated by valac 0.13.1.106-1068, the Vala compiler
 * generated from command-linking.vala, do not modify */

/*
 * Copyright (C) 2011 Philip Withnall
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Philip Withnall <philip@tecnocode.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <folks/folks.h>
#include <gio/gio.h>
#include <stdio.h>
#include <readline/readline.h>


#define FOLKS_INSPECT_TYPE_COMMAND (folks_inspect_command_get_type ())
#define FOLKS_INSPECT_COMMAND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_INSPECT_TYPE_COMMAND, FolksInspectCommand))
#define FOLKS_INSPECT_COMMAND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_INSPECT_TYPE_COMMAND, FolksInspectCommandClass))
#define FOLKS_INSPECT_IS_COMMAND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_INSPECT_TYPE_COMMAND))
#define FOLKS_INSPECT_IS_COMMAND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_INSPECT_TYPE_COMMAND))
#define FOLKS_INSPECT_COMMAND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_INSPECT_TYPE_COMMAND, FolksInspectCommandClass))

typedef struct _FolksInspectCommand FolksInspectCommand;
typedef struct _FolksInspectCommandClass FolksInspectCommandClass;
typedef struct _FolksInspectCommandPrivate FolksInspectCommandPrivate;

#define FOLKS_INSPECT_TYPE_CLIENT (folks_inspect_client_get_type ())
#define FOLKS_INSPECT_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_INSPECT_TYPE_CLIENT, FolksInspectClient))
#define FOLKS_INSPECT_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_INSPECT_TYPE_CLIENT, FolksInspectClientClass))
#define FOLKS_INSPECT_IS_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_INSPECT_TYPE_CLIENT))
#define FOLKS_INSPECT_IS_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_INSPECT_TYPE_CLIENT))
#define FOLKS_INSPECT_CLIENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_INSPECT_TYPE_CLIENT, FolksInspectClientClass))

typedef struct _FolksInspectClient FolksInspectClient;
typedef struct _FolksInspectClientClass FolksInspectClientClass;

#define FOLKS_INSPECT_COMMANDS_TYPE_LINKING (folks_inspect_commands_linking_get_type ())
#define FOLKS_INSPECT_COMMANDS_LINKING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_INSPECT_COMMANDS_TYPE_LINKING, FolksInspectCommandsLinking))
#define FOLKS_INSPECT_COMMANDS_LINKING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_INSPECT_COMMANDS_TYPE_LINKING, FolksInspectCommandsLinkingClass))
#define FOLKS_INSPECT_COMMANDS_IS_LINKING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_INSPECT_COMMANDS_TYPE_LINKING))
#define FOLKS_INSPECT_COMMANDS_IS_LINKING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_INSPECT_COMMANDS_TYPE_LINKING))
#define FOLKS_INSPECT_COMMANDS_LINKING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_INSPECT_COMMANDS_TYPE_LINKING, FolksInspectCommandsLinkingClass))

typedef struct _FolksInspectCommandsLinking FolksInspectCommandsLinking;
typedef struct _FolksInspectCommandsLinkingClass FolksInspectCommandsLinkingClass;
typedef struct _FolksInspectCommandsLinkingPrivate FolksInspectCommandsLinkingPrivate;
typedef struct _Block1Data Block1Data;
#define _folks_inspect_command_unref0(var) ((var == NULL) ? NULL : (var = (folks_inspect_command_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block2Data Block2Data;

struct _FolksInspectCommand {
	GTypeInstance parent_instance;
	volatile int ref_count;
	FolksInspectCommandPrivate * priv;
	FolksInspectClient* client;
};

struct _FolksInspectCommandClass {
	GTypeClass parent_class;
	void (*finalize) (FolksInspectCommand *self);
	void (*run) (FolksInspectCommand* self, const gchar* command_string);
	gchar** (*complete_subcommand) (FolksInspectCommand* self, const gchar* subcommand, int* result_length1);
	const gchar* (*get_name) (FolksInspectCommand* self);
	const gchar* (*get_description) (FolksInspectCommand* self);
	const gchar* (*get_help) (FolksInspectCommand* self);
};

struct _FolksInspectCommandsLinking {
	FolksInspectCommand parent_instance;
	FolksInspectCommandsLinkingPrivate * priv;
};

struct _FolksInspectCommandsLinkingClass {
	FolksInspectCommandClass parent_class;
};

struct _Block1Data {
	int _ref_count_;
	FolksInspectCommandsLinking * self;
	GeeHashSet* personas;
};

struct _Block2Data {
	int _ref_count_;
	FolksInspectCommandsLinking * self;
	FolksIndividual* ind;
};


static gpointer folks_inspect_commands_linking_parent_class = NULL;
static gchar** folks_inspect_commands_linking_subcommand_completions;
static gchar** folks_inspect_commands_linking_subcommand_completions = NULL;
static guint folks_inspect_commands_linking_completion_count;
static guint folks_inspect_commands_linking_completion_count = 0U;
static gchar* folks_inspect_commands_linking_prefix;
static gchar* folks_inspect_commands_linking_prefix = NULL;

gpointer folks_inspect_command_ref (gpointer instance);
void folks_inspect_command_unref (gpointer instance);
GParamSpec* folks_inspect_param_spec_command (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void folks_inspect_value_set_command (GValue* value, gpointer v_object);
void folks_inspect_value_take_command (GValue* value, gpointer v_object);
gpointer folks_inspect_value_get_command (const GValue* value);
GType folks_inspect_command_get_type (void) G_GNUC_CONST;
GType folks_inspect_client_get_type (void) G_GNUC_CONST;
GType folks_inspect_commands_linking_get_type (void) G_GNUC_CONST;
enum  {
	FOLKS_INSPECT_COMMANDS_LINKING_DUMMY_PROPERTY
};
FolksInspectCommandsLinking* folks_inspect_commands_linking_new (FolksInspectClient* client);
FolksInspectCommandsLinking* folks_inspect_commands_linking_construct (GType object_type, FolksInspectClient* client);
FolksInspectCommand* folks_inspect_command_construct (GType object_type, FolksInspectClient* client);
static void folks_inspect_commands_linking_real_run (FolksInspectCommand* base, const gchar* command_string);
void folks_inspect_utils_print_line (const gchar* format, ...);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
FolksIndividualAggregator* folks_inspect_client_get_aggregator (FolksInspectClient* self);
static void _lambda2_ (GObject* obj, GAsyncResult* res, Block1Data* _data1_);
static void __lambda2__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (Block2Data* _data2_);
static void _lambda3_ (GObject* obj, GAsyncResult* res, Block2Data* _data2_);
static void __lambda3__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
gchar* folks_inspect_commands_linking_subcommand_name_completion_cb (const gchar* word, gint state);
gchar* folks_inspect_utils_persona_uid_completion_cb (const gchar* word, gint state);
static gchar* _folks_inspect_utils_persona_uid_completion_cb_rl_compentry_func_t (const gchar* str, gint a);
static gchar** _vala_array_dup4 (gchar** self, int length);
gchar* folks_inspect_utils_individual_id_completion_cb (const gchar* word, gint state);
static gchar* _folks_inspect_utils_individual_id_completion_cb_rl_compentry_func_t (const gchar* str, gint a);
static gchar** _vala_array_dup5 (gchar** self, int length);
static gchar** folks_inspect_commands_linking_real_complete_subcommand (FolksInspectCommand* base, const gchar* subcommand, int* result_length1);
static gchar* _folks_inspect_commands_linking_subcommand_name_completion_cb_rl_compentry_func_t (const gchar* str, gint a);
static gchar** _vala_array_dup6 (gchar** self, int length);
static void folks_inspect_commands_linking_finalize (FolksInspectCommand* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


FolksInspectCommandsLinking* folks_inspect_commands_linking_construct (GType object_type, FolksInspectClient* client) {
	FolksInspectCommandsLinking* self = NULL;
	FolksInspectClient* _tmp0_;
	g_return_val_if_fail (client != NULL, NULL);
	_tmp0_ = client;
	self = (FolksInspectCommandsLinking*) folks_inspect_command_construct (object_type, _tmp0_);
	return self;
}


FolksInspectCommandsLinking* folks_inspect_commands_linking_new (FolksInspectClient* client) {
	return folks_inspect_commands_linking_construct (FOLKS_INSPECT_COMMANDS_TYPE_LINKING, client);
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (Block1Data* _data1_) {
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_folks_inspect_command_unref0 (_data1_->self);
		_g_object_unref0 (_data1_->personas);
		g_slice_free (Block1Data, _data1_);
	}
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static void _lambda2_ (GObject* obj, GAsyncResult* res, Block1Data* _data1_) {
	FolksInspectCommandsLinking * self;
	GeeHashSet* _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	GError * _inner_error_ = NULL;
	self = _data1_->self;
	g_return_if_fail (res != NULL);
	{
		FolksInspectClient* _tmp0_;
		FolksIndividualAggregator* _tmp1_;
		FolksIndividualAggregator* _tmp2_;
		GAsyncResult* _tmp3_;
		_tmp0_ = ((FolksInspectCommand*) self)->client;
		_tmp1_ = folks_inspect_client_get_aggregator (_tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = res;
		folks_individual_aggregator_link_personas_finish (_tmp2_, _tmp3_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR) {
				goto __catch0_folks_individual_aggregator_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally0;
	__catch0_folks_individual_aggregator_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		GQuark _tmp5_;
		GError* _tmp6_;
		gint _tmp7_;
		GeeHashSet* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		GError* _tmp11_;
		const gchar* _tmp12_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->domain;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->code;
		_tmp8_ = _data1_->personas;
		_tmp9_ = gee_collection_get_size ((GeeCollection*) _tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = e;
		_tmp12_ = _tmp11_->message;
		folks_inspect_utils_print_line ("Error (domain: %u, code: %u) linking %u " "personas: %s", _tmp5_, _tmp7_, _tmp10_, _tmp12_);
		_g_error_free0 (e);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp13_ = _data1_->personas;
	_tmp14_ = gee_collection_get_size ((GeeCollection*) _tmp13_);
	_tmp15_ = _tmp14_;
	folks_inspect_utils_print_line ("Linking of %u personas was successful.", (guint) _tmp15_);
}


static void __lambda2__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	_lambda2_ (source_object, res, self);
	block1_data_unref (self);
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (Block2Data* _data2_) {
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		_folks_inspect_command_unref0 (_data2_->self);
		_g_object_unref0 (_data2_->ind);
		g_slice_free (Block2Data, _data2_);
	}
}


static void _lambda3_ (GObject* obj, GAsyncResult* res, Block2Data* _data2_) {
	FolksInspectCommandsLinking * self;
	FolksIndividual* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	GError * _inner_error_ = NULL;
	self = _data2_->self;
	g_return_if_fail (res != NULL);
	{
		FolksInspectClient* _tmp0_;
		FolksIndividualAggregator* _tmp1_;
		FolksIndividualAggregator* _tmp2_;
		GAsyncResult* _tmp3_;
		_tmp0_ = ((FolksInspectCommand*) self)->client;
		_tmp1_ = folks_inspect_client_get_aggregator (_tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = res;
		folks_individual_aggregator_unlink_individual_finish (_tmp2_, _tmp3_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		GQuark _tmp5_;
		GError* _tmp6_;
		gint _tmp7_;
		FolksIndividual* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		GError* _tmp11_;
		const gchar* _tmp12_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->domain;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->code;
		_tmp8_ = _data2_->ind;
		_tmp9_ = folks_individual_get_id (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = e;
		_tmp12_ = _tmp11_->message;
		folks_inspect_utils_print_line ("Error (domain: %u, code: %u) unlinking " "individual '%s': %s", _tmp5_, _tmp7_, _tmp10_, _tmp12_);
		_g_error_free0 (e);
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp13_ = _data2_->ind;
	_tmp14_ = folks_individual_get_id (_tmp13_);
	_tmp15_ = _tmp14_;
	folks_inspect_utils_print_line ("Unlinking of individual '%s' was successful.", _tmp15_);
}


static void __lambda3__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	_lambda3_ (source_object, res, self);
	block2_data_unref (self);
}


static void folks_inspect_commands_linking_real_run (FolksInspectCommand* base, const gchar* command_string) {
	FolksInspectCommandsLinking * self;
	gchar** _tmp0_ = NULL;
	gchar** parts;
	gint parts_length1;
	gint _parts_size_;
	const gchar* _tmp1_;
	gboolean _tmp5_ = FALSE;
	gchar** _tmp6_;
	gint _tmp6__length1;
	gboolean _tmp13_;
	gchar** _tmp15_;
	gint _tmp15__length1;
	const gchar* _tmp16_;
	self = (FolksInspectCommandsLinking*) base;
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	parts = _tmp0_;
	parts_length1 = 0;
	_parts_size_ = parts_length1;
	_tmp1_ = command_string;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		gchar** _tmp3_;
		gchar** _tmp4_ = NULL;
		_tmp2_ = command_string;
		_tmp4_ = _tmp3_ = g_strsplit (_tmp2_, " ", 0);
		parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
		parts = _tmp4_;
		parts_length1 = _vala_array_length (_tmp3_);
		_parts_size_ = parts_length1;
	}
	_tmp6_ = parts;
	_tmp6__length1 = parts_length1;
	if (_tmp6__length1 < 1) {
		_tmp5_ = TRUE;
	} else {
		gboolean _tmp7_ = FALSE;
		gchar** _tmp8_;
		gint _tmp8__length1;
		const gchar* _tmp9_;
		gboolean _tmp12_;
		_tmp8_ = parts;
		_tmp8__length1 = parts_length1;
		_tmp9_ = _tmp8_[0];
		if (g_strcmp0 (_tmp9_, "link-personas") != 0) {
			gchar** _tmp10_;
			gint _tmp10__length1;
			const gchar* _tmp11_;
			_tmp10_ = parts;
			_tmp10__length1 = parts_length1;
			_tmp11_ = _tmp10_[0];
			_tmp7_ = g_strcmp0 (_tmp11_, "unlink-individual") != 0;
		} else {
			_tmp7_ = FALSE;
		}
		_tmp12_ = _tmp7_;
		_tmp5_ = _tmp12_;
	}
	_tmp13_ = _tmp5_;
	if (_tmp13_) {
		const gchar* _tmp14_;
		_tmp14_ = command_string;
		folks_inspect_utils_print_line ("Unrecognised 'linking' command '%s'.", _tmp14_);
		parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
		return;
	}
	_tmp15_ = parts;
	_tmp15__length1 = parts_length1;
	_tmp16_ = _tmp15_[0];
	if (g_strcmp0 (_tmp16_, "link-personas") == 0) {
		Block1Data* _data1_;
		GeeHashSet* _tmp17_;
		gchar** _tmp18_;
		gint _tmp18__length1;
		FolksInspectClient* _tmp74_;
		FolksIndividualAggregator* _tmp75_;
		FolksIndividualAggregator* _tmp76_;
		GeeHashSet* _tmp77_;
		_data1_ = g_slice_new0 (Block1Data);
		_data1_->_ref_count_ = 1;
		_data1_->self = folks_inspect_command_ref (self);
		_tmp17_ = gee_hash_set_new (FOLKS_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
		_data1_->personas = _tmp17_;
		_tmp18_ = parts;
		_tmp18__length1 = parts_length1;
		if (_tmp18__length1 < 2) {
			folks_inspect_utils_print_line ("%s", "Must pass at least one persona to a " "'link-personas' subcommand.");
			block1_data_unref (_data1_);
			_data1_ = NULL;
			parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
			return;
		}
		{
			guint i;
			i = (guint) 1;
			{
				gboolean _tmp19_;
				_tmp19_ = TRUE;
				while (TRUE) {
					gboolean _tmp20_;
					guint _tmp22_;
					gchar** _tmp23_;
					gint _tmp23__length1;
					gboolean _tmp24_ = FALSE;
					gchar** _tmp25_;
					gint _tmp25__length1;
					guint _tmp26_;
					const gchar* _tmp27_;
					gboolean _tmp33_;
					gboolean found;
					gchar** _tmp37_;
					gint _tmp37__length1;
					guint _tmp38_;
					const gchar* _tmp39_;
					gchar* _tmp40_ = NULL;
					gchar* uid;
					gboolean _tmp70_;
					_tmp20_ = _tmp19_;
					if (!_tmp20_) {
						guint _tmp21_;
						_tmp21_ = i;
						i = _tmp21_ + 1;
					}
					_tmp19_ = FALSE;
					_tmp22_ = i;
					_tmp23_ = parts;
					_tmp23__length1 = parts_length1;
					if (!(_tmp22_ < ((guint) _tmp23__length1))) {
						break;
					}
					_tmp25_ = parts;
					_tmp25__length1 = parts_length1;
					_tmp26_ = i;
					_tmp27_ = _tmp25_[_tmp26_];
					if (_tmp27_ == NULL) {
						_tmp24_ = TRUE;
					} else {
						gchar** _tmp28_;
						gint _tmp28__length1;
						guint _tmp29_;
						const gchar* _tmp30_;
						gchar* _tmp31_ = NULL;
						gchar* _tmp32_;
						_tmp28_ = parts;
						_tmp28__length1 = parts_length1;
						_tmp29_ = i;
						_tmp30_ = _tmp28_[_tmp29_];
						_tmp31_ = string_strip (_tmp30_);
						_tmp32_ = _tmp31_;
						_tmp24_ = g_strcmp0 (_tmp32_, "") == 0;
						_g_free0 (_tmp32_);
					}
					_tmp33_ = _tmp24_;
					if (_tmp33_) {
						gchar** _tmp34_;
						gint _tmp34__length1;
						guint _tmp35_;
						const gchar* _tmp36_;
						_tmp34_ = parts;
						_tmp34__length1 = parts_length1;
						_tmp35_ = i;
						_tmp36_ = _tmp34_[_tmp35_];
						folks_inspect_utils_print_line ("Unrecognised persona UID '%s'.", _tmp36_);
						block1_data_unref (_data1_);
						_data1_ = NULL;
						parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
						return;
					}
					found = FALSE;
					_tmp37_ = parts;
					_tmp37__length1 = parts_length1;
					_tmp38_ = i;
					_tmp39_ = _tmp37_[_tmp38_];
					_tmp40_ = string_strip (_tmp39_);
					uid = _tmp40_;
					{
						FolksInspectClient* _tmp41_;
						FolksIndividualAggregator* _tmp42_;
						FolksIndividualAggregator* _tmp43_;
						GeeMap* _tmp44_;
						GeeMap* _tmp45_;
						GeeCollection* _tmp46_;
						GeeCollection* _tmp47_;
						GeeCollection* _tmp48_;
						GeeIterator* _tmp49_ = NULL;
						GeeIterator* _tmp50_;
						GeeIterator* _individual_it;
						_tmp41_ = ((FolksInspectCommand*) self)->client;
						_tmp42_ = folks_inspect_client_get_aggregator (_tmp41_);
						_tmp43_ = _tmp42_;
						_tmp44_ = folks_individual_aggregator_get_individuals (_tmp43_);
						_tmp45_ = _tmp44_;
						_tmp46_ = gee_map_get_values (_tmp45_);
						_tmp47_ = _tmp46_;
						_tmp48_ = _tmp47_;
						_tmp49_ = gee_iterable_iterator ((GeeIterable*) _tmp48_);
						_tmp50_ = _tmp49_;
						_g_object_unref0 (_tmp48_);
						_individual_it = _tmp50_;
						while (TRUE) {
							GeeIterator* _tmp51_;
							gboolean _tmp52_ = FALSE;
							GeeIterator* _tmp53_;
							gpointer _tmp54_ = NULL;
							FolksIndividual* individual;
							gboolean _tmp69_;
							_tmp51_ = _individual_it;
							_tmp52_ = gee_iterator_next (_tmp51_);
							if (!_tmp52_) {
								break;
							}
							_tmp53_ = _individual_it;
							_tmp54_ = gee_iterator_get (_tmp53_);
							individual = (FolksIndividual*) _tmp54_;
							{
								FolksIndividual* _tmp55_;
								GeeSet* _tmp56_;
								GeeSet* _tmp57_;
								GeeIterator* _tmp58_ = NULL;
								GeeIterator* _persona_it;
								_tmp55_ = individual;
								_tmp56_ = folks_individual_get_personas (_tmp55_);
								_tmp57_ = _tmp56_;
								_tmp58_ = gee_iterable_iterator ((GeeIterable*) _tmp57_);
								_persona_it = _tmp58_;
								while (TRUE) {
									GeeIterator* _tmp59_;
									gboolean _tmp60_ = FALSE;
									GeeIterator* _tmp61_;
									gpointer _tmp62_ = NULL;
									FolksPersona* persona;
									FolksPersona* _tmp63_;
									const gchar* _tmp64_;
									const gchar* _tmp65_;
									const gchar* _tmp66_;
									_tmp59_ = _persona_it;
									_tmp60_ = gee_iterator_next (_tmp59_);
									if (!_tmp60_) {
										break;
									}
									_tmp61_ = _persona_it;
									_tmp62_ = gee_iterator_get (_tmp61_);
									persona = (FolksPersona*) _tmp62_;
									_tmp63_ = persona;
									_tmp64_ = folks_persona_get_uid (_tmp63_);
									_tmp65_ = _tmp64_;
									_tmp66_ = uid;
									if (g_strcmp0 (_tmp65_, _tmp66_) == 0) {
										GeeHashSet* _tmp67_;
										FolksPersona* _tmp68_;
										_tmp67_ = _data1_->personas;
										_tmp68_ = persona;
										gee_abstract_collection_add ((GeeAbstractCollection*) _tmp67_, _tmp68_);
										found = TRUE;
										_g_object_unref0 (persona);
										break;
									}
									_g_object_unref0 (persona);
								}
								_g_object_unref0 (_persona_it);
							}
							_tmp69_ = found;
							if (_tmp69_ == TRUE) {
								_g_object_unref0 (individual);
								break;
							}
							_g_object_unref0 (individual);
						}
						_g_object_unref0 (_individual_it);
					}
					_tmp70_ = found;
					if (_tmp70_ == FALSE) {
						gchar** _tmp71_;
						gint _tmp71__length1;
						guint _tmp72_;
						const gchar* _tmp73_;
						_tmp71_ = parts;
						_tmp71__length1 = parts_length1;
						_tmp72_ = i;
						_tmp73_ = _tmp71_[_tmp72_];
						folks_inspect_utils_print_line ("Unrecognised persona UID '%s'.", _tmp73_);
						_g_free0 (uid);
						block1_data_unref (_data1_);
						_data1_ = NULL;
						parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
						return;
					}
					_g_free0 (uid);
				}
			}
		}
		_tmp74_ = ((FolksInspectCommand*) self)->client;
		_tmp75_ = folks_inspect_client_get_aggregator (_tmp74_);
		_tmp76_ = _tmp75_;
		_tmp77_ = _data1_->personas;
		folks_individual_aggregator_link_personas (_tmp76_, (GeeSet*) _tmp77_, __lambda2__gasync_ready_callback, block1_data_ref (_data1_));
		block1_data_unref (_data1_);
		_data1_ = NULL;
	} else {
		gchar** _tmp78_;
		gint _tmp78__length1;
		const gchar* _tmp79_;
		_tmp78_ = parts;
		_tmp78__length1 = parts_length1;
		_tmp79_ = _tmp78_[0];
		if (g_strcmp0 (_tmp79_, "unlink-individual") == 0) {
			Block2Data* _data2_;
			gchar** _tmp80_;
			gint _tmp80__length1;
			FolksInspectClient* _tmp81_;
			FolksIndividualAggregator* _tmp82_;
			FolksIndividualAggregator* _tmp83_;
			GeeMap* _tmp84_;
			GeeMap* _tmp85_;
			gchar** _tmp86_;
			gint _tmp86__length1;
			const gchar* _tmp87_;
			gpointer _tmp88_ = NULL;
			FolksIndividual* _tmp89_;
			FolksInspectClient* _tmp92_;
			FolksIndividualAggregator* _tmp93_;
			FolksIndividualAggregator* _tmp94_;
			FolksIndividual* _tmp95_;
			_data2_ = g_slice_new0 (Block2Data);
			_data2_->_ref_count_ = 1;
			_data2_->self = folks_inspect_command_ref (self);
			_tmp80_ = parts;
			_tmp80__length1 = parts_length1;
			if (_tmp80__length1 != 2) {
				folks_inspect_utils_print_line ("%s", "Must pass exactly one individual ID to an " "'unlink-individual' subcommand.");
				block2_data_unref (_data2_);
				_data2_ = NULL;
				parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
				return;
			}
			_tmp81_ = ((FolksInspectCommand*) self)->client;
			_tmp82_ = folks_inspect_client_get_aggregator (_tmp81_);
			_tmp83_ = _tmp82_;
			_tmp84_ = folks_individual_aggregator_get_individuals (_tmp83_);
			_tmp85_ = _tmp84_;
			_tmp86_ = parts;
			_tmp86__length1 = parts_length1;
			_tmp87_ = _tmp86_[1];
			_tmp88_ = gee_map_get (_tmp85_, _tmp87_);
			_data2_->ind = (FolksIndividual*) _tmp88_;
			_tmp89_ = _data2_->ind;
			if (_tmp89_ == NULL) {
				gchar** _tmp90_;
				gint _tmp90__length1;
				const gchar* _tmp91_;
				_tmp90_ = parts;
				_tmp90__length1 = parts_length1;
				_tmp91_ = _tmp90_[1];
				folks_inspect_utils_print_line ("Unrecognised individual ID '%s'.", _tmp91_);
				block2_data_unref (_data2_);
				_data2_ = NULL;
				parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
				return;
			}
			_tmp92_ = ((FolksInspectCommand*) self)->client;
			_tmp93_ = folks_inspect_client_get_aggregator (_tmp92_);
			_tmp94_ = _tmp93_;
			_tmp95_ = _data2_->ind;
			folks_individual_aggregator_unlink_individual (_tmp94_, _tmp95_, __lambda3__gasync_ready_callback, block2_data_ref (_data2_));
			block2_data_unref (_data2_);
			_data2_ = NULL;
		} else {
			g_assert_not_reached ();
		}
	}
	parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
}


static gchar* _folks_inspect_utils_persona_uid_completion_cb_rl_compentry_func_t (const gchar* str, gint a) {
	gchar* result;
	result = folks_inspect_utils_persona_uid_completion_cb (str, a);
	return result;
}


static gchar** _vala_array_dup4 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	glong string_length;
	glong _tmp2_;
	glong _tmp5_;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_;
	gboolean _tmp12_;
	gboolean _tmp13_ = FALSE;
	glong _tmp14_;
	gboolean _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_;
		glong _tmp4_;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_;
		glong _tmp7_;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	_tmp12_ = _tmp8_;
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp14_ = end;
	if (_tmp14_ >= ((glong) 0)) {
		glong _tmp15_;
		glong _tmp16_;
		_tmp15_ = end;
		_tmp16_ = string_length;
		_tmp13_ = _tmp15_ <= _tmp16_;
	} else {
		_tmp13_ = FALSE;
	}
	_tmp17_ = _tmp13_;
	g_return_val_if_fail (_tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	g_return_val_if_fail (_tmp18_ <= _tmp19_, NULL);
	_tmp20_ = start;
	_tmp21_ = end;
	_tmp22_ = start;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) (_tmp21_ - _tmp22_));
	result = _tmp23_;
	return result;
}


static gchar* _folks_inspect_utils_individual_id_completion_cb_rl_compentry_func_t (const gchar* str, gint a) {
	gchar* result;
	result = folks_inspect_utils_individual_id_completion_cb (str, a);
	return result;
}


static gchar** _vala_array_dup5 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


gchar* folks_inspect_commands_linking_subcommand_name_completion_cb (const gchar* word, gint state) {
	gchar* result = NULL;
	gint _tmp0_;
	gchar* _tmp61_;
	g_return_val_if_fail (word != NULL, NULL);
	_tmp0_ = state;
	if (_tmp0_ == 0) {
		const gchar* _tmp1_;
		gchar** _tmp2_;
		gchar** _tmp3_ = NULL;
		gchar** parts;
		gint parts_length1;
		gint _parts_size_;
		gboolean _tmp4_ = FALSE;
		gchar** _tmp5_;
		gint _tmp5__length1;
		gboolean _tmp8_;
		_tmp1_ = word;
		_tmp3_ = _tmp2_ = g_strsplit (_tmp1_, " ", 0);
		parts = _tmp3_;
		parts_length1 = _vala_array_length (_tmp2_);
		_parts_size_ = parts_length1;
		_tmp5_ = parts;
		_tmp5__length1 = parts_length1;
		if (_tmp5__length1 > 0) {
			gchar** _tmp6_;
			gint _tmp6__length1;
			const gchar* _tmp7_;
			_tmp6_ = parts;
			_tmp6__length1 = parts_length1;
			_tmp7_ = _tmp6_[0];
			_tmp4_ = g_strcmp0 (_tmp7_, "link-personas") == 0;
		} else {
			_tmp4_ = FALSE;
		}
		_tmp8_ = _tmp4_;
		if (_tmp8_) {
			gchar** _tmp9_;
			gint _tmp9__length1;
			gchar** _tmp10_;
			gint _tmp10__length1;
			const gchar* _tmp11_;
			gchar* _tmp12_;
			gchar* last_part;
			const gchar* _tmp13_;
			gchar** _tmp14_;
			gchar** _tmp15_ = NULL;
			gchar** _tmp16_;
			gint _tmp16__length1;
			const gchar* _tmp17_;
			_tmp9_ = parts;
			_tmp9__length1 = parts_length1;
			_tmp10_ = parts;
			_tmp10__length1 = parts_length1;
			_tmp11_ = _tmp9_[_tmp10__length1 - 1];
			_tmp12_ = g_strdup (_tmp11_);
			last_part = _tmp12_;
			_tmp13_ = last_part;
			_tmp15_ = _tmp14_ = rl_completion_matches (_tmp13_, _folks_inspect_utils_persona_uid_completion_cb_rl_compentry_func_t);
			_tmp16_ = (_tmp15_ != NULL) ? _vala_array_dup4 (_tmp15_, _vala_array_length (_tmp14_)) : ((gpointer) _tmp15_);
			_tmp16__length1 = _vala_array_length (_tmp14_);
			folks_inspect_commands_linking_subcommand_completions = (_vala_array_free (folks_inspect_commands_linking_subcommand_completions, _vala_array_length (folks_inspect_commands_linking_subcommand_completions), (GDestroyNotify) g_free), NULL);
			folks_inspect_commands_linking_subcommand_completions = _tmp16_;
			_tmp17_ = last_part;
			if (g_strcmp0 (_tmp17_, "") == 0) {
				const gchar* _tmp18_;
				gchar* _tmp19_;
				_tmp18_ = word;
				_tmp19_ = g_strdup (_tmp18_);
				_g_free0 (folks_inspect_commands_linking_prefix);
				folks_inspect_commands_linking_prefix = _tmp19_;
			} else {
				const gchar* _tmp20_;
				const gchar* _tmp21_;
				gint _tmp22_;
				gint _tmp23_;
				gchar* _tmp24_ = NULL;
				_tmp20_ = word;
				_tmp21_ = last_part;
				_tmp22_ = strlen (_tmp21_);
				_tmp23_ = _tmp22_;
				_tmp24_ = string_slice (_tmp20_, (glong) 0, (glong) (-_tmp23_));
				_g_free0 (folks_inspect_commands_linking_prefix);
				folks_inspect_commands_linking_prefix = _tmp24_;
			}
			_g_free0 (last_part);
		} else {
			gboolean _tmp25_ = FALSE;
			gchar** _tmp26_;
			gint _tmp26__length1;
			gboolean _tmp29_;
			_tmp26_ = parts;
			_tmp26__length1 = parts_length1;
			if (_tmp26__length1 > 0) {
				gchar** _tmp27_;
				gint _tmp27__length1;
				const gchar* _tmp28_;
				_tmp27_ = parts;
				_tmp27__length1 = parts_length1;
				_tmp28_ = _tmp27_[0];
				_tmp25_ = g_strcmp0 (_tmp28_, "unlink-individual") == 0;
			} else {
				_tmp25_ = FALSE;
			}
			_tmp29_ = _tmp25_;
			if (_tmp29_) {
				gchar** _tmp30_;
				gint _tmp30__length1;
				gchar** _tmp32_;
				gint _tmp32__length1;
				const gchar* _tmp33_;
				gchar** _tmp34_;
				gchar** _tmp35_ = NULL;
				gchar** _tmp36_;
				gint _tmp36__length1;
				gchar* _tmp37_;
				_tmp30_ = parts;
				_tmp30__length1 = parts_length1;
				if (_tmp30__length1 != 2) {
					gchar* _tmp31_;
					folks_inspect_commands_linking_subcommand_completions = (_vala_array_free (folks_inspect_commands_linking_subcommand_completions, _vala_array_length (folks_inspect_commands_linking_subcommand_completions), (GDestroyNotify) g_free), NULL);
					folks_inspect_commands_linking_subcommand_completions = NULL;
					folks_inspect_commands_linking_completion_count = (guint) 0;
					_tmp31_ = g_strdup ("");
					_g_free0 (folks_inspect_commands_linking_prefix);
					folks_inspect_commands_linking_prefix = _tmp31_;
					result = NULL;
					parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
					return result;
				}
				_tmp32_ = parts;
				_tmp32__length1 = parts_length1;
				_tmp33_ = _tmp32_[1];
				_tmp35_ = _tmp34_ = rl_completion_matches (_tmp33_, _folks_inspect_utils_individual_id_completion_cb_rl_compentry_func_t);
				_tmp36_ = (_tmp35_ != NULL) ? _vala_array_dup5 (_tmp35_, _vala_array_length (_tmp34_)) : ((gpointer) _tmp35_);
				_tmp36__length1 = _vala_array_length (_tmp34_);
				folks_inspect_commands_linking_subcommand_completions = (_vala_array_free (folks_inspect_commands_linking_subcommand_completions, _vala_array_length (folks_inspect_commands_linking_subcommand_completions), (GDestroyNotify) g_free), NULL);
				folks_inspect_commands_linking_subcommand_completions = _tmp36_;
				_tmp37_ = g_strdup ("unlink-individual ");
				_g_free0 (folks_inspect_commands_linking_prefix);
				folks_inspect_commands_linking_prefix = _tmp37_;
			} else {
				gchar* _tmp38_;
				gchar* _tmp39_;
				gchar** _tmp40_ = NULL;
				gchar* _tmp41_;
				_tmp38_ = g_strdup ("link-personas");
				_tmp39_ = g_strdup ("unlink-individual");
				_tmp40_ = g_new0 (gchar*, 3 + 1);
				_tmp40_[0] = _tmp38_;
				_tmp40_[1] = _tmp39_;
				_tmp40_[2] = NULL;
				folks_inspect_commands_linking_subcommand_completions = (_vala_array_free (folks_inspect_commands_linking_subcommand_completions, _vala_array_length (folks_inspect_commands_linking_subcommand_completions), (GDestroyNotify) g_free), NULL);
				folks_inspect_commands_linking_subcommand_completions = _tmp40_;
				_tmp41_ = g_strdup ("");
				_g_free0 (folks_inspect_commands_linking_prefix);
				folks_inspect_commands_linking_prefix = _tmp41_;
			}
		}
		folks_inspect_commands_linking_completion_count = (guint) 0;
		parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
	}
	while (TRUE) {
		guint _tmp42_;
		gchar** _tmp43_;
		gint _tmp43__length1;
		gchar** _tmp44_;
		gint _tmp44__length1;
		guint _tmp45_;
		const gchar* _tmp46_;
		gchar* _tmp47_;
		gchar* completion;
		const gchar* _tmp48_;
		const gchar* _tmp49_;
		gchar* _tmp50_;
		gchar* candidate;
		guint _tmp51_;
		gboolean _tmp52_ = FALSE;
		gboolean _tmp53_ = FALSE;
		const gchar* _tmp54_;
		gboolean _tmp56_;
		gboolean _tmp60_;
		_tmp42_ = folks_inspect_commands_linking_completion_count;
		_tmp43_ = folks_inspect_commands_linking_subcommand_completions;
		_tmp43__length1 = _vala_array_length (folks_inspect_commands_linking_subcommand_completions);
		if (!(_tmp42_ < ((guint) _tmp43__length1))) {
			break;
		}
		_tmp44_ = folks_inspect_commands_linking_subcommand_completions;
		_tmp44__length1 = _vala_array_length (folks_inspect_commands_linking_subcommand_completions);
		_tmp45_ = folks_inspect_commands_linking_completion_count;
		_tmp46_ = _tmp44_[_tmp45_];
		_tmp47_ = g_strdup (_tmp46_);
		completion = _tmp47_;
		_tmp48_ = folks_inspect_commands_linking_prefix;
		_tmp49_ = completion;
		_tmp50_ = g_strconcat (_tmp48_, _tmp49_, NULL);
		candidate = _tmp50_;
		_tmp51_ = folks_inspect_commands_linking_completion_count;
		folks_inspect_commands_linking_completion_count = _tmp51_ + 1;
		_tmp54_ = completion;
		if (_tmp54_ != NULL) {
			const gchar* _tmp55_;
			_tmp55_ = completion;
			_tmp53_ = g_strcmp0 (_tmp55_, "") != 0;
		} else {
			_tmp53_ = FALSE;
		}
		_tmp56_ = _tmp53_;
		if (_tmp56_) {
			const gchar* _tmp57_;
			const gchar* _tmp58_;
			gboolean _tmp59_ = FALSE;
			_tmp57_ = candidate;
			_tmp58_ = word;
			_tmp59_ = g_str_has_prefix (_tmp57_, _tmp58_);
			_tmp52_ = _tmp59_;
		} else {
			_tmp52_ = FALSE;
		}
		_tmp60_ = _tmp52_;
		if (_tmp60_) {
			result = completion;
			_g_free0 (candidate);
			return result;
		}
		_g_free0 (candidate);
		_g_free0 (completion);
	}
	folks_inspect_commands_linking_subcommand_completions = (_vala_array_free (folks_inspect_commands_linking_subcommand_completions, _vala_array_length (folks_inspect_commands_linking_subcommand_completions), (GDestroyNotify) g_free), NULL);
	folks_inspect_commands_linking_subcommand_completions = NULL;
	folks_inspect_commands_linking_completion_count = (guint) 0;
	_tmp61_ = g_strdup ("");
	_g_free0 (folks_inspect_commands_linking_prefix);
	folks_inspect_commands_linking_prefix = _tmp61_;
	result = NULL;
	return result;
}


static gchar* _folks_inspect_commands_linking_subcommand_name_completion_cb_rl_compentry_func_t (const gchar* str, gint a) {
	gchar* result;
	result = folks_inspect_commands_linking_subcommand_name_completion_cb (str, a);
	return result;
}


static gchar** _vala_array_dup6 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** folks_inspect_commands_linking_real_complete_subcommand (FolksInspectCommand* base, const gchar* subcommand, int* result_length1) {
	FolksInspectCommandsLinking * self;
	gchar** result = NULL;
	const gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_ = NULL;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar** _tmp4_;
	gint _tmp4__length1;
	self = (FolksInspectCommandsLinking*) base;
	g_return_val_if_fail (subcommand != NULL, NULL);
	_tmp0_ = subcommand;
	_tmp2_ = _tmp1_ = rl_completion_matches (_tmp0_, _folks_inspect_commands_linking_subcommand_name_completion_cb_rl_compentry_func_t);
	_tmp3_ = (_tmp2_ != NULL) ? _vala_array_dup6 (_tmp2_, _vala_array_length (_tmp1_)) : ((gpointer) _tmp2_);
	_tmp3__length1 = _vala_array_length (_tmp1_);
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}


static const gchar* folks_inspect_commands_linking_real_get_name (FolksInspectCommand* base) {
	const gchar* result;
	FolksInspectCommandsLinking* self;
	self = (FolksInspectCommandsLinking*) base;
	result = "linking";
	return result;
}


static const gchar* folks_inspect_commands_linking_real_get_description (FolksInspectCommand* base) {
	const gchar* result;
	FolksInspectCommandsLinking* self;
	self = (FolksInspectCommandsLinking*) base;
	result = "Link and unlink personas";
	return result;
}


static const gchar* folks_inspect_commands_linking_real_get_help (FolksInspectCommand* base) {
	const gchar* result;
	FolksInspectCommandsLinking* self;
	self = (FolksInspectCommandsLinking*) base;
	result = "linking link-personas [persona 1 UID] [persona 2 UID] …    " "Link the given personas.\n" "linking unlink-individual [individual ID]                  " "Unlink the given individual.";
	return result;
}


static void folks_inspect_commands_linking_class_init (FolksInspectCommandsLinkingClass * klass) {
	folks_inspect_commands_linking_parent_class = g_type_class_peek_parent (klass);
	FOLKS_INSPECT_COMMAND_CLASS (klass)->finalize = folks_inspect_commands_linking_finalize;
	FOLKS_INSPECT_COMMAND_CLASS (klass)->run = folks_inspect_commands_linking_real_run;
	FOLKS_INSPECT_COMMAND_CLASS (klass)->complete_subcommand = folks_inspect_commands_linking_real_complete_subcommand;
	FOLKS_INSPECT_COMMAND_CLASS (klass)->get_name = folks_inspect_commands_linking_real_get_name;
	FOLKS_INSPECT_COMMAND_CLASS (klass)->get_description = folks_inspect_commands_linking_real_get_description;
	FOLKS_INSPECT_COMMAND_CLASS (klass)->get_help = folks_inspect_commands_linking_real_get_help;
}


static void folks_inspect_commands_linking_instance_init (FolksInspectCommandsLinking * self) {
}


static void folks_inspect_commands_linking_finalize (FolksInspectCommand* obj) {
	FolksInspectCommandsLinking * self;
	self = FOLKS_INSPECT_COMMANDS_LINKING (obj);
	FOLKS_INSPECT_COMMAND_CLASS (folks_inspect_commands_linking_parent_class)->finalize (obj);
}


GType folks_inspect_commands_linking_get_type (void) {
	static volatile gsize folks_inspect_commands_linking_type_id__volatile = 0;
	if (g_once_init_enter (&folks_inspect_commands_linking_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksInspectCommandsLinkingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_inspect_commands_linking_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksInspectCommandsLinking), 0, (GInstanceInitFunc) folks_inspect_commands_linking_instance_init, NULL };
		GType folks_inspect_commands_linking_type_id;
		folks_inspect_commands_linking_type_id = g_type_register_static (FOLKS_INSPECT_TYPE_COMMAND, "FolksInspectCommandsLinking", &g_define_type_info, 0);
		g_once_init_leave (&folks_inspect_commands_linking_type_id__volatile, folks_inspect_commands_linking_type_id);
	}
	return folks_inspect_commands_linking_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



