/* edsf-persona.c generated by valac 0.13.1.106-1068, the Vala compiler
 * generated from edsf-persona.vala, do not modify */

/*
 * Copyright (C) 2011 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Travis Reitter <travis.reitter@collabora.co.uk>
 *       Marco Barisione <marco.barisione@collabora.co.uk>
 *       Raul Gutierrez Segales <raul.gutierrez.segales@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <folks/folks.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <libebook/e-book-client.h>
#include <gio/gio.h>


#define EDSF_TYPE_PERSONA (edsf_persona_get_type ())
#define EDSF_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EDSF_TYPE_PERSONA, EdsfPersona))
#define EDSF_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EDSF_TYPE_PERSONA, EdsfPersonaClass))
#define EDSF_IS_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EDSF_TYPE_PERSONA))
#define EDSF_IS_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EDSF_TYPE_PERSONA))
#define EDSF_PERSONA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EDSF_TYPE_PERSONA, EdsfPersonaClass))

typedef struct _EdsfPersona EdsfPersona;
typedef struct _EdsfPersonaClass EdsfPersonaClass;
typedef struct _EdsfPersonaPrivate EdsfPersonaPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _EdsfPersonaChangeGroupData EdsfPersonaChangeGroupData;

#define EDSF_TYPE_PERSONA_STORE (edsf_persona_store_get_type ())
#define EDSF_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EDSF_TYPE_PERSONA_STORE, EdsfPersonaStore))
#define EDSF_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EDSF_TYPE_PERSONA_STORE, EdsfPersonaStoreClass))
#define EDSF_IS_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EDSF_TYPE_PERSONA_STORE))
#define EDSF_IS_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EDSF_TYPE_PERSONA_STORE))
#define EDSF_PERSONA_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EDSF_TYPE_PERSONA_STORE, EdsfPersonaStoreClass))

typedef struct _EdsfPersonaStore EdsfPersonaStore;
typedef struct _EdsfPersonaStoreClass EdsfPersonaStoreClass;
#define __vala_EVCardAttribute_free0(var) ((var == NULL) ? NULL : (var = (_vala_EVCardAttribute_free (var), NULL)))
#define __vala_EVCardAttributeParam_free0(var) ((var == NULL) ? NULL : (var = (_vala_EVCardAttributeParam_free (var), NULL)))
#define __g_list_free___vala_EVCardAttribute_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free___vala_EVCardAttribute_free0_ (var), NULL)))
#define __vala_EContactName_free0(var) ((var == NULL) ? NULL : (var = (_vala_EContactName_free (var), NULL)))

#define EDSF_TYPE_MEMORY_ICON (edsf_memory_icon_get_type ())
#define EDSF_MEMORY_ICON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EDSF_TYPE_MEMORY_ICON, EdsfMemoryIcon))
#define EDSF_MEMORY_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EDSF_TYPE_MEMORY_ICON, EdsfMemoryIconClass))
#define EDSF_IS_MEMORY_ICON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EDSF_TYPE_MEMORY_ICON))
#define EDSF_IS_MEMORY_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EDSF_TYPE_MEMORY_ICON))
#define EDSF_MEMORY_ICON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EDSF_TYPE_MEMORY_ICON, EdsfMemoryIconClass))

typedef struct _EdsfMemoryIcon EdsfMemoryIcon;
typedef struct _EdsfMemoryIconClass EdsfMemoryIconClass;
typedef struct _Block1Data Block1Data;
#define __vala_EContactPhoto_free0(var) ((var == NULL) ? NULL : (var = (_vala_EContactPhoto_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define __vala_EContactAddress_free0(var) ((var == NULL) ? NULL : (var = (_vala_EContactAddress_free (var), NULL)))

struct _EdsfPersona {
	FolksPersona parent_instance;
	EdsfPersonaPrivate * priv;
};

struct _EdsfPersonaClass {
	FolksPersonaClass parent_class;
};

struct _EdsfPersonaPrivate {
	GeeHashSet* _phone_numbers;
	GeeSet* _phone_numbers_ro;
	GeeHashSet* _email_addresses;
	GeeSet* _email_addresses_ro;
	GeeHashSet* _notes;
	GeeSet* _notes_ro;
	GeeHashSet* _postal_addresses;
	GeeSet* _postal_addresses_ro;
	GeeHashSet* _local_ids;
	GeeSet* _local_ids_ro;
	GeeHashMultiMap* _web_service_addresses;
	EContact* _contact;
	GLoadableIcon* _avatar;
	FolksStructuredName* _structured_name;
	gchar* _contact_id;
	gchar* _full_name;
	gchar* _nickname;
	FolksGender _gender;
	GeeHashSet* _urls;
	GeeSet* _urls_ro;
	GeeHashMultiMap* _im_addresses;
	GeeHashSet* _groups;
	GeeSet* _groups_ro;
};

struct _EdsfPersonaChangeGroupData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	EdsfPersona* self;
	gchar* group;
	gboolean is_member;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GeeHashSet* _tmp3_;
	const gchar* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	GeeHashSet* _tmp9_;
	const gchar* _tmp10_;
	gboolean _tmp11_;
	gboolean _tmp12_;
	gboolean _tmp13_;
	GeeHashSet* _tmp14_;
	GeeHashSet* new_groups;
	GeeHashSet* _tmp15_;
	GeeIterator* _tmp16_;
	GeeIterator* _category_name_it;
	GeeIterator* _tmp17_;
	gboolean _tmp18_;
	GeeIterator* _tmp19_;
	gpointer _tmp20_;
	gchar* category_name;
	GeeHashSet* _tmp21_;
	const gchar* _tmp22_;
	gboolean _tmp23_;
	GeeHashSet* _tmp24_;
	const gchar* _tmp25_;
	GeeHashSet* _tmp26_;
	const gchar* _tmp27_;
	GeeHashSet* _tmp28_;
};

struct _Block1Data {
	int _ref_count_;
	EdsfPersona * self;
	FolksAvatarCache* cache;
	GLoadableIcon* new_avatar;
};


static gpointer edsf_persona_parent_class = NULL;
static GHashTable* edsf_persona__im_eds_map;
static GStaticRecMutex __lock_edsf_persona__im_eds_map = {0};
static GHashTable* edsf_persona__im_eds_map = NULL;
static FolksAvatarDetailsIface* edsf_persona_folks_avatar_details_parent_iface = NULL;
static FolksEmailDetailsIface* edsf_persona_folks_email_details_parent_iface = NULL;
static FolksGenderDetailsIface* edsf_persona_folks_gender_details_parent_iface = NULL;
static FolksGroupDetailsIface* edsf_persona_folks_group_details_parent_iface = NULL;
static FolksImDetailsIface* edsf_persona_folks_im_details_parent_iface = NULL;
static FolksLocalIdDetailsIface* edsf_persona_folks_local_id_details_parent_iface = NULL;
static FolksNameDetailsIface* edsf_persona_folks_name_details_parent_iface = NULL;
static FolksNoteDetailsIface* edsf_persona_folks_note_details_parent_iface = NULL;
static FolksPhoneDetailsIface* edsf_persona_folks_phone_details_parent_iface = NULL;
static FolksUrlDetailsIface* edsf_persona_folks_url_details_parent_iface = NULL;
static FolksPostalAddressDetailsIface* edsf_persona_folks_postal_address_details_parent_iface = NULL;
static FolksWebServiceDetailsIface* edsf_persona_folks_web_service_details_parent_iface = NULL;

GType edsf_persona_get_type (void) G_GNUC_CONST;
#define EDSF_PERSONA_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), EDSF_TYPE_PERSONA, EdsfPersonaPrivate))
enum  {
	EDSF_PERSONA_DUMMY_PROPERTY,
	EDSF_PERSONA_CONTACT,
	EDSF_PERSONA_WEB_SERVICE_ADDRESSES,
	EDSF_PERSONA_LOCAL_IDS,
	EDSF_PERSONA_POSTAL_ADDRESSES,
	EDSF_PERSONA_PHONE_NUMBERS,
	EDSF_PERSONA_EMAIL_ADDRESSES,
	EDSF_PERSONA_NOTES,
	EDSF_PERSONA_LINKABLE_PROPERTIES,
	EDSF_PERSONA_WRITEABLE_PROPERTIES,
	EDSF_PERSONA_AVATAR,
	EDSF_PERSONA_STRUCTURED_NAME,
	EDSF_PERSONA_CONTACT_ID,
	EDSF_PERSONA_FULL_NAME,
	EDSF_PERSONA_NICKNAME,
	EDSF_PERSONA_GENDER,
	EDSF_PERSONA_URLS,
	EDSF_PERSONA_IM_ADDRESSES,
	EDSF_PERSONA_GROUPS
};
#define EDSF_PERSONA_gender_attribute_name "X-GENDER"
#define EDSF_PERSONA_gender_male "M"
#define EDSF_PERSONA_gender_female "F"
static void edsf_persona_real_change_group_data_free (gpointer _data);
static void edsf_persona_real_change_group (FolksGroupDetails* base, const gchar* group, gboolean is_member, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean edsf_persona_real_change_group_co (EdsfPersonaChangeGroupData* _data_);
gchar* edsf_persona_build_iid_from_contact (const gchar* store_id, EContact* contact);
void* _edsf_persona_get_property_from_contact (EContact* contact, const gchar* prop_name);
gchar* edsf_persona_build_iid (const gchar* store_id, const gchar* contact_id);
GType edsf_persona_store_get_type (void) G_GNUC_CONST;
EdsfPersona* edsf_persona_new (EdsfPersonaStore* store, EContact* contact);
EdsfPersona* edsf_persona_construct (GType object_type, EdsfPersonaStore* store, EContact* contact);
static void edsf_persona_set_contact_id (EdsfPersona* self, const gchar* value);
void _edsf_persona_update (EdsfPersona* self, EContact* contact);
static void edsf_persona_real_linkable_property_to_links (FolksPersona* base, const gchar* prop_name, FolksPersonaLinkablePropertyCallback callback, void* callback_target);
static void edsf_persona_set_contact (EdsfPersona* self, EContact* value);
static void _edsf_persona_update_names (EdsfPersona* self);
static void _edsf_persona_update_avatar (EdsfPersona* self);
static void _edsf_persona_update_urls (EdsfPersona* self);
static void _edsf_persona_update_phones (EdsfPersona* self);
static void _edsf_persona_update_addresses (EdsfPersona* self);
static void _edsf_persona_update_emails (EdsfPersona* self);
static void _edsf_persona_update_im_addresses (EdsfPersona* self);
static void _edsf_persona_update_groups (EdsfPersona* self);
static void _edsf_persona_update_notes (EdsfPersona* self);
static void _edsf_persona_update_local_ids (EdsfPersona* self);
static void _edsf_persona_update_web_services_addresses (EdsfPersona* self);
static void _edsf_persona_update_gender (EdsfPersona* self);
EContact* edsf_persona_get_contact (EdsfPersona* self);
static EVCardAttribute* _vala_EVCardAttribute_copy (EVCardAttribute* self);
static void _vala_EVCardAttribute_free (EVCardAttribute* self);
static EVCardAttributeParam* _vala_EVCardAttributeParam_copy (EVCardAttributeParam* self);
static void _vala_EVCardAttributeParam_free (EVCardAttributeParam* self);
static void __vala_EVCardAttribute_free0_ (gpointer var);
static void _g_list_free___vala_EVCardAttribute_free0_ (GList* self);
static void* _edsf_persona_get_property (EdsfPersona* self, const gchar* prop_name);
static EContactName* _vala_EContactName_copy (EContactName* self);
static void _vala_EContactName_free (EContactName* self);
static GLoadableIcon* _edsf_persona_contact_photo_to_loadable_icon (EdsfPersona* self, EContactPhoto* p);
EdsfMemoryIcon* edsf_memory_icon_new (const gchar* image_type, guint8* image_data, int image_data_length1);
EdsfMemoryIcon* edsf_memory_icon_construct (GType object_type, const gchar* image_type, guint8* image_data, int image_data_length1);
GType edsf_memory_icon_get_type (void) G_GNUC_CONST;
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
static EContactPhoto* _vala_EContactPhoto_copy (EContactPhoto* self);
static void _vala_EContactPhoto_free (EContactPhoto* self);
static void _lambda0_ (GObject* obj, GAsyncResult* res, Block1Data* _data1_);
static void __lambda0__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void _lambda1_ (GObject* obj, GAsyncResult* res, Block1Data* _data1_);
static void __lambda1__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
GHashTable* _edsf_persona_get_im_eds_map (void);
static void _g_free0_ (gpointer var);
static EContactAddress* _vala_EContactAddress_copy (EContactAddress* self);
static void _vala_EContactAddress_free (EContactAddress* self);
void _edsf_persona_store_set_web_service_addresses (EdsfPersonaStore* self, EdsfPersona* persona, GeeMultiMap* web_service_addresses, GAsyncReadyCallback _callback_, gpointer _user_data_);
void _edsf_persona_store_set_web_service_addresses_finish (EdsfPersonaStore* self, GAsyncResult* _res_);
const gchar* edsf_persona_get_contact_id (EdsfPersona* self);
void _edsf_persona_store_set_local_ids (EdsfPersonaStore* self, EdsfPersona* persona, GeeSet* local_ids, GAsyncReadyCallback _callback_, gpointer _user_data_);
void _edsf_persona_store_set_local_ids_finish (EdsfPersonaStore* self, GAsyncResult* _res_);
void _edsf_persona_store_set_postal_addresses (EdsfPersonaStore* self, EdsfPersona* persona, GeeSet* postal_fds, GAsyncReadyCallback _callback_, gpointer _user_data_);
void _edsf_persona_store_set_postal_addresses_finish (EdsfPersonaStore* self, GAsyncResult* _res_);
void _edsf_persona_store_set_phones (EdsfPersonaStore* self, EdsfPersona* persona, GeeSet* phones, GAsyncReadyCallback _callback_, gpointer _user_data_);
void _edsf_persona_store_set_phones_finish (EdsfPersonaStore* self, GAsyncResult* _res_);
void _edsf_persona_store_set_emails (EdsfPersonaStore* self, EdsfPersona* persona, GeeSet* emails, GAsyncReadyCallback _callback_, gpointer _user_data_);
void _edsf_persona_store_set_emails_finish (EdsfPersonaStore* self, GAsyncResult* _res_);
void _edsf_persona_store_set_notes (EdsfPersonaStore* self, EdsfPersona* persona, GeeSet* notes, GAsyncReadyCallback _callback_, gpointer _user_data_);
void _edsf_persona_store_set_notes_finish (EdsfPersonaStore* self, GAsyncResult* _res_);
void _edsf_persona_store_set_avatar (EdsfPersonaStore* self, EdsfPersona* persona, GLoadableIcon* avatar, GAsyncReadyCallback _callback_, gpointer _user_data_);
void _edsf_persona_store_set_avatar_finish (EdsfPersonaStore* self, GAsyncResult* _res_);
void _edsf_persona_store_set_structured_name (EdsfPersonaStore* self, EdsfPersona* persona, FolksStructuredName* sname, GAsyncReadyCallback _callback_, gpointer _user_data_);
void _edsf_persona_store_set_structured_name_finish (EdsfPersonaStore* self, GAsyncResult* _res_);
void _edsf_persona_store_set_full_name (EdsfPersonaStore* self, EdsfPersona* persona, const gchar* full_name, GAsyncReadyCallback _callback_, gpointer _user_data_);
void _edsf_persona_store_set_full_name_finish (EdsfPersonaStore* self, GAsyncResult* _res_);
void _edsf_persona_store_set_nickname (EdsfPersonaStore* self, EdsfPersona* persona, const gchar* nickname, GAsyncReadyCallback _callback_, gpointer _user_data_);
void _edsf_persona_store_set_nickname_finish (EdsfPersonaStore* self, GAsyncResult* _res_);
void _edsf_persona_store_set_gender (EdsfPersonaStore* self, EdsfPersona* persona, FolksGender gender, GAsyncReadyCallback _callback_, gpointer _user_data_);
void _edsf_persona_store_set_gender_finish (EdsfPersonaStore* self, GAsyncResult* _res_);
void _edsf_persona_store_set_urls (EdsfPersonaStore* self, EdsfPersona* persona, GeeSet* urls, GAsyncReadyCallback _callback_, gpointer _user_data_);
void _edsf_persona_store_set_urls_finish (EdsfPersonaStore* self, GAsyncResult* _res_);
void _edsf_persona_store_set_im_fds (EdsfPersonaStore* self, EdsfPersona* persona, GeeMultiMap* im_fds, GAsyncReadyCallback _callback_, gpointer _user_data_);
void _edsf_persona_store_set_im_fds_finish (EdsfPersonaStore* self, GAsyncResult* _res_);
void _edsf_persona_store_set_groups (EdsfPersonaStore* self, EdsfPersona* persona, GeeSet* groups, GAsyncReadyCallback _callback_, gpointer _user_data_);
void _edsf_persona_store_set_groups_finish (EdsfPersonaStore* self, GAsyncResult* _res_);
static void edsf_persona_finalize (GObject* obj);
static void _vala_edsf_persona_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_edsf_persona_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);

const gchar* EDSF_PERSONA_phone_fields[12] = {"assistant_phone", "business_phone", "business_phone_2", "callback_phone", "car_phone", "company_phone", "home_phone", "home_phone_2", "isdn_phone", "mobile_phone", "other_phone", "primary_phone"};
const gchar* EDSF_PERSONA_address_fields[3] = {"address_home", "address_other", "address_work"};
const gchar* EDSF_PERSONA_email_fields[4] = {"email_1", "email_2", "email_3", "email_4"};
const gchar* EDSF_PERSONA_url_properties[4] = {"blog_url", "fburl", "homepage_url", "video_url"};
static const gchar* EDSF_PERSONA__linkable_properties[3] = {"im-addresses", "local-ids", "web-service-addresses"};
static const gchar* EDSF_PERSONA__writeable_properties[12] = {"web-service-addresses", "local-ids", "postal-addresses", "phone-numbers", "email-addresses", "notes", "avatar", "structured-name", "full-name", "nickname", "im-addresses", "groups"};

static void edsf_persona_real_change_group_data_free (gpointer _data) {
	EdsfPersonaChangeGroupData* _data_;
	_data_ = _data;
	_g_free0 (_data_->group);
	_g_object_unref0 (_data_->self);
	g_slice_free (EdsfPersonaChangeGroupData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void edsf_persona_real_change_group (FolksGroupDetails* base, const gchar* group, gboolean is_member, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	EdsfPersona * self;
	EdsfPersonaChangeGroupData* _data_;
	EdsfPersona* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gboolean _tmp3_;
	self = (EdsfPersona*) base;
	_data_ = g_slice_new0 (EdsfPersonaChangeGroupData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, edsf_persona_real_change_group);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, edsf_persona_real_change_group_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = group;
	_tmp2_ = g_strdup (_tmp1_);
	_data_->group = _tmp2_;
	_tmp3_ = is_member;
	_data_->is_member = _tmp3_;
	edsf_persona_real_change_group_co (_data_);
}


static void edsf_persona_real_change_group_finish (FolksGroupDetails* base, GAsyncResult* _res_, GError** error) {
	EdsfPersonaChangeGroupData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * {@inheritDoc}
   *
   * @since 0.6.0
   */
static gboolean edsf_persona_real_change_group_co (EdsfPersonaChangeGroupData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp2_ = _data_->is_member;
	if (_data_->_tmp2_ == TRUE) {
		_data_->_tmp3_ = _data_->self->priv->_groups;
		_data_->_tmp4_ = _data_->group;
		_data_->_tmp5_ = FALSE;
		_data_->_tmp5_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _data_->_tmp3_, _data_->_tmp4_);
		_data_->_tmp1_ = _data_->_tmp5_ == TRUE;
	} else {
		_data_->_tmp1_ = FALSE;
	}
	_data_->_tmp6_ = _data_->_tmp1_;
	if (_data_->_tmp6_) {
		_data_->_tmp0_ = TRUE;
	} else {
		_data_->_tmp8_ = _data_->is_member;
		if (_data_->_tmp8_ == FALSE) {
			_data_->_tmp9_ = _data_->self->priv->_groups;
			_data_->_tmp10_ = _data_->group;
			_data_->_tmp11_ = FALSE;
			_data_->_tmp11_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _data_->_tmp9_, _data_->_tmp10_);
			_data_->_tmp7_ = _data_->_tmp11_ == FALSE;
		} else {
			_data_->_tmp7_ = FALSE;
		}
		_data_->_tmp12_ = _data_->_tmp7_;
		_data_->_tmp0_ = _data_->_tmp12_;
	}
	_data_->_tmp13_ = _data_->_tmp0_;
	if (_data_->_tmp13_) {
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp14_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL);
	_data_->new_groups = _data_->_tmp14_;
	{
		_data_->_tmp15_ = _data_->self->priv->_groups;
		_data_->_tmp16_ = NULL;
		_data_->_tmp16_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _data_->_tmp15_);
		_data_->_category_name_it = _data_->_tmp16_;
		while (TRUE) {
			_data_->_tmp17_ = _data_->_category_name_it;
			_data_->_tmp18_ = FALSE;
			_data_->_tmp18_ = gee_iterator_next (_data_->_tmp17_);
			if (!_data_->_tmp18_) {
				break;
			}
			_data_->_tmp19_ = _data_->_category_name_it;
			_data_->_tmp20_ = NULL;
			_data_->_tmp20_ = gee_iterator_get (_data_->_tmp19_);
			_data_->category_name = (gchar*) _data_->_tmp20_;
			_data_->_tmp21_ = _data_->new_groups;
			_data_->_tmp22_ = _data_->category_name;
			gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp21_, _data_->_tmp22_);
			_g_free0 (_data_->category_name);
		}
		_g_object_unref0 (_data_->_category_name_it);
	}
	_data_->_tmp23_ = _data_->is_member;
	if (_data_->_tmp23_ == FALSE) {
		_data_->_tmp24_ = _data_->new_groups;
		_data_->_tmp25_ = _data_->group;
		gee_abstract_collection_remove ((GeeAbstractCollection*) _data_->_tmp24_, _data_->_tmp25_);
	} else {
		_data_->_tmp26_ = _data_->new_groups;
		_data_->_tmp27_ = _data_->group;
		gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp26_, _data_->_tmp27_);
	}
	_data_->_tmp28_ = _data_->new_groups;
	folks_group_details_set_groups ((FolksGroupDetails*) _data_->self, (GeeSet*) _data_->_tmp28_);
	_g_object_unref0 (_data_->new_groups);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


/**
   * Build a IID.
   *
   * @param store_id the {@link PersonaStore.id}
   * @param contact the Contact
   * @return a valid IID
   *
   * @since 0.6.0
   */
gchar* edsf_persona_build_iid_from_contact (const gchar* store_id, EContact* contact) {
	gchar* result = NULL;
	EContact* _tmp0_;
	void* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* contact_id;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_ = NULL;
	g_return_val_if_fail (store_id != NULL, NULL);
	g_return_val_if_fail (contact != NULL, NULL);
	_tmp0_ = contact;
	_tmp1_ = _edsf_persona_get_property_from_contact (_tmp0_, "id");
	_tmp2_ = g_strdup ((const gchar*) _tmp1_);
	contact_id = _tmp2_;
	_tmp3_ = store_id;
	_tmp4_ = contact_id;
	_tmp5_ = edsf_persona_build_iid (_tmp3_, _tmp4_);
	result = _tmp5_;
	_g_free0 (contact_id);
	return result;
}


/**
   * Build a IID.
   *
   * @param store_id the {@link PersonaStore.id}
   * @param contact_id the id belonging to the Contact
   * @return a valid IID
   *
   * @since 0.6.0
   */
gchar* edsf_persona_build_iid (const gchar* store_id, const gchar* contact_id) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	g_return_val_if_fail (store_id != NULL, NULL);
	g_return_val_if_fail (contact_id != NULL, NULL);
	_tmp0_ = store_id;
	_tmp1_ = contact_id;
	_tmp2_ = g_strdup_printf ("%s:%s", _tmp0_, _tmp1_);
	result = _tmp2_;
	return result;
}


/**
   * Create a new persona.
   *
   * Create a new persona for the {@link PersonaStore} `store`, representing
   * the EDS contact given by `contact`.
   *
   * @since 0.6.0
   */
EdsfPersona* edsf_persona_construct (GType object_type, EdsfPersonaStore* store, EContact* contact) {
	EdsfPersona * self = NULL;
	EContact* _tmp0_;
	void* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* contact_id;
	EdsfPersonaStore* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* uid;
	EdsfPersonaStore* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_ = NULL;
	gchar* iid;
	EContact* _tmp13_;
	gboolean _tmp14_ = FALSE;
	gboolean is_user;
	EContact* _tmp15_;
	void* _tmp16_ = NULL;
	gchar* _tmp17_;
	gchar* full_name;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	EdsfPersonaStore* _tmp22_;
	gboolean _tmp23_;
	const gchar* _tmp24_;
	GeeHashSet* _tmp25_;
	GeeHashSet* _tmp26_;
	GeeSet* _tmp27_;
	GeeSet* _tmp28_;
	GeeHashSet* _tmp29_;
	GeeHashSet* _tmp30_;
	GeeSet* _tmp31_;
	GeeSet* _tmp32_;
	GeeHashSet* _tmp33_;
	GeeHashSet* _tmp34_;
	GeeSet* _tmp35_;
	GeeSet* _tmp36_;
	GeeHashSet* _tmp37_;
	GeeHashSet* _tmp38_;
	GeeSet* _tmp39_;
	GeeSet* _tmp40_;
	GeeHashSet* _tmp41_;
	GeeHashSet* _tmp42_;
	GeeSet* _tmp43_;
	GeeSet* _tmp44_;
	GeeHashSet* _tmp45_;
	GeeHashSet* _tmp46_;
	GeeSet* _tmp47_;
	GeeSet* _tmp48_;
	GeeHashMultiMap* _tmp49_;
	GeeHashSet* _tmp50_;
	GeeHashSet* _tmp51_;
	GeeSet* _tmp52_;
	GeeSet* _tmp53_;
	EContact* _tmp54_;
	g_return_val_if_fail (store != NULL, NULL);
	g_return_val_if_fail (contact != NULL, NULL);
	_tmp0_ = contact;
	_tmp1_ = _edsf_persona_get_property_from_contact (_tmp0_, "id");
	_tmp2_ = g_strdup ((const gchar*) _tmp1_);
	contact_id = _tmp2_;
	_tmp3_ = store;
	_tmp4_ = folks_persona_store_get_id ((FolksPersonaStore*) _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = contact_id;
	_tmp7_ = folks_persona_build_uid (BACKEND_NAME, _tmp5_, _tmp6_);
	uid = _tmp7_;
	_tmp8_ = store;
	_tmp9_ = folks_persona_store_get_id ((FolksPersonaStore*) _tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = contact_id;
	_tmp12_ = edsf_persona_build_iid (_tmp10_, _tmp11_);
	iid = _tmp12_;
	_tmp13_ = contact;
	_tmp14_ = e_book_client_is_self (_tmp13_);
	is_user = _tmp14_;
	_tmp15_ = contact;
	_tmp16_ = _edsf_persona_get_property_from_contact (_tmp15_, "full_name");
	_tmp17_ = g_strdup ((const gchar*) _tmp16_);
	full_name = _tmp17_;
	_tmp18_ = iid;
	g_debug ("edsf-persona.vala:477: Creating new Edsf.Persona with IID '%s'", _tmp18_);
	_tmp19_ = full_name;
	_tmp20_ = uid;
	_tmp21_ = iid;
	_tmp22_ = store;
	_tmp23_ = is_user;
	self = (EdsfPersona*) g_object_new (object_type, "display-id", _tmp19_, "uid", _tmp20_, "iid", _tmp21_, "store", _tmp22_, "is-user", _tmp23_, NULL);
	self->priv->_gender = FOLKS_GENDER_UNSPECIFIED;
	_tmp24_ = contact_id;
	edsf_persona_set_contact_id (self, _tmp24_);
	_tmp25_ = gee_hash_set_new (FOLKS_TYPE_PHONE_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, (GHashFunc) folks_abstract_field_details_hash, (GEqualFunc) folks_abstract_field_details_equal);
	_g_object_unref0 (self->priv->_phone_numbers);
	self->priv->_phone_numbers = _tmp25_;
	_tmp26_ = self->priv->_phone_numbers;
	_tmp27_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) _tmp26_);
	_tmp28_ = _tmp27_;
	_g_object_unref0 (self->priv->_phone_numbers_ro);
	self->priv->_phone_numbers_ro = _tmp28_;
	_tmp29_ = gee_hash_set_new (FOLKS_TYPE_EMAIL_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, (GHashFunc) folks_abstract_field_details_hash, (GEqualFunc) folks_abstract_field_details_equal);
	_g_object_unref0 (self->priv->_email_addresses);
	self->priv->_email_addresses = _tmp29_;
	_tmp30_ = self->priv->_email_addresses;
	_tmp31_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) _tmp30_);
	_tmp32_ = _tmp31_;
	_g_object_unref0 (self->priv->_email_addresses_ro);
	self->priv->_email_addresses_ro = _tmp32_;
	_tmp33_ = gee_hash_set_new (FOLKS_TYPE_NOTE_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, (GHashFunc) folks_abstract_field_details_hash, (GEqualFunc) folks_abstract_field_details_equal);
	_g_object_unref0 (self->priv->_notes);
	self->priv->_notes = _tmp33_;
	_tmp34_ = self->priv->_notes;
	_tmp35_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) _tmp34_);
	_tmp36_ = _tmp35_;
	_g_object_unref0 (self->priv->_notes_ro);
	self->priv->_notes_ro = _tmp36_;
	_tmp37_ = gee_hash_set_new (FOLKS_TYPE_URL_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, (GHashFunc) folks_abstract_field_details_hash, (GEqualFunc) folks_abstract_field_details_equal);
	_g_object_unref0 (self->priv->_urls);
	self->priv->_urls = _tmp37_;
	_tmp38_ = self->priv->_urls;
	_tmp39_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) _tmp38_);
	_tmp40_ = _tmp39_;
	_g_object_unref0 (self->priv->_urls_ro);
	self->priv->_urls_ro = _tmp40_;
	_tmp41_ = gee_hash_set_new (FOLKS_TYPE_POSTAL_ADDRESS_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, (GHashFunc) folks_abstract_field_details_hash, (GEqualFunc) folks_abstract_field_details_equal);
	_g_object_unref0 (self->priv->_postal_addresses);
	self->priv->_postal_addresses = _tmp41_;
	_tmp42_ = self->priv->_postal_addresses;
	_tmp43_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) _tmp42_);
	_tmp44_ = _tmp43_;
	_g_object_unref0 (self->priv->_postal_addresses_ro);
	self->priv->_postal_addresses_ro = _tmp44_;
	_tmp45_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL);
	_g_object_unref0 (self->priv->_local_ids);
	self->priv->_local_ids = _tmp45_;
	_tmp46_ = self->priv->_local_ids;
	_tmp47_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) _tmp46_);
	_tmp48_ = _tmp47_;
	_g_object_unref0 (self->priv->_local_ids_ro);
	self->priv->_local_ids_ro = _tmp48_;
	_tmp49_ = gee_hash_multi_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, FOLKS_TYPE_WEB_SERVICE_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, (GHashFunc) folks_abstract_field_details_hash, (GEqualFunc) folks_abstract_field_details_equal);
	_g_object_unref0 (self->priv->_web_service_addresses);
	self->priv->_web_service_addresses = _tmp49_;
	_tmp50_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL);
	_g_object_unref0 (self->priv->_groups);
	self->priv->_groups = _tmp50_;
	_tmp51_ = self->priv->_groups;
	_tmp52_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) _tmp51_);
	_tmp53_ = _tmp52_;
	_g_object_unref0 (self->priv->_groups_ro);
	self->priv->_groups_ro = _tmp53_;
	_tmp54_ = contact;
	_edsf_persona_update (self, _tmp54_);
	_g_free0 (full_name);
	_g_free0 (iid);
	_g_free0 (uid);
	_g_free0 (contact_id);
	return self;
}


EdsfPersona* edsf_persona_new (EdsfPersonaStore* store, EContact* contact) {
	return edsf_persona_construct (EDSF_TYPE_PERSONA, store, contact);
}


/**
   * {@inheritDoc}
   *
   * @since 0.6.0
   */
static void edsf_persona_real_linkable_property_to_links (FolksPersona* base, const gchar* prop_name, FolksPersonaLinkablePropertyCallback callback, void* callback_target) {
	EdsfPersona * self;
	const gchar* _tmp0_;
	self = (EdsfPersona*) base;
	g_return_if_fail (prop_name != NULL);
	_tmp0_ = prop_name;
	if (g_strcmp0 (_tmp0_, "im-addresses") == 0) {
		{
			GeeHashMultiMap* _tmp1_;
			GeeSet* _tmp2_ = NULL;
			GeeSet* _tmp3_;
			GeeIterator* _tmp4_ = NULL;
			GeeIterator* _tmp5_;
			GeeIterator* _protocol_it;
			_tmp1_ = self->priv->_im_addresses;
			_tmp2_ = gee_multi_map_get_keys ((GeeMultiMap*) _tmp1_);
			_tmp3_ = _tmp2_;
			_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
			_tmp5_ = _tmp4_;
			_g_object_unref0 (_tmp3_);
			_protocol_it = _tmp5_;
			while (TRUE) {
				GeeIterator* _tmp6_;
				gboolean _tmp7_ = FALSE;
				GeeIterator* _tmp8_;
				gpointer _tmp9_ = NULL;
				gchar* protocol;
				GeeHashMultiMap* _tmp10_;
				const gchar* _tmp11_;
				GeeCollection* _tmp12_ = NULL;
				GeeCollection* im_fds;
				_tmp6_ = _protocol_it;
				_tmp7_ = gee_iterator_next (_tmp6_);
				if (!_tmp7_) {
					break;
				}
				_tmp8_ = _protocol_it;
				_tmp9_ = gee_iterator_get (_tmp8_);
				protocol = (gchar*) _tmp9_;
				_tmp10_ = self->priv->_im_addresses;
				_tmp11_ = protocol;
				_tmp12_ = gee_multi_map_get ((GeeMultiMap*) _tmp10_, _tmp11_);
				im_fds = _tmp12_;
				{
					GeeCollection* _tmp13_;
					GeeIterator* _tmp14_ = NULL;
					GeeIterator* _im_fd_it;
					_tmp13_ = im_fds;
					_tmp14_ = gee_iterable_iterator ((GeeIterable*) _tmp13_);
					_im_fd_it = _tmp14_;
					while (TRUE) {
						GeeIterator* _tmp15_;
						gboolean _tmp16_ = FALSE;
						GeeIterator* _tmp17_;
						gpointer _tmp18_ = NULL;
						FolksImFieldDetails* im_fd;
						FolksPersonaLinkablePropertyCallback _tmp19_;
						void* _tmp19__target;
						const gchar* _tmp20_;
						gchar* _tmp21_;
						gchar* _tmp22_;
						FolksImFieldDetails* _tmp23_;
						gconstpointer _tmp24_;
						const gchar* _tmp25_;
						gchar* _tmp26_;
						gchar* _tmp27_;
						_tmp15_ = _im_fd_it;
						_tmp16_ = gee_iterator_next (_tmp15_);
						if (!_tmp16_) {
							break;
						}
						_tmp17_ = _im_fd_it;
						_tmp18_ = gee_iterator_get (_tmp17_);
						im_fd = (FolksImFieldDetails*) _tmp18_;
						_tmp19_ = callback;
						_tmp19__target = callback_target;
						_tmp20_ = protocol;
						_tmp21_ = g_strconcat (_tmp20_, ":", NULL);
						_tmp22_ = _tmp21_;
						_tmp23_ = im_fd;
						_tmp24_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp23_);
						_tmp25_ = _tmp24_;
						_tmp26_ = g_strconcat (_tmp22_, (const gchar*) _tmp25_, NULL);
						_tmp27_ = _tmp26_;
						_tmp19_ (_tmp27_, _tmp19__target);
						_g_free0 (_tmp27_);
						_g_free0 (_tmp22_);
						_g_object_unref0 (im_fd);
					}
					_g_object_unref0 (_im_fd_it);
				}
				_g_object_unref0 (im_fds);
				_g_free0 (protocol);
			}
			_g_object_unref0 (_protocol_it);
		}
	} else {
		const gchar* _tmp28_;
		_tmp28_ = prop_name;
		if (g_strcmp0 (_tmp28_, "local-ids") == 0) {
			{
				GeeHashSet* _tmp29_;
				GeeIterator* _tmp30_ = NULL;
				GeeIterator* _id_it;
				_tmp29_ = self->priv->_local_ids;
				_tmp30_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp29_);
				_id_it = _tmp30_;
				while (TRUE) {
					GeeIterator* _tmp31_;
					gboolean _tmp32_ = FALSE;
					GeeIterator* _tmp33_;
					gpointer _tmp34_ = NULL;
					gchar* id;
					FolksPersonaLinkablePropertyCallback _tmp35_;
					void* _tmp35__target;
					const gchar* _tmp36_;
					_tmp31_ = _id_it;
					_tmp32_ = gee_iterator_next (_tmp31_);
					if (!_tmp32_) {
						break;
					}
					_tmp33_ = _id_it;
					_tmp34_ = gee_iterator_get (_tmp33_);
					id = (gchar*) _tmp34_;
					_tmp35_ = callback;
					_tmp35__target = callback_target;
					_tmp36_ = id;
					_tmp35_ (_tmp36_, _tmp35__target);
					_g_free0 (id);
				}
				_g_object_unref0 (_id_it);
			}
		} else {
			const gchar* _tmp37_;
			_tmp37_ = prop_name;
			if (g_strcmp0 (_tmp37_, "web-service-addresses") == 0) {
				{
					GeeMultiMap* _tmp38_;
					GeeMultiMap* _tmp39_;
					GeeSet* _tmp40_ = NULL;
					GeeSet* _tmp41_;
					GeeIterator* _tmp42_ = NULL;
					GeeIterator* _tmp43_;
					GeeIterator* _web_service_it;
					_tmp38_ = folks_web_service_details_get_web_service_addresses ((FolksWebServiceDetails*) self);
					_tmp39_ = _tmp38_;
					_tmp40_ = gee_multi_map_get_keys (_tmp39_);
					_tmp41_ = _tmp40_;
					_tmp42_ = gee_iterable_iterator ((GeeIterable*) _tmp41_);
					_tmp43_ = _tmp42_;
					_g_object_unref0 (_tmp41_);
					_web_service_it = _tmp43_;
					while (TRUE) {
						GeeIterator* _tmp44_;
						gboolean _tmp45_ = FALSE;
						GeeIterator* _tmp46_;
						gpointer _tmp47_ = NULL;
						gchar* web_service;
						GeeHashMultiMap* _tmp48_;
						const gchar* _tmp49_;
						GeeCollection* _tmp50_ = NULL;
						GeeCollection* web_service_addresses;
						_tmp44_ = _web_service_it;
						_tmp45_ = gee_iterator_next (_tmp44_);
						if (!_tmp45_) {
							break;
						}
						_tmp46_ = _web_service_it;
						_tmp47_ = gee_iterator_get (_tmp46_);
						web_service = (gchar*) _tmp47_;
						_tmp48_ = self->priv->_web_service_addresses;
						_tmp49_ = web_service;
						_tmp50_ = gee_multi_map_get ((GeeMultiMap*) _tmp48_, _tmp49_);
						web_service_addresses = _tmp50_;
						{
							GeeCollection* _tmp51_;
							GeeIterator* _tmp52_ = NULL;
							GeeIterator* _ws_fd_it;
							_tmp51_ = web_service_addresses;
							_tmp52_ = gee_iterable_iterator ((GeeIterable*) _tmp51_);
							_ws_fd_it = _tmp52_;
							while (TRUE) {
								GeeIterator* _tmp53_;
								gboolean _tmp54_ = FALSE;
								GeeIterator* _tmp55_;
								gpointer _tmp56_ = NULL;
								FolksWebServiceFieldDetails* ws_fd;
								FolksPersonaLinkablePropertyCallback _tmp57_;
								void* _tmp57__target;
								const gchar* _tmp58_;
								gchar* _tmp59_;
								gchar* _tmp60_;
								FolksWebServiceFieldDetails* _tmp61_;
								gconstpointer _tmp62_;
								const gchar* _tmp63_;
								gchar* _tmp64_;
								gchar* _tmp65_;
								_tmp53_ = _ws_fd_it;
								_tmp54_ = gee_iterator_next (_tmp53_);
								if (!_tmp54_) {
									break;
								}
								_tmp55_ = _ws_fd_it;
								_tmp56_ = gee_iterator_get (_tmp55_);
								ws_fd = (FolksWebServiceFieldDetails*) _tmp56_;
								_tmp57_ = callback;
								_tmp57__target = callback_target;
								_tmp58_ = web_service;
								_tmp59_ = g_strconcat (_tmp58_, ":", NULL);
								_tmp60_ = _tmp59_;
								_tmp61_ = ws_fd;
								_tmp62_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp61_);
								_tmp63_ = _tmp62_;
								_tmp64_ = g_strconcat (_tmp60_, (const gchar*) _tmp63_, NULL);
								_tmp65_ = _tmp64_;
								_tmp57_ (_tmp65_, _tmp57__target);
								_g_free0 (_tmp65_);
								_g_free0 (_tmp60_);
								_g_object_unref0 (ws_fd);
							}
							_g_object_unref0 (_ws_fd_it);
						}
						_g_object_unref0 (web_service_addresses);
						_g_free0 (web_service);
					}
					_g_object_unref0 (_web_service_it);
				}
			} else {
				const gchar* _tmp66_;
				FolksPersonaLinkablePropertyCallback _tmp67_;
				void* _tmp67__target;
				_tmp66_ = prop_name;
				_tmp67_ = callback;
				_tmp67__target = callback_target;
				FOLKS_PERSONA_CLASS (edsf_persona_parent_class)->linkable_property_to_links (FOLKS_PERSONA (self), _tmp66_, _tmp67_, _tmp67__target);
			}
		}
	}
}


/**
   * Update attribs of the persona.
   */
void _edsf_persona_update (EdsfPersona* self, EContact* contact) {
	EContact* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (contact != NULL);
	_tmp0_ = contact;
	edsf_persona_set_contact (self, _tmp0_);
	_edsf_persona_update_names (self);
	_edsf_persona_update_avatar (self);
	_edsf_persona_update_urls (self);
	_edsf_persona_update_phones (self);
	_edsf_persona_update_addresses (self);
	_edsf_persona_update_emails (self);
	_edsf_persona_update_im_addresses (self);
	_edsf_persona_update_groups (self);
	_edsf_persona_update_notes (self);
	_edsf_persona_update_local_ids (self);
	_edsf_persona_update_web_services_addresses (self);
	_edsf_persona_update_gender (self);
}


static EVCardAttribute* _vala_EVCardAttribute_copy (EVCardAttribute* self) {
	return g_boxed_copy (e_vcard_attribute_get_type (), self);
}


static gpointer __vala_EVCardAttribute_copy0 (gpointer self) {
	return self ? _vala_EVCardAttribute_copy (self) : NULL;
}


static void _vala_EVCardAttribute_free (EVCardAttribute* self) {
	g_boxed_free (e_vcard_attribute_get_type (), self);
}


static void _edsf_persona_update_gender (EdsfPersona* self) {
	FolksGender gender;
	EContact* _tmp0_;
	EVCardAttribute* _tmp1_ = NULL;
	EVCardAttribute* _tmp2_;
	EVCardAttribute* gender_attr;
	EVCardAttribute* _tmp3_;
	FolksGender _tmp11_;
	FolksGender _tmp12_;
	g_return_if_fail (self != NULL);
	gender = FOLKS_GENDER_UNSPECIFIED;
	_tmp0_ = self->priv->_contact;
	_tmp1_ = e_vcard_get_attribute ((EVCard*) _tmp0_, EDSF_PERSONA_gender_attribute_name);
	_tmp2_ = __vala_EVCardAttribute_copy0 (_tmp1_);
	gender_attr = _tmp2_;
	_tmp3_ = gender_attr;
	if (_tmp3_ != NULL) {
		EVCardAttribute* _tmp4_;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		gchar* gender_str;
		const gchar* _tmp9_;
		_tmp4_ = gender_attr;
		_tmp5_ = e_vcard_attribute_get_value (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_utf8_strup (_tmp6_, (gssize) (-1));
		_tmp8_ = _tmp7_;
		_g_free0 (_tmp6_);
		gender_str = _tmp8_;
		_tmp9_ = gender_str;
		if (g_strcmp0 (_tmp9_, EDSF_PERSONA_gender_male) == 0) {
			gender = FOLKS_GENDER_MALE;
		} else {
			const gchar* _tmp10_;
			_tmp10_ = gender_str;
			if (g_strcmp0 (_tmp10_, EDSF_PERSONA_gender_female) == 0) {
				gender = FOLKS_GENDER_FEMALE;
			}
		}
		_g_free0 (gender_str);
	}
	_tmp11_ = self->priv->_gender;
	_tmp12_ = gender;
	if (_tmp11_ != _tmp12_) {
		FolksGender _tmp13_;
		_tmp13_ = gender;
		self->priv->_gender = _tmp13_;
		g_object_notify ((GObject*) self, "gender");
	}
	__vala_EVCardAttribute_free0 (gender_attr);
}


static EVCardAttributeParam* _vala_EVCardAttributeParam_copy (EVCardAttributeParam* self) {
	return g_boxed_copy (e_vcard_attribute_param_get_type (), self);
}


static gpointer __vala_EVCardAttributeParam_copy0 (gpointer self) {
	return self ? _vala_EVCardAttributeParam_copy (self) : NULL;
}


static void _vala_EVCardAttributeParam_free (EVCardAttributeParam* self) {
	g_boxed_free (e_vcard_attribute_param_get_type (), self);
}


static void _edsf_persona_update_web_services_addresses (EdsfPersona* self) {
	GeeHashMultiMap* _tmp0_;
	EContact* _tmp1_;
	EVCardAttribute* _tmp2_ = NULL;
	EVCardAttribute* _tmp3_;
	EVCardAttribute* services;
	EVCardAttribute* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_web_service_addresses;
	gee_multi_map_clear ((GeeMultiMap*) _tmp0_);
	_tmp1_ = self->priv->_contact;
	_tmp2_ = e_vcard_get_attribute ((EVCard*) _tmp1_, "X-FOLKS-WEB-SERVICES-IDS");
	_tmp3_ = __vala_EVCardAttribute_copy0 (_tmp2_);
	services = _tmp3_;
	_tmp4_ = services;
	if (_tmp4_ != NULL) {
		EVCardAttribute* _tmp5_;
		GList* _tmp6_ = NULL;
		_tmp5_ = services;
		_tmp6_ = e_vcard_attribute_get_params (_tmp5_);
		{
			GList* service_collection = NULL;
			GList* service_it = NULL;
			service_collection = _tmp6_;
			for (service_it = service_collection; service_it != NULL; service_it = service_it->next) {
				EVCardAttributeParam* _tmp7_;
				EVCardAttributeParam* service = NULL;
				_tmp7_ = __vala_EVCardAttributeParam_copy0 ((EVCardAttributeParam*) service_it->data);
				service = _tmp7_;
				{
					EVCardAttributeParam* _tmp8_;
					const gchar* _tmp9_ = NULL;
					gchar* _tmp10_ = NULL;
					gchar* service_name;
					EVCardAttributeParam* _tmp11_;
					GList* _tmp12_ = NULL;
					_tmp8_ = service;
					_tmp9_ = e_vcard_attribute_param_get_name (_tmp8_);
					_tmp10_ = g_utf8_strdown (_tmp9_, (gssize) (-1));
					service_name = _tmp10_;
					_tmp11_ = service;
					_tmp12_ = e_vcard_attribute_param_get_values (_tmp11_);
					{
						GList* service_id_collection = NULL;
						GList* service_id_it = NULL;
						service_id_collection = _tmp12_;
						for (service_id_it = service_id_collection; service_id_it != NULL; service_id_it = service_id_it->next) {
							gchar* _tmp13_;
							gchar* service_id = NULL;
							_tmp13_ = g_strdup ((const gchar*) service_id_it->data);
							service_id = _tmp13_;
							{
								GeeHashMultiMap* _tmp14_;
								const gchar* _tmp15_;
								const gchar* _tmp16_;
								FolksWebServiceFieldDetails* _tmp17_;
								FolksWebServiceFieldDetails* _tmp18_;
								_tmp14_ = self->priv->_web_service_addresses;
								_tmp15_ = service_name;
								_tmp16_ = service_id;
								_tmp17_ = folks_web_service_field_details_new (_tmp16_, NULL);
								_tmp18_ = _tmp17_;
								gee_multi_map_set ((GeeMultiMap*) _tmp14_, _tmp15_, _tmp18_);
								_g_object_unref0 (_tmp18_);
								_g_free0 (service_id);
							}
						}
					}
					_g_free0 (service_name);
					__vala_EVCardAttributeParam_free0 (service);
				}
			}
		}
	}
	g_object_notify ((GObject*) self, "web-service-addresses");
	__vala_EVCardAttribute_free0 (services);
}


static void __vala_EVCardAttribute_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (_vala_EVCardAttribute_free (var), NULL));
}


static void _g_list_free___vala_EVCardAttribute_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) __vala_EVCardAttribute_free0_, NULL);
	g_list_free (self);
}


static void _edsf_persona_update_emails (EdsfPersona* self) {
	GeeHashSet* _tmp0_;
	EContact* _tmp1_;
	GList* _tmp2_ = NULL;
	GList* attrs;
	GList* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_email_addresses;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
	_tmp1_ = self->priv->_contact;
	_tmp2_ = e_contact_get_attributes (_tmp1_, E_CONTACT_EMAIL);
	attrs = _tmp2_;
	_tmp3_ = attrs;
	{
		GList* attr_collection = NULL;
		GList* attr_it = NULL;
		attr_collection = _tmp3_;
		for (attr_it = attr_collection; attr_it != NULL; attr_it = attr_it->next) {
			EVCardAttribute* _tmp4_;
			EVCardAttribute* attr = NULL;
			_tmp4_ = __vala_EVCardAttribute_copy0 ((EVCardAttribute*) attr_it->data);
			attr = _tmp4_;
			{
				EVCardAttribute* _tmp5_;
				gchar* _tmp6_ = NULL;
				gchar* _tmp7_;
				FolksEmailFieldDetails* _tmp8_;
				FolksEmailFieldDetails* _tmp9_;
				FolksEmailFieldDetails* email_fd;
				EVCardAttribute* _tmp10_;
				GList* _tmp11_ = NULL;
				GeeHashSet* _tmp22_;
				FolksEmailFieldDetails* _tmp23_;
				_tmp5_ = attr;
				_tmp6_ = e_vcard_attribute_get_value (_tmp5_);
				_tmp7_ = _tmp6_;
				_tmp8_ = folks_email_field_details_new (_tmp7_, NULL);
				_tmp9_ = _tmp8_;
				_g_free0 (_tmp7_);
				email_fd = _tmp9_;
				_tmp10_ = attr;
				_tmp11_ = e_vcard_attribute_get_params (_tmp10_);
				{
					GList* param_collection = NULL;
					GList* param_it = NULL;
					param_collection = _tmp11_;
					for (param_it = param_collection; param_it != NULL; param_it = param_it->next) {
						EVCardAttributeParam* _tmp12_;
						EVCardAttributeParam* param = NULL;
						_tmp12_ = __vala_EVCardAttributeParam_copy0 ((EVCardAttributeParam*) param_it->data);
						param = _tmp12_;
						{
							EVCardAttributeParam* _tmp13_;
							const gchar* _tmp14_ = NULL;
							gchar* _tmp15_ = NULL;
							gchar* param_name;
							EVCardAttributeParam* _tmp16_;
							GList* _tmp17_ = NULL;
							_tmp13_ = param;
							_tmp14_ = e_vcard_attribute_param_get_name (_tmp13_);
							_tmp15_ = g_utf8_strdown (_tmp14_, (gssize) (-1));
							param_name = _tmp15_;
							_tmp16_ = param;
							_tmp17_ = e_vcard_attribute_param_get_values (_tmp16_);
							{
								GList* param_value_collection = NULL;
								GList* param_value_it = NULL;
								param_value_collection = _tmp17_;
								for (param_value_it = param_value_collection; param_value_it != NULL; param_value_it = param_value_it->next) {
									gchar* _tmp18_;
									gchar* param_value = NULL;
									_tmp18_ = g_strdup ((const gchar*) param_value_it->data);
									param_value = _tmp18_;
									{
										FolksEmailFieldDetails* _tmp19_;
										const gchar* _tmp20_;
										const gchar* _tmp21_;
										_tmp19_ = email_fd;
										_tmp20_ = param_name;
										_tmp21_ = param_value;
										folks_abstract_field_details_add_parameter ((FolksAbstractFieldDetails*) _tmp19_, _tmp20_, _tmp21_);
										_g_free0 (param_value);
									}
								}
							}
							_g_free0 (param_name);
							__vala_EVCardAttributeParam_free0 (param);
						}
					}
				}
				_tmp22_ = self->priv->_email_addresses;
				_tmp23_ = email_fd;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp22_, _tmp23_);
				_g_object_unref0 (email_fd);
				__vala_EVCardAttribute_free0 (attr);
			}
		}
	}
	g_object_notify ((GObject*) self, "email-addresses");
	__g_list_free___vala_EVCardAttribute_free0_0 (attrs);
}


static void _edsf_persona_update_notes (EdsfPersona* self) {
	GeeHashSet* _tmp0_;
	void* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* n;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_;
	gboolean _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_notes;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
	_tmp1_ = _edsf_persona_get_property (self, "note");
	_tmp2_ = g_strdup ((const gchar*) _tmp1_);
	n = _tmp2_;
	_tmp4_ = n;
	if (_tmp4_ != NULL) {
		const gchar* _tmp5_;
		_tmp5_ = n;
		_tmp3_ = g_strcmp0 (_tmp5_, "") != 0;
	} else {
		_tmp3_ = FALSE;
	}
	_tmp6_ = _tmp3_;
	if (_tmp6_) {
		const gchar* _tmp7_;
		FolksNoteFieldDetails* _tmp8_;
		FolksNoteFieldDetails* note;
		GeeHashSet* _tmp9_;
		FolksNoteFieldDetails* _tmp10_;
		_tmp7_ = n;
		_tmp8_ = folks_note_field_details_new (_tmp7_, NULL, NULL);
		note = _tmp8_;
		_tmp9_ = self->priv->_notes;
		_tmp10_ = note;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp9_, _tmp10_);
		_g_object_unref0 (note);
	}
	g_object_notify ((GObject*) self, "notes");
	_g_free0 (n);
}


static EContactName* _vala_EContactName_copy (EContactName* self) {
	return g_boxed_copy (e_contact_name_get_type (), self);
}


static gpointer __vala_EContactName_copy0 (gpointer self) {
	return self ? _vala_EContactName_copy (self) : NULL;
}


static void _vala_EContactName_free (EContactName* self) {
	g_boxed_free (e_contact_name_get_type (), self);
}


static void _edsf_persona_update_names (EdsfPersona* self) {
	void* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* full_name;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	void* _tmp6_ = NULL;
	gchar* _tmp7_;
	gchar* nickname;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	FolksStructuredName* structured_name;
	void* _tmp13_ = NULL;
	EContactName* _tmp14_;
	EContactName* cn;
	EContactName* _tmp15_;
	gboolean _tmp37_ = FALSE;
	FolksStructuredName* _tmp38_;
	gboolean _tmp41_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _edsf_persona_get_property (self, "full_name");
	_tmp1_ = g_strdup ((const gchar*) _tmp0_);
	full_name = _tmp1_;
	_tmp2_ = self->priv->_full_name;
	_tmp3_ = full_name;
	if (g_strcmp0 (_tmp2_, _tmp3_) != 0) {
		const gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = full_name;
		_tmp5_ = g_strdup (_tmp4_);
		_g_free0 (self->priv->_full_name);
		self->priv->_full_name = _tmp5_;
		g_object_notify ((GObject*) self, "full-name");
	}
	_tmp6_ = _edsf_persona_get_property (self, "nickname");
	_tmp7_ = g_strdup ((const gchar*) _tmp6_);
	nickname = _tmp7_;
	_tmp8_ = folks_name_details_get_nickname ((FolksNameDetails*) self);
	_tmp9_ = _tmp8_;
	_tmp10_ = nickname;
	if (g_strcmp0 (_tmp9_, _tmp10_) != 0) {
		const gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp11_ = nickname;
		_tmp12_ = g_strdup (_tmp11_);
		_g_free0 (self->priv->_nickname);
		self->priv->_nickname = _tmp12_;
		g_object_notify ((GObject*) self, "nickname");
	}
	structured_name = NULL;
	_tmp13_ = _edsf_persona_get_property (self, "name");
	_tmp14_ = __vala_EContactName_copy0 ((EContactName*) _tmp13_);
	cn = _tmp14_;
	_tmp15_ = cn;
	if (_tmp15_ != NULL) {
		EContactName* _tmp16_;
		const gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* family_name;
		EContactName* _tmp19_;
		const gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* given_name;
		EContactName* _tmp22_;
		const gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* additional_names;
		EContactName* _tmp25_;
		const gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* prefixes;
		EContactName* _tmp28_;
		const gchar* _tmp29_;
		gchar* _tmp30_;
		gchar* suffixes;
		const gchar* _tmp31_;
		const gchar* _tmp32_;
		const gchar* _tmp33_;
		const gchar* _tmp34_;
		const gchar* _tmp35_;
		FolksStructuredName* _tmp36_;
		_tmp16_ = cn;
		_tmp17_ = _tmp16_->family;
		_tmp18_ = g_strdup (_tmp17_);
		family_name = _tmp18_;
		_tmp19_ = cn;
		_tmp20_ = _tmp19_->given;
		_tmp21_ = g_strdup (_tmp20_);
		given_name = _tmp21_;
		_tmp22_ = cn;
		_tmp23_ = _tmp22_->additional;
		_tmp24_ = g_strdup (_tmp23_);
		additional_names = _tmp24_;
		_tmp25_ = cn;
		_tmp26_ = _tmp25_->prefixes;
		_tmp27_ = g_strdup (_tmp26_);
		prefixes = _tmp27_;
		_tmp28_ = cn;
		_tmp29_ = _tmp28_->suffixes;
		_tmp30_ = g_strdup (_tmp29_);
		suffixes = _tmp30_;
		_tmp31_ = family_name;
		_tmp32_ = given_name;
		_tmp33_ = additional_names;
		_tmp34_ = prefixes;
		_tmp35_ = suffixes;
		_tmp36_ = folks_structured_name_new (_tmp31_, _tmp32_, _tmp33_, _tmp34_, _tmp35_);
		_g_object_unref0 (structured_name);
		structured_name = _tmp36_;
		_g_free0 (suffixes);
		_g_free0 (prefixes);
		_g_free0 (additional_names);
		_g_free0 (given_name);
		_g_free0 (family_name);
	}
	_tmp38_ = structured_name;
	if (_tmp38_ != NULL) {
		FolksStructuredName* _tmp39_;
		gboolean _tmp40_ = FALSE;
		_tmp39_ = structured_name;
		_tmp40_ = folks_structured_name_is_empty (_tmp39_);
		_tmp37_ = !_tmp40_;
	} else {
		_tmp37_ = FALSE;
	}
	_tmp41_ = _tmp37_;
	if (_tmp41_) {
		FolksStructuredName* _tmp42_;
		FolksStructuredName* _tmp43_;
		_tmp42_ = structured_name;
		_tmp43_ = _g_object_ref0 (_tmp42_);
		_g_object_unref0 (self->priv->_structured_name);
		self->priv->_structured_name = _tmp43_;
		g_object_notify ((GObject*) self, "structured-name");
	} else {
		FolksStructuredName* _tmp44_;
		_tmp44_ = self->priv->_structured_name;
		if (_tmp44_ != NULL) {
			_g_object_unref0 (self->priv->_structured_name);
			self->priv->_structured_name = NULL;
			g_object_notify ((GObject*) self, "structured-name");
		}
	}
	__vala_EContactName_free0 (cn);
	_g_object_unref0 (structured_name);
	_g_free0 (nickname);
	_g_free0 (full_name);
}


static GLoadableIcon* _edsf_persona_contact_photo_to_loadable_icon (EdsfPersona* self, EContactPhoto* p) {
	GLoadableIcon* result = NULL;
	EContactPhoto* _tmp0_;
	EContactPhoto* _tmp1_;
	EContactPhotoType _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = p;
	if (_tmp0_ == NULL) {
		result = NULL;
		return result;
	}
	_tmp1_ = p;
	_tmp2_ = _tmp1_->type;
	switch (_tmp2_) {
		case E_CONTACT_PHOTO_TYPE_URI:
		{
			EContactPhoto* _tmp3_;
			const gchar* _tmp4_ = NULL;
			EContactPhoto* _tmp5_;
			const gchar* _tmp6_ = NULL;
			GFile* _tmp7_ = NULL;
			GFile* _tmp8_;
			GFileIcon* _tmp9_;
			GLoadableIcon* _tmp10_;
			_tmp3_ = p;
			_tmp4_ = e_contact_photo_get_uri (_tmp3_);
			if (_tmp4_ == NULL) {
				result = NULL;
				return result;
			}
			_tmp5_ = p;
			_tmp6_ = e_contact_photo_get_uri (_tmp5_);
			_tmp7_ = g_file_new_for_uri (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = (GFileIcon*) g_file_icon_new (_tmp8_);
			_tmp10_ = (GLoadableIcon*) _tmp9_;
			_g_object_unref0 (_tmp8_);
			result = _tmp10_;
			return result;
		}
		case E_CONTACT_PHOTO_TYPE_INLINED:
		{
			gboolean _tmp11_ = FALSE;
			EContactPhoto* _tmp12_;
			const gchar* _tmp13_ = NULL;
			gboolean _tmp17_;
			EContactPhoto* _tmp18_;
			const gchar* _tmp19_ = NULL;
			EContactPhoto* _tmp20_;
			gsize _tmp21_;
			guint8* _tmp22_ = NULL;
			EdsfMemoryIcon* _tmp23_;
			_tmp12_ = p;
			_tmp13_ = e_contact_photo_get_mime_type (_tmp12_);
			if (_tmp13_ == NULL) {
				_tmp11_ = TRUE;
			} else {
				EContactPhoto* _tmp14_;
				gsize _tmp15_;
				guint8* _tmp16_ = NULL;
				_tmp14_ = p;
				_tmp16_ = e_contact_photo_get_inlined (_tmp14_, &_tmp15_);
				_tmp11_ = _tmp16_ == NULL;
			}
			_tmp17_ = _tmp11_;
			if (_tmp17_) {
				result = NULL;
				return result;
			}
			_tmp18_ = p;
			_tmp19_ = e_contact_photo_get_mime_type (_tmp18_);
			_tmp20_ = p;
			_tmp22_ = e_contact_photo_get_inlined (_tmp20_, &_tmp21_);
			_tmp23_ = edsf_memory_icon_new (_tmp19_, _tmp22_, _tmp21_);
			result = (GLoadableIcon*) _tmp23_;
			return result;
		}
		default:
		{
			result = NULL;
			return result;
		}
	}
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (Block1Data* _data1_) {
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_object_unref0 (_data1_->self);
		_g_object_unref0 (_data1_->new_avatar);
		_g_object_unref0 (_data1_->cache);
		g_slice_free (Block1Data, _data1_);
	}
}


static EContactPhoto* _vala_EContactPhoto_copy (EContactPhoto* self) {
	return g_boxed_copy (e_contact_photo_get_type (), self);
}


static gpointer __vala_EContactPhoto_copy0 (gpointer self) {
	return self ? _vala_EContactPhoto_copy (self) : NULL;
}


static void _vala_EContactPhoto_free (EContactPhoto* self) {
	g_boxed_free (e_contact_photo_get_type (), self);
}


static void _lambda0_ (GObject* obj, GAsyncResult* res, Block1Data* _data1_) {
	EdsfPersona * self;
	GLoadableIcon* _tmp2_;
	GLoadableIcon* _tmp3_;
	GError * _inner_error_ = NULL;
	self = _data1_->self;
	g_return_if_fail (res != NULL);
	{
		FolksAvatarCache* _tmp0_;
		GAsyncResult* _tmp1_;
		_tmp0_ = _data1_->cache;
		_tmp1_ = res;
		folks_avatar_cache_remove_avatar_finish (_tmp0_, _tmp1_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e1 = NULL;
		e1 = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e1);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp2_ = _data1_->new_avatar;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->priv->_avatar);
	self->priv->_avatar = _tmp3_;
	g_object_notify ((GObject*) self, "avatar");
}


static void __lambda0__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	_lambda0_ (source_object, res, self);
	block1_data_unref (self);
}


static void _lambda1_ (GObject* obj, GAsyncResult* res, Block1Data* _data1_) {
	EdsfPersona * self;
	GLoadableIcon* _tmp8_;
	GLoadableIcon* _tmp9_;
	GError * _inner_error_ = NULL;
	self = _data1_->self;
	g_return_if_fail (res != NULL);
	{
		FolksAvatarCache* _tmp0_;
		GAsyncResult* _tmp1_;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		_tmp0_ = _data1_->cache;
		_tmp1_ = res;
		_tmp2_ = folks_avatar_cache_store_avatar_finish (_tmp0_, _tmp1_, &_inner_error_);
		_tmp3_ = _tmp2_;
		_g_free0 (_tmp3_);
		if (_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e2 = NULL;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		GError* _tmp6_;
		const gchar* _tmp7_;
		e2 = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = folks_persona_get_uid ((FolksPersona*) self);
		_tmp5_ = _tmp4_;
		_tmp6_ = e2;
		_tmp7_ = _tmp6_->message;
		g_warning ("edsf-persona.vala:791: Couldn't cache avatar for Edsf.Persona '%s': %s", _tmp5_, _tmp7_);
		_g_object_unref0 (_data1_->new_avatar);
		_data1_->new_avatar = NULL;
		_g_error_free0 (e2);
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp8_ = _data1_->new_avatar;
	_tmp9_ = _g_object_ref0 (_tmp8_);
	_g_object_unref0 (self->priv->_avatar);
	self->priv->_avatar = _tmp9_;
	g_object_notify ((GObject*) self, "avatar");
}


static void __lambda1__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	_lambda1_ (source_object, res, self);
	block1_data_unref (self);
}


static void _edsf_persona_update_avatar (EdsfPersona* self) {
	Block1Data* _data1_;
	void* _tmp0_ = NULL;
	EContactPhoto* _tmp1_;
	EContactPhoto* p;
	FolksAvatarCache* _tmp2_ = NULL;
	FolksAvatarCache* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* cache_uri;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	EContactPhoto* _tmp9_;
	gboolean _tmp12_;
	gboolean _tmp16_;
	EContactPhoto* _tmp17_;
	GLoadableIcon* _tmp18_ = NULL;
	gboolean _tmp19_ = FALSE;
	GLoadableIcon* _tmp20_;
	gboolean _tmp22_;
	g_return_if_fail (self != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = _edsf_persona_get_property (self, "photo");
	_tmp1_ = __vala_EContactPhoto_copy0 ((EContactPhoto*) _tmp0_);
	p = _tmp1_;
	_tmp2_ = folks_avatar_cache_dup ();
	_data1_->cache = _tmp2_;
	_tmp3_ = _data1_->cache;
	_tmp4_ = folks_persona_get_uid ((FolksPersona*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = folks_avatar_cache_build_uri_for_avatar (_tmp3_, _tmp5_);
	cache_uri = _tmp6_;
	_tmp9_ = p;
	if (_tmp9_ != NULL) {
		EContactPhoto* _tmp10_;
		EContactPhotoType _tmp11_;
		_tmp10_ = p;
		_tmp11_ = _tmp10_->type;
		_tmp8_ = _tmp11_ == E_CONTACT_PHOTO_TYPE_URI;
	} else {
		_tmp8_ = FALSE;
	}
	_tmp12_ = _tmp8_;
	if (_tmp12_) {
		EContactPhoto* _tmp13_;
		const gchar* _tmp14_ = NULL;
		const gchar* _tmp15_;
		_tmp13_ = p;
		_tmp14_ = e_contact_photo_get_uri (_tmp13_);
		_tmp15_ = cache_uri;
		_tmp7_ = g_strcmp0 (_tmp14_, _tmp15_) == 0;
	} else {
		_tmp7_ = FALSE;
	}
	_tmp16_ = _tmp7_;
	if (_tmp16_) {
		g_object_notify ((GObject*) self, "avatar");
		_g_free0 (cache_uri);
		__vala_EContactPhoto_free0 (p);
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return;
	}
	_tmp17_ = p;
	_tmp18_ = _edsf_persona_contact_photo_to_loadable_icon (self, _tmp17_);
	_data1_->new_avatar = _tmp18_;
	_tmp20_ = self->priv->_avatar;
	if (_tmp20_ != NULL) {
		GLoadableIcon* _tmp21_;
		_tmp21_ = _data1_->new_avatar;
		_tmp19_ = _tmp21_ == NULL;
	} else {
		_tmp19_ = FALSE;
	}
	_tmp22_ = _tmp19_;
	if (_tmp22_) {
		FolksAvatarCache* _tmp23_;
		const gchar* _tmp24_;
		const gchar* _tmp25_;
		_tmp23_ = _data1_->cache;
		_tmp24_ = folks_persona_get_uid ((FolksPersona*) self);
		_tmp25_ = _tmp24_;
		folks_avatar_cache_remove_avatar (_tmp23_, _tmp25_, __lambda0__gasync_ready_callback, block1_data_ref (_data1_));
	} else {
		gboolean _tmp26_ = FALSE;
		gboolean _tmp27_ = FALSE;
		GLoadableIcon* _tmp28_;
		GLoadableIcon* _tmp29_;
		gboolean _tmp31_;
		gboolean _tmp42_;
		_tmp28_ = folks_avatar_details_get_avatar ((FolksAvatarDetails*) self);
		_tmp29_ = _tmp28_;
		if (_tmp29_ == NULL) {
			GLoadableIcon* _tmp30_;
			_tmp30_ = _data1_->new_avatar;
			_tmp27_ = _tmp30_ != NULL;
		} else {
			_tmp27_ = FALSE;
		}
		_tmp31_ = _tmp27_;
		if (_tmp31_) {
			_tmp26_ = TRUE;
		} else {
			gboolean _tmp32_ = FALSE;
			gboolean _tmp33_ = FALSE;
			GLoadableIcon* _tmp34_;
			GLoadableIcon* _tmp35_;
			gboolean _tmp37_;
			gboolean _tmp41_;
			_tmp34_ = folks_avatar_details_get_avatar ((FolksAvatarDetails*) self);
			_tmp35_ = _tmp34_;
			if (_tmp35_ != NULL) {
				GLoadableIcon* _tmp36_;
				_tmp36_ = _data1_->new_avatar;
				_tmp33_ = _tmp36_ != NULL;
			} else {
				_tmp33_ = FALSE;
			}
			_tmp37_ = _tmp33_;
			if (_tmp37_) {
				GLoadableIcon* _tmp38_;
				GLoadableIcon* _tmp39_;
				gboolean _tmp40_ = FALSE;
				_tmp38_ = self->priv->_avatar;
				_tmp39_ = _data1_->new_avatar;
				_tmp40_ = g_icon_equal ((GIcon*) _tmp38_, (GIcon*) _tmp39_);
				_tmp32_ = _tmp40_ == FALSE;
			} else {
				_tmp32_ = FALSE;
			}
			_tmp41_ = _tmp32_;
			_tmp26_ = _tmp41_;
		}
		_tmp42_ = _tmp26_;
		if (_tmp42_) {
			FolksAvatarCache* _tmp43_;
			const gchar* _tmp44_;
			const gchar* _tmp45_;
			GLoadableIcon* _tmp46_;
			_tmp43_ = _data1_->cache;
			_tmp44_ = folks_persona_get_uid ((FolksPersona*) self);
			_tmp45_ = _tmp44_;
			_tmp46_ = _data1_->new_avatar;
			folks_avatar_cache_store_avatar (_tmp43_, _tmp45_, _tmp46_, __lambda1__gasync_ready_callback, block1_data_ref (_data1_));
		}
	}
	_g_free0 (cache_uri);
	__vala_EContactPhoto_free0 (p);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}


static void _edsf_persona_update_urls (EdsfPersona* self) {
	GeeHashSet* _tmp0_;
	GeeHashSet* _tmp1_;
	GeeHashSet* urls_temp;
	EContact* _tmp16_;
	EVCard* _tmp17_;
	EVCard* vcard;
	EVCard* _tmp18_;
	GList* _tmp19_ = NULL;
	GeeHashSet* _tmp41_;
	GeeHashSet* _tmp42_;
	gboolean _tmp43_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_urls;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
	_tmp1_ = gee_hash_set_new (FOLKS_TYPE_URL_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
	urls_temp = _tmp1_;
	{
		const gchar** url_property_collection = NULL;
		gint url_property_collection_length1 = 0;
		gint _url_property_collection_size_ = 0;
		gint url_property_it = 0;
		url_property_collection = EDSF_PERSONA_url_properties;
		url_property_collection_length1 = G_N_ELEMENTS (EDSF_PERSONA_url_properties);
		for (url_property_it = 0; url_property_it < G_N_ELEMENTS (EDSF_PERSONA_url_properties); url_property_it = url_property_it + 1) {
			gchar* _tmp2_;
			gchar* url_property = NULL;
			_tmp2_ = g_strdup (url_property_collection[url_property_it]);
			url_property = _tmp2_;
			{
				const gchar* _tmp3_;
				void* _tmp4_ = NULL;
				gchar* _tmp5_;
				gchar* u;
				gboolean _tmp6_ = FALSE;
				const gchar* _tmp7_;
				gboolean _tmp9_;
				_tmp3_ = url_property;
				_tmp4_ = _edsf_persona_get_property (self, _tmp3_);
				_tmp5_ = g_strdup ((const gchar*) _tmp4_);
				u = _tmp5_;
				_tmp7_ = u;
				if (_tmp7_ != NULL) {
					const gchar* _tmp8_;
					_tmp8_ = u;
					_tmp6_ = g_strcmp0 (_tmp8_, "") != 0;
				} else {
					_tmp6_ = FALSE;
				}
				_tmp9_ = _tmp6_;
				if (_tmp9_) {
					const gchar* _tmp10_;
					FolksUrlFieldDetails* _tmp11_;
					FolksUrlFieldDetails* fd_u;
					FolksUrlFieldDetails* _tmp12_;
					const gchar* _tmp13_;
					GeeHashSet* _tmp14_;
					FolksUrlFieldDetails* _tmp15_;
					_tmp10_ = u;
					_tmp11_ = folks_url_field_details_new (_tmp10_, NULL);
					fd_u = _tmp11_;
					_tmp12_ = fd_u;
					_tmp13_ = url_property;
					folks_abstract_field_details_set_parameter ((FolksAbstractFieldDetails*) _tmp12_, "type", _tmp13_);
					_tmp14_ = urls_temp;
					_tmp15_ = fd_u;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp14_, _tmp15_);
					_g_object_unref0 (fd_u);
				}
				_g_free0 (u);
				_g_free0 (url_property);
			}
		}
	}
	_tmp16_ = self->priv->_contact;
	_tmp17_ = _g_object_ref0 (E_VCARD (_tmp16_));
	vcard = _tmp17_;
	_tmp18_ = vcard;
	_tmp19_ = e_vcard_get_attributes (_tmp18_);
	{
		GList* attr_collection = NULL;
		GList* attr_it = NULL;
		attr_collection = _tmp19_;
		for (attr_it = attr_collection; attr_it != NULL; attr_it = attr_it->next) {
			EVCardAttribute* attr = NULL;
			attr = (EVCardAttribute*) attr_it->data;
			{
				EVCardAttribute* _tmp20_;
				const gchar* _tmp21_ = NULL;
				_tmp20_ = attr;
				_tmp21_ = e_vcard_attribute_get_name (_tmp20_);
				if (g_strcmp0 (_tmp21_, "X-URIS") == 0) {
					EVCardAttribute* _tmp22_;
					gchar* _tmp23_ = NULL;
					gchar* _tmp24_;
					FolksUrlFieldDetails* _tmp25_;
					FolksUrlFieldDetails* _tmp26_;
					FolksUrlFieldDetails* url_fd;
					EVCardAttribute* _tmp27_;
					GList* _tmp28_ = NULL;
					GeeHashSet* _tmp39_;
					FolksUrlFieldDetails* _tmp40_;
					_tmp22_ = attr;
					_tmp23_ = e_vcard_attribute_get_value (_tmp22_);
					_tmp24_ = _tmp23_;
					_tmp25_ = folks_url_field_details_new (_tmp24_, NULL);
					_tmp26_ = _tmp25_;
					_g_free0 (_tmp24_);
					url_fd = _tmp26_;
					_tmp27_ = attr;
					_tmp28_ = e_vcard_attribute_get_params (_tmp27_);
					{
						GList* param_collection = NULL;
						GList* param_it = NULL;
						param_collection = _tmp28_;
						for (param_it = param_collection; param_it != NULL; param_it = param_it->next) {
							EVCardAttributeParam* _tmp29_;
							EVCardAttributeParam* param = NULL;
							_tmp29_ = __vala_EVCardAttributeParam_copy0 ((EVCardAttributeParam*) param_it->data);
							param = _tmp29_;
							{
								EVCardAttributeParam* _tmp30_;
								const gchar* _tmp31_ = NULL;
								gchar* _tmp32_ = NULL;
								gchar* param_name;
								EVCardAttributeParam* _tmp33_;
								GList* _tmp34_ = NULL;
								_tmp30_ = param;
								_tmp31_ = e_vcard_attribute_param_get_name (_tmp30_);
								_tmp32_ = g_utf8_strdown (_tmp31_, (gssize) (-1));
								param_name = _tmp32_;
								_tmp33_ = param;
								_tmp34_ = e_vcard_attribute_param_get_values (_tmp33_);
								{
									GList* param_value_collection = NULL;
									GList* param_value_it = NULL;
									param_value_collection = _tmp34_;
									for (param_value_it = param_value_collection; param_value_it != NULL; param_value_it = param_value_it->next) {
										gchar* _tmp35_;
										gchar* param_value = NULL;
										_tmp35_ = g_strdup ((const gchar*) param_value_it->data);
										param_value = _tmp35_;
										{
											FolksUrlFieldDetails* _tmp36_;
											const gchar* _tmp37_;
											const gchar* _tmp38_;
											_tmp36_ = url_fd;
											_tmp37_ = param_name;
											_tmp38_ = param_value;
											folks_abstract_field_details_add_parameter ((FolksAbstractFieldDetails*) _tmp36_, _tmp37_, _tmp38_);
											_g_free0 (param_value);
										}
									}
								}
								_g_free0 (param_name);
								__vala_EVCardAttributeParam_free0 (param);
							}
						}
					}
					_tmp39_ = urls_temp;
					_tmp40_ = url_fd;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp39_, _tmp40_);
					_g_object_unref0 (url_fd);
				}
			}
		}
	}
	_tmp41_ = urls_temp;
	_tmp42_ = self->priv->_urls;
	_tmp43_ = folks_utils_set_afd_equal ((GeeSet*) _tmp41_, (GeeSet*) _tmp42_);
	if (!_tmp43_) {
		GeeHashSet* _tmp44_;
		_tmp44_ = self->priv->_urls;
		gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp44_);
		{
			GeeHashSet* _tmp45_;
			GeeIterator* _tmp46_ = NULL;
			GeeIterator* _url_fd_it;
			_tmp45_ = urls_temp;
			_tmp46_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp45_);
			_url_fd_it = _tmp46_;
			while (TRUE) {
				GeeIterator* _tmp47_;
				gboolean _tmp48_ = FALSE;
				GeeIterator* _tmp49_;
				gpointer _tmp50_ = NULL;
				FolksUrlFieldDetails* url_fd;
				GeeHashSet* _tmp51_;
				FolksUrlFieldDetails* _tmp52_;
				_tmp47_ = _url_fd_it;
				_tmp48_ = gee_iterator_next (_tmp47_);
				if (!_tmp48_) {
					break;
				}
				_tmp49_ = _url_fd_it;
				_tmp50_ = gee_iterator_get (_tmp49_);
				url_fd = (FolksUrlFieldDetails*) _tmp50_;
				_tmp51_ = self->priv->_urls;
				_tmp52_ = url_fd;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp51_, _tmp52_);
				_g_object_unref0 (url_fd);
			}
			_g_object_unref0 (_url_fd_it);
		}
		g_object_notify ((GObject*) self, "urls");
	}
	_g_object_unref0 (vcard);
	_g_object_unref0 (urls_temp);
}


static void _edsf_persona_update_im_addresses (EdsfPersona* self) {
	GHashTable* _tmp0_ = NULL;
	GHashTable* im_eds_map;
	GeeHashMultiMap* _tmp1_;
	GHashTable* _tmp2_;
	GList* _tmp3_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = _edsf_persona_get_im_eds_map ();
	im_eds_map = _tmp0_;
	_tmp1_ = self->priv->_im_addresses;
	gee_multi_map_clear ((GeeMultiMap*) _tmp1_);
	_tmp2_ = im_eds_map;
	_tmp3_ = g_hash_table_get_keys (_tmp2_);
	{
		GList* im_proto_collection = NULL;
		GList* im_proto_it = NULL;
		im_proto_collection = _tmp3_;
		for (im_proto_it = im_proto_collection; im_proto_it != NULL; im_proto_it = im_proto_it->next) {
			const gchar* im_proto = NULL;
			im_proto = (const gchar*) im_proto_it->data;
			{
				EContact* _tmp4_;
				GHashTable* _tmp5_;
				const gchar* _tmp6_;
				gconstpointer _tmp7_ = NULL;
				GList* _tmp8_ = NULL;
				GList* addresses;
				GList* _tmp9_;
				_tmp4_ = self->priv->_contact;
				_tmp5_ = im_eds_map;
				_tmp6_ = im_proto;
				_tmp7_ = g_hash_table_lookup (_tmp5_, _tmp6_);
				_tmp8_ = e_contact_get_attributes (_tmp4_, GPOINTER_TO_INT (_tmp7_));
				addresses = _tmp8_;
				_tmp9_ = addresses;
				{
					GList* attr_collection = NULL;
					GList* attr_it = NULL;
					attr_collection = _tmp9_;
					for (attr_it = attr_collection; attr_it != NULL; attr_it = attr_it->next) {
						EVCardAttribute* _tmp10_;
						EVCardAttribute* attr = NULL;
						_tmp10_ = __vala_EVCardAttribute_copy0 ((EVCardAttribute*) attr_it->data);
						attr = _tmp10_;
						{
							{
								EVCardAttribute* _tmp11_;
								gchar* _tmp12_ = NULL;
								gchar* addr;
								const gchar* _tmp13_;
								const gchar* _tmp14_;
								gchar* _tmp15_ = NULL;
								gchar* _tmp16_;
								const gchar* _tmp17_;
								gchar* _tmp18_;
								gchar* _tmp19_;
								gchar* _tmp20_;
								gchar* normalised_addr;
								const gchar* _tmp21_;
								FolksImFieldDetails* _tmp22_;
								FolksImFieldDetails* im_fd;
								GeeHashMultiMap* _tmp23_;
								const gchar* _tmp24_;
								FolksImFieldDetails* _tmp25_;
								_tmp11_ = attr;
								_tmp12_ = e_vcard_attribute_get_value (_tmp11_);
								addr = _tmp12_;
								_tmp13_ = addr;
								_tmp14_ = im_proto;
								_tmp15_ = folks_im_details_normalise_im_address (_tmp13_, _tmp14_, &_inner_error_);
								_tmp16_ = _tmp15_;
								if (_inner_error_ != NULL) {
									_g_free0 (addr);
									if (_inner_error_->domain == FOLKS_IM_DETAILS_ERROR) {
										goto __catch2_folks_im_details_error;
									}
									_g_free0 (addr);
									__vala_EVCardAttribute_free0 (attr);
									__g_list_free___vala_EVCardAttribute_free0_0 (addresses);
									_g_list_free0 (im_proto_collection);
									_g_hash_table_unref0 (im_eds_map);
									g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return;
								}
								_tmp17_ = _tmp16_;
								_tmp18_ = _tmp17_;
								_tmp19_ = _tmp18_;
								_tmp18_ = NULL;
								_tmp20_ = _tmp19_;
								_g_free0 (_tmp18_);
								normalised_addr = _tmp20_;
								_tmp21_ = normalised_addr;
								_tmp22_ = folks_im_field_details_new (_tmp21_, NULL);
								im_fd = _tmp22_;
								_tmp23_ = self->priv->_im_addresses;
								_tmp24_ = im_proto;
								_tmp25_ = im_fd;
								gee_multi_map_set ((GeeMultiMap*) _tmp23_, _tmp24_, _tmp25_);
								_g_object_unref0 (im_fd);
								_g_free0 (normalised_addr);
								_g_free0 (addr);
							}
							goto __finally2;
							__catch2_folks_im_details_error:
							{
								GError* e = NULL;
								GError* _tmp26_;
								const gchar* _tmp27_;
								e = _inner_error_;
								_inner_error_ = NULL;
								_tmp26_ = e;
								_tmp27_ = _tmp26_->message;
								g_warning ("edsf-persona.vala:872: Problem when trying to normalise address: %s\n", _tmp27_);
								_g_error_free0 (e);
							}
							__finally2:
							if (_inner_error_ != NULL) {
								__vala_EVCardAttribute_free0 (attr);
								__g_list_free___vala_EVCardAttribute_free0_0 (addresses);
								_g_list_free0 (im_proto_collection);
								_g_hash_table_unref0 (im_eds_map);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return;
							}
							__vala_EVCardAttribute_free0 (attr);
						}
					}
				}
				__g_list_free___vala_EVCardAttribute_free0_0 (addresses);
			}
		}
		_g_list_free0 (im_proto_collection);
	}
	g_object_notify ((GObject*) self, "im-addresses");
	_g_hash_table_unref0 (im_eds_map);
}


static void _edsf_persona_update_groups (EdsfPersona* self) {
	EContact* _tmp0_;
	void* _tmp1_ = NULL;
	GList* category_names;
	GeeHashSet* _tmp2_;
	GeeHashSet* new_categories;
	GeeLinkedList* _tmp3_;
	GeeLinkedList* added_categories;
	GList* _tmp4_;
	GeeLinkedList* _tmp13_;
	GeeLinkedList* removed_categories;
	gboolean _tmp53_ = FALSE;
	GeeLinkedList* _tmp54_;
	gint _tmp55_;
	gint _tmp56_;
	gboolean _tmp60_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_contact;
	_tmp1_ = e_contact_get (_tmp0_, E_CONTACT_CATEGORY_LIST);
	category_names = (GList*) _tmp1_;
	_tmp2_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL);
	new_categories = _tmp2_;
	_tmp3_ = gee_linked_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	added_categories = _tmp3_;
	_tmp4_ = category_names;
	{
		GList* category_name_collection = NULL;
		GList* category_name_it = NULL;
		category_name_collection = _tmp4_;
		for (category_name_it = category_name_collection; category_name_it != NULL; category_name_it = category_name_it->next) {
			gchar* _tmp5_;
			gchar* category_name = NULL;
			_tmp5_ = g_strdup ((const gchar*) category_name_it->data);
			category_name = _tmp5_;
			{
				GeeHashSet* _tmp6_;
				const gchar* _tmp7_;
				GeeHashSet* _tmp8_;
				const gchar* _tmp9_;
				gboolean _tmp10_ = FALSE;
				_tmp6_ = new_categories;
				_tmp7_ = category_name;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp6_, _tmp7_);
				_tmp8_ = self->priv->_groups;
				_tmp9_ = category_name;
				_tmp10_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp8_, _tmp9_);
				if (!_tmp10_) {
					GeeLinkedList* _tmp11_;
					const gchar* _tmp12_;
					_tmp11_ = added_categories;
					_tmp12_ = category_name;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp11_, _tmp12_);
				}
				_g_free0 (category_name);
			}
		}
	}
	_tmp13_ = gee_linked_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	removed_categories = _tmp13_;
	{
		GeeHashSet* _tmp14_;
		GeeIterator* _tmp15_ = NULL;
		GeeIterator* _category_name_it;
		_tmp14_ = self->priv->_groups;
		_tmp15_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp14_);
		_category_name_it = _tmp15_;
		while (TRUE) {
			GeeIterator* _tmp16_;
			gboolean _tmp17_ = FALSE;
			GeeIterator* _tmp18_;
			gpointer _tmp19_ = NULL;
			gchar* category_name;
			GeeHashSet* _tmp20_;
			const gchar* _tmp21_;
			gboolean _tmp22_ = FALSE;
			_tmp16_ = _category_name_it;
			_tmp17_ = gee_iterator_next (_tmp16_);
			if (!_tmp17_) {
				break;
			}
			_tmp18_ = _category_name_it;
			_tmp19_ = gee_iterator_get (_tmp18_);
			category_name = (gchar*) _tmp19_;
			_tmp20_ = new_categories;
			_tmp21_ = category_name;
			_tmp22_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp20_, _tmp21_);
			if (!_tmp22_) {
				GeeLinkedList* _tmp23_;
				const gchar* _tmp24_;
				_tmp23_ = removed_categories;
				_tmp24_ = category_name;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp23_, _tmp24_);
			}
			_g_free0 (category_name);
		}
		_g_object_unref0 (_category_name_it);
	}
	{
		GeeLinkedList* _tmp25_;
		GeeLinkedList* _tmp26_;
		GeeLinkedList* _category_name_list;
		GeeLinkedList* _tmp27_;
		gint _tmp28_;
		gint _tmp29_;
		gint _category_name_size;
		gint _category_name_index;
		_tmp25_ = removed_categories;
		_tmp26_ = _g_object_ref0 (_tmp25_);
		_category_name_list = _tmp26_;
		_tmp27_ = _category_name_list;
		_tmp28_ = gee_collection_get_size ((GeeCollection*) _tmp27_);
		_tmp29_ = _tmp28_;
		_category_name_size = _tmp29_;
		_category_name_index = -1;
		while (TRUE) {
			gint _tmp30_;
			gint _tmp31_;
			gint _tmp32_;
			GeeLinkedList* _tmp33_;
			gint _tmp34_;
			gpointer _tmp35_ = NULL;
			gchar* category_name;
			const gchar* _tmp36_;
			GeeHashSet* _tmp37_;
			const gchar* _tmp38_;
			_tmp30_ = _category_name_index;
			_category_name_index = _tmp30_ + 1;
			_tmp31_ = _category_name_index;
			_tmp32_ = _category_name_size;
			if (!(_tmp31_ < _tmp32_)) {
				break;
			}
			_tmp33_ = _category_name_list;
			_tmp34_ = _category_name_index;
			_tmp35_ = gee_abstract_list_get ((GeeAbstractList*) _tmp33_, _tmp34_);
			category_name = (gchar*) _tmp35_;
			_tmp36_ = category_name;
			g_signal_emit_by_name ((FolksGroupDetails*) self, "group-changed", _tmp36_, FALSE);
			_tmp37_ = self->priv->_groups;
			_tmp38_ = category_name;
			gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp37_, _tmp38_);
			_g_free0 (category_name);
		}
		_g_object_unref0 (_category_name_list);
	}
	{
		GeeLinkedList* _tmp39_;
		GeeLinkedList* _tmp40_;
		GeeLinkedList* _category_name_list;
		GeeLinkedList* _tmp41_;
		gint _tmp42_;
		gint _tmp43_;
		gint _category_name_size;
		gint _category_name_index;
		_tmp39_ = added_categories;
		_tmp40_ = _g_object_ref0 (_tmp39_);
		_category_name_list = _tmp40_;
		_tmp41_ = _category_name_list;
		_tmp42_ = gee_collection_get_size ((GeeCollection*) _tmp41_);
		_tmp43_ = _tmp42_;
		_category_name_size = _tmp43_;
		_category_name_index = -1;
		while (TRUE) {
			gint _tmp44_;
			gint _tmp45_;
			gint _tmp46_;
			GeeLinkedList* _tmp47_;
			gint _tmp48_;
			gpointer _tmp49_ = NULL;
			gchar* category_name;
			GeeHashSet* _tmp50_;
			const gchar* _tmp51_;
			const gchar* _tmp52_;
			_tmp44_ = _category_name_index;
			_category_name_index = _tmp44_ + 1;
			_tmp45_ = _category_name_index;
			_tmp46_ = _category_name_size;
			if (!(_tmp45_ < _tmp46_)) {
				break;
			}
			_tmp47_ = _category_name_list;
			_tmp48_ = _category_name_index;
			_tmp49_ = gee_abstract_list_get ((GeeAbstractList*) _tmp47_, _tmp48_);
			category_name = (gchar*) _tmp49_;
			_tmp50_ = self->priv->_groups;
			_tmp51_ = category_name;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp50_, _tmp51_);
			_tmp52_ = category_name;
			g_signal_emit_by_name ((FolksGroupDetails*) self, "group-changed", _tmp52_, TRUE);
			_g_free0 (category_name);
		}
		_g_object_unref0 (_category_name_list);
	}
	_tmp54_ = added_categories;
	_tmp55_ = gee_collection_get_size ((GeeCollection*) _tmp54_);
	_tmp56_ = _tmp55_;
	if (_tmp56_ != 0) {
		_tmp53_ = TRUE;
	} else {
		GeeLinkedList* _tmp57_;
		gint _tmp58_;
		gint _tmp59_;
		_tmp57_ = removed_categories;
		_tmp58_ = gee_collection_get_size ((GeeCollection*) _tmp57_);
		_tmp59_ = _tmp58_;
		_tmp53_ = _tmp59_ != 0;
	}
	_tmp60_ = _tmp53_;
	if (_tmp60_) {
		g_object_notify ((GObject*) self, "groups");
	}
	_g_object_unref0 (removed_categories);
	_g_object_unref0 (added_categories);
	_g_object_unref0 (new_categories);
}


/**
   * build a table of im protocols / im protocol aliases
   */
static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static gpointer _g_hash_table_ref0 (gpointer self) {
	return self ? g_hash_table_ref (self) : NULL;
}


GHashTable* _edsf_persona_get_im_eds_map (void) {
	GHashTable* result = NULL;
	GHashTable* _tmp22_;
	GHashTable* _tmp23_;
	GError * _inner_error_ = NULL;
	{
		GHashTable* _tmp0_;
		_tmp0_ = edsf_persona__im_eds_map;
		g_static_rec_mutex_lock (&__lock_edsf_persona__im_eds_map);
		{
			GHashTable* _tmp1_;
			_tmp1_ = edsf_persona__im_eds_map;
			if (_tmp1_ == NULL) {
				GHashFunc _tmp2_;
				GEqualFunc _tmp3_;
				GHashTable* _tmp4_;
				GHashTable* _tmp5_;
				gchar* _tmp6_;
				GHashTable* _tmp7_;
				gchar* _tmp8_;
				GHashTable* _tmp9_;
				gchar* _tmp10_;
				GHashTable* _tmp11_;
				gchar* _tmp12_;
				GHashTable* _tmp13_;
				gchar* _tmp14_;
				GHashTable* _tmp15_;
				gchar* _tmp16_;
				GHashTable* _tmp17_;
				gchar* _tmp18_;
				GHashTable* _tmp19_;
				gchar* _tmp20_;
				_tmp2_ = g_str_hash;
				_tmp3_ = g_str_equal;
				_tmp4_ = g_hash_table_new_full (_tmp2_, _tmp3_, _g_free0_, NULL);
				_g_hash_table_unref0 (edsf_persona__im_eds_map);
				edsf_persona__im_eds_map = _tmp4_;
				_tmp5_ = edsf_persona__im_eds_map;
				_tmp6_ = g_strdup ("aim");
				g_hash_table_insert (_tmp5_, _tmp6_, GINT_TO_POINTER (E_CONTACT_IM_AIM));
				_tmp7_ = edsf_persona__im_eds_map;
				_tmp8_ = g_strdup ("yahoo");
				g_hash_table_insert (_tmp7_, _tmp8_, GINT_TO_POINTER (E_CONTACT_IM_YAHOO));
				_tmp9_ = edsf_persona__im_eds_map;
				_tmp10_ = g_strdup ("groupwise");
				g_hash_table_insert (_tmp9_, _tmp10_, GINT_TO_POINTER (E_CONTACT_IM_GROUPWISE));
				_tmp11_ = edsf_persona__im_eds_map;
				_tmp12_ = g_strdup ("jabber");
				g_hash_table_insert (_tmp11_, _tmp12_, GINT_TO_POINTER (E_CONTACT_IM_JABBER));
				_tmp13_ = edsf_persona__im_eds_map;
				_tmp14_ = g_strdup ("msn");
				g_hash_table_insert (_tmp13_, _tmp14_, GINT_TO_POINTER (E_CONTACT_IM_MSN));
				_tmp15_ = edsf_persona__im_eds_map;
				_tmp16_ = g_strdup ("icq");
				g_hash_table_insert (_tmp15_, _tmp16_, GINT_TO_POINTER (E_CONTACT_IM_ICQ));
				_tmp17_ = edsf_persona__im_eds_map;
				_tmp18_ = g_strdup ("gadugadu");
				g_hash_table_insert (_tmp17_, _tmp18_, GINT_TO_POINTER (E_CONTACT_IM_GADUGADU));
				_tmp19_ = edsf_persona__im_eds_map;
				_tmp20_ = g_strdup ("skype");
				g_hash_table_insert (_tmp19_, _tmp20_, GINT_TO_POINTER (E_CONTACT_IM_SKYPE));
			}
		}
		__finally3:
		{
			GHashTable* _tmp21_;
			_tmp21_ = edsf_persona__im_eds_map;
			g_static_rec_mutex_unlock (&__lock_edsf_persona__im_eds_map);
		}
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp22_ = edsf_persona__im_eds_map;
	_tmp23_ = _g_hash_table_ref0 (_tmp22_);
	result = _tmp23_;
	return result;
}


static void _edsf_persona_update_phones (EdsfPersona* self) {
	GeeHashSet* _tmp0_;
	EContact* _tmp1_;
	GList* _tmp2_ = NULL;
	GList* attrs;
	GList* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_phone_numbers;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
	_tmp1_ = self->priv->_contact;
	_tmp2_ = e_contact_get_attributes (_tmp1_, E_CONTACT_TEL);
	attrs = _tmp2_;
	_tmp3_ = attrs;
	{
		GList* attr_collection = NULL;
		GList* attr_it = NULL;
		attr_collection = _tmp3_;
		for (attr_it = attr_collection; attr_it != NULL; attr_it = attr_it->next) {
			EVCardAttribute* _tmp4_;
			EVCardAttribute* attr = NULL;
			_tmp4_ = __vala_EVCardAttribute_copy0 ((EVCardAttribute*) attr_it->data);
			attr = _tmp4_;
			{
				EVCardAttribute* _tmp5_;
				gchar* _tmp6_ = NULL;
				gchar* _tmp7_;
				FolksPhoneFieldDetails* _tmp8_;
				FolksPhoneFieldDetails* _tmp9_;
				FolksPhoneFieldDetails* phone_fd;
				EVCardAttribute* _tmp10_;
				GList* _tmp11_ = NULL;
				GeeHashSet* _tmp22_;
				FolksPhoneFieldDetails* _tmp23_;
				_tmp5_ = attr;
				_tmp6_ = e_vcard_attribute_get_value (_tmp5_);
				_tmp7_ = _tmp6_;
				_tmp8_ = folks_phone_field_details_new (_tmp7_, NULL);
				_tmp9_ = _tmp8_;
				_g_free0 (_tmp7_);
				phone_fd = _tmp9_;
				_tmp10_ = attr;
				_tmp11_ = e_vcard_attribute_get_params (_tmp10_);
				{
					GList* param_collection = NULL;
					GList* param_it = NULL;
					param_collection = _tmp11_;
					for (param_it = param_collection; param_it != NULL; param_it = param_it->next) {
						EVCardAttributeParam* _tmp12_;
						EVCardAttributeParam* param = NULL;
						_tmp12_ = __vala_EVCardAttributeParam_copy0 ((EVCardAttributeParam*) param_it->data);
						param = _tmp12_;
						{
							EVCardAttributeParam* _tmp13_;
							const gchar* _tmp14_ = NULL;
							gchar* _tmp15_ = NULL;
							gchar* param_name;
							EVCardAttributeParam* _tmp16_;
							GList* _tmp17_ = NULL;
							_tmp13_ = param;
							_tmp14_ = e_vcard_attribute_param_get_name (_tmp13_);
							_tmp15_ = g_utf8_strdown (_tmp14_, (gssize) (-1));
							param_name = _tmp15_;
							_tmp16_ = param;
							_tmp17_ = e_vcard_attribute_param_get_values (_tmp16_);
							{
								GList* param_value_collection = NULL;
								GList* param_value_it = NULL;
								param_value_collection = _tmp17_;
								for (param_value_it = param_value_collection; param_value_it != NULL; param_value_it = param_value_it->next) {
									gchar* _tmp18_;
									gchar* param_value = NULL;
									_tmp18_ = g_strdup ((const gchar*) param_value_it->data);
									param_value = _tmp18_;
									{
										FolksPhoneFieldDetails* _tmp19_;
										const gchar* _tmp20_;
										const gchar* _tmp21_;
										_tmp19_ = phone_fd;
										_tmp20_ = param_name;
										_tmp21_ = param_value;
										folks_abstract_field_details_add_parameter ((FolksAbstractFieldDetails*) _tmp19_, _tmp20_, _tmp21_);
										_g_free0 (param_value);
									}
								}
							}
							_g_free0 (param_name);
							__vala_EVCardAttributeParam_free0 (param);
						}
					}
				}
				_tmp22_ = self->priv->_phone_numbers;
				_tmp23_ = phone_fd;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp22_, _tmp23_);
				_g_object_unref0 (phone_fd);
				__vala_EVCardAttribute_free0 (attr);
			}
		}
	}
	g_object_notify ((GObject*) self, "phone-numbers");
	__g_list_free___vala_EVCardAttribute_free0_0 (attrs);
}


static EContactAddress* _vala_EContactAddress_copy (EContactAddress* self) {
	return g_boxed_copy (e_contact_address_get_type (), self);
}


static gpointer __vala_EContactAddress_copy0 (gpointer self) {
	return self ? _vala_EContactAddress_copy (self) : NULL;
}


static void _vala_EContactAddress_free (EContactAddress* self) {
	g_boxed_free (e_contact_address_get_type (), self);
}


static void _edsf_persona_update_addresses (EdsfPersona* self) {
	GeeHashSet* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_postal_addresses;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
	{
		const gchar** afield_collection = NULL;
		gint afield_collection_length1 = 0;
		gint _afield_collection_size_ = 0;
		gint afield_it = 0;
		afield_collection = EDSF_PERSONA_address_fields;
		afield_collection_length1 = G_N_ELEMENTS (EDSF_PERSONA_address_fields);
		for (afield_it = 0; afield_it < G_N_ELEMENTS (EDSF_PERSONA_address_fields); afield_it = afield_it + 1) {
			gchar* _tmp1_;
			gchar* afield = NULL;
			_tmp1_ = g_strdup (afield_collection[afield_it]);
			afield = _tmp1_;
			{
				const gchar* _tmp2_;
				void* _tmp3_ = NULL;
				EContactAddress* _tmp4_;
				EContactAddress* a;
				EContactAddress* _tmp5_;
				_tmp2_ = afield;
				_tmp3_ = _edsf_persona_get_property (self, _tmp2_);
				_tmp4_ = __vala_EContactAddress_copy0 ((EContactAddress*) _tmp3_);
				a = _tmp4_;
				_tmp5_ = a;
				if (_tmp5_ != NULL) {
					EContactAddress* _tmp6_;
					const gchar* _tmp7_;
					gchar* _tmp8_;
					gchar* address_format;
					EContactAddress* _tmp9_;
					const gchar* _tmp10_;
					gchar* _tmp11_;
					gchar* postal_code;
					EContactAddress* _tmp12_;
					const gchar* _tmp13_;
					gchar* _tmp14_;
					gchar* country;
					EContactAddress* _tmp15_;
					const gchar* _tmp16_;
					gchar* _tmp17_;
					gchar* extension;
					EContactAddress* _tmp18_;
					const gchar* _tmp19_;
					gchar* _tmp20_;
					gchar* locality;
					EContactAddress* _tmp21_;
					const gchar* _tmp22_;
					gchar* _tmp23_;
					gchar* po_box;
					EContactAddress* _tmp24_;
					const gchar* _tmp25_;
					gchar* _tmp26_;
					gchar* region;
					EContactAddress* _tmp27_;
					const gchar* _tmp28_;
					gchar* _tmp29_;
					gchar* street;
					const gchar* _tmp30_;
					const gchar* _tmp31_;
					const gchar* _tmp32_;
					const gchar* _tmp33_;
					const gchar* _tmp34_;
					const gchar* _tmp35_;
					const gchar* _tmp36_;
					const gchar* _tmp37_;
					FolksPostalAddress* _tmp38_;
					FolksPostalAddress* pa;
					FolksPostalAddress* _tmp39_;
					FolksPostalAddressFieldDetails* _tmp40_;
					FolksPostalAddressFieldDetails* pa_fd;
					FolksPostalAddressFieldDetails* _tmp41_;
					const gchar* _tmp42_;
					GeeHashSet* _tmp43_;
					FolksPostalAddressFieldDetails* _tmp44_;
					_tmp6_ = a;
					_tmp7_ = _tmp6_->address_format;
					_tmp8_ = g_strdup (_tmp7_);
					address_format = _tmp8_;
					_tmp9_ = a;
					_tmp10_ = _tmp9_->code;
					_tmp11_ = g_strdup (_tmp10_);
					postal_code = _tmp11_;
					_tmp12_ = a;
					_tmp13_ = _tmp12_->country;
					_tmp14_ = g_strdup (_tmp13_);
					country = _tmp14_;
					_tmp15_ = a;
					_tmp16_ = _tmp15_->ext;
					_tmp17_ = g_strdup (_tmp16_);
					extension = _tmp17_;
					_tmp18_ = a;
					_tmp19_ = _tmp18_->locality;
					_tmp20_ = g_strdup (_tmp19_);
					locality = _tmp20_;
					_tmp21_ = a;
					_tmp22_ = _tmp21_->po;
					_tmp23_ = g_strdup (_tmp22_);
					po_box = _tmp23_;
					_tmp24_ = a;
					_tmp25_ = _tmp24_->region;
					_tmp26_ = g_strdup (_tmp25_);
					region = _tmp26_;
					_tmp27_ = a;
					_tmp28_ = _tmp27_->street;
					_tmp29_ = g_strdup (_tmp28_);
					street = _tmp29_;
					_tmp30_ = po_box;
					_tmp31_ = extension;
					_tmp32_ = street;
					_tmp33_ = locality;
					_tmp34_ = region;
					_tmp35_ = postal_code;
					_tmp36_ = country;
					_tmp37_ = address_format;
					_tmp38_ = folks_postal_address_new (_tmp30_, _tmp31_, _tmp32_, _tmp33_, _tmp34_, _tmp35_, _tmp36_, _tmp37_, NULL);
					pa = _tmp38_;
					_tmp39_ = pa;
					_tmp40_ = folks_postal_address_field_details_new (_tmp39_, NULL);
					pa_fd = _tmp40_;
					_tmp41_ = pa_fd;
					_tmp42_ = afield;
					folks_abstract_field_details_add_parameter ((FolksAbstractFieldDetails*) _tmp41_, "type", _tmp42_);
					_tmp43_ = self->priv->_postal_addresses;
					_tmp44_ = pa_fd;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp43_, _tmp44_);
					_g_object_unref0 (pa_fd);
					_g_object_unref0 (pa);
					_g_free0 (street);
					_g_free0 (region);
					_g_free0 (po_box);
					_g_free0 (locality);
					_g_free0 (extension);
					_g_free0 (country);
					_g_free0 (postal_code);
					_g_free0 (address_format);
				}
				__vala_EContactAddress_free0 (a);
				_g_free0 (afield);
			}
		}
	}
	g_object_notify ((GObject*) self, "postal-addresses");
}


static void _edsf_persona_update_local_ids (EdsfPersona* self) {
	GeeHashSet* _tmp0_;
	EContact* _tmp1_;
	EVCardAttribute* _tmp2_ = NULL;
	EVCardAttribute* _tmp3_;
	EVCardAttribute* ids;
	EVCardAttribute* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_local_ids;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
	_tmp1_ = self->priv->_contact;
	_tmp2_ = e_vcard_get_attribute ((EVCard*) _tmp1_, "X-FOLKS-CONTACTS-IDS");
	_tmp3_ = __vala_EVCardAttribute_copy0 (_tmp2_);
	ids = _tmp3_;
	_tmp4_ = ids;
	if (_tmp4_ != NULL) {
		EVCardAttribute* _tmp5_;
		GList* _tmp6_ = NULL;
		GList* ids_v;
		GList* _tmp7_;
		_tmp5_ = ids;
		_tmp6_ = e_vcard_attribute_get_values (_tmp5_);
		ids_v = _tmp6_;
		_tmp7_ = ids_v;
		{
			GList* local_id_collection = NULL;
			GList* local_id_it = NULL;
			local_id_collection = _tmp7_;
			for (local_id_it = local_id_collection; local_id_it != NULL; local_id_it = local_id_it->next) {
				gchar* _tmp8_;
				gchar* local_id = NULL;
				_tmp8_ = g_strdup ((const gchar*) local_id_it->data);
				local_id = _tmp8_;
				{
					GeeHashSet* _tmp9_;
					const gchar* _tmp10_;
					_tmp9_ = self->priv->_local_ids;
					_tmp10_ = local_id;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp9_, _tmp10_);
					_g_free0 (local_id);
				}
			}
		}
	}
	g_object_notify ((GObject*) self, "local-ids");
	__vala_EVCardAttribute_free0 (ids);
}


void* _edsf_persona_get_property_from_contact (EContact* contact, const gchar* prop_name) {
	void* result = NULL;
	void* prop_value;
	EContact* _tmp0_;
	const gchar* _tmp1_;
	EContactField _tmp2_ = 0;
	void* _tmp3_ = NULL;
	void* _tmp4_;
	g_return_val_if_fail (contact != NULL, NULL);
	g_return_val_if_fail (prop_name != NULL, NULL);
	prop_value = NULL;
	_tmp0_ = contact;
	_tmp1_ = prop_name;
	_tmp2_ = e_contact_field_id (_tmp1_);
	_tmp3_ = e_contact_get (_tmp0_, _tmp2_);
	prop_value = _tmp3_;
	_tmp4_ = prop_value;
	result = _tmp4_;
	return result;
}


static void* _edsf_persona_get_property (EdsfPersona* self, const gchar* prop_name) {
	void* result = NULL;
	EContact* _tmp0_;
	const gchar* _tmp1_;
	void* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (prop_name != NULL, NULL);
	_tmp0_ = self->priv->_contact;
	_tmp1_ = prop_name;
	_tmp2_ = _edsf_persona_get_property_from_contact (_tmp0_, _tmp1_);
	result = _tmp2_;
	return result;
}


EContact* edsf_persona_get_contact (EdsfPersona* self) {
	EContact* result;
	EContact* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_contact;
	result = _tmp0_;
	return result;
}


static void edsf_persona_set_contact (EdsfPersona* self, EContact* value) {
	EContact* _tmp0_;
	EContact* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_contact);
	self->priv->_contact = _tmp1_;
	g_object_notify ((GObject *) self, "contact");
}


static GeeMultiMap* edsf_persona_real_get_web_service_addresses (FolksWebServiceDetails* base) {
	GeeMultiMap* result;
	EdsfPersona* self;
	GeeHashMultiMap* _tmp0_;
	self = (EdsfPersona*) base;
	_tmp0_ = self->priv->_web_service_addresses;
	result = (GeeMultiMap*) _tmp0_;
	return result;
}


static void edsf_persona_real_set_web_service_addresses (FolksWebServiceDetails* base, GeeMultiMap* value) {
	EdsfPersona* self;
	FolksPersonaStore* _tmp0_;
	FolksPersonaStore* _tmp1_;
	EdsfPersonaStore* _tmp2_;
	EdsfPersonaStore* store;
	EdsfPersonaStore* _tmp3_;
	GeeMultiMap* _tmp4_;
	self = (EdsfPersona*) base;
	_tmp0_ = folks_persona_get_store ((FolksPersona*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (EDSF_PERSONA_STORE (_tmp1_));
	store = _tmp2_;
	_tmp3_ = store;
	_tmp4_ = value;
	_edsf_persona_store_set_web_service_addresses (_tmp3_, self, _tmp4_, NULL, NULL);
	_g_object_unref0 (store);
	g_object_notify ((GObject *) self, "web-service-addresses");
}


static GeeSet* edsf_persona_real_get_local_ids (FolksLocalIdDetails* base) {
	GeeSet* result;
	EdsfPersona* self;
	GeeHashSet* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GeeSet* _tmp5_;
	self = (EdsfPersona*) base;
	_tmp0_ = self->priv->_local_ids;
	_tmp1_ = self->priv->_contact_id;
	_tmp2_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp0_, _tmp1_);
	if (_tmp2_ == FALSE) {
		GeeHashSet* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = self->priv->_local_ids;
		_tmp4_ = self->priv->_contact_id;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp3_, _tmp4_);
	}
	_tmp5_ = self->priv->_local_ids_ro;
	result = _tmp5_;
	return result;
}


static void edsf_persona_real_set_local_ids (FolksLocalIdDetails* base, GeeSet* value) {
	EdsfPersona* self;
	FolksPersonaStore* _tmp0_;
	FolksPersonaStore* _tmp1_;
	GeeSet* _tmp2_;
	self = (EdsfPersona*) base;
	_tmp0_ = folks_persona_get_store ((FolksPersona*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = value;
	_edsf_persona_store_set_local_ids (EDSF_PERSONA_STORE (_tmp1_), self, _tmp2_, NULL, NULL);
	g_object_notify ((GObject *) self, "local-ids");
}


static GeeSet* edsf_persona_real_get_postal_addresses (FolksPostalAddressDetails* base) {
	GeeSet* result;
	EdsfPersona* self;
	GeeSet* _tmp0_;
	self = (EdsfPersona*) base;
	_tmp0_ = self->priv->_postal_addresses_ro;
	result = _tmp0_;
	return result;
}


static void edsf_persona_real_set_postal_addresses (FolksPostalAddressDetails* base, GeeSet* value) {
	EdsfPersona* self;
	FolksPersonaStore* _tmp0_;
	FolksPersonaStore* _tmp1_;
	GeeSet* _tmp2_;
	self = (EdsfPersona*) base;
	_tmp0_ = folks_persona_get_store ((FolksPersona*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = value;
	_edsf_persona_store_set_postal_addresses (EDSF_PERSONA_STORE (_tmp1_), self, _tmp2_, NULL, NULL);
	g_object_notify ((GObject *) self, "postal-addresses");
}


static GeeSet* edsf_persona_real_get_phone_numbers (FolksPhoneDetails* base) {
	GeeSet* result;
	EdsfPersona* self;
	GeeSet* _tmp0_;
	self = (EdsfPersona*) base;
	_tmp0_ = self->priv->_phone_numbers_ro;
	result = _tmp0_;
	return result;
}


static void edsf_persona_real_set_phone_numbers (FolksPhoneDetails* base, GeeSet* value) {
	EdsfPersona* self;
	FolksPersonaStore* _tmp0_;
	FolksPersonaStore* _tmp1_;
	GeeSet* _tmp2_;
	self = (EdsfPersona*) base;
	_tmp0_ = folks_persona_get_store ((FolksPersona*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = value;
	_edsf_persona_store_set_phones (EDSF_PERSONA_STORE (_tmp1_), self, _tmp2_, NULL, NULL);
	g_object_notify ((GObject *) self, "phone-numbers");
}


static GeeSet* edsf_persona_real_get_email_addresses (FolksEmailDetails* base) {
	GeeSet* result;
	EdsfPersona* self;
	GeeSet* _tmp0_;
	self = (EdsfPersona*) base;
	_tmp0_ = self->priv->_email_addresses_ro;
	result = _tmp0_;
	return result;
}


static void edsf_persona_real_set_email_addresses (FolksEmailDetails* base, GeeSet* value) {
	EdsfPersona* self;
	FolksPersonaStore* _tmp0_;
	FolksPersonaStore* _tmp1_;
	GeeSet* _tmp2_;
	self = (EdsfPersona*) base;
	_tmp0_ = folks_persona_get_store ((FolksPersona*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = value;
	_edsf_persona_store_set_emails (EDSF_PERSONA_STORE (_tmp1_), self, _tmp2_, NULL, NULL);
	g_object_notify ((GObject *) self, "email-addresses");
}


static GeeSet* edsf_persona_real_get_notes (FolksNoteDetails* base) {
	GeeSet* result;
	EdsfPersona* self;
	GeeSet* _tmp0_;
	self = (EdsfPersona*) base;
	_tmp0_ = self->priv->_notes_ro;
	result = _tmp0_;
	return result;
}


static void edsf_persona_real_set_notes (FolksNoteDetails* base, GeeSet* value) {
	EdsfPersona* self;
	FolksPersonaStore* _tmp0_;
	FolksPersonaStore* _tmp1_;
	GeeSet* _tmp2_;
	self = (EdsfPersona*) base;
	_tmp0_ = folks_persona_get_store ((FolksPersona*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = value;
	_edsf_persona_store_set_notes (EDSF_PERSONA_STORE (_tmp1_), self, _tmp2_, NULL, NULL);
	g_object_notify ((GObject *) self, "notes");
}


static gchar** edsf_persona_real_get_linkable_properties (FolksPersona* base, int* result_length1) {
	gchar** result;
	EdsfPersona* self;
	gchar** _tmp0_;
	gint _tmp0__length1;
	self = (EdsfPersona*) base;
	_tmp0_ = EDSF_PERSONA__linkable_properties;
	_tmp0__length1 = G_N_ELEMENTS (EDSF_PERSONA__linkable_properties);
	if (result_length1) {
		*result_length1 = _tmp0__length1;
	}
	result = _tmp0_;
	return result;
}


static gchar** edsf_persona_real_get_writeable_properties (FolksPersona* base, int* result_length1) {
	gchar** result;
	EdsfPersona* self;
	gchar** _tmp0_;
	gint _tmp0__length1;
	self = (EdsfPersona*) base;
	_tmp0_ = EDSF_PERSONA__writeable_properties;
	_tmp0__length1 = G_N_ELEMENTS (EDSF_PERSONA__writeable_properties);
	if (result_length1) {
		*result_length1 = _tmp0__length1;
	}
	result = _tmp0_;
	return result;
}


static GLoadableIcon* edsf_persona_real_get_avatar (FolksAvatarDetails* base) {
	GLoadableIcon* result;
	EdsfPersona* self;
	GLoadableIcon* _tmp0_;
	self = (EdsfPersona*) base;
	_tmp0_ = self->priv->_avatar;
	result = _tmp0_;
	return result;
}


static void edsf_persona_real_set_avatar (FolksAvatarDetails* base, GLoadableIcon* value) {
	EdsfPersona* self;
	gboolean _tmp0_ = FALSE;
	GLoadableIcon* _tmp1_;
	gboolean _tmp5_;
	self = (EdsfPersona*) base;
	_tmp1_ = self->priv->_avatar;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		GLoadableIcon* _tmp2_;
		GLoadableIcon* _tmp3_;
		gboolean _tmp4_ = FALSE;
		_tmp2_ = self->priv->_avatar;
		_tmp3_ = value;
		_tmp4_ = g_icon_equal ((GIcon*) _tmp2_, (GIcon*) _tmp3_);
		_tmp0_ = !_tmp4_;
	}
	_tmp5_ = _tmp0_;
	if (_tmp5_) {
		FolksPersonaStore* _tmp6_;
		FolksPersonaStore* _tmp7_;
		GLoadableIcon* _tmp8_;
		_tmp6_ = folks_persona_get_store ((FolksPersona*) self);
		_tmp7_ = _tmp6_;
		_tmp8_ = value;
		_edsf_persona_store_set_avatar (EDSF_PERSONA_STORE (_tmp7_), self, _tmp8_, NULL, NULL);
	}
	g_object_notify ((GObject *) self, "avatar");
}


static FolksStructuredName* edsf_persona_real_get_structured_name (FolksNameDetails* base) {
	FolksStructuredName* result;
	EdsfPersona* self;
	FolksStructuredName* _tmp0_;
	self = (EdsfPersona*) base;
	_tmp0_ = self->priv->_structured_name;
	result = _tmp0_;
	return result;
}


static void edsf_persona_real_set_structured_name (FolksNameDetails* base, FolksStructuredName* value) {
	EdsfPersona* self;
	FolksPersonaStore* _tmp0_;
	FolksPersonaStore* _tmp1_;
	FolksStructuredName* _tmp2_;
	self = (EdsfPersona*) base;
	_tmp0_ = folks_persona_get_store ((FolksPersona*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = value;
	_edsf_persona_store_set_structured_name (EDSF_PERSONA_STORE (_tmp1_), self, _tmp2_, NULL, NULL);
	g_object_notify ((GObject *) self, "structured-name");
}


const gchar* edsf_persona_get_contact_id (EdsfPersona* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_contact_id;
	result = _tmp0_;
	return result;
}


static void edsf_persona_set_contact_id (EdsfPersona* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_contact_id);
	self->priv->_contact_id = _tmp1_;
	g_object_notify ((GObject *) self, "contact-id");
}


static const gchar* edsf_persona_real_get_full_name (FolksNameDetails* base) {
	const gchar* result;
	EdsfPersona* self;
	const gchar* _tmp0_;
	self = (EdsfPersona*) base;
	_tmp0_ = self->priv->_full_name;
	result = _tmp0_;
	return result;
}


static void edsf_persona_real_set_full_name (FolksNameDetails* base, const gchar* value) {
	EdsfPersona* self;
	FolksPersonaStore* _tmp0_;
	FolksPersonaStore* _tmp1_;
	const gchar* _tmp2_;
	self = (EdsfPersona*) base;
	_tmp0_ = folks_persona_get_store ((FolksPersona*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = value;
	_edsf_persona_store_set_full_name (EDSF_PERSONA_STORE (_tmp1_), self, _tmp2_, NULL, NULL);
	g_object_notify ((GObject *) self, "full-name");
}


static const gchar* edsf_persona_real_get_nickname (FolksNameDetails* base) {
	const gchar* result;
	EdsfPersona* self;
	const gchar* _tmp0_;
	self = (EdsfPersona*) base;
	_tmp0_ = self->priv->_nickname;
	result = _tmp0_;
	return result;
}


static void edsf_persona_real_set_nickname (FolksNameDetails* base, const gchar* value) {
	EdsfPersona* self;
	FolksPersonaStore* _tmp0_;
	FolksPersonaStore* _tmp1_;
	const gchar* _tmp2_;
	self = (EdsfPersona*) base;
	_tmp0_ = folks_persona_get_store ((FolksPersona*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = value;
	_edsf_persona_store_set_nickname (EDSF_PERSONA_STORE (_tmp1_), self, _tmp2_, NULL, NULL);
	g_object_notify ((GObject *) self, "nickname");
}


static FolksGender edsf_persona_real_get_gender (FolksGenderDetails* base) {
	FolksGender result;
	EdsfPersona* self;
	FolksGender _tmp0_;
	self = (EdsfPersona*) base;
	_tmp0_ = self->priv->_gender;
	result = _tmp0_;
	return result;
}


static void edsf_persona_real_set_gender (FolksGenderDetails* base, FolksGender value) {
	EdsfPersona* self;
	FolksPersonaStore* _tmp0_;
	FolksPersonaStore* _tmp1_;
	FolksGender _tmp2_;
	self = (EdsfPersona*) base;
	_tmp0_ = folks_persona_get_store ((FolksPersona*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = value;
	_edsf_persona_store_set_gender (EDSF_PERSONA_STORE (_tmp1_), self, _tmp2_, NULL, NULL);
	g_object_notify ((GObject *) self, "gender");
}


static GeeSet* edsf_persona_real_get_urls (FolksUrlDetails* base) {
	GeeSet* result;
	EdsfPersona* self;
	GeeSet* _tmp0_;
	self = (EdsfPersona*) base;
	_tmp0_ = self->priv->_urls_ro;
	result = _tmp0_;
	return result;
}


static void edsf_persona_real_set_urls (FolksUrlDetails* base, GeeSet* value) {
	EdsfPersona* self;
	FolksPersonaStore* _tmp0_;
	FolksPersonaStore* _tmp1_;
	GeeSet* _tmp2_;
	self = (EdsfPersona*) base;
	_tmp0_ = folks_persona_get_store ((FolksPersona*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = value;
	_edsf_persona_store_set_urls (EDSF_PERSONA_STORE (_tmp1_), self, _tmp2_, NULL, NULL);
	g_object_notify ((GObject *) self, "urls");
}


static GeeMultiMap* edsf_persona_real_get_im_addresses (FolksImDetails* base) {
	GeeMultiMap* result;
	EdsfPersona* self;
	GeeHashMultiMap* _tmp0_;
	self = (EdsfPersona*) base;
	_tmp0_ = self->priv->_im_addresses;
	result = (GeeMultiMap*) _tmp0_;
	return result;
}


static void edsf_persona_real_set_im_addresses (FolksImDetails* base, GeeMultiMap* value) {
	EdsfPersona* self;
	FolksPersonaStore* _tmp0_;
	FolksPersonaStore* _tmp1_;
	GeeMultiMap* _tmp2_;
	self = (EdsfPersona*) base;
	_tmp0_ = folks_persona_get_store ((FolksPersona*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = value;
	_edsf_persona_store_set_im_fds (EDSF_PERSONA_STORE (_tmp1_), self, _tmp2_, NULL, NULL);
	g_object_notify ((GObject *) self, "im-addresses");
}


static GeeSet* edsf_persona_real_get_groups (FolksGroupDetails* base) {
	GeeSet* result;
	EdsfPersona* self;
	GeeSet* _tmp0_;
	self = (EdsfPersona*) base;
	_tmp0_ = self->priv->_groups_ro;
	result = _tmp0_;
	return result;
}


static void edsf_persona_real_set_groups (FolksGroupDetails* base, GeeSet* value) {
	EdsfPersona* self;
	FolksPersonaStore* _tmp0_;
	FolksPersonaStore* _tmp1_;
	GeeSet* _tmp2_;
	self = (EdsfPersona*) base;
	_tmp0_ = folks_persona_get_store ((FolksPersona*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = value;
	_edsf_persona_store_set_groups (EDSF_PERSONA_STORE (_tmp1_), self, _tmp2_, NULL, NULL);
	g_object_notify ((GObject *) self, "groups");
}


static void edsf_persona_class_init (EdsfPersonaClass * klass) {
	edsf_persona_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (EdsfPersonaPrivate));
	FOLKS_PERSONA_CLASS (klass)->linkable_property_to_links = edsf_persona_real_linkable_property_to_links;
	FOLKS_PERSONA_CLASS (klass)->get_linkable_properties = edsf_persona_real_get_linkable_properties;
	FOLKS_PERSONA_CLASS (klass)->get_writeable_properties = edsf_persona_real_get_writeable_properties;
	G_OBJECT_CLASS (klass)->get_property = _vala_edsf_persona_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_edsf_persona_set_property;
	G_OBJECT_CLASS (klass)->finalize = edsf_persona_finalize;
	/**
	   * The e-d-s contact represented by this Persona
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), EDSF_PERSONA_CONTACT, g_param_spec_object ("contact", "contact", "contact", e_contact_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * {@inheritDoc}
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), EDSF_PERSONA_WEB_SERVICE_ADDRESSES, "web-service-addresses");
	/**
	   * IDs used to link {@link Edsf.Persona}s.
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), EDSF_PERSONA_LOCAL_IDS, "local-ids");
	/**
	   * The postal addresses of the contact.
	   *
	   * A list of postal addresses associated to the contact.
	   *
	   * @since 0.6.0
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), EDSF_PERSONA_POSTAL_ADDRESSES, "postal-addresses");
	/**
	   * {@inheritDoc}
	   *
	   * @since 0.6.0
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), EDSF_PERSONA_PHONE_NUMBERS, "phone-numbers");
	/**
	   * {@inheritDoc}
	   *
	   * @since 0.6.0
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), EDSF_PERSONA_EMAIL_ADDRESSES, "email-addresses");
	/**
	   * {@inheritDoc}
	   *
	   * @since 0.6.0
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), EDSF_PERSONA_NOTES, "notes");
	/**
	   * {@inheritDoc}
	   *
	   * @since 0.6.0
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), EDSF_PERSONA_LINKABLE_PROPERTIES, "linkable-properties");
	/**
	   * {@inheritDoc}
	   *
	   * @since 0.6.0
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), EDSF_PERSONA_WRITEABLE_PROPERTIES, "writeable-properties");
	/**
	   * An avatar for the Persona.
	   *
	   * See {@link Folks.AvatarDetails.avatar}.
	   *
	   * @since 0.6.0
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), EDSF_PERSONA_AVATAR, "avatar");
	/**
	   * {@inheritDoc}
	   *
	   * @since 0.6.0
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), EDSF_PERSONA_STRUCTURED_NAME, "structured-name");
	/**
	   * The e-d-s contact uid
	   *
	   * @since 0.6.0
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), EDSF_PERSONA_CONTACT_ID, g_param_spec_string ("contact-id", "contact-id", "contact-id", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * {@inheritDoc}
	   *
	   * @since 0.6.0
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), EDSF_PERSONA_FULL_NAME, "full-name");
	/**
	   * {@inheritDoc}
	   *
	   * @since 0.6.0
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), EDSF_PERSONA_NICKNAME, "nickname");
	/**
	   * {@inheritDoc}
	   *
	   * @since 0.6.0
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), EDSF_PERSONA_GENDER, "gender");
	/**
	   * {@inheritDoc}
	   *
	   * @since 0.6.0
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), EDSF_PERSONA_URLS, "urls");
	/**
	   * {@inheritDoc}
	   *
	   * @since 0.6.0
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), EDSF_PERSONA_IM_ADDRESSES, "im-addresses");
	/**
	   * {@inheritDoc}
	   *
	   * @since 0.6.0
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), EDSF_PERSONA_GROUPS, "groups");
	g_static_rec_mutex_init (&__lock_edsf_persona__im_eds_map);
}


static void edsf_persona_folks_avatar_details_interface_init (FolksAvatarDetailsIface * iface) {
	edsf_persona_folks_avatar_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_avatar = edsf_persona_real_get_avatar;
	iface->set_avatar = edsf_persona_real_set_avatar;
}


static void edsf_persona_folks_email_details_interface_init (FolksEmailDetailsIface * iface) {
	edsf_persona_folks_email_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_email_addresses = edsf_persona_real_get_email_addresses;
	iface->set_email_addresses = edsf_persona_real_set_email_addresses;
}


static void edsf_persona_folks_gender_details_interface_init (FolksGenderDetailsIface * iface) {
	edsf_persona_folks_gender_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_gender = edsf_persona_real_get_gender;
	iface->set_gender = edsf_persona_real_set_gender;
}


static void edsf_persona_folks_group_details_interface_init (FolksGroupDetailsIface * iface) {
	edsf_persona_folks_group_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->change_group = (void (*)(FolksGroupDetails*, const gchar*, gboolean, GError**)) edsf_persona_real_change_group;
	iface->change_group_finish = edsf_persona_real_change_group_finish;
	iface->get_groups = edsf_persona_real_get_groups;
	iface->set_groups = edsf_persona_real_set_groups;
}


static void edsf_persona_folks_im_details_interface_init (FolksImDetailsIface * iface) {
	edsf_persona_folks_im_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_im_addresses = edsf_persona_real_get_im_addresses;
	iface->set_im_addresses = edsf_persona_real_set_im_addresses;
}


static void edsf_persona_folks_local_id_details_interface_init (FolksLocalIdDetailsIface * iface) {
	edsf_persona_folks_local_id_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_local_ids = edsf_persona_real_get_local_ids;
	iface->set_local_ids = edsf_persona_real_set_local_ids;
}


static void edsf_persona_folks_name_details_interface_init (FolksNameDetailsIface * iface) {
	edsf_persona_folks_name_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_structured_name = edsf_persona_real_get_structured_name;
	iface->set_structured_name = edsf_persona_real_set_structured_name;
	iface->get_full_name = edsf_persona_real_get_full_name;
	iface->set_full_name = edsf_persona_real_set_full_name;
	iface->get_nickname = edsf_persona_real_get_nickname;
	iface->set_nickname = edsf_persona_real_set_nickname;
}


static void edsf_persona_folks_note_details_interface_init (FolksNoteDetailsIface * iface) {
	edsf_persona_folks_note_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_notes = edsf_persona_real_get_notes;
	iface->set_notes = edsf_persona_real_set_notes;
}


static void edsf_persona_folks_phone_details_interface_init (FolksPhoneDetailsIface * iface) {
	edsf_persona_folks_phone_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_phone_numbers = edsf_persona_real_get_phone_numbers;
	iface->set_phone_numbers = edsf_persona_real_set_phone_numbers;
}


static void edsf_persona_folks_url_details_interface_init (FolksUrlDetailsIface * iface) {
	edsf_persona_folks_url_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_urls = edsf_persona_real_get_urls;
	iface->set_urls = edsf_persona_real_set_urls;
}


static void edsf_persona_folks_postal_address_details_interface_init (FolksPostalAddressDetailsIface * iface) {
	edsf_persona_folks_postal_address_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_postal_addresses = edsf_persona_real_get_postal_addresses;
	iface->set_postal_addresses = edsf_persona_real_set_postal_addresses;
}


static void edsf_persona_folks_web_service_details_interface_init (FolksWebServiceDetailsIface * iface) {
	edsf_persona_folks_web_service_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_web_service_addresses = edsf_persona_real_get_web_service_addresses;
	iface->set_web_service_addresses = edsf_persona_real_set_web_service_addresses;
}


static void edsf_persona_instance_init (EdsfPersona * self) {
	GeeHashMultiMap* _tmp0_;
	self->priv = EDSF_PERSONA_GET_PRIVATE (self);
	self->priv->_avatar = NULL;
	_tmp0_ = gee_hash_multi_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, FOLKS_TYPE_IM_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, (GHashFunc) folks_abstract_field_details_hash, (GEqualFunc) folks_abstract_field_details_equal);
	self->priv->_im_addresses = _tmp0_;
}


static void edsf_persona_finalize (GObject* obj) {
	EdsfPersona * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	self = EDSF_PERSONA (obj);
	_tmp0_ = folks_persona_get_uid ((FolksPersona*) self);
	_tmp1_ = _tmp0_;
	g_debug ("edsf-persona.vala:565: Destroying Edsf.Persona '%s': %p", _tmp1_, self);
	_g_object_unref0 (self->priv->_phone_numbers);
	_g_object_unref0 (self->priv->_phone_numbers_ro);
	_g_object_unref0 (self->priv->_email_addresses);
	_g_object_unref0 (self->priv->_email_addresses_ro);
	_g_object_unref0 (self->priv->_notes);
	_g_object_unref0 (self->priv->_notes_ro);
	_g_object_unref0 (self->priv->_postal_addresses);
	_g_object_unref0 (self->priv->_postal_addresses_ro);
	_g_object_unref0 (self->priv->_local_ids);
	_g_object_unref0 (self->priv->_local_ids_ro);
	_g_object_unref0 (self->priv->_web_service_addresses);
	_g_object_unref0 (self->priv->_contact);
	_g_object_unref0 (self->priv->_avatar);
	_g_object_unref0 (self->priv->_structured_name);
	_g_free0 (self->priv->_contact_id);
	_g_free0 (self->priv->_full_name);
	_g_free0 (self->priv->_nickname);
	_g_object_unref0 (self->priv->_urls);
	_g_object_unref0 (self->priv->_urls_ro);
	_g_object_unref0 (self->priv->_im_addresses);
	_g_object_unref0 (self->priv->_groups);
	_g_object_unref0 (self->priv->_groups_ro);
	G_OBJECT_CLASS (edsf_persona_parent_class)->finalize (obj);
}


/**
 * A persona subclass which represents a single EDS contact.
 */
GType edsf_persona_get_type (void) {
	static volatile gsize edsf_persona_type_id__volatile = 0;
	if (g_once_init_enter (&edsf_persona_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (EdsfPersonaClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) edsf_persona_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EdsfPersona), 0, (GInstanceInitFunc) edsf_persona_instance_init, NULL };
		static const GInterfaceInfo folks_avatar_details_info = { (GInterfaceInitFunc) edsf_persona_folks_avatar_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_email_details_info = { (GInterfaceInitFunc) edsf_persona_folks_email_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_gender_details_info = { (GInterfaceInitFunc) edsf_persona_folks_gender_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_group_details_info = { (GInterfaceInitFunc) edsf_persona_folks_group_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_im_details_info = { (GInterfaceInitFunc) edsf_persona_folks_im_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_local_id_details_info = { (GInterfaceInitFunc) edsf_persona_folks_local_id_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_name_details_info = { (GInterfaceInitFunc) edsf_persona_folks_name_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_note_details_info = { (GInterfaceInitFunc) edsf_persona_folks_note_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_phone_details_info = { (GInterfaceInitFunc) edsf_persona_folks_phone_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_url_details_info = { (GInterfaceInitFunc) edsf_persona_folks_url_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_postal_address_details_info = { (GInterfaceInitFunc) edsf_persona_folks_postal_address_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_web_service_details_info = { (GInterfaceInitFunc) edsf_persona_folks_web_service_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType edsf_persona_type_id;
		edsf_persona_type_id = g_type_register_static (FOLKS_TYPE_PERSONA, "EdsfPersona", &g_define_type_info, 0);
		g_type_add_interface_static (edsf_persona_type_id, FOLKS_TYPE_AVATAR_DETAILS, &folks_avatar_details_info);
		g_type_add_interface_static (edsf_persona_type_id, FOLKS_TYPE_EMAIL_DETAILS, &folks_email_details_info);
		g_type_add_interface_static (edsf_persona_type_id, FOLKS_TYPE_GENDER_DETAILS, &folks_gender_details_info);
		g_type_add_interface_static (edsf_persona_type_id, FOLKS_TYPE_GROUP_DETAILS, &folks_group_details_info);
		g_type_add_interface_static (edsf_persona_type_id, FOLKS_TYPE_IM_DETAILS, &folks_im_details_info);
		g_type_add_interface_static (edsf_persona_type_id, FOLKS_TYPE_LOCAL_ID_DETAILS, &folks_local_id_details_info);
		g_type_add_interface_static (edsf_persona_type_id, FOLKS_TYPE_NAME_DETAILS, &folks_name_details_info);
		g_type_add_interface_static (edsf_persona_type_id, FOLKS_TYPE_NOTE_DETAILS, &folks_note_details_info);
		g_type_add_interface_static (edsf_persona_type_id, FOLKS_TYPE_PHONE_DETAILS, &folks_phone_details_info);
		g_type_add_interface_static (edsf_persona_type_id, FOLKS_TYPE_URL_DETAILS, &folks_url_details_info);
		g_type_add_interface_static (edsf_persona_type_id, FOLKS_TYPE_POSTAL_ADDRESS_DETAILS, &folks_postal_address_details_info);
		g_type_add_interface_static (edsf_persona_type_id, FOLKS_TYPE_WEB_SERVICE_DETAILS, &folks_web_service_details_info);
		g_once_init_leave (&edsf_persona_type_id__volatile, edsf_persona_type_id);
	}
	return edsf_persona_type_id__volatile;
}


static void _vala_edsf_persona_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	EdsfPersona * self;
	self = EDSF_PERSONA (object);
	switch (property_id) {
		case EDSF_PERSONA_CONTACT:
		g_value_set_object (value, edsf_persona_get_contact (self));
		break;
		case EDSF_PERSONA_WEB_SERVICE_ADDRESSES:
		g_value_set_object (value, folks_web_service_details_get_web_service_addresses ((FolksWebServiceDetails*) self));
		break;
		case EDSF_PERSONA_LOCAL_IDS:
		g_value_set_object (value, folks_local_id_details_get_local_ids ((FolksLocalIdDetails*) self));
		break;
		case EDSF_PERSONA_POSTAL_ADDRESSES:
		g_value_set_object (value, folks_postal_address_details_get_postal_addresses ((FolksPostalAddressDetails*) self));
		break;
		case EDSF_PERSONA_PHONE_NUMBERS:
		g_value_set_object (value, folks_phone_details_get_phone_numbers ((FolksPhoneDetails*) self));
		break;
		case EDSF_PERSONA_EMAIL_ADDRESSES:
		g_value_set_object (value, folks_email_details_get_email_addresses ((FolksEmailDetails*) self));
		break;
		case EDSF_PERSONA_NOTES:
		g_value_set_object (value, folks_note_details_get_notes ((FolksNoteDetails*) self));
		break;
		case EDSF_PERSONA_LINKABLE_PROPERTIES:
		{
			int length;
			g_value_set_boxed (value, folks_persona_get_linkable_properties ((FolksPersona*) self, &length));
		}
		break;
		case EDSF_PERSONA_WRITEABLE_PROPERTIES:
		{
			int length;
			g_value_set_boxed (value, folks_persona_get_writeable_properties ((FolksPersona*) self, &length));
		}
		break;
		case EDSF_PERSONA_AVATAR:
		g_value_set_object (value, folks_avatar_details_get_avatar ((FolksAvatarDetails*) self));
		break;
		case EDSF_PERSONA_STRUCTURED_NAME:
		g_value_set_object (value, folks_name_details_get_structured_name ((FolksNameDetails*) self));
		break;
		case EDSF_PERSONA_CONTACT_ID:
		g_value_set_string (value, edsf_persona_get_contact_id (self));
		break;
		case EDSF_PERSONA_FULL_NAME:
		g_value_set_string (value, folks_name_details_get_full_name ((FolksNameDetails*) self));
		break;
		case EDSF_PERSONA_NICKNAME:
		g_value_set_string (value, folks_name_details_get_nickname ((FolksNameDetails*) self));
		break;
		case EDSF_PERSONA_GENDER:
		g_value_set_enum (value, folks_gender_details_get_gender ((FolksGenderDetails*) self));
		break;
		case EDSF_PERSONA_URLS:
		g_value_set_object (value, folks_url_details_get_urls ((FolksUrlDetails*) self));
		break;
		case EDSF_PERSONA_IM_ADDRESSES:
		g_value_set_object (value, folks_im_details_get_im_addresses ((FolksImDetails*) self));
		break;
		case EDSF_PERSONA_GROUPS:
		g_value_set_object (value, folks_group_details_get_groups ((FolksGroupDetails*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_edsf_persona_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	EdsfPersona * self;
	self = EDSF_PERSONA (object);
	switch (property_id) {
		case EDSF_PERSONA_CONTACT:
		edsf_persona_set_contact (self, g_value_get_object (value));
		break;
		case EDSF_PERSONA_WEB_SERVICE_ADDRESSES:
		folks_web_service_details_set_web_service_addresses ((FolksWebServiceDetails*) self, g_value_get_object (value));
		break;
		case EDSF_PERSONA_LOCAL_IDS:
		folks_local_id_details_set_local_ids ((FolksLocalIdDetails*) self, g_value_get_object (value));
		break;
		case EDSF_PERSONA_POSTAL_ADDRESSES:
		folks_postal_address_details_set_postal_addresses ((FolksPostalAddressDetails*) self, g_value_get_object (value));
		break;
		case EDSF_PERSONA_PHONE_NUMBERS:
		folks_phone_details_set_phone_numbers ((FolksPhoneDetails*) self, g_value_get_object (value));
		break;
		case EDSF_PERSONA_EMAIL_ADDRESSES:
		folks_email_details_set_email_addresses ((FolksEmailDetails*) self, g_value_get_object (value));
		break;
		case EDSF_PERSONA_NOTES:
		folks_note_details_set_notes ((FolksNoteDetails*) self, g_value_get_object (value));
		break;
		case EDSF_PERSONA_AVATAR:
		folks_avatar_details_set_avatar ((FolksAvatarDetails*) self, g_value_get_object (value));
		break;
		case EDSF_PERSONA_STRUCTURED_NAME:
		folks_name_details_set_structured_name ((FolksNameDetails*) self, g_value_get_object (value));
		break;
		case EDSF_PERSONA_CONTACT_ID:
		edsf_persona_set_contact_id (self, g_value_get_string (value));
		break;
		case EDSF_PERSONA_FULL_NAME:
		folks_name_details_set_full_name ((FolksNameDetails*) self, g_value_get_string (value));
		break;
		case EDSF_PERSONA_NICKNAME:
		folks_name_details_set_nickname ((FolksNameDetails*) self, g_value_get_string (value));
		break;
		case EDSF_PERSONA_GENDER:
		folks_gender_details_set_gender ((FolksGenderDetails*) self, g_value_get_enum (value));
		break;
		case EDSF_PERSONA_URLS:
		folks_url_details_set_urls ((FolksUrlDetails*) self, g_value_get_object (value));
		break;
		case EDSF_PERSONA_IM_ADDRESSES:
		folks_im_details_set_im_addresses ((FolksImDetails*) self, g_value_get_object (value));
		break;
		case EDSF_PERSONA_GROUPS:
		folks_group_details_set_groups ((FolksGroupDetails*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



