/* note-details-interface.c generated by valac 0.12.0, the Vala compiler
 * generated from note-details-interface.vala, do not modify */

/*
 * Copyright (C) 2011 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Raul Gutierrez Segales <raul.gutierrez.segales@collabora.co.uk>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <folks-test.h>
#include <folks.h>
#include <tracker-test.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <folks-tracker.h>
#include <gio/gio.h>


#define TYPE_NOTE_DETAILS_INTERFACE_TESTS (note_details_interface_tests_get_type ())
#define NOTE_DETAILS_INTERFACE_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTE_DETAILS_INTERFACE_TESTS, NoteDetailsInterfaceTests))
#define NOTE_DETAILS_INTERFACE_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTE_DETAILS_INTERFACE_TESTS, NoteDetailsInterfaceTestsClass))
#define IS_NOTE_DETAILS_INTERFACE_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTE_DETAILS_INTERFACE_TESTS))
#define IS_NOTE_DETAILS_INTERFACE_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTE_DETAILS_INTERFACE_TESTS))
#define NOTE_DETAILS_INTERFACE_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTE_DETAILS_INTERFACE_TESTS, NoteDetailsInterfaceTestsClass))

typedef struct _NoteDetailsInterfaceTests NoteDetailsInterfaceTests;
typedef struct _NoteDetailsInterfaceTestsClass NoteDetailsInterfaceTestsClass;
typedef struct _NoteDetailsInterfaceTestsPrivate NoteDetailsInterfaceTestsPrivate;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _tracker_test_backend_unref0(var) ((var == NULL) ? NULL : (var = (tracker_test_backend_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _NoteDetailsInterfaceTestsTestNoteDetailsInterfaceAsyncData NoteDetailsInterfaceTestsTestNoteDetailsInterfaceAsyncData;

struct _NoteDetailsInterfaceTests {
	FolksTestCase parent_instance;
	NoteDetailsInterfaceTestsPrivate * priv;
};

struct _NoteDetailsInterfaceTestsClass {
	FolksTestCaseClass parent_class;
};

struct _NoteDetailsInterfaceTestsPrivate {
	GMainLoop* _main_loop;
	FolksIndividualAggregator* _aggregator;
	TrackerTestBackend* _tracker_backend;
	gboolean _found_note;
	gchar* _note;
	gchar* _fullname;
};

struct _NoteDetailsInterfaceTestsTestNoteDetailsInterfaceAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	NoteDetailsInterfaceTests* self;
	FolksBackendStore* _tmp0_;
	FolksBackendStore* store;
	FolksIndividualAggregator* _tmp1_;
	GError * e;
	GError * _inner_error_;
};


static gpointer note_details_interface_tests_parent_class = NULL;

GType note_details_interface_tests_get_type (void) G_GNUC_CONST;
#define NOTE_DETAILS_INTERFACE_TESTS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_NOTE_DETAILS_INTERFACE_TESTS, NoteDetailsInterfaceTestsPrivate))
enum  {
	NOTE_DETAILS_INTERFACE_TESTS_DUMMY_PROPERTY
};
NoteDetailsInterfaceTests* note_details_interface_tests_new (void);
NoteDetailsInterfaceTests* note_details_interface_tests_construct (GType object_type);
void note_details_interface_tests_test_note_details_interface (NoteDetailsInterfaceTests* self);
static void _note_details_interface_tests_test_note_details_interface_folks_test_case_test_method (gpointer self);
static void note_details_interface_tests_real_set_up (FolksTestCase* base);
static void note_details_interface_tests_real_tear_down (FolksTestCase* base);
static void _note_details_interface_tests_test_note_details_interface_async (NoteDetailsInterfaceTests* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void _note_details_interface_tests_test_note_details_interface_finish (NoteDetailsInterfaceTests* self, GAsyncResult* _res_);
static gboolean _lambda0_ (NoteDetailsInterfaceTests* self);
static gboolean __lambda0__gsource_func (gpointer self);
static void _note_details_interface_tests_test_note_details_interface_async_data_free (gpointer _data);
static gboolean _note_details_interface_tests_test_note_details_interface_async_co (NoteDetailsInterfaceTestsTestNoteDetailsInterfaceAsyncData* data);
static void _note_details_interface_tests_test_note_details_interface_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _note_details_interface_tests_individuals_changed_cb (NoteDetailsInterfaceTests* self, GList* added, GList* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason);
static void __note_details_interface_tests_individuals_changed_cb_folks_individual_aggregator_individuals_changed (FolksIndividualAggregator* _sender, GList* added, GList* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason, gpointer self);
static void _note_details_interface_tests_notify_note_cb (NoteDetailsInterfaceTests* self, GObject* individual_obj, GParamSpec* ps);
static void __note_details_interface_tests_notify_note_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void note_details_interface_tests_finalize (GObject* obj);
gint _vala_main (gchar** args, int args_length1);


static void _note_details_interface_tests_test_note_details_interface_folks_test_case_test_method (gpointer self) {
	note_details_interface_tests_test_note_details_interface (self);
}


NoteDetailsInterfaceTests* note_details_interface_tests_construct (GType object_type) {
	NoteDetailsInterfaceTests * self = NULL;
	TrackerTestBackend* _tmp0_ = NULL;
	self = (NoteDetailsInterfaceTests*) folks_test_case_construct (object_type, "NoteDetailsInterfaceTests");
	_tmp0_ = tracker_test_backend_new ();
	_tracker_test_backend_unref0 (self->priv->_tracker_backend);
	self->priv->_tracker_backend = _tmp0_;
	tracker_test_backend_set_debug (self->priv->_tracker_backend, FALSE);
	folks_test_case_add_test ((FolksTestCase*) self, "test note details interface", _note_details_interface_tests_test_note_details_interface_folks_test_case_test_method, self);
	return self;
}


NoteDetailsInterfaceTests* note_details_interface_tests_new (void) {
	return note_details_interface_tests_construct (TYPE_NOTE_DETAILS_INTERFACE_TESTS);
}


static void note_details_interface_tests_real_set_up (FolksTestCase* base) {
	NoteDetailsInterfaceTests * self;
	self = (NoteDetailsInterfaceTests*) base;
}


static void note_details_interface_tests_real_tear_down (FolksTestCase* base) {
	NoteDetailsInterfaceTests * self;
	self = (NoteDetailsInterfaceTests*) base;
}


static gboolean _lambda0_ (NoteDetailsInterfaceTests* self) {
	gboolean result = FALSE;
	g_main_loop_quit (self->priv->_main_loop);
	g_assert_not_reached ();
	return result;
}


static gboolean __lambda0__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda0_ (self);
	return result;
}


void note_details_interface_tests_test_note_details_interface (NoteDetailsInterfaceTests* self) {
	GMainLoop* _tmp0_ = NULL;
	GeeHashMap* _tmp1_ = NULL;
	GeeHashMap* c1;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_main_loop_new (NULL, FALSE);
	_g_main_loop_unref0 (self->priv->_main_loop);
	self->priv->_main_loop = _tmp0_;
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	c1 = _tmp1_;
	_tmp2_ = g_strdup ("persona #1");
	_g_free0 (self->priv->_fullname);
	self->priv->_fullname = _tmp2_;
	_tmp3_ = g_strdup ("this is a note");
	_g_free0 (self->priv->_note);
	self->priv->_note = _tmp3_;
	gee_abstract_map_set ((GeeAbstractMap*) c1, TRF_ONTOLOGY_DEFS_NCO_FULLNAME, self->priv->_fullname);
	gee_abstract_map_set ((GeeAbstractMap*) c1, TRF_ONTOLOGY_DEFS_NCO_NOTE, self->priv->_note);
	tracker_test_backend_add_contact (self->priv->_tracker_backend, c1);
	tracker_test_backend_set_up (self->priv->_tracker_backend);
	self->priv->_found_note = FALSE;
	_note_details_interface_tests_test_note_details_interface_async (self, NULL, NULL);
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 5, __lambda0__gsource_func, g_object_ref (self), g_object_unref);
	g_main_loop_run (self->priv->_main_loop);
	g_assert (self->priv->_found_note == TRUE);
	tracker_test_backend_tear_down (self->priv->_tracker_backend);
	_g_object_unref0 (c1);
}


static void _note_details_interface_tests_test_note_details_interface_async_data_free (gpointer _data) {
	NoteDetailsInterfaceTestsTestNoteDetailsInterfaceAsyncData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (NoteDetailsInterfaceTestsTestNoteDetailsInterfaceAsyncData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _note_details_interface_tests_test_note_details_interface_async (NoteDetailsInterfaceTests* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	NoteDetailsInterfaceTestsTestNoteDetailsInterfaceAsyncData* _data_;
	_data_ = g_slice_new0 (NoteDetailsInterfaceTestsTestNoteDetailsInterfaceAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _note_details_interface_tests_test_note_details_interface_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _note_details_interface_tests_test_note_details_interface_async_data_free);
	_data_->self = _g_object_ref0 (self);
	_note_details_interface_tests_test_note_details_interface_async_co (_data_);
}


static void _note_details_interface_tests_test_note_details_interface_finish (NoteDetailsInterfaceTests* self, GAsyncResult* _res_) {
	NoteDetailsInterfaceTestsTestNoteDetailsInterfaceAsyncData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void _note_details_interface_tests_test_note_details_interface_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	NoteDetailsInterfaceTestsTestNoteDetailsInterfaceAsyncData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	_note_details_interface_tests_test_note_details_interface_async_co (data);
}


static void __note_details_interface_tests_individuals_changed_cb_folks_individual_aggregator_individuals_changed (FolksIndividualAggregator* _sender, GList* added, GList* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason, gpointer self) {
	_note_details_interface_tests_individuals_changed_cb (self, added, removed, message, actor, reason);
}


static gboolean _note_details_interface_tests_test_note_details_interface_async_co (NoteDetailsInterfaceTestsTestNoteDetailsInterfaceAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = folks_backend_store_dup ();
	data->store = data->_tmp0_;
	data->_state_ = 1;
	folks_backend_store_prepare (data->store, _note_details_interface_tests_test_note_details_interface_async_ready, data);
	return FALSE;
	_state_1:
	folks_backend_store_prepare_finish (data->store, data->_res_);
	data->_tmp1_ = NULL;
	data->_tmp1_ = folks_individual_aggregator_new ();
	_g_object_unref0 (data->self->priv->_aggregator);
	data->self->priv->_aggregator = data->_tmp1_;
	g_signal_connect_object (data->self->priv->_aggregator, "individuals-changed", (GCallback) __note_details_interface_tests_individuals_changed_cb_folks_individual_aggregator_individuals_changed, data->self, 0);
	data->_state_ = 2;
	folks_individual_aggregator_prepare (data->self->priv->_aggregator, _note_details_interface_tests_test_note_details_interface_async_ready, data);
	return FALSE;
	_state_2:
	folks_individual_aggregator_prepare_finish (data->self->priv->_aggregator, data->_res_, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		goto __catch0_g_error;
	}
	goto __finally0;
	__catch0_g_error:
	{
		data->e = data->_inner_error_;
		data->_inner_error_ = NULL;
		g_warning ("note-details-interface.vala:97: Error when calling prepare: %s\n", data->e->message);
		_g_error_free0 (data->e);
	}
	__finally0:
	if (data->_inner_error_ != NULL) {
		_g_object_unref0 (data->store);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	_g_object_unref0 (data->store);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void __note_details_interface_tests_notify_note_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_note_details_interface_tests_notify_note_cb (self, _sender, pspec);
}


static void _note_details_interface_tests_individuals_changed_cb (NoteDetailsInterfaceTests* self, GList* added, GList* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason) {
	g_return_if_fail (self != NULL);
	{
		GList* i_collection;
		GList* i_it;
		i_collection = added;
		for (i_it = i_collection; i_it != NULL; i_it = i_it->next) {
			FolksIndividual* i;
			i = (FolksIndividual*) i_it->data;
			{
				const gchar* _tmp0_ = NULL;
				_tmp0_ = folks_name_details_get_full_name ((FolksNameDetails*) i);
				if (g_strcmp0 (_tmp0_, self->priv->_fullname) == 0) {
					g_signal_connect_object ((GObject*) i, "notify::notes", (GCallback) __note_details_interface_tests_notify_note_cb_g_object_notify, self, 0);
					{
						GeeHashSet* _tmp1_ = NULL;
						GeeIterator* _tmp2_ = NULL;
						GeeIterator* _n_it;
						_tmp1_ = folks_note_details_get_notes ((FolksNoteDetails*) i);
						_tmp2_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp1_);
						_n_it = _tmp2_;
						while (TRUE) {
							gboolean _tmp3_;
							gpointer _tmp4_ = NULL;
							FolksNote* n;
							const gchar* _tmp5_ = NULL;
							_tmp3_ = gee_iterator_next (_n_it);
							if (!_tmp3_) {
								break;
							}
							_tmp4_ = gee_iterator_get (_n_it);
							n = (FolksNote*) _tmp4_;
							_tmp5_ = folks_note_get_content (n);
							if (g_strcmp0 (_tmp5_, self->priv->_note) == 0) {
								self->priv->_found_note = TRUE;
								g_main_loop_quit (self->priv->_main_loop);
							}
							_g_object_unref0 (n);
						}
						_g_object_unref0 (_n_it);
					}
				}
			}
		}
	}
	g_assert (removed == NULL);
}


static void _note_details_interface_tests_notify_note_cb (NoteDetailsInterfaceTests* self, GObject* individual_obj, GParamSpec* ps) {
	FolksIndividual* _tmp0_;
	FolksIndividual* individual;
	g_return_if_fail (self != NULL);
	g_return_if_fail (individual_obj != NULL);
	g_return_if_fail (ps != NULL);
	_tmp0_ = _g_object_ref0 (FOLKS_INDIVIDUAL (individual_obj));
	individual = _tmp0_;
	{
		GeeHashSet* _tmp1_ = NULL;
		GeeIterator* _tmp2_ = NULL;
		GeeIterator* _n_it;
		_tmp1_ = folks_note_details_get_notes ((FolksNoteDetails*) individual);
		_tmp2_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp1_);
		_n_it = _tmp2_;
		while (TRUE) {
			gboolean _tmp3_;
			gpointer _tmp4_ = NULL;
			FolksNote* n;
			const gchar* _tmp5_ = NULL;
			_tmp3_ = gee_iterator_next (_n_it);
			if (!_tmp3_) {
				break;
			}
			_tmp4_ = gee_iterator_get (_n_it);
			n = (FolksNote*) _tmp4_;
			_tmp5_ = folks_note_get_content (n);
			if (g_strcmp0 (_tmp5_, self->priv->_note) == 0) {
				self->priv->_found_note = TRUE;
				g_main_loop_quit (self->priv->_main_loop);
			}
			_g_object_unref0 (n);
		}
		_g_object_unref0 (_n_it);
	}
	_g_object_unref0 (individual);
}


static void note_details_interface_tests_class_init (NoteDetailsInterfaceTestsClass * klass) {
	note_details_interface_tests_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (NoteDetailsInterfaceTestsPrivate));
	FOLKS_TEST_CASE_CLASS (klass)->set_up = note_details_interface_tests_real_set_up;
	FOLKS_TEST_CASE_CLASS (klass)->tear_down = note_details_interface_tests_real_tear_down;
	G_OBJECT_CLASS (klass)->finalize = note_details_interface_tests_finalize;
}


static void note_details_interface_tests_instance_init (NoteDetailsInterfaceTests * self) {
	gchar* _tmp0_;
	self->priv = NOTE_DETAILS_INTERFACE_TESTS_GET_PRIVATE (self);
	_tmp0_ = g_strdup ("persona #1");
	self->priv->_fullname = _tmp0_;
}


static void note_details_interface_tests_finalize (GObject* obj) {
	NoteDetailsInterfaceTests * self;
	self = NOTE_DETAILS_INTERFACE_TESTS (obj);
	_g_main_loop_unref0 (self->priv->_main_loop);
	_g_object_unref0 (self->priv->_aggregator);
	_tracker_test_backend_unref0 (self->priv->_tracker_backend);
	_g_free0 (self->priv->_note);
	_g_free0 (self->priv->_fullname);
	G_OBJECT_CLASS (note_details_interface_tests_parent_class)->finalize (obj);
}


GType note_details_interface_tests_get_type (void) {
	static volatile gsize note_details_interface_tests_type_id__volatile = 0;
	if (g_once_init_enter (&note_details_interface_tests_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NoteDetailsInterfaceTestsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) note_details_interface_tests_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NoteDetailsInterfaceTests), 0, (GInstanceInitFunc) note_details_interface_tests_instance_init, NULL };
		GType note_details_interface_tests_type_id;
		note_details_interface_tests_type_id = g_type_register_static (FOLKS_TYPE_TEST_CASE, "NoteDetailsInterfaceTests", &g_define_type_info, 0);
		g_once_init_leave (&note_details_interface_tests_type_id__volatile, note_details_interface_tests_type_id);
	}
	return note_details_interface_tests_type_id__volatile;
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	GTestSuite* _tmp0_ = NULL;
	GTestSuite* root;
	NoteDetailsInterfaceTests* _tmp1_ = NULL;
	NoteDetailsInterfaceTests* _tmp2_;
	GTestSuite* _tmp3_ = NULL;
	g_test_init (&args_length1, &args, NULL);
	_tmp0_ = g_test_get_root ();
	root = _tmp0_;
	_tmp1_ = note_details_interface_tests_new ();
	_tmp2_ = _tmp1_;
	_tmp3_ = folks_test_case_get_suite ((FolksTestCase*) _tmp2_);
	g_test_suite_add_suite (root, _tmp3_);
	_g_object_unref0 (_tmp2_);
	g_test_run ();
	result = 0;
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return _vala_main (argv, argc);
}



