/* tr-backend.c generated by valac 0.12.0, the Vala compiler
 * generated from tr-backend.vala, do not modify */

/*
 * Copyright (C) 2011 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Travis Reitter <travis.reitter@collabora.co.uk>
 *       Raul Gutierrez Segales <raul.gutierrez.segales@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <folks.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <folks-tracker.h>


#define FOLKS_BACKENDS_TR_TYPE_BACKEND (folks_backends_tr_backend_get_type ())
#define FOLKS_BACKENDS_TR_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_BACKENDS_TR_TYPE_BACKEND, FolksBackendsTrBackend))
#define FOLKS_BACKENDS_TR_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_BACKENDS_TR_TYPE_BACKEND, FolksBackendsTrBackendClass))
#define FOLKS_BACKENDS_TR_IS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_BACKENDS_TR_TYPE_BACKEND))
#define FOLKS_BACKENDS_TR_IS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_BACKENDS_TR_TYPE_BACKEND))
#define FOLKS_BACKENDS_TR_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_BACKENDS_TR_TYPE_BACKEND, FolksBackendsTrBackendClass))

typedef struct _FolksBackendsTrBackend FolksBackendsTrBackend;
typedef struct _FolksBackendsTrBackendClass FolksBackendsTrBackendClass;
typedef struct _FolksBackendsTrBackendPrivate FolksBackendsTrBackendPrivate;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _FolksBackendsTrBackendPrepareData FolksBackendsTrBackendPrepareData;
typedef struct _FolksBackendsTrBackendUnprepareData FolksBackendsTrBackendUnprepareData;

struct _FolksBackendsTrBackend {
	FolksBackend parent_instance;
	FolksBackendsTrBackendPrivate * priv;
};

struct _FolksBackendsTrBackendClass {
	FolksBackendClass parent_class;
};

struct _FolksBackendsTrBackendPrivate {
	gboolean _is_prepared;
	GStaticRecMutex __lock__is_prepared;
	GHashTable* _persona_stores;
};

struct _FolksBackendsTrBackendPrepareData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksBackendsTrBackend* self;
	GError * _inner_error_;
};

struct _FolksBackendsTrBackendUnprepareData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksBackendsTrBackend* self;
};


static gpointer folks_backends_tr_backend_parent_class = NULL;

GType folks_backends_tr_backend_get_type (void) G_GNUC_CONST;
#define FOLKS_BACKENDS_TR_BACKEND_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FOLKS_BACKENDS_TR_TYPE_BACKEND, FolksBackendsTrBackendPrivate))
enum  {
	FOLKS_BACKENDS_TR_BACKEND_DUMMY_PROPERTY,
	FOLKS_BACKENDS_TR_BACKEND_NAME,
	FOLKS_BACKENDS_TR_BACKEND_PERSONA_STORES,
	FOLKS_BACKENDS_TR_BACKEND_IS_PREPARED
};
FolksBackendsTrBackend* folks_backends_tr_backend_new (void);
FolksBackendsTrBackend* folks_backends_tr_backend_construct (GType object_type);
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
static void folks_backends_tr_backend_real_prepare_data_free (gpointer _data);
static void folks_backends_tr_backend_real_prepare (FolksBackend* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean folks_backends_tr_backend_real_prepare_co (FolksBackendsTrBackendPrepareData* data);
static void _folks_backends_tr_backend_add_default_persona_store (FolksBackendsTrBackend* self);
static void folks_backends_tr_backend_real_unprepare_data_free (gpointer _data);
static void folks_backends_tr_backend_real_unprepare (FolksBackend* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean folks_backends_tr_backend_real_unprepare_co (FolksBackendsTrBackendUnprepareData* data);
static void _lambda0_ (const gchar* k, FolksPersonaStore* v, FolksBackendsTrBackend* self);
static void __lambda0__gh_func (gconstpointer key, gconstpointer value, gpointer self);
static void _folks_backends_tr_backend_store_removed_cb (FolksBackendsTrBackend* self, FolksPersonaStore* store);
static void __folks_backends_tr_backend_store_removed_cb_folks_persona_store_removed (FolksPersonaStore* _sender, gpointer self);
static void folks_backends_tr_backend_finalize (GObject* obj);
static void _vala_folks_backends_tr_backend_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);


/**
   * {@inheritDoc}
   */
static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


FolksBackendsTrBackend* folks_backends_tr_backend_construct (GType object_type) {
	FolksBackendsTrBackend * self = NULL;
	GHashTable* _tmp0_ = NULL;
	self = (FolksBackendsTrBackend*) folks_backend_construct (object_type);
	_tmp0_ = g_hash_table_new_full (g_str_hash, g_str_equal, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->_persona_stores);
	self->priv->_persona_stores = _tmp0_;
	return self;
}


FolksBackendsTrBackend* folks_backends_tr_backend_new (void) {
	return folks_backends_tr_backend_construct (FOLKS_BACKENDS_TR_TYPE_BACKEND);
}


static void folks_backends_tr_backend_real_prepare_data_free (gpointer _data) {
	FolksBackendsTrBackendPrepareData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (FolksBackendsTrBackendPrepareData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void folks_backends_tr_backend_real_prepare (FolksBackend* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksBackendsTrBackend * self;
	FolksBackendsTrBackendPrepareData* _data_;
	self = (FolksBackendsTrBackend*) base;
	_data_ = g_slice_new0 (FolksBackendsTrBackendPrepareData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_backends_tr_backend_real_prepare);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_backends_tr_backend_real_prepare_data_free);
	_data_->self = _g_object_ref0 (self);
	folks_backends_tr_backend_real_prepare_co (_data_);
}


static void folks_backends_tr_backend_real_prepare_finish (FolksBackend* base, GAsyncResult* _res_, GError** error) {
	FolksBackendsTrBackendPrepareData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * {@inheritDoc}
   *
   */
static gboolean folks_backends_tr_backend_real_prepare_co (FolksBackendsTrBackendPrepareData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		g_static_rec_mutex_lock (&data->self->priv->__lock__is_prepared);
		if (!data->self->priv->_is_prepared) {
			_folks_backends_tr_backend_add_default_persona_store (data->self);
			data->self->priv->_is_prepared = TRUE;
			g_object_notify ((GObject*) data->self, "is-prepared");
		}
		__finally0:
		g_static_rec_mutex_unlock (&data->self->priv->__lock__is_prepared);
		if (data->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void folks_backends_tr_backend_real_unprepare_data_free (gpointer _data) {
	FolksBackendsTrBackendUnprepareData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (FolksBackendsTrBackendUnprepareData, data);
}


static void folks_backends_tr_backend_real_unprepare (FolksBackend* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksBackendsTrBackend * self;
	FolksBackendsTrBackendUnprepareData* _data_;
	self = (FolksBackendsTrBackend*) base;
	_data_ = g_slice_new0 (FolksBackendsTrBackendUnprepareData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_backends_tr_backend_real_unprepare);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_backends_tr_backend_real_unprepare_data_free);
	_data_->self = _g_object_ref0 (self);
	folks_backends_tr_backend_real_unprepare_co (_data_);
}


static void folks_backends_tr_backend_real_unprepare_finish (FolksBackend* base, GAsyncResult* _res_, GError** error) {
	FolksBackendsTrBackendUnprepareData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * {@inheritDoc}
   */
static void _lambda0_ (const gchar* k, FolksPersonaStore* v, FolksBackendsTrBackend* self) {
	g_return_if_fail (k != NULL);
	g_return_if_fail (v != NULL);
	g_signal_emit_by_name ((FolksBackend*) self, "persona-store-removed", FOLKS_PERSONA_STORE (v));
}


static void __lambda0__gh_func (gconstpointer key, gconstpointer value, gpointer self) {
	_lambda0_ (key, value, self);
}


static gboolean folks_backends_tr_backend_real_unprepare_co (FolksBackendsTrBackendUnprepareData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_hash_table_foreach (data->self->priv->_persona_stores, __lambda0__gh_func, data->self);
	g_hash_table_remove_all (data->self->priv->_persona_stores);
	g_object_notify ((GObject*) data->self, "persona-stores");
	data->self->priv->_is_prepared = FALSE;
	g_object_notify ((GObject*) data->self, "is-prepared");
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


/**
   * Add a the default Persona Store.
   */
static void __folks_backends_tr_backend_store_removed_cb_folks_persona_store_removed (FolksPersonaStore* _sender, gpointer self) {
	_folks_backends_tr_backend_store_removed_cb (self, _sender);
}


static void _folks_backends_tr_backend_add_default_persona_store (FolksBackendsTrBackend* self) {
	TrfPersonaStore* _tmp0_ = NULL;
	TrfPersonaStore* store;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	FolksPersonaStore* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = trf_persona_store_new ();
	store = _tmp0_;
	_tmp1_ = folks_persona_store_get_id ((FolksPersonaStore*) store);
	_tmp2_ = g_strdup (_tmp1_);
	_tmp3_ = _g_object_ref0 ((FolksPersonaStore*) store);
	g_hash_table_insert (self->priv->_persona_stores, _tmp2_, _tmp3_);
	g_signal_connect_object ((FolksPersonaStore*) store, "removed", (GCallback) __folks_backends_tr_backend_store_removed_cb_folks_persona_store_removed, self, 0);
	g_object_notify ((GObject*) self, "persona-stores");
	g_signal_emit_by_name ((FolksBackend*) self, "persona-store-added", (FolksPersonaStore*) store);
	_g_object_unref0 (store);
}


static void _folks_backends_tr_backend_store_removed_cb (FolksBackendsTrBackend* self, FolksPersonaStore* store) {
	GHashTable* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (store != NULL);
	g_signal_emit_by_name ((FolksBackend*) self, "persona-store-removed", store);
	_tmp0_ = folks_backend_get_persona_stores ((FolksBackend*) self);
	_tmp1_ = folks_persona_store_get_id (store);
	g_hash_table_remove (_tmp0_, _tmp1_);
}


static const gchar* folks_backends_tr_backend_real_get_name (FolksBackend* base) {
	const gchar* result;
	FolksBackendsTrBackend* self;
	self = (FolksBackendsTrBackend*) base;
	result = BACKEND_NAME;
	return result;
}


static GHashTable* folks_backends_tr_backend_real_get_persona_stores (FolksBackend* base) {
	GHashTable* result;
	FolksBackendsTrBackend* self;
	self = (FolksBackendsTrBackend*) base;
	result = self->priv->_persona_stores;
	return result;
}


static gboolean folks_backends_tr_backend_real_get_is_prepared (FolksBackend* base) {
	gboolean result;
	FolksBackendsTrBackend* self;
	self = (FolksBackendsTrBackend*) base;
	result = self->priv->_is_prepared;
	return result;
}


static void folks_backends_tr_backend_class_init (FolksBackendsTrBackendClass * klass) {
	folks_backends_tr_backend_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FolksBackendsTrBackendPrivate));
	FOLKS_BACKEND_CLASS (klass)->prepare = folks_backends_tr_backend_real_prepare;
	FOLKS_BACKEND_CLASS (klass)->prepare_finish = folks_backends_tr_backend_real_prepare_finish;
	FOLKS_BACKEND_CLASS (klass)->unprepare = folks_backends_tr_backend_real_unprepare;
	FOLKS_BACKEND_CLASS (klass)->unprepare_finish = folks_backends_tr_backend_real_unprepare_finish;
	FOLKS_BACKEND_CLASS (klass)->get_name = folks_backends_tr_backend_real_get_name;
	FOLKS_BACKEND_CLASS (klass)->get_persona_stores = folks_backends_tr_backend_real_get_persona_stores;
	FOLKS_BACKEND_CLASS (klass)->get_is_prepared = folks_backends_tr_backend_real_get_is_prepared;
	G_OBJECT_CLASS (klass)->get_property = _vala_folks_backends_tr_backend_get_property;
	G_OBJECT_CLASS (klass)->finalize = folks_backends_tr_backend_finalize;
	/**
	   * {@inheritDoc}
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_TR_BACKEND_NAME, "name");
	/**
	   * {@inheritDoc}
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_TR_BACKEND_PERSONA_STORES, "persona-stores");
	/**
	   * Whether this Backend has been prepared.
	   *
	   * See {@link Folks.Backend.is_prepared}.
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_TR_BACKEND_IS_PREPARED, "is-prepared");
}


static void folks_backends_tr_backend_instance_init (FolksBackendsTrBackend * self) {
	self->priv = FOLKS_BACKENDS_TR_BACKEND_GET_PRIVATE (self);
	g_static_rec_mutex_init (&self->priv->__lock__is_prepared);
	self->priv->_is_prepared = FALSE;
}


static void folks_backends_tr_backend_finalize (GObject* obj) {
	FolksBackendsTrBackend * self;
	self = FOLKS_BACKENDS_TR_BACKEND (obj);
	g_static_rec_mutex_free (&self->priv->__lock__is_prepared);
	_g_hash_table_unref0 (self->priv->_persona_stores);
	G_OBJECT_CLASS (folks_backends_tr_backend_parent_class)->finalize (obj);
}


/**
 * A backend which connects to Tracker and creates a {@link PersonaStore}
 * for each service.
 */
GType folks_backends_tr_backend_get_type (void) {
	static volatile gsize folks_backends_tr_backend_type_id__volatile = 0;
	if (g_once_init_enter (&folks_backends_tr_backend_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksBackendsTrBackendClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_backends_tr_backend_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksBackendsTrBackend), 0, (GInstanceInitFunc) folks_backends_tr_backend_instance_init, NULL };
		GType folks_backends_tr_backend_type_id;
		folks_backends_tr_backend_type_id = g_type_register_static (FOLKS_TYPE_BACKEND, "FolksBackendsTrBackend", &g_define_type_info, 0);
		g_once_init_leave (&folks_backends_tr_backend_type_id__volatile, folks_backends_tr_backend_type_id);
	}
	return folks_backends_tr_backend_type_id__volatile;
}


static void _vala_folks_backends_tr_backend_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	FolksBackendsTrBackend * self;
	self = FOLKS_BACKENDS_TR_BACKEND (object);
	switch (property_id) {
		case FOLKS_BACKENDS_TR_BACKEND_NAME:
		g_value_set_string (value, folks_backend_get_name ((FolksBackend*) self));
		break;
		case FOLKS_BACKENDS_TR_BACKEND_PERSONA_STORES:
		g_value_set_boxed (value, folks_backend_get_persona_stores ((FolksBackend*) self));
		break;
		case FOLKS_BACKENDS_TR_BACKEND_IS_PREPARED:
		g_value_set_boolean (value, folks_backend_get_is_prepared ((FolksBackend*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



