/* utils.c generated by valac 0.11.6, the Vala compiler
 * generated from utils.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Philip Withnall <philip.withnall@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <folks.h>
#include <stdarg.h>
#include <stdio.h>
#include <gio/gio.h>
#include <gobject/gvaluecollector.h>


#define FOLKS_INSPECT_TYPE_UTILS (folks_inspect_utils_get_type ())
#define FOLKS_INSPECT_UTILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_INSPECT_TYPE_UTILS, FolksInspectUtils))
#define FOLKS_INSPECT_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_INSPECT_TYPE_UTILS, FolksInspectUtilsClass))
#define FOLKS_INSPECT_IS_UTILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_INSPECT_TYPE_UTILS))
#define FOLKS_INSPECT_IS_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_INSPECT_TYPE_UTILS))
#define FOLKS_INSPECT_UTILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_INSPECT_TYPE_UTILS, FolksInspectUtilsClass))

typedef struct _FolksInspectUtils FolksInspectUtils;
typedef struct _FolksInspectUtilsClass FolksInspectUtilsClass;
typedef struct _FolksInspectUtilsPrivate FolksInspectUtilsPrivate;

#define FOLKS_INSPECT_TYPE_COMMAND (folks_inspect_command_get_type ())
#define FOLKS_INSPECT_COMMAND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_INSPECT_TYPE_COMMAND, FolksInspectCommand))
#define FOLKS_INSPECT_COMMAND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_INSPECT_TYPE_COMMAND, FolksInspectCommandClass))
#define FOLKS_INSPECT_IS_COMMAND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_INSPECT_TYPE_COMMAND))
#define FOLKS_INSPECT_IS_COMMAND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_INSPECT_TYPE_COMMAND))
#define FOLKS_INSPECT_COMMAND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_INSPECT_TYPE_COMMAND, FolksInspectCommandClass))

typedef struct _FolksInspectCommand FolksInspectCommand;
typedef struct _FolksInspectCommandClass FolksInspectCommandClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block2Data Block2Data;
typedef struct _Block3Data Block3Data;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _Block4Data Block4Data;
typedef struct _Block5Data Block5Data;
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))

#define FOLKS_INSPECT_TYPE_CLIENT (folks_inspect_client_get_type ())
#define FOLKS_INSPECT_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_INSPECT_TYPE_CLIENT, FolksInspectClient))
#define FOLKS_INSPECT_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_INSPECT_TYPE_CLIENT, FolksInspectClientClass))
#define FOLKS_INSPECT_IS_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_INSPECT_TYPE_CLIENT))
#define FOLKS_INSPECT_IS_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_INSPECT_TYPE_CLIENT))
#define FOLKS_INSPECT_CLIENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_INSPECT_TYPE_CLIENT, FolksInspectClientClass))

typedef struct _FolksInspectClient FolksInspectClient;
typedef struct _FolksInspectClientClass FolksInspectClientClass;
typedef struct _FolksInspectClientPrivate FolksInspectClientPrivate;
typedef struct _FolksInspectParamSpecUtils FolksInspectParamSpecUtils;

struct _FolksInspectUtils {
	GTypeInstance parent_instance;
	volatile int ref_count;
	FolksInspectUtilsPrivate * priv;
};

struct _FolksInspectUtilsClass {
	GTypeClass parent_class;
	void (*finalize) (FolksInspectUtils *self);
};

struct _Block2Data {
	int _ref_count_;
	gchar* output_string;
};

struct _Block3Data {
	int _ref_count_;
	Block2Data * _data2_;
	gboolean first;
};

struct _Block4Data {
	int _ref_count_;
	Block2Data * _data2_;
	gboolean first;
};

struct _Block5Data {
	int _ref_count_;
	Block4Data * _data4_;
	gboolean _first;
};

struct _FolksInspectClient {
	GObject parent_instance;
	FolksInspectClientPrivate * priv;
	GeeHashMap* commands;
};

struct _FolksInspectClientClass {
	GObjectClass parent_class;
};

struct _FolksInspectParamSpecUtils {
	GParamSpec parent_instance;
};


static gpointer folks_inspect_utils_parent_class = NULL;
static guint folks_inspect_utils_indentation;
static guint folks_inspect_utils_indentation = (guint) 0;
static gchar* folks_inspect_utils_indentation_string;
static gchar* folks_inspect_utils_indentation_string = NULL;
static GeeMapIterator* folks_inspect_utils_command_name_iter;
static GeeMapIterator* folks_inspect_utils_command_name_iter = NULL;
static GHashTableIter* folks_inspect_utils_individual_id_iter;
static GHashTableIter* folks_inspect_utils_individual_id_iter = NULL;
static GList* folks_inspect_utils_persona_uid_iter;
static GList* folks_inspect_utils_persona_uid_iter = NULL;
static GeeIterator* folks_inspect_utils_backend_name_iter;
static GeeIterator* folks_inspect_utils_backend_name_iter = NULL;
static GHashTableIter* folks_inspect_utils_persona_store_id_iter;
static GHashTableIter* folks_inspect_utils_persona_store_id_iter = NULL;
extern FolksInspectClient* main_client;

gpointer folks_inspect_utils_ref (gpointer instance);
void folks_inspect_utils_unref (gpointer instance);
GParamSpec* folks_inspect_param_spec_utils (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void folks_inspect_value_set_utils (GValue* value, gpointer v_object);
void folks_inspect_value_take_utils (GValue* value, gpointer v_object);
gpointer folks_inspect_value_get_utils (const GValue* value);
GType folks_inspect_utils_get_type (void) G_GNUC_CONST;
enum  {
	FOLKS_INSPECT_UTILS_DUMMY_PROPERTY
};
gpointer folks_inspect_command_ref (gpointer instance);
void folks_inspect_command_unref (gpointer instance);
GParamSpec* folks_inspect_param_spec_command (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void folks_inspect_value_set_command (GValue* value, gpointer v_object);
void folks_inspect_value_take_command (GValue* value, gpointer v_object);
gpointer folks_inspect_value_get_command (const GValue* value);
GType folks_inspect_command_get_type (void) G_GNUC_CONST;
void folks_inspect_utils_init (void);
static void folks_inspect_utils_transform_object_to_string (GValue* src, GValue* dest);
static void _folks_inspect_utils_transform_object_to_string_gvalue_transform (GValue* src_value, GValue* dest_value);
static void folks_inspect_utils_transform_persona_store_to_string (GValue* src, GValue* dest);
static void _folks_inspect_utils_transform_persona_store_to_string_gvalue_transform (GValue* src_value, GValue* dest_value);
static void folks_inspect_utils_transform_string_array_to_string (GValue* src, GValue* dest);
static void _folks_inspect_utils_transform_string_array_to_string_gvalue_transform (GValue* src_value, GValue* dest_value);
void folks_inspect_utils_indent (void);
void folks_inspect_utils_unindent (void);
void folks_inspect_utils_print_line (const gchar* format, ...);
void folks_inspect_utils_print_individual (FolksIndividual* individual, gboolean show_personas);
static gchar* folks_inspect_utils_property_to_string (GType object_type, const gchar* prop_name, GValue* prop_value);
void folks_inspect_utils_print_persona (FolksPersona* persona);
void folks_inspect_utils_print_persona_store (FolksPersonaStore* store, gboolean show_personas);
static void _lambda3_ (const gchar* k, FolksPersona* v);
static void __lambda3__gh_func (gconstpointer key, gconstpointer value, gpointer self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (Block2Data* _data2_);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (Block3Data* _data3_);
static void _lambda0_ (const gchar* k, gboolean v, Block3Data* _data3_);
static void __lambda0__gh_func (gconstpointer key, gconstpointer value, gpointer self);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (Block4Data* _data4_);
static void _lambda1_ (const gchar* k, GPtrArray* v, Block4Data* _data4_);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (Block5Data* _data5_);
static void _lambda2_ (const gchar* a, Block5Data* _data5_);
static void __lambda2__gfunc (gconstpointer data, gpointer self);
static void __lambda1__gh_func (gconstpointer key, gconstpointer value, gpointer self);
gchar* folks_inspect_utils_transform_value_to_string (GValue* prop_value);
gchar* folks_inspect_utils_command_name_completion_cb (const gchar* word, gint state);
GType folks_inspect_client_get_type (void) G_GNUC_CONST;
gchar* folks_inspect_utils_individual_id_completion_cb (const gchar* word, gint state);
FolksIndividualAggregator* folks_inspect_client_get_aggregator (FolksInspectClient* self);
static GHashTableIter* _g_hash_table_iter_dup (GHashTableIter* self);
gchar* folks_inspect_utils_persona_uid_completion_cb (const gchar* word, gint state);
gchar* folks_inspect_utils_backend_name_completion_cb (const gchar* word, gint state);
FolksBackendStore* folks_inspect_client_get_backend_store (FolksInspectClient* self);
gchar* folks_inspect_utils_persona_store_id_completion_cb (const gchar* word, gint state);
FolksInspectUtils* folks_inspect_utils_new (void);
FolksInspectUtils* folks_inspect_utils_construct (GType object_type);
static void folks_inspect_utils_finalize (FolksInspectUtils* obj);


static void _folks_inspect_utils_transform_object_to_string_gvalue_transform (GValue* src_value, GValue* dest_value) {
	folks_inspect_utils_transform_object_to_string (src_value, dest_value);
}


static void _folks_inspect_utils_transform_persona_store_to_string_gvalue_transform (GValue* src_value, GValue* dest_value) {
	folks_inspect_utils_transform_persona_store_to_string (src_value, dest_value);
}


static void _folks_inspect_utils_transform_string_array_to_string_gvalue_transform (GValue* src_value, GValue* dest_value) {
	folks_inspect_utils_transform_string_array_to_string (src_value, dest_value);
}


void folks_inspect_utils_init (void) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	_tmp0_ = g_strdup ("");
	_tmp1_ = _tmp0_;
	_g_free0 (folks_inspect_utils_indentation_string);
	folks_inspect_utils_indentation_string = _tmp1_;
	g_value_register_transform_func (G_TYPE_OBJECT, G_TYPE_STRING, _folks_inspect_utils_transform_object_to_string_gvalue_transform);
	g_value_register_transform_func (FOLKS_TYPE_PERSONA_STORE, G_TYPE_STRING, _folks_inspect_utils_transform_persona_store_to_string_gvalue_transform);
	g_value_register_transform_func (G_TYPE_STRV, G_TYPE_STRING, _folks_inspect_utils_transform_string_array_to_string_gvalue_transform);
}


static void folks_inspect_utils_transform_object_to_string (GValue* src, GValue* dest) {
	GValue _dest = {0};
	GValue dest_tmp = {0};
	GObject* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GValue _tmp2_;
	GValue _tmp3_ = {0};
	GValue _tmp4_;
	g_value_init (&dest_tmp, G_TYPE_STRING);
	_tmp0_ = g_value_get_object (src);
	_tmp1_ = g_strdup_printf ("%p", _tmp0_);
	g_value_take_string (&dest_tmp, _tmp1_);
	_tmp2_ = G_IS_VALUE (&dest_tmp) ? (g_value_init (&_tmp3_, G_VALUE_TYPE (&dest_tmp)), g_value_copy (&dest_tmp, &_tmp3_), _tmp3_) : dest_tmp;
	_tmp4_ = _tmp2_;
	G_IS_VALUE (&_dest) ? (g_value_unset (&_dest), NULL) : NULL;
	_dest = _tmp4_;
	G_IS_VALUE (&dest_tmp) ? (g_value_unset (&dest_tmp), NULL) : NULL;
	if (dest) {
		*dest = _dest;
	} else {
		G_IS_VALUE (&_dest) ? (g_value_unset (&_dest), NULL) : NULL;
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void folks_inspect_utils_transform_persona_store_to_string (GValue* src, GValue* dest) {
	GValue _dest = {0};
	GValue dest_tmp = {0};
	GObject* _tmp0_ = NULL;
	FolksPersonaStore* _tmp1_;
	FolksPersonaStore* store;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	GValue _tmp6_;
	GValue _tmp7_ = {0};
	GValue _tmp8_;
	g_value_init (&dest_tmp, G_TYPE_STRING);
	_tmp0_ = g_value_get_object (src);
	_tmp1_ = _g_object_ref0 (FOLKS_PERSONA_STORE (_tmp0_));
	store = _tmp1_;
	_tmp2_ = folks_persona_store_get_type_id (store);
	_tmp3_ = folks_persona_store_get_id (store);
	_tmp4_ = folks_persona_store_get_display_name (store);
	_tmp5_ = g_strdup_printf ("%p: %s, %s (%s)", store, _tmp2_, _tmp3_, _tmp4_);
	g_value_take_string (&dest_tmp, _tmp5_);
	_tmp6_ = G_IS_VALUE (&dest_tmp) ? (g_value_init (&_tmp7_, G_VALUE_TYPE (&dest_tmp)), g_value_copy (&dest_tmp, &_tmp7_), _tmp7_) : dest_tmp;
	_tmp8_ = _tmp6_;
	G_IS_VALUE (&_dest) ? (g_value_unset (&_dest), NULL) : NULL;
	_dest = _tmp8_;
	_g_object_unref0 (store);
	G_IS_VALUE (&dest_tmp) ? (g_value_unset (&dest_tmp), NULL) : NULL;
	if (dest) {
		*dest = _dest;
	} else {
		G_IS_VALUE (&_dest) ? (g_value_unset (&_dest), NULL) : NULL;
	}
}


static void folks_inspect_utils_transform_string_array_to_string (GValue* src, GValue* dest) {
	GValue _dest = {0};
	GValue dest_tmp = {0};
	void* _tmp0_ = NULL;
	gchar** array;
	gint array_length1;
	gint _array_size_;
	gchar* _tmp1_;
	gchar* output;
	gboolean first;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GValue _tmp9_;
	GValue _tmp10_ = {0};
	GValue _tmp11_;
	g_value_init (&dest_tmp, G_TYPE_STRING);
	_tmp0_ = g_value_get_boxed (src);
	array = (gchar**) _tmp0_;
	array_length1 = -1;
	_array_size_ = -1;
	_tmp1_ = g_strdup ("{ ");
	output = _tmp1_;
	first = TRUE;
	{
		gchar** element_collection;
		int element_collection_length1;
		int element_it;
		element_collection = array;
		element_collection_length1 = array_length1;
		for (element_it = 0; element_it < array_length1; element_it = element_it + 1) {
			gchar* _tmp2_;
			gchar* element;
			_tmp2_ = g_strdup (element_collection[element_it]);
			element = _tmp2_;
			{
				gchar* _tmp4_ = NULL;
				gchar* _tmp5_;
				gchar* _tmp6_;
				if (first == FALSE) {
					gchar* _tmp3_;
					_tmp3_ = g_strconcat (output, ", ", NULL);
					_g_free0 (output);
					output = _tmp3_;
				}
				_tmp4_ = g_strdup_printf ("'%s'", element);
				_tmp5_ = _tmp4_;
				_tmp6_ = g_strconcat (output, _tmp5_, NULL);
				_g_free0 (output);
				output = _tmp6_;
				_g_free0 (_tmp5_);
				first = FALSE;
				_g_free0 (element);
			}
		}
	}
	_tmp7_ = g_strconcat (output, " }", NULL);
	_g_free0 (output);
	output = _tmp7_;
	_tmp8_ = g_strdup (output);
	g_value_take_string (&dest_tmp, _tmp8_);
	_tmp9_ = G_IS_VALUE (&dest_tmp) ? (g_value_init (&_tmp10_, G_VALUE_TYPE (&dest_tmp)), g_value_copy (&dest_tmp, &_tmp10_), _tmp10_) : dest_tmp;
	_tmp11_ = _tmp9_;
	G_IS_VALUE (&_dest) ? (g_value_unset (&_dest), NULL) : NULL;
	_dest = _tmp11_;
	_g_free0 (output);
	G_IS_VALUE (&dest_tmp) ? (g_value_unset (&dest_tmp), NULL) : NULL;
	if (dest) {
		*dest = _dest;
	} else {
		G_IS_VALUE (&_dest) ? (g_value_unset (&_dest), NULL) : NULL;
	}
}


void folks_inspect_utils_indent (void) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	folks_inspect_utils_indentation = folks_inspect_utils_indentation + ((guint) 2);
	_tmp0_ = g_strnfill ((gsize) folks_inspect_utils_indentation, ' ');
	_tmp1_ = _tmp0_;
	_g_free0 (folks_inspect_utils_indentation_string);
	folks_inspect_utils_indentation_string = _tmp1_;
}


void folks_inspect_utils_unindent (void) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	folks_inspect_utils_indentation = folks_inspect_utils_indentation - ((guint) 2);
	_tmp0_ = g_strnfill ((gsize) folks_inspect_utils_indentation, ' ');
	_tmp1_ = _tmp0_;
	_g_free0 (folks_inspect_utils_indentation_string);
	folks_inspect_utils_indentation_string = _tmp1_;
}


void folks_inspect_utils_print_line (const gchar* format, ...) {
	va_list valist;
	gchar* _tmp0_ = NULL;
	gchar* output;
	g_return_if_fail (format != NULL);
	va_start (valist, format);
	_tmp0_ = g_strdup_vprintf (format, valist);
	output = _tmp0_;
	fprintf (stdout, "%s%s\n", folks_inspect_utils_indentation_string, output);
	_g_free0 (output);
	va_end (valist);
}


void folks_inspect_utils_print_individual (FolksIndividual* individual, gboolean show_personas) {
	const gchar* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	guint _tmp2_;
	GObjectClass* _tmp3_ = NULL;
	guint _tmp4_;
	GParamSpec** _tmp5_ = NULL;
	GParamSpec** properties;
	gint properties_length1;
	gint _properties_size_;
	g_return_if_fail (individual != NULL);
	_tmp0_ = folks_individual_get_id (individual);
	_tmp1_ = folks_individual_get_personas (individual);
	_tmp2_ = g_list_length (_tmp1_);
	folks_inspect_utils_print_line ("Individual '%s' with %u personas:", _tmp0_, _tmp2_);
	_tmp3_ = G_OBJECT_GET_CLASS ((GObject*) individual);
	_tmp5_ = g_object_class_list_properties (_tmp3_, &_tmp4_);
	properties = _tmp5_;
	properties_length1 = _tmp4_;
	_properties_size_ = _tmp4_;
	folks_inspect_utils_indent ();
	{
		GParamSpec** pspec_collection;
		int pspec_collection_length1;
		int pspec_it;
		pspec_collection = properties;
		pspec_collection_length1 = properties_length1;
		for (pspec_it = 0; pspec_it < properties_length1; pspec_it = pspec_it + 1) {
			GParamSpec* pspec;
			pspec = pspec_collection[pspec_it];
			{
				GValue prop_value = {0};
				gchar* output_string = NULL;
				gboolean _tmp6_ = FALSE;
				GValue _tmp8_ = {0};
				GValue _tmp9_ = {0};
				GValue _tmp10_;
				const gchar* _tmp11_ = NULL;
				GType _tmp12_;
				const gchar* _tmp13_ = NULL;
				gchar* _tmp14_ = NULL;
				gchar* _tmp15_;
				const gchar* _tmp16_ = NULL;
				if (show_personas == TRUE) {
					const gchar* _tmp7_ = NULL;
					_tmp7_ = g_param_spec_get_name (pspec);
					_tmp6_ = g_strcmp0 (_tmp7_, "personas") == 0;
				} else {
					_tmp6_ = FALSE;
				}
				if (_tmp6_) {
					_g_free0 (output_string);
					G_IS_VALUE (&prop_value) ? (g_value_unset (&prop_value), NULL) : NULL;
					continue;
				}
				g_value_init (&_tmp8_, pspec->value_type);
				_tmp9_ = _tmp8_;
				_tmp10_ = _tmp9_;
				G_IS_VALUE (&prop_value) ? (g_value_unset (&prop_value), NULL) : NULL;
				prop_value = _tmp10_;
				_tmp11_ = g_param_spec_get_name (pspec);
				g_object_get_property ((GObject*) individual, _tmp11_, &prop_value);
				_tmp12_ = G_TYPE_FROM_INSTANCE ((GObject*) individual);
				_tmp13_ = g_param_spec_get_name (pspec);
				_tmp14_ = folks_inspect_utils_property_to_string (_tmp12_, _tmp13_, &prop_value);
				_tmp15_ = _tmp14_;
				_g_free0 (output_string);
				output_string = _tmp15_;
				_tmp16_ = g_param_spec_get_nick (pspec);
				folks_inspect_utils_print_line ("%-20s  %s", _tmp16_, output_string);
				_g_free0 (output_string);
				G_IS_VALUE (&prop_value) ? (g_value_unset (&prop_value), NULL) : NULL;
			}
		}
	}
	if (show_personas == TRUE) {
		GList* _tmp17_ = NULL;
		folks_inspect_utils_print_line ("");
		folks_inspect_utils_print_line ("Personas:");
		folks_inspect_utils_indent ();
		_tmp17_ = folks_individual_get_personas (individual);
		{
			GList* persona_collection;
			GList* persona_it;
			persona_collection = _tmp17_;
			for (persona_it = persona_collection; persona_it != NULL; persona_it = persona_it->next) {
				FolksPersona* _tmp18_;
				FolksPersona* persona;
				_tmp18_ = _g_object_ref0 ((FolksPersona*) persona_it->data);
				persona = _tmp18_;
				{
					folks_inspect_utils_print_persona (persona);
					_g_object_unref0 (persona);
				}
			}
		}
		folks_inspect_utils_unindent ();
	}
	folks_inspect_utils_unindent ();
}


void folks_inspect_utils_print_persona (FolksPersona* persona) {
	const gchar* _tmp0_ = NULL;
	GObjectClass* _tmp1_ = NULL;
	guint _tmp2_;
	GParamSpec** _tmp3_ = NULL;
	GParamSpec** properties;
	gint properties_length1;
	gint _properties_size_;
	g_return_if_fail (persona != NULL);
	_tmp0_ = folks_persona_get_uid (persona);
	folks_inspect_utils_print_line ("Persona '%s':", _tmp0_);
	_tmp1_ = G_OBJECT_GET_CLASS ((GObject*) persona);
	_tmp3_ = g_object_class_list_properties (_tmp1_, &_tmp2_);
	properties = _tmp3_;
	properties_length1 = _tmp2_;
	_properties_size_ = _tmp2_;
	folks_inspect_utils_indent ();
	{
		GParamSpec** pspec_collection;
		int pspec_collection_length1;
		int pspec_it;
		pspec_collection = properties;
		pspec_collection_length1 = properties_length1;
		for (pspec_it = 0; pspec_it < properties_length1; pspec_it = pspec_it + 1) {
			GParamSpec* pspec;
			pspec = pspec_collection[pspec_it];
			{
				GValue prop_value = {0};
				gchar* output_string = NULL;
				GValue _tmp4_ = {0};
				GValue _tmp5_ = {0};
				GValue _tmp6_;
				const gchar* _tmp7_ = NULL;
				GType _tmp8_;
				const gchar* _tmp9_ = NULL;
				gchar* _tmp10_ = NULL;
				gchar* _tmp11_;
				const gchar* _tmp12_ = NULL;
				g_value_init (&_tmp4_, pspec->value_type);
				_tmp5_ = _tmp4_;
				_tmp6_ = _tmp5_;
				G_IS_VALUE (&prop_value) ? (g_value_unset (&prop_value), NULL) : NULL;
				prop_value = _tmp6_;
				_tmp7_ = g_param_spec_get_name (pspec);
				g_object_get_property ((GObject*) persona, _tmp7_, &prop_value);
				_tmp8_ = G_TYPE_FROM_INSTANCE ((GObject*) persona);
				_tmp9_ = g_param_spec_get_name (pspec);
				_tmp10_ = folks_inspect_utils_property_to_string (_tmp8_, _tmp9_, &prop_value);
				_tmp11_ = _tmp10_;
				_g_free0 (output_string);
				output_string = _tmp11_;
				_tmp12_ = g_param_spec_get_nick (pspec);
				folks_inspect_utils_print_line ("%-20s  %s", _tmp12_, output_string);
				_g_free0 (output_string);
				G_IS_VALUE (&prop_value) ? (g_value_unset (&prop_value), NULL) : NULL;
			}
		}
	}
	folks_inspect_utils_unindent ();
}


static void _lambda3_ (const gchar* k, FolksPersona* v) {
	g_return_if_fail (k != NULL);
	g_return_if_fail (v != NULL);
	folks_inspect_utils_print_persona (FOLKS_PERSONA (v));
}


static void __lambda3__gh_func (gconstpointer key, gconstpointer value, gpointer self) {
	_lambda3_ (key, value);
}


void folks_inspect_utils_print_persona_store (FolksPersonaStore* store, gboolean show_personas) {
	const gchar* _tmp0_ = NULL;
	GHashTable* _tmp1_ = NULL;
	guint _tmp2_;
	GObjectClass* _tmp3_ = NULL;
	guint _tmp4_;
	GParamSpec** _tmp5_ = NULL;
	GParamSpec** properties;
	gint properties_length1;
	gint _properties_size_;
	g_return_if_fail (store != NULL);
	_tmp0_ = folks_persona_store_get_id (store);
	_tmp1_ = folks_persona_store_get_personas (store);
	_tmp2_ = g_hash_table_size (_tmp1_);
	folks_inspect_utils_print_line ("Persona store '%s' with %u personas:", _tmp0_, _tmp2_);
	_tmp3_ = G_OBJECT_GET_CLASS ((GObject*) store);
	_tmp5_ = g_object_class_list_properties (_tmp3_, &_tmp4_);
	properties = _tmp5_;
	properties_length1 = _tmp4_;
	_properties_size_ = _tmp4_;
	folks_inspect_utils_indent ();
	{
		GParamSpec** pspec_collection;
		int pspec_collection_length1;
		int pspec_it;
		pspec_collection = properties;
		pspec_collection_length1 = properties_length1;
		for (pspec_it = 0; pspec_it < properties_length1; pspec_it = pspec_it + 1) {
			GParamSpec* pspec;
			pspec = pspec_collection[pspec_it];
			{
				GValue prop_value = {0};
				gchar* output_string = NULL;
				gboolean _tmp6_ = FALSE;
				GValue _tmp8_ = {0};
				GValue _tmp9_ = {0};
				GValue _tmp10_;
				const gchar* _tmp11_ = NULL;
				GType _tmp12_;
				const gchar* _tmp13_ = NULL;
				gchar* _tmp14_ = NULL;
				gchar* _tmp15_;
				const gchar* _tmp16_ = NULL;
				if (show_personas == TRUE) {
					const gchar* _tmp7_ = NULL;
					_tmp7_ = g_param_spec_get_name (pspec);
					_tmp6_ = g_strcmp0 (_tmp7_, "personas") == 0;
				} else {
					_tmp6_ = FALSE;
				}
				if (_tmp6_) {
					_g_free0 (output_string);
					G_IS_VALUE (&prop_value) ? (g_value_unset (&prop_value), NULL) : NULL;
					continue;
				}
				g_value_init (&_tmp8_, pspec->value_type);
				_tmp9_ = _tmp8_;
				_tmp10_ = _tmp9_;
				G_IS_VALUE (&prop_value) ? (g_value_unset (&prop_value), NULL) : NULL;
				prop_value = _tmp10_;
				_tmp11_ = g_param_spec_get_name (pspec);
				g_object_get_property ((GObject*) store, _tmp11_, &prop_value);
				_tmp12_ = G_TYPE_FROM_INSTANCE ((GObject*) store);
				_tmp13_ = g_param_spec_get_name (pspec);
				_tmp14_ = folks_inspect_utils_property_to_string (_tmp12_, _tmp13_, &prop_value);
				_tmp15_ = _tmp14_;
				_g_free0 (output_string);
				output_string = _tmp15_;
				_tmp16_ = g_param_spec_get_nick (pspec);
				folks_inspect_utils_print_line ("%-20s  %s", _tmp16_, output_string);
				_g_free0 (output_string);
				G_IS_VALUE (&prop_value) ? (g_value_unset (&prop_value), NULL) : NULL;
			}
		}
	}
	if (show_personas == TRUE) {
		GHashTable* _tmp17_ = NULL;
		folks_inspect_utils_print_line ("");
		folks_inspect_utils_print_line ("Personas:");
		folks_inspect_utils_indent ();
		_tmp17_ = folks_persona_store_get_personas (store);
		g_hash_table_foreach (_tmp17_, __lambda3__gh_func, NULL);
		folks_inspect_utils_unindent ();
	}
	folks_inspect_utils_unindent ();
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (Block2Data* _data2_) {
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		_g_free0 (_data2_->output_string);
		g_slice_free (Block2Data, _data2_);
	}
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (Block3Data* _data3_) {
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		block2_data_unref (_data3_->_data2_);
		_data3_->_data2_ = NULL;
		g_slice_free (Block3Data, _data3_);
	}
}


static gpointer _g_hash_table_ref0 (gpointer self) {
	return self ? g_hash_table_ref (self) : NULL;
}


static void _lambda0_ (const gchar* k, gboolean v, Block3Data* _data3_) {
	Block2Data* _data2_;
	_data2_ = _data3_->_data2_;
	g_return_if_fail (k != NULL);
	if (((gboolean) v) == TRUE) {
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		gchar* _tmp3_;
		if (_data3_->first == FALSE) {
			gchar* _tmp0_;
			_tmp0_ = g_strconcat (_data2_->output_string, ", ", NULL);
			_g_free0 (_data2_->output_string);
			_data2_->output_string = _tmp0_;
		}
		_tmp1_ = g_strdup_printf ("'%s'", (const gchar*) k);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_strconcat (_data2_->output_string, _tmp2_, NULL);
		_g_free0 (_data2_->output_string);
		_data2_->output_string = _tmp3_;
		_g_free0 (_tmp2_);
		_data3_->first = FALSE;
	}
}


static void __lambda0__gh_func (gconstpointer key, gconstpointer value, gpointer self) {
	_lambda0_ (key, value, self);
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}


static void block4_data_unref (Block4Data* _data4_) {
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		block2_data_unref (_data4_->_data2_);
		_data4_->_data2_ = NULL;
		g_slice_free (Block4Data, _data4_);
	}
}


static Block5Data* block5_data_ref (Block5Data* _data5_) {
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}


static void block5_data_unref (Block5Data* _data5_) {
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		block4_data_unref (_data5_->_data4_);
		_data5_->_data4_ = NULL;
		g_slice_free (Block5Data, _data5_);
	}
}


static gpointer _g_ptr_array_ref0 (gpointer self) {
	return self ? g_ptr_array_ref (self) : NULL;
}


static void _lambda2_ (const gchar* a, Block5Data* _data5_) {
	Block4Data* _data4_;
	Block2Data* _data2_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_;
	_data4_ = _data5_->_data4_;
	_data2_ = _data4_->_data2_;
	g_return_if_fail (a != NULL);
	if (_data5_->_first == FALSE) {
		gchar* _tmp0_;
		_tmp0_ = g_strconcat (_data2_->output_string, ", ", NULL);
		_g_free0 (_data2_->output_string);
		_data2_->output_string = _tmp0_;
	}
	_tmp1_ = g_strdup_printf ("'%s'", (const gchar*) a);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_data2_->output_string, _tmp2_, NULL);
	_g_free0 (_data2_->output_string);
	_data2_->output_string = _tmp3_;
	_g_free0 (_tmp2_);
	_data5_->_first = FALSE;
}


static void __lambda2__gfunc (gconstpointer data, gpointer self) {
	_lambda2_ (data, self);
}


static void _lambda1_ (const gchar* k, GPtrArray* v, Block4Data* _data4_) {
	Block2Data* _data2_;
	Block5Data* _data5_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GPtrArray* _tmp4_;
	GPtrArray* addresses;
	gchar* _tmp5_;
	_data2_ = _data4_->_data2_;
	g_return_if_fail (k != NULL);
	g_return_if_fail (v != NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->_data4_ = block4_data_ref (_data4_);
	if (_data4_->first == FALSE) {
		gchar* _tmp0_;
		_tmp0_ = g_strconcat (_data2_->output_string, ", ", NULL);
		_g_free0 (_data2_->output_string);
		_data2_->output_string = _tmp0_;
	}
	_tmp1_ = g_strdup_printf ("'%s' : { ", (const gchar*) k);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_data2_->output_string, _tmp2_, NULL);
	_g_free0 (_data2_->output_string);
	_data2_->output_string = _tmp3_;
	_g_free0 (_tmp2_);
	_data4_->first = FALSE;
	_tmp4_ = _g_ptr_array_ref0 ((GPtrArray*) v);
	addresses = _tmp4_;
	_data5_->_first = TRUE;
	g_ptr_array_foreach (addresses, __lambda2__gfunc, _data5_);
	_tmp5_ = g_strconcat (_data2_->output_string, " }", NULL);
	_g_free0 (_data2_->output_string);
	_data2_->output_string = _tmp5_;
	_g_ptr_array_unref0 (addresses);
	block5_data_unref (_data5_);
	_data5_ = NULL;
}


static void __lambda1__gh_func (gconstpointer key, gconstpointer value, gpointer self) {
	_lambda1_ (key, value, self);
}


static gchar* g_date_time_to_string (GDateTime* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_date_time_format (self, "%FT%H:%M:%S%z");
	result = _tmp0_;
	return result;
}


static gchar* folks_inspect_utils_property_to_string (GType object_type, const gchar* prop_name, GValue* prop_value) {
	gchar* result = NULL;
	Block2Data* _data2_;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gchar* _tmp53_ = NULL;
	g_return_val_if_fail (prop_name != NULL, NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_tmp1_ = g_type_is_a (object_type, FOLKS_TYPE_INDIVIDUAL);
	if (_tmp1_) {
		_tmp0_ = g_strcmp0 (prop_name, "personas") == 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		void* _tmp2_ = NULL;
		GList* personas;
		guint _tmp3_;
		gchar* _tmp4_ = NULL;
		_tmp2_ = g_value_get_pointer (prop_value);
		personas = (GList*) _tmp2_;
		_tmp3_ = g_list_length (personas);
		_tmp4_ = g_strdup_printf ("List of %u personas", _tmp3_);
		result = _tmp4_;
		block2_data_unref (_data2_);
		_data2_ = NULL;
		return result;
	} else {
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_;
		_tmp6_ = g_type_is_a (object_type, FOLKS_TYPE_PERSONA_STORE);
		if (_tmp6_) {
			_tmp5_ = g_strcmp0 (prop_name, "personas") == 0;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			void* _tmp7_ = NULL;
			GHashTable* personas;
			guint _tmp8_;
			gchar* _tmp9_ = NULL;
			_tmp7_ = g_value_get_boxed (prop_value);
			personas = (GHashTable*) _tmp7_;
			_tmp8_ = g_hash_table_size (personas);
			_tmp9_ = g_strdup_printf ("Set of %u personas", _tmp8_);
			result = _tmp9_;
			block2_data_unref (_data2_);
			_data2_ = NULL;
			return result;
		} else {
			if (g_strcmp0 (prop_name, "groups") == 0) {
				Block3Data* _data3_;
				void* _tmp10_ = NULL;
				GHashTable* _tmp11_;
				GHashTable* groups;
				gchar* _tmp12_;
				gchar* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				_data3_ = g_slice_new0 (Block3Data);
				_data3_->_ref_count_ = 1;
				_data3_->_data2_ = block2_data_ref (_data2_);
				_tmp10_ = g_value_get_boxed (prop_value);
				_tmp11_ = _g_hash_table_ref0 ((GHashTable*) _tmp10_);
				groups = _tmp11_;
				_tmp12_ = g_strdup ("{ ");
				_tmp13_ = _tmp12_;
				_g_free0 (_data2_->output_string);
				_data2_->output_string = _tmp13_;
				_data3_->first = TRUE;
				g_hash_table_foreach (groups, __lambda0__gh_func, _data3_);
				_tmp14_ = g_strconcat (_data2_->output_string, " }", NULL);
				_g_free0 (_data2_->output_string);
				_data2_->output_string = _tmp14_;
				_tmp15_ = g_strdup (_data2_->output_string);
				result = _tmp15_;
				_g_hash_table_unref0 (groups);
				block3_data_unref (_data3_);
				_data3_ = NULL;
				block2_data_unref (_data2_);
				_data2_ = NULL;
				return result;
			} else {
				if (g_strcmp0 (prop_name, "avatar") == 0) {
					gchar* ret;
					GObject* _tmp16_ = NULL;
					GFile* _tmp17_;
					GFile* avatar;
					ret = NULL;
					_tmp16_ = g_value_get_object (prop_value);
					_tmp17_ = _g_object_ref0 (G_FILE (_tmp16_));
					avatar = _tmp17_;
					if (avatar != NULL) {
						gchar* _tmp18_ = NULL;
						gchar* _tmp19_;
						_tmp18_ = g_file_get_uri (avatar);
						_tmp19_ = _tmp18_;
						_g_free0 (ret);
						ret = _tmp19_;
					}
					result = ret;
					_g_object_unref0 (avatar);
					block2_data_unref (_data2_);
					_data2_ = NULL;
					return result;
				} else {
					if (g_strcmp0 (prop_name, "im-addresses") == 0) {
						Block4Data* _data4_;
						void* _tmp20_ = NULL;
						GHashTable* _tmp21_;
						GHashTable* im_addresses;
						gchar* _tmp22_;
						gchar* _tmp23_;
						gchar* _tmp24_;
						gchar* _tmp25_;
						_data4_ = g_slice_new0 (Block4Data);
						_data4_->_ref_count_ = 1;
						_data4_->_data2_ = block2_data_ref (_data2_);
						_tmp20_ = g_value_get_boxed (prop_value);
						_tmp21_ = _g_hash_table_ref0 ((GHashTable*) _tmp20_);
						im_addresses = _tmp21_;
						_tmp22_ = g_strdup ("{ ");
						_tmp23_ = _tmp22_;
						_g_free0 (_data2_->output_string);
						_data2_->output_string = _tmp23_;
						_data4_->first = TRUE;
						g_hash_table_foreach (im_addresses, __lambda1__gh_func, _data4_);
						_tmp24_ = g_strconcat (_data2_->output_string, " }", NULL);
						_g_free0 (_data2_->output_string);
						_data2_->output_string = _tmp24_;
						_tmp25_ = g_strdup (_data2_->output_string);
						result = _tmp25_;
						_g_hash_table_unref0 (im_addresses);
						block4_data_unref (_data4_);
						_data4_ = NULL;
						block2_data_unref (_data2_);
						_data2_ = NULL;
						return result;
					} else {
						gboolean _tmp26_ = FALSE;
						gboolean _tmp27_ = FALSE;
						if (g_strcmp0 (prop_name, "email-addresses") == 0) {
							_tmp27_ = TRUE;
						} else {
							_tmp27_ = g_strcmp0 (prop_name, "urls") == 0;
						}
						if (_tmp27_) {
							_tmp26_ = TRUE;
						} else {
							_tmp26_ = g_strcmp0 (prop_name, "phone-numbers") == 0;
						}
						if (_tmp26_) {
							gchar* _tmp28_;
							gchar* _tmp29_;
							gboolean first;
							void* _tmp30_ = NULL;
							GList* prop_list;
							gchar* _tmp35_;
							gchar* _tmp36_;
							_tmp28_ = g_strdup ("{ ");
							_tmp29_ = _tmp28_;
							_g_free0 (_data2_->output_string);
							_data2_->output_string = _tmp29_;
							first = TRUE;
							_tmp30_ = g_value_get_pointer (prop_value);
							prop_list = (GList*) _tmp30_;
							{
								GList* p_collection;
								GList* p_it;
								p_collection = prop_list;
								for (p_it = p_collection; p_it != NULL; p_it = p_it->next) {
									FolksFieldDetails* _tmp31_;
									FolksFieldDetails* p;
									_tmp31_ = _g_object_ref0 ((FolksFieldDetails*) p_it->data);
									p = _tmp31_;
									{
										const gchar* _tmp33_ = NULL;
										gchar* _tmp34_;
										if (!first) {
											gchar* _tmp32_;
											_tmp32_ = g_strconcat (_data2_->output_string, ", ", NULL);
											_g_free0 (_data2_->output_string);
											_data2_->output_string = _tmp32_;
										}
										_tmp33_ = folks_field_details_get_value (p);
										_tmp34_ = g_strconcat (_data2_->output_string, _tmp33_, NULL);
										_g_free0 (_data2_->output_string);
										_data2_->output_string = _tmp34_;
										first = FALSE;
										_g_object_unref0 (p);
									}
								}
							}
							_tmp35_ = g_strconcat (_data2_->output_string, " }", NULL);
							_g_free0 (_data2_->output_string);
							_data2_->output_string = _tmp35_;
							_tmp36_ = g_strdup (_data2_->output_string);
							result = _tmp36_;
							block2_data_unref (_data2_);
							_data2_ = NULL;
							return result;
						} else {
							if (g_strcmp0 (prop_name, "birthday") == 0) {
								void* _tmp37_ = NULL;
								GDateTime* dobj;
								_tmp37_ = g_value_get_boxed (prop_value);
								dobj = (GDateTime*) _tmp37_;
								if (dobj != NULL) {
									gchar* _tmp38_ = NULL;
									_tmp38_ = g_date_time_to_string (dobj);
									result = _tmp38_;
									block2_data_unref (_data2_);
									_data2_ = NULL;
									return result;
								} else {
									gchar* _tmp39_;
									_tmp39_ = g_strdup ("");
									result = _tmp39_;
									block2_data_unref (_data2_);
									_data2_ = NULL;
									return result;
								}
							} else {
								if (g_strcmp0 (prop_name, "postal-addresses") == 0) {
									gchar* _tmp40_;
									gchar* _tmp41_;
									gboolean first;
									void* _tmp42_ = NULL;
									GList* prop_list;
									gchar* _tmp48_;
									gchar* _tmp49_;
									_tmp40_ = g_strdup ("{ ");
									_tmp41_ = _tmp40_;
									_g_free0 (_data2_->output_string);
									_data2_->output_string = _tmp41_;
									first = TRUE;
									_tmp42_ = g_value_get_pointer (prop_value);
									prop_list = (GList*) _tmp42_;
									{
										GList* p_collection;
										GList* p_it;
										p_collection = prop_list;
										for (p_it = p_collection; p_it != NULL; p_it = p_it->next) {
											FolksPostalAddress* _tmp43_;
											FolksPostalAddress* p;
											_tmp43_ = _g_object_ref0 ((FolksPostalAddress*) p_it->data);
											p = _tmp43_;
											{
												gchar* _tmp45_ = NULL;
												gchar* _tmp46_;
												gchar* _tmp47_;
												if (!first) {
													gchar* _tmp44_;
													_tmp44_ = g_strconcat (_data2_->output_string, ". ", NULL);
													_g_free0 (_data2_->output_string);
													_data2_->output_string = _tmp44_;
												}
												_tmp45_ = folks_postal_address_to_string (p);
												_tmp46_ = _tmp45_;
												_tmp47_ = g_strconcat (_data2_->output_string, _tmp46_, NULL);
												_g_free0 (_data2_->output_string);
												_data2_->output_string = _tmp47_;
												_g_free0 (_tmp46_);
												first = FALSE;
												_g_object_unref0 (p);
											}
										}
									}
									_tmp48_ = g_strconcat (_data2_->output_string, " }", NULL);
									_g_free0 (_data2_->output_string);
									_data2_->output_string = _tmp48_;
									_tmp49_ = g_strdup (_data2_->output_string);
									result = _tmp49_;
									block2_data_unref (_data2_);
									_data2_ = NULL;
									return result;
								} else {
									if (g_strcmp0 (prop_name, "structured-name") == 0) {
										GObject* _tmp50_ = NULL;
										FolksStructuredName* sn;
										gchar* ret;
										_tmp50_ = g_value_get_object (prop_value);
										sn = FOLKS_STRUCTURED_NAME (_tmp50_);
										ret = NULL;
										if (sn != NULL) {
											gchar* _tmp51_ = NULL;
											gchar* _tmp52_;
											_tmp51_ = folks_structured_name_to_string (sn);
											_tmp52_ = _tmp51_;
											_g_free0 (ret);
											ret = _tmp52_;
										}
										result = ret;
										block2_data_unref (_data2_);
										_data2_ = NULL;
										return result;
									}
								}
							}
						}
					}
				}
			}
		}
	}
	_tmp53_ = folks_inspect_utils_transform_value_to_string (prop_value);
	result = _tmp53_;
	block2_data_unref (_data2_);
	_data2_ = NULL;
	return result;
}


gchar* folks_inspect_utils_transform_value_to_string (GValue* prop_value) {
	gchar* result = NULL;
	GType _tmp0_;
	gboolean _tmp1_;
	_tmp0_ = G_VALUE_TYPE (prop_value);
	_tmp1_ = g_value_type_transformable (_tmp0_, G_TYPE_STRING);
	if (_tmp1_) {
		GValue string_value = {0};
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		g_value_init (&string_value, G_TYPE_STRING);
		g_value_transform (prop_value, &string_value);
		_tmp2_ = g_value_get_string (&string_value);
		_tmp3_ = g_strdup (_tmp2_);
		result = _tmp3_;
		G_IS_VALUE (&string_value) ? (g_value_unset (&string_value), NULL) : NULL;
		return result;
	} else {
		GType _tmp4_;
		const gchar* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		_tmp4_ = G_VALUE_TYPE (prop_value);
		_tmp5_ = g_type_name (_tmp4_);
		_tmp6_ = g_type_name (G_TYPE_STRING);
		_tmp7_ = g_strdup_printf ("Can't convert from type '%s' to '%s'", _tmp5_, _tmp6_);
		result = _tmp7_;
		return result;
	}
}


gchar* folks_inspect_utils_command_name_completion_cb (const gchar* word, gint state) {
	gchar* result = NULL;
	GeeMapIterator* _tmp5_;
	g_return_val_if_fail (word != NULL, NULL);
	if (state == 0) {
		GeeMapIterator* _tmp0_ = NULL;
		GeeMapIterator* _tmp1_;
		_tmp0_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) main_client->commands);
		_tmp1_ = _tmp0_;
		_g_object_unref0 (folks_inspect_utils_command_name_iter);
		folks_inspect_utils_command_name_iter = _tmp1_;
	}
	while (TRUE) {
		gboolean _tmp2_;
		gpointer _tmp3_ = NULL;
		gchar* command_name;
		gboolean _tmp4_;
		_tmp2_ = gee_map_iterator_next (folks_inspect_utils_command_name_iter);
		if (!(_tmp2_ == TRUE)) {
			break;
		}
		_tmp3_ = gee_map_iterator_get_key (folks_inspect_utils_command_name_iter);
		command_name = (gchar*) _tmp3_;
		_tmp4_ = g_str_has_prefix (command_name, word);
		if (_tmp4_) {
			result = command_name;
			return result;
		}
		_g_free0 (command_name);
	}
	_tmp5_ = NULL;
	_g_object_unref0 (folks_inspect_utils_command_name_iter);
	folks_inspect_utils_command_name_iter = _tmp5_;
	result = NULL;
	return result;
}


static GHashTableIter* _g_hash_table_iter_dup (GHashTableIter* self) {
	GHashTableIter* dup;
	dup = g_new0 (GHashTableIter, 1);
	memcpy (dup, self, sizeof (GHashTableIter));
	return dup;
}


static gpointer __g_hash_table_iter_dup0 (gpointer self) {
	return self ? _g_hash_table_iter_dup (self) : NULL;
}


gchar* folks_inspect_utils_individual_id_completion_cb (const gchar* word, gint state) {
	gchar* result = NULL;
	gchar* id = NULL;
	FolksIndividual* individual = NULL;
	GHashTableIter* _tmp12_;
	g_return_val_if_fail (word != NULL, NULL);
	if (state == 0) {
		FolksIndividualAggregator* _tmp0_ = NULL;
		GHashTable* _tmp1_ = NULL;
		GHashTableIter _tmp2_ = {0};
		GHashTableIter _tmp3_ = {0};
		GHashTableIter* _tmp4_;
		GHashTableIter* _tmp5_;
		_tmp0_ = folks_inspect_client_get_aggregator (main_client);
		_tmp1_ = folks_individual_aggregator_get_individuals (_tmp0_);
		g_hash_table_iter_init (&_tmp2_, _tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = __g_hash_table_iter_dup0 (&_tmp3_);
		_tmp5_ = _tmp4_;
		_g_free0 (folks_inspect_utils_individual_id_iter);
		folks_inspect_utils_individual_id_iter = _tmp5_;
	}
	while (TRUE) {
		gconstpointer _tmp6_ = NULL;
		gconstpointer _tmp7_ = NULL;
		gboolean _tmp8_;
		gchar* _tmp9_;
		FolksIndividual* _tmp10_;
		gboolean _tmp11_;
		_tmp8_ = g_hash_table_iter_next (folks_inspect_utils_individual_id_iter, &_tmp6_, &_tmp7_);
		_g_free0 (id);
		_tmp9_ = g_strdup (_tmp6_);
		id = _tmp9_;
		_g_object_unref0 (individual);
		_tmp10_ = _g_object_ref0 (_tmp7_);
		individual = _tmp10_;
		if (!(_tmp8_ == TRUE)) {
			break;
		}
		_tmp11_ = g_str_has_prefix (id, word);
		if (_tmp11_) {
			result = id;
			_g_object_unref0 (individual);
			return result;
		}
	}
	_tmp12_ = NULL;
	_g_free0 (folks_inspect_utils_individual_id_iter);
	folks_inspect_utils_individual_id_iter = _tmp12_;
	result = NULL;
	_g_object_unref0 (individual);
	_g_free0 (id);
	return result;
}


gchar* folks_inspect_utils_persona_uid_completion_cb (const gchar* word, gint state) {
	gchar* result = NULL;
	FolksIndividual* individual;
	GHashTableIter* _tmp15_;
	g_return_val_if_fail (word != NULL, NULL);
	if (state == 0) {
		FolksIndividualAggregator* _tmp0_ = NULL;
		GHashTable* _tmp1_ = NULL;
		GHashTableIter _tmp2_ = {0};
		GHashTableIter _tmp3_ = {0};
		GHashTableIter* _tmp4_;
		GHashTableIter* _tmp5_;
		_tmp0_ = folks_inspect_client_get_aggregator (main_client);
		_tmp1_ = folks_individual_aggregator_get_individuals (_tmp0_);
		g_hash_table_iter_init (&_tmp2_, _tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = __g_hash_table_iter_dup0 (&_tmp3_);
		_tmp5_ = _tmp4_;
		_g_free0 (folks_inspect_utils_individual_id_iter);
		folks_inspect_utils_individual_id_iter = _tmp5_;
		folks_inspect_utils_persona_uid_iter = NULL;
	}
	individual = NULL;
	while (TRUE) {
		gboolean _tmp6_ = FALSE;
		if (folks_inspect_utils_persona_uid_iter != NULL) {
			_tmp6_ = TRUE;
		} else {
			gconstpointer _tmp7_ = NULL;
			gboolean _tmp8_;
			FolksIndividual* _tmp9_;
			_tmp8_ = g_hash_table_iter_next (folks_inspect_utils_individual_id_iter, NULL, &_tmp7_);
			_g_object_unref0 (individual);
			_tmp9_ = _g_object_ref0 (_tmp7_);
			individual = _tmp9_;
			_tmp6_ = _tmp8_ == TRUE;
		}
		if (!_tmp6_) {
			break;
		}
		if (folks_inspect_utils_persona_uid_iter == NULL) {
			GList* _tmp10_ = NULL;
			g_assert (individual != NULL);
			_tmp10_ = folks_individual_get_personas (individual);
			folks_inspect_utils_persona_uid_iter = _tmp10_;
		}
		while (TRUE) {
			FolksPersona* persona;
			const gchar* _tmp11_ = NULL;
			gboolean _tmp12_;
			if (!(folks_inspect_utils_persona_uid_iter != NULL)) {
				break;
			}
			persona = FOLKS_PERSONA ((FolksPersona*) folks_inspect_utils_persona_uid_iter->data);
			folks_inspect_utils_persona_uid_iter = folks_inspect_utils_persona_uid_iter->next;
			_tmp11_ = folks_persona_get_uid (persona);
			_tmp12_ = g_str_has_prefix (_tmp11_, word);
			if (_tmp12_) {
				const gchar* _tmp13_ = NULL;
				gchar* _tmp14_;
				_tmp13_ = folks_persona_get_uid (persona);
				_tmp14_ = g_strdup (_tmp13_);
				result = _tmp14_;
				_g_object_unref0 (individual);
				return result;
			}
		}
	}
	_tmp15_ = NULL;
	_g_free0 (folks_inspect_utils_individual_id_iter);
	folks_inspect_utils_individual_id_iter = _tmp15_;
	result = NULL;
	_g_object_unref0 (individual);
	return result;
}


gchar* folks_inspect_utils_backend_name_completion_cb (const gchar* word, gint state) {
	gchar* result = NULL;
	GeeIterator* _tmp11_;
	g_return_val_if_fail (word != NULL, NULL);
	if (state == 0) {
		FolksBackendStore* _tmp0_ = NULL;
		GeeCollection* _tmp1_ = NULL;
		GeeCollection* _tmp2_;
		GeeIterator* _tmp3_ = NULL;
		GeeIterator* _tmp4_;
		_tmp0_ = folks_inspect_client_get_backend_store (main_client);
		_tmp1_ = folks_backend_store_list_backends (_tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = gee_iterable_iterator ((GeeIterable*) _tmp2_);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (folks_inspect_utils_backend_name_iter);
		folks_inspect_utils_backend_name_iter = _tmp4_;
		_g_object_unref0 (_tmp2_);
	}
	while (TRUE) {
		gboolean _tmp5_;
		gpointer _tmp6_ = NULL;
		FolksBackend* backend;
		const gchar* _tmp7_ = NULL;
		gboolean _tmp8_;
		_tmp5_ = gee_iterator_next (folks_inspect_utils_backend_name_iter);
		if (!(_tmp5_ == TRUE)) {
			break;
		}
		_tmp6_ = gee_iterator_get (folks_inspect_utils_backend_name_iter);
		backend = (FolksBackend*) _tmp6_;
		_tmp7_ = folks_backend_get_name (backend);
		_tmp8_ = g_str_has_prefix (_tmp7_, word);
		if (_tmp8_) {
			const gchar* _tmp9_ = NULL;
			gchar* _tmp10_;
			_tmp9_ = folks_backend_get_name (backend);
			_tmp10_ = g_strdup (_tmp9_);
			result = _tmp10_;
			_g_object_unref0 (backend);
			return result;
		}
		_g_object_unref0 (backend);
	}
	_tmp11_ = NULL;
	_g_object_unref0 (folks_inspect_utils_backend_name_iter);
	folks_inspect_utils_backend_name_iter = _tmp11_;
	result = NULL;
	return result;
}


gchar* folks_inspect_utils_persona_store_id_completion_cb (const gchar* word, gint state) {
	gchar* result = NULL;
	GeeIterator* _tmp21_;
	g_return_val_if_fail (word != NULL, NULL);
	if (state == 0) {
		FolksBackendStore* _tmp0_ = NULL;
		GeeCollection* _tmp1_ = NULL;
		GeeCollection* _tmp2_;
		GeeIterator* _tmp3_ = NULL;
		GeeIterator* _tmp4_;
		GHashTableIter* _tmp5_;
		_tmp0_ = folks_inspect_client_get_backend_store (main_client);
		_tmp1_ = folks_backend_store_list_backends (_tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = gee_iterable_iterator ((GeeIterable*) _tmp2_);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (folks_inspect_utils_backend_name_iter);
		folks_inspect_utils_backend_name_iter = _tmp4_;
		_g_object_unref0 (_tmp2_);
		_tmp5_ = NULL;
		_g_free0 (folks_inspect_utils_persona_store_id_iter);
		folks_inspect_utils_persona_store_id_iter = _tmp5_;
	}
	while (TRUE) {
		gboolean _tmp6_ = FALSE;
		gchar* id = NULL;
		FolksPersonaStore* store = NULL;
		GHashTableIter* _tmp20_;
		if (folks_inspect_utils_persona_store_id_iter != NULL) {
			_tmp6_ = TRUE;
		} else {
			gboolean _tmp7_;
			_tmp7_ = gee_iterator_next (folks_inspect_utils_backend_name_iter);
			_tmp6_ = _tmp7_ == TRUE;
		}
		if (!_tmp6_) {
			break;
		}
		if (folks_inspect_utils_persona_store_id_iter == NULL) {
			gpointer _tmp8_ = NULL;
			FolksBackend* backend;
			GHashTable* _tmp9_ = NULL;
			GHashTableIter _tmp10_ = {0};
			GHashTableIter _tmp11_ = {0};
			GHashTableIter* _tmp12_;
			GHashTableIter* _tmp13_;
			_tmp8_ = gee_iterator_get (folks_inspect_utils_backend_name_iter);
			backend = (FolksBackend*) _tmp8_;
			_tmp9_ = folks_backend_get_persona_stores (backend);
			g_hash_table_iter_init (&_tmp10_, _tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = __g_hash_table_iter_dup0 (&_tmp11_);
			_tmp13_ = _tmp12_;
			_g_free0 (folks_inspect_utils_persona_store_id_iter);
			folks_inspect_utils_persona_store_id_iter = _tmp13_;
			_g_object_unref0 (backend);
		}
		while (TRUE) {
			gconstpointer _tmp14_ = NULL;
			gconstpointer _tmp15_ = NULL;
			gboolean _tmp16_;
			gchar* _tmp17_;
			FolksPersonaStore* _tmp18_;
			gboolean _tmp19_;
			_tmp16_ = g_hash_table_iter_next (folks_inspect_utils_persona_store_id_iter, &_tmp14_, &_tmp15_);
			_g_free0 (id);
			_tmp17_ = g_strdup (_tmp14_);
			id = _tmp17_;
			_g_object_unref0 (store);
			_tmp18_ = _g_object_ref0 (_tmp15_);
			store = _tmp18_;
			if (!(_tmp16_ == TRUE)) {
				break;
			}
			_tmp19_ = g_str_has_prefix (id, word);
			if (_tmp19_) {
				result = id;
				_g_object_unref0 (store);
				return result;
			}
		}
		_tmp20_ = NULL;
		_g_free0 (folks_inspect_utils_persona_store_id_iter);
		folks_inspect_utils_persona_store_id_iter = _tmp20_;
		_g_object_unref0 (store);
		_g_free0 (id);
	}
	_tmp21_ = NULL;
	_g_object_unref0 (folks_inspect_utils_backend_name_iter);
	folks_inspect_utils_backend_name_iter = _tmp21_;
	result = NULL;
	return result;
}


FolksInspectUtils* folks_inspect_utils_construct (GType object_type) {
	FolksInspectUtils* self = NULL;
	self = (FolksInspectUtils*) g_type_create_instance (object_type);
	return self;
}


FolksInspectUtils* folks_inspect_utils_new (void) {
	return folks_inspect_utils_construct (FOLKS_INSPECT_TYPE_UTILS);
}


static void folks_inspect_value_utils_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void folks_inspect_value_utils_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		folks_inspect_utils_unref (value->data[0].v_pointer);
	}
}


static void folks_inspect_value_utils_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = folks_inspect_utils_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer folks_inspect_value_utils_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* folks_inspect_value_utils_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		FolksInspectUtils* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = folks_inspect_utils_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* folks_inspect_value_utils_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	FolksInspectUtils** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = folks_inspect_utils_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* folks_inspect_param_spec_utils (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	FolksInspectParamSpecUtils* spec;
	g_return_val_if_fail (g_type_is_a (object_type, FOLKS_INSPECT_TYPE_UTILS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer folks_inspect_value_get_utils (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FOLKS_INSPECT_TYPE_UTILS), NULL);
	return value->data[0].v_pointer;
}


void folks_inspect_value_set_utils (GValue* value, gpointer v_object) {
	FolksInspectUtils* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FOLKS_INSPECT_TYPE_UTILS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, FOLKS_INSPECT_TYPE_UTILS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		folks_inspect_utils_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		folks_inspect_utils_unref (old);
	}
}


void folks_inspect_value_take_utils (GValue* value, gpointer v_object) {
	FolksInspectUtils* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FOLKS_INSPECT_TYPE_UTILS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, FOLKS_INSPECT_TYPE_UTILS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		folks_inspect_utils_unref (old);
	}
}


static void folks_inspect_utils_class_init (FolksInspectUtilsClass * klass) {
	gchar* _tmp0_;
	folks_inspect_utils_parent_class = g_type_class_peek_parent (klass);
	FOLKS_INSPECT_UTILS_CLASS (klass)->finalize = folks_inspect_utils_finalize;
	_tmp0_ = g_strdup ("");
	folks_inspect_utils_indentation_string = _tmp0_;
}


static void folks_inspect_utils_instance_init (FolksInspectUtils * self) {
	self->ref_count = 1;
}


static void folks_inspect_utils_finalize (FolksInspectUtils* obj) {
	FolksInspectUtils * self;
	self = FOLKS_INSPECT_UTILS (obj);
}


GType folks_inspect_utils_get_type (void) {
	static volatile gsize folks_inspect_utils_type_id__volatile = 0;
	if (g_once_init_enter (&folks_inspect_utils_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { folks_inspect_value_utils_init, folks_inspect_value_utils_free_value, folks_inspect_value_utils_copy_value, folks_inspect_value_utils_peek_pointer, "p", folks_inspect_value_utils_collect_value, "p", folks_inspect_value_utils_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (FolksInspectUtilsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_inspect_utils_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksInspectUtils), 0, (GInstanceInitFunc) folks_inspect_utils_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType folks_inspect_utils_type_id;
		folks_inspect_utils_type_id = g_type_register_fundamental (g_type_fundamental_next (), "FolksInspectUtils", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&folks_inspect_utils_type_id__volatile, folks_inspect_utils_type_id);
	}
	return folks_inspect_utils_type_id__volatile;
}


gpointer folks_inspect_utils_ref (gpointer instance) {
	FolksInspectUtils* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void folks_inspect_utils_unref (gpointer instance) {
	FolksInspectUtils* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		FOLKS_INSPECT_UTILS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



