/* import.c generated by valac 0.11.5.3-fe751, the Vala compiler
 * generated from import.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Philip Withnall <philip.withnall@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <config.h>
#include <stdio.h>
#include <folks.h>
#include <gio/gio.h>


#define FOLKS_TYPE_IMPORT_TOOL (folks_import_tool_get_type ())
#define FOLKS_IMPORT_TOOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_IMPORT_TOOL, FolksImportTool))
#define FOLKS_IMPORT_TOOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_IMPORT_TOOL, FolksImportToolClass))
#define FOLKS_IS_IMPORT_TOOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_IMPORT_TOOL))
#define FOLKS_IS_IMPORT_TOOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_IMPORT_TOOL))
#define FOLKS_IMPORT_TOOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_IMPORT_TOOL, FolksImportToolClass))

typedef struct _FolksImportTool FolksImportTool;
typedef struct _FolksImportToolClass FolksImportToolClass;
typedef struct _FolksImportToolPrivate FolksImportToolPrivate;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))

#define FOLKS_TYPE_IMPORTER (folks_importer_get_type ())
#define FOLKS_IMPORTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_IMPORTER, FolksImporter))
#define FOLKS_IMPORTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_IMPORTER, FolksImporterClass))
#define FOLKS_IS_IMPORTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_IMPORTER))
#define FOLKS_IS_IMPORTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_IMPORTER))
#define FOLKS_IMPORTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_IMPORTER, FolksImporterClass))

typedef struct _FolksImporter FolksImporter;
typedef struct _FolksImporterClass FolksImporterClass;

#define FOLKS_IMPORTERS_TYPE_PIDGIN (folks_importers_pidgin_get_type ())
#define FOLKS_IMPORTERS_PIDGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_IMPORTERS_TYPE_PIDGIN, FolksImportersPidgin))
#define FOLKS_IMPORTERS_PIDGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_IMPORTERS_TYPE_PIDGIN, FolksImportersPidginClass))
#define FOLKS_IMPORTERS_IS_PIDGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_IMPORTERS_TYPE_PIDGIN))
#define FOLKS_IMPORTERS_IS_PIDGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_IMPORTERS_TYPE_PIDGIN))
#define FOLKS_IMPORTERS_PIDGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_IMPORTERS_TYPE_PIDGIN, FolksImportersPidginClass))

typedef struct _FolksImportersPidgin FolksImportersPidgin;
typedef struct _FolksImportersPidginClass FolksImportersPidginClass;
typedef struct _FolksImportToolImportData FolksImportToolImportData;
typedef struct _FolksImporterPrivate FolksImporterPrivate;

struct _FolksImportTool {
	GObject parent_instance;
	FolksImportToolPrivate * priv;
};

struct _FolksImportToolClass {
	GObjectClass parent_class;
};

struct _Block1Data {
	int _ref_count_;
	GMainLoop* main_loop;
	gboolean success;
};

typedef enum  {
	FOLKS_IMPORT_ERROR_MALFORMED_INPUT
} FolksImportError;
#define FOLKS_IMPORT_ERROR folks_import_error_quark ()
struct _FolksImportToolImportData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	gboolean result;
	FolksBackendStore* _tmp0_;
	FolksBackendStore* backend_store;
	GError * e1;
	const gchar* _tmp1_;
	FolksBackend* _tmp2_;
	FolksBackend* kf_backend;
	const gchar* _tmp3_;
	GError * e2;
	const gchar* _tmp4_;
	FolksPersonaStore* destination_store;
	GHashTable* _tmp5_;
	GList* _tmp6_;
	GList* stores;
	const gchar* _tmp7_;
	FolksPersonaStore* _tmp8_;
	FolksPersonaStore* _tmp9_;
	GError * e3;
	const gchar* _tmp10_;
	FolksImportersPidgin* _tmp11_;
	FolksImporter* importer;
	GError * e;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	GError * _inner_error_;
};

struct _FolksImporter {
	GObject parent_instance;
	FolksImporterPrivate * priv;
};

struct _FolksImporterClass {
	GObjectClass parent_class;
	void (*import) (FolksImporter* self, FolksPersonaStore* destination_store, const gchar* source_filename, GAsyncReadyCallback _callback_, gpointer _user_data_);
	guint (*import_finish) (FolksImporter* self, GAsyncResult* _res_, GError** error);
};


static gpointer folks_import_tool_parent_class = NULL;
static gchar* folks_import_tool_source;
static gchar* folks_import_tool_source = NULL;
static gchar* folks_import_tool_source_filename;
static gchar* folks_import_tool_source_filename = NULL;
static gpointer folks_importer_parent_class = NULL;

GType folks_import_tool_get_type (void) G_GNUC_CONST;
enum  {
	FOLKS_IMPORT_TOOL_DUMMY_PROPERTY
};
gint folks_import_tool_main (gchar** args, int args_length1);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
static void folks_import_tool_import (GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean folks_import_tool_import_finish (GAsyncResult* _res_);
static void _lambda0_ (GObject* o, GAsyncResult* r, Block1Data* _data1_);
static void __lambda0__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void folks_import_tool_import_data_free (gpointer _data);
static gboolean folks_import_tool_import_co (FolksImportToolImportData* data);
static void folks_import_tool_import_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
FolksImportersPidgin* folks_importers_pidgin_new (void);
FolksImportersPidgin* folks_importers_pidgin_construct (GType object_type);
GType folks_importer_get_type (void) G_GNUC_CONST;
GType folks_importers_pidgin_get_type (void) G_GNUC_CONST;
void folks_importer_import (FolksImporter* self, FolksPersonaStore* destination_store, const gchar* source_filename, GAsyncReadyCallback _callback_, gpointer _user_data_);
GQuark folks_import_error_quark (void);
guint folks_importer_import_finish (FolksImporter* self, GAsyncResult* _res_, GError** error);
FolksImportTool* folks_import_tool_new (void);
FolksImportTool* folks_import_tool_construct (GType object_type);
static void folks_import_tool_finalize (GObject* obj);
enum  {
	FOLKS_IMPORTER_DUMMY_PROPERTY
};
FolksImporter* folks_importer_construct (GType object_type);

static const GOptionEntry FOLKS_IMPORT_TOOL_options[3] = {{"source", 's', 0, G_OPTION_ARG_STRING, &folks_import_tool_source, "Source backend name (default: 'pidgin')", "name"}, {"source-filename", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &folks_import_tool_source_filename, "Source filename (default: specific to source backend)", NULL}, {NULL}};

static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (Block1Data* _data1_) {
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_main_loop_unref0 (_data1_->main_loop);
		g_slice_free (Block1Data, _data1_);
	}
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}


static void _lambda0_ (GObject* o, GAsyncResult* r, Block1Data* _data1_) {
	gboolean _tmp0_;
	g_return_if_fail (r != NULL);
	_tmp0_ = folks_import_tool_import_finish (r);
	_data1_->success = _tmp0_;
	g_main_loop_quit (_data1_->main_loop);
}


static void __lambda0__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	_lambda0_ (source_object, res, self);
	block1_data_unref (self);
}


gint folks_import_tool_main (gchar** args, int args_length1) {
	gint result = 0;
	Block1Data* _data1_;
	const gchar* _tmp0_ = NULL;
	GOptionContext* _tmp1_ = NULL;
	GOptionContext* context;
	gboolean _tmp3_ = FALSE;
	FolksIndividualAggregator* _tmp8_ = NULL;
	FolksIndividualAggregator* aggregator;
	FolksIndividualAggregator* _tmp9_;
	GMainLoop* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	GError * _inner_error_ = NULL;
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	bindtextdomain (GETTEXT_PACKAGE, LOCALE_DIR);
	textdomain (GETTEXT_PACKAGE);
	_tmp0_ = _ ("— import meta-contact information to libfolks");
	_tmp1_ = g_option_context_new (_tmp0_);
	context = _tmp1_;
	g_option_context_add_main_entries (context, FOLKS_IMPORT_TOOL_options, "folks");
	g_option_context_parse (context, &args_length1, &args, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_OPTION_ERROR) {
			goto __catch0_g_option_error;
		}
		_g_option_context_free0 (context);
		block1_data_unref (_data1_);
		_data1_ = NULL;
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	goto __finally0;
	__catch0_g_option_error:
	{
		GError * e;
		const gchar* _tmp2_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = _ ("Couldn't parse command line options: %s\n");
		fprintf (stderr, _tmp2_, e->message);
		result = 1;
		_g_error_free0 (e);
		_g_option_context_free0 (context);
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return result;
	}
	__finally0:
	if (_inner_error_ != NULL) {
		_g_option_context_free0 (context);
		block1_data_unref (_data1_);
		_data1_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	if (folks_import_tool_source == NULL) {
		_tmp3_ = TRUE;
	} else {
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		_tmp4_ = string_strip (folks_import_tool_source);
		_tmp5_ = _tmp4_;
		_tmp3_ = g_strcmp0 (_tmp5_, "") == 0;
		_g_free0 (_tmp5_);
	}
	if (_tmp3_) {
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp6_ = g_strdup ("pidgin");
		_tmp7_ = _tmp6_;
		_g_free0 (folks_import_tool_source);
		folks_import_tool_source = _tmp7_;
	}
	_tmp8_ = folks_individual_aggregator_new ();
	aggregator = _tmp8_;
	_tmp9_ = NULL;
	_g_object_unref0 (aggregator);
	aggregator = _tmp9_;
	_tmp10_ = g_main_loop_new (NULL, FALSE);
	_data1_->main_loop = _tmp10_;
	_data1_->success = FALSE;
	folks_import_tool_import (__lambda0__gasync_ready_callback, block1_data_ref (_data1_));
	g_main_loop_run (_data1_->main_loop);
	if (_data1_->success) {
		_tmp11_ = 0;
	} else {
		_tmp11_ = 1;
	}
	result = _tmp11_;
	_g_object_unref0 (aggregator);
	_g_option_context_free0 (context);
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return folks_import_tool_main (argv, argc);
}


static void folks_import_tool_import_data_free (gpointer _data) {
	FolksImportToolImportData* data;
	data = _data;
	g_slice_free (FolksImportToolImportData, data);
}


static void folks_import_tool_import (GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksImportToolImportData* _data_;
	_data_ = g_slice_new0 (FolksImportToolImportData);
	_data_->_async_result = g_simple_async_result_new (g_object_newv (G_TYPE_OBJECT, 0, NULL), _callback_, _user_data_, folks_import_tool_import);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_import_tool_import_data_free);
	folks_import_tool_import_co (_data_);
}


static gboolean folks_import_tool_import_finish (GAsyncResult* _res_) {
	gboolean result;
	FolksImportToolImportData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static void folks_import_tool_import_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksImportToolImportData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	folks_import_tool_import_co (data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean folks_import_tool_import_co (FolksImportToolImportData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		case 5:
		goto _state_5;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = folks_backend_store_dup ();
	data->backend_store = data->_tmp0_;
	data->_state_ = 1;
	folks_backend_store_load_backends (data->backend_store, folks_import_tool_import_ready, data);
	return FALSE;
	_state_1:
	folks_backend_store_load_backends_finish (data->backend_store, data->_res_, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		goto __catch1_g_error;
	}
	goto __finally1;
	__catch1_g_error:
	{
		data->e1 = data->_inner_error_;
		data->_inner_error_ = NULL;
		data->_tmp1_ = NULL;
		data->_tmp1_ = _ ("Couldn't load the backends: %s\n");
		fprintf (stderr, data->_tmp1_, data->e1->message);
		data->result = FALSE;
		_g_error_free0 (data->e1);
		_g_object_unref0 (data->backend_store);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	__finally1:
	if (data->_inner_error_ != NULL) {
		_g_object_unref0 (data->backend_store);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	data->_tmp2_ = NULL;
	data->_tmp2_ = folks_backend_store_get_backend_by_name (data->backend_store, "key-file");
	data->kf_backend = data->_tmp2_;
	if (data->kf_backend == NULL) {
		data->_tmp3_ = NULL;
		data->_tmp3_ = _ ("Couldn't load the 'key-file' backend.\n");
		fprintf (stderr, "%s", data->_tmp3_);
		data->result = FALSE;
		_g_object_unref0 (data->kf_backend);
		_g_object_unref0 (data->backend_store);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->_state_ = 2;
	folks_backend_prepare (data->kf_backend, folks_import_tool_import_ready, data);
	return FALSE;
	_state_2:
	folks_backend_prepare_finish (data->kf_backend, data->_res_, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		goto __catch2_g_error;
	}
	goto __finally2;
	__catch2_g_error:
	{
		data->e2 = data->_inner_error_;
		data->_inner_error_ = NULL;
		data->_tmp4_ = NULL;
		data->_tmp4_ = _ ("Couldn't prepare the 'key-file' backend: %s\n");
		fprintf (stderr, data->_tmp4_, data->e2->message);
		data->result = FALSE;
		_g_error_free0 (data->e2);
		_g_object_unref0 (data->kf_backend);
		_g_object_unref0 (data->backend_store);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	__finally2:
	if (data->_inner_error_ != NULL) {
		_g_object_unref0 (data->kf_backend);
		_g_object_unref0 (data->backend_store);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	data->_tmp5_ = NULL;
	data->_tmp5_ = folks_backend_get_persona_stores (data->kf_backend);
	data->_tmp6_ = NULL;
	data->_tmp6_ = g_hash_table_get_values (data->_tmp5_);
	data->stores = data->_tmp6_;
	if (data->stores == NULL) {
		data->_tmp7_ = NULL;
		data->_tmp7_ = _ ("Couldn't load the 'key-file' backend's persona store.\n");
		fprintf (stderr, "%s", data->_tmp7_);
		data->result = FALSE;
		_g_list_free0 (data->stores);
		_g_object_unref0 (data->destination_store);
		_g_object_unref0 (data->kf_backend);
		_g_object_unref0 (data->backend_store);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->_tmp8_ = _g_object_ref0 ((FolksPersonaStore*) data->stores->data);
	data->_tmp9_ = data->_tmp8_;
	_g_object_unref0 (data->destination_store);
	data->destination_store = data->_tmp9_;
	data->_state_ = 3;
	folks_persona_store_prepare (data->destination_store, folks_import_tool_import_ready, data);
	return FALSE;
	_state_3:
	folks_persona_store_prepare_finish (data->destination_store, data->_res_, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		goto __catch3_g_error;
	}
	goto __finally3;
	__catch3_g_error:
	{
		data->e3 = data->_inner_error_;
		data->_inner_error_ = NULL;
		data->_tmp10_ = NULL;
		data->_tmp10_ = _ ("Couldn't prepare the 'key-file' backend's persona store: %s\n");
		fprintf (stderr, data->_tmp10_, data->e3->message);
		data->result = FALSE;
		_g_error_free0 (data->e3);
		_g_list_free0 (data->stores);
		_g_object_unref0 (data->destination_store);
		_g_object_unref0 (data->kf_backend);
		_g_object_unref0 (data->backend_store);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	__finally3:
	if (data->_inner_error_ != NULL) {
		_g_list_free0 (data->stores);
		_g_object_unref0 (data->destination_store);
		_g_object_unref0 (data->kf_backend);
		_g_object_unref0 (data->backend_store);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	if (g_strcmp0 (folks_import_tool_source, "pidgin") == 0) {
		data->_tmp11_ = NULL;
		data->_tmp11_ = folks_importers_pidgin_new ();
		data->importer = (FolksImporter*) data->_tmp11_;
		data->_state_ = 4;
		folks_importer_import (data->importer, data->destination_store, folks_import_tool_source_filename, folks_import_tool_import_ready, data);
		return FALSE;
		_state_4:
		folks_importer_import_finish (data->importer, data->_res_, &data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			if (data->_inner_error_->domain == FOLKS_IMPORT_ERROR) {
				goto __catch4_folks_import_error;
			}
			_g_object_unref0 (data->importer);
			_g_list_free0 (data->stores);
			_g_object_unref0 (data->destination_store);
			_g_object_unref0 (data->kf_backend);
			_g_object_unref0 (data->backend_store);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
		goto __finally4;
		__catch4_folks_import_error:
		{
			data->e = data->_inner_error_;
			data->_inner_error_ = NULL;
			data->_tmp12_ = NULL;
			data->_tmp12_ = _ ("Error importing personas: %s\n");
			fprintf (stderr, data->_tmp12_, data->e->message);
			data->result = FALSE;
			_g_error_free0 (data->e);
			_g_object_unref0 (data->importer);
			_g_list_free0 (data->stores);
			_g_object_unref0 (data->destination_store);
			_g_object_unref0 (data->kf_backend);
			_g_object_unref0 (data->backend_store);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
		__finally4:
		if (data->_inner_error_ != NULL) {
			_g_object_unref0 (data->importer);
			_g_list_free0 (data->stores);
			_g_object_unref0 (data->destination_store);
			_g_object_unref0 (data->kf_backend);
			_g_object_unref0 (data->backend_store);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
		data->_state_ = 5;
		folks_persona_store_flush (data->destination_store, folks_import_tool_import_ready, data);
		return FALSE;
		_state_5:
		folks_persona_store_flush_finish (data->destination_store, data->_res_);
		data->result = TRUE;
		_g_object_unref0 (data->importer);
		_g_list_free0 (data->stores);
		_g_object_unref0 (data->destination_store);
		_g_object_unref0 (data->kf_backend);
		_g_object_unref0 (data->backend_store);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	} else {
		data->_tmp13_ = NULL;
		data->_tmp13_ = _ ("Unrecognised source backend name '%s'. 'pidgin' is currently the only " \
"supported source backend.\n");
		fprintf (stderr, data->_tmp13_, folks_import_tool_source);
		data->result = FALSE;
		_g_list_free0 (data->stores);
		_g_object_unref0 (data->destination_store);
		_g_object_unref0 (data->kf_backend);
		_g_object_unref0 (data->backend_store);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	_g_list_free0 (data->stores);
	_g_object_unref0 (data->destination_store);
	_g_object_unref0 (data->kf_backend);
	_g_object_unref0 (data->backend_store);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


FolksImportTool* folks_import_tool_construct (GType object_type) {
	FolksImportTool * self = NULL;
	self = (FolksImportTool*) g_object_new (object_type, NULL);
	return self;
}


FolksImportTool* folks_import_tool_new (void) {
	return folks_import_tool_construct (FOLKS_TYPE_IMPORT_TOOL);
}


static void folks_import_tool_class_init (FolksImportToolClass * klass) {
	folks_import_tool_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = folks_import_tool_finalize;
}


static void folks_import_tool_instance_init (FolksImportTool * self) {
}


static void folks_import_tool_finalize (GObject* obj) {
	FolksImportTool * self;
	self = FOLKS_IMPORT_TOOL (obj);
	G_OBJECT_CLASS (folks_import_tool_parent_class)->finalize (obj);
}


GType folks_import_tool_get_type (void) {
	static volatile gsize folks_import_tool_type_id__volatile = 0;
	if (g_once_init_enter (&folks_import_tool_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksImportToolClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_import_tool_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksImportTool), 0, (GInstanceInitFunc) folks_import_tool_instance_init, NULL };
		GType folks_import_tool_type_id;
		folks_import_tool_type_id = g_type_register_static (G_TYPE_OBJECT, "FolksImportTool", &g_define_type_info, 0);
		g_once_init_leave (&folks_import_tool_type_id__volatile, folks_import_tool_type_id);
	}
	return folks_import_tool_type_id__volatile;
}


GQuark folks_import_error_quark (void) {
	return g_quark_from_static_string ("folks_import_error-quark");
}


void folks_importer_import (FolksImporter* self, FolksPersonaStore* destination_store, const gchar* source_filename, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FOLKS_IMPORTER_GET_CLASS (self)->import (self, destination_store, source_filename, _callback_, _user_data_);
}


guint folks_importer_import_finish (FolksImporter* self, GAsyncResult* _res_, GError** error) {
	return FOLKS_IMPORTER_GET_CLASS (self)->import_finish (self, _res_, error);
}


FolksImporter* folks_importer_construct (GType object_type) {
	FolksImporter * self = NULL;
	self = (FolksImporter*) g_object_new (object_type, NULL);
	return self;
}


static void folks_importer_class_init (FolksImporterClass * klass) {
	folks_importer_parent_class = g_type_class_peek_parent (klass);
}


static void folks_importer_instance_init (FolksImporter * self) {
}


GType folks_importer_get_type (void) {
	static volatile gsize folks_importer_type_id__volatile = 0;
	if (g_once_init_enter (&folks_importer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksImporterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_importer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksImporter), 0, (GInstanceInitFunc) folks_importer_instance_init, NULL };
		GType folks_importer_type_id;
		folks_importer_type_id = g_type_register_static (G_TYPE_OBJECT, "FolksImporter", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&folks_importer_type_id__volatile, folks_importer_type_id);
	}
	return folks_importer_type_id__volatile;
}



