/*
 *  Copyright (C) 2000 Helix Code Inc.
 *
 *  Authors: Michael Zucchi <notzed@helixcode.com>
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public License
 *  as published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef _CAMEL_MIME_FILTER_BESTENC_H
#define _CAMEL_MIME_FILTER_BESTENC_H

#include <camel/camel-mime-filter.h>
#include <camel/camel-mime-part.h>
#include <camel/camel-charset-map.h>

#define CAMEL_MIME_FILTER_BESTENC(obj)         CAMEL_CHECK_CAST (obj, camel_mime_filter_bestenc_get_type (), CamelMimeFilterBestenc)
#define CAMEL_MIME_FILTER_BESTENC_CLASS(klass) CAMEL_CHECK_CLASS_CAST (klass, camel_mime_filter_bestenc_get_type (), CamelMimeFilterBestencClass)
#define CAMEL_IS_MIME_FILTER_BESTENC(obj)      CAMEL_CHECK_TYPE (obj, camel_mime_filter_bestenc_get_type ())

typedef struct _CamelMimeFilterBestencClass CamelMimeFilterBestencClass;

enum _CamelBestencRequired {
	CAMEL_BESTENC_GET_ENCODING = 1<<0,
	CAMEL_BESTENC_GET_CHARSET = 1<<1,

	/* do we treat 'lf' as if it were crlf? */
	CAMEL_BESTENC_LF_IS_CRLF = 1<<8,
	/* do we not allow "From " to appear at the start of a line in any part? */
	CAMEL_BESTENC_NO_FROM = 1<<9,
};
typedef enum _CamelBestencRequired CamelBestencRequired;

enum _CamelBestencEncoding {
	CAMEL_BESTENC_7BIT,
	CAMEL_BESTENC_8BIT,
	CAMEL_BESTENC_BINARY,
};
typedef enum _CamelBestencEncoding CamelBestencEncoding;

struct _CamelMimeFilterBestenc {
	CamelMimeFilter parent;

	unsigned int flags;	/* our creation flags, see above */

	unsigned int count0;	/* count of NUL characters */
	unsigned int count8;	/* count of 8 bit characters */
	unsigned int total;	/* total characters read */

	unsigned int lastc;	/* the last character read */
	int crlfnoorder;	/* if crlf's occured where they shouldn't have */

	int startofline;	/* are we at the start of a new line? */

	int fromcount;
	char fromsave[6];	/* save a few characters if we found an \nF near the end of the buffer */
	int hadfrom;		/* did we encounter a "\nFrom " in the data? */

	unsigned int countline;	/* current count of characters on a given line */
	unsigned int maxline;	/* max length of any line */

	CamelCharset charset;	/* used to determine the best charset to use */
};

struct _CamelMimeFilterBestencClass {
	CamelMimeFilterClass parent_class;
};

guint		camel_mime_filter_bestenc_get_type	(void);
CamelMimeFilterBestenc      *camel_mime_filter_bestenc_new	(unsigned int flags);


CamelMimePartEncodingType	camel_mime_filter_bestenc_get_best_encoding(CamelMimeFilterBestenc *f, CamelBestencEncoding required);
const char *		camel_mime_filter_bestenc_get_best_charset(CamelMimeFilterBestenc *f);
void 			camel_mime_filter_bestenc_set_flags(CamelMimeFilterBestenc *f, unsigned int flags);

#endif /* ! _CAMEL_MIME_FILTER_BESTENC_H */
